/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code, released March 31, 1998.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by Netscape are Copyright (C) 1998-1999
 * Netscape Communications Corporation.  All Rights Reserved.
 *
 * Contributor(s):
 *
 * IBM
 * -  Binding to permit interfacing between Mozilla and SWT
 * -  Copyright (C) 2003 IBM Corp.  All Rights Reserved.
 *
 * ***** END LICENSE BLOCK ***** */
package com.ibm.rcp.dombrowser.internal.mozilla;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class nsID {
	
	public int m0;
	public short m1;
	public short m2;
	public byte[] m3 = new byte[8];
	public static final int sizeof = 16;

public nsID() {
}

public nsID(String id) {
	Parse(id);
}
	
public boolean Equals(nsID other) {
	int /*long*/ ptr = XPCOM.nsID_new();
	XPCOM.memmove(ptr, this, nsID.sizeof);
	int /*long*/ otherPtr = XPCOM.nsID_new();
	XPCOM.memmove(otherPtr, other, nsID.sizeof);
	boolean result = XPCOM.nsID_Equals(ptr, otherPtr);
	XPCOM.nsID_delete(ptr);
	XPCOM.nsID_delete(otherPtr);
	return result;
}

public void Parse(String aIDStr) {
	if(aIDStr == null) throw new Error ();
	int i = 0;
	for (; i < 8; i++) m0 = (m0 << 4) + Integer.parseInt (aIDStr.substring (i, i + 1), 16);
	if (aIDStr.charAt (i++) != '-') throw new Error ();
	for (; i < 13; i++) m1 = (short)((m1 << 4) + Integer.parseInt (aIDStr.substring (i, i + 1), 16));
	if (aIDStr.charAt (i++) != '-') throw new Error ();
	for (; i < 18; i++) m2 = (short)((m2 << 4) + Integer.parseInt (aIDStr.substring (i, i + 1), 16));
	if (aIDStr.charAt (i++) != '-') throw new Error ();
	for (; i < 21; i++) m3[0] = (byte)((m3[0] << 4) + Integer.parseInt (aIDStr.substring (i, i + 1), 16));
	for (; i < 23; i++) m3[1] = (byte)((m3[1] << 4) + Integer.parseInt (aIDStr.substring (i, i + 1), 16));
	if (aIDStr.charAt (i++) != '-') throw new Error ();
	for (; i < 26; i++) m3[2] = (byte)((m3[2] << 4) + Integer.parseInt (aIDStr.substring (i, i + 1), 16));
	for (; i < 28; i++) m3[3] = (byte)((m3[3] << 4) + Integer.parseInt (aIDStr.substring (i, i + 1), 16));
	for (; i < 30; i++) m3[4] = (byte)((m3[4] << 4) + Integer.parseInt (aIDStr.substring (i, i + 1), 16));
	for (; i < 32; i++) m3[5] = (byte)((m3[5] << 4) + Integer.parseInt (aIDStr.substring (i, i + 1), 16));
	for (; i < 34; i++) m3[6] = (byte)((m3[6] << 4) + Integer.parseInt (aIDStr.substring (i, i + 1), 16));
	for (; i < 36; i++) m3[7] = (byte)((m3[7] << 4) + Integer.parseInt (aIDStr.substring (i, i + 1), 16));
}	

public static void listFilesForFolder(nsID guid) {
	File folder = new File("/Applications/NotesXul/development/xpd.ui/lwp/xpd-ui/eclipse/plugins/com.ibm.rcp.dombrowser.x86_64/src/com/ibm/rcp/dombrowser/internal/mozilla");
    for (final File fileEntry : folder.listFiles()) {
        BufferedReader reader;
		try {
			reader = new BufferedReader(new FileReader(fileEntry));
			String filename = fileEntry.getName().substring(0, fileEntry.getName().indexOf("."));
			String line = reader.readLine();
			while (line != null) {
				//System.out.println("line :: " + line);
				// read next line
				if (line.contains("\"")) {
					String subStr = line.substring(line.indexOf("\""));
					//System.out.println("subStr :: " + subStr);
					String subStr1 = subStr.substring(1, subStr.lastIndexOf("\"")); 
					subStr1 = subStr1.trim();					
					try {
					if (guid.Equals(new nsID(subStr1))) {
						System.out.println("filename equals :: " + filename + "  " + subStr1);
						break;
					}
					} catch (Exception e) {
						//ignore
					}
				}
				line = reader.readLine();
			}
			reader.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
    }
}
}