/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code, released March 31, 1998.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by Netscape are Copyright (C) 1998-1999
 * Netscape Communications Corporation.  All Rights Reserved.
 *
 * Contributor(s):
 *
 * IBM
 * -  Binding to permit interfacing between Mozilla and SWT
 * -  Copyright (C) 2003, 2010 IBM Corp.  All Rights Reserved.
 *
 * ***** END LICENSE BLOCK ***** */
package com.ibm.rcp.dombrowser.internal.mozilla;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Lock;


public class XPCOM {
	
	public static final String MOZILLA_FIVE_HOME = "MOZILLA_FIVE_HOME"; //$NON-NLS-1$
	public static final String CONTENT_MAYBETEXT = "application/x-vnd.mozilla.maybe-text"; //$NON-NLS-1$
	public static final String CONTENT_MULTIPART = "multipart/x-mixed-replace"; //$NON-NLS-1$
	public static final String HTTPS_PROTOCOL = "https:";  //$NON-NLS-1$
	public static boolean isMacOSX =  "carbon".equals(SWT.getPlatform()) || "cocoa".equals(SWT.getPlatform());
	public static final String DOMEVENT_FOCUS = "focus"; //$NON-NLS-1$
	public static final String DOMEVENT_UNLOAD = "unload"; //$NON-NLS-1$
	public static final String DOMEVENT_MOUSEDOWN = "mousedown"; //$NON-NLS-1$
	public static final String DOMEVENT_MOUSEUP = "mouseup"; //$NON-NLS-1$
	public static final String DOMEVENT_MOUSEMOVE = "mousemove"; //$NON-NLS-1$
	public static final String DOMEVENT_MOUSEDRAG = "draggesture"; //$NON-NLS-1$
	public static final String DOMEVENT_MOUSEWHEEL = "DOMMouseScroll"; //$NON-NLS-1$
	public static final String DOMEVENT_MOUSEOVER = "mouseover"; //$NON-NLS-1$
	public static final String DOMEVENT_MOUSEOUT = "mouseout"; //$NON-NLS-1$
	public static final String DOMEVENT_KEYDOWN = "keydown"; //$NON-NLS-1$
	public static final String DOMEVENT_KEYPRESS = "keypress"; //$NON-NLS-1$
	public static final String DOMEVENT_KEYUP = "keyup"; //$NON-NLS-1$
	
	/* JSAPI constants */
	public static final int JSPROP_ENUMERATE = 0x1;
	public static final int JSPROP_PERMANENT = 0x4;
	public static final int JSPROP_READONLY = 0x2;
	public static final int JS_FALSE = 0x0;
	public static final int JS_TRUE = 0x1;
	
	public static final int SEC_ERROR_EXPIRED_ISSUER_CERTIFICATE = 0x805A1FE2;
	public static final int SEC_ERROR_CA_CERT_INVALID = 0x805A1FDC;
	public static final int SEC_ERROR_EXPIRED_CERTIFICATE = 0x805A1FF5;
	public static final int SEC_ERROR_INADEQUATE_KEY_USAGE = 0x805A1FA6;
	public static final int SEC_ERROR_UNKNOWN_ISSUER = 0x805A1FF3;
	public static final int SEC_ERROR_UNTRUSTED_CERT = 0x805A1FEB;
	public static final int SEC_ERROR_UNTRUSTED_ISSUER = 0x805A1FEC;
	public static final int SSL_ERROR_BAD_CERT_DOMAIN = 0x805A2FF4;
	
	/* CID constants */
	public static final nsID NS_APPSHELL_CID =	new nsID("2d96b3df-c051-11d1-a827-0040959a28c9"); //$NON-NLS-1$
	public static final nsID NS_DOWNLOAD_CID = new nsID("e3fa9D0a-1dd1-11b2-bdef-8c720b597445"); //$NON-NLS-1$
	//changed for xul45
	public static final nsID NS_FILEPICKER_CID = new nsID("54ae32f8-1dd2-11b2-a209-df7c505370f6"); //$NON-NLS-1$//
//	public static final nsID NS_FILEPICKER_CID = new nsID("54ae32f8-1dd2-11b2-a209-df7c505370f8"); //$NON-NLS-1$//
	public static final nsID NS_IOSERVICE_CID =	new nsID("9ac9e770-18bc-11d3-9337-00104ba0fd40"); //$NON-NLS-1$
	public static final nsID NS_INPUTSTREAMCHANNEL_CID = new nsID("6ddb050c-0d04-11d4-986e-00c04fa0cf4a"); //$NON-NLS-1$
	public static final nsID NS_LOADGROUP_CID = new nsID("e1c61582-2a84-11d3-8cce-0060b0fc14a3"); //$NON-NLS-1$
	public static final nsID NS_PROMPTSERVICE_CID = new nsID("a2112d6a-0e28-421f-b46a-25c0b308cbd2"); //$NON-NLS-1$//
	public static final nsID NS_CATEGORYMANAGER_CID = new nsID("16d222a6-1dd2-11b2-b693-f38b02c021b2"); //$NON-NLS-1$
	public static final nsID EXTERNAL_CID = new nsID ("f2c59ad0-bd76-11dd-ad8b-0800200c9a66"); //$NON-NLS-1$
	public static final nsID NS_IWEBBROWSER_CID = new nsID ("cda5863a-aa9c-411e-be49-ea0d525ab4b5"); //$NON-NLS-1$
	public static final nsID NS_HELPERAPPLAUNCHERDIALOG_CID = new nsID("e68578eb-6ec2-4169-ae19-8c6243f0abe1"); //$NON-NLS-1$
	public static final nsID NS_ISCRIPTOBJECTOWNER_IID = new nsID ("8f6bca7e-ce42-11d1-b724-00600891d8c9"); //$NON-NLS-1$
	public static final nsID NS_IXPCONNECT_CID = new nsID ("CB6593E0-F9B2-11d2-BDD6-000064657374"); //$NON-NLS-1$
	public static final nsID NS_IWINDOW_MEDIATOR_CID = new nsID ("79a2b7cc-f05b-4605-bfa0-fac54f27eec8"); //$NON-NLS-1$
	public static final nsID NS_AUTHPROMPTER_CID = new nsID("e2112d6a-0e28-421f-b46a-25c0b308cbd0"); //$NON-NLS-1$
	
	public static final String NS_DOWNLOAD_CONTRACTID = "@mozilla.org/download;1"; //$NON-NLS-1$
	public static final String NS_DOWNLOADMANAGER_CONTRACTID = "@mozilla.org/download-manager;1"; //$NON-NLS-1$
	public static final String NS_DOWNLOADMANAGERUI_CONTRACTID = "@mozilla.org/download-manager-ui;1"; //$NON-NLS-1$
	public static final String NS_FILEPICKER_CONTRACTID = "@mozilla.org/filepicker;1"; //$NON-NLS-1$
	public static final String NS_PROFILE_CONTRACTID = "@mozilla.org/profile/manager;1"; //$NON-NLS-1$
	public static final String NS_MEMORY_CONTRACTID = "@mozilla.org/xpcom/memory-service;1"; //$NON-NLS-1$
	public static final String NS_PREFSERVICE_CONTRACTID = "@mozilla.org/preferences-service;1"; //$NON-NLS-1$
	public static final String NS_PROMPTSERVICE_CONTRACTID = "@mozilla.org/embedcomp/prompt-service;1"; //$NON-NLS-1$
	public static final String NS_WINDOWWATCHER_CONTRACTID = "@mozilla.org/embedcomp/window-watcher;1"; //$NON-NLS-1$
	public static final String NS_COOKIEMANAGER_CONTRACTID = "@mozilla.org/cookiemanager;1"; //$NON-NLS-1$
	public static final String NS_DIRECTORYSERVICE_CONTRACTID = "@mozilla.org/file/directory_service;1"; //$NON-NLS-1$
	public static final String NS_PRINTSETTING_SERVICE_CONTRACTID = "@mozilla.org/gfx/printsettings-service;1";//$NON-NLS-1$
	public static final String NS_HTTPAUTHMANAGER_CONTRACTID = "@mozilla.org/network/http-auth-manager;1"; //$NON-NLS-1$
	public static final String NS_INTERNETCONFIG_SERVICE_CONTRACTID = "@mozilla.org/mac/internet-config-service;1";//$NON-NLS-1$
	public static final String NS_OBSERVER_CONTRACTID = "@mozilla.org/observer-service;1"; //$NON-NLS-1$
	public static final String NS_WEBBROWSERPERSIST_CONTRACTID = "@mozilla.org/embedding/browser/nsWebBrowserPersist;1"; //$NON-NLS-1$
	public static final String NS_IOSERVICE_CONTRACTID = "@mozilla.org/network/io-service;1"; //$NON-NLS-1$
	public static final String NS_DOMSERIALIZER_CONTRACTID = "@mozilla.org/xmlextras/xmlserializer;1"; //$NON-NLS-1$
	public static final String NS_CERTOVERRIDE_CONTRACTID = "@mozilla.org/security/certoverride;1"; //$NON-NLS-1$
	public static final String NS_CERTIFICATEDIALOGS_CONTRACTID = "@mozilla.org/nsCertificateDialogs;1"; //$NON-NLS-1$
	public static final String NS_SCRIPTSECURITYMANAGER_CONTRACTID = "@mozilla.org/scriptsecuritymanager;1";//$NON-NLS-1$
	public static final String NS_CONTEXT_STACK_CONTRACTID = "@mozilla.org/js/xpc/ContextStack;1";//$NON-NLS-1$
	public static final String NS_VARIANT_CONTRACTID = "@mozilla.org/variant;1"; //$NON-NLS-1$
	public static final String EXTERNAL_CONTRACTID = "@eclipse.org/external;1"; //$NON-NLS-1$
	public static final String NS_CONTEXTSTACK_CONTRACTID = "@mozilla.org/js/xpc/ContextStack;1"; //$NON-NLS-1$
	public static final String NS_WEBNAVIGATIONINFO_CONTRACTID = "@mozilla.org/webnavigation-info;1"; //$NON-NLS-1$
	public static final String NS_FOCUSMANAGER_CONTRACTID = "@mozilla.org/focus-manager;1";	//$NON-NLS-1$
	public static final String NS_LOGINMANAGER_CONTRACTID = "@mozilla.org/login-manager;1";	//$NON-NLS-1$
	public static final String NS_LOGININFO_CONTRACTID = "@mozilla.org/login-manager/loginInfo;1";	//$NON-NLS-1$
	public static final String NS_STRINGBUNDLESERVICE_CONTRACTID = "@mozilla.org/intl/stringbundle;1";	//$NON-NLS-1$
	public static final String NS_PREFLOCALIZEDSTRING_CONTRACTID = "@mozilla.org/pref-localizedstring;1";	//$NON-NLS-1$
	public static final String NS_COOKIESERVICE_CONTRACTID = "@mozilla.org/cookieService;1"; //$NON-NLS-1$
	public static final String NS_HELPERAPPLAUNCHERDIALOG_CONTRACTID = "@mozilla.org/helperapplauncherdialog;1"; //$NON-NLS-1$
	public static final String EXECUTE_CONTRACTID = "@eclipse.org/execute;1"; //$NON-NLS-1$
	public static final String NS_MIMEINPUTSTREAM_CONTRACTID = "@mozilla.org/network/mime-input-stream;1"; //$NON-NLS-1$
	public static final String NS_INTERFACEINFOMANAGER_CONTRACTID = "@mozilla.org/xpti/interfaceinfomanager-service;1";
	public static final String NS_AUTHPROMPTER_CONTRACTID = "@mozilla.org/passwordmanager/authpromptfactory;1"; //$NON-NLS-1$
	
	/* XPCOM constants */
	public static final int NS_OK =  0;
	public static final int NS_COMFALSE = 1;
	public static final int NS_BINDING_ABORTED = 0x804b0002;
	public static final int NS_ERROR_BASE = 0xc1f30000;
	public static final int NS_ERROR_NOT_INITIALIZED =  NS_ERROR_BASE + 1;
	public static final int NS_ERROR_ALREADY_INITIALIZED = NS_ERROR_BASE + 2;
	public static final int NS_ERROR_NOT_IMPLEMENTED =  0x80004001;
	public static final int NS_NOINTERFACE =  0x80004002;
	public static final int NS_ERROR_NO_INTERFACE =   NS_NOINTERFACE;
	public static final int NS_ERROR_INVALID_POINTER =  0x80004003;
	public static final int NS_ERROR_NULL_POINTER = NS_ERROR_INVALID_POINTER;
	public static final int NS_ERROR_ABORT = 0x80004004;
	public static final int NS_ERROR_FAILURE = 0x80004005;
	public static final int NS_ERROR_UNEXPECTED = 0x8000ffff;
	public static final int NS_ERROR_OUT_OF_MEMORY = 0x8007000e;
	public static final int NS_ERROR_ILLEGAL_VALUE = 0x80070057;
	public static final int NS_ERROR_INVALID_ARG = NS_ERROR_ILLEGAL_VALUE;
	public static final int NS_ERROR_NO_AGGREGATION = 0x80040110;
	public static final int NS_ERROR_NOT_AVAILABLE = 0x80040111;
	public static final int NS_ERROR_FACTORY_NOT_REGISTERED = 0x80040154;
	public static final int NS_ERROR_FACTORY_REGISTER_AGAIN = 0x80040155;
	public static final int NS_ERROR_FACTORY_NOT_LOADED = 0x800401f8;
	public static final int NS_ERROR_FACTORY_NO_SIGNATURE_SUPPORT = NS_ERROR_BASE + 0x101;
	public static final int NS_ERROR_FACTORY_EXISTS = NS_ERROR_BASE + 0x100;
	public static final int NS_ERROR_HTMLPARSER_UNRESOLVEDDTD = 0x804e03f3;
	public static final int NS_ERROR_FILE_NOT_FOUND = 0x80520012;
	
	public static final Lock lock = new Lock ();
	
	/** @param functionLoad cast=(const nsDynamicFunctionLoad *) */
	public static final native int _XPCOMGlueLoadXULFunctions (int /*long*/ functionLoad);
	public static final int XPCOMGlueLoadXULFunctions (int /*long*/ functionLoad) {
		lock.lock();
		try {
			return _XPCOMGlueLoadXULFunctions(functionLoad);
		} finally {
			lock.unlock();
		}
	}
	
	public static final native int nsDynamicFunctionLoad_sizeof ();	
	/**
	 * @param dest cast=(void *)
	 * @param src cast=(const void *),flags=no_out critical
	 * @param size cast=(size_t)
	 */
public static final native void memmove (int /*long*/ dest, nsDynamicFunctionLoad src, int /*long*/ size);
public static final native int _Call(int /*long*/ ptr);

public static final int Call(int /*long*/ ptr) {
	lock.lock();
	try {
		return _Call(ptr);
	} finally {
		lock.unlock();
	}
}
/** @method flags=no_gen */
public static final native boolean _NS_Free(byte[] mozillaPath, int /*long*/ aPtr);
public static final boolean NS_Free(byte[] mozillaPath, int /*long*/ aPtr) {
	lock.lock();
	try {
		return _NS_Free(mozillaPath, aPtr);
	} finally {
		lock.unlock();
	}
}
/** @method flags=no_gen */
public static final native int /*long*/ _JS_NewObject(byte[] mozillaPath, int /*long*/ cx, int /*long*/ clasp, int /*long*/ proto, int /*long*/ parent);
public static final int /*long*/ JS_NewObject(byte[] mozillaPath, int /*long*/ cx, int /*long*/ clasp, int /*long*/ proto, int /*long*/ parent) {
	lock.lock();
	try {
		return _JS_NewObject(mozillaPath, cx, clasp, proto, parent);
	} finally {
		lock.unlock();
	}
}
/** @method flags=no_gen */
public static final native int /*long*/ CALLBACK_JSNative(int /*long*/ func);

/** @method flags=no_gen */
public static final native int /*long*/ _JS_DefineFunction(byte[] mozillaPath, int /*long*/ cx, int /*long*/ obj, byte[] name, int /*long*/ call, int nargs, int flags);
public static final int /*long*/ JS_DefineFunction(byte[] mozillaPath, int /*long*/ cx, int /*long*/ obj, byte[] name, int /*long*/ call, int nargs, int flags) {
	lock.lock();
	try {
		return _JS_DefineFunction(mozillaPath, cx, obj, name, call, nargs, flags);
	} finally {
		lock.unlock();
	}
}
public static final native void memmove(nsID dest, int /*long*/ src, int nbytes);
public static final native void memmove(int /*long*/ dest, nsID src, int nbytes);
public static final native void memmove(int /*long*/ dest, int[] src, int nbytes);
public static final native void memmove(int /*long*/ dest, long[] src, int nbytes);
public static final native void memmove(long[] dest, int /*long*/ src, int nbytes);
public static final native void memmove(int[] dest, int /*long*/ src, int nbytes);
public static final native void memmove(byte[] dest, int /*long*/ src, int nbytes);
public static final native void memmove(char[] dest, int /*long*/ src, int nbytes);
public static final native void memmove(int /*long*/ dest, byte[] src, int nbytes);
public static final native void memmove(int /*long*/ dest, char[] src, int nbytes);
public static final native void memmove(byte[] dest, char[] src, int nbytes);
public static final native int NS_GetComponentManager(int /*long*/[] result);
public static final native int NS_GetServiceManager(int /*long*/[] result);
public static final native int NS_InitEmbedding(int /*long*/ aMozBinDirectory, int /*long*/ aAppFileLocProvider);
public static final native int NS_InitXPCOM2(int /*long*/ result, int /*long*/ binDirectory, int /*long*/ appFileLocationProvider);
public static final native int NS_NewLocalFile(int /*long*/ path, boolean followLinks, int /*long*/[] result);
public static final native int NS_TermEmbedding();
public static final native int strlen_PRUnichar(int /*long*/ s);
public static final native int /*long*/ nsEmbedCString_new();
public static final native int /*long*/ nsEmbedCString_new(byte[] aString, int length);
public static final native void nsEmbedCString_delete(int /*long*/ ptr);
public static final native int nsEmbedCString_Length(int /*long*/ ptr);
public static final native int /*long*/ nsEmbedCString_get(int /*long*/ ptr);
public static final native void nsID_delete(int /*long*/ ptr);
public static final native int /*long*/ nsID_new();
public static final native boolean nsID_Equals(int /*long*/ ptr, int /*long*/ other);
public static final native int /*long*/ nsEmbedString_new();
public static final native int /*long*/ nsEmbedString_new(char[] aString);
public static final native void nsEmbedString_delete(int /*long*/ ptr);
public static final native int nsEmbedString_Length(int /*long*/ ptr);
public static final native int /*long*/ nsEmbedString_get(int /*long*/ ptr);
public static final native void free(int /*long*/ ptr);
public static final native void nsfree(int /*long*/ ptr);
public static final native int /*long*/ malloc(int Length);
public static final native int strlen(int /*long*/ s);
public static final native int XPCOMGlueStartup(byte[] place);
public static final native int XPCOMGlueShutdown();

public static final native int /*long*/ Call(int /*long*/ ptr, int /*long*/ aInStream, int /*long*/ aClosure, byte[] aFromSegment, int aToOffset, int aCount, int[] aWriteCount);
// for xul 10.0
/**
 * @param ptr cast=(SWT_XREInitEmbedding)
 * @param aLibXULDirectory cast=(nsILocalFile *)
 * @param aAppDirectory cast=(nsILocalFile *)
 * @param aAppDirProvider cast=(nsIDirectoryServiceProvider *)
 */
public static final native int _Call(int /*long*/ ptr, int /*long*/ aLibXULDirectory, int /*long*/ aAppDirectory, int /*long*/ aAppDirProvider);
public static final int Call(int /*long*/ ptr, int /*long*/ aLibXULDirectory, int /*long*/ aAppDirectory, int /*long*/ aAppDirProvider) {
	lock.lock();
	try {
		return _Call(ptr, aLibXULDirectory, aAppDirectory, aAppDirProvider);
	} finally {
		lock.unlock();
	}
}

//add for xul 10.0
/**
 * @param ptr cast=(XRE_AddManifestLocation)
 * @param aLocationType cast=(enum NSLocationType{NS_COMPONENT_LOCATION, NS_SKIN_LOCATION};)
 * @param aLocation cast=(nsILocalFile *)
 */
public static final native int _Call(int /*long*/ ptr, int aLocationType, int /*long*/ aLocation);
public static final int Call(int /*long*/ ptr, int aLocationType, int /*long*/ aLocation) {
	lock.lock();
	try{
		return _Call(ptr, aLocationType, aLocation);
	} finally {
		lock.unlock();
	}
}

//come from xpcomex.cpp
/* nsDirectoryServiceDefs constants */
public static final String NS_GRE_DIR = "GreD"; //$NON-NLS-1$
public static final String NS_GRE_COMPONENT_DIR = "GreComsD"; //$NON-NLS-1$
public static final String NS_APP_PLUGINS_DIR_LIST = "APluginsDL"; //$NON-NLS-1$
public static final String NS_APP_USER_PROFILE_50_DIR = "ProfD"; //$NON-NLS-1$
public static final String NS_APP_USER_PROFILE_LOCAL_50_DIR = "ProfLD"; //$NON-NLS-1$
public static final String NS_APP_PERMISSION_PARENT_DIR = "permissionDBPDir"; //$NON-NLS-1$
public static final String PLUGINS_DIR_NAME = "plugins"; //$NON-NLS-1$
public static final String COMPONENTS_DIR_NAME = "components"; //$NON-NLS-1$
public static final String NS_XPCOM_INIT_CURRENT_PROCESS_DIR = "MozBinD"; //$NON-NLS-1$
public static final String NS_XPCOM_COMPONENT_DIR = "ComsD"; //$NON-NLS-1$
public static final String NS_OS_CURRENT_PROCESS_DIR = "CurProcD"; //$NON-NLS-1$
public static final String NS_APP_PLUGIN_SCAN_QUICKTIME = "plugin.scan.Quicktime"; //$NON-NLS-1$
public static final String NS_APP_PREF_DEFAULTS_50_DIR = "PrfDef"; //$NON-NLS-1$
public static final String NS_APP_USER_APP_DATA_DIR = "UAppData";


public static final String NS_APP_CACHE_PARENT_DIR = "cachePDir"; //$NON-NLS-1$
public static final String NS_APP_HISTORY_50_FILE = "UHist"; //$NON-NLS-1$
public static final String NS_APP_LOCALSTORE_50_FILE = "LclSt"; //$NON-NLS-1$
public static final String NS_APP_PREFS_50_DIR = "PrefD"; //$NON-NLS-1$
public static final String NS_APP_PREFS_50_FILE = "PrefF"; //$NON-NLS-1$
public static final String NS_APP_USER_CHROME_DIR = "UChrm"; //$NON-NLS-1$
public static final String NS_APP_USER_MIMETYPES_50_FILE = "UMimTyp"; //$NON-NLS-1$
public static final String NS_OS_HOME_DIR = "Home"; //$NON-NLS-1$
public static final String NS_OS_TEMP_DIR = "TmpD"; //$NON-NLS-1$
public static final String NS_XPCOM_CURRENT_PROCESS_DIR = "XCurProcD"; //$NON-NLS-1$
public static final String NS_APP_CHROME_DIRS = "ChromeML";//$NON-NLS-1$

public static final String NS_XPCOM_COMPONENT_REGISTRY_FILE = "ComRegF"; //$NON-NLS-1$
public static final String NS_XPCOM_XPTI_REGISTRY_FILE = "XptiRegF"; //$NON-NLS-1$

public static final String NS_TRANSFER_CONTRACTID = "@mozilla.org/transfer;1";
public static final nsID NS_CONTEXTSTACK_CID =	new nsID("ff8c4d10-3194-11d3-9885-006008962422"); //$NON-NLS-1$
public static final nsID NS_HTTPPROTOCOLHANDLER_CID =	new nsID("4f47e42e-4d23-4dd3-bfda-eb29255e9ea3"); //$NON-NLS-1$
public static final nsID NS_ISECURITYCHECKEDCOMPONENT_IID = new nsID ("0dad9e8c-a12d-4dcb-9a6f-7d09839356e1"); //$NON-NLS-1$

/* nsDirectoryServiceDefs constants */
public static final String NS_APP_APPLICATION_REGISTRY_DIR = "AppRegD"; //$NON-NLS-1$

public static final native int NS_NewProfileDirServiceProvider(boolean aNotifyObservers, int[] aProvider);
public static final native int SetProfileDir(int /*long*/ aProvider, int /*long*/ aProfileDir);
public static final native int Register(int /*long*/ aProvider);

public static final native int /*long*/ nsCString_new(byte[] aString, int length);
public static final native void nsCString_delete(int /*long*/ ptr);
public static final native int /*long*/ nsCString_new();
public static final native int nsCString_Length(int /*long*/ ptr);
public static final native int /*long*/ nsCString_get(int /*long*/ ptr);

public static final native int nsIScriptGlobalObject_EnsureScriptEnvironment(int /*long*/ ptr, int lang);
public static final native int /*long*/ nsIScriptGlobalObject_GetScriptGlobal(int /*long*/ ptr, int lang);
public static final native int /*long*/ nsIScriptGlobalObject_GetScriptContext(int /*long*/ ptr, int lang);
public static final native int /*long*/ nsIScriptContext_GetNativeContext(int /*long*/ ptr);
public static final native int JS_EvaluateUCScriptForPrincipals(byte[] mozillaPath, int /*long*/ cx, int /*long*/ obj, int /*long*/ principals, char[] chars, int length, byte[] filename, int lineno, int /*long*/[] retVal);
public static final native int /*long*/ nsIScriptGlobalObject_GetScopeObject(int /*long*/ ptr);
public static final native int /*long*/ _JS_GetGlobalObject(byte[] mozillaPath, int /*long*/ cx);	
public static final int /*long*/ JS_GetGlobalObject(byte[] mozillaPath, int /*long*/ cx) {
	lock.lock();
	try {
		return _JS_GetGlobalObject(mozillaPath, cx);
	} finally {
		lock.unlock();
	}
}

/**
 * @method flags=cpp
 * @param ptr cast=(nsIMemory *)
 * @param size cast=(size_t)
 */
public static final native int /*long*/ _nsIMemory_Alloc(int /*long*/ ptr, int size);
public static final int /*long*/ nsIMemory_Alloc(int /*long*/ ptr, int size) {
	lock.lock();
	try {
		return _nsIMemory_Alloc(ptr, size);
	} finally {
		lock.unlock();
	}
}

/**
 * @method flags=cpp
 * @param ptr1 cast=(nsIMemory *)
 * @param ptr2 cast=(void *)
 * @param size cast=(size_t)
 */
public static final native int /*long*/ _nsIMemory_Realloc(int /*long*/ ptr1, int /*long*/ ptr2, int size);
public static final int /*long*/ nsIMemory_Realloc(int /*long*/ ptr1, int /*long*/ ptr2, int size) {
	lock.lock();
	try {
		return _nsIMemory_Realloc(ptr1, ptr2, size);
	} finally {
		lock.unlock();
	}
}

static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, char[] arg0);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, float arg0);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, float[] arg0);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int arg0);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int[] arg0);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, long arg0);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, long[] arg0);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, short[] arg0);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int arg0, int arg1);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int arg0, int[] arg1);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int arg0, long[] arg1);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, long arg0, int[] arg1);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, long arg0, long[] arg1);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, byte[] arg0, int[] arg1);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, byte[] arg0, long[] arg1);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, byte[] arg0, long arg1);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, byte[] arg0, int arg1);
//static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, long arg0, long arg1);///duplicate
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, long arg0, int arg1);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, nsID arg1);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int arg0, char[] arg1);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/arg0, char[] arg1, int arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int[] arg0, int[] arg1);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int[] arg0, long[] arg1);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, nsID arg0, int /*long*/ arg1);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, nsID arg0, int[] arg1);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, nsID arg0, long[] arg1);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, char[] arg0, char[] arg1);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/[] arg0, int /*long*/[] arg1, int /*long*/[] arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int[] arg0, long[] arg1, int /*long*/[] arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, byte[] arg0, int arg1, int[] arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, byte[] arg0, nsID arg1, int[] arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, byte[] arg0, nsID arg1, long[] arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, char[] arg0, int /*long*/ arg1, int[] arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, char[] arg0, int /*long*/ arg1, long[] arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, char[] arg1, char[] arg2);

static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int arg0, int arg1, int arg2);
//static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int arg0, long arg1, long arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int arg0, int arg1, long arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, long arg0, long arg1, long arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, long arg0, long arg1, int arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, long arg0, int arg1, int arg2);

static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int arg0, int arg1, int[] arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int arg0, int arg1, long[] arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, long arg0, long arg1, long[] arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, long arg0, long arg1, int[] arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int arg0, long arg1, int[] arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, long arg0, int arg1, int[] arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, long arg0, int arg1, long[] arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, nsID arg1, int /*long*/[] arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int arg0, int arg1, char[] arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, nsID arg0, nsID arg1, int[] arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, nsID arg0, nsID arg1, long[] arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, byte[] arg0, int /*long*/ arg1, nsID arg2, int /*long*/[] arg3);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, byte[] arg1, int /*long*/ arg2, int /*long*/[] arg3);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, char[] arg1, char[] arg2, int[] arg3);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, int /*long*/ arg1, int /*long*/ arg2, char[] arg3);
//static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, int /*long*/ arg1, int arg2, int arg3);
//static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, int /*long*/ arg1, long arg2, int arg3);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, int /*long*/ arg1, long arg2, long arg3);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, int arg1, int arg2, long arg3);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, long arg1, int arg2, long arg3);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, int arg1, int arg2, int[] arg3);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, long arg1, long arg2, int[] arg3);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, long arg1, int arg2, long[] arg3);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, long arg1, long arg2, long[] arg3);

static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int[] arg0, int[] arg1, int[] arg2, int[] arg3);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, nsID arg0, byte[] arg1, byte[] arg2, int /*long*/ arg3);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, nsID arg0, int /*long*/ arg1, nsID arg2, int /*long*/[] arg3);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, char[] arg0, int arg1, int /*long*/ arg2, int /*long*/ arg3, int /*long*/ arg4);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, long arg0, long arg1, long arg2, long arg3, long arg4);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int arg0, int arg1, int arg2, int arg3, int arg4);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int arg0, int[] arg1, int[] arg2, int[] arg3, int[] arg4);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, byte[] arg1, byte[] arg2, byte[] arg3, int /*long*/ arg4, int /*long*/[] arg5);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, int /*long*/ arg1, char[] arg2, int /*long*/ arg3, long arg4, int /*long*/ arg5);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, int /*long*/ arg1, int arg2, int arg3, int arg4, int arg5);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, nsID arg0, byte[] arg1, byte[] arg2, int /*long*/ arg3, byte[] arg4, byte[] arg5);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, byte[] arg0);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, byte[] arg0, byte[] arg1, int[] arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, byte[] arg0, byte[] arg1, long[] arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, byte[] arg0, byte[] arg1);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, byte[] arg0, int[] arg1, int[] arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, byte[] arg0, int[] arg1, long[] arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, byte[] arg0, long[] arg1, int[] arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, byte[] arg0, nsID arg1, int /*long*/ arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int arg0, byte[] arg1);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, long arg0, byte[] arg1);
//static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, int /*long*/ arg1, long arg2, long arg3, long arg4, long arg5);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int arg0, int arg1, byte[] arg2, int arg3);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int arg0, int arg1, int arg2, byte[] arg3, byte[] arg4, int arg5);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/arg0, int /*long*/arg1, int /*long*/arg2, int /*long*/arg3, byte[] arg4, int /*long*/arg5);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/arg0, int /*long*/arg1, int /*long*/arg2, byte[] arg3, int arg4, int arg5);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, byte[] arg0, int /*long*/arg1, int /*long*/arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, short arg0, float arg1);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, short arg0, float[] arg1);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/arg0, short[] arg1);

static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/arg0, int arg1, int arg2, int arg3, int /*long*/[] arg4);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/arg0, long arg1, int arg2, int arg3, long[] arg4);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/arg0, long arg1, long arg2, long arg3, int /*long*/[] arg4);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/arg0, int arg1, long arg2, int arg3, int /*long*/[] arg4);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/arg0, long arg1, int arg2, int arg3, int[] arg4);

static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, short arg0, int /*long*/arg1, short[] arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/arg0, char[] arg1, int[] arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/arg0, char[] arg1, long[] arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, double[] arg0);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, double arg0);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, short arg0, int arg1);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, short arg0, long arg1);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, char[] arg0, int arg1);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, char[] arg0, long arg1);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, int /*long*/ arg1, int arg2, int arg3, long arg4, int /*long*/ arg5, int /*long*/ arg6);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, char[] arg0, int /*long*/ arg1, int arg2, int arg3, long arg4, int /*long*/ arg5, int /*long*/ arg6);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, int /*long*/ arg1, long arg2, long arg3, long arg4, long arg5, long arg6);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/arg0, int /*long*/ arg1, int arg2, int /*long*/ arg3, int /*long*/ arg4, int /*long*/ arg5, int /*long*/ arg6, int /*long*/ arg7, int /*long*/ arg8);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/arg0, int /*long*/ arg1, long arg2, int /*long*/ arg3, int /*long*/ arg4, int /*long*/ arg5, int /*long*/ arg6, int /*long*/ arg7, int /*long*/ arg8);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/arg0, int /*long*/ arg1, long arg2, int arg3, int /*long*/ arg4, int arg5, int arg6, long arg7, long arg8);

static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, byte[] arg1, int arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, byte[] arg1, char[] arg2);

//Added since xulrunner 1.9
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, char[] arg1, long arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, byte[] arg0,  nsID[] arg1);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, short arg0, int /*long*/ arg1, int /*long*/ arg2, int /*long*/ arg3, int /*long*/arg4, long arg5, int /*long*/arg6, int /*long*/arg7, int /*long*/[] arg8);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, int /*long*/ arg1, byte[] arg2, int[] arg3);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, double[] arg0, double[] arg1);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, int arg1, int[] arg2, int[] arg3);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, int arg1, long[] arg2, long[] arg3);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, long arg1, int[] arg2, int[] arg3);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, int arg1, long[] arg2, int[] arg3);

static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int arg0, int arg1,int arg2, int arg3, int arg4, int arg5, int[] arg6,int[] arg7, int[] arg8) ;

static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, byte[] arg0, long arg1, int[] arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, long arg0, byte[] arg1, long arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int arg0, byte[] arg1, short arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, long arg0, byte[] arg1, short arg2);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int arg0, int arg1, byte[] arg2, byte[] arg3);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, long arg0, long arg1, byte[] arg2, byte[] arg3);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, long arg0, long arg1, byte[] arg2, long arg3);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, short[] arg0, int arg1, int[] arg2, int[] arg3);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, short[] arg0, long arg1, int[] arg2, long[] arg3);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int arg0, int arg1, byte[] arg2, int arg3, int arg4);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, long arg0, long arg1, byte[] arg2, long arg3, int arg4);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int arg0, nsID arg1, int arg2, int arg3, int[] arg4);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, long arg0, nsID arg1, long arg2, long arg3, long[] arg4);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int[] arg0, int[] arg1, int[] arg2, int[] arg3, int[] arg4, int[] arg5);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, long[] arg0, long[] arg1, long[] arg2, long[] arg3, long[] arg4, int[] arg5);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int arg0, int arg1, int arg2, int arg3, int arg4, int[] arg5);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, long arg0, long arg1, long arg2, long arg3, long arg4, long[] arg5);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, long arg0, long arg1, long arg2, byte[] arg3, byte[] arg4, long arg5);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int[] arg7);
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/arg0, long arg1, long arg2, long arg3, long arg4, long arg5, long arg6, long[] arg7);

//add for xul 1.9, specific to some changes from boolean to int
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, byte[] arg0, int /*long*/ arg1, int arg2, int /*long*/[] arg3);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, byte[] arg0, byte[] arg1, byte[] arg2, int arg3, int arg4, int /*long*/[] arg5);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, byte[]  arg0, byte[] arg1, int arg2);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/arg0, int arg1, int /*long*/arg2, int[] arg3, int[] arg4, int[] arg5);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/arg0, int arg1, int /*long*/arg2, int /*long*/arg3, int[] arg4, int[] arg5, int[] arg6);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/arg0, int /*long*/arg1, int /*long*/arg2, int arg3, char[] arg4, byte[] arg5, int /*long*/arg6, int /*long*/arg7, int arg8, int /*long*/arg9, int arg10, int /*long*/[] arg11, int /*long*/[] arg12);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/arg0, int arg1, int arg2, int /*long*/arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9);		
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/arg0, int arg1, int arg2, int /*long*/arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10, int arg11, int arg12, short arg13, int /*long*/arg14);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/arg0, int arg1, int arg2, int /*long*/arg3, int /*long*/arg4, int /*long*/arg5, int /*long*/arg6, short arg7);		
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/arg0, int /*long*/arg1, char[] arg2, char[] arg3, int arg4, int /*long*/[] arg5);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int arg0, byte[] arg1, int[] arg2);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, byte[] arg0, short[] arg1);		
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, int /*long*/ arg1, int /*long*/ arg2, int /*long*/ arg3, int arg4, int /*long*/[] arg5, int /*long*/[] arg6, int[] arg7);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, char[] arg0, char[] arg1, char[] arg2, int arg3);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, char[] arg0, int[] arg1);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, char[] arg0, long[] arg1);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, char[] arg0, char[] arg1, char[] arg2, int[] arg3);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, char[] arg0, char[] arg1, int[] arg2);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, char[] arg0, char[] arg1, char[] arg2, int[] arg3, int[] arg4);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, char[] arg0, char[] arg1, int arg2, char[] arg3, char[] arg4, char[] arg5, char[] arg6, int[] arg7, int[] arg8);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, char[] arg0, char[] arg1, int /*long*/[] arg2, char[] arg3, int[] arg4, int[] arg5);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, char[] arg0, char[] arg1, int /*long*/[] arg2, int /*long*/[] arg3, char[] arg4, int[] arg5, int[] arg6);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, char[] arg0, char[] arg1, int arg2, char[] arg3, int[] arg4, int[] arg5);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, char[] arg1, char[] arg2, char[] arg3, int[] arg4);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, char[] arg1, char[] arg2, char[] arg3, int[] arg4, int[] arg5);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, char[] arg1, char[] arg2, int arg3, char[] arg4, char[] arg5, char[] arg6, char[] arg7, int[] arg8, int[] arg9);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, char[] arg1, char[] arg2, int /*long*/[] arg3, char[] arg4, int[] arg5, int[] arg6);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, char[] arg1, char[] arg2, int /*long*/[] arg3, int /*long*/[] arg4, char[] arg5, int[] arg6, int[] arg7);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/ arg0, char[] arg1, char[] arg2, int arg3, char[] arg4, int[] arg5, int[] arg6);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/arg0, int /*long*/arg1, int arg2, int /*long*/arg3, char[] arg4, int[] arg5, int[] arg6);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/arg0, int /*long*/arg1, int /*long*/arg2, int /*long*/arg3, int arg4, int /*long*/arg5, char[] arg6, int[] arg7, int /*long*/[] arg8);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int arg0, int[] arg1, int[] arg2);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/arg0, byte[] arg1, short[] arg2);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, byte[] arg0, int arg1, int /*long*/[] arg2, int[] arg3);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, byte[] arg0, int arg1, int /*long*/arg2, int /*long*/[] arg3, int[] arg4);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/arg0, int arg1, int arg2, int /*long*/arg3, int[] arg4, int /*long*/[] arg5);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int arg0, int[] arg1, int[] arg2, int /*long*/[] arg3); 
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int arg0, int[] arg1, int /*long*/arg2);

// added for xul1.9.2, specific to BrowserFunction nsIWritableVariant.java
static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, nsID arg0);

// added for xul 10.0
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, float arg0, float arg1, int /*long*/[] arg2);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int /*long*/arg0, int arg1, int arg2, int /*long*/arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10, int arg11, int arg12, short arg13, int /*long*/arg14, float arg15, short art16);

//public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int[] arg0, int arg1, int arg2, int arg3, int[] arg4);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int[] arg0, int /*long*/ arg1, int /*long*/[] arg2);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int arg0, char[] arg1, int arg2, int /*long*/[] arg3);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, char[] arg0, char[] arg1, int arg2, int /*long*/[] arg3);

//added for nsILoginManager
public static final native int nsILoginManagerGetAllLogins(int fnNumber, int /*long*/ ppVtbl, int[] arg0, int /*long*/[] arg1);
public static final native int nsILoginManagerGetAllDisabledHosts(int fnNumber, int /*long*/ ppVtbl, int[] arg0, int /*long*/[] arg1);
public static final native int nsILoginManagerFindLogins(int fnNumber, int /*long*/ ppVtbl, int[] arg0, int /*long*/ arg1, int /*long*/ arg2, int /*long*/arg3, int /*long*/[] arg4);
public static final native int nsILoginManagerSearchLogins(int fnNumber, int /*long*/ ppVtbl, int[] arg0, int /*long*/ arg1, int /*long*/[] arg2);
//added for xul 45.0
public static final native int VtblCall(int fnNumber, int /*long*/ address, byte[] aSignature, int aSignatureLen, byte[] plaintext,
		int plaintextLen, int[] errorCode, int /*long*/[] retVal) ;
public static final native int VtblCall(int i, int /*long*/ address, byte[] aHostname, int /*long*/ evalTime, long[] aPinArray,
		int /*long*/[] aIncludeSubdomains, int[] retVal);
public static final native int VtblCall(int fnNumber, int /*long*/ address, byte[] aHost, int aIncludeSubdomains, int aMaxAge, int aPinCount,
		byte[] aSha256Pins, int[] retVal);
public static final native int VtblCall(int fnNumber, int /*long*/ address, byte[] aFromDataFlavor, int /*long*/ aFromData, int aDataLen,
		byte[] aToDataFlavor, int /*long*/[] aToData, int[] aDataToLen);
public static final native int VtblCall(int i, int /*long*/ address, int aFamily, byte[] aHost, int aPort, byte[] aProxyHost, int aProxyPort,
		int aFlags, int /*long*/[] aFileDesc, int /*long*/[] aSecurityInfo) ;
public static final native int VtblCall(int i, int /*long*/ address, byte[] aStr, byte[] aExpr, byte[] aFile, int aLine) ;
public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ stream, byte[] charset, byte[] contentType);
public static final native int VtblCall(int fnNumber, int /*long*/ address, char[] locale, int dateFormatSelector, int year, int month,
		int day, int /*long*/[] retVal);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ ctx, char[] selectedNickname, int certUsage, int allowInvalid,
		int allowDuplicateNicknames, int[] canceled, int /*long*/[] retVal) ;
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ beginNode, int /*long*/ beginOffset, long endNode, int endOffset,
		int allowAdjacent, int[] resultCount, int /*long*/[] results);
//public static final native int VtblCall(int i, int /*long*/ address, byte[] forString, int ignoreCase, int[] found, int[] offsetSearchedTo) ;
public static final native int VtblCall(int i, int /*long*/ address, byte[] serverinfo, int serverinfoLen, int[] hostnamePos,
		int[] hostnameLen, int[] port) ;
public static final native int VtblCall(int i, int /*long*/ address, byte[] authority, int authorityLen, int[] usernamePos, int[] usernameLen,
		int[] passwordPos, int[] passwordLen, int[] hostnamePos, int[] hostnameLen, int[] port) ;
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aTable, int aRowIndex, int aColIndex, int /*long*/[] aCell,
		int[] aStartRowIndex, int[] aStartColIndex, int[] aRowSpan, int[] aColSpan, int[] aActualRowSpan,
		int[] aActualColSpan, int[] aIsSelected);
public static final native int VtblCall(int i, int /*long*/ address, byte[] spec, int specLen, int[] schemePos, int[] schemeLen,
		int[] authorityPos, int[] authorityLen, int[] pathPos, int[] pathLen);
public static final native int VtblCall(int i, int /*long*/ address, int aDisplayWidth, int aDisplayHeight, double[] aDefaultZoom,
		int[] aAllowZoom, double[] aMinZoom, double[] aMaxZoom, int[] aWidth, int[] aHeight, int[] aAutoSize);
public static final native int VtblCall(int i, int /*long*/ address, byte[] userinfo, int userinfoLen, int[] usernamePos, int[] usernameLen,
		int[] passwordPos, int[] passwordLen) ;
public static final native int VtblCall(int i, int /*long*/ address, char[] word, int length, int offset, int[] begin, int[] end) ;
//public static final native int VtblCall(int i, int /*long*/ address, byte[] certDER, int length, int /*long*/[] retVal) ;
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ uri, byte[] type, int[] retVal) ;
public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ parent, int offset, short[] retVal);
public static final native int VtblCall(int fnNumber, int /*long*/ address, byte[] aFromType, byte[] aToType, int /*long*/ aListener, int /*long*/ aContext,
		int /*long*/[] retVal) ;
public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aParamValue, byte[] aCharset, byte[] aDefaultCharset,
		int aOverrideCharset, int /*long*/ retVal);
public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aFromStream, byte[] aFromType, byte[] aToType, int /*long*/ aCtxt,
		int /*long*/[] retVal);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ stream, byte[] charset, int contentLength, byte[] contentType,
		int /*long*/[] retVal);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aChannel, byte[] aChallenge, int aProxyAuth, int /*long*/[] aSessionState,
		int /*long*/[] aContinuationState, int[] aInvalidatesIdentity);
public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ parent, byte[] dialogURL, int /*long*/ parameters,
		int /*long*/ openDialogObserver, int[] notifyOnOpen);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ source, byte[] filename, int /*long*/ cx, int /*long*/ sandbox,
//		int /*long*/[] retVal) ;
public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ ctx, char[] tokenNameList, int count, int /*long*/[] tokenName,
		int /*long*/[] canceled);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ ctx, char[] tokenNameList, int count, int /*long*/[] tokenName,
//		int[] canceled) ;
public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aInToken, int aInTokenLength, int confidential,
		int /*long*/[] aOutToken, int[] aOutTokenLength);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aContentType, int aIsContentPreferred, int /*long*/ aRequest,
//		int /*long*/[] aContentHandler, int[] retVal);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, byte[] aFlavorList, int aLength, int aWhichClipboard,
//		int[] retVal);
public static final native int VtblCall(int i, int /*long*/ address, byte[] id, int mapping, int numButtons, int numAxes, int[] retVal);
public static final native int VtblCall(int i, int /*long*/ address, byte[] aHeaderVal, byte[] aDefaultCharset, int aOverrideCharset,
		int aEatContinuation, int /*long*/ retVal);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ uri, byte[] type, int permission, int expireType, long expireTime) ;
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int aType, byte[] aHost, int aFlags, int[] retVal) ;
public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aTransferable, byte[] aFlavor, int /*long*/[] aData,
		int[] aDataLen);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aCell, int[] aRowIndex, int[] aColIndex) ;
public static final native int VtblCall(int i, int /*long*/ address, byte[] aLangGroup, byte[] aGeneric, int[] aCount, int /*long*/[] aResult);
public static final native int VtblCall(int fnNumber, int /*long*/ address, byte[] name, double value);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aName, double aValue) ;
public static final native int VtblCall(int fnNumber, int /*long*/ address, long aName, long aValue) ;
public static final native int VtblCall(int fnNumber, int /*long*/ address, byte[] name, double[] retVal) ;
public static final native int VtblCall(int fnNumber, int /*long*/ address, byte[] aPrefName, float[] retVal);
public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aHeaderVal, byte[] aParamName, int /*long*/ aFallbackCharset,
		int aTryLocaleCharset, int /*long*/[] aLang, int /*long*/ retVal);
//public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ webBrowserPrint, int /*long*/ printSettings, int /*long*/ openDialogObserver,
//		int isForPrinting, int /*long*/[] webProgressListener, int /*long*/[] printProgressParams, int[] notifyOnOpen);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, byte[] args, int count, int /*long*/ observer, int holdWeak) ;
public static final native int VtblCall(int fnNumber, int /*long*/ address, byte[] aFromType, byte[] aToType, int /*long*/ aListener, int /*long*/ aCtxt);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, byte[] formatType, int flags, int wrapColumn, int /*long*/ retVal);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ principal, byte[] type, int exactHost, long sessionExpireTime,
		long persistentExpireTime);
public static final native int VtblCall(int fnNumber, int /*long*/ address, char[] args, int count, int /*long*/ observer, int holdWeak);
public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aStream, byte[] aCharset, int aBufferSize,
		int /*long*/ aReplacementChar);
public static final native int VtblCall(int i, int /*long*/ address, byte[] aHeaderVal, byte[] aParamName, int /*long*/[] aCharset, int /*long*/[] aLang,
		int /*long*/[] retVal);
//public static final native int VtblCall(int i, int /*long*/ address, byte[] aHostname, int /*long*/ evalTime, int /*long*/[] aPinArray,
//		int[] aIncludeSubdomains, int[] retVal) ;
//public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aChannel, int /*long*/ aObserver, int /*long*/ cx, int /*long*/[] aListener,
//		int /*long*/[] retVal);
public static final native int VtblCall(int i, int /*long*/ address, byte[] aName, int /*long*/ aValue, int /*long*/ aCallback, byte[] aMessage);
public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aOuter, byte[] aKey, nsID aIID, int /*long*/[] aResult);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aJSContext, int /*long*/ aScope, int /*long*/ aCOMObj, nsID aIID, int /*long*/[] retVal);
public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aJSContext, int /*long*/ aJSObj, nsID aIID, int /*long*/[] result);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aQueryString, int /*long*/[] aQueries, int[] aResultCount,
//		int /*long*/[] options);
//public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ domain, int /*long*/ name, int /*long*/ nscontext, int[] len, int /*long*/[] prefs);
public static final native int VtblCall(int i, int /*long*/ address, short action, short reason, int /*long*/ number, short timeSeconds,
		short serviceClass, int /*long*/ requestCallback);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aURI, int /*long*/ aName, short[] retVal) ;
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aScheme, int /*long*/ aHost, int aPort, int /*long*/ aAuthType, int /*long*/ aRealm,
		int /*long*/ aPath, int /*long*/ aUserDomain, int /*long*/ aUserName, int /*long*/ aUserPassword, int aIsPrivate, int /*long*/ aPrincipal);
public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aProperty, float[] retVal);
public static final native int VtblCall(int i, int /*long*/ address, int aFlushLayout, float[] aScrollX, float[] aScrollY) ;
public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aCompMgr, nsID aClass, nsID aIID, int /*long*/[] aResult);
//public static final native int VtblCall(int i, int /*long*/ address, int /*long*/[] aHiddenDOMWindow, int /*long*/[] aJSContext);
public static final native int VtblCall(int fnNumber, int /*long*/ address, short index, int /*long*/[] constant, int /*long*/[] name);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/[] aFlavor, int /*long*/[] aData, int[] aDataLen);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aKeyword, int /*long*/[] aPostData, int /*long*/[] retVal);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aNextListener, int /*long*/[] aNewNextListener, int /*long*/ aCtxt);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ window, long[] jsObjectsSize, long[] jsStringsSize,
		long[] jsOtherSize, long[] domSize, long[] styleSize, long[] otherSize, long[] totalSize,
		double[] jsMilliseconds, double[] nonJSMilliseconds);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/[] body, long[] contentLength, int /*long*/ contentType, int /*long*/ charset);
public static final native int VtblCall(int fnNumber, int /*long*/ address, int[] count, int /*long*/ aHostname, int /*long*/ aActionURL, int /*long*/ aHttpRealm,
		int /*long*/[] logins);
public static final native int VtblCall(int fnNumber, int /*long*/ address, char[] aPatText, int /*long*/ aSearchRange, int /*long*/ aStartPoint,
		int /*long*/ aEndPoint, int /*long*/[] retVal);
public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ element, int /*long*/ property, int /*long*/ value1, int /*long*/ value2,
		double[] retVal);
public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aContentType, int /*long*/ aContentLocation, int /*long*/ aRequestOrigin,
		int /*long*/ aContext, int /*long*/ aMimeTypeGuess, int /*long*/ aExtra, short[] retVal);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aContentType, int /*long*/ aContentLocation, int /*long*/ aRequestOrigin,
		int /*long*/ aContext, int /*long*/ aMimeTypeGuess, int /*long*/ aExtra, int /*long*/ aRequestPrincipal, short[] retVal);
public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aRequestTables, int /*long*/ aRequestBody, int /*long*/ aUpdateUrl,
		int /*long*/ aSuccessCallback, int /*long*/ aUpdateErrorCallback, int /*long*/ aDownloadErrorCallback, int[] retVal);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aContentType, int /*long*/ aContentLocation, int /*long*/ aRequestOrigin,
		int /*long*/ aTopFrameElement, int aIsTopLevel, int /*long*/ aMimeTypeGuess, int /*long*/ aExtra, int /*long*/ aRequestPrincipal,
		short[] retVal);
public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aSource, int /*long*/ aTarget, int /*long*/ aDisplayName, int /*long*/ aMIMEInfo,
		long startTime, int /*long*/ aTempFile, int /*long*/ aCancelable, int aIsPrivate);
public static final native int VtblCall(int fnNumber, int /*long*/ address, byte[] aCommand, int /*long*/ aChannel, int /*long*/ aLoadGroup,
		int /*long*/ aContentType, int /*long*/ aContainer, int /*long*/ aExtraInfo, int /*long*/[] aDocListenerResult, int /*long*/[] retVal);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aURI, int /*long*/ aCacheKey, int /*long*/ aReferrer, int aReferrerPolicy,
//		int /*long*/ aPostData, byte[] aExtraHeaders, int /*long*/ aFile, int aIsPrivate);
public static final native int VtblCall(int i, int /*long*/ address, int aType, int /*long*/ aSourceURI, byte[] aHeader, int /*long*/ aSSLStatus, int aFlags,
		long[] aMaxAge, int[] aIncludeSubdomains);
public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aURI, int /*long*/ aProxyURI, int aProxyFlags, int /*long*/ aLoadingNode,
		int /*long*/ aLoadingPrincipal, int /*long*/ aTriggeringPrincipal, int aSecurityFlags, int aContentPolicyType, int /*long*/[] retVal);
public static final native int VtblCall(int fnNumber, int /*long*/ address, long aItemId, long aVisitId, long aTime, int aTransitionType,
		int /*long*/ aURI, long aParentId, int /*long*/ aGuid, int /*long*/ aParentGuid);
public static final native int VtblCall(int i, int /*long*/ address, short aDownloadType, int /*long*/ aSource, int /*long*/ aTarget, int /*long*/ aDisplayName,
			int /*long*/ aMIMEInfo, long aStartTime, int /*long*/ aTempFile, int /*long*/ aCancelable, int /*long*/ aIsPrivate, int /*long*/[] retVal);
public static final native int VtblCall(int fnNumber, int /*long*/ address, byte[] aSocketTypes, int aTypeCount, int /*long*/ aHost, int aPort,
		int /*long*/ aHostRoute, int aPortRoute, int /*long*/ aProxyInfo, int /*long*/[] retVal);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aParent, int aChromeFlags, int aCalledFromJS,
		int aPositionSpecified, int aSizeSpecified, int /*long*/ aURI, int /*long*/ aName, int /*long*/ aFeatures, int[] aWindowIsNew,
		int /*long*/[] retVal);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aEventType, int aCanBubble, int aCancelable, int /*long*/ aView,
		int aDetail, float x, float y, float width, float height);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aHost, int /*long*/ aPath, int /*long*/ aName, int /*long*/ aValue, int aIsSecure,
		int aIsHttpOnly, int aIsSession, long aExpiry);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aNode, int /*long*/[] aText, int[] retVal);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aJSContext, nsID aIID, int /*long*/ aObj, int /*long*/ aClassInfo);
public static final native int VtblCall(int fnNumber, int /*long*/ address, byte[] aTopic, char[] aString, int /*long*/[] retVal);
//public static final native int VtblCall(int i, int /*long*/ address, byte[] scope, int /*long*/ originAttributes, int /*long*/[] retVal);
public static final native int VtblCall(int fnNumber, int /*long*/ address, byte[] methodName, short[] index, int /*long*/[] info);
public static final native int VtblCall(int fnNumber, int /*long*/ address, char[] str, byte[] contentType, int /*long*/[] retVal);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aToken, byte[] aEmailAddress, int /*long*/[] retVal);
public static final native void VtblCall(int fnNumber, int /*long*/ address, byte[] aReason, char[] functionName, char[] fileName,
		int lineNumber);
public static final native int VtblCall(int fnNumber, int /*long*/ address, char[] aName, char[] aSysid, char[] aPubid,
		char[] aNotationName);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aChannel, byte[] aChallenge, int aProxyAuth, char[] aDomain,
		char[] aUser, char[] aPassword, int /*long*/[] aSessionState, int /*long*/[] aContinuationState, int[] aFlags, int /*long*/[] retVal);
public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ ctx, char[] cn, char[] organization, char[] issuer,
		char[] certNickList, char[] certDetailsList, int count, int[] selectedIndex, int[] canceled);
public static final native int VtblCall(int i, int /*long*/ address, char[] dialogTitle, char[] text, char[] passwordRealm, int savePassword,
		char[] defaultText, int /*long*/[] result, int[] retVal);
public static final native int VtblCall(int i, int /*long*/ address, char[] dialogTitle, char[] text, char[] passwordRealm, int savePassword,
		int /*long*/[] user, int /*long*/[] pwd, int[] retVal);
public static final native int VtblCall(int fnNumber, int /*long*/ address, char[] dialogTitle, char[] text, char[] passwordRealm,
		int savePassword, int /*long*/[] pwd, int[] retVal);
public static final native int VtblCall(int i, int /*long*/ address, char[] text, int length, int pos, int isLastBuffer, int[] begin,
		int[] end, int[] retVal);
public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ ctx, char[] certNickList, char[] certDetailsList, int count,
		int[] selectedIndex, int[] canceled);
public static final native int VtblCall(int fnNumber, int /*long*/ address, char[] aName, char[] aAtts, int aAttsCount, int aLineNumber);
public static final native int VtblCall(int fnNumber, int /*long*/ address, char[] word, char[] correction, char[] lang);
public static final native int VtblCall(int i, int /*long*/ address, char[] word, char[] iwords, int icount, int /*long*/[] owords, int[] ocount);
//public static final native int VtblCall(int i, int /*long*/ address, int aNativeKeyboardLayout, int aNativeKeyCode, int aModifierFlags,
//		int /*long*/ aCharacters, int /*long*/ aUnmodifiedCharacters, int /*long*/ aObserver);
public static final native int VtblCall(int i, int /*long*/ address, int aUrlType, int aDefaultPort, int /*long*/ aSpec, byte[] aOriginCharset,
		int /*long*/ aBaseURI);
public static final native int VtblCall(int i, int /*long*/ address, char[] misspelledWord, char[] replaceWord, int allOccurrences);
public static final native int VtblCall(int i, int /*long*/ address, char[] line, int[] logLineStart, int[] retVal);
public static final native int VtblCall(int fnNumber, int /*long*/ address, char[] aURI, int aLoadFlags, int /*long*/ aReferrer, int aReferrerPolicy,
		int /*long*/ aPostData, int /*long*/ aHeaders, int /*long*/ aBaseURI);
//public static final native int VtblCall(int i, int /*long*/ address, char[] aErrorText, char[] aSourceText, int /*long*/ aError, int[] retVal);
public static final native int VtblCall(int i, int /*long*/ address, char[] action, int row, int /*long*/ col);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, char[] word, int /*long*/[] words, int[] count);
public static final native int VtblCall(int i, int /*long*/ address, char[] name, int /*long*/ aRequestor, int /*long*/ aOriginalRequestor, int /*long*/[] retVal);
public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ prop, double[] retVal);
//public static final native int VtblCall(int i, int /*long*/ address, float aXPx, float aYPx, float aWidthPx, float aHeightPx, int /*long*/ aElement,
//		int aPriority);
public static final native int VtblCall(int i, int /*long*/ address, float aX, float aY, float aTopSize, float aRightSize, float aBottomSize,
		float aLeftSize, int aIgnoreRootScrollFrame, int aFlushLayout, int /*long*/[] retVal);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aType, float aX, float aY, int aDirection, double aDelta,
		int aModifiers, int aClickCount);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aText, int /*long*/ aUri, float aVolume, float aRate, float aPitch,
		int /*long*/ aTask);
public static final native int VtblCall(int i, int /*long*/ address, float aTop, float aRight, float aBottom, float aLeft);
public static final native int VtblCall(int i, int /*long*/ address, int aFamily, byte[] aHost, int aPort, byte[] aProxyHost, int aProxyPort,
		int aFlags, int /*long*/ aFileDesc, int /*long*/[] aSecurityInfo);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aParent, byte[] aUrl, byte[] aName, byte[] aFeatures,
		int aCalledFromScript, int aDialog, int aNavigate, int /*long*/ aOpeningTab, int /*long*/ aArgs, int /*long*/[] retVal);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aWindow, char[] inTitle);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ action, int enabledLength, byte[] enabledCommands,
		int disabledLength, byte[] disabledCommands);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aHost, int aPort, byte[] aProtocol, int aTimeout, int /*long*/ cb);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int buf, int bufLen, byte[] contentType, int /*long*/[] retVal);
public static final native int VtblCall(int fnNumber, int /*long*/ address, char[] action, int row, char[] colID);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ statusMessage, int aLength, char[] aAdditionalInformation);
public static final native int VtblCall(int i, int /*long*/ address, int aEntries, double aInterval, byte[] aFeatures, int aFeatureCount,
		byte[] aThreadNameFilters, int aFilterCount);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int issuer, int issuer_length, int serial, int serial_length,
//		int subject, int subject_length, int pubkey, int pubkey_length, int[] retVal);
public static final native int VtblCall(int i, int /*long*/ address, int aScreenX, int aScreenY, int aNativeMessage, double aDeltaX,
		double aDeltaY, double aDeltaZ, int aModifierFlags, int aAdditionalFlags, int /*long*/ aElement, int /*long*/ aObserver);
//public static final native int VtblCall(int i, int /*long*/ address, int aType, int aOffset, int aLength, int aX, int aY,
//		int aAdditionalFlags, int /*long*/[] retVal);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aType, int aKeyCode, int aCharCode, int aModifiers,
//		int aAdditionalFlags, int[] retVal);
public static final native int VtblCall(int fnNumber, int /*long*/ address, float aElapsedTime, int aCharIndex);
public static final native int VtblCall(int i, int /*long*/ address, int startOffset, int endOffset, int[] x, int[] y, int[] width,
		int[] height, int coordType);
public static final native int VtblCall(int fnNumber, int /*long*/ address, int offset, int boundaryType, int[] startOffset, int[] endOffset,
		int /*long*/ retVal);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aName, float aElapsedTime, int aCharIndex);
public static final native int VtblCall(int i, int /*long*/ address, int offset, int[] x, int[] y, int[] width, int[] height,
		int coordType);
public static final native int VtblCall(int i, int /*long*/ address, int includeDefAttrs, int offset, int[] rangeStartOffset,
		int[] rangeEndOffset, int /*long*/[] retVal);
public static final native int VtblCall(int fnNumber, int /*long*/ address, long aToken, int aType, int[] count, int /*long*/[] certNameList);
public static final native int VtblCall(int fnNumber, int /*long*/ address, int startIndex, int[] frameCount, float[] frameIntervals);
public static final native int VtblCall(int fnNumber, int /*long*/ address, long scheme, int[] enabled, int /*long*/ retVal);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int x, int y, int[] row, int /*long*/[] col, int /*long*/ childElt);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/[] dictionaries, int[] count);
public static final native int VtblCall(int i, int /*long*/ address, int index, int axis, double value);
public static final native int VtblCall(int fnNumber, int /*long*/ address, double aSinceTime, int /*long*/[] retVal);
//public static final native int VtblCall(int i, int /*long*/ address, int[] aGroupLevel, int[] aSimilarItemsInGroup, int[] aPositionInGroup);
public static final native int VtblCall(int fnNumber, int /*long*/ address, int[] aMixed, short[] aAlign);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int aFlags, int[] aCount, int /*long*/[] aProps);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int[] verified, int[] count, int /*long*/[] usages);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aDoc, int[] aLength, int /*long*/[] aSheets);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aPrefixedFuncName, int /*long*/ aPrefixedFuncBody,
//		int /*long*/ aUnprefixedFuncName, int /*long*/ aUnprefixedFuncBody, int[] retVal);
//public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ wrapper, int /*long*/ cx, int /*long*/ obj, int /*long*/ id, int /*long*/ val, int[] retVal);
public static final native int VtblCall(int fnNumber, int /*long*/ address, byte[] aServiceName, int aServiceFlags, char[] aDomain,
		char[] aUsername, char[] aPassword);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aLauncher, int /*long*/ aWindowContext, char[] aDefaultFileName,
		char[] aSuggestedFileExtension, int aForcePrompt);
public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aMimetype, int /*long*/ aBrowser, int /*long*/ aReferer, char[] aUris,
		char[] aHashes, char[] aNames, char[] aIcons, int /*long*/ aCallback, int aInstallCount, int[] retVal);
//public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ name, int /*long*/ expiration, int histogram_type, int min, int max,
//		int bucket_count, int /*long*/[] retVal);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aSink, int /*long*/ aStatus, char[] aErrorMsg);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aObject, nsID aIID, int aIsStrongRef);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aError, int /*long*/ aURI, char[] aURL, int /*long*/ aFailedChannel);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aURI, int /*long*/ aName, double[] retVal);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aType, float aX, float aY, int aButton, int aClickCount,
		int aModifiers, int aIgnoreRootScrollFrame, float aPressure, short aInputSourceArg, int aIsSynthesized,
		int[] retVal);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aType, float aX, float aY, int aButton, int aClickCount,
		int aModifiers, int aIgnoreRootScrollFrame, float aPressure, short aInputSourceArg, int aIsSynthesized);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aType, float aX, float aY, int aButton, int aClickCount,
		int aModifiers, int aIgnoreRootScrollFrame, float aPressure, short aInputSourceArg, int aPointerId, int aWidth,
		int aHeight, int aTiltX, int aTiltY, int aIsPrimary, int aIsSynthesized, int[] retVal);
public static final native int VtblCall(int fnNumber, int /*long*/ address, float aX, float aY, int aIgnoreRootScrollFrame, int aFlushLayout,
		int /*long*/[] retVal);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aType, float aX, float aY, int aButton, int aClickCount,
		int aModifiers, int aIgnoreRootScrollFrame, float aPressure, short aInputSourceArg, int aPointerId, int aWidth,
		int aHeight, int aTiltX, int aTiltY, int aIsPrimary, int aIsSynthesized);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ typeArg, int canBubbleArg, int cancelableArg, int /*long*/ viewArg,
		int detailArg, int screenXArg, int screenYArg, int clientXArg, int clientYArg, int ctrlKeyArg, int altKeyArg,
		int shiftKeyArg, int metaKeyArg, short buttonArg, int /*long*/ relatedTargetArg, int allowedDirectionsArg,
		int directionArg, double deltaArg, int clickCount);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ typeArg, int canBubbleArg, int cancelableArg, int /*long*/ viewArg,
		int detailArg, int screenXArg, int screenYArg, int clientXArg, int clientYArg, int ctrlKeyArg, int altKeyArg,
		int shiftKeyArg, int metaKeyArg, short buttonArg, int /*long*/ relatedTargetArg, int axis);
//public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ typeArg, int canBubbleArg, int cancelableArg, int /*long*/ aView,
//		int aDetail, int aScreenX, int aScreenY, int aClientX, int aClientY, int aCtrlKey, int aAltKey, int aShiftKey,
//		int aMetaKey, short aButton, int /*long*/ aRelatedTarget, int /*long*/ aDataTransfer);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ typeArg, int canBubbleArg, int cancelableArg, int /*long*/ viewArg,
		int detailArg, int screenXArg, int screenYArg, int clientXArg, int clientYArg, short buttonArg,
		int /*long*/ relatedTargetArg, int /*long*/ modifiersListArg, double deltaXArg, double deltaYArg, double deltaZArg,
		int deltaMode);
public static final native int VtblCall(int fnNumber, int /*long*/ address, char[] locale, int dateFormatSelector, int timeFormatSelector,
		int year, int month, int day, int hour, int minute, int second, int /*long*/[] retVal);
public static final native int VtblCall(int fnNumber, int /*long*/ address, float aX, float aY, double aDeltaX, double aDeltaY,
		double aDeltaZ, int aDeltaMode, int aModifiers, int aLineOrPageDeltaX, int aLineOrPageDeltaY, int aOptions);
public static final native int VtblCall(int i, int /*long*/ address, int aServiceId, int aGsmGeographicalScope, short aMessageCode,
		short aMessageId, int /*long*/ aLanguage, int /*long*/ aBody, int aMessageClass, int /*long*/ aTimestamp, int aCdmaServiceCategory,
		int aHasEtwsInfo, int aEtwsWarningType, int aEtwsEmergencyUserAlert, int aEtwsPopup);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aType, int aIdentifiers, int aXs, int aYs, int aRxs, int aRys,
		float aRotationAngles, float aForces, int count, int aModifiers, int aIgnoreRootScrollFrame, int[] retVal);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aType, int aIdentifiers, int aXs, int aYs, int aRxs, int aRys,
		float aRotationAngles, float aForces, int count, int aModifiers);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ typeArg, int canBubbleArg, int cancelableArg, int /*long*/ viewArg,
//		int detailArg, int ctrlKeyArg, int altKeyArg, int shiftKeyArg, int metaKeyArg, int /*long*/ sourceEvent);
public static final native int VtblCall(int i, int /*long*/ address, byte[] aSocketTypes, int aTypeCount, int /*long*/ aHost, int aPort,
		int /*long*/ aProxyInfo, int /*long*/[] retVal);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, char[] aName, int aRecurse, int aSameType, int /*long*/ aRequestor,
//		int /*long*/ aOriginalRequestor, int /*long*/[] retVal);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ parent, int chromeFlags, int contextFlags, int /*long*/ uri,
		int /*long*/ aOpeningTab, int[] cancel, int /*long*/[] retVal);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aDataSources, int /*long*/ aRootNode, int aIsTrusted, int /*long*/ aBuilder,
//		int[] aShouldDelayBuilding, int /*long*/[] retVal);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ mimeType, int /*long*/ contentSourceURL, int /*long*/ sourceDocument,
		int willDeleteSelection, int /*long*/[] docFragment, int /*long*/[] contentStartNode, int[] contentStartOffset,
		int /*long*/[] contentEndNode, int[] contentEndOffset, int /*long*/[] insertionPointNode, int[] insertionPointOffset,
		int[] continueWithInsertion);
//public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aTypeHeader, int /*long*/ aCharset, int[] aCharsetStart, int[] aCharsetEnd,
//		int[] retVal);
public static final native int VtblCall(int i, int /*long*/ address, int row, int /*long*/ col, int /*long*/ element, int[] x, int[] y, int[] width,
		int[] height);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ inWindow, int inPosition, int /*long*/ inBelow, int[] outPosition,
//		int /*long*/[] outBelow, int[] retVal);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aProperty, int /*long*/ aAttribute, int /*long*/ aValue, int[] aFirst,
//		int[] aAny, int[] aAll);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ wrapper, int /*long*/ cx, int /*long*/ obj, int /*long*/ id, int[] resolvedp,
//		int[] retVal);
public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aURI, int /*long*/ aChannel, int /*long*/ aCookie, int[] aIsSession,
		long[] aExpiry, int[] retVal);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aContainer, int /*long*/ aDocument, byte[] aCommand,
//		int /*long*/[] retVal);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ api, int /*long*/ tags, int[] hasPlugin, int /*long*/ version);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aDatabaseName, long aId, int /*long*/ aOptions, int[] aRefCnt,
		int[] aDBRefCnt, int[] aSliceRefCnt, int[] retVal);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aProperty, int /*long*/ aAttribute, int /*long*/ aValue, int[] aFirst, int[] aAny,
		int[] aAll, int /*long*/ retVal);
public static final native int VtblCall(int i, int /*long*/ address, int aPointerId, int aTouchState, int aScreenX, int aScreenY,
		double aPressure, int aOrientation, int /*long*/ aObserver);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aWindow, int[] aVideo, int[] aAudio, int[] aScreenShare,
		int[] aWindowShare, int[] aAppShare, int[] aBrowserShare);
public static final native int VtblCall(int i, int /*long*/ address, int aType, int /*long*/ aSourceURI, byte[] aHeader, int aFlags, long[] aMaxAge,
		int[] aIncludeSubdomains);
public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aCompMgr, int /*long*/ aLocation, byte[] aLoaderStr);
public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ targetFile, long workingDir, char[] args,
		char[] description, int /*long*/ iconFile, int iconIndex);
public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aParent, long aUrl, int aChromeMask, int aInitialWidth,
		int aInitialHeight, int /*long*/ aOpeningTab, int /*long*/[] retVal);
public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aSpec, byte[] aOriginCharset, int /*long*/ aBaseURI,
		int /*long*/ aLoadingNode, int /*long*/ aLoadingPrincipal, int /*long*/ aTriggeringPrincipal, int aSecurityFlags,
		int aContentPolicyType, int /*long*/[] retVal);
public static final native int VtblCall(int i, int /*long*/ address, int id, long threadId, int /*long*/ iccId, int /*long*/ delivery, int /*long*/ deliveryInfo,
		int /*long*/ sender, int /*long*/ receivers, long timestamp, long sentTimestamp, int read, int /*long*/ subject, int /*long*/ smil,
		int /*long*/ attachments, long expiryDate, int readReportRequested, int /*long*/[] retVal);
public static final native int VtblCall(int i, int /*long*/ address, int id, long threadId, int /*long*/ iccId, int /*long*/ delivery, int /*long*/ deliveryStatus,
		int /*long*/ sender, int /*long*/ receiver, int /*long*/ body, int /*long*/ messageClass, long timestamp, long sentTimestamp,
		long deliveryTimestamp, int /*long*/ read, int /*long*/[] retVal);
//public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aScheme, int /*long*/ aHost, int aPort, int /*long*/ aAuthType, int /*long*/ aRealm,
//		int /*long*/ aPath, int /*long*/ aUserDomain, int /*long*/ aUserName, int /*long*/ aUserPassword, int /*long*/ aIsPrivate, int /*long*/ aPrincipal);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ imageUrl, int /*long*/ title, int /*long*/ text, int textClickable, int /*long*/ cookie,
		int /*long*/ alertListener, int /*long*/ name, int /*long*/ dir, int /*long*/ lang, int /*long*/ data, int /*long*/ principal, int inPrivateBrowsing);
//public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ origin, int /*long*/ id, int /*long*/ title, int /*long*/ dir, int /*long*/ lang, int /*long*/ body,
//		int /*long*/ tag, int /*long*/ icon, int /*long*/ alertName, int /*long*/ data, int /*long*/ behavior);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aURI, int /*long*/ aName, int[] aFlags, short[] aExpiration,
		short[] aType);
public static final native int VtblCall(int fnNumber, int /*long*/ address, int hasStartDate, long startDate, int hasEndDate, long endDate,
		char[] numbers, int numbersCount, int /*long*/ delivery, int hasRead, int read, long threadId, int reverse,
		int /*long*/ callback, int /*long*/[] retVal);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ message, int /*long*/ sourceName, int /*long*/ sourceLine, int lineNumber,
		int columnNumber, int flags, byte[] category);
//public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ parent, int /*long*/ cookie, int /*long*/ hostname, int cookiesFromHost,
//		int changingCookie, int[] rememberDecision, int[] retVal);
//public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aURI, int /*long*/ aLoadingNode, int /*long*/ aLoadingPrincipal,
//		int /*long*/ aTriggeringPrincipal, int aSecurityFlags, int aContentPolicyType, int /*long*/[] retVal);
public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aURI, int /*long*/ aCacheKey, int /*long*/ aReferrer, int /*long*/ aReferrerPolicy,
		int /*long*/ aPostData, byte[] aExtraHeaders, int /*long*/ aFile, int /*long*/ aPrivacyContext);
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aURI, int /*long*/ aInitialDocumentURL, int /*long*/ aReferrerURI,
		int /*long*/ aReferrerPolicy, int /*long*/ aLoadingPrincipal, int /*long*/ aLoadGroup, int /*long*/ aObserver, int /*long*/ aCX, int /*long*/ aLoadFlags,
		int /*long*/ cacheKey, int /*long*/ aContentPolicyType, int /*long*/[] retVal);
//public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aURI, int /*long*/ aReferrer, int aReferrerPolicy, int /*long*/ aOwner, int aFlags,
//		char[] aWindowTarget, byte[] aTypeHint, int /*long*/ aFileName, int /*long*/ aPostDataStream, int /*long*/ aHeadersStream,
//		int aLoadFlags, int /*long*/ aSHEntry, int firstParty, int /*long*/ aSrcdoc, int /*long*/ aSourceDocShell, int /*long*/ aBaseURI,
//		int /*long*/[] aDocShell, int /*long*/[] aRequest);
public static final native int VtblCall(int i, int /*long*/ address, int[] aMixed, int /*long*/ retVal);
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int strength, int /*long*/ stringIn, int /*long*/[] key, int[] outLen);
public static final native int VtblCall(int fnNumber, int /*long*/ address, char[] word, int type, int /*long*/[] words, int[] count);
public static final native int VtblCall(int fnNumber, int /*long*/ address, byte[] httpVersion, short statusCode, byte[] description) ;
public static final native int VtblCall(int fnNumber, int /*long*/ address, byte[] scheme, byte[] host, int port, int[] retVal) ;
//public static final native int VtblCall(int fnNumber, int /*long*/ address, int /*long*/ aBaseURI, int /*long*/ aContentType) ;
public static final native int VtblCall(int i, int /*long*/ address, int /*long*/ aURI, int /*long*/ aOriginalURI, int aLoadReplace, int /*long*/ aReferrer,
		int aReferrerPolicy, int /*long*/ aOwner, int aFlags, char[] aWindowTarget, byte[] aTypeHint, int /*long*/ aFileName,
		int /*long*/ aPostDataStream, int /*long*/ aHeadersStream, int aLoadFlags, int /*long*/ aSHEntry, int firstParty, int /*long*/ aSrcdoc,
		int /*long*/ aSourceDocShell, int /*long*/ aBaseURI, int /*long*/[] aDocShell, int /*long*/[] aRequest) ;
}
