﻿:: **********************************************************
:: * Installation-Script HCL Notes                          *
:: *                                                        *
:: * Sections:                                              *
:: * - Variables                                            *
:: * - Copy Installation files                              *
:: * - Saving personal notes data             		        *
:: * - De-Installation IBM Notes                            *
:: * - Installation IBM Notes                               *
:: * - Installation IBM Notes Fixes                         *
:: * - Restore personal notes data                          *
:: * - Copy configuration files                             *
:: * - Delete installation files                            *
:: *                                                        *
:: *     CROSS-WORKS AG ¦ Janick Mueller ¦ 12.01.2022 	    *
:: **********************************************************

echo off

title CROSS-WORKS - HCL Notes Client Installer
color A
MD C:\Temp

CLS
echo  *********************************
echo  * CROSS-WORKS                   *
echo  *                               *
echo  * HCL Notes Installer for WIN   *
echo  *********************************
echo.
::set /p winuser=Please enter the windows logon name of the to migrate user:
::echo %winuser%
::if not exist %systemdrive%\Users\%winuser%\ goto error



:: **********************************************************
:: * Variables                                              *
:: **********************************************************
:: Folder variables
set source=%~dp0
set logpath=C:\Temp\
set notes_source=%source%\Client\
set notes_config=%source%\Config\
set notes_fixes=%source%\Fixes\
set notes_uninstall=%source%\Uninstall\
set notesdatabackup=%systemdrive%\Users\%winuser%\AppData\Local\HCL\Notes\NSF-Backup\
set localappnotesdata=%systemdrive%\Users\%winuser%\AppData\Local\HCL\Notes\Data\
:: check if OS is x86 or x64
if exist "%ProgramFiles(x86)%" (set notesprogram="%ProgramFiles(x86)%\HCL\Notes\") else (set notesprogram="%ProgramFiles%\HCL\Notes\")
:: check if notes program dir exists, otherwise we try to read the program dir from registry (x64)
if NOT exist %notesprogram% (FOR /F "skip=2 tokens=2,*" %%A IN ('reg.exe query "HKEY_LOCAL_MACHINE\SOFTWARE\WOW6432Node\Lotus\Notes" /v "Path"') DO set notesprogram="%%B")
:: check if notes program dir exists, otherwise we try to read the program dir from registry (x86)
if NOT exist %notesprogram% (FOR /F "skip=2 tokens=2,*" %%A IN ('reg.exe query "HKEY_LOCAL_MACHINE\SOFTWARE\Lotus\Notes" /v "Path"') DO set notesprogram="%%B")
:: check if notes.ini exists in notes program dir (-> single user installation), otherwise we assume its a multiuser installation
if exist %notesprogram%notes.ini (set notesdatadir=%notesprogram%Data\) else (set notesdatadir="%localappnotesdata%")

:: change config.txt
set /P domsrvname=Please enter a Domino Server name without the Organisation e.g. "servername01":
(
echo Username=%UserName%
echo Domino.Name=%domsrvname%
echo Domino.Server=1
echo Domino.Port=TCPIP
echo AdditionalServices=-1
)>"%source%Config\Shared\config.txt"


:: Installation step variables
set installationstep=0
set suminstallationsteps=8

:: **********************************************************
:: * Copy the installation files to the destination         *
:: **********************************************************
set /a "installationstep+=1"
CLS
echo  *********************************
echo  * CROSS-WORKS                   *
echo  *                               *
echo  * HCL Notes Installer for WIN   *
echo  *********************************
echo. 
echo  Installation step: %installationstep%/%suminstallationsteps%
echo  ===========================
echo. 
echo  Copy Installations files...
echo.
echo            ...will take a little while
echo.


:: **********************************************************
:: * Saving personal Notes data                             *
:: **********************************************************
set /a "installationstep+=1"
CLS
echo  *********************************
echo  * CROSS-WORKS                   *
echo  *                               *
echo  * HCL Notes Installer for WIN   *
echo  *********************************
echo. 
echo  Installation step: %installationstep%/%suminstallationsteps%
echo  ===========================
echo. 
echo Saving personal Notes data...
echo.

mkdir %notesdatabackup%

xcopy /S /Q /R /V /Y %notesdatadir%*.ndk %notesdatabackup%
xcopy /S /Q /R /V /Y %notesdatadir%*.nsf %notesdatabackup%
xcopy /S /Q /R /V /Y %notesdatadir%*.id %notesdatabackup%


:: **********************************************************
:: * De-Installation Notes          	 	                *
:: **********************************************************
set /a "installationstep+=1"
CLS
echo  *********************************
echo  * CROSS-WORKS                   *
echo  *                               *
echo  * HCL Notes Installer for WIN   *
echo  *********************************
echo. 
echo  Installation step: %installationstep%/%suminstallationsteps%
echo  ===========================
echo. 
echo Uninstalling HCL Notes Client...
echo.
echo            ...will take a little while
echo.
cd %notes_uninstall%
:: Zu Testzwecken kann NICE mit dem Parameter "/qb+" ausgeführt werden um den Fortschritt anzuzeigen. Für einen Silent-Run wird stattdessen "/qn" verwendet
:: Offizielles IBM-Hilfedokument: http://www-01.ibm.com/support/docview.wss?uid=swg21459714
nice.exe -rp -rd -wipe /qn
rmdir %notesdatadir% /S /Q


:: **********************************************************
:: * Installation Notes Client (MSI & MST config)           *
:: **********************************************************
set /a "installationstep+=1"
CLS
echo  *********************************
echo  * CROSS-WORKS                   *
echo  *                               *
echo  * HCL Notes Installer for WIN   *
echo  *********************************
echo. 
echo  Installation step: %installationstep%/%suminstallationsteps%
echo  ===========================
echo. 
echo  Installing HCL Notes Client...
echo.
echo            ...will take a little while
echo.
cd %notes_source%
msiexec.exe /I "HCL Notes 12.0.1.msi" SETMULTIUSER=1 /qn  /lx*v %logpath%\Notes-Client.log


:: **********************************************************
:: * Installation Feature Pack                              *
:: **********************************************************
set /a "installationstep+=1"
#CLS
echo  *********************************
echo  * CROSS-WORKS                   *
echo  *                               *
echo  * HCL Notes Installer for WIN   *
echo  *********************************
echo. 
echo  Installation step: %installationstep%/%suminstallationsteps%
echo  ===========================
echo. 
echo  HCL Notes Client Fixes...
echo.
echo            ...will take a little while
echo.
cd %notes_fixes%
notes-featurepack.exe -s -a /s /v"/qn /L*v %logpath%\Notes-FeaturePack.log"
echo.
echo.
echo.


:: **********************************************************
:: * Restore personal Notes data                            *
:: **********************************************************
set /a "installationstep+=1"
#CLS
echo  *********************************
echo  * CROSS-WORKS                   *
echo  *                               *
echo  * HCL Notes Installer for WIN   *
echo  *********************************
echo. 
echo  Installation step: %installationstep%/%suminstallationsteps%
echo  ===========================
echo. 
echo Personal Notes Data are restored...
echo.
xcopy /S /Q /R /V /Y %notesdatabackup%desktop8.ndk %localappnotesdata%
xcopy /S /Q /R /V /Y %notesdatabackup%bookmark.nsf %localappnotesdata%
xcopy /S /Q /R /V /Y %notesdatabackup%names.nsf %localappnotesdata%
xcopy /S /Q /R /V /Y %notesdatabackup%*.id %localappnotesdata%


:: **********************************************************
:: * Copy configuration files                               *
:: **********************************************************
set /a "installationstep+=1"
#CLS
echo  *********************************
echo  * CROSS-WORKS                   *
echo  *                               *
echo  * HCL Notes Installer for WIN   *
echo  *********************************
echo. 
echo  Installation step: %installationstep%/%suminstallationsteps%
echo  ===========================
echo. 
echo  Copy config files...
cd %notes_config%
copy /V /Y %notes_config%\Shared\notes.ini %ALLUSERSPROFILE%\HCL\Notes\Data
copy /V /Y %notes_config%\Shared\config.txt %ALLUSERSPROFILE%\HCL\Notes\Data


:: **********************************************************
:: * Delete installation files                              *
:: **********************************************************
set /a "installationstep+=1"
CLS
echo  *********************************
echo  * CROSS-WORKS                   *
echo  *                               *
echo  * HCL Notes Installer for WIN   *
echo  *********************************
echo. 
echo  Installation step: %installationstep%/%suminstallationsteps%
echo  ===========================
echo. 
echo  Deleting Installation files...
echo.
CD\
rmdir %source% /S /Q


:: **********************************************************
:: * Installation finished                                  *
:: **********************************************************
CLS
echo  *********************************
echo  * CROSS-WORKS                   *
echo  *                               *
echo  * HCL Notes Installer for WIN   *
echo  *********************************
echo.
echo  The installation of HCL Notes is finished.
echo.
pause
exit

:error
color C
CLS
echo  *********************************
echo  * CROSS-WORKS                   *
echo  *                               *
echo  * HCL Notes Installer for WIN   *
echo  *********************************
echo.
echo Error, user directory doesn't exist.
echo.
pause

