' ***************************************************************** 
'                                                                   
' IBM Confidential                                                  
'                                                                   
' OCO Source Materials                                              
'                                                                   
' Copyright IBM Corp. 2010, 2015                                    
'                                                                   
' The source code for this program is not published or otherwise    
' divested of its trade secrets, irrespective of what has been      
' deposited with the U.S. Copyright Office.                         
'                                                                   
' ***************************************************************** 

Dim debugmode, inifile, Directory, NotesProgram, CurrentDataDirectory, RCPHome
Dim MultiUserBaseDir, MultiUserCommonDir, DryRun, BackupDirectory, NeedRestore, MultiUserBaseDirInReg, MultiUserCommonDirInReg, bEnableLogging, bEnableProgress
Dim lotuskey, lotussubkey, IBMkey, CurrentUserNotesKey, CurrentUserNotesSubKey, HCLkey
Dim MIGRATE_REGISTRY, MIGRATE_USER_REGISTRY, MIGRATE_SHARED_DIR, MIGRATE_USERDATA_DIR, IS_SIMULATED_MODE, MIGRATE_SHARED_FILES, NBP_MODE, SILENT_MODE
Dim LogFile
Dim NotesMajorVersion, MultiUserDataPath
Dim pb, percentComplete


'##########################################################################################
'#
'#									Configurations
'##########################################################################################

'more debug information
debugmode = 0





'###########################################################################################
'#									Consts
'#
'###########################################################################################


Const Read   = 1
Const Write   = 2
Const Append = 8

CSIDL_APPDATA = &H1A ' * CSIDL_APPDATA - File system directory that serves as a common repository for application-specific data. A common path is C:\WINNT\Profiles\username\Application Data.
CSIDL_COMMON_APPDATA = &H23 ' * CSIDL_COMMON_APPDATA - Version 5.0. Application data for all users. A common path is C:\WINNT\Profiles\All Users\Application Data.
CSIDL_COMMON_DESKTOPDIRECTORY = &H19 ' * CSIDL_COMMON_DESKTOPDIRECTORY - File system directory that contains files and folders that appear on the desktop for all users. A common path is C:\WINNT\Profiles\All Users\Desktop. Valid only for Windows NT systems.
CSIDL_COMMON_DOCUMENTS = &H2E ' * CSIDL_COMMON_DOCUMENTS - File system directory that contains documents that are common to all users. A common path is C:\WINNT\Profiles\All Users\Documents. Valid only for Windows NT systems.
CSIDL_COMMON_PROGRAMS = &H17 ' * CSIDL_COMMON_PROGRAMS - File system directory that contains the directories for the common program groups that appear on the Start menu for all users. A common path is c:\WINNT\Profiles\All Users\Start Menu\Programs. Valid only for Windows NT systems.
CSIDL_PROGRAMS = &H2 ' * CSIDL_PROGRAMS - File system directory that contains the user's program groups (which are also file system directories). A common path is C:\WINNT\Profiles\username\Start Menu\Programs
CSIDL_DESKTOPDIRECTORY = &H10 ' * CSIDL_DESKTOPDIRECTORY - File system directory used to physically store file objects on the desktop (not to be confused with the desktop folder itself). A common path is C:\WINNT\Profiles\username\Desktop
CSIDL_LOCAL_APPDATA = &H1C ' * CSIDL_LOCAL_APPDATA - Version 5.0. File system directory that serves as a data repository for local (non-roaming) applications. A common path is C:\WINNT\Profiles\username\Local Settings\Application Data.
CSIDL_PROGRAM_FILES = &H26 ' * CSIDL_PROGRAM_FILES - Version 5.0. Program Files folder. A common path is C:\Program Files.
CSIDL_PERSONAL = &H5  ' * CSIDL_PERSONAL - File system directory that serves as a common repository for documents. A common path is C:\WINNT\Profiles\username\My Documents.


'###########################################################################################
'#									Progress Bar class
'#
'###########################################################################################
Class ProgressBar
Private Title
Private PercentComplete
Private CurrentStep
Private ProgressBar
Private Text
Private StatusBarText

' set progress bar defaults
Private Sub ProgessBar_Init
m_PercentComplete = 0
m_CurrentStep = 0
m_Title = "Progress"
m_Text = ""
End Sub

Public Function SetTitle(pTitle)
Title = pTitle
End Function

Public Function SetTask(pText)
Text = pText
End Function

Public Function Update(pPercentComplete)
PercentComplete = pPercentComplete
UpdateProgressBar()
End Function

Public Function Show()

If not SILENT_MODE Then
	Set ProgressBar = CreateObject("InternetExplorer.Application")
	'in code, the colon acts as a line feed
	ProgressBar.navigate2 "about:blank" : ProgressBar.width = 315 : ProgressBar.height = 120 : ProgressBar.toolbar = false : ProgressBar.menubar = false : ProgressBar.statusbar = false : ProgressBar.visible = true
	ProgressBar.document.write "<body Scroll=no style='margin:0px;padding:0px;'><div style='text-align:center;'><span name='pb' id='pb'>0</span></div>"
	ProgressBar.document.write "<div id='statusbar' name='statusbar' style='border:1px solid blue;line-height:10px;height:10px;color:blue;'></div>"
	ProgressBar.document.write "<div style='text-align:center'><span id='text' name='text'></span></div>"
End If
End Function

Public Function Close()
If not SILENT_MODE Then
	ProgressBar.quit
End If
End Function

Private Function UpdateProgressBar()

	If not SILENT_MODE Then
		If PercentComplete = 0 Then
			StatusBarText = ""
		End If
		For n = CurrentStep to PercentComplete - 1
			StatusBarText = StatusBarText & "|"
			ProgressBar.Document.GetElementById("statusbar").InnerHtml = StatusBarText
			ProgressBar.Document.title = n & "% Complete : " & Title
			ProgressBar.Document.GetElementById("pb").InnerHtml = n & "% Complete : " & Title
			wscript.sleep 10
		Next
		ProgressBar.Document.GetElementById("statusbar").InnerHtml = StatusBarText
		ProgressBar.Document.title = PercentComplete & "% Complete : " & Title
		ProgressBar.Document.GetElementById("pb").InnerHtml = PercentComplete & "% Complete : " & Title
		ProgressBar.Document.GetElementById("text").InnerHtml = Text
		CurrentStep = PercentComplete
	End If
End Function


End Class




'###########################################################################################
'#									Utils
'#
'###########################################################################################

'##########################################################################################
' Print msgs to the log file and display on the screen
'##########################################################################################

Sub Print(msg)
	Dim fso
	Set fso = CreateObject("Scripting.FileSystemObject")
	If bEnableLogging Then
		Set logStream = fso.OpenTextFile( LogFile, Append, True)
		logStream.WriteLine(Now() & " " & msg)
		logStream.Close
	End If
	If NBP_MODE = "" Then
		WScript.Echo(Now() & " " & msg)
	End If
End Sub


Sub Debug(msg)
	If debugmode = 1 Then
		Print("DEBUG: " & msg)
	End If
End Sub


Sub Warn(msg)
	Print("WARN: " & msg)
End Sub


Sub ErrorOut(errno, msg)
	Print("ERROR: " & msg)
	Err.Clear
	If NeedRestore And (Not DryRun) Then
		RestoreUserData()
	End If	
	pb.Close()
	WScript.Quit(errno)
End Sub


Sub CreateFolder( fso, path )
	On Error Resume Next
	If path <> "" Then 
		If Not fso.FolderExists( fso.GetParentFolderName(path) ) Then	 
			Call CreateFolder(fso, fso.GetParentFolderName(path)) 
		End If
		fso.CreateFolder( path )
		If Err.Number <> 0 Then
			ErrorOut Err.Number, "Cannot create folder " & path & ", " & Err.Description
		End If
	End If 
End Sub

'##########################################################################################
' Read the notes.ini file
'##########################################################################################
Function ReadIni( myFile, mySecion, myKey )
    
	Dim pos,rpos
	Dim fso, textstream
	Dim file, secion, key, lstr, line

	file = Trim(myFile)
	section = Trim(mySecion)
	key = Trim(myKey)

	Set fso = CreateObject( "Scripting.FileSystemObject" )
	ReadIni     = ""
	On Error Resume Next	
	Set textstream = fso.OpenTextFile( file, Read, False )
	If Err.Number <> 0 Then
		ErrorOut Err.Number, "Cannot open" & file & "," & Err.Description
	End If
	On Error Goto 0
	Do While Not textstream.AtEndOfStream
		line = Trim( textstream.ReadLine )
		If Left(line, 1) <> ";" Then
			If LCase( line ) = "[" & LCase( section ) & "]" Then
				line = Trim( textstream.ReadLine )
				Do While Left( line, 1 ) <> "["
					pos = InStr( 1, line, "=", 1 )
					If pos > 0 Then
						lstr = Trim( Left( line, pos - 1 ) )
						If LCase( key ) = LCase( lstr ) Then
							rpos = InStr(pos, line, ";", 1)
							If rpos > 0 Then
								ReadIni = Trim( Mid( line, pos + 1, rpos-pos ) )
							Else
								ReadIni = Trim( Mid( line, pos + 1 ) )
							End If
							If ReadIni = "" Then
								ReadIni = " "
							End If
							' Quit loop when key is found
							Exit Do
						End If
					End If

					' Quit if the end of the INI file is reached
					If textstream.AtEndOfStream Then Exit Do

					' Continue with next line
					line = Trim( textstream.ReadLine )
				Loop
				Exit Do
			End If
		End If
	Loop
	textstream.Close
End Function

'##########################################################################################
' Write the stub notes.ini file
'##########################################################################################
Sub WriteIni( myFile, mySection, myKey, myVal )
	Dim fso, wsh, tempFile
	Dim readStream, tempStream, line, lstr
	Dim file, section, key, val
	Dim bKeyExist, bWritten, bInSection, bSectionExists
	Dim pos
	
	file = Trim( myFile )
	section = Trim( mySection )
	key = Trim( myKey )
	val = Trim ( myVal )


	Set fso   = CreateObject( "Scripting.FileSystemObject" )
	Set wsh = CreateObject( "WScript.Shell" )

	tempFile = fso.BuildPath( wsh.ExpandEnvironmentStrings( "%TEMP%" ), fso.GetTempName )
	On Error Resume Next
	Set readStream = fso.OpenTextFile( file, Read, True )
	If Err.Number <> 0 Then
		ErrorOut Err.Number, "Cannot open " & file & "," & Err.Description
	End If

	Set tempStream = fso.CreateTextFile( tempFile, False, False )

	If Err.Number <> 0 Then
		ErrorOut Err.Number, "Cannot open " & tempFile & "," & Err.Description
	End If
	On Error Goto 0

	bSectionExists = False
	bInSection     = False
	bWritten       = False
	bKeyExists = ( ReadIni( file, section, key ) <> "" )
    
	While Not readStream.AtEndOfStream
		line = Trim(readStream.ReadLine)
		If Not bWritten Then
			If LCase( line ) = "[" & LCase( section) & "]" Then
				bInSection = True
				bSectionExists = True
				ElseIf InStr( line, "[" ) = 1 Then
					bInSection = False
				End If
			End If

			If bInSection Then
				If bKeyExists Then 
				pos = InStr( 1, line, "=", 1 )
				If pos > 0 Then
					lstr = Trim( Left( line, pos - 1 ) )
					If LCase( lstr ) = LCase( key ) Then
						tempStream.WriteLine key & "=" & val
						bWritten   = True
						bInSection = False
					End If
				End If
				If Not bWritten Then
					tempStream.WriteLine line
				End If
			Else
				tempStream.WriteLine line
				tempStream.WriteLine key & "=" & val
				bWritten = True
				bInSection = False
			End If
		Else 
			tempStream.WriteLine line
		End If
	Wend

	If Not bSectionExists Then
		tempStream.WriteLine line
		tempStream.WriteLine "[" & section & "]"
		tempStream.WriteLine key & "=" & val  
	End If 

	readStream.Close
	tempStream.Close

	fso.CopyFile tempFile, file
	fso.DeleteFile tempFile, True
	Set readStream = Nothing
	Set tempStream = Nothing
	Set fso    = Nothing
	Set wsh  = Nothing		
End Sub

' array should be something like "val1|, val2|, val3|"
Function FindInArray( ar, val )
	Dim ret, temp, v
	ret = Filter( ar, val, True, vbTextCompare )
	For Each v In ret
		temp = Left( v, InStrRev( v, "|")-1)
		If StrComp( temp, val, vbTextCompare) = 0 Then
			FindInArray = True
			Exit Function
		End If
	Next
	FindInArray = false
End Function

'##########################################################################################
' Handle java property file
'##########################################################################################

Function ReadPropertyFile( myFile, myKey )

	Dim pos
	Dim fso, textstream
	Dim file, key, lstr, line

	On Error Resume Next
	file = Trim(myFile)
	key = Trim(myKey)

	Set fso = CreateObject( "Scripting.FileSystemObject" )
	ReadPropertyFile     = ""

	Set textstream = fso.OpenTextFile( file, Read, False )
	If Err.Number <> 0 Then
		ErrorOut Err.Number, "Cannot open" & file & "," & Err.Description
	End If
	On Error Goto 0
	Do While Not textstream.AtEndOfStream
		line = Trim( textstream.ReadLine )
		pos = InStr( 1, line, "=", 1 )
		If pos > 0 Then
			lstr = Trim( Left( line, pos - 1 ) )
			If LCase( key ) = LCase( lstr ) Then
				ReadPropertyFile = Trim( Mid( line, pos + 1 ) )
				If ReadPropertyFile = "" Then
					ReadPropertyFile = " "
				End If
				' Quit loop when key is found
				Exit Do
			End If
		End If
	Loop    
	textstream.Close
End Function

'##########################################################################################
' Handle java property file
'##########################################################################################
Sub WritePropertyFile( myFile, myKey, myVal )
	Dim fso, wsh, tempFile
	Dim readStream, writeStream, tempStream, line, lstr
	Dim file, section, key, val
	Dim bKeyExist, bWritten
	Dim pos
	On Error Resume Next
	file = Trim( myFile )
	key = Trim( myKey )
	val = Trim ( myVal )


	Set fso   = CreateObject( "Scripting.FileSystemObject" )
	Set wsh = CreateObject( "WScript.Shell" )

	tempFile = fso.BuildPath( wsh.ExpandEnvironmentStrings( "%TEMP%" ), fso.GetTempName )
	'try to test write permission first
	Set writeStream = fso.OpenTextFile( file, Append, False )
	If Err.Number <> 0 Then
		ErrorOut Err.Number, "Cannot open " & file & ", " & Err.Description
	End If
	writeStream.Close
	
	Set readStream = fso.OpenTextFile( file, Read, False )

	Set tempStream = fso.CreateTextFile( tempFile, False, False )

	If Err.Number <> 0 Then
		ErrorOut Err.Number, "Cannot open " & tempFile & "," & Err.Description
	End If
	On Error Goto 0

	bWritten   = False
	bKeyExists = ( ReadPropertyFile( file, key ) <> "" )

	While Not readStream.AtEndOfStream
		line = readStream.ReadLine
		If bKeyExists and not bWritten Then
			pos = InStr( 1, line, "=", 1 )
			If pos > 0 Then
				lstr = Trim( Left( line, pos - 1 ) )
				If LCase( lstr ) = LCase( key ) Then
					tempStream.WriteLine key & "=" & val
					bWritten   = True
				End If
			End if
			If Not bWritten Then
				tempStream.WriteLine line
			End If

		Else
			tempStream.WriteLine line  
		End If
	Wend

	If Not bWritten Then 
		tempStream.WriteLine key & "=" & val
		bWritten = True
	End If 

	readStream.Close
	tempStream.Close
	If NBP_MODE = "" Then
		WScript.echo "File:" & file
	End If
	fso.CopyFile tempFile, file, True
	fso.DeleteFile tempFile, True
	Set writeStream = Nothing
	Set readStream = Nothing
	Set tempStream = Nothing
	Set fso    = Nothing
	Set wsh  = Nothing		
End Sub

'##########################################################################################
' Check if a Registry Key exists
'##########################################################################################
Function IsRegKeyExists (key)
	On Error Resume Next
	Dim OperationRegistry
	Set OperationRegistry=WScript.CreateObject("WScript.Shell")
	OperationRegistry.RegRead key
	Select Case Err
	Case 0:
		IsRegKeyExists = true
	Case &h80070002:
		ErrDescription = Replace(Err.description, key, "")
		Err.clear
		'Read in a registry entry we know doesn't exist (to create an error description for something that doesnt exist)
		OperationRegistry.RegRead "HK_ERROR\"
		If (ErrDescription <> Replace(Err.description, "HK_ERROR\", "")) Then
			IsRegKeyExists = true
		Else
			IsRegKeyExists = false
		End If
	Case Else:
		IsRegKeyExists = false
	End Select
	Debug(chr(9) & chr(9) & "IsRegKeyExists(" & key & ") = " & IsRegKeyExists)
	On Error Goto 0
End Function

'##########################################################################################
' Vista and win7 provide UAC support, this function can determine if user has disabled it or not
'##########################################################################################

Function IsUACEnabled()
	Dim wsh
	On Error Resume Next
	IsUACEnabled = False
	Set wsh = CreateObject("WScript.Shell")
	If wsh.RegRead("HKLM\Software\Microsoft\Windows\CurrentVersion\Policies\System\EnableLUA") = 1 Then
		If Err.Number = 0 Then
			IsUACEnabled = True
		End If
	End If
	Debug(chr(9) & chr(9) & "IsUACEnabled = " & IsUACEnabled)
End Function

'##################################################################################################################################################
' Even admin access in vista and win7 should get permission to do some operations, this function checks whether current process has this permission 
'##################################################################################################################################################

Function IsElevated()
	Dim wsh, fso
	IsElevated = False
	Set fso = CreateObject("Scripting.FileSystemObject")
	Set wsh = CreateObject("WScript.Shell")
	If fso.FileExists(wsh.ExpandEnvironmentStrings("%WINDIR%/System32/whoami.exe")) And wsh.Run("%comspec% /c whoami /groups | findstr /I /C:""S-1-16-12288""", 0 , True) = 0 Then
		IsElevated = True
	End If
	Debug(chr(9) & chr(9) & "IsElevated = " & IsElevated)
End Function


Function GetEveryoneName()
	Dim UserAccount
	Set UserAccount = GetObject("winmgmts://./root/cimv2").ExecQuery("Select * from Win32_SystemAccount Where SID = 'S-1-1-0'")
	For Each account in UserAccount
		GetEveryoneName = account.Name
	Next
	Debug(chr(9) & chr(9) & "GetEveryoneName = " & GetEveryoneName)
End Function
'###########################################################################################
'#									Implement
'#
'###########################################################################################


lotuskey="SOFTWARE\Lotus\Notes\"
IBMkey="SOFTWARE\IBM\Notes\"
HCLkey="SOFTWARE\HCL\Notes\"
MULTIUSER_DATAPATH = "\HCL\Notes\Data"
MULTIUSER_DATAPATH_IBM = "\IBM\Notes\Data"
MULTIUSER_DATAPATH_CLASSIC = "\Lotus\Notes\Data"
bEnableLogging = False

'##################################################################################################################################################
' File list needn't be migrated
'##################################################################################################################################################

Function GetNoMigrateFiles()
	GetNoMigrateFiles = Array("Thumbs.db|")
End Function

'##################################################################################################################################################
' Migrate default files to shared data directory
'##################################################################################################################################################

Function GetDefaultMigrateFiles()
	Dim version
	version = GetNotesVersion()
	Select Case version
	Case "6.0.0","6.0.1","6.0.2","6.0.3","6.0.4","6.0.5","6.5.0","6.5.1","6.5.2","6.5.3","6.5.4","6.5.5","6.5.6","7.0.0","7.0.1","7.0.2","7.0.3","7.0.4"
		GetDefaultMigrateFiles = Array("W32|Common", "Help|Shared","Modems|Shared", "bookmark.ntf|Shared", "browser.cnf|Common", "uk.dic|Shared", "canadien.dic|Shared", "us.dic|Shared", "unknown.gif|Common", "text.gif|Common", "sound.gif|Common", "movie.gif|Common", "image.gif|Common", "link.gif|Common", "error.gif|Common", "binary.gif|Common", "folder.gif|Common", "graphic.gif|Common","us.med|Shared", "KeyView.ini|Shared")
	Case "8.0.0", "8.0.1"
		GetDefaultMigrateFiles = Array("W32|Common", "Help|Shared","Modems|Shared", "domino|Shared", "bookmark.ntf|Shared", "browser.cnf|Common", "uk.dic|Shared", "canadien.dic|Shared", "us.dic|Shared", "unknown.gif|Common", "text.gif|Common", "sound.gif|Common", "movie.gif|Common", "image.gif|Common", "link.gif|Common", "error.gif|Common", "binary.gif|Common", "folder.gif|Common", "graphic.gif|Common", "us.med|Shared")
	Case "8.0.2"
		GetDefaultMigrateFiles = Array("W32|Common", "Help|Shared","Modems|Shared", "domino|Shared", "bookmark.ntf|Shared", "browser.cnf|Common", "uk.dic|Shared", "canadien.dic|Shared", "us.dic|Shared", "unknown.gif|Common", "text.gif|Common", "sound.gif|Common", "movie.gif|Common", "image.gif|Common", "link.gif|Common", "error.gif|Common", "binary.gif|Common", "folder.gif|Common", "graphic.gif|Common","us.med|Shared", "KeyView.ini|Shared")
	Case "8.5.0"
		GetDefaultMigrateFiles = Array( "theme|Shared", "domino|Shared", "properties|Shared", "autocorr|Shared", "W32|Common", "Help|Shared", "bookmark.ntf|Shared", "browser.cnf|Shared", "uk.dic|Shared", "canadien.dic|Shared", "us.dic|Shared", "unknown.gif|Shared", "text.gif|Shared", "sound.gif|Shared", "movie.gif|Shared", "image.gif|Shared", "link.gif|Shared", "error.gif|Shared", "binary.gif|Shared", "folder.gif|Shared", "graphic.gif|Shared", "KeyView.ini|Shared","us.med|Shared")
	Case "8.5.1", "8.5.2", "8.5.3"
		GetDefaultMigrateFiles = Array( "theme|Shared", "domino|Shared", "properties|Shared", "autocorr|Shared", "W32|Shared", "Help|Shared", "bookmark.ntf|Shared", "browser.cnf|Shared", "uk.dic|Shared", "canadien.dic|Shared", "us.dic|Shared", "unknown.gif|Shared", "text.gif|Shared", "sound.gif|Shared", "movie.gif|Shared", "image.gif|Shared", "link.gif|Shared", "error.gif|Shared", "binary.gif|Shared", "folder.gif|Shared", "graphic.gif|Shared", "KeyView.ini|Shared","us.med|Shared")
	Case Else
		GetDefaultMigrateFiles = Array( "theme|Shared", "domino|Shared", "properties|Shared", "autocorr|Shared", "W32|Shared", "Help|Shared", "bookmark.ntf|Shared", "browser.cnf|Shared", "uk.dic|Shared", "canadien.dic|Shared", "us.dic|Shared", "unknown.gif|Shared", "text.gif|Shared", "sound.gif|Shared", "movie.gif|Shared", "image.gif|Shared", "link.gif|Shared", "error.gif|Shared", "binary.gif|Shared", "folder.gif|Shared", "graphic.gif|Shared", "KeyView.ini|Shared","us.med|Shared")
	End Select

End Function

'##################################################################################################################################################
' Migrate files to mui folder in shared data directory
'##################################################################################################################################################

Function GetMUIDataFiles()
	Dim version
	version = GetNotesVersion()
	Select Case version
	Case "6.5.6", "7.0.0","7.0.1","7.0.2", "7.0.3","7.0.4"
		GetMUIDataFiles = Array("Help|", "Modems|", "canadien.dic|", "uk.dic|", "us.dic|", "us.med|", "bookmark.ntf|")
	Case "8.0.0"
		GetMUIDataFiles = Array("Help|", "Modems|", "canadien.dic|", "uk.dic|", "us.dic|", "us.med|", "bookmark.ntf|")
	Case "8.0.1","8.0.2"
		GetMUIDataFiles = Array("domino|", "Help|", "Modems|", "canadien.dic|", "uk.dic|", "us.dic|", "us.med|", "bookmark.ntf|")
	Case "8.5.0", "8.5.1"
		GetMUIDataFiles = Array("domino|", "Help|", "Theme|", "canadien.dic|", "uk.dic|", "us.dic|", "us.med|", "bookmark.ntf|")
	Case "8.5.2"
		GetMUIDataFiles = Array("autocorr|", "domino|", "Help|", "Theme|", "W32|", "binary.gif|", "browser.cnf|", "canadien.dic|", "error.gif|", "folder.gif|", "graphic.gif|", "image.gif|", "keyview.ini|", "link.gif|", "movie.gif|", "sound.gif|", "text.gif|", "uk.dic|", "unknown.gif|", "us.dic|", "us.med|", "bookmark.ntf|")
	Case Else
		GetMUIDataFiles = Array("domino|", "Help|", "Theme|", "canadien.dic|", "uk.dic|", "us.dic|", "us.med|", "bookmark.ntf|")
	End Select
End Function

'##################################################################################################################################################
' file will be migrated to "shared data directory/Common" 
'##################################################################################################################################################

Function IsTargetCommon(fileList, file)
	Dim ret, v, target
	Dim offset
	IsTargetCommon = False
	ret = Filter( fileList, file, True, 0 )
	For Each v In ret
		offset = InStrRev(v, "|")
		temp = Left( v, offset-1)
		If temp = file Then
			target = Right(v, Len(v) - offset)
			If StrComp( target, "Common", vbTextCompare) = 0 Then
				IsTargetCommon = True
			End If
		End If
	Next
	Debug(chr(9) & chr(9) & "IsTargetCommon(" & file & ") = " & IsTargetCommon)
End Function

'##################################################################################################################################################
' Check for Allclient Kit which is not supported by this tool
'##################################################################################################################################################
Function IsAllClient()
	IsAllClient = FALSE
	Dim fso, designer, admin
	Set fso = CreateObject("Scripting.FileSystemObject")
	designer = fso.FileExists( NotesProgram & "\designer.exe")
	admin = fso.FileExists( NotesProgram & "\admin.exe")
	installType = ReadIni(inifile, "Notes", "InstallType")
	IsAllClient = designer Or admin Or installType = "2"
	Debug(chr(9) & chr(9) & "IsAllClient = " & IsAllClient)
End Function

Function IsStandardClient()
	Set fso = CreateObject("Scripting.FileSystemObject")
	IsStandardClient  = fso.FolderExists( NotesProgram & "\framework" )
	Debug(chr(9) & chr(9) & "IsStandardClient = " & IsStandardClient)
End Function

Function IsMUIClient()
	IsMUIClient = FALSE
	Set fso = CreateObject("Scripting.FileSystemObject")
	If fso.FolderExists( NotesProgram & "\mui" ) Then
		IsMUIClient  =  fso.GetFolder(NotesProgram & "\mui").SubFolders.Count > 0
	End If
	Debug(chr(9) & chr(9) & "IsMUIClient = " & IsMUIClient)
End Function

Function IsMultiUserMode()
	Dim OperationRegistry
	Set OperationRegistry= WScript.CreateObject("WScript.Shell")
	IsMultiUserMode = ( OperationRegistry.RegRead("HKEY_LOCAL_MACHINE\" & lotuskey & "\MultiUser") = 1 )
	Debug(chr(9) & chr(9) & "IsMultiUserMode = " & IsMultiUserMode)
End Function

'##################################################################################################################################################
' Get the Notes version
'##################################################################################################################################################
Function GetNotesVersion()
	Dim fso, version, split
	Set fso = CreateObject("Scripting.FileSystemObject")
	version = fso.GetFileVersion(NotesProgram & "\notes.exe")
	Debug(chr(9) & chr(9) & "Get notes.exe version : " & version)
	'The format of Notes.exe is like "9.x.x.xxxxx" or "10.x.x.xxxxx", so find the 2nd char to see if a dot.
	'If so, Notes version will be "10.x.x", otherwise Notes version should be "9.x.x".
	split = Mid(version, 2, 1)
	If split = "." Then
		GetNotesVersion = Left(version, 5)
	Else
		split = Mid(version, 3, 1)
		If split = "." Then
			GetNotesVersion = Left(version, 6)
		Else
			ErrorOut 1, "Get Notes version failed"
		End If
	End If
	Debug(chr(9) & chr(9) & "GetNotesVersion = " & GetNotesVersion)
End Function

Function GetNotesMajorVersion()
	Dim version
	version = GetNotesVersion()
	If Len(version) = 5 Then
		GetNotesMajorVersion = Left(version, 1)
	Else
		GetNotesMajorVersion = Left(version, 2)
	End If
	Debug(chr(9) & chr(9) & "GetNotesMajorVersion = " & GetNotesMajorVersion)
End Function

'##################################################################################################################################################
' Check if this is Notes 8.0 version or higher
'##################################################################################################################################################

Function IsNotes80()
	IsNotes80 = False
	If StrComp("8.0.0", GetNotesVersion() ) = 0 Then
		IsNotes80 = True
	End If
	Debug(chr(9) & chr(9) & "IsNotes80 = " & IsNotes80)
End Function

Function IsDefaultMultiUserCommonDir()
	Dim oshell, wsh
	Set oshell = CreateObject("shell.application")
	Set wsh = CreateObject( "WScript.Shell" )
	IsDefaultMultiUserCommonDir = False
	If StrComp(wsh.ExpandEnvironmentStrings(MultiUserCommonDir), oshell.NameSpace(CSIDL_COMMON_APPDATA).self.path & MultiUserDataPath, vbTextCompare) = 0 Then
		IsDefaultMultiUserCommonDir = True
	End If
	Debug(chr(9) & chr(9) & "IsDefaultMultiUserCommonDir = " & IsDefaultMultiUserCommonDir)
End Function

Function IsDefaultMultiUserBaseDir()
	Dim oshell,wsh
	Set oshell = CreateObject("shell.application")
	Set wsh = CreateObject( "WScript.Shell" )
	IsDefaultMultiUserBaseDir = False
	If StrComp(wsh.ExpandEnvironmentStrings(MultiUserBaseDir), oshell.NameSpace(CSIDL_LOCAL_APPDATA).self.path & MultiUserDataPath, vbTextCompare) = 0 Then
		IsDefaultMultiUserBaseDir = True
	End If
	Debug(chr(9) & chr(9) & "IsDefaultMultiUserBaseDir = " & IsDefaultMultiUserBaseDir)
End Function

'##################################################################################################################################################
' Construct rcpdata property based on current configuration
'##################################################################################################################################################


Function GetRcpData( baseDir )
	Dim oshell, wsh, i, inPercent
	Set oshell = CreateObject("shell.application")
	Set wsh = CreateObject( "WScript.Shell" )
	GetRcpData = ""
	If StrComp(baseDir, oshell.NameSpace(CSIDL_LOCAL_APPDATA).self.path & MultiUserDataPath, vbTextCompare) = 0 Then
		'it is default multiuser base dir, so return default multiuser rcp data dir
		Dim fstr
		fstr = wsh.ExpandEnvironmentStrings("%USERPROFILE%")
		GetRcpData = Replace( Replace(baseDir, fstr, "${env.USERPROFILE}", 1, -1, vbTextCompare), "\", "/", 1, -1, vbTextCompare) & "/workspace"
	Else
		inPercent = False
		For i = 1 to Len(baseDir)
			Dim char
			char = Mid(baseDir, i, 1)
			If char = "%" Then
				If Not inPercent Then
					GetRcpData = GetRcpData & "${env."
				Else
					GetRcpData = GetRcpData & "}"
				End If
				inPercent = Not inPercent
			Else
				If char = "\" Then
					GetRcpData = GetRcpData & "/"
				Else
					GetRcpData = GetRcpData & char
				End If
			End If
		Next
		GetRcpData = GetRcpData & "/workspace"
	End If
	Debug(chr(9) & chr(9) & "GetRcpData = " & GetRcpData)
End Function

'#################################################################################################################################################################
' User may run this script with "RunAs", so "HKCU" will not point to real current user who runs the script, this function will return the correct key in that case
'#################################################################################################################################################################

Function GetCurrentUserKey()
	Dim fso, wsh,oshell, wshNetwork
	Set fso   = CreateObject( "Scripting.FileSystemObject" )
	Set wsh = CreateObject( "WScript.Shell" )
	Set wshNetwork = CreateObject("WScript.Network")

	Set UserAccount = GetObject("winmgmts://./root/cimv2").Get("Win32_UserAccount.Domain='" & wshNetwork.UserDomain & "'" & ",Name='" & wsh.ExpandEnvironmentStrings("%USERNAME%") & "'")
	GetCurrentUserKey = "HKEY_USERS\" & UserAccount.SID & "\"
	Debug(chr(9) & chr(9) & "GetCurrentUserKey = " & GetCurrentUserKey)
End Function

'##################################################################################################################################################
' Function to create a backup of the user's data directory
'##################################################################################################################################################
Function BackupUserData()
	Debug("BackupUserData Begin")
	Dim fso, wsh,oshell, desktop, startmenu

	Set fso   = CreateObject( "Scripting.FileSystemObject" )
	Set wsh = CreateObject( "WScript.Shell" )
	Set oshell = CreateObject("shell.application")
	BackupDirectory = fso.BuildPath( wsh.ExpandEnvironmentStrings( "%TEMP%" ), fso.GetTempName )
	Debug(chr(9) & chr(9) & "Backup folder : " & BackupDirectory)
	If Not DryRun Then
		CreateFolder fso, BackupDirectory
	End If
	'Backup notes.ini
	Debug(chr(9) & chr(9) & "Copying notes.ini")
	If Not DryRun Then
		fso.CopyFile inifile, BackupDirectory & "\notes.ini"
	End If

	'Backup rcplauncher.properties
	If ( IsStandardClient() ) Then 
		Debug(chr(9) & chr(9) & "Copying rcplauncher.properties")
		If Not DryRun Then
			fso.CopyFile NotesProgram & "\framework\rcp\rcplauncher.properties", BackupDirectory & "\rcplauncher.properties"
		End If
	End If 

	'Backup user data
	Debug(chr(9) & chr(9) & "Copying user data")
	If Not DryRun Then
		If fso.GetFolder(CurrentDataDirectory).IsRootFolder Then
			CreateFolder fso, BackupDirectory & "\Data"
			fso.CopyFolder CurrentDataDirectory & "\*", BackupDirectory & "\Data"
			fso.CopyFile CurrentDataDirectory & "\*", BackupDirectory & "\Data"
		Else
			fso.CopyFolder CurrentDataDirectory, BackupDirectory & "\"
		End If
	End If
	
	'Backup shortcut
	Debug(chr(9) & chr(9) & "Copying shortcut")
	If Not DryRun Then
		CreateFolder fso, BackupDirectory & "\Shortcuts\Desktop\Common" 
		CreateFolder fso, BackupDirectory & "\Shortcuts\Startmenu\Common" 
	
		desktop = oshell.NameSpace(CSIDL_COMMON_DESKTOPDIRECTORY).self.path
		startmenu = oshell.NameSpace(CSIDL_COMMON_PROGRAMS).self.path

		For Each file in fso.GetFolder(desktop).Files
			If LCase(fso.GetExtensionName(file)) = "lnk" And (Left(fso.GetBaseName(file),11) = "Lotus Notes" Or Left(fso.GetBaseName(file),9) = "IBM Notes" Or Left(fso.GetBaseName(file),9) = "HCL Notes") Then
				Debug(chr(9) & chr(9) & " Copying shortcut " & file)
				fso.CopyFile file, BackupDirectory & "\Shortcuts\Desktop\Common\"
			End If
		Next
		For Each folder in fso.GetFolder(startmenu).SubFolders
			if Left(folder.name, 5) = "Lotus" Or Left(folder.name, 16) = "IBM Applications" Or Left(folder.name, 16) = "HCL Applications" Then
				Debug(chr(9) & chr(9) & " Copying shortcut foler" & folder)
				fso.CopyFolder folder, BackupDirectory & "\Shortcuts\Startmenu\common\"
			End If
		Next
	End If
	
	If IsNotes80() And IsStandardClient() Then
		If Not DryRun Then
			'8.0 Standard version only, this version install shortcut to user's desktop rather than common desktop
			desktop = oshell.NameSpace(CSIDL_DESKTOPDIRECTORY).self.path
			startmenu = oshell.NameSpace(CSIDL_PROGRAMS).self.path
			CreateFolder fso, wsh.ExpandEnvironmentStrings(BackupDirectory & "\Shortcuts\Desktop\%USERNAME%" )
			CreateFolder fso, wsh.ExpandEnvironmentStrings(BackupDirectory & "\Shortcuts\Startmenu\%USERNAME%")
		
			For Each file in fso.GetFolder(desktop).Files
				If LCase(fso.GetExtensionName(file)) = "lnk" And Left(fso.GetBaseName(file),5) = "Lotus" Then
					Debug(chr(9) & chr(9) & " Copying shortcut " & file)
					fso.CopyFile file, wsh.ExpandEnvironmentStrings(BackupDirectory & "\Shortcuts\Desktop\%USERNAME%\")
				End If
			Next
			For Each folder in fso.GetFolder(startmenu).SubFolders
				if Left(folder.name, 5) = "Lotus" Then
					Debug(chr(9) & chr(9) & " Copying shortcut foler" & folder)
					fso.CopyFolder folder, wsh.ExpandEnvironmentStrings(BackupDirectory & "\Shortcuts\Startmenu\%USERNAME%\")
				End If
			Next
		
			For Each file in fso.GetFolder(startmenu).Files
				If LCase(fso.GetExtensionName(file)) = "lnk" And Left(fso.GetBaseName(file),5) = "Lotus" Then
					Debug(chr(9) & chr(9) & " Copying shortcut " & file)
					fso.CopyFile file, wsh.ExpandEnvironmentStrings(BackupDirectory & "\Shortcuts\Startmenu\%USERNAME%\")
				End If
			Next
		End If
	End If
	
	Debug("BackupUserData End")

End Function
'##################################################################################################################################################
' Function to restore user's data directory
'##################################################################################################################################################
Function RestoreUserData()
	Debug("RestoreUserData Begin")
	On Error Resume Next 
	Dim fso,oshell, wsh, desktop, failedList, file, folder
	Set fso   = CreateObject( "Scripting.FileSystemObject" )
	Set oshell = CreateObject("shell.application")
	Set wsh = CreateObject( "WScript.Shell" )
	Err.clear
	'restore notes.ini
	Debug(chr(9) & chr(9) & "Restoring " & inifile)
	fso.CopyFile BackupDirectory & "\notes.ini", inifile,  True
	wsh.run "cacls """ & inifile & " "" /T /E /P " & GetEveryoneName() & ":F"
	If Err.Number <> 0 Then
		Warn "Cannot restore notes.ini:" & Err.Description
		failedList = failedList & "notes.ini,"
		Err.clear
	End If 


	'restore rcplauncher.properties
	If ( IsStandardClient() ) Then 
		Debug(chr(9) & chr(9) & "Restoring " & NotesProgram & "\framework\rcp\rcplauncher.properties")
		fso.CopyFile BackupDirectory & "\rcplauncher.properties", NotesProgram & "\framework\rcp\rcplauncher.properties", True
		If Err.Number <> 0 Then 
				Warn "Cannot restore rcplauncher.properties:" & Err.Description
				Err.clear
				failedList = failedList & "rcplauncher.properties,"
		End If 
	End If 



	'restore user data
	Debug(chr(9) & chr(9) & "Restoring user data")
	
	For Each file in fso.GetFolder(BackupDirectory & "\Data\").Files
		Debug(chr(9) & chr(9) & " Restoring " & CurrentDataDirectory & "\" & fso.GetFileName(file) )
		fso.CopyFile file, CurrentDataDirectory & "\", True
		If Err.Number <> 0 Then 
				Warn "Cannot restore " & fso.GetFileName(file) & ":" & Err.Description
				Err.clear
				failedList = failedList & fso.GetFileName(file) & ","
		End If
	Next
	For Each folder in fso.GetFolder(BackupDirectory & "\Data\").SubFolders
		Debug(chr(9) & chr(9) & " Restoring " & CurrentDataDirectory & "\" & folder.Name)
		fso.CopyFolder folder, CurrentDataDirectory & "\", True
		If Err.Number <> 0 Then 
				Warn "Cannot restore " & folder.Name & ":" & Err.Description
				Err.clear
				failedList = failedList & folder.Name & "\,"
		End If
	Next
	
	'restore shortcut
	Debug(chr(9) & chr(9) & "Restoring shortcut")

	
	desktop = oshell.NameSpace(CSIDL_COMMON_DESKTOPDIRECTORY).self.path
	startmenu = oshell.NameSpace(CSIDL_COMMON_PROGRAMS).self.path



	For Each file in fso.GetFolder(BackupDirectory & "\Shortcuts\Desktop\common").Files
		If LCase(fso.GetExtensionName(file)) = "lnk" And (Left(fso.GetBaseName(file),11) = "Lotus Notes" Or Left(fso.GetBaseName(file),9) = "IBM Notes" Or Left(fso.GetBaseName(file),9) = "HCL Notes") Then
			Debug(chr(9) & chr(9) & " Restoring shortcut " & desktop & "\" & fso.GetFileName(file))
			fso.CopyFile file, desktop & "\", True
		End If
	Next
	
	For Each folder in fso.GetFolder(BackupDirectory & "\Shortcuts\Startmenu\common").SubFolders
		if Left(folder.name, 5) = "Lotus" Or Left(folder.name, 16) = "IBM Applications" Or Left(folder.name, 16) = "HCL Applications" Then
			Debug(chr(9) & chr(9) & " Restoring shortcut folder " & startmenu & "\" & folder.Name)
			fso.CopyFolder folder, startmenu & "\", True
			If Err.Number <> 0 Then 
					Warn "Cannot restore " & folder.Name & ":" & Err.Description
					Err.clear
					failedList = failedList & folder.Name & "\,"
			End If
		End If
	Next
	
	If IsNotes80() and IsStandardClient() Then
		'8.0 Standard version only, this version install shortcut to user's desktop rather than common desktop
		desktop = oshell.NameSpace(CSIDL_DESKTOPDIRECTORY).self.path
		startmenu = oshell.NameSpace(CSIDL_PROGRAMS).self.path
		For Each file in fso.GetFolder(oshell.NameSpace(CSIDL_COMMON_DESKTOPDIRECTORY).self.path).Files
			If LCase(fso.GetExtensionName(file)) = "lnk" And Left(fso.GetBaseName(file),5) = "Lotus" Then
				If fso.FileExists(wsh.ExpandEnvironmentStrings(BackupDirectory & "\Shortcuts\Desktop\%USERNAME%\" & fso.GetFileName(file))) Then
					fso.DeleteFile file
				End If
			End If
		Next
		Dim notesFolder
		For Each folder in fso.GetFolder(oshell.NameSpace(CSIDL_COMMON_PROGRAMS).self.path).SubFolders
			notesFolder = False
			if Left(folder.name, 5) = "Lotus" Then
				For Each file in folder.Files
					If LCase(fso.GetExtensionName(file)) = "lnk" And Left(fso.GetBaseName(file),11) = "Lotus Notes" Then
						notesFolder = True
						Exit For
					end if
				Next
			End If
			If notesFolder Then
				fso.DeleteFolder folder
			End If
		Next
		
		For Each file in fso.GetFolder(oshell.NameSpace(CSIDL_COMMON_PROGRAMS).self.path).Files
			If LCase(fso.GetExtensionName(file)) = "lnk" And Left(fso.GetBaseName(file),5) = "Lotus" Then
				If fso.FileExists(wsh.ExpandEnvironmentStrings(BackupDirectory & "\Shortcuts\Startmenu\%USERNAME%\" & fso.GetFileName(file))) Then
					fso.DeleteFile file
				End If
			End If
		Next
		For Each file in fso.GetFolder(wsh.ExpandEnvironmentStrings(BackupDirectory & "\Shortcuts\Desktop\%USERNAME%")).Files
			If LCase(fso.GetExtensionName(file)) = "lnk" And Left(fso.GetBaseName(file),5) = "Lotus" Then
				Debug(chr(9) & chr(9) & " Restoring shortcut " & desktop & "\" & fso.GetFileName(file))
				fso.CopyFile file, desktop & "\", True
			End If
		Next

		For Each folder in fso.GetFolder(wsh.ExpandEnvironmentStrings(BackupDirectory & "\Shortcuts\Startmenu\%USERNAME%")).SubFolders
			if Left(folder.name, 5) = "Lotus" Then
				Debug(chr(9) & chr(9) & " Restoring shortcut foler" & startmenu & "\" & folder.Name)
				fso.CopyFolder folder, startmenu & "\", True
			End If
		Next
		
		For Each file in fso.GetFolder(wsh.ExpandEnvironmentStrings(BackupDirectory & "\Shortcuts\Startmenu\%USERNAME%")).Files
			If LCase(fso.GetExtensionName(file)) = "lnk" And Left(fso.GetBaseName(file),5) = "Lotus" Then
				Debug(chr(9) & chr(9) & " Restoring shortcut " & desktop & "\" & fso.GetFileName(file))
				fso.CopyFile file, desktop & "\", True
			End If
		Next
		
	End If
	
	If failedList <> "" Then
		NeedRestore = False
		Warn "Following files or folders cannot be restored, you will need to restore it from " & BackupDirectory & " manually: "
		Warn chr(9) & chr(9) & failedList
		ErrorOut 1, "RestoreUserData failed"
	End If

	' try to delete directory and files, but not terminate MUMA if error occurs.
	Dim dir
	dir = wsh.ExpandEnvironmentStrings(MultiUserCommonDir)
	If MIGRATE_SHARED_DIR And CurrentDataDirectory <> dir Then
		Debug(chr(9) & chr(9) & "Cleaning " & dir)
		fso.DeleteFolder dir, True
		If Err.Number <> 0 Then 
					Warn "Cannot clean folder " & dir & ":" & Err.Description
					Err.clear
		End If
	End If
	dir = wsh.ExpandEnvironmentStrings(MultiUserBaseDir)
	If MIGRATE_USERDATA_DIR And CurrentDataDirectory <> dir Then
		Debug(chr(9) & chr(9) & "Cleaning " & dir)
		fso.DeleteFolder dir, True
		If Err.Number <> 0 Then 
				Warn "Cannot clean folder " & dir & ":" & Err.Description
				Err.clear
		End If
	End If
	Debug(chr(9) & chr(9) & "Restore sucessfully, backup folder " & BackupDirectory & " will not be deleted until your next system restart.")
	On Error Goto 0

	Debug("RestoreUserData End")
End Function

'##################################################################################################################################################
' Creating backup of the registry
'##################################################################################################################################################
Function BackupRegistry()
	Debug("BackupRegistry Begin")
	Dim wsh
	Set wsh = CreateObject( "WScript.Shell" )
	wsh.Run("reg.exe export hklm\software\lotus\notes " & BackupDirectory & "\backup.reg")
	Debug("BackupRegistry End")
End Function

'##################################################################################################################################################
' Restore the registry
'##################################################################################################################################################
Function RestoreRegistry()
	Debug("RestoreRegistry Begin")
	Dim wsh
	Set wsh = CreateObject( "WScript.Shell" )
	wsh.Run("reg.exe import " & BackupDirectory & "\backup.reg")
	Debug("RestoreRegistry End")
End Function

Function GetMUIFolder()
	Dim fso 
	Set fso = CreateObject("Scripting.FileSystemObject")
	For Each folder in  fso.GetFolder(NotesProgram & "\mui\").SubFolders
		GetMUIFolder = "mui\" & folder.Name
	Next 
	Debug(chr(9) & chr(9) & "GetMUIFolder = " & GetMUIFolder )
End Function

'##################################################################################################################################################
' MUI kits put language files(template, dictionary, etc..) in mui folder, and English files in shared data folder, but there are no English files in single user mode, so we just do a copy between shared data and mui data. This function will copy the directory/file specified by path to mui folder. 
'##################################################################################################################################################
Function CopyDataToMUIFolder( path )
	Dim fso, wsh, muifolder
	Set fso = CreateObject("Scripting.FileSystemObject")
	Set wsh = CreateObject( "WScript.Shell" )
	muifolder = GetMUIFolder()
	If Not DryRun Then
		If Not fso.FolderExists( wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & "\shared\" & muifolder ) Then
			CreateFolder fso,wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & "\shared\" & muifolder 
		End If
	End If
	If fso.FolderExists(path) Then
		Debug(chr(9) & chr(9) & "Copying folder " & path & " to " & wsh.ExpandEnvironmentStrings( MultiUserCommonDir) & "\shared\" & muifolder & "\")
		If Not DryRun Then
			Dim dir
			dir =  fso.GetFileName(path)
			Select Case dir
			Case "Help"
				CreateFolder fso, wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & "\shared\" & muifolder & "\Help"
				fso.CopyFile path & "\*help*.nsf", wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & "\shared\" & muifolder & "\Help\", True
				' Copy readme.nsf in ja kit
				If StrComp( "mui\ja", muifolder, vbTextCompare ) = 0 and fso.FileExists( path & "\readme.nsf" ) Then
					fso.CopyFile path & "\readme.nsf", wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & "\shared\" & muifolder & "\Help\", True
				End If
				If fso.FileExists( path & "\readme.html" ) Then
					fso.CopyFile path & "\readme.html", wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & "\shared\" & muifolder & "\Help\", True
				End If
			Case "domino"
				CreateFolder fso, wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & "\shared\" & muifolder & "\domino"
				fso.CopyFolder path & "\icons", wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & "\shared\" & muifolder & "\domino\", True
		 	Case Else 
				fso.CopyFolder path, wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & "\shared\" & muifolder & "\", True
			End Select
		End If
	ElseIf fso.FileExists( path ) Then
		Debug(chr(9) & chr(9) & "Copying file " & path & " to " & wsh.ExpandEnvironmentStrings( MultiUserCommonDir) & "\shared\" & muifolder & "\")
		If Not DryRun  Then
			fso.CopyFile path, wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & "\shared\" & muifolder & "\", True
		End If
	End If
End Function

'##################################################################################################################################################
' Read the config file
'##################################################################################################################################################

Function ReadConfiguration()
	Debug("ReadConfiguration Begin")
	Dim configurationFile, fso, oshell,wsh, needRelaunch, host
	Dim i, pos, key, val
	Set fso = CreateObject("Scripting.FileSystemObject")
	Set oshell = CreateObject("shell.application")
	Set wsh =  CreateObject("WScript.Shell")
	Set WshProcEnv = wsh.Environment("Process")
	
	On Error Resume Next
	Err.clear

	'process command line arguments first
	For i = 0 to WScript.Arguments.Count-1
		pos = InStr( 1, WScript.Arguments(i), "=", 1 )
		If pos > 0 Then
			key = Trim( Left( WScript.Arguments(i), pos - 1 ) )
			val = Trim( Mid( WScript.Arguments(i), pos + 1 ) ) 
			Select Case UCase(key)
				Case "MIGRATE_REGISTRY"
					MIGRATE_REGISTRY = val
				Case "MIGRATE_USER_REGISTRY"
					MIGRATE_USER_REGISTRY = val
				Case "MIGRATE_SHARED_DIR"
					MIGRATE_SHARED_DIR = val
				Case "MIGRATE_USERDATA_DIR"
					MIGRATE_USERDATA_DIR = val
				Case "IS_SIMULATED_MODE"
					IS_SIMULATED_MODE = val
				Case "MIGRATE_SHARED_FILES"
					MIGRATE_SHARED_FILES = val
				Case "DRYRUN"
					DryRun = val
				Case "NBP_MODE"
					NBP_MODE = val
				Case Else
					Warn "Ignore unknown argument " & WScript.Arguments(i)
			End Select
		Else
			pos = InStr( 1, WScript.Arguments(i), "-", 1 )
			If pos > 0 Then
				key = Trim( Right(WScript.Arguments(i),  Len(WScript.Arguments(i)) - pos ) ) 
				Select Case LCase(key)
					Case "silent"
						SILENT_MODE = true
				End Select
			Else
				wscript.Echo "Ignore argument " & WScript.Arguments(i) 
			End If
		End If
	Next
	
	LogFile = oshell.NameSpace(CSIDL_PERSONAL).self.path & "\HCLNotesInstall.log" 
	
	If fso.FileExists(LogFile) Then
		Set textstream = fso.OpenTextFile(LogFile, Append, False)
	Else
		Set textstream = fso.CreateTextFile(LogFile, False, False)
	End If
	If Err.Number <> 0 Then
		ErrorOut 1, chr(9) & chr(9) & "Cannot open " & LogFile & " because of " & Err.Description
	End If
	'Start logging from here since we get the log file name
	bEnableLogging = True
	textstream.Close
	
	
	If configurationFile = "" Then
		If NBP_MODE = "" Then
			configurationFile = fso.GetParentFolderName(WScript.ScriptFullName) & "\MUMigrationAssistant.ini"
		Else
			configurationFile = fso.GetParentFolderName(WScript.ScriptFullName) & "\nbpwm.ini"
		End If
	End If
	
	'try to read ini configuration file
	Set textstream = fso.OpenTextFile( configurationFile, Read, false )
	
	If Err.Number <> 0 Then
		ErrorOut 1, chr(9) & chr(9) & "Cannot open " & configurationFile & " because of " & Err.Description
	End If
	
	textstream.Close
	
	
	Debug(chr(9) & chr(9) & "Using configuration file : " & configurationFile )
	
	If MIGRATE_REGISTRY = "" Then
		MIGRATE_REGISTRY = ReadIni( configurationFile, "Notes", "MIGRATE_REGISTRY")
	End If
	
	If MIGRATE_USER_REGISTRY = "" Then
		MIGRATE_USER_REGISTRY = ReadIni( configurationFile, "Notes", "MIGRATE_USER_REGISTRY")
	End If

	If MIGRATE_SHARED_DIR = "" Then
		MIGRATE_SHARED_DIR = ReadIni( configurationFile, "Notes", "MIGRATE_SHARED_DIR")
	End If

	If MIGRATE_USERDATA_DIR = "" Then
		MIGRATE_USERDATA_DIR = ReadIni( configurationFile, "Notes", "MIGRATE_USERDATA_DIR")
	End If

	If MIGRATE_SHARED_FILES = "" Then
		MIGRATE_SHARED_FILES = ReadIni( configurationFile, "Notes", "MIGRATE_SHARED_FILES")
	End If
	

	If IS_SIMULATED_MODE = "" Then
		IS_SIMULATED_MODE = ReadIni(configurationFile, "Notes", "IS_SIMULATED_MODE")
	End If

	If MIGRATE_REGISTRY = "" Then
		MIGRATE_REGISTRY = True
	End If
	
	Debug(chr(9) & chr(9) & "MIGRATE_REGISTRY = " & MIGRATE_REGISTRY)
	
	If MIGRATE_USER_REGISTRY = "" Then
		MIGRATE_USER_REGISTRY = True
	End If

	Debug(chr(9) & chr(9) & "MIGRATE_USER_REGISTRY = " & MIGRATE_USER_REGISTRY)
	
	If MIGRATE_SHARED_DIR = "" Then
		MIGRATE_SHARED_DIR = True
	End If

	Debug(chr(9) & chr(9) & "MIGRATE_SHARED_DIR = " & MIGRATE_SHARED_DIR)

	If MIGRATE_USERDATA_DIR = "" Then
		MIGRATE_USERDATA_DIR = True
	End If

	Debug(chr(9) & chr(9) & "MIGRATE_USERDATA_DIR = " & MIGRATE_USERDATA_DIR)
	
	If IS_SIMULATED_MODE = "" Then
		IS_SIMULATED_MODE = False
	End If
	
	Debug(chr(9) & chr(9) & "IS_SIMULATED_MODE = " & IS_SIMULATED_MODE)
	
	'this tools need to be relaunched in 2 cases: 
	'one is user execute this tool with 64-bit cscript.exe, notes installer is 32-bit, so we need to use 32-bit cscript.exe to relaunch this tool
	'one is user has enabled UAC, we should relaunch this tool to trigger UAC
	host = wsh.ExpandEnvironmentStrings("%WINDIR%\system32\cscript.exe")
	If Not WshProcEnv("PROCESSOR_ARCHITECTURE") = "x86" Then
		host = wsh.ExpandEnvironmentStrings("%WINDIR%\syswow64\cscript.exe")
		needRelaunch = True
	End If
	If Not (IS_SIMULATED_MODE And (Not MIGRATE_REGISTRY) And (Not MIGRATE_SHARED_DIR)) Then
		If IsUACEnabled() And (Not IsElevated() ) Then
			needRelaunch = True
		End If
	End If
	
	If needRelaunch Then
		Dim Arguments, oExec
		For i = 0 to WScript.Arguments.Count-1
			Arguments = Arguments & " """ & WScript.Arguments(i) & """ "
		Next
		
		Debug(chr(9) & chr(9) & "Using following command to relaunch this script: ")
		Debug(chr(9) & chr(9) & host & " " & WScript.ScriptFullName & " " & Arguments)
		If IS_SIMULATED_MODE And (NOT MIGRATE_REGISTRY) And (NOT MIGRATE_SHARED_DIR) Then
			oshell.ShellExecute host, WScript.ScriptFullName & " " & Arguments, "", "", 1
		Else
			oshell.ShellExecute host, WScript.ScriptFullName & " " & Arguments, "", "runas", 1
		End If
		WScript.Quit 0
	End If

	' display the progress bar after any potential relaunches
	pb.Show()
	pb.Update(10)
	
	If NotesProgram = "" Then
		NotesProgram = ReadIni( configurationFile, "Notes", "NOTESPROGRAM")
	End If
	If NotesProgram = "" Then
		NotesProgram = wsh.RegRead("HKEY_LOCAL_MACHINE\" & lotuskey & "\Path")		
	End If
	
	If Not fso.FolderExists(NotesProgram) Then	
		ErrorOut 1,"NotesProgram " & NotesProgram & "doesn't exist."
	End If
	If Not fso.FileExists(NotesProgram & "\notes.exe") Then	
		ErrorOut 1, "NotesProgram " & NotesProgram & "isn't validated."
	End If
	Debug(chr(9) & chr(9) & "NotesProgram = " & NotesProgram)
	
	NotesMajorVersion = GetNotesMajorVersion()
		
	If inifile = "" Then
		inifile = ReadIni( configurationFile, "Notes", "CURRENTINIPATH")
	End If
	
	If inifile = "" Then
		Debug(chr(9) & chr(9) & "No ini file set, using default location")
		inifile = NotesProgram & "notes.ini" 
	End If
	Debug(chr(9) & chr(9) & "Ini file is set to " & inifile)
		
	Debug(chr(9) & chr(9) & "MultiUserBaseDir = " & MultiUserBaseDir)
	If MultiUserBaseDir = "" Then 
		MultiUserBaseDir = ReadIni( configurationFile, "Notes", "MULTIUSERBASEDIR")
	End If
	If MultiUserBaseDir = "" Then
		Debug(chr(9) & chr(9) & "MultiUserBaseDir isn't set, using default location")
	End If
	If MultiUserCommonDir = "" Then
		MultiUserCommonDir = ReadIni( configurationFile, "Notes", "MULTIUSERCOMMONDIR")
	End If
	If MultiUserCommonDir = "" Then
		Debug(chr(9) & chr(9) & "MultiUserCommonDir isn't set, using default location")
	End If

	If DryRun = "" Then
		DryRun = ReadIni( configurationFile, "Notes", "DRYRUN")
	End If
	
	If DryRun = "" or DryRun = " "  Then
		DryRun = True
	Else 
		If DryRun = "0" Then
			DryRun = False
		End If
		If DryRun = "1" Then
			DryRun = True
		End If
	End If

	Debug("ReadConfiguration End")
End Function


Function CheckConfiguration()
	Debug("CheckConfiguration Begin")
	
	Dim fso, oshell, wsh, pList, done, version, classic
	Set fso = CreateObject("Scripting.FileSystemObject")
	Set oshell = CreateObject("shell.application")
	Set wsh = CreateObject("WScript.Shell")
	done = False
	pList = Array("notes.exe|","nlnotes.exe|","notes2w.exe|")
	On Error Resume Next	
	For Each ps in getobject("winmgmts:\\.\root\cimv2:win32_process").instances_
		Dim pUser, pDomain, ret
		ret = ps.GetOwner(pUser, pDomain)
		If FindInArray(pList, lcase(ps.name)) Then
			If (Not IS_SIMULATED_MODE) Or ( ret = 0 And pUser = wsh.ExpandEnvironmentStrings("%USERNAME%") And pDomain = wsh.ExpandEnvironmentStrings("%USERDOMAIN%")) Then
				ErrorOut 1, "Please quit notes before running this script!"
			End If
		End If
	next
	
	'make sure we have right permission to open notes.ini
	Set textstream = fso.OpenTextFile( inifile, Append, false)
	If Err.Number <> 0 Then
		ErrorOut Err.Number, "Cannot open " & inifile & "," & Err.Description
	End If
	TextStream.Close
	
	Debug(chr(9) & chr(9) & "notes.ini path = " & inifile)
	
	'check if Notes is upgraded from lower version, to decide which data path should be used.
	If NotesMajorVersion = "9" Or Len(NotesMajorVersion) = 2 Then
		classic = ReadIni(inifile, "Notes", "CLASSIC_DATAPATH")
		
		If LCase(classic) = "true" Then
			MultiUserDataPath = MULTIUSER_DATAPATH_CLASSIC
		Else
		    classicibm = ReadIni(inifile, "Notes", "MULTIUSER_DATAPATH_IBM")
		    If LCase(classicibm) = "true" Then
			   MultiUserDataPath = MULTIUSER_DATAPATH_IBM
			Else
			   MultiUserDataPath = MULTIUSER_DATAPATH
			End If   
		End If
 	Else
		MultiUserDataPath = MULTIUSER_DATAPATH_CLASSIC
	End If
	
	'validate data directory
	CurrentDataDirectory = ReadIni(inifile, "Notes", "Directory")
	If Not fso.FolderExists(CurrentDataDirectory) Then	
		ErrorOut 1,"Directory " & CurrentDataDirectory & "doesn't exist."
	End If
	Debug(chr(9) & chr(9) & "Directory = " & CurrentDataDirectory)

	Select Case NotesMajorVersion
	Case "11"
		lotussubkey="SOFTWARE\Lotus\Notes\11.0\"
    Case "10"
		lotussubkey="SOFTWARE\Lotus\Notes\10.0\"
	Case "9"
		lotussubkey="SOFTWARE\Lotus\Notes\9.0\"
	Case "8"
		lotussubkey="SOFTWARE\Lotus\Notes\8.0\"
	Case "7"
		lotussubkey="SOFTWARE\Lotus\Notes\7.0\"
	Case "6"
		lotussubkey="SOFTWARE\Lotus\Notes\6.0\"
	Case Else
		ErrorOut 1, "This tool cannot support the notes version which you installed"
	End Select
	If Not IsRegKeyExists("HKEY_LOCAL_MACHINE\" & lotussubkey) Then
		ErrorOut 1, "Cannot validate notes version in HKEY_LOCAL_MACHINE\" & lotuskey
	End If
	
	
	
	If IS_SIMULATED_MODE Then
		If IsRegKeyExists( CurrentUserKey & lotussubkey & "MIGRATED") Then
			If RegRead( CurrentUserKey & lotussubkey & "MIGRATED") = 1 Then
				done = True
			End If
		End If
	
		If done Then
			ErrorOut 1, "This user has been migrated!"
		End If
	End If
	
	'Is it multiuser yet?  In simulated mode, this tool still need to do some migration even it's multiuser yet, it use HKCU/lotus notes key/MIGRATED to know whether this user has been migrated
	If Not IS_SIMULATED_MODE And IsMultiUserMode() Then
		Print("Notesclient on this machine is already installed in Multiuser mode")
		pb.Close()
		WScript.Quit(1)
	End If
	
	On Error Goto 0
	'Is AllClient?

	If IsAllClient() Then 
		if NBP_MODE <> "" then
			If not SILENT_MODE Then
				WScript.Echo("AllClient is not supported for migrating to Multi-user.")
			End If
		End If
		
		ErrorOut 1,"AllClient is not supported for migrating to Multi-user."
	End If 

	' this tool need to modify the rcplauncher.properties, so check whether we have permission first
	' SPR # XTCN8KAH9V, on simulated mode, if it is a standard user(MIGRATE_REGISTRY=false and MIGRATE_SHARED_DIR=false),
	' we won't need to change rcplauncher.properties
	If Not (IS_SIMULATED_MODE And (Not MIGRATE_REGISTRY) And (Not MIGRATE_SHARED_DIR)) Then
		If IsStandardClient() Then
			Set textstream = fso.OpenTextFile( NotesProgram & "\framework\rcp\rcplauncher.properties", Append, false)
			If Err.Number <> 0 Then
				ErrorOut Err.Number, "Cannot open " & NotesProgram & "\framework\rcp\rcplauncher.properties, " & Err.Description
			End If
			TextStream.Close
		End If
	End If

	' notes don't support customized shared data location( use MULTIUSERCOMMONDDIR) before 8.5.1
	version = GetNotesVersion()
	If version < "8.5.1" Then
		If (IS_SIMULATED_MODE And Not MIGRATE_USERDATA_DIR) Or MultiUserBaseDir <> "" Or MultiUserCommonDir <> "" Then
			Warn("Notes doesn't support customized shared data directory and user data directory in this version, default location will be used! ")
			MultiUserCommonDir = ""
			MultiUserBaseDir = ""
			MIGRATE_USERDATA_DIR = true
		End If
	End If
	'try to validate new user data directory
	If IS_SIMULATED_MODE Then
		If Not MIGRATE_USERDATA_DIR Then
			MultiUserBaseDir = CurrentDataDirectory
			MultiUserBaseDirInReg = MultiUserBaseDir
		Else
			If MultiUserBaseDir="" Then
				MultiUserBaseDir=oshell.NameSpace(CSIDL_LOCAL_APPDATA).self.path
			Else
				MultiUserBaseDirInReg = MultiUserBaseDir
				'MULTIUSERBASE is set, to try to verify its value contain "%USERNAME%"
				If InStr(MultiUserBaseDir, "%USERNAME%") = 0 Then
					ErrorOut 1, "Didn't find %USERNAME% in MULTIUSERBASEDIR"
				End If
			End If
			MultiUserBaseDir = MultiUserBaseDir & MultiUserDataPath
		End If
	Else
		If MultiUserBaseDir="" Then
			MultiUserBaseDir=oshell.NameSpace(CSIDL_LOCAL_APPDATA).self.path
		Else
			MultiUserBaseDirInReg = MultiUserBaseDir
			'MULTIUSERBASE is set, to try to verify its value contain "%USERNAME%"
			If InStr(MultiUserBaseDir, "%USERNAME%") = 0 Then
				ErrorOut 1, "Didn't find %USERNAME% in MULTIUSERBASEDIR"
			End If
		End If

		MultiUserBaseDir = MultiUserBaseDir & MultiUserDataPath
	End If
	' provide default value if user don't set it in configure file and command line

	If MultiUserCommonDir="" Then
		MultiUserCommonDir=oshell.NameSpace(CSIDL_COMMON_APPDATA).self.path
	Else
		MultiUserCommonDirInReg = MultiUserCommonDir
	End If

	MultiUserCommonDir = MultiUserCommonDir & MultiUserDataPath
	
	If StrComp(wsh.ExpandEnvironmentStrings(MultiUserCommonDir), wsh.ExpandEnvironmentStrings(MultiUserBaseDir), vbTextCompare) = 0 Then
		ErrorOut 1, "Multiuser base directory should not be equal to multiuser common directory"
	End If
	
	' if you customized multiuser shared directory, you should customiz multiuser user data directory too, vice versa.
	If IsDefaultMultiUserBaseDir() Xor IsDefaultMultiUserCommonDir() Then
		ErrorOut 1, "MULTIUSERBASEDIR and MULTIUSERCOMMONDIR should always be set meanwhile"
	End If
	
	' rename exist folder to avoid to override it
	If fso.FolderExists( wsh.ExpandEnvironmentStrings(MultiUserBaseDir) )  And Not ( wsh.ExpandEnvironmentStrings(MultiUserBaseDir) = CurrentDataDirectory ) And MIGRATE_USERDATA_DIR Then	
		Warn(chr(9) & chr(9) & MultiUserBaseDir & " exists, trying to rename it")
		temp = wsh.ExpandEnvironmentStrings(MultiUserBaseDir) & " - Copy"
		While ( fso.FolderExists( temp ) )
			temp = temp & " - Copy"
		Wend
		If Not DryRun Then
			fso.MoveFolder wsh.ExpandEnvironmentStrings(MultiUserBaseDir), temp
		End If 
	End If
	If Not DryRun Then
		If Not fso.FolderExists(wsh.ExpandEnvironmentStrings(MultiUserBaseDir)) Then
			CreateFolder fso, wsh.ExpandEnvironmentStrings(MultiUserBaseDir)
		End If
	End If
	Debug(chr(9) & chr(9) & "MultiUserBaseDir = " & MultiUserBaseDir)	

	'try to validate common data directory

	If fso.FolderExists( wsh.ExpandEnvironmentStrings(MultiUserCommonDir) ) And MIGRATE_SHARED_DIR Then	
		Warn(chr(9) & chr(9) & MultiUserCommonDir & " exists, trying to rename it")
		temp = wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & " - Copy"
		While ( fso.FolderExists( temp ) )
			temp = temp & " - Copy"
		Wend
		If Not DryRun Then 
			fso.MoveFolder wsh.ExpandEnvironmentStrings(MultiUserCommonDir), temp
		End If	
	End If
	If Not DryRun then
		If Not fso.FolderExists(wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & "\Shared\") Then
			CreateFolder fso, wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & "\Shared\"
		End If
	End If
	Debug(chr(9) & chr(9) & "MultiUserCommonDir = " & MultiUserCommonDir)


	Debug("CheckConfiguration End")
End Function

'##################################################################################################################################################
' Begin Migration
'##################################################################################################################################################

Function DoMigration()
	Debug("DoMigration Begin")
	
	Dim path,fso,wsh,defaultMigrateFile,noMigrateFile
	Set fso = CreateObject("Scripting.FileSystemObject")
	Set wsh = CreateObject("WScript.Shell")
	Set oshell = CreateObject("shell.application")
	defaultMigrateFile = GetDefaultMigrateFiles()
	noMigrateFile = GetNoMigrateFiles()
	Debug( chr(9) & chr(9) & "Back up user data.")
	If Not DryRun Then 
		BackupUserData()
		NeedRestore = True 
	End If		
	On Error Resume Next
	Err.Clear

	' update progress bar
	pb.SetTask("Updating property files")
	pb.Update(60)
	
	'update rcplauncher.properties
	If IsStandardClient() Then
		If MIGRATE_REGISTRY Then
			Debug( chr(9) & chr(9) & "Update common rcplauncher.properties " )
			If Not DryRun Then 
				WritePropertyFile NotesProgram & "\framework\rcp\rcplauncher.properties", "install.configuration", "multiuser"
				WritePropertyFile NotesProgram & "\framework\rcp\rcplauncher.properties", "rcp.data", GetRcpData(MultiUserBaseDir)
				'wsh.run "cacls """ & NotesProgram & "\framework\rcp\rcplauncher.properties"" /T /E /P EVERYONE:R"
			End If 
		End If
		If MIGRATE_USER_REGISTRY Then
			Debug( chr(9) & chr(9) & "Update user rcplauncher.properties " )
			Dim userRcpLauncherProperty
			userRcpLauncherProperty = CurrentDataDirectory & "\workspace\.config\rcpinstall.properties"
			If fso.FileExists(userRcpLauncherProperty) Then
				WritePropertyFile userRcpLauncherProperty, "install.configuration", "multiuser"
				WritePropertyFile userRcpLauncherProperty, "rcp.data", GetRcpData(MultiUserBaseDir)
			End If
		End If
	
	End If
	
	Dim kittype, installtype, installmode, UserInterface, UseFTSyntaxOnly, TechnoteSearchURL
	kittype = ReadIni( inifile, "Notes", "KitType")
	installtype = ReadIni( inifile, "Notes", "InstallType")
	installmode = ReadIni( inifile, "Notes", "InstallMode")
	If IsMUIClient() Then
		UserInterface = ReadIni( inifile, "Notes", "UserInterface")
		UseFTSyntaxOnly = ReadIni( inifile, "Notes", "UseFTSyntaxOnly")
		TechnoteSearchURL = ReadIni( inifile, "Notes", "TechnoteSearchURL")
	End If
	
	'refresh current user's notes.ini
	If MIGRATE_USER_REGISTRY Then	
		Debug(chr(9) & chr(9) & " Moving current notes.ini to " & wsh.ExpandEnvironmentStrings(MultiUserBaseDir) & " .")
		If Not DryRun Then
				fso.MoveFile inifile, wsh.ExpandEnvironmentStrings(MultiUserBaseDir) & "\"
				If Err.Number <> 0 Then
					ErrorOut Err.Number, "Cannot move notes.ini to " & wsh.ExpandEnvironmentStrings(MultiUserBaseDir) & "\, " & Err.Description
				End If
		End If
		Debug(chr(9) & chr(9) & " Writing Directory = " & wsh.ExpandEnvironmentStrings( MultiUserBaseDir) & " to new notes.ini.")
		If Not DryRun Then
			WriteIni wsh.ExpandEnvironmentStrings(MultiUserBaseDir) & "\notes.ini", "Notes", "Directory", wsh.ExpandEnvironmentStrings( MultiUserBaseDir)
		End If
		Debug(chr(9) & chr(9) & " Writing SharedDirectory = " & wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & "\Shared to new notes.ini.")
		If Not DryRun Then
			WriteIni wsh.ExpandEnvironmentStrings(MultiUserBaseDir) & "\notes.ini", "Notes", "SharedDirectory",wsh.ExpandEnvironmentStrings( MultiUserCommonDir) & "\Shared"
		End If
	End If

	'refresh common notes.ini
	If MIGRATE_SHARED_DIR Then
		Dim commoninifile
		commoninifile = wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & "\notes.ini"
		Debug(chr(9) & chr(9) & "Creating common notes.ini in " & wsh.ExpandEnvironmentStrings(MultiUserCommonDir) )
		If Not DryRun Then
			fso.GetFolder(wsh.ExpandEnvironmentStrings(MultiUserCommonDir)).CreateTextFile("notes.ini")
			If Err.Number <> 0 Then
				ErrorOut Err.Number, "Cannot create common notes.ini, " & Err.Description
			End If
		End If
		Debug(chr(9) & chr(9) & "Writing KitType = " & kittype & " to common notes.ini")
		If Not DryRun Then
			WriteIni commoninifile, "Notes", "KitType", kittype 
		End If 
		Debug(chr(9) & chr(9) & "Writing InstallType = " & installtype & " to common notes.ini")
		If Not DryRun Then
			WriteIni commoninifile, "Notes", "InstallType", installtype
		End If 
		Debug(chr(9) & chr(9) & "Writing InstallMode = " & installmode & " to common notes.ini")
		If Not DryRun Then
			WriteIni commoninifile, "Notes", "InstallMode", installmode
		End If 
		Debug(chr(9) & chr(9) & "Writing NotesProgram = " & NotesProgram & " to common notes.ini")
		If Not DryRun Then
			WriteIni commoninifile, "Notes", "NotesProgram", NotesProgram
		End If 
		Debug(chr(9) & chr(9) & "Writing SharedDataDirectory = " & wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & "\Shared to common notes.ini")
		If Not DryRun Then
			WriteIni commoninifile, "Notes", "SharedDataDirectory", wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & "\Shared"
		End If 
		If IsMUIClient() Then
			
			Debug(chr(9) & chr(9) & "Writing UserInterface = " & UserInterface & " to common notes.ini")
			If Not DryRun Then
				WriteIni commoninifile, "Notes", "UserInterface", UserInterface 
			End If 
			Debug(chr(9) & chr(9) & "Writing UseFTSyntaxOnly = " & UseFTSyntaxOnly & " to common notes.ini")
			If Not DryRun Then
				WriteIni commoninifile, "Notes", "UseFTSyntaxOnly", UseFTSyntaxOnly
			End If 
			Debug(chr(9) & chr(9) & "Writing TechnoteSearchURL = " & TechnoteSearchURL & " to common notes.ini")
			If Not DryRun Then
				WriteIni commoninifile, "Notes", "TechnoteSearchURL", TechnoteSearchURL
			End If
		
		End If

		'make sure everyone can read shared data directory
		If Not DryRun Then
			wsh.run "cacls """ & wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & "\notes.ini"" /T /E /P " & GetEveryoneName() & ":R"
		End If
	End If
	
	' update progress bar
	pb.SetTask("Moving shared data")
	pb.Update(70)
	
	'move shared data 
	If MIGRATE_SHARED_DIR Then
		If CurrentDataDirectory <> wsh.ExpandEnvironmentStrings(MultiUserCommonDir) Then
			For Each entry In defaultMigrateFile
				offset = InStrRev(entry, "|")
				file = Left(entry, offset-1)
				target = Right(entry, Len(entry) - offset)
				path = CurrentDataDirectory & "\" & file
				If fso.FolderExists( path ) Then	
					Debug(chr(9) & chr(9) & "Moving folder " & path & " to " & wsh.ExpandEnvironmentStrings(MultiUserCommonDir))
					If Not DryRun  Then
						If Not fso.FolderExists(wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & "\" & target & "\" ) Then
							CreateFolder fso, wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & "\" & target & "\"
						End If
						If Err.Number <> 0 Then
							ErrorOut Err.Number, "Cannot create folder " & target & " in " & MultiUserCommonDir & ", " & Err.Description
						End If
						fso.CopyFolder path, wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & "\" & target & "\"
						' copy it to mui folder
						If IsMUIClient() And FindInArray( GetMUIDataFiles(), file ) Then
							CopyDataToMUIFolder(path)
						End If
		
						'do not delete it if it's copied to "Common", because it need to be moved to user data directory later
						If target <> "Common" Then
							fso.DeleteFolder path
						End If
						If Err.Number <> 0 Then
							ErrorOut Err.Number, "Cannot move folder " & path & "," & Err.Description
						End If
					End If
				ElseIf fso.FileExists( path ) Then
					Debug(chr(9) & chr(9) & "Moving file " & path & " to " & wsh.ExpandEnvironmentStrings( MultiUserCommonDir))
					If Not DryRun  Then
						If Not fso.FolderExists( wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & "\" & target & "\" ) Then
							CreateFolder fso,wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & "\" & target & "\"
						End If
						If Err.Number <> 0 Then
							ErrorOut Err.Number, "Cannot create folder " & target & " in " & wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & ", " & Err.Description
						End If
						fso.CopyFile path, wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & "\" & target &  "\"
						If IsMUIClient() And FindInArray( GetMUIDataFiles(), file ) Then
							CopyDataToMUIFolder(path)
						End If
						If target <> "Common" Then
							fso.DeleteFile path
						End If
						If Err.Number <> 0 Then
							ErrorOut Err.Number, "Cannot move file " & path & "," & Err.Description
						End If
					End If	
				Else
					Warn(chr(9) & chr(9) & "Skipping " & path & " because it doesn't exist.")
				End If
			Next
			' move template files
			Debug(chr(9) & chr(9) & "Moving all template files to " & wsh.ExpandEnvironmentStrings(MultiUserCommonDir)) & "\Shared\"
			If Not DryRun Then		
				fso.CopyFile CurrentDataDirectory & "\*.ntf",wsh.ExpandEnvironmentStrings( MultiUserCommonDir) & "\Shared\", True
				If Err.Number <> 0 Then
					ErrorOut Err.Number, "Cannot Copy *.ntf to Shared folder ," & Err.Description
				End If
				If IsMUIClient() Then
					Dim muifolder
					muifolder = GetMUIFolder()
					Debug(chr(9) & chr(9) & "Moving all dictionary files to " & wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & "\Shared\" & muifolder)
					fso.CopyFile CurrentDataDirectory & "\*.dic",wsh.ExpandEnvironmentStrings( MultiUserCommonDir) & "\Shared\" & muifolder & "\", True
					fso.DeleteFile CurrentDataDirectory & "\*.dic", True
					' ignore the error, because not all nlv build have special dictionary file
					Err.Clear
					Debug(chr(9) & chr(9) & "Copying all template files to " & wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & "\Shared\" & muifolder)
					fso.CopyFile CurrentDataDirectory & "\*.ntf",wsh.ExpandEnvironmentStrings( MultiUserCommonDir) & "\Shared\" & muifolder & "\", True
					If Err.Number <> 0 Then
						ErrorOut Err.Number, "Cannot Copy *.ntf to" & wsh.ExpandEnvironmentStrings( MultiUserCommonDir) & "\Shared\" & muifolder & "\, " & Err.Description
					End If
				End If
				fso.DeleteFile CurrentDataDirectory & "\*.ntf"
				If Err.Number <> 0 Then
					ErrorOut Err.Number, "Cannot delete *.ntf from " & CurrentDataDirectory & " ," & Err.Description
				End If
			End If
			
			If MIGRATE_SHARED_FILES <> "" Then
				Dim textStream
				Debug(chr(9) & chr(9) & "Moving customized files to " & wsh.ExpandEnvironmentStrings(MultiUserCommonDir))
				Set textStream = fso.OpenTextFile(MIGRATE_SHARED_FILES, Read, False)
				If Err.Number <> 0 Then
					ErrorOut Err.Number, "Cannot open " & MIGRATE_SHARED_FILES & " because of " & Err.Description
				End If
				While Not textStream.AtEndOfStream
					path = Trim(textStream.ReadLine)
					If fso.FolderExists( path ) Then	
						Debug(chr(9) & chr(9) & "Moving folder " & path & " to " & wsh.ExpandEnvironmentStrings(MultiUserCommonDir))
						If Not DryRun  Then
							fso.CopyFolder path, wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & "\Shared\"
							fso.DeleteFolder path
							If Err.Number <> 0 Then
								ErrorOut Err.Number, "Cannot move folder " & path & "," & Err.Description
							End If
						End If
					ElseIf fso.FileExists( path ) Then
						Debug(chr(9) & chr(9) & "Moving file " & path & " to " & wsh.ExpandEnvironmentStrings( MultiUserCommonDir))
						If Not DryRun  Then
							fso.MoveFile path, wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & "\Shared\"
							If Err.Number <> 0 Then
								ErrorOut Err.Number, "Cannot move file " & path & "," & Err.Description
							End If
						End If	
					Else
						Warn(chr(9) & chr(9) & "Skipping " & path & " because it doesn't exist.")
					End If
				Wend
			End If 
			'make sure everyone can read shared data directory
			If Not DryRun Then
				wsh.run "cacls """ & wsh.ExpandEnvironmentStrings(MultiUserCommonDir) & "\*"" /T /E /P " & GetEveryoneName() & ":R", 1, True
			End If		
		End If
	End If

	' update progress bar
	pb.SetTask("Moving user data")
	pb.Update(80)
	
	'move user's data
	If MIGRATE_USERDATA_DIR Then
		If CurrentDataDirectory <> wsh.ExpandEnvironmentStrings( MultiUserBaseDir) Then
			Set fc = fso.GetFolder(CurrentDataDirectory)
			For Each file In fc.Files
				fname = fso.GetFileName(file)
				If FindInArray(noMigrateFile, fname) Then
					Debug(chr(9) & chr(9) & "Skipped moving file " & file)
				ElseIf (Not FindInArray( defaultMigrateFile, file)) Or IsTargetCommon(defaultMigrateFile, file) Then
					Debug(chr(9) & chr(9) & "Moving file " & file & " to " & wsh.ExpandEnvironmentStrings( MultiUserBaseDir))
					If Not DryRun  Then
						fso.CopyFile file, wsh.ExpandEnvironmentStrings( MultiUserBaseDir) & "\"
						fso.DeleteFile file, True
						If Err.Number <> 0 Then
							ErrorOut Err.Number, "Cannot move file " & file & "," & Err.Description
						End If
					End If	
				End If	
			Next
			For Each folder In fc.SubFolders
				If FindInArray(noMigrateFile, folder) Then
					Debug(chr(9) & chr(9) & "Skipped moving folder " & folder)
				ElseIf (Not FindInArray(noMigrateFile, folder)) Or IsTargetCommon(defaultMigrateFile, foler) Then 
					Debug(chr(9) & chr(9) & "Moving folder " & folder & " to " & wsh.ExpandEnvironmentStrings( MultiUserBaseDir) )
					If Not DryRun  Then
						fso.CopyFolder folder, wsh.ExpandEnvironmentStrings( MultiUserBaseDir) & "\"
						fso.DeleteFolder folder, True
						If Err.Number <> 0 Then
							ErrorOut Err.Number, "Cannot move folder " & folder & "," & Err.Description
						End If
					End If	
				End If	
			Next 	
		End If	
	End If
	
	' update progress bar
	pb.SetTask("Updating shortcuts")
	pb.Update(85)
		
	'refresh notes shortcut
	If MIGRATE_REGISTRY Then
		desktop = oshell.NameSpace(CSIDL_COMMON_DESKTOPDIRECTORY).self.path
		startmenu = oshell.NameSpace(CSIDL_COMMON_PROGRAMS).self.path
		For Each file in fso.GetFolder(desktop).Files
			If LCase(fso.GetExtensionName(file)) = "lnk" And (Left(fso.GetBaseName(file),9) = "HCL Notes" Or Left(fso.GetBaseName(file),9) = "IBM Notes" Or Left(fso.GetBaseName(file),11) = "Lotus Notes") Then
				Debug(chr(9) & chr(9) & " Update shortcut " & file)
				If Not DryRun Then
					Set link = wsh.CreateShortCut(file)
					args = Replace(link.Arguments, "="&inifile, "", 1, -1, vbTextCompare)
					link.Arguments = args
					link.Save()
				End If
			End If
		Next
		For Each folder in fso.GetFolder(startmenu).SubFolders
			if Left(folder.name, 5) = "Lotus" Then
				For Each file in folder.Files
					If LCase(fso.GetExtensionName(file)) = "lnk" And (Left(fso.GetBaseName(file),9) = "HCL Notes" Or Left(fso.GetBaseName(file),9) = "IBM Notes" Or Left(fso.GetBaseName(file),11) = "Lotus Notes" Or Left(fso.GetBaseName(file),12) = "Notes Minder") Then
						Debug(chr(9) & chr(9) & " Update shortcut " & file)
						If Not DryRun Then
							Set link = wsh.CreateShortCut(file)
							args = Replace(link.Arguments, "="&inifile, "", 1, -1, vbTextCompare)
							link.Arguments = args
							link.Save()
						End If
					end if
				Next
			End If
		Next
		If IsNotes80() And IsStandardClient() Then
			'8.0 Standard version only, this version install shortcut to user's desktop rather than common desktop
			Dim notesFolder, name
			desktop = oshell.NameSpace(CSIDL_DESKTOPDIRECTORY).self.path
			startmenu = oshell.NameSpace(CSIDL_PROGRAMS).self.path
			For Each file in fso.GetFolder(desktop).Files
				If LCase(fso.GetExtensionName(file)) = "lnk"  And Left(fso.GetBaseName(file),5) = "Lotus" Then
					name = fso.GetFileName(file)
					Set link = wsh.CreateShortCut(file)
					If Left(fso.GetBaseName(file),11) = "Lotus Notes" Then
						Debug(chr(9) & chr(9) & " Update shortcut " & file)
						If Not DryRun Then
							args = Replace(link.Arguments, "="&inifile, "", 1, -1, vbTextCompare)
							link.Arguments = args
							link.Save()
						End If
						Debug(chr(9) & chr(9) & " Move shortcut " & file)
						If Not DryRun Then
							fso.MoveFile file, oshell.NameSpace(CSIDL_COMMON_DESKTOPDIRECTORY).self.path & "\"
							wsh.run "cacls """ & oshell.NameSpace(CSIDL_COMMON_DESKTOPDIRECTORY).self.path & "\" & name & " "" /T /E /P " & GetEveryoneName() & ":R"
						End If
					Else
						If StrComp(link.TargetPath, fso.GetAbsolutePathName(NotesProgram & "\framework\rcp\rcplauncher.exe"), vbTextCompare ) = 0 Then
							Debug(chr(9) & chr(9) & " Move shortcut " & file)
							If Not DryRun Then
								fso.MoveFile file, oshell.NameSpace(CSIDL_COMMON_DESKTOPDIRECTORY).self.path & "\"
								wsh.run "cacls """ & oshell.NameSpace(CSIDL_COMMON_DESKTOPDIRECTORY).self.path & "\" & name & " "" /T /E /P " & GetEveryoneName() & ":R"
							End If
						End If
					End If
				End If
			Next
			For Each folder in fso.GetFolder(startmenu).SubFolders
				notesFolder = false
				if Left(folder.name, 5) = "Lotus" Then
					For Each file in folder.Files
						If LCase(fso.GetExtensionName(file)) = "lnk" And ( Left(fso.GetBaseName(file),11) = "Lotus Notes" Or Left(fso.GetBaseName(file),12) = "Notes Minder") Then
							Debug(chr(9) & chr(9) & " Update shortcut " & file)
							If Not DryRun Then
								Set link = wsh.CreateShortCut(file)
								args = Replace(link.Arguments, "="&inifile, "", 1, -1, vbTextCompare)
								link.Arguments = args
								link.Save()
							End If
							notesFolder = true
						end if
					Next
					If notesFolder Then
						Debug(chr(9) & chr(9) & " Move folder " & folder)
						If Not DryRun Then
							name = folder.Name
							fso.CopyFolder folder, oshell.NameSpace(CSIDL_COMMON_PROGRAMS).self.path & "\"
							fso.DeleteFolder folder
							wsh.run "cacls """ & oshell.NameSpace(CSIDL_COMMON_PROGRAMS).self.path & "\" & name & "\*"" /T /E /P " & GetEveryoneName() & ":R"
						End If
					End If
				End If
			Next
			
			For Each file in fso.GetFolder(startmenu).Files
				If LCase(fso.GetExtensionName(file)) = "lnk"  And Left(fso.GetBaseName(file),5) = "Lotus" Then
					name = fso.GetFileName(file)
					Set link = wsh.CreateShortCut(file)
					If StrComp(link.TargetPath, fso.GetAbsolutePathName(NotesProgram & "\framework\rcp\rcplauncher.exe") , vbTextCompare ) = 0 Then
						Debug(chr(9) & chr(9) & " Move shortcut " & file)
						If Not DryRun Then
							fso.MoveFile file, oshell.NameSpace(CSIDL_COMMON_PROGRAMS).self.path & "\"
							wsh.run "cacls """ & oshell.NameSpace(CSIDL_COMMON_PROGRAMS).self.path & "\" & name & " "" /T /E /P " & GetEveryoneName() & ":R"
						End If
					End If
				End If
			Next

		End If
	End If

	If Not DryRun Then
		If IS_SIMULATED_MODE And fso.FileExists( NotesProgram & "\notes.ini") Then
			fso.MoveFile NotesProgram & "\notes.ini", NotesProgram & "\notes.ini.SIMULATED"
		End If
	End If
	
	' update progress bar
	pb.SetTask("Updating registry")
	pb.Update(95)
	
	'refresh registry, it is multiuser from now on
	Dim OperationRegistry
	Set OperationRegistry = WScript.CreateObject("WScript.Shell")
	
	If Not DryRun Then
		BackupRegistry()
	End If
	
	Err.clear
	
	If MIGRATE_REGISTRY Then
		Debug(chr(9) & chr(9) & "Setting registry key " & "HKEY_LOCAL_MACHINE\" & lotuskey & "\MultiUser to 1")
		If Not DryRun Then
			OperationRegistry.RegWrite "HKEY_LOCAL_MACHINE\" & lotuskey & "\MultiUser", 1,"REG_DWORD"
			If Err.Number <> 0 Then
				RestoreRegistry() 
				ErrorOut Err.Number, Err.Description
			End If
		End If
		
		Debug(chr(9) & chr(9) & "Setting registry key " & "HKEY_LOCAL_MACHINE\" & lotussubkey & "\MultiUser to 1")
		If Not DryRun Then
			OperationRegistry.RegWrite "HKEY_LOCAL_MACHINE\" & lotussubkey & "\MultiUser", 1,"REG_DWORD"
			If Err.Number <> 0 Then
				RestoreRegistry() 
				ErrorOut Err.Number, Err.Description
			End If
		End If
			
		If IsDefaultMultiUserBaseDir() Then
			Debug(chr(9) & chr(9) & "Removing registry key " & "HKEY_LOCAL_MACHINE\" & lotuskey & "\DataPath")
			If Not DryRun Then		
				OperationRegistry.RegDelete "HKEY_LOCAL_MACHINE\" & lotuskey & "\DataPath"
				If Err.Number <> 0 Then 
					Warn Err.Description
					Err.Clear
				End If
			End If
			
			Debug(chr(9) & chr(9) & "Removing registry key " & "HKEY_LOCAL_MACHINE\" & lotussubkey & "\DataPath")
			If Not DryRun Then		
				OperationRegistry.RegDelete "HKEY_LOCAL_MACHINE\" & lotussubkey & "\DataPath"
				If Err.Number <> 0 Then 
					Warn Err.Description
					Err.Clear
				End If
			End If
		Else
			Debug(chr(9) & chr(9) & "Setting registry key " & "HKEY_LOCAL_MACHINE\" & lotuskey & "\DataPath to " & MultiUserBaseDirInReg)
			If Not DryRun Then		
				OperationRegistry.RegWrite "HKEY_LOCAL_MACHINE\" & lotuskey & "\DataPath", MultiUserBaseDirInReg, "REG_SZ"
				If Err.Number <> 0 Then 
					RestoreRegistry()
					ErrorOut Err.Number, Err.Description
				End If
			End If
			
			Debug(chr(9) & chr(9) & "Updating registry key " & "HKEY_LOCAL_MACHINE\" & lotussubkey & "\DataPath to " & MultiUserBaseDirInReg)
			If Not DryRun Then		
				OperationRegistry.RegWrite "HKEY_LOCAL_MACHINE\" & lotussubkey & "\DataPath", MultiUserBaseDirInReg, "REG_SZ"
				If Err.Number <> 0 Then 
					RestoreRegistry()
					ErrorOut Err.Number, Err.Description
				End If
			End If


		End If
		
		If Not IsDefaultMultiUserCommonDir() Then
			Debug(chr(9) & chr(9) & "Updating registry key " & "HKEY_LOCAL_MACHINE\" & lotuskey & "\CommonDataPath to " & MultiUserCommonDirInReg)
			If Not DryRun Then		
				OperationRegistry.RegWrite "HKEY_LOCAL_MACHINE\" & lotuskey & "\CommonDataPath", MultiUserCommonDirInReg, "REG_SZ"
				If Err.Number <> 0 Then 
					RestoreRegistry()
					ErrorOut Err.Number, Err.Description
				End If
			End If
			
			Debug(chr(9) & chr(9) & "Updating registry key " & "HKEY_LOCAL_MACHINE\" & lotussubkey & "\CommonDataPath to " & MultiUserCommonDirInReg)
			If Not DryRun Then		
				OperationRegistry.RegWrite "HKEY_LOCAL_MACHINE\" & lotussubkey & "\CommonDataPath", MultiUserCommonDirInReg, "REG_SZ"
				If Err.Number <> 0 Then 
					RestoreRegistry()
					ErrorOut Err.Number, Err.Description
				End If
			End If
		End If
	End If
	
	If MIGRATE_USER_REGISTRY Then
		Dim CurrentUserKey, NewIniPath
		CurrentUserKey = GetCurrentUserKey()
		CurrentUserNotesKey = lotuskey
		CurrentUserNotesSubKey = lotussubkey
	
		NewIniPath = wsh.ExpandEnvironmentStrings( MultiUserBaseDir) & "\notes.ini"
		Debug(chr(9) & chr(9) & "Setting registry key " & CurrentUserKey  & CurrentUserNotesKey & "\NotesIniPath to " & NewIniPath)
		If Not DryRun Then
			OperationRegistry.RegWrite CurrentUserKey & CurrentUserNotesKey & "\NotesIniPath", NewIniPath, "REG_SZ"
			If Err.Number <> 0 Then 
				RestoreRegistry()
				ErrorOut Err.Number, Err.Description
			End If
		End If

		Debug(chr(9) & chr(9) & "Setting registry key " & CurrentUserKey & CurrentUserNotesSubKey & "\NotesIniPath to " & NewIniPath )
		If Not DryRun Then
			OperationRegistry.RegWrite CurrentUserKey & CurrentUserNotesSubKey & "\NotesIniPath", NewIniPath, "REG_SZ"
			If Err.Number <> 0 Then 
				ErrorOut Err.Number, Err.Description
			End If
		End If

		Debug(chr(9) & chr(9) & "Setting registry key " & CurrentUserKey & CurrentUserNotesSubKey & "\MIGRATED to 1")
		If Not DryRun Then
			OperationRegistry.RegWrite CurrentUserKey & CurrentUserNotesSubKey & "\MIGRATED", 1, "REG_DWORD"
			If Err.Number <> 0 Then 
				ErrorOut Err.Number, Err.Description
			End If
		End If
	End IF

	'SPR XTCN8HXKK7, Precreate .muservice under framework\eclipse in MUMA, because standard user have no privilege to create directory
	If IsStandardClient() And (StrComp("8.0.2", GetNotesVersion() ) = 0) Then
		If Not DryRun Then
			Dim muserviceDir
			muserviceDir = NotesProgram & "\framework\eclipse\.muservice"
			If Not fso.FolderExists(muserviceDir) Then
				CreateFolder fso, muserviceDir
			End If
			wsh.run "cacls """ & muserviceDir & " "" /T /E /P " & GetEveryoneName() & ":F"
		End If
	End If
	
	On Error Goto 0
	
	Debug("DoMigration End")
End Function

Set pb = New ProgressBar

If not SILENT_MODE Then
	'Setup the initial progress bar
	percentComplete = 0
	pb.SetTitle("Migrating to Multi-user")
End If	


' try to read configuration from MUMigrationAssistant.ini
pb.SetTask("Reading configuration...")
ReadConfiguration()
pb.Update(25)
' Verify the configuration, and user's environment
pb.SetTask("Verifying configuration...")
CheckConfiguration()
pb.Update(50)
' do the job
pb.SetTask("Migrating user data...")
DoMigration()
pb.Update(100)
pb.Close()
If NBP_MODE = "" Then
	WScript.Echo "Migration Successful"
End If

WScript.Quit