/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.update.internal.ui.wizards;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.model.SiteBookmark;

public class ProvisioningUIUtils {

    private static final String CLAZZ_NAME = ProvisioningUIUtils.class.getName();
    private static final String PKG = ProvisioningUIUtils.class.getPackage().getName();
    private static Logger _logger = Logger.getLogger(PKG);
	
	// Added to allow searching of all update sites
	public static boolean useFeatureURL;
	public static boolean useList;
	public static boolean whiteList;
	public static String updateSiteList = null;	
	
	public static void loadProvisioningPreferences() {
		
		final String _method = "loadProvisioningPreferences";
		
		final String PREFERENCES_ROOT = "com.ibm.rcp.provisioning";
		
	    final String WHITELIST = "whiteList";
	    final String UPDATE_SITE_LIST = "updateSiteList";
	    final String USE_FEATURE_URL = "useFeatureURL";
	    final String USE_LIST = "useList";
		
		IPreferencesService service = Platform.getPreferencesService();
		
		useFeatureURL = service.getBoolean( PREFERENCES_ROOT, USE_FEATURE_URL, true, null);
		useList = service.getBoolean( PREFERENCES_ROOT, USE_LIST, false, null );
		whiteList = service.getBoolean( PREFERENCES_ROOT, WHITELIST, false, null );
		
		updateSiteList = service.getString( PREFERENCES_ROOT, UPDATE_SITE_LIST, "", null );	
	}
	
	/**
	 * Retrieves valid updateSiteList URLs.
	 * @return Array of valid updateSiteList URLs 
	 */	
	public static URL[] getUpdateURLList() {
		
		final String _method = "getUpdateURLList";
		
		// Parse the updateSiteList sites
		String[] updateSites = updateSiteList.split("\\|");
		URL[] returnValue = null;
		
		// Check the list for invalid URL sites
		HashSet updateURLList = new HashSet();
		for (int i = 0 ; i < updateSites.length ; i++) {
			try {
				// Make sure we are not an empty string
				if (!updateSites[i].equals("")) {
					URL updateSiteURL = new URL(updateSites[i]);
					updateURLList.add(updateSiteURL);
				}
			}
			catch (MalformedURLException murl) {
				// Do not add this site as a potential site
				String message = NLS.bind( UpdateUIMessages.InstallServlet_incorrectURLFormat, new Object[] { updateSites[i] });
				_logger.logp( Level.WARNING, CLAZZ_NAME, _method, message, murl );
			}
		}
		
		if (!updateURLList.isEmpty()) {
			returnValue = (URL[])updateURLList.toArray(new URL[] {}); 
		}
		return returnValue;		
	}
	
	/**
	 * Checks to make sure the bookmark list does not already contain the site.
	 * @param Set Set of site bookmarks
	 * @param String Site to search for in the Set 
	 * @return boolean Status of site in the list 
	 */	
	public static boolean isSiteBookmarkListed(Set siteBookmarks, String site) {

		final String _method = "isSiteBookmarkListed";
		
		if (siteBookmarks == null) {
			return false;
		}
		// Check all the sites in the set for the requested site
		Iterator sites = siteBookmarks.iterator();	
		while(sites.hasNext()){
			String siteBookmark = ((SiteBookmark)sites.next()).getURL().toExternalForm();
			// Remove the site.xml if present
			if (siteBookmark.endsWith("site.xml")) {
				siteBookmark=siteBookmark.substring(0,siteBookmark.indexOf("site.xml"));
			}
			if(!siteBookmark.endsWith("/")){
				siteBookmark = siteBookmark + "/";
			}
			if (siteBookmark.equalsIgnoreCase(site)) {
				return true;
			}
		}
				
		return false;
	}
	
	
	/**
	 * Retrieves valid bookmark URLs.
	 * @return Array of valid bookmark URLs 
	 */	
/*	public static URL[] getBookmarkURLList() {

		final String _method = "getBookmarkURLList";

		// Parse the bookmark sites and remove duplicate URLs
		HashSet bookmarkURLList = new HashSet();
		URL[] returnValue = null;

		UpdateModel model = UpdateUI.getDefault().getUpdateModel();
		SiteBookmark[] bookmarks = model.getBookmarkLeafs();
		
		for (int i = 0 ; i < bookmarks.length ; i++) {
			bookmarkURLList.add(bookmarks[i].getURL());
		}		
		
		if (!bookmarkURLList.isEmpty()) {
			returnValue = (URL[])bookmarkURLList.toArray(new URL[] {}); 
		}
		return returnValue;	
		
	}
*/	
	
}
