/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.update.internal.ui.wizards;


import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;

import org.eclipse.update.core.IFeature;
import org.eclipse.update.operations.IInstallFeatureOperation;

public class ProvisioningRequestAdapter {

	public static Object[] getRequests(IInstallFeatureOperation operation) {
		Object[] requests = new Object[1];
		requests[0] = createRequest(operation);
		
		return requests;
	}
	
	public static Object[] getRequests(IInstallFeatureOperation[] operations) {
		Object[] requests = new Object[operations.length];
		for(int i = 0; i < operations.length; i++) {
			requests[i] = createRequest(operations[i]);
		}
		
		return requests;
	}
	
	public static Object[] getRequests(IFeature feature, String action) {
		Object[] requests = new Object[1];
		requests[0] = createRequest(feature, action);
		return requests;
	}
	
	public static Object[] getRequests(IFeature[] features, String action) {
		Object[] requests = new Object[features.length];
		for(int i = 0; i < features.length; i++) {
			requests[i] = createRequest(features[i], action);
		}
		
		return requests;
	}
	
	private static Object createRequest(IFeature feature, String action){
		Object request = null;
		
		try {
			//ProvisioningRequest request = new ProvisioningRequest();
			Class provisioningRequestClazz = Class.forName( "com.ibm.rcp.provisioning.ProvisioningRequest" );
			request = provisioningRequestClazz.newInstance();
			
			//request.setId( operation.getFeature().getVersionedIdentifier().getIdentifier());
			Method m_setId = provisioningRequestClazz.getMethod( "setId", new Class[] { java.lang.String.class } );
			m_setId.invoke(request, new Object[] { feature.getVersionedIdentifier().getIdentifier() } );
			
			//request.setVersion(operation.getFeature().getVersionedIdentifier().getVersion().toString());
			Method m_setVersion = provisioningRequestClazz.getMethod( "setVersion", new Class[] { java.lang.String.class } );
			m_setVersion.invoke(request, new Object[] { feature.getVersionedIdentifier().getVersion().toString() } );
			
			//request.setUrl(operation.getFeature().getSite().getURL().toExternalForm().replaceFirst("site.xml", ""));
			Method m_setUrl = provisioningRequestClazz.getMethod( "setUrl", new Class[] { java.lang.String.class } );
			m_setUrl.invoke(request, new Object[] { feature.getSite().getURL().toExternalForm().replaceFirst("site.xml", "") } );
			
			//request.setAction( "install" );
			Method m_setAction = provisioningRequestClazz.getMethod( "setAction", new Class[] { java.lang.String.class } );
			m_setAction.invoke(request, new Object[] { action } );
			
			//request.setMatch( "perfect" );
			Method m_setMatch = provisioningRequestClazz.getMethod( "setMatch", new Class[] { java.lang.String.class } );
			m_setMatch.invoke(request, new Object[] { "perfect" } );
			
			URL url = feature.getSite().getURL();
			
			//request.setTargetSite(url.toExternalForm());
			Method m_setTargetSite = provisioningRequestClazz.getMethod( "setTargetSite", new Class[] { java.lang.String.class } );
			m_setTargetSite.invoke(request, new Object[] { url.toExternalForm() } );
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InstantiationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SecurityException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return request;		
	}
	
	private static Object createRequest(IInstallFeatureOperation operation){
		Object request = null;
		
		try {
			//ProvisioningRequest request = new ProvisioningRequest();
			Class provisioningRequestClazz = Class.forName( "com.ibm.rcp.provisioning.ProvisioningRequest" );
			request = provisioningRequestClazz.newInstance();
			
			//request.setId( operation.getFeature().getVersionedIdentifier().getIdentifier());
			Method m_setId = provisioningRequestClazz.getMethod( "setId", new Class[] { java.lang.String.class } );
			m_setId.invoke(request, new Object[] { operation.getFeature().getVersionedIdentifier().getIdentifier() } );
			
			//request.setVersion(operation.getFeature().getVersionedIdentifier().getVersion().toString());
			Method m_setVersion = provisioningRequestClazz.getMethod( "setVersion", new Class[] { java.lang.String.class } );
			m_setVersion.invoke(request, new Object[] { operation.getFeature().getVersionedIdentifier().getVersion().toString() } );
			
			//request.setUrl(operation.getFeature().getSite().getURL().toExternalForm().replaceFirst("site.xml", ""));
			Method m_setUrl = provisioningRequestClazz.getMethod( "setUrl", new Class[] { java.lang.String.class } );
			m_setUrl.invoke(request, new Object[] { operation.getFeature().getSite().getURL().toExternalForm().replaceFirst("site.xml", "") } );
			
			//request.setAction( "install" );
			Method m_setAction = provisioningRequestClazz.getMethod( "setAction", new Class[] { java.lang.String.class } );
			m_setAction.invoke(request, new Object[] { "install" } );
			
			//request.setMatch( "perfect" );
			Method m_setMatch = provisioningRequestClazz.getMethod( "setMatch", new Class[] { java.lang.String.class } );
			m_setMatch.invoke(request, new Object[] { "perfect" } );			
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InstantiationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SecurityException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return request;		
	}
}
