/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Chris Aniszczyk <zx@us.ibm.com> - use provisioning to uninstall
 *     Brian Lillie <brianlil@us.ibm.com> - remove UpdateUI.requestRestart call
 *     Paul Foreman <pforeman@us.ibm.com> - modify isEnabled to also check super.isEnabled()
 *******************************************************************************/
package org.eclipse.update.internal.ui.views;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.model.ConfiguredFeatureAdapter;
import org.eclipse.update.internal.ui.wizards.ProvisioningRequestAdapter;
import org.eclipse.update.operations.IFeatureOperation;
import org.eclipse.update.operations.OperationsManager;

public class UnconfigureAndUninstallFeatureAction extends FeatureAction {

	private ConfiguredFeatureAdapter[] adapters;

	public UnconfigureAndUninstallFeatureAction(Shell shell, String text) {
		super(shell, text);
		setWindowTitle(UpdateUIMessages.FeatureUnconfigureAndUninstallAction_dialogTitle);
	}

	public void run() {
		try {
			IStatus status = OperationsManager.getValidator().validatePlatformConfigValid();
			if (status != null)
				throw new CoreException(status);
			
			if (adapters == null || !confirm(UpdateUIMessages.FeatureUnconfigureAndUninstallAction_question))
				return;

			// If current config is broken, confirm with the user to continue
			if (OperationsManager.getValidator().validateCurrentState() != null &&
					!confirm(UpdateUIMessages.Actions_brokenConfigQuestion))
				return;
			
			IFeature[] features = new IFeature[adapters.length];
			IConfiguredSite[] configuredSites = new IConfiguredSite[adapters.length];
			for( int i = 0; i < adapters.length; i++) {
				features[i] = adapters[i].getFeature(null);
				configuredSites[i] = adapters[i].getConfiguredSite();
			}
			
			Object[] requests = ProvisioningRequestAdapter.getRequests(features, "uninstall");

			Object service = UpdateUI.getProvisioningService();
			//IStatus provisionStatus = service.process(requests, new NullProgressMonitor());
			IStatus provisionStatus = Status.OK_STATUS;
			Object tempStatus = null;
			try {
				Class provisioningServiceImplClazz = Class.forName( "com.ibm.rcp.provisioning.ProvisioningService" );
				Class provisioningRequestClazz = Class.forName( "com.ibm.rcp.provisioning.ProvisioningRequest" );
				Class provisioningRequestArrayClazz = Class.forName( "[Lcom.ibm.rcp.provisioning.ProvisioningRequest;" );
				
				Method m_process = provisioningServiceImplClazz.getMethod( "process", new Class[] { provisioningRequestArrayClazz, String.class, String.class, String.class, IProgressMonitor.class, boolean.class } );
				Object provisioningRequestArray = Array.newInstance(provisioningRequestClazz, requests.length);
				for (int i = 0; i < requests.length; i++) {
					Array.set(provisioningRequestArray, i, requests[i]);
				}
				
				String uid="Admin.added.requests";
				String version="1.0.0";
				String name = UpdateUIMessages.Provisioning_updateManagerRequests;
				
				tempStatus = m_process.invoke( service, new Object[] { provisioningRequestArray, uid, version, name, new NullProgressMonitor(), Boolean.FALSE } );
				provisionStatus = (IStatus)tempStatus;
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SecurityException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (NoSuchMethodException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalArgumentException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			
			if(!provisionStatus.isOK()) {
				throw new CoreException(provisionStatus);
			}

//			boolean restartNeeded = true;
//			UpdateUI.requestRestart(restartNeeded);

		} catch (CoreException e) {
			ErrorDialog.openError(shell, null, null, e.getStatus());
		//} catch (InvocationTargetException e) {
			//// This should not happen
			//UpdateUtils.logException(e.getTargetException());
		}
	}



	public void setSelection(IStructuredSelection selection) {
		this.adapters = (ConfiguredFeatureAdapter[]) selection.toList().toArray(new ConfiguredFeatureAdapter[selection.size()]);
		setText(UpdateUIMessages.FeatureUnconfigureAndUninstallAction_uninstall);
	}
	
	
	public boolean canExecuteAction() {
		if (adapters == null || adapters.length == 0)
			return false;

		for( int i = 0; i < adapters.length; i++) {

			try {
				// check for pending changes (e.g. if the feature has just been disabled)
				IFeatureOperation pendingOperation = OperationsManager.findPendingOperation(adapters[i].getFeature(null));
				if (pendingOperation != null)
					return false;

			} catch (CoreException e) {
				return false;
			}
		}

		return true;	
	}
	
	public boolean isEnabled() {
		return super.isEnabled() && canExecuteAction();
	}
}
