/*******************************************************************************
 * Copyright (c) 2000, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Chris Aniszczyk (zx@us.ibm.com) - Updated to call provisioning
 *     Brian Lillie (brianlil@us.ibm.com) - Remove call to UpdateUI.requestRestart
 *******************************************************************************/
package org.eclipse.update.internal.ui.views;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.model.ConfiguredFeatureAdapter;
import org.eclipse.update.internal.ui.wizards.ProvisioningRequestAdapter;
import org.eclipse.update.operations.OperationsManager;

public class FeatureStateAction extends FeatureAction {

	private ConfiguredFeatureAdapter adapter;

    public FeatureStateAction(Shell shell, String text) {
        super(shell, text);
        setWindowTitle(UpdateUIMessages.FeatureStateAction_dialogTitle);
    }
    
	public void setSelection(IStructuredSelection selection) {
		
		this.adapter = (ConfiguredFeatureAdapter) selection.getFirstElement();
		if (adapter.isConfigured()) {
			setText(UpdateUIMessages.FeatureStateAction_disable); 
		} else {
			setText(UpdateUIMessages.FeatureStateAction_enable); 
		}
	}

	public void run() {
		try {
			if (adapter == null)
				return;
			
			IStatus status = OperationsManager.getValidator().validatePlatformConfigValid();
			if (status != null)
				throw new CoreException(status);
			
			boolean isConfigured = adapter.isConfigured();
			// Ask user to confirm the operation
			String message =
				isConfigured
					? UpdateUIMessages.FeatureStateAction_disableQuestion
					: UpdateUIMessages.FeatureStateAction_EnableQuestion; 

			if (!confirm(message))
				return;

			// If current config is broken, confirm with the user to continue
			if (OperationsManager.getValidator().validateCurrentState() != null &&
					!confirm(UpdateUIMessages.Actions_brokenConfigQuestion)) 
				return;
			
			Object service = UpdateUI.getProvisioningService();
			if(service != null) {
				Object[] requests = 
					ProvisioningRequestAdapter.getRequests(adapter.getFeature(null), isConfigured ? "disable" : "enable" );
				//status = service.process( requests, new NullProgressMonitor() );
				Object tempStatus = null;
				try {
					Class provisioningServiceImplClazz = Class.forName( "com.ibm.rcp.provisioning.ProvisioningService" );
					Class provisioningRequestClazz = Class.forName( "com.ibm.rcp.provisioning.ProvisioningRequest" );
					Class provisioningRequestArrayClazz = Class.forName( "[Lcom.ibm.rcp.provisioning.ProvisioningRequest;" );
					
					Method m_process = provisioningServiceImplClazz.getMethod( "process", new Class[] { provisioningRequestArrayClazz, String.class, String.class, String.class, IProgressMonitor.class, boolean.class } );
					Object provisioningRequestArray = Array.newInstance(provisioningRequestClazz, requests.length);
					for (int i = 0; i < requests.length; i++) {
						Array.set(provisioningRequestArray, i, requests[i]);
					}

					String uid="Admin.added.requests";
					String version="1.0.0";
					String name = UpdateUIMessages.Provisioning_updateManagerRequests;
					
					tempStatus = m_process.invoke( service, new Object[] { provisioningRequestArray, uid, version, name, new NullProgressMonitor(), Boolean.FALSE } );
					status = (IStatus)tempStatus;
				} catch (ClassNotFoundException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (SecurityException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (NoSuchMethodException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IllegalArgumentException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IllegalAccessException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (InvocationTargetException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			
			if(!status.isOK()) {
				throw new CoreException(status);
			}
			
//			IOperation toggleOperation =
//				isConfigured
//					? (IOperation)OperationsManager
//						.getOperationFactory()
//						.createUnconfigOperation(
//						adapter.getConfiguredSite(),
//						adapter.getFeature(null))
//					: OperationsManager
//						.getOperationFactory()
//						.createConfigOperation(
//						adapter.getConfiguredSite(),
//						adapter.getFeature(null));

//			UpdateUI.requestRestart(true);

		} catch (CoreException e) {
			ErrorDialog.openError(shell,
                    null, null, e.getStatus());
		}
//		} catch (InvocationTargetException e) {
//			// This should not happen
//			UpdateUtils.logException(e.getTargetException());
//		}
	}
	
	public boolean canExecuteAction() {
		return true;
	}

}
