/*******************************************************************************
 * Copyright (c) 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Paul Foreman (pforeman@us.ibm.com) - Removing need for compatibility plugin 
 *******************************************************************************/

package org.eclipse.update.internal.ui;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class UpdateUIPreferenceInitializer extends AbstractPreferenceInitializer {

	private static final String PREFERENCES_ROOT = "org.eclipse.update.ui";
	
	public UpdateUIPreferenceInitializer() {
		super();
	}
	
	public void initializeDefaultPreferences() {
		IEclipsePreferences prefs = new DefaultScope().getNode( PREFERENCES_ROOT );
		prefs.putBoolean(UpdateUI.P_DISCOVERY_SITES_ENABLED, true);
		prefs.putBoolean(UpdateUI.P_UPDATE_SITES_ENABLED, true);	
	}
}