/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.help.internal.server;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.appserver.IWebappServer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class WebappManager {

	private static int port = -1;
	private static String APPSERVER_EXT = "org.eclipse.help.appserver.server";
	private static IWebappServer server = null;
	
	public static void start(String webappName) throws Exception {
		
		IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(APPSERVER_EXT);
		if (point != null) {
			IExtension[] extensions = point.getExtensions();
			if (extensions != null) {
				for (int i = 0; i < extensions.length; i++) {
					IConfigurationElement[] els = extensions[i].getConfigurationElements();
					for (int j = 0; j < els.length; j++) {
						if ("server".equals(els[j].getName())) {
							 server = (IWebappServer) els[j].createExecutableExtension("class");
							 server.start(0, "localhost");
						}
					}
				}
			}
		} else {
			checkBundle();
		}
	}
	
	/*
	 * Ensures that the bundle with the specified name and the highest available
	 * version is started and reads the port number
	 */
	private static void checkBundle() throws InvalidSyntaxException, BundleException {
		Bundle bundle = Platform.getBundle("org.eclipse.equinox.http.registry"); //$NON-NLS-1$if (bundle != null) {
		if (bundle.getState() == Bundle.RESOLVED) {
			bundle.start(Bundle.START_TRANSIENT);
		}
		if (port == -1) {
			// Jetty selected a port number for us
			ServiceReference[] reference = bundle.getBundleContext().getServiceReferences("org.osgi.service.http.HttpService", "(other.info=org.eclipse.help)"); //$NON-NLS-1$ //$NON-NLS-2$
			Object assignedPort = reference[0].getProperty("http.port"); //$NON-NLS-1$
			port = Integer.parseInt((String)assignedPort);
		}
	}

	public static void stop(String webappName) throws CoreException {		
		if(server != null) {
			server.stop();
		}	
	}

	public static int getPort() {
		return server.getPort();		
	}

	public static String getHost() {
		return server.getHost();
	}
	
	private WebappManager() {
	}
	
}
