/*******************************************************************************
 * Copyright (c) 2003, 2013 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Liming Zhan (IBM Corp.) - Add some JNI methods
 *******************************************************************************/
#include "swt.h"
#include "xpcom_structs.h"
#include "xpcom_stats.h"

extern "C" {

#define XPCOM_NATIVE(func) Java_com_ibm_rcp_dombrowser_internal_mozilla_XPCOM_##func

#ifndef NO_Call
JNIEXPORT jlong JNICALL XPCOM_NATIVE(Call)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jlong arg2, jbyteArray arg3, jint arg4, jint arg5, jintArray arg6)
{
	jbyte *lparg3=NULL;
	jint *lparg6=NULL;
	jlong rc = 0;
	XPCOM_NATIVE_ENTER(env, that, Call_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jlong)((nsWriteSegmentFun)arg0)((nsIInputStream *)arg1, (void *)arg2, (const char *)lparg3, arg4, arg5, (PRUint32 *)lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, Call_FUNC);
	return rc;
}
#endif
#ifndef NO_nsIScriptGlobalObject_1GetScopeObject
JNIEXPORT jlong JNICALL XPCOM_NATIVE(nsIScriptGlobalObject_1GetScopeObject)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong result = 0;
	XPCOM_NATIVE_ENTER(env, that, nsIScriptGlobalObject_1GetScopeObject_FUNC);
	result = (jlong)((nsIDocument *)arg0)->GetScopeObject();
	XPCOM_NATIVE_EXIT(env, that, nsIScriptGlobalObject_1GetScopeObject_FUNC);
	return result;
	
}
#endif
#ifndef NO_NS_1GetComponentManager
JNIEXPORT jint JNICALL XPCOM_NATIVE(NS_1GetComponentManager)
	(JNIEnv *env, jclass that, jlongArray arg0)
{
	jlong *lparg0=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, NS_1GetComponentManager_FUNC);
	if (arg0) if ((lparg0 = env->GetLongArrayElements(arg0, NULL)) == NULL) goto fail;
	rc = (jint)NS_GetComponentManager((nsIComponentManager**)lparg0);
fail:
	if (arg0 && lparg0) env->ReleaseLongArrayElements(arg0, lparg0, 0);
	XPCOM_NATIVE_EXIT(env, that, NS_1GetComponentManager_FUNC);
	return rc;
}
#endif

#ifndef NO_NS_1GetServiceManager
JNIEXPORT jint JNICALL XPCOM_NATIVE(NS_1GetServiceManager)
	(JNIEnv *env, jclass that, jlongArray arg0)
{
	jlong *lparg0=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, NS_1GetServiceManager_FUNC);
	if (arg0) if ((lparg0 = env->GetLongArrayElements(arg0, NULL)) == NULL) goto fail;
	rc = (jint)NS_GetServiceManager((nsIServiceManager**)lparg0);
fail:
	if (arg0 && lparg0) env->ReleaseLongArrayElements(arg0, lparg0, 0);
	XPCOM_NATIVE_EXIT(env, that, NS_1GetServiceManager_FUNC);
	return rc;
}
#endif

#ifndef NO_NS_1InitXPCOM2
JNIEXPORT jint JNICALL XPCOM_NATIVE(NS_1InitXPCOM2)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jlong arg2)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, NS_1InitXPCOM2_FUNC);
	rc = (jint)NS_InitXPCOM2((nsIServiceManager **)arg0, (nsIFile *)arg1, (nsIDirectoryServiceProvider *)arg2);
	XPCOM_NATIVE_EXIT(env, that, NS_1InitXPCOM2_FUNC);
	return rc;
}
#endif

#ifndef NO_NS_1NewLocalFile
JNIEXPORT jint JNICALL XPCOM_NATIVE(NS_1NewLocalFile)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1, jlongArray arg2)
{
	jlong *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, NS_1NewLocalFile_FUNC);
	if (arg2) if ((lparg2 = env->GetLongArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)NS_NewLocalFile(*(nsAString *)arg0, arg1, (nsIFile**)lparg2);
fail:
	if (arg2 && lparg2) env->ReleaseLongArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, NS_1NewLocalFile_FUNC);
	return rc;
}
#endif

#ifndef NO_free
JNIEXPORT void JNICALL XPCOM_NATIVE(free)
	(JNIEnv *env, jclass that, jlong arg0)
{
	XPCOM_NATIVE_ENTER(env, that, free_FUNC);
	free((void *)arg0);
	XPCOM_NATIVE_EXIT(env, that, free_FUNC);
}
#endif

#ifndef NO_nsfree
JNIEXPORT void JNICALL XPCOM_NATIVE(nsfree)
	(JNIEnv *env, jclass that, jlong arg0)
{
	XPCOM_NATIVE_ENTER(env, that, free_FUNC);
	NS_Free((void *)arg0);
	XPCOM_NATIVE_EXIT(env, that, free_FUNC);
}
#endif


#ifndef NO_malloc
JNIEXPORT jlong JNICALL XPCOM_NATIVE(malloc)
	(JNIEnv *env, jclass that, jint arg0)
{
	jlong rc = 0;
	XPCOM_NATIVE_ENTER(env, that, malloc_FUNC);
	rc = (jlong)malloc(arg0);
	XPCOM_NATIVE_EXIT(env, that, malloc_FUNC);
	return rc;
}
#endif

#ifndef NO_XPCOMGlueShutdown
JNIEXPORT jint JNICALL XPCOM_NATIVE(XPCOMGlueShutdown)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, XPCOMGlueShutdown_FUNC);
	// commented out as its not used from java code as well
	//rc = (jint)XPCOMGlueShutdown();
	XPCOM_NATIVE_EXIT(env, that, XPCOMGlueShutdown_FUNC);
	return rc;
}
#endif

#ifndef NO_XPCOMGlueStartup
JNIEXPORT jint JNICALL XPCOM_NATIVE(XPCOMGlueStartup)
	(JNIEnv *env, jclass that, jbyteArray arg0)
{
	jbyte *lparg0=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, XPCOMGlueStartup_FUNC);
	if (arg0) if ((lparg0 = env->GetByteArrayElements(arg0, NULL)) == NULL) goto fail;
	rc = (jint)XPCOMGlueStartup((const char *)lparg0);
fail:
	if (arg0 && lparg0) env->ReleaseByteArrayElements(arg0, lparg0, 0);
	XPCOM_NATIVE_EXIT(env, that, XPCOMGlueStartup_FUNC);
	return rc;
}
#endif

#ifndef NO_memmove__JLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2I
JNIEXPORT void JNICALL XPCOM_NATIVE(memmove__JLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2I)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2)
{
	nsID _arg1, *lparg1=NULL;
	XPCOM_NATIVE_ENTER(env, that, memmove__JLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2I_FUNC);
	if (arg1) if ((lparg1 = getnsIDFields(env, arg1, &_arg1)) == NULL) goto fail;
	memmove((void *)arg0, (const void *)lparg1, (size_t)arg2);
fail:
	if (arg1 && lparg1) setnsIDFields(env, arg1, lparg1);
	XPCOM_NATIVE_EXIT(env, that, memmove__JLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2I_FUNC);
}
#endif

#ifndef NO_memmove__J_3BI
JNIEXPORT void JNICALL XPCOM_NATIVE(memmove__J_3BI)
	(JNIEnv *env, jclass that, jlong arg0, jbyteArray arg1, jint arg2)
{
	jbyte *lparg1=NULL;
	XPCOM_NATIVE_ENTER(env, that, memmove__J_3BI_FUNC);
	if (arg1) if ((lparg1 = env->GetByteArrayElements(arg1, NULL)) == NULL) goto fail;
	memmove((void *)arg0, (const void *)lparg1, (size_t)arg2);
fail:
	if (arg1 && lparg1) env->ReleaseByteArrayElements(arg1, lparg1, 0);
	XPCOM_NATIVE_EXIT(env, that, memmove__J_3BI_FUNC);
}
#endif

#ifndef NO_memmove__J_3CI
JNIEXPORT void JNICALL XPCOM_NATIVE(memmove__J_3CI)
	(JNIEnv *env, jclass that, jlong arg0, jcharArray arg1, jint arg2)
{
	jchar *lparg1=NULL;
	XPCOM_NATIVE_ENTER(env, that, memmove__J_3CI_FUNC);
	if (arg1) if ((lparg1 = env->GetCharArrayElements(arg1, NULL)) == NULL) goto fail;
	memmove((void *)arg0, (const void *)lparg1, (size_t)arg2);
fail:
	if (arg1 && lparg1) env->ReleaseCharArrayElements(arg1, lparg1, 0);
	XPCOM_NATIVE_EXIT(env, that, memmove__J_3CI_FUNC);
}
#endif

#ifndef NO_memmove__J_3II
JNIEXPORT void JNICALL XPCOM_NATIVE(memmove__J_3II)
	(JNIEnv *env, jclass that, jlong arg0, jintArray arg1, jint arg2)
{
	jint *lparg1=NULL;
	XPCOM_NATIVE_ENTER(env, that, memmove__J_3II_FUNC);
	if (arg1) if ((lparg1 = env->GetIntArrayElements(arg1, NULL)) == NULL) goto fail;
	memmove((void *)arg0, (const void *)lparg1, (size_t)arg2);
fail:
	if (arg1 && lparg1) env->ReleaseIntArrayElements(arg1, lparg1, 0);
	XPCOM_NATIVE_EXIT(env, that, memmove__J_3II_FUNC);
}
#endif

#ifndef NO_memmove__J_3JI
JNIEXPORT void JNICALL XPCOM_NATIVE(memmove__J_3JI)
	(JNIEnv *env, jclass that, jlong arg0, jlongArray arg1, jint arg2)
{
	jlong *lparg1=NULL;
	XPCOM_NATIVE_ENTER(env, that, memmove__J_3JI_FUNC);
	if (arg1) if ((lparg1 = env->GetLongArrayElements(arg1, NULL)) == NULL) goto fail;
	memmove((void *)arg0, (const void *)lparg1, (size_t)arg2);
fail:
	if (arg1 && lparg1) env->ReleaseLongArrayElements(arg1, lparg1, 0);
	XPCOM_NATIVE_EXIT(env, that, memmove__J_3JI_FUNC);
}
#endif

#ifndef NO_memmove__Lcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2JI
JNIEXPORT void JNICALL XPCOM_NATIVE(memmove__Lcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	nsID _arg0, *lparg0=NULL;
	XPCOM_NATIVE_ENTER(env, that, memmove__Lcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2JI_FUNC);
	if (arg0) if ((lparg0 = getnsIDFields(env, arg0, &_arg0)) == NULL) goto fail;
	memmove((void *)lparg0, (const void *)arg1, (size_t)arg2);
fail:
	if (arg0 && lparg0) setnsIDFields(env, arg0, lparg0);
	XPCOM_NATIVE_EXIT(env, that, memmove__Lcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2JI_FUNC);
}
#endif

#ifndef NO_memmove___3BJI
JNIEXPORT void JNICALL XPCOM_NATIVE(memmove___3BJI)
	(JNIEnv *env, jclass that, jbyteArray arg0, jlong arg1, jint arg2)
{
	jbyte *lparg0=NULL;
	XPCOM_NATIVE_ENTER(env, that, memmove___3BJI_FUNC);
	if (arg0) if ((lparg0 = env->GetByteArrayElements(arg0, NULL)) == NULL) goto fail;
	memmove((void *)lparg0, (const void *)arg1, (size_t)arg2);
fail:
	if (arg0 && lparg0) env->ReleaseByteArrayElements(arg0, lparg0, 0);
	XPCOM_NATIVE_EXIT(env, that, memmove___3BJI_FUNC);
}
#endif

#ifndef NO_memmove___3B_3CI
JNIEXPORT void JNICALL XPCOM_NATIVE(memmove___3B_3CI)
	(JNIEnv *env, jclass that, jbyteArray arg0, jcharArray arg1, jint arg2)
{
	jbyte *lparg0=NULL;
	jchar *lparg1=NULL;
	XPCOM_NATIVE_ENTER(env, that, memmove___3B_3CI_FUNC);
	if (arg0) if ((lparg0 = env->GetByteArrayElements(arg0, NULL)) == NULL) goto fail;
	if (arg1) if ((lparg1 = env->GetCharArrayElements(arg1, NULL)) == NULL) goto fail;
	memmove((void *)lparg0, (const void *)lparg1, (size_t)arg2);
fail:
	if (arg1 && lparg1) env->ReleaseCharArrayElements(arg1, lparg1, 0);
	if (arg0 && lparg0) env->ReleaseByteArrayElements(arg0, lparg0, 0);
	XPCOM_NATIVE_EXIT(env, that, memmove___3B_3CI_FUNC);
}
#endif

#ifndef NO_memmove___3CJI
JNIEXPORT void JNICALL XPCOM_NATIVE(memmove___3CJI)
	(JNIEnv *env, jclass that, jcharArray arg0, jlong arg1, jint arg2)
{
	jchar *lparg0=NULL;
	XPCOM_NATIVE_ENTER(env, that, memmove___3CJI_FUNC);
	if (arg0) if ((lparg0 = env->GetCharArrayElements(arg0, NULL)) == NULL) goto fail;
	memmove((void *)lparg0, (const void *)arg1, (size_t)arg2);
fail:
	if (arg0 && lparg0) env->ReleaseCharArrayElements(arg0, lparg0, 0);
	XPCOM_NATIVE_EXIT(env, that, memmove___3CJI_FUNC);
}
#endif

#ifndef NO_memmove___3IJI
JNIEXPORT void JNICALL XPCOM_NATIVE(memmove___3IJI)
	(JNIEnv *env, jclass that, jintArray arg0, jlong arg1, jint arg2)
{
	jint *lparg0=NULL;
	XPCOM_NATIVE_ENTER(env, that, memmove___3IJI_FUNC);
	if (arg0) if ((lparg0 = env->GetIntArrayElements(arg0, NULL)) == NULL) goto fail;
	memmove((void *)lparg0, (const void *)arg1, (size_t)arg2);
fail:
	if (arg0 && lparg0) env->ReleaseIntArrayElements(arg0, lparg0, 0);
	XPCOM_NATIVE_EXIT(env, that, memmove___3IJI_FUNC);
}
#endif

#ifndef NO_memmove___3JJI
JNIEXPORT void JNICALL XPCOM_NATIVE(memmove___3JJI)
	(JNIEnv *env, jclass that, jlongArray arg0, jlong arg1, jint arg2)
{
	jlong *lparg0=NULL;
	XPCOM_NATIVE_ENTER(env, that, memmove___3JJI_FUNC);
	if (arg0) if ((lparg0 = env->GetLongArrayElements(arg0, NULL)) == NULL) goto fail;
	memmove((void *)lparg0, (const void *)arg1, (size_t)arg2);
fail:
	if (arg0 && lparg0) env->ReleaseLongArrayElements(arg0, lparg0, 0);
	XPCOM_NATIVE_EXIT(env, that, memmove___3JJI_FUNC);
}
#endif

#ifndef NO_nsEmbedCString_1Length
JNIEXPORT jint JNICALL XPCOM_NATIVE(nsEmbedCString_1Length)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsEmbedCString_1Length_FUNC);
	rc = (jint)((nsEmbedCString *)arg0)->Length();
	XPCOM_NATIVE_EXIT(env, that, nsEmbedCString_1Length_FUNC);
	return rc;
}
#endif

#ifndef NO_nsEmbedCString_1delete
JNIEXPORT void JNICALL XPCOM_NATIVE(nsEmbedCString_1delete)
	(JNIEnv *env, jclass that, jlong arg0)
{
	XPCOM_NATIVE_ENTER(env, that, nsEmbedCString_1delete_FUNC);
	delete (nsEmbedCString *)arg0;
	XPCOM_NATIVE_EXIT(env, that, nsEmbedCString_1delete_FUNC);
}
#endif

#ifndef NO_nsEmbedCString_1get
JNIEXPORT jlong JNICALL XPCOM_NATIVE(nsEmbedCString_1get)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsEmbedCString_1get_FUNC);
	rc = (jlong)((nsEmbedCString *)arg0)->get();
	XPCOM_NATIVE_EXIT(env, that, nsEmbedCString_1get_FUNC);
	return rc;
}
#endif

#ifndef NO_nsEmbedCString_1new__
JNIEXPORT jlong JNICALL XPCOM_NATIVE(nsEmbedCString_1new__)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsEmbedCString_1new___FUNC);
	rc = (jlong)new nsEmbedCString();
	XPCOM_NATIVE_EXIT(env, that, nsEmbedCString_1new___FUNC);
	return rc;
}
#endif

#ifndef NO_nsEmbedCString_1new__JI
JNIEXPORT jlong JNICALL XPCOM_NATIVE(nsEmbedCString_1new__JI)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jlong rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsEmbedCString_1new__JI_FUNC);
	rc = (jlong)new nsEmbedCString((const char *)arg0, arg1);
	XPCOM_NATIVE_EXIT(env, that, nsEmbedCString_1new__JI_FUNC);
	return rc;
}
#endif

#ifndef NO_nsEmbedCString_1new___3BI
JNIEXPORT jlong JNICALL XPCOM_NATIVE(nsEmbedCString_1new___3BI)
	(JNIEnv *env, jclass that, jbyteArray arg0, jint arg1)
{
	jbyte *lparg0=NULL;
	jlong rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsEmbedCString_1new___3BI_FUNC);
	if (arg0) if ((lparg0 = env->GetByteArrayElements(arg0, NULL)) == NULL) goto fail;
	rc = (jlong)new nsEmbedCString((const char *)lparg0, arg1);
fail:
	if (arg0 && lparg0) env->ReleaseByteArrayElements(arg0, lparg0, 0);
	XPCOM_NATIVE_EXIT(env, that, nsEmbedCString_1new___3BI_FUNC);
	return rc;
}
#endif

#ifndef NO_nsEmbedString_1Length
JNIEXPORT jint JNICALL XPCOM_NATIVE(nsEmbedString_1Length)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsEmbedString_1Length_FUNC);
	rc = (jint)((nsEmbedString *)arg0)->Length();
	XPCOM_NATIVE_EXIT(env, that, nsEmbedString_1Length_FUNC);
	return rc;
}
#endif

#ifndef NO_nsEmbedString_1delete
JNIEXPORT void JNICALL XPCOM_NATIVE(nsEmbedString_1delete)
	(JNIEnv *env, jclass that, jlong arg0)
{
	XPCOM_NATIVE_ENTER(env, that, nsEmbedString_1delete_FUNC);
	delete (nsEmbedString *)arg0;
	XPCOM_NATIVE_EXIT(env, that, nsEmbedString_1delete_FUNC);
}
#endif

#ifndef NO_nsEmbedString_1get
JNIEXPORT jlong JNICALL XPCOM_NATIVE(nsEmbedString_1get)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsEmbedString_1get_FUNC);
	rc = (jlong)((nsEmbedString *)arg0)->get();
	XPCOM_NATIVE_EXIT(env, that, nsEmbedString_1get_FUNC);
	return rc;
}
#endif

#ifndef NO_nsEmbedString_1new__
JNIEXPORT jlong JNICALL XPCOM_NATIVE(nsEmbedString_1new__)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsEmbedString_1new___FUNC);
	rc = (jlong)new nsEmbedString();
	XPCOM_NATIVE_EXIT(env, that, nsEmbedString_1new___FUNC);
	return rc;
}
#endif

#ifndef NO_nsEmbedString_1new___3C
JNIEXPORT jlong JNICALL XPCOM_NATIVE(nsEmbedString_1new___3C)
	(JNIEnv *env, jclass that, jcharArray arg0)
{
	jchar *lparg0=NULL;
	jlong rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsEmbedString_1new___3C_FUNC);
	if (arg0) if ((lparg0 = env->GetCharArrayElements(arg0, NULL)) == NULL) goto fail;
	rc = (jlong)new nsEmbedString((char16_t *)lparg0);
fail:
	if (arg0 && lparg0) env->ReleaseCharArrayElements(arg0, lparg0, 0);
	XPCOM_NATIVE_EXIT(env, that, nsEmbedString_1new___3C_FUNC);
	return rc;
}
#endif

#ifndef NO_nsID_1Equals
JNIEXPORT jboolean JNICALL XPCOM_NATIVE(nsID_1Equals)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	jboolean rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsID_1Equals_FUNC);
	rc = (jboolean)((nsID *)arg0)->Equals(*(nsID *)arg1);
	XPCOM_NATIVE_EXIT(env, that, nsID_1Equals_FUNC);
	return rc;
}
#endif

#ifndef NO_nsID_1delete
JNIEXPORT void JNICALL XPCOM_NATIVE(nsID_1delete)
	(JNIEnv *env, jclass that, jlong arg0)
{
	XPCOM_NATIVE_ENTER(env, that, nsID_1delete_FUNC);
	delete (nsID *)arg0;
	XPCOM_NATIVE_EXIT(env, that, nsID_1delete_FUNC);
}
#endif

#ifndef NO_nsID_1new
JNIEXPORT jlong JNICALL XPCOM_NATIVE(nsID_1new)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsID_1new_FUNC);
	rc = (jlong)new nsID();
	XPCOM_NATIVE_EXIT(env, that, nsID_1new_FUNC);
	return rc;
}
#endif

#ifndef NO_strlen
JNIEXPORT jint JNICALL XPCOM_NATIVE(strlen)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, strlen_FUNC);
	rc = (jint)strlen((char *)arg0);
	XPCOM_NATIVE_EXIT(env, that, strlen_FUNC);
	return rc;
}
#endif

//}
//==========================================================from xpcomex.cpp==========================================================

#ifndef NO_nsCString_1new___3BI
JNIEXPORT jlong JNICALL XPCOM_NATIVE(nsCString_1new___3BI)
	(JNIEnv *env, jclass, jbyteArray arg0, jint length)
{
	jbyte *lparg0=NULL;
	jlong rc;
	if (arg0) lparg0 = env->GetByteArrayElements(arg0, NULL);
	rc = (jlong)new nsCString((const char *)lparg0, length);
	if (arg0) env->ReleaseByteArrayElements(arg0, lparg0, 0);
	return rc;
}
#endif

#ifndef NO_nsCString_1delete
JNIEXPORT void JNICALL XPCOM_NATIVE(nsCString_1delete)
	(JNIEnv *, jclass that, jlong arg0)
{
	delete (nsCString *)arg0;
}
#endif

#ifndef NO_nsCRT_1strlen_1PRUnichar
JNIEXPORT jint JNICALL XPCOM_NATIVE(nsCRT_1strlen_1PRUnichar)
	(JNIEnv *env, jclass, jlong arg0)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, strlen_FUNC);
	rc = (jint)strlen((char *)arg0);
	XPCOM_NATIVE_ENTER(env, that, strlen_FUNC);
	return rc;
}
#endif

#ifndef NO_nsCString_1new__
JNIEXPORT jlong JNICALL XPCOM_NATIVE(nsCString_1new__)
	(JNIEnv *env, jclass)
{
	return (jlong)new nsCString();
}
#endif

#ifndef NO_nsCString_1Length
JNIEXPORT jint JNICALL XPCOM_NATIVE(nsCString_1Length)
	(JNIEnv *env, jclass, jlong arg0)
{
	nsCString *lparg0 = NULL;
	if (arg0 != 0)
		lparg0 = (nsCString *)arg0;
	return (jint)lparg0->Length();
}
#endif

#ifndef NO_nsCString_1get
JNIEXPORT jlong JNICALL XPCOM_NATIVE(nsCString_1get)
	(JNIEnv *env, jclass, jlong arg0)
{
	nsCString *lparg0 = NULL;
	if (arg0 != 0)
		lparg0 = (nsCString *)arg0;
	return (jlong)lparg0->get();
}
#endif

/*
#ifndef NO_
JNIEXPORT void JNICALL XPCOM_NATIVE(VtblCallNoRet__III)
  (JNIEnv *env, jclass, jint fnNumber, jint ppVtbl, jint arg0)
{
	P_OLE_FN_2N fn = (P_OLE_FN_2N)(*(int **)ppVtbl)[fnNumber];
	fn(ppVtbl, arg0);
	return;
}
#endif
*/


//===========story 933====================================
#ifndef NO_memmove__JLcom_ibm_rcp_dombrowser_internal_mozilla_nsDynamicFunctionLoad_2J
extern "C" JNIEXPORT void JNICALL XPCOM_NATIVE(memmove__JLcom_ibm_rcp_dombrowser_internal_mozilla_nsDynamicFunctionLoad_2J)(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jlong arg2);
JNIEXPORT void JNICALL XPCOM_NATIVE(memmove__JLcom_ibm_rcp_dombrowser_internal_mozilla_nsDynamicFunctionLoad_2J)(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jlong arg2)

{
	nsDynamicFunctionLoad _arg1, *lparg1=NULL;

	XPCOM_NATIVE_ENTER(env, that, memmove__JLcom_ibm_rcp_dombrowser_internal_mozilla_nsDynamicFunctionLoad_2J_FUNC);

	if (arg1) if ((lparg1 = getnsDynamicFunctionLoadFields(env, arg1, &_arg1)) == NULL) goto fail;
	memmove((void *)arg0, (const void *)lparg1, (size_t)arg2);
fail:

	XPCOM_NATIVE_EXIT(env, that, memmove__JLcom_ibm_rcp_dombrowser_internal_mozilla_nsDynamicFunctionLoad_2J_FUNC);
}
#endif

#ifndef NO_nsDynamicFunctionLoad_1sizeof
extern "C" JNIEXPORT jint JNICALL XPCOM_NATIVE(nsDynamicFunctionLoad_1sizeof)(JNIEnv *env, jclass that);
JNIEXPORT jint JNICALL XPCOM_NATIVE(nsDynamicFunctionLoad_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsDynamicFunctionLoad_1sizeof_FUNC);
	rc = (jint)nsDynamicFunctionLoad_sizeof();
	XPCOM_NATIVE_EXIT(env, that, nsDynamicFunctionLoad_1sizeof_FUNC);
	return rc;
}
#endif


#ifndef NO__1XPCOMGlueLoadXULFunctions
extern "C" JNIEXPORT jint JNICALL XPCOM_NATIVE(_1XPCOMGlueLoadXULFunctions)(JNIEnv *env, jclass that, jlong arg0);
JNIEXPORT jint JNICALL XPCOM_NATIVE(_1XPCOMGlueLoadXULFunctions)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, _1XPCOMGlueLoadXULFunctions_FUNC);
	rc = (jint)XPCOMGlueLoadXULFunctions((const nsDynamicFunctionLoad *)arg0);
	XPCOM_NATIVE_EXIT(env, that, _1XPCOMGlueLoadXULFunctions_FUNC);
	return rc;
}
#endif

// for xulrunner 10.0
#ifndef NO__1Call__JJJJ
extern "C" JNIEXPORT jint JNICALL XPCOM_NATIVE(_1Call__JJJJ)(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jlong arg2, jlong arg3);
JNIEXPORT jint JNICALL XPCOM_NATIVE(_1Call__JJJJ)(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jlong arg2, jlong arg3)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, _1Call__JJJJ_FUNC);
	rc = (jint)((SWT_XREInitEmbedding2)arg0)((nsILocalFile *)arg1, (nsILocalFile *)arg2, (nsIDirectoryServiceProvider *)arg3);
	XPCOM_NATIVE_EXIT(env, that, _1Call__JJJJ_FUNC);
	return rc;
}
#endif

// for xul 10.0
#ifndef NO__1Call__JIJ
extern "C" JNIEXPORT jint JNICALL XPCOM_NATIVE(_1Call__JIJ)(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2);
JNIEXPORT jint JNICALL XPCOM_NATIVE(_1Call__JIJ)(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, _1Call__JIJ_FUNC);
	rc = (jint)((SWT_XREAddManifestLocation)arg0)(arg1, (nsILocalFile *)arg2);
	XPCOM_NATIVE_EXIT(env, that, _1Call__JIJ_FUNC);
	return rc;
}
#endif

#ifndef NO__1Call__J
extern "C" JNIEXPORT jint JNICALL XPCOM_NATIVE(_1Call__J)(JNIEnv *env, jclass that, jlong arg0);
JNIEXPORT jint JNICALL XPCOM_NATIVE(_1Call__J)(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, _1Call__J_FUNC);
	rc = (jint)((jint (*)())arg0)();
	XPCOM_NATIVE_EXIT(env, that, _1Call__J_FUNC);
	return rc;
}
#endif


//===========end of story 933============

#ifndef NO_nsIScriptContext_1GetNativeContext
JNIEXPORT jlong JNICALL XPCOM_NATIVE(nsIScriptContext_1GetNativeContext)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsIScriptContext_1GetNativeContext_FUNC);
	rc = (jlong)((nsIScriptContext *)arg0)->GetNativeContext();
	XPCOM_NATIVE_EXIT(env, that, nsIScriptContext_1GetNativeContext_FUNC);
	return rc;
}
#endif

#ifndef NO_nsIScriptGlobalObject_1EnsureScriptEnvironment
JNIEXPORT jint JNICALL XPCOM_NATIVE(nsIScriptGlobalObject_1EnsureScriptEnvironment)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsIScriptGlobalObject_1EnsureScriptEnvironment_FUNC);
	rc = (jlong)((nsIScriptGlobalObject *)arg0)->EnsureScriptEnvironment();
	XPCOM_NATIVE_EXIT(env, that, nsIScriptGlobalObject_1EnsureScriptEnvironment_FUNC);
	return rc;
}
#endif

#ifndef NO_nsIScriptGlobalObject_1GetScriptContext
JNIEXPORT jlong JNICALL XPCOM_NATIVE(nsIScriptGlobalObject_1GetScriptContext)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jlong rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsIScriptGlobalObject_1GetScriptContext_FUNC);
	rc = (jlong)((nsIScriptGlobalObject *)arg0)->GetScriptContext();
	XPCOM_NATIVE_EXIT(env, that, nsIScriptGlobalObject_1GetScriptContext_FUNC);
	return rc;
}
#endif

#ifndef NO_nsIScriptGlobalObject_1GetScriptGlobal
JNIEXPORT jlong JNICALL XPCOM_NATIVE(nsIScriptGlobalObject_1GetScriptGlobal)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jlong rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsIScriptGlobalObject_1GetScriptGlobal_FUNC);
	rc = (jlong)((nsIScriptGlobalObject *)arg0)->GetGlobalJSObject();
	XPCOM_NATIVE_EXIT(env, that, nsIScriptGlobalObject_1GetScriptGlobal_FUNC);
	return rc;
}
#endif

//@@@
#ifndef NO_JS_1EvaluateUCScriptForPrincipals
JNIEXPORT jint JNICALL XPCOM_NATIVE(JS_1EvaluateUCScriptForPrincipals)
	(JNIEnv *env, jclass that, jbyteArray mozillaPath, jlong arg0, jlong arg1, jlong arg2, jcharArray arg3, jint arg4, jbyteArray arg5, jint arg6, jlongArray arg7)
{
	
	jbyte *lpmozillaPath=NULL;
	jchar *lparg3=NULL;
	jbyte *lparg5=NULL;
	jlong *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, JS_1EvaluateUCScriptForPrincipals_FUNC);
	if (mozillaPath) if ((lpmozillaPath = env->GetByteArrayElements(mozillaPath, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetByteArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetLongArrayElements(arg7, NULL)) == NULL) goto fail;
	
/*
	rc = (jint)JS_EvaluateUCScriptForPrincipals(arg0, arg1, arg2, lparg3, arg4, lparg5, arg6, lparg7);
*/
	{
#ifdef _WIN32
		static int initialized = 0;
		static FARPROC fp = NULL;
		if (!initialized) {
			HMODULE hm = LoadLibrary((const char *)lpmozillaPath);
			if (hm) {
				fp = GetProcAddress(hm, "JS_EvaluateUCScriptForPrincipals");
			}
			initialized = 1;
		}
//		LOAD_FUNCTION(fp, JS_EvaluateUCScriptForPrincipals)
		
		if (fp) {
			rc = (jint)((jint (*)(jlong, jlong, jlong, jchar *, jint, jbyte *, jint, jlong *))fp)(arg0, arg1, arg2, lparg3, arg4, lparg5, arg6, lparg7);
		}
		
#else
#define CALLING_CONVENTION

		static int initialized = 0;
		static void *fp = NULL;
		if (!initialized) {
			void* handle = dlopen((const char *)lpmozillaPath, RTLD_LAZY);
			if (handle) {
				fp = dlsym(handle, "JS_EvaluateUCScriptForPrincipals");
			}
			initialized = 1;
		}
		if (fp) {
			rc = (jint)((jint (CALLING_CONVENTION*)(jlong, jlong, jlong, jchar *, jint, jbyte *, jint, jlong *))fp)(arg0, arg1, arg2, lparg3, arg4, lparg5, arg6, lparg7);
		}
#endif /* _WIN32 */
	}
fail:
	if (arg7 && lparg7) env->ReleaseLongArrayElements(arg7, lparg7, 0);
	if (arg5 && lparg5) env->ReleaseByteArrayElements(arg5, lparg5, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	if (mozillaPath && lpmozillaPath) env->ReleaseByteArrayElements(mozillaPath, lpmozillaPath, 0);
	XPCOM_NATIVE_EXIT(env, that, JS_1EvaluateUCScriptForPrincipals_FUNC);
	return rc;
}
#endif

#ifndef NO__1JS_1GetGlobalObject
JNIEXPORT jlong JNICALL XPCOM_NATIVE(_1JS_1GetGlobalObject)
	(JNIEnv *env, jclass that, jbyteArray mozillaPath, jlong arg0)
{
	jbyte *lpmozillaPath=NULL;
	jlong rc = 0;
	XPCOM_NATIVE_ENTER(env, that, _1JS_1GetGlobalObject_FUNC);
	if (mozillaPath) if ((lpmozillaPath = env->GetByteArrayElements(mozillaPath, NULL)) == NULL) goto fail;
/*
	rc = (jlong)JS_GetGlobalObject(arg0);
*/
	{
	
#ifdef _WIN32
		static int initialized = 0;
		static FARPROC fp = NULL;
		if (!initialized) {
			HMODULE hm = LoadLibrary((const char *)lpmozillaPath);
			if (hm) {
				fp = GetProcAddress(hm, "JS_GetGlobalObject");
			}
			initialized = 1;
		}
		if (fp) {
			rc = (jlong)((jlong (*)(jlong))fp)(arg0);
		}
#else
#define CALLING_CONVENTION
		static int initialized = 0;
		static void *fp = NULL;
		if (!initialized) {
			void* handle = dlopen((const char *)lpmozillaPath, RTLD_LAZY);
			if (handle) {
				fp = dlsym(handle, "JS_GetGlobalObject");
			}
			initialized = 1;
		}
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
#endif /* _WIN32 */
	}
fail:
	if (mozillaPath && lpmozillaPath) env->ReleaseByteArrayElements(mozillaPath, lpmozillaPath, 0);
	XPCOM_NATIVE_EXIT(env, that, _1JS_1GetGlobalObject_FUNC);
	return rc;
}
#endif
    
#ifndef NO__1nsIMemory_1Alloc
extern "C" JNIEXPORT jlong JNICALL XPCOM_NATIVE(_1nsIMemory_1Alloc)(JNIEnv *env, jclass that, jlong arg0, jint arg1);
JNIEXPORT jlong JNICALL XPCOM_NATIVE(_1nsIMemory_1Alloc)
    (JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
    jlong rc = 0;
    XPCOM_NATIVE_ENTER(env, that, _1nsIMemory_1Alloc_FUNC);
    //rc = (jlong)((nsIMemory *)arg0)->Alloc((size_t)arg1);
	rc = (jlong) NS_Alloc((size_t)arg1);
    XPCOM_NATIVE_EXIT(env, that, _1nsIMemory_1Alloc_FUNC);
    return rc;
}
#endif
    
#ifndef NO__1nsIMemory_1Realloc
extern "C" JNIEXPORT jlong JNICALL XPCOM_NATIVE(_1nsIMemory_1Realloc)(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2);
JNIEXPORT jlong JNICALL XPCOM_NATIVE(_1nsIMemory_1Realloc)
    (JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2)
{
    jlong rc = 0;
    XPCOM_NATIVE_ENTER(env, that, _1nsIMemory_1Realloc_FUNC);
    //rc = (jlong)((nsIMemory *)arg0)->Realloc((void *)arg1, (size_t)arg2);
	rc = (jlong) NS_Realloc((void *)arg1, (size_t)arg2);
    XPCOM_NATIVE_EXIT(env, that, _1nsIMemory_1Realloc_FUNC);
    return rc;
}
#endif
    
//===========ended for Story370 Eclipse bug 259687 ============


//================Below section are all VtblCall generated from tool genJniStub ============
#ifndef NO_nsILoginManagerGetAllLogins__IJ_3I_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(nsILoginManagerGetAllLogins__IJ_3I_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jintArray arg2, jlongArray arg3)
{
	jint *lparg2=NULL;
	jlong *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsILoginManagerGetAllLogins__IJ_3I_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetIntArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint *, jlong **))(*(jlong **)arg1)[arg0])(arg1, lparg2, &lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseIntArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, nsILoginManagerGetAllLogins__IJ_3I_3J_FUNC);
	return rc;
}
#endif

#ifndef nsILoginManagerGetAllDisabledHosts__IJ_3I_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(nsILoginManagerGetAllDisabledHosts__IJ_3I_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jintArray arg2, jlongArray arg3)
{
	jint *lparg2=NULL;
	jlong *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsILoginManagerGetAllDisabledHosts__IJ_3I_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetIntArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint *, jlong **))(*(jlong **)arg1)[arg0])(arg1, lparg2, &lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseIntArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, nsILoginManagerGetAllDisabledHosts__IJ_3I_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_nsILoginManagerFindLogins__IJ_3IJJJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(nsILoginManagerFindLogins__IJ_3IJJJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jintArray arg2, jlong arg3, jlong arg4, jlong arg5, jlongArray arg6)
{
	jint *lparg2=NULL;
	jlong *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsILoginManagerFindLogins__IJ_3IJJJ_3J_FUNC);
	if (arg2) if((lparg2 = env->GetIntArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg6) if((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint *, jlong, jlong, jlong, jlong **))(*(jlong **)arg1)[arg0])(arg1, lparg2, arg3, arg4, arg5, &lparg6);
fail:
	if (arg2 && lparg2) env->ReleaseIntArrayElements(arg2, lparg2, 0);
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, JNI_COMMIT);
	XPCOM_NATIVE_EXIT(env, that, nsILoginManagerFindLogins__IJ_3IJJJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_nsILoginManagerSearchLogins__IJ_3IJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(nsILoginManagerSearchLogins__IJ_3IJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jintArray arg2, jlong arg3, jlongArray arg4)
{
	jint *lparg2=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, nsILoginManagerSearchLogins__IJ_3IJ_3J_FUNC);
	if (arg2) if((lparg2 = env->GetIntArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg4) if((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint *, jlong, jlong **))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, &lparg4);
fail:
	if (arg2 && lparg2) env->ReleaseIntArrayElements(arg2, lparg2, 0);
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, nsILoginManagerSearchLogins__IJ_3IJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong))(*(jlong**)arg1)[arg0])(arg1);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3C
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3C)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2)
{
	jchar *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3C_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *))(*(jlong**)arg1)[arg0])(arg1, lparg2);
fail:
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3C_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJF
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJF)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jfloat arg2)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJF_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jfloat))(*(jlong**)arg1)[arg0])(arg1, arg2);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJF_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3F
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3F)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jfloatArray arg2)
{
	jfloat *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3F_FUNC);
	if (arg2) if ((lparg2 = env->GetFloatArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jfloat *))(*(jlong**)arg1)[arg0])(arg1, lparg2);
fail:
	if (arg2 && lparg2) env->ReleaseFloatArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3F_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJI_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint))(*(jlong**)arg1)[arg0])(arg1, arg2);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jintArray arg2)
{
	jint *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetIntArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2);
fail:
	if (arg2 && lparg2) env->ReleaseIntArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlongArray arg2)
{
	jlong *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetLongArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2);
fail:
	if (arg2 && lparg2) env->ReleaseLongArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3S
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3S)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jshortArray arg2)
{
	jshort *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3S_FUNC);
	if (arg2) if ((lparg2 = env->GetShortArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jshort *))(*(jlong**)arg1)[arg0])(arg1, lparg2);
fail:
	if (arg2 && lparg2) env->ReleaseShortArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3S_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJII
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJII)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJII_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJII_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJI_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJI_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jintArray arg3)
{
	jint *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJI_3I_FUNC);
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJI_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJI_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJI_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jlongArray arg3)
{
	jlong *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJI_3J_FUNC);
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJI_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jintArray arg3)
{
	jint *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3I_FUNC);
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlongArray arg3)
{
	jlong *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3J_FUNC);
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jintArray arg3)
{
	jbyte *lparg2=NULL;
	jint *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jlongArray arg3)
{
	jbyte *lparg2=NULL;
	jlong *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jlong arg3)
{
	jbyte *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BJ_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jlong))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3);
fail:
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jint arg3)
{
	jbyte *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BI_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jint))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3);
fail:
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJI_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jobject arg3)
{
	nsID _arg3, *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_FUNC);
	if (arg3) if ((lparg3 = getnsIDFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, nsID *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3);
fail:
	if (arg3 && lparg3) setnsIDFields(env, arg3, lparg3);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJI_3C
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJI_3C)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jcharArray arg3)
{
	jchar *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJI_3C_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jchar *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJI_3C_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3CI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3CI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jcharArray arg3, jint arg4)
{
	jchar *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3CI_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jchar *, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4);
fail:
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3CI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jintArray arg2, jintArray arg3)
{
	jint *lparg2=NULL;
	jint *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3I_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetIntArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseIntArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3I_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3I_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jintArray arg2, jlongArray arg3)
{
	jint *lparg2=NULL;
	jlong *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3I_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetIntArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint *, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseIntArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3I_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jobject arg2, jlong arg3)
{
	nsID _arg2, *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2J_FUNC);
	if (arg2) if ((lparg2 = getnsIDFields(env, arg2, &_arg2)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, nsID *, jlong))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3);
fail:
	if (arg2 && lparg2) setnsIDFields(env, arg2, lparg2);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jobject arg2, jintArray arg3)
{
	nsID _arg2, *lparg2=NULL;
	jint *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3I_FUNC);
	if (arg2) if ((lparg2 = getnsIDFields(env, arg2, &_arg2)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, nsID *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) setnsIDFields(env, arg2, lparg2);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jobject arg2, jlongArray arg3)
{
	nsID _arg2, *lparg2=NULL;
	jlong *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J_FUNC);
	if (arg2) if ((lparg2 = getnsIDFields(env, arg2, &_arg2)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, nsID *, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) setnsIDFields(env, arg2, lparg2);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3C_3C
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3C_3C)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jcharArray arg3)
{
	jchar *lparg2=NULL;
	jchar *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3C_3C_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jchar *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3C_3C_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3J_3J_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3J_3J_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlongArray arg2, jlongArray arg3, jlongArray arg4)
{
	jlong *lparg2=NULL;
	jlong *lparg3=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3J_3J_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetLongArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong *, jlong *, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseLongArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3J_3J_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3I_3J_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3I_3J_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jintArray arg2, jlongArray arg3, jlongArray arg4)
{
	jint *lparg2=NULL;
	jlong *lparg3=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3I_3J_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetIntArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint *, jlong *, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseIntArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3I_3J_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BI_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BI_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jint arg3, jintArray arg4)
{
	jbyte *lparg2=NULL;
	jint *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BI_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jint, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BI_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jobject arg3, jintArray arg4)
{
	jbyte *lparg2=NULL;
	nsID _arg3, *lparg3=NULL;
	jint *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = getnsIDFields(env, arg3, &_arg3)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, nsID *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) setnsIDFields(env, arg3, lparg3);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jobject arg3, jlongArray arg4)
{
	jbyte *lparg2=NULL;
	nsID _arg3, *lparg3=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = getnsIDFields(env, arg3, &_arg3)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, nsID *, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) setnsIDFields(env, arg3, lparg3);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3CJ_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3CJ_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jlong arg3, jintArray arg4)
{
	jchar *lparg2=NULL;
	jint *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3CJ_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jlong, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3CJ_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3CJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3CJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jlong arg3, jlongArray arg4)
{
	jchar *lparg2=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3CJ_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3CJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3C_3C
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3C_3C)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jcharArray arg3, jcharArray arg4)
{
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3C_3C_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jchar *, jchar *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3C_3C_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJIII
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJIII)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jint arg4)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJIII_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJIII_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJIIJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJIIJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jlong arg4)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJIIJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJIIJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jint arg4)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJI_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJII
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJII)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jint arg4)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJII_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJII_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJII_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJII_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jintArray arg4)
{
	jint *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJII_3I_FUNC);
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJII_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJII_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJII_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jlongArray arg4)
{
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJII_3J_FUNC);
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJII_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlongArray arg4)
{
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJ_3J_FUNC);
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJ_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJ_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jintArray arg4)
{
	jint *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJ_3I_FUNC);
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJ_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJIJ_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJIJ_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jlong arg3, jintArray arg4)
{
	jint *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJIJ_3I_FUNC);
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jlong, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJIJ_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJI_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJI_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jintArray arg4)
{
	jint *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJI_3I_FUNC);
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJI_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJI_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJI_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jlongArray arg4)
{
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJI_3J_FUNC);
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJI_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jobject arg3, jlongArray arg4)
{
	nsID _arg3, *lparg3=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J_FUNC);
	if (arg3) if ((lparg3 = getnsIDFields(env, arg3, &_arg3)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, nsID *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) setnsIDFields(env, arg3, lparg3);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJII_3C
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJII_3C)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jcharArray arg4)
{
	jchar *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJII_3C_FUNC);
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jchar *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJII_3C_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2Lcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2Lcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jobject arg2, jobject arg3, jintArray arg4)
{
	nsID _arg2, *lparg2=NULL;
	nsID _arg3, *lparg3=NULL;
	jint *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2Lcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3I_FUNC);
	if (arg2) if ((lparg2 = getnsIDFields(env, arg2, &_arg2)) == NULL) goto fail;
	if (arg3) if ((lparg3 = getnsIDFields(env, arg3, &_arg3)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, nsID *, nsID *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) setnsIDFields(env, arg3, lparg3);
	if (arg2 && lparg2) setnsIDFields(env, arg2, lparg2);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2Lcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2Lcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2Lcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jobject arg2, jobject arg3, jlongArray arg4)
{
	nsID _arg2, *lparg2=NULL;
	nsID _arg3, *lparg3=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2Lcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J_FUNC);
	if (arg2) if ((lparg2 = getnsIDFields(env, arg2, &_arg2)) == NULL) goto fail;
	if (arg3) if ((lparg3 = getnsIDFields(env, arg3, &_arg3)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, nsID *, nsID *, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) setnsIDFields(env, arg3, lparg3);
	if (arg2 && lparg2) setnsIDFields(env, arg2, lparg2);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2Lcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jlong arg3, jobject arg4, jlongArray arg5)
{
	jbyte *lparg2=NULL;
	nsID _arg4, *lparg4=NULL;
	jlong *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = getnsIDFields(env, arg4, &_arg4)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jlong, nsID *, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) setnsIDFields(env, arg4, lparg4);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3BJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3BJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jbyteArray arg3, jlong arg4, jlongArray arg5)
{
	jbyte *lparg3=NULL;
	jlong *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3BJ_3J_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jbyte *, jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3BJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3C_3C_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3C_3C_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jcharArray arg3, jcharArray arg4, jintArray arg5)
{
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jint *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3C_3C_3I_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jchar *, jchar *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3C_3C_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJ_3C
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJ_3C)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jcharArray arg5)
{
	jchar *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJ_3C_FUNC);
	if (arg5) if ((lparg5 = env->GetCharArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jchar *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseCharArrayElements(arg5, lparg5, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJ_3C_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jlong arg5)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJIIJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJIIJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jint arg4, jlong arg5)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJIIJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jint, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJIIJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJIJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJIJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jint arg4, jlong arg5)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJIJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jint, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJIJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJII_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJII_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jint arg4, jintArray arg5)
{
	jint *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJII_3I_FUNC);
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jint, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJII_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJ_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJ_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jintArray arg5)
{
	jint *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJ_3I_FUNC);
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJ_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJI_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJI_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jint arg4, jlongArray arg5)
{
	jlong *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJI_3J_FUNC);
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jint, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJI_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jlongArray arg5)
{
	jlong *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJ_3J_FUNC);
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3I_3I_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3I_3I_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jintArray arg2, jintArray arg3, jintArray arg4, jintArray arg5)
{
	jint *lparg2=NULL;
	jint *lparg3=NULL;
	jint *lparg4=NULL;
	jint *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3I_3I_3I_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetIntArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint *, jint *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseIntArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3I_3I_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3B_3BJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3B_3BJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jobject arg2, jbyteArray arg3, jbyteArray arg4, jlong arg5)
{
	nsID _arg2, *lparg2=NULL;
	jbyte *lparg3=NULL;
	jbyte *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3B_3BJ_FUNC);
	if (arg2) if ((lparg2 = getnsIDFields(env, arg2, &_arg2)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, nsID *, jbyte *, jbyte *, jlong))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4, arg5);
fail:
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) setnsIDFields(env, arg2, lparg2);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3B_3BJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2JLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2JLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jobject arg2, jlong arg3, jobject arg4, jlongArray arg5)
{
	nsID _arg2, *lparg2=NULL;
	nsID _arg4, *lparg4=NULL;
	jlong *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2JLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J_FUNC);
	if (arg2) if ((lparg2 = getnsIDFields(env, arg2, &_arg2)) == NULL) goto fail;
	if (arg4) if ((lparg4 = getnsIDFields(env, arg4, &_arg4)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, nsID *, jlong, nsID *, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) setnsIDFields(env, arg4, lparg4);
	if (arg2 && lparg2) setnsIDFields(env, arg2, lparg2);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2JLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3CIJJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3CIJJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jint arg3, jlong arg4, jlong arg5, jlong arg6)
{
	jchar *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3CIJJJ_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jint, jlong, jlong, jlong))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, arg4, arg5, arg6);
fail:
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3CIJJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jlong arg5, jlong arg6)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJJJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jlong, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJIIIII
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJIIIII)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jint arg4, jint arg5, jint arg6)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJIIIII_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jint, jint, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJIIIII_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJI_3I_3I_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJI_3I_3I_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jintArray arg3, jintArray arg4, jintArray arg5, jintArray arg6)
{
	jint *lparg3=NULL;
	jint *lparg4=NULL;
	jint *lparg5=NULL;
	jint *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJI_3I_3I_3I_3I_FUNC);
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint *, jint *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4, lparg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJI_3I_3I_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3B_3B_3BJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3B_3B_3BJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jbyteArray arg3, jbyteArray arg4, jbyteArray arg5, jlong arg6, jlongArray arg7)
{
	jbyte *lparg3=NULL;
	jbyte *lparg4=NULL;
	jbyte *lparg5=NULL;
	jlong *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3B_3B_3BJ_3J_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetByteArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetLongArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jbyte *, jbyte *, jbyte *, jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4, lparg5, arg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseLongArrayElements(arg7, lparg7, 0);
	if (arg5 && lparg5) env->ReleaseByteArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3B_3B_3BJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJ_3CJJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJ_3CJJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jcharArray arg4, jlong arg5, jlong arg6, jlong arg7)
{
	jchar *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJ_3CJJJ_FUNC);
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jchar *, jlong, jlong, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, arg5, arg6, arg7);
fail:
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJ_3CJJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJIIII
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJIIII)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jint arg4, jint arg5, jint arg6, jint arg7)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJIIII_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jint, jint, jint, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJIIII_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3B_3BJ_3B_3B
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3B_3BJ_3B_3B)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jobject arg2, jbyteArray arg3, jbyteArray arg4, jlong arg5, jbyteArray arg6, jbyteArray arg7)
{
	nsID _arg2, *lparg2=NULL;
	jbyte *lparg3=NULL;
	jbyte *lparg4=NULL;
	jbyte *lparg6=NULL;
	jbyte *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3B_3BJ_3B_3B_FUNC);
	if (arg2) if ((lparg2 = getnsIDFields(env, arg2, &_arg2)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetByteArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetByteArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, nsID *, jbyte *, jbyte *, jlong, jbyte *, jbyte *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4, arg5, lparg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseByteArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseByteArrayElements(arg6, lparg6, 0);
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) setnsIDFields(env, arg2, lparg2);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3B_3BJ_3B_3B_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2)
{
	jbyte *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *))(*(jlong**)arg1)[arg0])(arg1, lparg2);
fail:
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3B_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3B_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jbyteArray arg3, jintArray arg4)
{
	jbyte *lparg2=NULL;
	jbyte *lparg3=NULL;
	jint *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3B_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jbyte *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3B_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3B_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3B_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jbyteArray arg3, jlongArray arg4)
{
	jbyte *lparg2=NULL;
	jbyte *lparg3=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3B_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jbyte *, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3B_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3B
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3B)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jbyteArray arg3)
{
	jbyte *lparg2=NULL;
	jbyte *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3B_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jbyte *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3B_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jintArray arg3, jintArray arg4)
{
	jbyte *lparg2=NULL;
	jint *lparg3=NULL;
	jint *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3I_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3I_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3I_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jintArray arg3, jlongArray arg4)
{
	jbyte *lparg2=NULL;
	jint *lparg3=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3I_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jint *, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3I_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3J_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3J_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jlongArray arg3, jintArray arg4)
{
	jbyte *lparg2=NULL;
	jlong *lparg3=NULL;
	jint *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3J_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jlong *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3J_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jobject arg3, jlong arg4)
{
	jbyte *lparg2=NULL;
	nsID _arg3, *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2J_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = getnsIDFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, nsID *, jlong))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, arg4);
fail:
	if (arg3 && lparg3) setnsIDFields(env, arg3, lparg3);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJI_3B
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJI_3B)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jbyteArray arg3)
{
	jbyte *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJI_3B_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jbyte *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJI_3B_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3B
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3B)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jbyteArray arg3)
{
	jbyte *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3B_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jbyte *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3B_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJII_3BI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJII_3BI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jbyteArray arg4, jint arg5)
{
	jbyte *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJII_3BI_FUNC);
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jbyte *, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, arg5);
fail:
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJII_3BI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJIII_3B_3BI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJIII_3B_3BI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jint arg4, jbyteArray arg5, jbyteArray arg6, jint arg7)
{
	jbyte *lparg5=NULL;
	jbyte *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJIII_3B_3BI_FUNC);
	if (arg5) if ((lparg5 = env->GetByteArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetByteArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jint, jbyte *, jbyte *, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, lparg5, lparg6, arg7);
fail:
	if (arg6 && lparg6) env->ReleaseByteArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseByteArrayElements(arg5, lparg5, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJIII_3B_3BI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJJ_3BJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJJ_3BJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jlong arg5, jbyteArray arg6, jlong arg7)
{
	jbyte *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJJ_3BJ_FUNC);
	if (arg6) if ((lparg6 = env->GetByteArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jlong, jbyte *, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, lparg6, arg7);
fail:
	if (arg6 && lparg6) env->ReleaseByteArrayElements(arg6, lparg6, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJJ_3BJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJ_3BII
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJ_3BII)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jbyteArray arg5, jint arg6, jint arg7)
{
	jbyte *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJ_3BII_FUNC);
	if (arg5) if ((lparg5 = env->GetByteArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jbyte *, jint, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, lparg5, arg6, arg7);
fail:
	if (arg5 && lparg5) env->ReleaseByteArrayElements(arg5, lparg5, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJ_3BII_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jlong arg3, jlong arg4)
{
	jbyte *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BJJ_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jlong, jlong))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, arg4);
fail:
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJSF
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJSF)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jshort arg2, jfloat arg3)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJSF_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jshort, jfloat))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJSF_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJS_3F
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJS_3F)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jshort arg2, jfloatArray arg3)
{
	jfloat *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJS_3F_FUNC);
	if (arg3) if ((lparg3 = env->GetFloatArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jshort, jfloat *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseFloatArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJS_3F_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3S
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3S)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jshortArray arg3)
{
	jshort *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3S_FUNC);
	if (arg3) if ((lparg3 = env->GetShortArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jshort *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseShortArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3S_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJIII_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJIII_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jint arg4, jint arg5, jlongArray arg6)
{
	jlong *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJIII_3J_FUNC);
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jint, jint, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJIII_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJII_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJII_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jint arg4, jint arg5, jlongArray arg6)
{
	jlong *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJII_3J_FUNC);
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jint, jint, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJII_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jlong arg5, jlongArray arg6)
{
	jlong *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJJ_3J_FUNC);
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJIJI_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJIJI_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jlong arg4, jint arg5, jlongArray arg6)
{
	jlong *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJIJI_3J_FUNC);
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jlong, jint, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJIJI_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJII_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJII_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jint arg4, jint arg5, jintArray arg6)
{
	jint *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJII_3I_FUNC);
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jint, jint, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJII_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJSJ_3S
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJSJ_3S)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jshort arg2, jlong arg3, jshortArray arg4)
{
	jshort *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJSJ_3S_FUNC);
	if (arg4) if ((lparg4 = env->GetShortArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jshort, jlong, jshort *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseShortArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJSJ_3S_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3C_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3C_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jcharArray arg3, jintArray arg4)
{
	jchar *lparg3=NULL;
	jint *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3C_3I_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jchar *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3C_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3C_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3C_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jcharArray arg3, jlongArray arg4)
{
	jchar *lparg3=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3C_3J_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jchar *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3C_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3D
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3D)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jdoubleArray arg2)
{
	jdouble *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3D_FUNC);
	if (arg2) if ((lparg2 = env->GetDoubleArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jdouble *))(*(jlong**)arg1)[arg0])(arg1, lparg2);
fail:
	if (arg2 && lparg2) env->ReleaseDoubleArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3D_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJD
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJD)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jdouble arg2)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJD_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jdouble))(*(jlong**)arg1)[arg0])(arg1, arg2);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJD_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJSI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJSI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jshort arg2, jint arg3)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJSI_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jshort, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJSI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJSJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJSJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jshort arg2, jlong arg3)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJSJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jshort, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJSJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3CI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3CI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jint arg3)
{
	jchar *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3CI_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jint))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3);
fail:
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3CI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3CJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3CJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jlong arg3)
{
	jchar *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3CJ_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jlong))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3);
fail:
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3CJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJIIJJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJIIJJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jint arg4, jint arg5, jlong arg6, jlong arg7, jlong arg8)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJIIJJJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jint, jint, jlong, jlong, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJIIJJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3CJIIJJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3CJIIJJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jlong arg3, jint arg4, jint arg5, jlong arg6, jlong arg7, jlong arg8)
{
	jchar *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3CJIIJJJ_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jlong, jint, jint, jlong, jlong, jlong))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, arg4, arg5, arg6, arg7, arg8);
fail:
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3CJIIJJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJJJJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJJJJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jlong arg5, jlong arg6, jlong arg7, jlong arg8)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJJJJJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJJJJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJIJJJJJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJIJJJJJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jint arg4, jlong arg5, jlong arg6, jlong arg7, jlong arg8, jlong arg9, jlong arg10)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJIJJJJJJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jint, jlong, jlong, jlong, jlong, jlong, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJIJJJJJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJJJJJJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJJJJJJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jlong arg5, jlong arg6, jlong arg7, jlong arg8, jlong arg9, jlong arg10)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJJJJJJJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJJJJJJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJIJIIJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJIJIIJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jint arg5, jlong arg6, jint arg7, jint arg8, jlong arg9, jlong arg10)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJIJIIJJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jint, jlong, jint, jint, jlong, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJIJIIJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3BI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3BI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jbyteArray arg3, jint arg4)
{
	jbyte *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3BI_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jbyte *, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4);
fail:
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3BI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3B_3C
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3B_3C)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jbyteArray arg3, jcharArray arg4)
{
	jbyte *lparg3=NULL;
	jchar *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3B_3C_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jbyte *, jchar *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3B_3C_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3CJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3CJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jcharArray arg3, jlong arg4)
{
	jchar *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3CJ_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jchar *, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4);
fail:
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3CJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jobject arg3)
{
	jbyte *lparg2=NULL;
	nsID _arg3, *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = getnsIDFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, nsID *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3);
fail:
	if (arg3 && lparg3) setnsIDFields(env, arg3, lparg3);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJSJJJJJJJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJSJJJJJJJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jshort arg2, jlong arg3, jlong arg4, jlong arg5, jlong arg6, jlong arg7, jlong arg8, jlong arg9, jlongArray arg10)
{
	jlong *lparg10=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJSJJJJJJJ_3J_FUNC);
	if (arg10) if ((lparg10 = env->GetLongArrayElements(arg10, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jshort, jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, lparg10);
fail:
	if (arg10 && lparg10) env->ReleaseLongArrayElements(arg10, lparg10, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJSJJJJJJJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJ_3B_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJ_3B_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jbyteArray arg4, jintArray arg5)
{
	jbyte *lparg4=NULL;
	jint *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJ_3B_3I_FUNC);
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jbyte *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJ_3B_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3D_3D
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3D_3D)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jdoubleArray arg2, jdoubleArray arg3)
{
	jdouble *lparg2=NULL;
	jdouble *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3D_3D_FUNC);
	if (arg2) if ((lparg2 = env->GetDoubleArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetDoubleArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jdouble *, jdouble *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseDoubleArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseDoubleArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3D_3D_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJI_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJI_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jintArray arg4, jintArray arg5)
{
	jint *lparg4=NULL;
	jint *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJI_3I_3I_FUNC);
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJI_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJI_3J_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJI_3J_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jlongArray arg4, jlongArray arg5)
{
	jlong *lparg4=NULL;
	jlong *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJI_3J_3J_FUNC);
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jlong *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJI_3J_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJ_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJ_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jintArray arg4, jintArray arg5)
{
	jint *lparg4=NULL;
	jint *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJ_3I_3I_FUNC);
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJ_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJI_3J_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJI_3J_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jlongArray arg4, jintArray arg5)
{
	jlong *lparg4=NULL;
	jint *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJI_3J_3I_FUNC);
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jlong *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJI_3J_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJIIIIII_3I_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJIIIIII_3I_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jint arg4, jint arg5, jint arg6, jint arg7, jintArray arg8, jintArray arg9, jintArray arg10)
{
	jint *lparg8=NULL;
	jint *lparg9=NULL;
	jint *lparg10=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJIIIIII_3I_3I_3I_FUNC);
	if (arg8) if ((lparg8 = env->GetIntArrayElements(arg8, NULL)) == NULL) goto fail;
	if (arg9) if ((lparg9 = env->GetIntArrayElements(arg9, NULL)) == NULL) goto fail;
	if (arg10) if ((lparg10 = env->GetIntArrayElements(arg10, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jint, jint, jint, jint, jint *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, lparg8, lparg9, lparg10);
fail:
	if (arg10 && lparg10) env->ReleaseIntArrayElements(arg10, lparg10, 0);
	if (arg9 && lparg9) env->ReleaseIntArrayElements(arg9, lparg9, 0);
	if (arg8 && lparg8) env->ReleaseIntArrayElements(arg8, lparg8, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJIIIIII_3I_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BJ_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BJ_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jlong arg3, jintArray arg4)
{
	jbyte *lparg2=NULL;
	jint *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BJ_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jlong, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BJ_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3BJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3BJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jbyteArray arg3, jlong arg4)
{
	jbyte *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3BJ_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jbyte *, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4);
fail:
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3BJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJI_3BS
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJI_3BS)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jbyteArray arg3, jshort arg4)
{
	jbyte *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJI_3BS_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jbyte *, jshort))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4);
fail:
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJI_3BS_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3BS
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3BS)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jbyteArray arg3, jshort arg4)
{
	jbyte *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3BS_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jbyte *, jshort))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4);
fail:
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3BS_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJII_3B_3B
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJII_3B_3B)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jbyteArray arg4, jbyteArray arg5)
{
	jbyte *lparg4=NULL;
	jbyte *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJII_3B_3B_FUNC);
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetByteArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jbyte *, jbyte *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseByteArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJII_3B_3B_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJ_3B_3B
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJ_3B_3B)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jbyteArray arg4, jbyteArray arg5)
{
	jbyte *lparg4=NULL;
	jbyte *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJ_3B_3B_FUNC);
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetByteArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jbyte *, jbyte *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseByteArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJ_3B_3B_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJ_3BJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJ_3BJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jbyteArray arg4, jlong arg5)
{
	jbyte *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJ_3BJ_FUNC);
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jbyte *, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, arg5);
fail:
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJ_3BJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3SI_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3SI_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jshortArray arg2, jint arg3, jintArray arg4, jintArray arg5)
{
	jshort *lparg2=NULL;
	jint *lparg4=NULL;
	jint *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3SI_3I_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetShortArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jshort *, jint, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg2 && lparg2) env->ReleaseShortArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3SI_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3SJ_3I_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3SJ_3I_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jshortArray arg2, jlong arg3, jintArray arg4, jlongArray arg5)
{
	jshort *lparg2=NULL;
	jint *lparg4=NULL;
	jlong *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3SJ_3I_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetShortArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jshort *, jlong, jint *, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg2 && lparg2) env->ReleaseShortArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3SJ_3I_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJII_3BII
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJII_3BII)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jbyteArray arg4, jint arg5, jint arg6)
{
	jbyte *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJII_3BII_FUNC);
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jbyte *, jint, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, arg5, arg6);
fail:
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJII_3BII_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJ_3BJI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJ_3BJI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jbyteArray arg4, jlong arg5, jint arg6)
{
	jbyte *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJ_3BJI_FUNC);
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jbyte *, jlong, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, arg5, arg6);
fail:
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJ_3BJI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJILcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2II_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJILcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2II_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jobject arg3, jint arg4, jint arg5, jintArray arg6)
{
	nsID _arg3, *lparg3=NULL;
	jint *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJILcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2II_3I_FUNC);
	if (arg3) if ((lparg3 = getnsIDFields(env, arg3, &_arg3)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, nsID *, jint, jint, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4, arg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg3 && lparg3) setnsIDFields(env, arg3, lparg3);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJILcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2II_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2JJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2JJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jobject arg3, jlong arg4, jlong arg5, jlongArray arg6)
{
	nsID _arg3, *lparg3=NULL;
	jlong *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2JJ_3J_FUNC);
	if (arg3) if ((lparg3 = getnsIDFields(env, arg3, &_arg3)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, nsID *, jlong, jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4, arg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	if (arg3 && lparg3) setnsIDFields(env, arg3, lparg3);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2JJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3I_3I_3I_3I_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3I_3I_3I_3I_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jintArray arg2, jintArray arg3, jintArray arg4, jintArray arg5, jintArray arg6, jintArray arg7)
{
	jint *lparg2=NULL;
	jint *lparg3=NULL;
	jint *lparg4=NULL;
	jint *lparg5=NULL;
	jint *lparg6=NULL;
	jint *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3I_3I_3I_3I_3I_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetIntArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint *, jint *, jint *, jint *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4, lparg5, lparg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseIntArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3I_3I_3I_3I_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3J_3J_3J_3J_3J_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3J_3J_3J_3J_3J_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlongArray arg2, jlongArray arg3, jlongArray arg4, jlongArray arg5, jlongArray arg6, jintArray arg7)
{
	jlong *lparg2=NULL;
	jlong *lparg3=NULL;
	jlong *lparg4=NULL;
	jlong *lparg5=NULL;
	jlong *lparg6=NULL;
	jint *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3J_3J_3J_3J_3J_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetLongArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong *, jlong *, jlong *, jlong *, jlong *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4, lparg5, lparg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseLongArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3J_3J_3J_3J_3J_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJIIIII_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJIIIII_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jint arg4, jint arg5, jint arg6, jintArray arg7)
{
	jint *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJIIIII_3I_FUNC);
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jint, jint, jint, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJIIIII_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJJJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJJJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jlong arg5, jlong arg6, jlongArray arg7)
{
	jlong *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJJJ_3J_FUNC);
	if (arg7) if ((lparg7 = env->GetLongArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jlong, jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseLongArrayElements(arg7, lparg7, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJJJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJ_3B_3BJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJ_3B_3BJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jbyteArray arg5, jbyteArray arg6, jlong arg7)
{
	jbyte *lparg5=NULL;
	jbyte *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJ_3B_3BJ_FUNC);
	if (arg5) if ((lparg5 = env->GetByteArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetByteArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jbyte *, jbyte *, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, lparg5, lparg6, arg7);
fail:
	if (arg6 && lparg6) env->ReleaseByteArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseByteArrayElements(arg5, lparg5, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJ_3B_3BJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJIIIIII_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJIIIIII_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jint arg4, jint arg5, jint arg6, jint arg7, jint arg8, jintArray arg9)
{
	jint *lparg9=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJIIIIII_3I_FUNC);
	if (arg9) if ((lparg9 = env->GetIntArrayElements(arg9, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jint, jint, jint, jint, jint, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, lparg9);
fail:
	if (arg9 && lparg9) env->ReleaseIntArrayElements(arg9, lparg9, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJIIIIII_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJJJJJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJJJJJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jlong arg5, jlong arg6, jlong arg7, jlong arg8, jlongArray arg9)
{
	jlong *lparg9=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJJJJJ_3J_FUNC);
	if (arg9) if ((lparg9 = env->GetLongArrayElements(arg9, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, lparg9);
fail:
	if (arg9 && lparg9) env->ReleaseLongArrayElements(arg9, lparg9, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJJJJJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BJI_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BJI_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jlong arg3, jint arg4, jlongArray arg5)
{
	jbyte *lparg2=NULL;
	jlong *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BJI_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jlong, jint, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, arg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BJI_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3B_3BII_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3B_3BII_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jbyteArray arg3, jbyteArray arg4, jint arg5, jint arg6, jlongArray arg7)
{
	jbyte *lparg2=NULL;
	jbyte *lparg3=NULL;
	jbyte *lparg4=NULL;
	jlong *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3B_3BII_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetLongArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jbyte *, jbyte *, jint, jint, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4, arg5, arg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseLongArrayElements(arg7, lparg7, 0);
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3B_3BII_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3BI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3BI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jbyteArray arg3, jint arg4)
{
	jbyte *lparg2=NULL;
	jbyte *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3BI_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jbyte *, jint))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, arg4);
fail:
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3BI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJIJ_3I_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJIJ_3I_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jlong arg4, jintArray arg5, jintArray arg6, jintArray arg7)
{
	jint *lparg5=NULL;
	jint *lparg6=NULL;
	jint *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJIJ_3I_3I_3I_FUNC);
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jlong, jint *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, lparg5, lparg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJIJ_3I_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJIJJ_3I_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJIJJ_3I_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jlong arg4, jlong arg5, jintArray arg6, jintArray arg7, jintArray arg8)
{
	jint *lparg6=NULL;
	jint *lparg7=NULL;
	jint *lparg8=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJIJJ_3I_3I_3I_FUNC);
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetIntArrayElements(arg8, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jlong, jlong, jint *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, lparg6, lparg7, lparg8);
fail:
	if (arg8 && lparg8) env->ReleaseIntArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJIJJ_3I_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJI_3C_3BJJIJI_3J_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJI_3C_3BJJIJI_3J_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jint arg5, jcharArray arg6, jbyteArray arg7, jlong arg8, jlong arg9, jint arg10, jlong arg11, jint arg12, jlongArray arg13, jlongArray arg14)
{
	jchar *lparg6=NULL;
	jbyte *lparg7=NULL;
	jlong *lparg13=NULL;
	jlong *lparg14=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJI_3C_3BJJIJI_3J_3J_FUNC);
	if (arg6) if ((lparg6 = env->GetCharArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetByteArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg13) if ((lparg13 = env->GetLongArrayElements(arg13, NULL)) == NULL) goto fail;
	if (arg14) if ((lparg14 = env->GetLongArrayElements(arg14, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jint, jchar *, jbyte *, jlong, jlong, jint, jlong, jint, jlong *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, lparg6, lparg7, arg8, arg9, arg10, arg11, arg12, lparg13, lparg14);
fail:
	if (arg14 && lparg14) env->ReleaseLongArrayElements(arg14, lparg14, 0);
	if (arg13 && lparg13) env->ReleaseLongArrayElements(arg13, lparg13, 0);
	if (arg7 && lparg7) env->ReleaseByteArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseCharArrayElements(arg6, lparg6, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJI_3C_3BJJIJI_3J_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJIIJIIIIII
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJIIJIIIIII)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jint arg4, jlong arg5, jint arg6, jint arg7, jint arg8, jint arg9, jint arg10, jint arg11)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJIIJIIIIII_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jint, jlong, jint, jint, jint, jint, jint, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJIIJIIIIII_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJIIJIIIIIIIIISJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJIIJIIIIIIIIISJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jint arg4, jlong arg5, jint arg6, jint arg7, jint arg8, jint arg9, jint arg10, jint arg11, jint arg12, jint arg13, jint arg14, jshort arg15, jlong arg16)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJIIJIIIIIIIIISJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jint, jlong, jint, jint, jint, jint, jint, jint, jint, jint, jint, jshort, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJIIJIIIIIIIIISJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJIIJJJJS
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJIIJJJJS)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jint arg4, jlong arg5, jlong arg6, jlong arg7, jlong arg8, jshort arg9)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJIIJJJJS_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jint, jlong, jlong, jlong, jlong, jshort))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJIIJJJJS_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJ_3C_3CI_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJ_3C_3CI_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jcharArray arg4, jcharArray arg5, jint arg6, jlongArray arg7)
{
	jchar *lparg4=NULL;
	jchar *lparg5=NULL;
	jlong *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJ_3C_3CI_3J_FUNC);
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetCharArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetLongArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jchar *, jchar *, jint, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, lparg5, arg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseLongArrayElements(arg7, lparg7, 0);
	if (arg5 && lparg5) env->ReleaseCharArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJ_3C_3CI_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJI_3B_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJI_3B_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jbyteArray arg3, jintArray arg4)
{
	jbyte *lparg3=NULL;
	jint *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJI_3B_3I_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jbyte *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJI_3B_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3S
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3S)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jshortArray arg3)
{
	jbyte *lparg2=NULL;
	jshort *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3S_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetShortArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jshort *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseShortArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3S_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJJI_3J_3J_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJJI_3J_3J_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jlong arg5, jint arg6, jlongArray arg7, jlongArray arg8, jintArray arg9)
{
	jlong *lparg7=NULL;
	jlong *lparg8=NULL;
	jint *lparg9=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJJI_3J_3J_3I_FUNC);
	if (arg7) if ((lparg7 = env->GetLongArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetLongArrayElements(arg8, NULL)) == NULL) goto fail;
	if (arg9) if ((lparg9 = env->GetIntArrayElements(arg9, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jlong, jint, jlong *, jlong *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, lparg7, lparg8, lparg9);
fail:
	if (arg9 && lparg9) env->ReleaseIntArrayElements(arg9, lparg9, 0);
	if (arg8 && lparg8) env->ReleaseLongArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseLongArrayElements(arg7, lparg7, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJJI_3J_3J_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3C_3C_3CI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3C_3C_3CI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jcharArray arg3, jcharArray arg4, jint arg5)
{
	jchar *lparg2=NULL;
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3C_3C_3CI_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jchar *, jchar *, jint))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4, arg5);
fail:
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3C_3C_3CI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3C_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3C_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jintArray arg3)
{
	jchar *lparg2=NULL;
	jint *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3C_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3C_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3C_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3C_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jlongArray arg3)
{
	jchar *lparg2=NULL;
	jlong *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3C_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3C_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3C_3C_3C_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3C_3C_3C_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jcharArray arg3, jcharArray arg4, jintArray arg5)
{
	jchar *lparg2=NULL;
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jint *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3C_3C_3C_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jchar *, jchar *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3C_3C_3C_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3C_3C_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3C_3C_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jcharArray arg3, jintArray arg4)
{
	jchar *lparg2=NULL;
	jchar *lparg3=NULL;
	jint *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3C_3C_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jchar *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3C_3C_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3C_3C_3C_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3C_3C_3C_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jcharArray arg3, jcharArray arg4, jintArray arg5, jintArray arg6)
{
	jchar *lparg2=NULL;
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jint *lparg5=NULL;
	jint *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3C_3C_3C_3I_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jchar *, jchar *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4, lparg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3C_3C_3C_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3C_3CI_3C_3C_3C_3C_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3C_3CI_3C_3C_3C_3C_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jcharArray arg3, jint arg4, jcharArray arg5, jcharArray arg6, jcharArray arg7, jcharArray arg8, jintArray arg9, jintArray arg10)
{
	jchar *lparg2=NULL;
	jchar *lparg3=NULL;
	jchar *lparg5=NULL;
	jchar *lparg6=NULL;
	jchar *lparg7=NULL;
	jchar *lparg8=NULL;
	jint *lparg9=NULL;
	jint *lparg10=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3C_3CI_3C_3C_3C_3C_3I_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetCharArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetCharArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetCharArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetCharArrayElements(arg8, NULL)) == NULL) goto fail;
	if (arg9) if ((lparg9 = env->GetIntArrayElements(arg9, NULL)) == NULL) goto fail;
	if (arg10) if ((lparg10 = env->GetIntArrayElements(arg10, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jchar *, jint, jchar *, jchar *, jchar *, jchar *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, arg4, lparg5, lparg6, lparg7, lparg8, lparg9, lparg10);
fail:
	if (arg10 && lparg10) env->ReleaseIntArrayElements(arg10, lparg10, 0);
	if (arg9 && lparg9) env->ReleaseIntArrayElements(arg9, lparg9, 0);
	if (arg8 && lparg8) env->ReleaseCharArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseCharArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseCharArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseCharArrayElements(arg5, lparg5, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3C_3CI_3C_3C_3C_3C_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3C_3C_3J_3C_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3C_3C_3J_3C_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jcharArray arg3, jlongArray arg4, jcharArray arg5, jintArray arg6, jintArray arg7)
{
	jchar *lparg2=NULL;
	jchar *lparg3=NULL;
	jlong *lparg4=NULL;
	jchar *lparg5=NULL;
	jint *lparg6=NULL;
	jint *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3C_3C_3J_3C_3I_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetCharArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jchar *, jlong *, jchar *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4, lparg5, lparg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseCharArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3C_3C_3J_3C_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3C_3C_3J_3J_3C_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3C_3C_3J_3J_3C_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jcharArray arg3, jlongArray arg4, jlongArray arg5, jcharArray arg6, jintArray arg7, jintArray arg8)
{
	jchar *lparg2=NULL;
	jchar *lparg3=NULL;
	jlong *lparg4=NULL;
	jlong *lparg5=NULL;
	jchar *lparg6=NULL;
	jint *lparg7=NULL;
	jint *lparg8=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3C_3C_3J_3J_3C_3I_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetCharArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetIntArrayElements(arg8, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jchar *, jlong *, jlong *, jchar *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4, lparg5, lparg6, lparg7, lparg8);
fail:
	if (arg8 && lparg8) env->ReleaseIntArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseCharArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3C_3C_3J_3J_3C_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3C_3CI_3C_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3C_3CI_3C_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jcharArray arg3, jint arg4, jcharArray arg5, jintArray arg6, jintArray arg7)
{
	jchar *lparg2=NULL;
	jchar *lparg3=NULL;
	jchar *lparg5=NULL;
	jint *lparg6=NULL;
	jint *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3C_3CI_3C_3I_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetCharArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jchar *, jint, jchar *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, arg4, lparg5, lparg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseCharArrayElements(arg5, lparg5, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3C_3CI_3C_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3C_3C_3C_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3C_3C_3C_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jcharArray arg3, jcharArray arg4, jcharArray arg5, jintArray arg6)
{
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jchar *lparg5=NULL;
	jint *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3C_3C_3C_3I_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetCharArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jchar *, jchar *, jchar *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4, lparg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseCharArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3C_3C_3C_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3C_3C_3C_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3C_3C_3C_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jcharArray arg3, jcharArray arg4, jcharArray arg5, jintArray arg6, jintArray arg7)
{
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jchar *lparg5=NULL;
	jint *lparg6=NULL;
	jint *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3C_3C_3C_3I_3I_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetCharArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jchar *, jchar *, jchar *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4, lparg5, lparg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseCharArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3C_3C_3C_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3C_3CI_3C_3C_3C_3C_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3C_3CI_3C_3C_3C_3C_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jcharArray arg3, jcharArray arg4, jint arg5, jcharArray arg6, jcharArray arg7, jcharArray arg8, jcharArray arg9, jintArray arg10, jintArray arg11)
{
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jchar *lparg6=NULL;
	jchar *lparg7=NULL;
	jchar *lparg8=NULL;
	jchar *lparg9=NULL;
	jint *lparg10=NULL;
	jint *lparg11=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3C_3CI_3C_3C_3C_3C_3I_3I_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetCharArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetCharArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetCharArrayElements(arg8, NULL)) == NULL) goto fail;
	if (arg9) if ((lparg9 = env->GetCharArrayElements(arg9, NULL)) == NULL) goto fail;
	if (arg10) if ((lparg10 = env->GetIntArrayElements(arg10, NULL)) == NULL) goto fail;
	if (arg11) if ((lparg11 = env->GetIntArrayElements(arg11, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jchar *, jchar *, jint, jchar *, jchar *, jchar *, jchar *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4, arg5, lparg6, lparg7, lparg8, lparg9, lparg10, lparg11);
fail:
	if (arg11 && lparg11) env->ReleaseIntArrayElements(arg11, lparg11, 0);
	if (arg10 && lparg10) env->ReleaseIntArrayElements(arg10, lparg10, 0);
	if (arg9 && lparg9) env->ReleaseCharArrayElements(arg9, lparg9, 0);
	if (arg8 && lparg8) env->ReleaseCharArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseCharArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseCharArrayElements(arg6, lparg6, 0);
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3C_3CI_3C_3C_3C_3C_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3C_3C_3J_3C_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3C_3C_3J_3C_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jcharArray arg3, jcharArray arg4, jlongArray arg5, jcharArray arg6, jintArray arg7, jintArray arg8)
{
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jlong *lparg5=NULL;
	jchar *lparg6=NULL;
	jint *lparg7=NULL;
	jint *lparg8=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3C_3C_3J_3C_3I_3I_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetCharArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetIntArrayElements(arg8, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jchar *, jchar *, jlong *, jchar *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4, lparg5, lparg6, lparg7, lparg8);
fail:
	if (arg8 && lparg8) env->ReleaseIntArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseCharArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3C_3C_3J_3C_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3C_3C_3J_3J_3C_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3C_3C_3J_3J_3C_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jcharArray arg3, jcharArray arg4, jlongArray arg5, jlongArray arg6, jcharArray arg7, jintArray arg8, jintArray arg9)
{
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jlong *lparg5=NULL;
	jlong *lparg6=NULL;
	jchar *lparg7=NULL;
	jint *lparg8=NULL;
	jint *lparg9=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3C_3C_3J_3J_3C_3I_3I_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetCharArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetIntArrayElements(arg8, NULL)) == NULL) goto fail;
	if (arg9) if ((lparg9 = env->GetIntArrayElements(arg9, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jchar *, jchar *, jlong *, jlong *, jchar *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4, lparg5, lparg6, lparg7, lparg8, lparg9);
fail:
	if (arg9 && lparg9) env->ReleaseIntArrayElements(arg9, lparg9, 0);
	if (arg8 && lparg8) env->ReleaseIntArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseCharArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3C_3C_3J_3J_3C_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3C_3CI_3C_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3C_3CI_3C_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jcharArray arg3, jcharArray arg4, jint arg5, jcharArray arg6, jintArray arg7, jintArray arg8)
{
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jchar *lparg6=NULL;
	jint *lparg7=NULL;
	jint *lparg8=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3C_3CI_3C_3I_3I_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetCharArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetIntArrayElements(arg8, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jchar *, jchar *, jint, jchar *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4, arg5, lparg6, lparg7, lparg8);
fail:
	if (arg8 && lparg8) env->ReleaseIntArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseCharArrayElements(arg6, lparg6, 0);
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3C_3CI_3C_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJIJ_3C_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJIJ_3C_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jint arg4, jlong arg5, jcharArray arg6, jintArray arg7, jintArray arg8)
{
	jchar *lparg6=NULL;
	jint *lparg7=NULL;
	jint *lparg8=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJIJ_3C_3I_3I_FUNC);
	if (arg6) if ((lparg6 = env->GetCharArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetIntArrayElements(arg8, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jint, jlong, jchar *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, lparg6, lparg7, lparg8);
fail:
	if (arg8 && lparg8) env->ReleaseIntArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseCharArrayElements(arg6, lparg6, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJIJ_3C_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJJIJ_3C_3I_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJJIJ_3C_3I_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jlong arg5, jint arg6, jlong arg7, jcharArray arg8, jintArray arg9, jlongArray arg10)
{
	jchar *lparg8=NULL;
	jint *lparg9=NULL;
	jlong *lparg10=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJJIJ_3C_3I_3J_FUNC);
	if (arg8) if ((lparg8 = env->GetCharArrayElements(arg8, NULL)) == NULL) goto fail;
	if (arg9) if ((lparg9 = env->GetIntArrayElements(arg9, NULL)) == NULL) goto fail;
	if (arg10) if ((lparg10 = env->GetLongArrayElements(arg10, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jlong, jint, jlong, jchar *, jint *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, lparg8, lparg9, lparg10);
fail:
	if (arg10 && lparg10) env->ReleaseLongArrayElements(arg10, lparg10, 0);
	if (arg9 && lparg9) env->ReleaseIntArrayElements(arg9, lparg9, 0);
	if (arg8 && lparg8) env->ReleaseCharArrayElements(arg8, lparg8, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJJIJ_3C_3I_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJI_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJI_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jintArray arg3, jintArray arg4)
{
	jint *lparg3=NULL;
	jint *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJI_3I_3I_FUNC);
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJI_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3B_3S
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3B_3S)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jbyteArray arg3, jshortArray arg4)
{
	jbyte *lparg3=NULL;
	jshort *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3B_3S_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetShortArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jbyte *, jshort *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseShortArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3B_3S_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BI_3J_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BI_3J_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jint arg3, jlongArray arg4, jintArray arg5)
{
	jbyte *lparg2=NULL;
	jlong *lparg4=NULL;
	jint *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BI_3J_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jint, jlong *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BI_3J_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BIJ_3J_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BIJ_3J_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jint arg3, jlong arg4, jlongArray arg5, jintArray arg6)
{
	jbyte *lparg2=NULL;
	jlong *lparg5=NULL;
	jint *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BIJ_3J_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jint, jlong, jlong *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, arg4, lparg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BIJ_3J_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJIIJ_3I_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJIIJ_3I_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jint arg4, jlong arg5, jintArray arg6, jlongArray arg7)
{
	jint *lparg6=NULL;
	jlong *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJIIJ_3I_3J_FUNC);
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetLongArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jint, jlong, jint *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, lparg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseLongArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJIIJ_3I_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJI_3I_3I_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJI_3I_3I_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jintArray arg3, jintArray arg4, jlongArray arg5)
{
	jint *lparg3=NULL;
	jint *lparg4=NULL;
	jlong *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJI_3I_3I_3J_FUNC);
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint *, jint *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJI_3I_3I_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJI_3IJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJI_3IJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jintArray arg3, jlong arg4)
{
	jint *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJI_3IJ_FUNC);
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint *, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4);
fail:
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJI_3IJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jobject arg2)
{
	nsID _arg2, *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_FUNC);
	if (arg2) if ((lparg2 = getnsIDFields(env, arg2, &_arg2)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, nsID *))(*(jlong**)arg1)[arg0])(arg1, lparg2);
fail:
	if (arg2 && lparg2) setnsIDFields(env, arg2, lparg2);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJFF_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJFF_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jfloat arg2, jfloat arg3, jlongArray arg4)
{
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJFF_3J_FUNC);
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jfloat, jfloat, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJFF_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJIIJIIIIIIIIISJFS
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJIIJIIIIIIIIISJFS)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jint arg4, jlong arg5, jint arg6, jint arg7, jint arg8, jint arg9, jint arg10, jint arg11, jint arg12, jint arg13, jint arg14, jshort arg15, jlong arg16, jfloat arg17, jshort arg18)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJIIJIIIIIIIIISJFS_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jint, jlong, jint, jint, jint, jint, jint, jint, jint, jint, jint, jshort, jlong, jfloat, jshort))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJIIJIIIIIIIIISJFS_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3IIII_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3IIII_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jintArray arg2, jint arg3, jint arg4, jint arg5, jintArray arg6)
{
	jint *lparg2=NULL;
	jint *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3IIII_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetIntArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint *, jint, jint, jint, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, arg4, arg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg2 && lparg2) env->ReleaseIntArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3IIII_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3IJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3IJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jintArray arg2, jlong arg3, jlongArray arg4)
{
	jint *lparg2=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3IJ_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetIntArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint *, jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg2 && lparg2) env->ReleaseIntArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3IJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJI_3CI_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJI_3CI_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jcharArray arg3, jint arg4, jlongArray arg5)
{
	jchar *lparg3=NULL;
	jlong *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJI_3CI_3J_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jchar *, jint, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJI_3CI_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3C_3CI_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3C_3CI_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jcharArray arg3, jint arg4, jlongArray arg5)
{
	jchar *lparg2=NULL;
	jchar *lparg3=NULL;
	jlong *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3C_3CI_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jchar *, jint, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, arg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3C_3CI_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BI_3BI_3I_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BI_3BI_3I_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jint arg3, jbyteArray arg4, jint arg5, jintArray arg6, jlongArray arg7)
{
	jbyte *lparg2=NULL;
	jbyte *lparg4=NULL;
	jint *lparg6=NULL;
	jlong *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BI_3BI_3I_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetLongArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jint, jbyte *, jint, jint *, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, lparg4, arg5, lparg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseLongArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BI_3BI_3I_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BJ_3J_3J_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BJ_3J_3J_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jlong arg3, jlongArray arg4, jlongArray arg5, jintArray arg6)
{
	jbyte *lparg2=NULL;
	jlong *lparg4=NULL;
	jlong *lparg5=NULL;
	jint *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BJ_3J_3J_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jlong, jlong *, jlong *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, lparg4, lparg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BJ_3J_3J_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BIII_3B_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BIII_3B_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jint arg3, jint arg4, jint arg5, jbyteArray arg6, jintArray arg7)
{
	jbyte *lparg2=NULL;
	jbyte *lparg6=NULL;
	jint *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BIII_3B_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetByteArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jint, jint, jint, jbyte *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, arg4, arg5, lparg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseByteArrayElements(arg6, lparg6, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BIII_3B_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BJI_3B_3J_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BJI_3B_3J_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jlong arg3, jint arg4, jbyteArray arg5, jlongArray arg6, jintArray arg7)
{
	jbyte *lparg2=NULL;
	jbyte *lparg5=NULL;
	jlong *lparg6=NULL;
	jint *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BJI_3B_3J_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetByteArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jlong, jint, jbyte *, jlong *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, arg4, lparg5, lparg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseByteArrayElements(arg5, lparg5, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BJI_3B_3J_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJI_3BI_3BII_3J_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJI_3BI_3BII_3J_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jbyteArray arg3, jint arg4, jbyteArray arg5, jint arg6, jint arg7, jlongArray arg8, jlongArray arg9)
{
	jbyte *lparg3=NULL;
	jbyte *lparg5=NULL;
	jlong *lparg8=NULL;
	jlong *lparg9=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJI_3BI_3BII_3J_3J_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetByteArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetLongArrayElements(arg8, NULL)) == NULL) goto fail;
	if (arg9) if ((lparg9 = env->GetLongArrayElements(arg9, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jbyte *, jint, jbyte *, jint, jint, jlong *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4, lparg5, arg6, arg7, lparg8, lparg9);
fail:
	if (arg9 && lparg9) env->ReleaseLongArrayElements(arg9, lparg9, 0);
	if (arg8 && lparg8) env->ReleaseLongArrayElements(arg8, lparg8, 0);
	if (arg5 && lparg5) env->ReleaseByteArrayElements(arg5, lparg5, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJI_3BI_3BII_3J_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3B_3BI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3B_3BI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jbyteArray arg3, jbyteArray arg4, jint arg5)
{
	jbyte *lparg2=NULL;
	jbyte *lparg3=NULL;
	jbyte *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3B_3BI_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jbyte *, jbyte *, jint))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4, arg5);
fail:
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3B_3BI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3B_3B
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3B_3B)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jbyteArray arg3, jbyteArray arg4)
{
	jbyte *lparg3=NULL;
	jbyte *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3B_3B_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jbyte *, jbyte *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3B_3B_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3CIIII_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3CIIII_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jint arg3, jint arg4, jint arg5, jint arg6, jlongArray arg7)
{
	jchar *lparg2=NULL;
	jlong *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3CIIII_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetLongArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jint, jint, jint, jint, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, arg4, arg5, arg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseLongArrayElements(arg7, lparg7, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3CIIII_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3CIII_3I_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3CIII_3I_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jcharArray arg3, jint arg4, jint arg5, jint arg6, jintArray arg7, jlongArray arg8)
{
	jchar *lparg3=NULL;
	jint *lparg7=NULL;
	jlong *lparg8=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3CIII_3I_3J_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetLongArrayElements(arg8, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jchar *, jint, jint, jint, jint *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4, arg5, arg6, lparg7, lparg8);
fail:
	if (arg8 && lparg8) env->ReleaseLongArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3CIII_3I_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJII_3I_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJII_3I_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jint arg5, jint arg6, jintArray arg7, jlongArray arg8)
{
	jint *lparg7=NULL;
	jlong *lparg8=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJII_3I_3J_FUNC);
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetLongArrayElements(arg8, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jint, jint, jint *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, lparg7, lparg8);
fail:
	if (arg8 && lparg8) env->ReleaseLongArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJII_3I_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BI_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BI_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jint arg3, jintArray arg4, jintArray arg5)
{
	jbyte *lparg2=NULL;
	jint *lparg4=NULL;
	jint *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BI_3I_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jint, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BI_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BI_3I_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BI_3I_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jint arg3, jintArray arg4, jintArray arg5, jintArray arg6)
{
	jbyte *lparg2=NULL;
	jint *lparg4=NULL;
	jint *lparg5=NULL;
	jint *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BI_3I_3I_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jint, jint *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, lparg4, lparg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BI_3I_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BI_3I_3I_3I_3I_3I_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BI_3I_3I_3I_3I_3I_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jint arg3, jintArray arg4, jintArray arg5, jintArray arg6, jintArray arg7, jintArray arg8, jintArray arg9, jintArray arg10)
{
	jbyte *lparg2=NULL;
	jint *lparg4=NULL;
	jint *lparg5=NULL;
	jint *lparg6=NULL;
	jint *lparg7=NULL;
	jint *lparg8=NULL;
	jint *lparg9=NULL;
	jint *lparg10=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BI_3I_3I_3I_3I_3I_3I_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetIntArrayElements(arg8, NULL)) == NULL) goto fail;
	if (arg9) if ((lparg9 = env->GetIntArrayElements(arg9, NULL)) == NULL) goto fail;
	if (arg10) if ((lparg10 = env->GetIntArrayElements(arg10, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jint, jint *, jint *, jint *, jint *, jint *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, lparg4, lparg5, lparg6, lparg7, lparg8, lparg9, lparg10);
fail:
	if (arg10 && lparg10) env->ReleaseIntArrayElements(arg10, lparg10, 0);
	if (arg9 && lparg9) env->ReleaseIntArrayElements(arg9, lparg9, 0);
	if (arg8 && lparg8) env->ReleaseIntArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BI_3I_3I_3I_3I_3I_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJII_3J_3I_3I_3I_3I_3I_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJII_3J_3I_3I_3I_3I_3I_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jint arg4, jlongArray arg5, jintArray arg6, jintArray arg7, jintArray arg8, jintArray arg9, jintArray arg10, jintArray arg11, jintArray arg12)
{
	jlong *lparg5=NULL;
	jint *lparg6=NULL;
	jint *lparg7=NULL;
	jint *lparg8=NULL;
	jint *lparg9=NULL;
	jint *lparg10=NULL;
	jint *lparg11=NULL;
	jint *lparg12=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJII_3J_3I_3I_3I_3I_3I_3I_3I_FUNC);
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetIntArrayElements(arg8, NULL)) == NULL) goto fail;
	if (arg9) if ((lparg9 = env->GetIntArrayElements(arg9, NULL)) == NULL) goto fail;
	if (arg10) if ((lparg10 = env->GetIntArrayElements(arg10, NULL)) == NULL) goto fail;
	if (arg11) if ((lparg11 = env->GetIntArrayElements(arg11, NULL)) == NULL) goto fail;
	if (arg12) if ((lparg12 = env->GetIntArrayElements(arg12, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jint, jlong *, jint *, jint *, jint *, jint *, jint *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, lparg5, lparg6, lparg7, lparg8, lparg9, lparg10, lparg11, lparg12);
fail:
	if (arg12 && lparg12) env->ReleaseIntArrayElements(arg12, lparg12, 0);
	if (arg11 && lparg11) env->ReleaseIntArrayElements(arg11, lparg11, 0);
	if (arg10 && lparg10) env->ReleaseIntArrayElements(arg10, lparg10, 0);
	if (arg9 && lparg9) env->ReleaseIntArrayElements(arg9, lparg9, 0);
	if (arg8 && lparg8) env->ReleaseIntArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJII_3J_3I_3I_3I_3I_3I_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BI_3I_3I_3I_3I_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BI_3I_3I_3I_3I_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jint arg3, jintArray arg4, jintArray arg5, jintArray arg6, jintArray arg7, jintArray arg8, jintArray arg9)
{
	jbyte *lparg2=NULL;
	jint *lparg4=NULL;
	jint *lparg5=NULL;
	jint *lparg6=NULL;
	jint *lparg7=NULL;
	jint *lparg8=NULL;
	jint *lparg9=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BI_3I_3I_3I_3I_3I_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetIntArrayElements(arg8, NULL)) == NULL) goto fail;
	if (arg9) if ((lparg9 = env->GetIntArrayElements(arg9, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jint, jint *, jint *, jint *, jint *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, lparg4, lparg5, lparg6, lparg7, lparg8, lparg9);
fail:
	if (arg9 && lparg9) env->ReleaseIntArrayElements(arg9, lparg9, 0);
	if (arg8 && lparg8) env->ReleaseIntArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BI_3I_3I_3I_3I_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJII_3D_3I_3D_3D_3I_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJII_3D_3I_3D_3D_3I_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jdoubleArray arg4, jintArray arg5, jdoubleArray arg6, jdoubleArray arg7, jintArray arg8, jintArray arg9, jintArray arg10)
{
	jdouble *lparg4=NULL;
	jint *lparg5=NULL;
	jdouble *lparg6=NULL;
	jdouble *lparg7=NULL;
	jint *lparg8=NULL;
	jint *lparg9=NULL;
	jint *lparg10=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJII_3D_3I_3D_3D_3I_3I_3I_FUNC);
	if (arg4) if ((lparg4 = env->GetDoubleArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetDoubleArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetDoubleArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetIntArrayElements(arg8, NULL)) == NULL) goto fail;
	if (arg9) if ((lparg9 = env->GetIntArrayElements(arg9, NULL)) == NULL) goto fail;
	if (arg10) if ((lparg10 = env->GetIntArrayElements(arg10, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jdouble *, jint *, jdouble *, jdouble *, jint *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, lparg5, lparg6, lparg7, lparg8, lparg9, lparg10);
fail:
	if (arg10 && lparg10) env->ReleaseIntArrayElements(arg10, lparg10, 0);
	if (arg9 && lparg9) env->ReleaseIntArrayElements(arg9, lparg9, 0);
	if (arg8 && lparg8) env->ReleaseIntArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseDoubleArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseDoubleArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseDoubleArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJII_3D_3I_3D_3D_3I_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BI_3I_3I_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BI_3I_3I_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jint arg3, jintArray arg4, jintArray arg5, jintArray arg6, jintArray arg7)
{
	jbyte *lparg2=NULL;
	jint *lparg4=NULL;
	jint *lparg5=NULL;
	jint *lparg6=NULL;
	jint *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BI_3I_3I_3I_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jint, jint *, jint *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, lparg4, lparg5, lparg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BI_3I_3I_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3CII_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3CII_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jint arg3, jint arg4, jintArray arg5, jintArray arg6)
{
	jchar *lparg2=NULL;
	jint *lparg5=NULL;
	jint *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3CII_3I_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jint, jint, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, arg4, lparg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3CII_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BI_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BI_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jint arg3, jlongArray arg4)
{
	jbyte *lparg2=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BI_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jint, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BI_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3B_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3B_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jbyteArray arg3, jintArray arg4)
{
	jbyte *lparg3=NULL;
	jint *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3B_3I_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jbyte *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3B_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJI_3S
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJI_3S)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jshortArray arg4)
{
	jshort *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJI_3S_FUNC);
	if (arg4) if ((lparg4 = env->GetShortArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jshort *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseShortArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJI_3S_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3BJJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3BJJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jbyteArray arg3, jlong arg4, jlong arg5, jlongArray arg6)
{
	jbyte *lparg2=NULL;
	jbyte *lparg3=NULL;
	jlong *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3BJJ_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jbyte *, jlong, jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, arg4, arg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3BJJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3B_3BIJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3B_3BIJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jbyteArray arg3, jbyteArray arg4, jint arg5, jlong arg6)
{
	jbyte *lparg3=NULL;
	jbyte *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3B_3BIJ_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jbyte *, jbyte *, jint, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4, arg5, arg6);
fail:
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3B_3BIJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3B_3BJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3B_3BJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jbyteArray arg3, jbyteArray arg4, jlong arg5, jlongArray arg6)
{
	jbyte *lparg3=NULL;
	jbyte *lparg4=NULL;
	jlong *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3B_3BJ_3J_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jbyte *, jbyte *, jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4, arg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3B_3BJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3BI_3B_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3BI_3B_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jbyteArray arg3, jint arg4, jbyteArray arg5, jlongArray arg6)
{
	jbyte *lparg3=NULL;
	jbyte *lparg5=NULL;
	jlong *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3BI_3B_3J_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetByteArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jbyte *, jint, jbyte *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4, lparg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseByteArrayElements(arg5, lparg5, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3BI_3B_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3BI_3J_3J_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3BI_3J_3J_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jbyteArray arg3, jint arg4, jlongArray arg5, jlongArray arg6, jintArray arg7)
{
	jbyte *lparg3=NULL;
	jlong *lparg5=NULL;
	jlong *lparg6=NULL;
	jint *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3BI_3J_3J_3I_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jbyte *, jint, jlong *, jlong *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4, lparg5, lparg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3BI_3J_3J_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3BJJ_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3BJJ_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jbyteArray arg3, jlong arg4, jlong arg5, jintArray arg6)
{
	jbyte *lparg3=NULL;
	jint *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3BJJ_3I_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jbyte *, jlong, jlong, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4, arg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3BJJ_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3BJJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3BJJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jbyteArray arg3, jlong arg4, jlong arg5, jlongArray arg6)
{
	jbyte *lparg3=NULL;
	jlong *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3BJJ_3J_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jbyte *, jlong, jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4, arg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3BJJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3CI_3J_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3CI_3J_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jcharArray arg3, jint arg4, jlongArray arg5, jlongArray arg6)
{
	jchar *lparg3=NULL;
	jlong *lparg5=NULL;
	jlong *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3CI_3J_3J_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jchar *, jint, jlong *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4, lparg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3CI_3J_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3CI_3J_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3CI_3J_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jcharArray arg3, jint arg4, jlongArray arg5, jintArray arg6)
{
	jchar *lparg3=NULL;
	jlong *lparg5=NULL;
	jint *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3CI_3J_3I_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jchar *, jint, jlong *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4, lparg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3CI_3J_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJII_3J_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJII_3J_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jint arg4, jlongArray arg5, jintArray arg6)
{
	jlong *lparg5=NULL;
	jint *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJII_3J_3I_FUNC);
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jint, jlong *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, lparg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJII_3J_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJIJ_3J_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJIJ_3J_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jlong arg4, jlongArray arg5, jintArray arg6)
{
	jlong *lparg5=NULL;
	jint *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJIJ_3J_3I_FUNC);
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jlong, jlong *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, lparg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJIJ_3J_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BII_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BII_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jint arg3, jint arg4, jintArray arg5)
{
	jbyte *lparg2=NULL;
	jint *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BII_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jint, jint, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, arg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BII_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BIII_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BIII_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jint arg3, jint arg4, jint arg5, jintArray arg6)
{
	jbyte *lparg2=NULL;
	jint *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BIII_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jint, jint, jint, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, arg4, arg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BIII_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3BIIJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3BIIJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jbyteArray arg3, jint arg4, jint arg5, jlong arg6)
{
	jbyte *lparg2=NULL;
	jbyte *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3BIIJ_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jbyte *, jint, jint, jlong))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, arg4, arg5, arg6);
fail:
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3BIIJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3BIIJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3BIIJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jbyteArray arg3, jint arg4, jint arg5, jlong arg6)
{
	jbyte *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3BIIJ_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jbyte *, jint, jint, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4, arg5, arg6);
fail:
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3BIIJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJI_3BI_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJI_3BI_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jbyteArray arg3, jint arg4, jintArray arg5)
{
	jbyte *lparg3=NULL;
	jint *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJI_3BI_3I_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jbyte *, jint, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJI_3BI_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3B_3J_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3B_3J_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jbyteArray arg3, jlongArray arg4, jintArray arg5)
{
	jbyte *lparg3=NULL;
	jlong *lparg4=NULL;
	jint *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3B_3J_3I_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jbyte *, jlong *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3B_3J_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jintArray arg3, jintArray arg4)
{
	jint *lparg3=NULL;
	jint *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3I_3I_FUNC);
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3B_3I_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3B_3I_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jbyteArray arg3, jintArray arg4, jlongArray arg5)
{
	jbyte *lparg2=NULL;
	jbyte *lparg3=NULL;
	jint *lparg4=NULL;
	jlong *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3B_3I_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jbyte *, jint *, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3B_3I_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BD
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BD)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jdouble arg3)
{
	jbyte *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BD_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jdouble))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3);
fail:
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BD_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJD
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJD)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jdouble arg3)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJD_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jdouble))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJD_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3D
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3D)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jdoubleArray arg3)
{
	jbyte *lparg2=NULL;
	jdouble *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3D_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetDoubleArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jdouble *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseDoubleArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3D_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3F
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3F)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jfloatArray arg3)
{
	jbyte *lparg2=NULL;
	jfloat *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3F_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetFloatArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jfloat *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseFloatArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3F_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3BJI_3JJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3BJI_3JJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jbyteArray arg3, jlong arg4, jint arg5, jlongArray arg6, jlong arg7)
{
	jbyte *lparg3=NULL;
	jlong *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3BJI_3JJ_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jbyte *, jlong, jint, jlong *, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4, arg5, lparg6, arg7);
fail:
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3BJI_3JJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJI_3J_3J_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJI_3J_3J_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jint arg5, jlongArray arg6, jlongArray arg7, jintArray arg8)
{
	jlong *lparg6=NULL;
	jlong *lparg7=NULL;
	jint *lparg8=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJI_3J_3J_3I_FUNC);
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetLongArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetIntArrayElements(arg8, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jint, jlong *, jlong *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, lparg6, lparg7, lparg8);
fail:
	if (arg8 && lparg8) env->ReleaseIntArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseLongArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJI_3J_3J_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BIJI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BIJI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jint arg3, jlong arg4, jint arg5)
{
	jbyte *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BIJI_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jint, jlong, jint))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, arg4, arg5);
fail:
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BIJI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3BJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3BJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jbyteArray arg3, jlong arg4, jlong arg5)
{
	jbyte *lparg2=NULL;
	jbyte *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3BJJ_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jbyte *, jlong, jlong))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, arg4, arg5);
fail:
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3BJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BIIJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BIIJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jint arg3, jint arg4, jlong arg5)
{
	jbyte *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BIIJ_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jint, jint, jlong))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, arg4, arg5);
fail:
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BIIJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3BIJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3BIJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jbyteArray arg3, jint arg4, jlong arg5, jlong arg6)
{
	jbyte *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3BIJJ_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jbyte *, jint, jlong, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4, arg5, arg6);
fail:
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3BIJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3CIJI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3CIJI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jint arg3, jlong arg4, jint arg5)
{
	jchar *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3CIJI_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jint, jlong, jint))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, arg4, arg5);
fail:
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3CIJI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3BIJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3BIJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jbyteArray arg3, jint arg4, jlong arg5)
{
	jbyte *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3BIJ_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jbyte *, jint, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4, arg5);
fail:
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3BIJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3B_3J_3J_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3B_3J_3J_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jbyteArray arg3, jlongArray arg4, jlongArray arg5, jlongArray arg6)
{
	jbyte *lparg2=NULL;
	jbyte *lparg3=NULL;
	jlong *lparg4=NULL;
	jlong *lparg5=NULL;
	jlong *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3B_3J_3J_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jbyte *, jlong *, jlong *, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4, lparg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3B_3J_3J_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BJ_3J_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BJ_3J_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jlong arg3, jlongArray arg4, jintArray arg5, jintArray arg6)
{
	jbyte *lparg2=NULL;
	jlong *lparg4=NULL;
	jint *lparg5=NULL;
	jint *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BJ_3J_3I_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jlong, jlong *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, lparg4, lparg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BJ_3J_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJ_3J_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJ_3J_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jlongArray arg5, jlongArray arg6)
{
	jlong *lparg5=NULL;
	jlong *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJ_3J_3J_FUNC);
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jlong *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, lparg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJ_3J_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BJJ_3B
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BJJ_3B)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jlong arg3, jlong arg4, jbyteArray arg5)
{
	jbyte *lparg2=NULL;
	jbyte *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BJJ_3B_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetByteArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jlong, jlong, jbyte *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, arg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseByteArrayElements(arg5, lparg5, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BJJ_3B_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3BLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3BLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jbyteArray arg3, jobject arg4, jlongArray arg5)
{
	jbyte *lparg3=NULL;
	nsID _arg4, *lparg4=NULL;
	jlong *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3BLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = getnsIDFields(env, arg4, &_arg4)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jbyte *, nsID *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) setnsIDFields(env, arg4, lparg4);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3BLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jobject arg5, jlongArray arg6)
{
	nsID _arg5, *lparg5=NULL;
	jlong *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J_FUNC);
	if (arg5) if ((lparg5 = getnsIDFields(env, arg5, &_arg5)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, nsID *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, lparg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) setnsIDFields(env, arg5, lparg5);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jobject arg4, jlongArray arg5)
{
	nsID _arg4, *lparg4=NULL;
	jlong *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J_FUNC);
	if (arg4) if ((lparg4 = getnsIDFields(env, arg4, &_arg4)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, nsID *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) setnsIDFields(env, arg4, lparg4);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3J_3I_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3J_3I_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlongArray arg3, jintArray arg4, jlongArray arg5)
{
	jlong *lparg3=NULL;
	jint *lparg4=NULL;
	jlong *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3J_3I_3J_FUNC);
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong *, jint *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3J_3I_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJ_3I_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJ_3I_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jintArray arg5, jlongArray arg6)
{
	jint *lparg5=NULL;
	jlong *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJ_3I_3J_FUNC);
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jint *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, lparg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJ_3I_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJSSJSSJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJSSJSSJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jshort arg2, jshort arg3, jlong arg4, jshort arg5, jshort arg6, jlong arg7)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJSSJSSJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jshort, jshort, jlong, jshort, jshort, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJSSJSSJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJ_3S
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJ_3S)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jshortArray arg4)
{
	jshort *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJ_3S_FUNC);
	if (arg4) if ((lparg4 = env->GetShortArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jshort *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseShortArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJ_3S_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJIJJJJJJIJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJIJJJJJJIJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jint arg4, jlong arg5, jlong arg6, jlong arg7, jlong arg8, jlong arg9, jlong arg10, jint arg11, jlong arg12)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJIJJJJJJIJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jint, jlong, jlong, jlong, jlong, jlong, jlong, jint, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJIJJJJJJIJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3F
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3F)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jfloatArray arg3)
{
	jfloat *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3F_FUNC);
	if (arg3) if ((lparg3 = env->GetFloatArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jfloat *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseFloatArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3F_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJI_3F_3F
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJI_3F_3F)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jfloatArray arg3, jfloatArray arg4)
{
	jfloat *lparg3=NULL;
	jfloat *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJI_3F_3F_FUNC);
	if (arg3) if ((lparg3 = env->GetFloatArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetFloatArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jfloat *, jfloat *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseFloatArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseFloatArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJI_3F_3F_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2Lcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2Lcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jobject arg3, jobject arg4, jlongArray arg5)
{
	nsID _arg3, *lparg3=NULL;
	nsID _arg4, *lparg4=NULL;
	jlong *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2Lcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J_FUNC);
	if (arg3) if ((lparg3 = getnsIDFields(env, arg3, &_arg3)) == NULL) goto fail;
	if (arg4) if ((lparg4 = getnsIDFields(env, arg4, &_arg4)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, nsID *, nsID *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) setnsIDFields(env, arg4, lparg4);
	if (arg3 && lparg3) setnsIDFields(env, arg3, lparg3);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2Lcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3J_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3J_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlongArray arg2, jlongArray arg3)
{
	jlong *lparg2=NULL;
	jlong *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3J_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetLongArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong *, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseLongArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3J_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJS_3J_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJS_3J_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jshort arg2, jlongArray arg3, jlongArray arg4)
{
	jlong *lparg3=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJS_3J_3J_FUNC);
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jshort, jlong *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJS_3J_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3J_3J_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3J_3J_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlongArray arg2, jlongArray arg3, jintArray arg4)
{
	jlong *lparg2=NULL;
	jlong *lparg3=NULL;
	jint *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3J_3J_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetLongArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong *, jlong *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseLongArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3J_3J_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3J_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3J_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlongArray arg3, jlongArray arg4)
{
	jlong *lparg3=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3J_3J_FUNC);
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3J_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3JJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3JJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlongArray arg3, jlong arg4)
{
	jlong *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3JJ_FUNC);
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong *, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4);
fail:
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3JJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3J_3J_3J_3J_3J_3J_3J_3D_3D
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3J_3J_3J_3J_3J_3J_3J_3D_3D)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlongArray arg3, jlongArray arg4, jlongArray arg5, jlongArray arg6, jlongArray arg7, jlongArray arg8, jlongArray arg9, jdoubleArray arg10, jdoubleArray arg11)
{
	jlong *lparg3=NULL;
	jlong *lparg4=NULL;
	jlong *lparg5=NULL;
	jlong *lparg6=NULL;
	jlong *lparg7=NULL;
	jlong *lparg8=NULL;
	jlong *lparg9=NULL;
	jdouble *lparg10=NULL;
	jdouble *lparg11=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3J_3J_3J_3J_3J_3J_3J_3D_3D_FUNC);
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetLongArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetLongArrayElements(arg8, NULL)) == NULL) goto fail;
	if (arg9) if ((lparg9 = env->GetLongArrayElements(arg9, NULL)) == NULL) goto fail;
	if (arg10) if ((lparg10 = env->GetDoubleArrayElements(arg10, NULL)) == NULL) goto fail;
	if (arg11) if ((lparg11 = env->GetDoubleArrayElements(arg11, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong *, jlong *, jlong *, jlong *, jlong *, jlong *, jlong *, jdouble *, jdouble *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4, lparg5, lparg6, lparg7, lparg8, lparg9, lparg10, lparg11);
fail:
	if (arg11 && lparg11) env->ReleaseDoubleArrayElements(arg11, lparg11, 0);
	if (arg10 && lparg10) env->ReleaseDoubleArrayElements(arg10, lparg10, 0);
	if (arg9 && lparg9) env->ReleaseLongArrayElements(arg9, lparg9, 0);
	if (arg8 && lparg8) env->ReleaseLongArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseLongArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3J_3J_3J_3J_3J_3J_3J_3D_3D_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3J_3JJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3J_3JJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlongArray arg2, jlongArray arg3, jlong arg4, jlong arg5)
{
	jlong *lparg2=NULL;
	jlong *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3J_3JJJ_FUNC);
	if (arg2) if ((lparg2 = env->GetLongArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong *, jlong *, jlong, jlong))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, arg4, arg5);
fail:
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseLongArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3J_3JJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3IJJJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3IJJJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jintArray arg2, jlong arg3, jlong arg4, jlong arg5, jlongArray arg6)
{
	jint *lparg2=NULL;
	jlong *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3IJJJ_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetIntArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint *, jlong, jlong, jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, arg4, arg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	if (arg2 && lparg2) env->ReleaseIntArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3IJJJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3CJJJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3CJJJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jlong arg3, jlong arg4, jlong arg5, jlongArray arg6)
{
	jchar *lparg2=NULL;
	jlong *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3CJJJ_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jlong, jlong, jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, arg4, arg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3CJJJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJJ_3D
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJJ_3D)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jlong arg5, jdoubleArray arg6)
{
	jdouble *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJJ_3D_FUNC);
	if (arg6) if ((lparg6 = env->GetDoubleArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jlong, jdouble *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseDoubleArrayElements(arg6, lparg6, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJJ_3D_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJJJJ_3S
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJJJJ_3S)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jlong arg5, jlong arg6, jlong arg7, jshortArray arg8)
{
	jshort *lparg8=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJJJJ_3S_FUNC);
	if (arg8) if ((lparg8 = env->GetShortArrayElements(arg8, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jlong, jlong, jlong, jshort *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, lparg8);
fail:
	if (arg8 && lparg8) env->ReleaseShortArrayElements(arg8, lparg8, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJJJJ_3S_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJJJJJ_3S
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJJJJJ_3S)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jlong arg5, jlong arg6, jlong arg7, jlong arg8, jshortArray arg9)
{
	jshort *lparg9=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJJJJJ_3S_FUNC);
	if (arg9) if ((lparg9 = env->GetShortArrayElements(arg9, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong, jshort *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, lparg9);
fail:
	if (arg9 && lparg9) env->ReleaseShortArrayElements(arg9, lparg9, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJJJJJ_3S_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJJJJ_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJJJJ_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jlong arg5, jlong arg6, jlong arg7, jintArray arg8)
{
	jint *lparg8=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJJJJ_3I_FUNC);
	if (arg8) if ((lparg8 = env->GetIntArrayElements(arg8, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jlong, jlong, jlong, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, lparg8);
fail:
	if (arg8 && lparg8) env->ReleaseIntArrayElements(arg8, lparg8, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJJJJ_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJJIJJJ_3S
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJJIJJJ_3S)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jlong arg5, jint arg6, jlong arg7, jlong arg8, jlong arg9, jshortArray arg10)
{
	jshort *lparg10=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJJIJJJ_3S_FUNC);
	if (arg10) if ((lparg10 = env->GetShortArrayElements(arg10, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jlong, jint, jlong, jlong, jlong, jshort *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, lparg10);
fail:
	if (arg10 && lparg10) env->ReleaseShortArrayElements(arg10, lparg10, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJJIJJJ_3S_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJJJJJI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJJJJJI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jlong arg5, jlong arg6, jlong arg7, jlong arg8, jint arg9)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJJJJJI_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJJJJJI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BJJJJJ_3J_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BJJJJJ_3J_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jlong arg3, jlong arg4, jlong arg5, jlong arg6, jlong arg7, jlongArray arg8, jlongArray arg9)
{
	jbyte *lparg2=NULL;
	jlong *lparg8=NULL;
	jlong *lparg9=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BJJJJJ_3J_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetLongArrayElements(arg8, NULL)) == NULL) goto fail;
	if (arg9) if ((lparg9 = env->GetLongArrayElements(arg9, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jlong, jlong, jlong, jlong, jlong, jlong *, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, arg4, arg5, arg6, arg7, lparg8, lparg9);
fail:
	if (arg9 && lparg9) env->ReleaseLongArrayElements(arg9, lparg9, 0);
	if (arg8 && lparg8) env->ReleaseLongArrayElements(arg8, lparg8, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BJJJJJ_3J_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJIJ_3BJI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJIJ_3BJI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jint arg5, jlong arg6, jbyteArray arg7, jlong arg8, jint arg9)
{
	jbyte *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJIJ_3BJI_FUNC);
	if (arg7) if ((lparg7 = env->GetByteArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jint, jlong, jbyte *, jlong, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, lparg7, arg8, arg9);
fail:
	if (arg7 && lparg7) env->ReleaseByteArrayElements(arg7, lparg7, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJIJ_3BJI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJIJ_3BJI_3J_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJIJ_3BJI_3J_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jlong arg3, jbyteArray arg4, jlong arg5, jint arg6, jlongArray arg7, jintArray arg8)
{
	jbyte *lparg4=NULL;
	jlong *lparg7=NULL;
	jint *lparg8=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJIJ_3BJI_3J_3I_FUNC);
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetLongArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetIntArrayElements(arg8, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jlong, jbyte *, jlong, jint, jlong *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, arg5, arg6, lparg7, lparg8);
fail:
	if (arg8 && lparg8) env->ReleaseIntArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseLongArrayElements(arg7, lparg7, 0);
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJIJ_3BJI_3J_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJIJJJII_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJIJJJII_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jint arg4, jlong arg5, jlong arg6, jlong arg7, jint arg8, jint arg9, jlongArray arg10)
{
	jlong *lparg10=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJIJJJII_3J_FUNC);
	if (arg10) if ((lparg10 = env->GetLongArrayElements(arg10, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jint, jlong, jlong, jlong, jint, jint, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, lparg10);
fail:
	if (arg10 && lparg10) env->ReleaseLongArrayElements(arg10, lparg10, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJIJJJII_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJIJJJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJIJJJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jint arg5, jlong arg6, jlong arg7, jlong arg8, jlong arg9)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJIJJJJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jint, jlong, jlong, jlong, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJIJJJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJSJJJJJJJJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJSJJJJJJJJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jshort arg2, jlong arg3, jlong arg4, jlong arg5, jlong arg6, jlong arg7, jlong arg8, jlong arg9, jlong arg10, jlongArray arg11)
{
	jlong *lparg11=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJSJJJJJJJJ_3J_FUNC);
	if (arg11) if ((lparg11 = env->GetLongArrayElements(arg11, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jshort, jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, lparg11);
fail:
	if (arg11 && lparg11) env->ReleaseLongArrayElements(arg11, lparg11, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJSJJJJJJJJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BIJIJIJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BIJIJIJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jint arg3, jlong arg4, jint arg5, jlong arg6, jint arg7, jlong arg8, jlongArray arg9)
{
	jbyte *lparg2=NULL;
	jlong *lparg9=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BIJIJIJ_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg9) if ((lparg9 = env->GetLongArrayElements(arg9, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jint, jlong, jint, jlong, jint, jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, arg4, arg5, arg6, arg7, arg8, lparg9);
fail:
	if (arg9 && lparg9) env->ReleaseLongArrayElements(arg9, lparg9, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BIJIJIJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJIIIIJJJ_3I_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJIIIIJJJ_3I_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jint arg4, jint arg5, jint arg6, jlong arg7, jlong arg8, jlong arg9, jintArray arg10, jlongArray arg11)
{
	jint *lparg10=NULL;
	jlong *lparg11=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJIIIIJJJ_3I_3J_FUNC);
	if (arg10) if ((lparg10 = env->GetIntArrayElements(arg10, NULL)) == NULL) goto fail;
	if (arg11) if ((lparg11 = env->GetLongArrayElements(arg11, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jint, jint, jint, jlong, jlong, jlong, jint *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, lparg10, lparg11);
fail:
	if (arg11 && lparg11) env->ReleaseLongArrayElements(arg11, lparg11, 0);
	if (arg10 && lparg10) env->ReleaseIntArrayElements(arg10, lparg10, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJIIIIJJJ_3I_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJIIJIFFFF
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJIIJIFFFF)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jint arg4, jlong arg5, jint arg6, jfloat arg7, jfloat arg8, jfloat arg9, jfloat arg10)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJIIJIFFFF_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jint, jlong, jint, jfloat, jfloat, jfloat, jfloat))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJIIJIFFFF_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJJIIIJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJJIIIJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jlong arg5, jint arg6, jint arg7, jint arg8, jlong arg9)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJJIIIJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jlong, jint, jint, jint, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJJIIIJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3J_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3J_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlongArray arg3, jintArray arg4)
{
	jlong *lparg3=NULL;
	jint *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3J_3I_FUNC);
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3J_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2JJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2JJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jobject arg3, jlong arg4, jlong arg5)
{
	nsID _arg3, *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2JJ_FUNC);
	if (arg3) if ((lparg3 = getnsIDFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, nsID *, jlong, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4, arg5);
fail:
	if (arg3 && lparg3) setnsIDFields(env, arg3, lparg3);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2JJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3C_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3C_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jcharArray arg3, jlongArray arg4)
{
	jbyte *lparg2=NULL;
	jchar *lparg3=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3C_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jchar *, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3C_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jlong arg3, jlongArray arg4)
{
	jbyte *lparg2=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BJ_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3S_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3S_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jshortArray arg3, jlongArray arg4)
{
	jbyte *lparg2=NULL;
	jshort *lparg3=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3S_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetShortArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jshort *, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseShortArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3S_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3C_3B_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3C_3B_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jbyteArray arg3, jlongArray arg4)
{
	jchar *lparg2=NULL;
	jbyte *lparg3=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3C_3B_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jbyte *, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3C_3B_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3B_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3B_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jbyteArray arg3, jlongArray arg4)
{
	jbyte *lparg3=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3B_3J_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jbyte *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3B_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3C_3CI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3C_3CI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jcharArray arg3, jcharArray arg4, jint arg5)
{
	jbyte *lparg2=NULL;
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3C_3CI_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jchar *, jchar *, jint))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4, arg5);
fail:
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3C_3CI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3C_3C_3C_3C
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3C_3C_3C_3C)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jcharArray arg3, jcharArray arg4, jcharArray arg5)
{
	jchar *lparg2=NULL;
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jchar *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3C_3C_3C_3C_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetCharArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jchar *, jchar *, jchar *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseCharArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3C_3C_3C_3C_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3BI_3C_3C_3C_3J_3J_3I_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3BI_3C_3C_3C_3J_3J_3I_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jbyteArray arg3, jint arg4, jcharArray arg5, jcharArray arg6, jcharArray arg7, jlongArray arg8, jlongArray arg9, jintArray arg10, jlongArray arg11)
{
	jbyte *lparg3=NULL;
	jchar *lparg5=NULL;
	jchar *lparg6=NULL;
	jchar *lparg7=NULL;
	jlong *lparg8=NULL;
	jlong *lparg9=NULL;
	jint *lparg10=NULL;
	jlong *lparg11=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3BI_3C_3C_3C_3J_3J_3I_3J_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetCharArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetCharArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetCharArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetLongArrayElements(arg8, NULL)) == NULL) goto fail;
	if (arg9) if ((lparg9 = env->GetLongArrayElements(arg9, NULL)) == NULL) goto fail;
	if (arg10) if ((lparg10 = env->GetIntArrayElements(arg10, NULL)) == NULL) goto fail;
	if (arg11) if ((lparg11 = env->GetLongArrayElements(arg11, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jbyte *, jint, jchar *, jchar *, jchar *, jlong *, jlong *, jint *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4, lparg5, lparg6, lparg7, lparg8, lparg9, lparg10, lparg11);
fail:
	if (arg11 && lparg11) env->ReleaseLongArrayElements(arg11, lparg11, 0);
	if (arg10 && lparg10) env->ReleaseIntArrayElements(arg10, lparg10, 0);
	if (arg9 && lparg9) env->ReleaseLongArrayElements(arg9, lparg9, 0);
	if (arg8 && lparg8) env->ReleaseLongArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseCharArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseCharArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseCharArrayElements(arg5, lparg5, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3BI_3C_3C_3C_3J_3J_3I_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3C_3C_3C_3C_3CI_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3C_3C_3C_3C_3CI_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jcharArray arg3, jcharArray arg4, jcharArray arg5, jcharArray arg6, jcharArray arg7, jint arg8, jintArray arg9, jintArray arg10)
{
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jchar *lparg5=NULL;
	jchar *lparg6=NULL;
	jchar *lparg7=NULL;
	jint *lparg9=NULL;
	jint *lparg10=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3C_3C_3C_3C_3CI_3I_3I_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetCharArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetCharArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetCharArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg9) if ((lparg9 = env->GetIntArrayElements(arg9, NULL)) == NULL) goto fail;
	if (arg10) if ((lparg10 = env->GetIntArrayElements(arg10, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jchar *, jchar *, jchar *, jchar *, jchar *, jint, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4, lparg5, lparg6, lparg7, arg8, lparg9, lparg10);
fail:
	if (arg10 && lparg10) env->ReleaseIntArrayElements(arg10, lparg10, 0);
	if (arg9 && lparg9) env->ReleaseIntArrayElements(arg9, lparg9, 0);
	if (arg7 && lparg7) env->ReleaseCharArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseCharArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseCharArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3C_3C_3C_3C_3CI_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3C_3C_3CI_3C_3J_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3C_3C_3CI_3C_3J_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jcharArray arg3, jcharArray arg4, jint arg5, jcharArray arg6, jlongArray arg7, jintArray arg8)
{
	jchar *lparg2=NULL;
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jchar *lparg6=NULL;
	jlong *lparg7=NULL;
	jint *lparg8=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3C_3C_3CI_3C_3J_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetCharArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetLongArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetIntArrayElements(arg8, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jchar *, jchar *, jint, jchar *, jlong *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4, arg5, lparg6, lparg7, lparg8);
fail:
	if (arg8 && lparg8) env->ReleaseIntArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseLongArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseCharArrayElements(arg6, lparg6, 0);
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3C_3C_3CI_3C_3J_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3C_3C_3CI_3J_3J_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3C_3C_3CI_3J_3J_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jcharArray arg3, jcharArray arg4, jint arg5, jlongArray arg6, jlongArray arg7, jintArray arg8)
{
	jchar *lparg2=NULL;
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jlong *lparg6=NULL;
	jlong *lparg7=NULL;
	jint *lparg8=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3C_3C_3CI_3J_3J_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetLongArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetIntArrayElements(arg8, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jchar *, jchar *, jint, jlong *, jlong *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4, arg5, lparg6, lparg7, lparg8);
fail:
	if (arg8 && lparg8) env->ReleaseIntArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseLongArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3C_3C_3CI_3J_3J_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3C_3C_3CI_3J_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3C_3C_3CI_3J_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jcharArray arg3, jcharArray arg4, jint arg5, jlongArray arg6, jintArray arg7)
{
	jchar *lparg2=NULL;
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jlong *lparg6=NULL;
	jint *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3C_3C_3CI_3J_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jchar *, jchar *, jint, jlong *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4, arg5, lparg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3C_3C_3CI_3J_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3CIII_3I_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3CIII_3I_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jint arg3, jint arg4, jint arg5, jintArray arg6, jintArray arg7, jintArray arg8)
{
	jchar *lparg2=NULL;
	jint *lparg6=NULL;
	jint *lparg7=NULL;
	jint *lparg8=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3CIII_3I_3I_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetIntArrayElements(arg8, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jint, jint, jint, jint *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, arg4, arg5, lparg6, lparg7, lparg8);
fail:
	if (arg8 && lparg8) env->ReleaseIntArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3CIII_3I_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3C_3CI_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3C_3CI_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jcharArray arg3, jcharArray arg4, jint arg5, jintArray arg6, jintArray arg7)
{
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jint *lparg6=NULL;
	jint *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3C_3CI_3I_3I_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jchar *, jchar *, jint, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4, arg5, lparg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3C_3CI_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3C_3CII
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3C_3CII)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jcharArray arg3, jint arg4, jint arg5)
{
	jchar *lparg2=NULL;
	jchar *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3C_3CII_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jchar *, jint, jint))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, arg4, arg5);
fail:
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3C_3CII_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3C_3C_3C
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3C_3C_3C)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jcharArray arg3, jcharArray arg4)
{
	jchar *lparg2=NULL;
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3C_3C_3C_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jchar *, jchar *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3C_3C_3C_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3C_3CI_3J_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3C_3CI_3J_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jcharArray arg3, jint arg4, jlongArray arg5, jintArray arg6)
{
	jchar *lparg2=NULL;
	jchar *lparg3=NULL;
	jlong *lparg5=NULL;
	jint *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3C_3CI_3J_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jchar *, jint, jlong *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, arg4, lparg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3C_3CI_3J_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJIIIJJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJIIIJJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jint arg4, jlong arg5, jlong arg6, jlong arg7)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJIIIJJJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jint, jlong, jlong, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJIIIJJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJIIJ_3BJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJIIJ_3BJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jlong arg4, jbyteArray arg5, jlong arg6)
{
	jbyte *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJIIJ_3BJ_FUNC);
	if (arg5) if ((lparg5 = env->GetByteArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jlong, jbyte *, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, lparg5, arg6);
fail:
	if (arg5 && lparg5) env->ReleaseByteArrayElements(arg5, lparg5, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJIIJ_3BJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3C_3CI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3C_3CI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jcharArray arg3, jint arg4)
{
	jchar *lparg2=NULL;
	jchar *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3C_3CI_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jchar *, jint))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, arg4);
fail:
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3C_3CI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3C_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3C_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jintArray arg3, jintArray arg4)
{
	jchar *lparg2=NULL;
	jint *lparg3=NULL;
	jint *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3C_3I_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3C_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3CIJIJJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3CIJIJJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jint arg3, jlong arg4, jint arg5, jlong arg6, jlong arg7, jlong arg8)
{
	jchar *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3CIJIJJJ_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jint, jlong, jint, jlong, jlong, jlong))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, arg4, arg5, arg6, arg7, arg8);
fail:
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3CIJIJJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3C_3CJ_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3C_3CJ_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jcharArray arg3, jlong arg4, jintArray arg5)
{
	jchar *lparg2=NULL;
	jchar *lparg3=NULL;
	jint *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3C_3CJ_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jchar *, jlong, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, arg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3C_3CJ_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3CIJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3CIJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jint arg3, jlong arg4)
{
	jchar *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3CIJ_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jint, jlong))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, arg4);
fail:
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3CIJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3C_3J_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3C_3J_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jlongArray arg3, jintArray arg4)
{
	jchar *lparg2=NULL;
	jlong *lparg3=NULL;
	jint *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3C_3J_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jlong *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3C_3J_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3CJJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3CJJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jlong arg3, jlong arg4, jlongArray arg5)
{
	jchar *lparg2=NULL;
	jlong *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3CJJ_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jlong, jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, arg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3CJJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3D
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3D)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jdoubleArray arg3)
{
	jdouble *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3D_FUNC);
	if (arg3) if ((lparg3 = env->GetDoubleArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jdouble *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseDoubleArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3D_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJFFFFFFII_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJFFFFFFII_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jfloat arg2, jfloat arg3, jfloat arg4, jfloat arg5, jfloat arg6, jfloat arg7, jint arg8, jint arg9, jlongArray arg10)
{
	jlong *lparg10=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJFFFFFFII_3J_FUNC);
	if (arg10) if ((lparg10 = env->GetLongArrayElements(arg10, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jfloat, jfloat, jfloat, jfloat, jfloat, jfloat, jint, jint, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, lparg10);
fail:
	if (arg10 && lparg10) env->ReleaseLongArrayElements(arg10, lparg10, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJFFFFFFII_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJFFIDII
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJFFIDII)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jfloat arg3, jfloat arg4, jint arg5, jdouble arg6, jint arg7, jint arg8)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJFFIDII_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jfloat, jfloat, jint, jdouble, jint, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJFFIDII_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJFFFJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJFFFJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jfloat arg4, jfloat arg5, jfloat arg6, jlong arg7)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJFFFJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jfloat, jfloat, jfloat, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJFFFJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJFFFF
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJFFFF)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jfloat arg2, jfloat arg3, jfloat arg4, jfloat arg5)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJFFFF_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jfloat, jfloat, jfloat, jfloat))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJFFFF_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJI_3BI_3BIIJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJI_3BI_3BIIJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jbyteArray arg3, jint arg4, jbyteArray arg5, jint arg6, jint arg7, jlong arg8, jlongArray arg9)
{
	jbyte *lparg3=NULL;
	jbyte *lparg5=NULL;
	jlong *lparg9=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJI_3BI_3BIIJ_3J_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetByteArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg9) if ((lparg9 = env->GetLongArrayElements(arg9, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jbyte *, jint, jbyte *, jint, jint, jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4, lparg5, arg6, arg7, arg8, lparg9);
fail:
	if (arg9 && lparg9) env->ReleaseLongArrayElements(arg9, lparg9, 0);
	if (arg5 && lparg5) env->ReleaseByteArrayElements(arg5, lparg5, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJI_3BI_3BIIJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3B_3B_3BIIIJJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3B_3B_3BIIIJJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jbyteArray arg3, jbyteArray arg4, jbyteArray arg5, jint arg6, jint arg7, jint arg8, jlong arg9, jlong arg10, jlongArray arg11)
{
	jbyte *lparg3=NULL;
	jbyte *lparg4=NULL;
	jbyte *lparg5=NULL;
	jlong *lparg11=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3B_3B_3BIIIJJ_3J_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetByteArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg11) if ((lparg11 = env->GetLongArrayElements(arg11, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jbyte *, jbyte *, jbyte *, jint, jint, jint, jlong, jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4, lparg5, arg6, arg7, arg8, arg9, arg10, lparg11);
fail:
	if (arg11 && lparg11) env->ReleaseLongArrayElements(arg11, lparg11, 0);
	if (arg5 && lparg5) env->ReleaseByteArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3B_3B_3BIIIJJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3C
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3C)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jcharArray arg3)
{
	jchar *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3C_FUNC);
	if (arg3) if ((lparg3 = env->GetCharArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jchar *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseCharArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3C_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJI_3BI_3B
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJI_3BI_3B)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jbyteArray arg4, jint arg5, jbyteArray arg6)
{
	jbyte *lparg4=NULL;
	jbyte *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJI_3BI_3B_FUNC);
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetByteArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jbyte *, jint, jbyte *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, arg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseByteArrayElements(arg6, lparg6, 0);
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJI_3BI_3B_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJI_3BIJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJI_3BIJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jbyteArray arg4, jint arg5, jlong arg6)
{
	jbyte *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJI_3BIJ_FUNC);
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jbyte *, jint, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, arg5, arg6);
fail:
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJI_3BIJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJII_3B_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJII_3B_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jbyteArray arg4, jlongArray arg5)
{
	jbyte *lparg4=NULL;
	jlong *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJII_3B_3J_FUNC);
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jbyte *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJII_3B_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3CI_3C
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3CI_3C)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jint arg3, jcharArray arg4)
{
	jchar *lparg2=NULL;
	jchar *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3CI_3C_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jint, jchar *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3CI_3C_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJI_3C
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJI_3C)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jcharArray arg4)
{
	jchar *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJI_3C_FUNC);
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jchar *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJI_3C_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJID_3BI_3BI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJID_3BI_3BI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jdouble arg3, jbyteArray arg4, jint arg5, jbyteArray arg6, jint arg7)
{
	jbyte *lparg4=NULL;
	jbyte *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJID_3BI_3BI_FUNC);
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetByteArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jdouble, jbyte *, jint, jbyte *, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, arg5, lparg6, arg7);
fail:
	if (arg6 && lparg6) env->ReleaseByteArrayElements(arg6, lparg6, 0);
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJID_3BI_3BI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJIIIIIIII_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJIIIIIIII_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jint arg4, jint arg5, jint arg6, jint arg7, jint arg8, jint arg9, jintArray arg10)
{
	jint *lparg10=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJIIIIIIII_3I_FUNC);
	if (arg10) if ((lparg10 = env->GetIntArrayElements(arg10, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jint, jint, jint, jint, jint, jint, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, lparg10);
fail:
	if (arg10 && lparg10) env->ReleaseIntArrayElements(arg10, lparg10, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJIIIIIIII_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJIIIDDDIIJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJIIIDDDIIJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jint arg4, jdouble arg5, jdouble arg6, jdouble arg7, jint arg8, jint arg9, jlong arg10, jlong arg11)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJIIIDDDIIJJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jint, jdouble, jdouble, jdouble, jint, jint, jlong, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJIIIDDDIIJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJIIIIII_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJIIIIII_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jint arg4, jint arg5, jint arg6, jint arg7, jlongArray arg8)
{
	jlong *lparg8=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJIIIIII_3J_FUNC);
	if (arg8) if ((lparg8 = env->GetLongArrayElements(arg8, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jint, jint, jint, jint, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, lparg8);
fail:
	if (arg8 && lparg8) env->ReleaseLongArrayElements(arg8, lparg8, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJIIIIII_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJIIII_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJIIII_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jint arg4, jint arg5, jint arg6, jintArray arg7)
{
	jint *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJIIII_3I_FUNC);
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jint, jint, jint, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJIIII_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJFI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJFI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jfloat arg2, jint arg3)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJFI_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jfloat, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJFI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJII_3I_3I_3I_3II
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJII_3I_3I_3I_3II)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jintArray arg4, jintArray arg5, jintArray arg6, jintArray arg7, jint arg8)
{
	jint *lparg4=NULL;
	jint *lparg5=NULL;
	jint *lparg6=NULL;
	jint *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJII_3I_3I_3I_3II_FUNC);
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jint *, jint *, jint *, jint *, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, lparg5, lparg6, lparg7, arg8);
fail:
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJII_3I_3I_3I_3II_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJII_3I_3IJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJII_3I_3IJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jintArray arg4, jintArray arg5, jlong arg6)
{
	jint *lparg4=NULL;
	jint *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJII_3I_3IJ_FUNC);
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jint *, jint *, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, lparg5, arg6);
fail:
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJII_3I_3IJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJFI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJFI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jfloat arg3, jint arg4)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJFI_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jfloat, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJFI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJI_3I_3I_3I_3II
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJI_3I_3I_3I_3II)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jintArray arg3, jintArray arg4, jintArray arg5, jintArray arg6, jint arg7)
{
	jint *lparg3=NULL;
	jint *lparg4=NULL;
	jint *lparg5=NULL;
	jint *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJI_3I_3I_3I_3II_FUNC);
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint *, jint *, jint *, jint *, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4, lparg5, lparg6, arg7);
fail:
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJI_3I_3I_3I_3II_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJII_3I_3I_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJII_3I_3I_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jintArray arg4, jintArray arg5, jlongArray arg6)
{
	jint *lparg4=NULL;
	jint *lparg5=NULL;
	jlong *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJII_3I_3I_3J_FUNC);
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jint *, jint *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, lparg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJII_3I_3I_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJI_3I_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJI_3I_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jintArray arg4, jlongArray arg5)
{
	jint *lparg4=NULL;
	jlong *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJI_3I_3J_FUNC);
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jint *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJI_3I_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJI_3I_3F
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJI_3I_3F)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jintArray arg3, jfloatArray arg4)
{
	jint *lparg3=NULL;
	jfloat *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJI_3I_3F_FUNC);
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetFloatArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint *, jfloat *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseFloatArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJI_3I_3F_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3IJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3IJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jintArray arg3, jlong arg4)
{
	jint *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3IJ_FUNC);
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint *, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4);
fail:
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3IJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJII_3I_3JJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJII_3I_3JJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jintArray arg4, jlongArray arg5, jlong arg6)
{
	jint *lparg4=NULL;
	jlong *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJII_3I_3JJ_FUNC);
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jint *, jlong *, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, lparg5, arg6);
fail:
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJII_3I_3JJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3J_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3J_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlongArray arg2, jintArray arg3)
{
	jlong *lparg2=NULL;
	jint *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3J_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetLongArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseLongArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3J_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJIID
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJIID)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jdouble arg4)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJIID_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jdouble))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJIID_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJD_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJD_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jdouble arg2, jlongArray arg3)
{
	jlong *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJD_3J_FUNC);
	if (arg3) if ((lparg3 = env->GetLongArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jdouble, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseLongArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJD_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3I_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3I_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jintArray arg2, jintArray arg3, jintArray arg4)
{
	jint *lparg2=NULL;
	jint *lparg3=NULL;
	jint *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3I_3I_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetIntArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseIntArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3I_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3I_3S
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3I_3S)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jintArray arg2, jshortArray arg3)
{
	jint *lparg2=NULL;
	jshort *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3I_3S_FUNC);
	if (arg2) if ((lparg2 = env->GetIntArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetShortArrayElements(arg3, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint *, jshort *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3);
fail:
	if (arg3 && lparg3) env->ReleaseShortArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseIntArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3I_3S_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJI_3I_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJI_3I_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jintArray arg3, jlongArray arg4)
{
	jint *lparg3=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJI_3I_3J_FUNC);
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJI_3I_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3I_3I_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3I_3I_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jintArray arg2, jintArray arg3, jlongArray arg4)
{
	jint *lparg2=NULL;
	jint *lparg3=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3I_3I_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetIntArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint *, jint *, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseIntArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3I_3I_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3I_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3I_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jintArray arg3, jlongArray arg4)
{
	jint *lparg3=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3I_3J_FUNC);
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3I_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJJ_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJJ_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jlong arg5, jintArray arg6)
{
	jint *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJJ_3I_FUNC);
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jlong, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJJ_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJJJ_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJJJ_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jlong arg5, jlong arg6, jintArray arg7)
{
	jint *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJJJ_3I_FUNC);
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jlong, jlong, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJJJ_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BI_3C_3C_3C
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BI_3C_3C_3C)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jint arg3, jcharArray arg4, jcharArray arg5, jcharArray arg6)
{
	jbyte *lparg2=NULL;
	jchar *lparg4=NULL;
	jchar *lparg5=NULL;
	jchar *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BI_3C_3C_3C_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetCharArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetCharArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jint, jchar *, jchar *, jchar *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, lparg4, lparg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseCharArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseCharArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BI_3C_3C_3C_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJ_3C_3CI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJ_3C_3CI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jcharArray arg4, jcharArray arg5, jint arg6)
{
	jchar *lparg4=NULL;
	jchar *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJ_3C_3CI_FUNC);
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetCharArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jchar *, jchar *, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, lparg5, arg6);
fail:
	if (arg5 && lparg5) env->ReleaseCharArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJ_3C_3CI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJ_3C_3C_3C_3CJI_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJ_3C_3C_3C_3CJI_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jcharArray arg5, jcharArray arg6, jcharArray arg7, jcharArray arg8, jlong arg9, jint arg10, jintArray arg11)
{
	jchar *lparg5=NULL;
	jchar *lparg6=NULL;
	jchar *lparg7=NULL;
	jchar *lparg8=NULL;
	jint *lparg11=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJ_3C_3C_3C_3CJI_3I_FUNC);
	if (arg5) if ((lparg5 = env->GetCharArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetCharArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetCharArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetCharArrayElements(arg8, NULL)) == NULL) goto fail;
	if (arg11) if ((lparg11 = env->GetIntArrayElements(arg11, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jchar *, jchar *, jchar *, jchar *, jlong, jint, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, lparg5, lparg6, lparg7, lparg8, arg9, arg10, lparg11);
fail:
	if (arg11 && lparg11) env->ReleaseIntArrayElements(arg11, lparg11, 0);
	if (arg8 && lparg8) env->ReleaseCharArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseCharArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseCharArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseCharArrayElements(arg5, lparg5, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJ_3C_3C_3C_3CJI_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJIIII_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJIIII_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jint arg4, jint arg5, jint arg6, jint arg7, jlongArray arg8)
{
	jlong *lparg8=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJIIII_3J_FUNC);
	if (arg8) if ((lparg8 = env->GetLongArrayElements(arg8, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jint, jint, jint, jint, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, lparg8);
fail:
	if (arg8 && lparg8) env->ReleaseLongArrayElements(arg8, lparg8, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJIIII_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJ_3C
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJ_3C)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jcharArray arg4)
{
	jchar *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJ_3C_FUNC);
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jchar *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJ_3C_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jobject arg3, jint arg4)
{
	nsID _arg3, *lparg3=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2I_FUNC);
	if (arg3) if ((lparg3 = getnsIDFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, nsID *, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4);
fail:
	if (arg3 && lparg3) setnsIDFields(env, arg3, lparg3);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJLcom_ibm_rcp_dombrowser_internal_mozilla_nsID_2I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJ_3CJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJ_3CJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jcharArray arg4, jlong arg5)
{
	jchar *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJ_3CJ_FUNC);
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jchar *, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, arg5);
fail:
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJ_3CJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJ_3D
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJ_3D)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jdoubleArray arg4)
{
	jdouble *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJ_3D_FUNC);
	if (arg4) if ((lparg4 = env->GetDoubleArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jdouble *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseDoubleArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJ_3D_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJFFIIIIFSI_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJFFIIIIFSI_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jfloat arg3, jfloat arg4, jint arg5, jint arg6, jint arg7, jint arg8, jfloat arg9, jshort arg10, jint arg11, jintArray arg12)
{
	jint *lparg12=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJFFIIIIFSI_3I_FUNC);
	if (arg12) if ((lparg12 = env->GetIntArrayElements(arg12, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jfloat, jfloat, jint, jint, jint, jint, jfloat, jshort, jint, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, lparg12);
fail:
	if (arg12 && lparg12) env->ReleaseIntArrayElements(arg12, lparg12, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJFFIIIIFSI_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJFFIIIIFSI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJFFIIIIFSI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jfloat arg3, jfloat arg4, jint arg5, jint arg6, jint arg7, jint arg8, jfloat arg9, jshort arg10, jint arg11)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJFFIIIIFSI_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jfloat, jfloat, jint, jint, jint, jint, jfloat, jshort, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJFFIIIIFSI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJFFIIIIFSIIIIIII_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJFFIIIIFSIIIIIII_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jfloat arg3, jfloat arg4, jint arg5, jint arg6, jint arg7, jint arg8, jfloat arg9, jshort arg10, jint arg11, jint arg12, jint arg13, jint arg14, jint arg15, jint arg16, jint arg17, jintArray arg18)
{
	jint *lparg18=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJFFIIIIFSIIIIIII_3I_FUNC);
	if (arg18) if ((lparg18 = env->GetIntArrayElements(arg18, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jfloat, jfloat, jint, jint, jint, jint, jfloat, jshort, jint, jint, jint, jint, jint, jint, jint, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, lparg18);
fail:
	if (arg18 && lparg18) env->ReleaseIntArrayElements(arg18, lparg18, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJFFIIIIFSIIIIIII_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJFFII_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJFFII_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jfloat arg2, jfloat arg3, jint arg4, jint arg5, jlongArray arg6)
{
	jlong *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJFFII_3J_FUNC);
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jfloat, jfloat, jint, jint, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJFFII_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJFFIIIIFSIIIIIII
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJFFIIIIFSIIIIIII)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jfloat arg3, jfloat arg4, jint arg5, jint arg6, jint arg7, jint arg8, jfloat arg9, jshort arg10, jint arg11, jint arg12, jint arg13, jint arg14, jint arg15, jint arg16, jint arg17)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJFFIIIIFSIIIIIII_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jfloat, jfloat, jint, jint, jint, jint, jfloat, jshort, jint, jint, jint, jint, jint, jint, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJFFIIIIFSIIIIIII_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJIIJIIIIIIIIISJIIDI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJIIJIIIIIIIIISJIIDI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jint arg4, jlong arg5, jint arg6, jint arg7, jint arg8, jint arg9, jint arg10, jint arg11, jint arg12, jint arg13, jint arg14, jshort arg15, jlong arg16, jint arg17, jint arg18, jdouble arg19, jint arg20)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJIIJIIIIIIIIISJIIDI_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jint, jlong, jint, jint, jint, jint, jint, jint, jint, jint, jint, jshort, jlong, jint, jint, jdouble, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJIIJIIIIIIIIISJIIDI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJIIJIIIIIIIIISJI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJIIJIIIIIIIIISJI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jint arg4, jlong arg5, jint arg6, jint arg7, jint arg8, jint arg9, jint arg10, jint arg11, jint arg12, jint arg13, jint arg14, jshort arg15, jlong arg16, jint arg17)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJIIJIIIIIIIIISJI_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jint, jlong, jint, jint, jint, jint, jint, jint, jint, jint, jint, jshort, jlong, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJIIJIIIIIIIIISJI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJIIJIIIIIIIIISJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJIIJIIIIIIIIISJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jint arg4, jlong arg5, jint arg6, jint arg7, jint arg8, jint arg9, jint arg10, jint arg11, jint arg12, jint arg13, jint arg14, jshort arg15, jlong arg16, jlong arg17)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJIIJIIIIIIIIISJJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jint, jlong, jint, jint, jint, jint, jint, jint, jint, jint, jint, jshort, jlong, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJIIJIIIIIIIIISJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJIIJIIIIISJJDDDI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJIIJIIIIISJJDDDI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jint arg4, jlong arg5, jint arg6, jint arg7, jint arg8, jint arg9, jint arg10, jshort arg11, jlong arg12, jlong arg13, jdouble arg14, jdouble arg15, jdouble arg16, jint arg17)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJIIJIIIIISJJDDDI_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jint, jlong, jint, jint, jint, jint, jint, jshort, jlong, jlong, jdouble, jdouble, jdouble, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJIIJIIIIISJJDDDI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3CIIIIIIII_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3CIIIIIIII_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jint arg3, jint arg4, jint arg5, jint arg6, jint arg7, jint arg8, jint arg9, jint arg10, jlongArray arg11)
{
	jchar *lparg2=NULL;
	jlong *lparg11=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3CIIIIIIII_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg11) if ((lparg11 = env->GetLongArrayElements(arg11, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jint, jint, jint, jint, jint, jint, jint, jint, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, lparg11);
fail:
	if (arg11 && lparg11) env->ReleaseLongArrayElements(arg11, lparg11, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3CIIIIIIII_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJFFDDDIIIII
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJFFDDDIIIII)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jfloat arg2, jfloat arg3, jdouble arg4, jdouble arg5, jdouble arg6, jint arg7, jint arg8, jint arg9, jint arg10, jint arg11)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJFFDDDIIIII_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jfloat, jfloat, jdouble, jdouble, jdouble, jint, jint, jint, jint, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJFFDDDIIIII_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJIISSJJIJIIIII
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJIISSJJIJIIIII)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jshort arg4, jshort arg5, jlong arg6, jlong arg7, jint arg8, jlong arg9, jint arg10, jint arg11, jint arg12, jint arg13, jint arg14)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJIISSJJIJIIIII_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jshort, jshort, jlong, jlong, jint, jlong, jint, jint, jint, jint, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJIISSJJIJIIIII_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJIIIIIFFIII_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJIIIIIFFIII_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jint arg4, jint arg5, jint arg6, jint arg7, jfloat arg8, jfloat arg9, jint arg10, jint arg11, jint arg12, jintArray arg13)
{
	jint *lparg13=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJIIIIIFFIII_3I_FUNC);
	if (arg13) if ((lparg13 = env->GetIntArrayElements(arg13, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jint, jint, jint, jint, jfloat, jfloat, jint, jint, jint, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, lparg13);
fail:
	if (arg13 && lparg13) env->ReleaseIntArrayElements(arg13, lparg13, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJIIIIIFFIII_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJIIIIIFFII
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJIIIIIFFII)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jint arg4, jint arg5, jint arg6, jint arg7, jfloat arg8, jfloat arg9, jint arg10, jint arg11)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJIIIIIFFII_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jint, jint, jint, jint, jfloat, jfloat, jint, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJIIIIIFFII_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJIIJIIIIIJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJIIJIIIIIJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jint arg4, jlong arg5, jint arg6, jint arg7, jint arg8, jint arg9, jint arg10, jlong arg11)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJIIJIIIIIJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jint, jlong, jint, jint, jint, jint, jint, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJIIJIIIIIJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BIJIJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BIJIJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jint arg3, jlong arg4, jint arg5, jlong arg6, jlongArray arg7)
{
	jbyte *lparg2=NULL;
	jlong *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BIJIJ_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetLongArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jint, jlong, jint, jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, arg4, arg5, arg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseLongArrayElements(arg7, lparg7, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BIJIJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3CIIJJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3CIIJJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jint arg3, jint arg4, jlong arg5, jlong arg6, jlongArray arg7)
{
	jchar *lparg2=NULL;
	jlong *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3CIIJJ_3J_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetLongArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jint, jint, jlong, jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, arg4, arg5, arg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseLongArrayElements(arg7, lparg7, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3CIIJJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJIIJJ_3I_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJIIJJ_3I_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jint arg4, jlong arg5, jlong arg6, jintArray arg7, jlongArray arg8)
{
	jint *lparg7=NULL;
	jlong *lparg8=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJIIJJ_3I_3J_FUNC);
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetLongArrayElements(arg8, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jint, jlong, jlong, jint *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, lparg7, lparg8);
fail:
	if (arg8 && lparg8) env->ReleaseLongArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJIIJJ_3I_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJIJ_3I_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJIJ_3I_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jint arg4, jlong arg5, jintArray arg6, jlongArray arg7)
{
	jint *lparg6=NULL;
	jlong *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJIJ_3I_3J_FUNC);
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetLongArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jint, jlong, jint *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, lparg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseLongArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJIJ_3I_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJI_3J_3J_3I_3J_3I_3J_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJI_3J_3J_3I_3J_3I_3J_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jint arg5, jlongArray arg6, jlongArray arg7, jintArray arg8, jlongArray arg9, jintArray arg10, jlongArray arg11, jintArray arg12, jintArray arg13)
{
	jlong *lparg6=NULL;
	jlong *lparg7=NULL;
	jint *lparg8=NULL;
	jlong *lparg9=NULL;
	jint *lparg10=NULL;
	jlong *lparg11=NULL;
	jint *lparg12=NULL;
	jint *lparg13=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJI_3J_3J_3I_3J_3I_3J_3I_3I_FUNC);
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetLongArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetIntArrayElements(arg8, NULL)) == NULL) goto fail;
	if (arg9) if ((lparg9 = env->GetLongArrayElements(arg9, NULL)) == NULL) goto fail;
	if (arg10) if ((lparg10 = env->GetIntArrayElements(arg10, NULL)) == NULL) goto fail;
	if (arg11) if ((lparg11 = env->GetLongArrayElements(arg11, NULL)) == NULL) goto fail;
	if (arg12) if ((lparg12 = env->GetIntArrayElements(arg12, NULL)) == NULL) goto fail;
	if (arg13) if ((lparg13 = env->GetIntArrayElements(arg13, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jint, jlong *, jlong *, jint *, jlong *, jint *, jlong *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, lparg6, lparg7, lparg8, lparg9, lparg10, lparg11, lparg12, lparg13);
fail:
	if (arg13 && lparg13) env->ReleaseIntArrayElements(arg13, lparg13, 0);
	if (arg12 && lparg12) env->ReleaseIntArrayElements(arg12, lparg12, 0);
	if (arg11 && lparg11) env->ReleaseLongArrayElements(arg11, lparg11, 0);
	if (arg10 && lparg10) env->ReleaseIntArrayElements(arg10, lparg10, 0);
	if (arg9 && lparg9) env->ReleaseLongArrayElements(arg9, lparg9, 0);
	if (arg8 && lparg8) env->ReleaseIntArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseLongArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJI_3J_3J_3I_3J_3I_3J_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJ_3I_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJ_3I_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jintArray arg4, jintArray arg5, jintArray arg6)
{
	jint *lparg4=NULL;
	jint *lparg5=NULL;
	jint *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJ_3I_3I_3I_FUNC);
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jint *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, lparg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJ_3I_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJIJJ_3I_3I_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJIJJ_3I_3I_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jlong arg3, jlong arg4, jintArray arg5, jintArray arg6, jintArray arg7, jintArray arg8)
{
	jint *lparg5=NULL;
	jint *lparg6=NULL;
	jint *lparg7=NULL;
	jint *lparg8=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJIJJ_3I_3I_3I_3I_FUNC);
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetIntArrayElements(arg8, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jlong, jlong, jint *, jint *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, lparg5, lparg6, lparg7, lparg8);
fail:
	if (arg8 && lparg8) env->ReleaseIntArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJIJJ_3I_3I_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJIJ_3I_3J_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJIJ_3I_3J_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3, jlong arg4, jintArray arg5, jlongArray arg6, jintArray arg7)
{
	jint *lparg5=NULL;
	jlong *lparg6=NULL;
	jint *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJIJ_3I_3J_3I_FUNC);
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint, jlong, jint *, jlong *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, lparg5, lparg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJIJ_3I_3J_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJ_3I_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJ_3I_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jintArray arg5, jintArray arg6, jintArray arg7)
{
	jint *lparg5=NULL;
	jint *lparg6=NULL;
	jint *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJ_3I_3I_3I_FUNC);
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jint *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, lparg5, lparg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJ_3I_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJJ_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJJ_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jlong arg5, jintArray arg6, jintArray arg7)
{
	jint *lparg6=NULL;
	jint *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJJ_3I_3I_FUNC);
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jlong, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, lparg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJJ_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJ_3I_3J_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJ_3I_3J_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jintArray arg5, jlongArray arg6, jintArray arg7)
{
	jint *lparg5=NULL;
	jlong *lparg6=NULL;
	jint *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJ_3I_3J_3I_FUNC);
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jint *, jlong *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, lparg5, lparg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJ_3I_3J_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJ_3B_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJ_3B_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jbyteArray arg4, jlongArray arg5)
{
	jbyte *lparg4=NULL;
	jlong *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJ_3B_3J_FUNC);
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetLongArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jbyte *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseLongArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJ_3B_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJ_3IJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJ_3IJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jintArray arg4, jlong arg5)
{
	jint *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJ_3IJ_FUNC);
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jint *, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, arg5);
fail:
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJ_3IJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJ_3I_3I_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJ_3I_3I_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jintArray arg5, jintArray arg6, jintArray arg7, jintArray arg8)
{
	jint *lparg5=NULL;
	jint *lparg6=NULL;
	jint *lparg7=NULL;
	jint *lparg8=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJ_3I_3I_3I_3I_FUNC);
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetIntArrayElements(arg8, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jint *, jint *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, lparg5, lparg6, lparg7, lparg8);
fail:
	if (arg8 && lparg8) env->ReleaseIntArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJ_3I_3I_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJ_3I_3I_3IJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJ_3I_3I_3IJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jintArray arg5, jintArray arg6, jintArray arg7, jlong arg8)
{
	jint *lparg5=NULL;
	jint *lparg6=NULL;
	jint *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJ_3I_3I_3IJ_FUNC);
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jint *, jint *, jint *, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, lparg5, lparg6, lparg7, arg8);
fail:
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJ_3I_3I_3IJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJIIIIDIJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJIIIIDIJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3, jint arg4, jint arg5, jdouble arg6, jint arg7, jlong arg8)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJIIIIDIJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jint, jint, jint, jdouble, jint, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJIIIIDIJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3I_3I_3I_3I_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3I_3I_3I_3I_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jintArray arg3, jintArray arg4, jintArray arg5, jintArray arg6, jintArray arg7, jintArray arg8)
{
	jint *lparg3=NULL;
	jint *lparg4=NULL;
	jint *lparg5=NULL;
	jint *lparg6=NULL;
	jint *lparg7=NULL;
	jint *lparg8=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3I_3I_3I_3I_3I_3I_FUNC);
	if (arg3) if ((lparg3 = env->GetIntArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetIntArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetIntArrayElements(arg8, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jint *, jint *, jint *, jint *, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, lparg4, lparg5, lparg6, lparg7, lparg8);
fail:
	if (arg8 && lparg8) env->ReleaseIntArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseIntArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	if (arg3 && lparg3) env->ReleaseIntArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3I_3I_3I_3I_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJIJ_3BI_3J_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJIJ_3BI_3J_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jlong arg3, jbyteArray arg4, jint arg5, jlongArray arg6, jintArray arg7)
{
	jbyte *lparg4=NULL;
	jlong *lparg6=NULL;
	jint *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJIJ_3BI_3J_3I_FUNC);
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetLongArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jlong, jbyte *, jint, jlong *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, arg5, lparg6, lparg7);
fail:
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	if (arg6 && lparg6) env->ReleaseLongArrayElements(arg6, lparg6, 0);
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJIJ_3BI_3J_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJ_3B
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJ_3B)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jbyteArray arg4)
{
	jbyte *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJ_3B_FUNC);
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jbyte *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJ_3B_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJ_3C_3CJI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJ_3C_3CJI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jcharArray arg4, jcharArray arg5, jlong arg6, jint arg7)
{
	jchar *lparg4=NULL;
	jchar *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJ_3C_3CJI_FUNC);
	if (arg4) if ((lparg4 = env->GetCharArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetCharArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jchar *, jchar *, jlong, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, lparg5, arg6, arg7);
fail:
	if (arg5 && lparg5) env->ReleaseCharArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseCharArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJ_3C_3CJI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJIIIJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJIIIJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jint arg4, jint arg5, jint arg6, jlong arg7, jlongArray arg8)
{
	jlong *lparg8=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJIIIJ_3J_FUNC);
	if (arg8) if ((lparg8 = env->GetLongArrayElements(arg8, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jint, jint, jint, jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, lparg8);
fail:
	if (arg8 && lparg8) env->ReleaseLongArrayElements(arg8, lparg8, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJIIIJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJ_3BJJJJII_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJ_3BJJJJII_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jbyteArray arg3, jlong arg4, jlong arg5, jlong arg6, jlong arg7, jint arg8, jint arg9, jlongArray arg10)
{
	jbyte *lparg3=NULL;
	jlong *lparg10=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJ_3BJJJJII_3J_FUNC);
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg10) if ((lparg10 = env->GetLongArrayElements(arg10, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jbyte *, jlong, jlong, jlong, jlong, jint, jint, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, lparg3, arg4, arg5, arg6, arg7, arg8, arg9, lparg10);
fail:
	if (arg10 && lparg10) env->ReleaseLongArrayElements(arg10, lparg10, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJ_3BJJJJII_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJIJJJJJJJJIJJJJI_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJIJJJJJJJJIJJJJI_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jlong arg3, jlong arg4, jlong arg5, jlong arg6, jlong arg7, jlong arg8, jlong arg9, jlong arg10, jint arg11, jlong arg12, jlong arg13, jlong arg14, jlong arg15, jint arg16, jlongArray arg17)
{
	jlong *lparg17=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJIJJJJJJJJIJJJJI_3J_FUNC);
	if (arg17) if ((lparg17 = env->GetLongArrayElements(arg17, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong, jint, jlong, jlong, jlong, jlong, jint, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, lparg17);
fail:
	if (arg17 && lparg17) env->ReleaseLongArrayElements(arg17, lparg17, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJIJJJJJJJJIJJJJI_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJIJJJJJJJJJJJJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJIJJJJJJJJJJJJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jlong arg3, jlong arg4, jlong arg5, jlong arg6, jlong arg7, jlong arg8, jlong arg9, jlong arg10, jlong arg11, jlong arg12, jlong arg13, jlong arg14, jlongArray arg15)
{
	jlong *lparg15=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJIJJJJJJJJJJJJ_3J_FUNC);
	if (arg15) if ((lparg15 = env->GetLongArrayElements(arg15, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, lparg15);
fail:
	if (arg15 && lparg15) env->ReleaseLongArrayElements(arg15, lparg15, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJIJJJJJJJJJJJJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJIJJJJJJJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJIJJJJJJJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jint arg4, jlong arg5, jlong arg6, jlong arg7, jlong arg8, jlong arg9, jlong arg10, jlong arg11, jlong arg12)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJIJJJJJJJJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jint, jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJIJJJJJJJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJIJJJJJJJI
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJIJJJJJJJI)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jint arg5, jlong arg6, jlong arg7, jlong arg8, jlong arg9, jlong arg10, jlong arg11, jlong arg12, jint arg13)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJIJJJJJJJI_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jint, jlong, jlong, jlong, jlong, jlong, jlong, jlong, jint))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJIJJJJJJJI_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJJJJJJJJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJJJJJJJJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jlong arg5, jlong arg6, jlong arg7, jlong arg8, jlong arg9, jlong arg10, jlong arg11, jlong arg12)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJJJJJJJJJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJJJJJJJJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJ_3I_3S_3S
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJ_3I_3S_3S)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jintArray arg4, jshortArray arg5, jshortArray arg6)
{
	jint *lparg4=NULL;
	jshort *lparg5=NULL;
	jshort *lparg6=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJ_3I_3S_3S_FUNC);
	if (arg4) if ((lparg4 = env->GetIntArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetShortArrayElements(arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = env->GetShortArrayElements(arg6, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jint *, jshort *, jshort *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, lparg5, lparg6);
fail:
	if (arg6 && lparg6) env->ReleaseShortArrayElements(arg6, lparg6, 0);
	if (arg5 && lparg5) env->ReleaseShortArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseIntArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJ_3I_3S_3S_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJIJIJ_3CIJIIJIJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJIJIJ_3CIJIIJIJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jlong arg3, jint arg4, jlong arg5, jcharArray arg6, jint arg7, jlong arg8, jint arg9, jint arg10, jlong arg11, jint arg12, jlong arg13, jlongArray arg14)
{
	jchar *lparg6=NULL;
	jlong *lparg14=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJIJIJ_3CIJIIJIJ_3J_FUNC);
	if (arg6) if ((lparg6 = env->GetCharArrayElements(arg6, NULL)) == NULL) goto fail;
	if (arg14) if ((lparg14 = env->GetLongArrayElements(arg14, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jlong, jint, jlong, jchar *, jint, jlong, jint, jint, jlong, jint, jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, lparg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, lparg14);
fail:
	if (arg14 && lparg14) env->ReleaseLongArrayElements(arg14, lparg14, 0);
	if (arg6 && lparg6) env->ReleaseCharArrayElements(arg6, lparg6, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJIJIJ_3CIJIIJIJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJIII_3B
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJIII_3B)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jint arg5, jint arg6, jint arg7, jbyteArray arg8)
{
	jbyte *lparg8=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJIII_3B_FUNC);
	if (arg8) if ((lparg8 = env->GetByteArrayElements(arg8, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jint, jint, jint, jbyte *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, lparg8);
fail:
	if (arg8 && lparg8) env->ReleaseByteArrayElements(arg8, lparg8, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJIII_3B_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJII_3I_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJII_3I_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jint arg5, jint arg6, jintArray arg7, jintArray arg8)
{
	jint *lparg7=NULL;
	jint *lparg8=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJII_3I_3I_FUNC);
	if (arg7) if ((lparg7 = env->GetIntArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetIntArrayElements(arg8, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jint, jint, jint *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, lparg7, lparg8);
fail:
	if (arg8 && lparg8) env->ReleaseIntArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseIntArrayElements(arg7, lparg7, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJII_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJJII_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJJII_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jlong arg5, jint arg6, jint arg7, jlongArray arg8)
{
	jlong *lparg8=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJJII_3J_FUNC);
	if (arg8) if ((lparg8 = env->GetLongArrayElements(arg8, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jlong, jint, jint, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, lparg8);
fail:
	if (arg8 && lparg8) env->ReleaseLongArrayElements(arg8, lparg8, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJJII_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJIJ_3BJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJIJ_3BJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jint arg5, jlong arg6, jbyteArray arg7, jlong arg8, jlong arg9)
{
	jbyte *lparg7=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJIJ_3BJJ_FUNC);
	if (arg7) if ((lparg7 = env->GetByteArrayElements(arg7, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jint, jlong, jbyte *, jlong, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, lparg7, arg8, arg9);
fail:
	if (arg7 && lparg7) env->ReleaseByteArrayElements(arg7, lparg7, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJIJ_3BJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJJJJJJJJJJ_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJJJJJJJJJJ_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jlong arg5, jlong arg6, jlong arg7, jlong arg8, jlong arg9, jlong arg10, jlong arg11, jlong arg12, jlongArray arg13)
{
	jlong *lparg13=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJJJJJJJJJJ_3J_FUNC);
	if (arg13) if ((lparg13 = env->GetLongArrayElements(arg13, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, lparg13);
fail:
	if (arg13 && lparg13) env->ReleaseLongArrayElements(arg13, lparg13, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJJJJJJJJJJ_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJIJI_3C_3BJJJIJIJJJ_3J_3J
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJIJI_3C_3BJJJIJIJJJ_3J_3J)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3, jint arg4, jlong arg5, jint arg6, jcharArray arg7, jbyteArray arg8, jlong arg9, jlong arg10, jlong arg11, jint arg12, jlong arg13, jint arg14, jlong arg15, jlong arg16, jlong arg17, jlongArray arg18, jlongArray arg19)
{
	jchar *lparg7=NULL;
	jbyte *lparg8=NULL;
	jlong *lparg18=NULL;
	jlong *lparg19=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJIJI_3C_3BJJJIJIJJJ_3J_3J_FUNC);
	if (arg7) if ((lparg7 = env->GetCharArrayElements(arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = env->GetByteArrayElements(arg8, NULL)) == NULL) goto fail;
	if (arg18) if ((lparg18 = env->GetLongArrayElements(arg18, NULL)) == NULL) goto fail;
	if (arg19) if ((lparg19 = env->GetLongArrayElements(arg19, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong, jint, jlong, jint, jchar *, jbyte *, jlong, jlong, jlong, jint, jlong, jint, jlong, jlong, jlong, jlong *, jlong *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, arg4, arg5, arg6, lparg7, lparg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, lparg18, lparg19);
fail:
	if (arg19 && lparg19) env->ReleaseLongArrayElements(arg19, lparg19, 0);
	if (arg18 && lparg18) env->ReleaseLongArrayElements(arg18, lparg18, 0);
	if (arg8 && lparg8) env->ReleaseByteArrayElements(arg8, lparg8, 0);
	if (arg7 && lparg7) env->ReleaseCharArrayElements(arg7, lparg7, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJIJI_3C_3BJJJIJIJJJ_3J_3J_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3IJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3IJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jintArray arg2, jlong arg3)
{
	jint *lparg2=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3IJ_FUNC);
	if (arg2) if ((lparg2 = env->GetIntArrayElements(arg2, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint *, jlong))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3);
fail:
	if (arg2 && lparg2) env->ReleaseIntArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3IJ_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJIJ_3J_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJIJ_3J_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jlong arg3, jlongArray arg4, jintArray arg5)
{
	jlong *lparg4=NULL;
	jint *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJIJ_3J_3I_FUNC);
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jint, jlong, jlong *, jint *))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJIJ_3J_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3CI_3J_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3CI_3J_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jcharArray arg2, jint arg3, jlongArray arg4, jintArray arg5)
{
	jchar *lparg2=NULL;
	jlong *lparg4=NULL;
	jint *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3CI_3J_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetCharArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetLongArrayElements(arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jchar *, jint, jlong *, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, lparg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg4 && lparg4) env->ReleaseLongArrayElements(arg4, lparg4, 0);
	if (arg2 && lparg2) env->ReleaseCharArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3CI_3J_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3BS_3B
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3BS_3B)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jshort arg3, jbyteArray arg4)
{
	jbyte *lparg2=NULL;
	jbyte *lparg4=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3BS_3B_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = env->GetByteArrayElements(arg4, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jshort, jbyte *))(*(jlong**)arg1)[arg0])(arg1, lparg2, arg3, lparg4);
fail:
	if (arg4 && lparg4) env->ReleaseByteArrayElements(arg4, lparg4, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3BS_3B_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJ_3B_3BI_3I
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJ_3B_3BI_3I)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jbyteArray arg2, jbyteArray arg3, jint arg4, jintArray arg5)
{
	jbyte *lparg2=NULL;
	jbyte *lparg3=NULL;
	jint *lparg5=NULL;
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJ_3B_3BI_3I_FUNC);
	if (arg2) if ((lparg2 = env->GetByteArrayElements(arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = env->GetByteArrayElements(arg3, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = env->GetIntArrayElements(arg5, NULL)) == NULL) goto fail;
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jbyte *, jbyte *, jint, jint *))(*(jlong**)arg1)[arg0])(arg1, lparg2, lparg3, arg4, lparg5);
fail:
	if (arg5 && lparg5) env->ReleaseIntArrayElements(arg5, lparg5, 0);
	if (arg3 && lparg3) env->ReleaseByteArrayElements(arg3, lparg3, 0);
	if (arg2 && lparg2) env->ReleaseByteArrayElements(arg2, lparg2, 0);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJ_3B_3BI_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_VtblCall__IJJJ
JNIEXPORT jint JNICALL XPCOM_NATIVE(VtblCall__IJJJ)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jlong arg3)
{
	jint rc = 0;
	XPCOM_NATIVE_ENTER(env, that, VtblCall__IJJJ_FUNC);
	rc = (jint)((jint (STDMETHODCALLTYPE *)(jlong, jlong, jlong))(*(jlong**)arg1)[arg0])(arg1, arg2, arg3);
	XPCOM_NATIVE_EXIT(env, that, VtblCall__IJJJ_FUNC);
	return rc;
}
#endif


//================ end of section generated from tool genJniStub

}