/*******************************************************************************
 * Copyright (c) 2010, 2015 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/

package com.ibm.rcp.ui.internal.presentations.dnd;

import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

import com.ibm.rcp.swt.swidgets.STabFolder;
import com.ibm.rcp.ui.internal.presentations.FolderStackPresentation;

/**
 *
 */
public class DPartDragAgent extends DDragAgent {
	public DPartDragAgent(DDnDManager manager) {
		super(manager);
	}

	@Override
	public MUIElement getElementToDrag(DDnDInfo info) {
		if (!(info.curElement instanceof MPartStack))
			return null;

		MPartStack stack = (MPartStack) info.curElement;

		// Drag a part that is in a stack
		if (info.itemElement instanceof MStackElement) {
			// Prevent dragging 'No Move' parts
			if (info.itemElement.getTags().contains(IPresentationEngine.NO_MOVE))
				return null;

			// If it's an MPart only drag the part itself
			if (info.itemElement instanceof MPart) {
				return info.itemElement;
			}

			// check if we want to drag the placeholder or default to dragging the whole stack
			int tbrCount = dndManager.getModelService().countRenderableChildren(stack);
			if (tbrCount > 1 || dndManager.getModelService().isLastEditorStack(stack)) {
				dragElement = info.itemElement;
				return info.itemElement;
			}
		}

		// Drag a complete stack
		// Only allow a drag to start if we're a CTabFolder
		if (!(stack.getWidget() instanceof Composite))
			return null;

		// Only allow a drag to start if we're inside the 'tab area' of the CTF
		STabFolder ctf = getTabFolder(stack);
		Point ctfPos = ctf.getDisplay().map(null, ctf, info.cursorPos);
		if (ctfPos.y > ctf.getTabHeight())
			return null;

		// Prevent dragging 'No Move' stacks
		if (stack.getTags().contains(IPresentationEngine.NO_MOVE))
			return null;

		// Prevent dragging the last stack out of the shared area
		if (dndManager.getModelService().isLastEditorStack(stack))
			return null;

		dragElement = info.curElement;
		return info.curElement;
	}

	private STabFolder getTabFolder(MPartStack stack) {
		FolderStackPresentation fsp = (FolderStackPresentation)stack.getTransientData().get("SP");
		return fsp.getTabFolder();
	}
	
	@Override
	public void dragStart(DDnDInfo info) {
		super.dragStart(info);
		if (dndManager.getFeedbackStyle() != DDnDManager.SIMPLE)
			dndManager.hostElement(dragElement, 16, 10);
	}

	@Override
	public void dragFinished(boolean performDrop, DDnDInfo info) {
		if (dragElement instanceof MPart) {
			EPartService ps = dndManager.getDragWindow().getContext().get(EPartService.class);
			ps.activate((MPart) dragElement);
		}
		super.dragFinished(performDrop, info);
	}
}
