/*
*	Copyright IBM Corporation 2003, 2005
*	All rights reserved.
*	US Government Users Restricted Rights - Use, duplication or disclosure
*	restricted by GS ADP Schedule Contract with IBM Corp.
*/
/*******************************************************************************
 * Copyright (c) 2000, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * 		IBM Corporation - initial API and implementation
 *******************************************************************************/

/* Note orignal code from  org.eclipse.ui.internal.progress.ErrorNotificationDialog */

package com.ibm.rcp.ui.internal.dialogs;
import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;


public class DebugModeErrorDialog extends Dialog {
	TableViewer errorViewer;
	Button clearButton;
	List detailsList;
	private Clipboard clipboard;
	private IStatus selectedError = null;

	/**
	 * Reserve room for this many details list items.
	 */
	private static final int DETAILS_LIST_ITEM_COUNT = 7;

	/**
	 * The nesting indent.
	 */
	private static final String NESTING_INDENT = "  "; //$NON-NLS-1$
	private IStatus[] errors;

	public DebugModeErrorDialog(Shell parentShell,IStatus status){
		this(parentShell, new IStatus[]{status});
	}
	public DebugModeErrorDialog(Shell parentShell,IStatus[] statuses){
		this(parentShell);
		this.errors = statuses;
	}
	
	/**
	 * Create a new instance of the receiver.
	 * 
	 * @param parentShell
	 */
	protected DebugModeErrorDialog(Shell parentShell) {
		super(parentShell);
		setBlockOnOpen(false);
		setShellStyle(SWT.CLOSE | SWT.MODELESS | SWT.BORDER | SWT.TITLE
				| SWT.RESIZE);
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.window.Window#configureShell(org.eclipse.swt.widgets.Shell)
	 */
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText("Debug Error Dialog"); //$NON-NLS-1$
		newShell.addDisposeListener(new DisposeListener() {
			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.swt.events.DisposeListener#widgetDisposed(org.eclipse.swt.events.DisposeEvent)
			 */
			public void widgetDisposed(DisposeEvent e) {
				//getManager().clearDialog();
			}
		});
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.window.Window#getShellStyle()
	 */
	protected int getShellStyle() {
		return super.getShellStyle() | SWT.MIN;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
	 */
	protected Control createDialogArea(Composite parent) {
		initializeDialogUnits(parent);
		Composite topArea = (Composite) super.createDialogArea(parent);
		errorViewer = new TableViewer(topArea, SWT.MULTI | SWT.H_SCROLL
				| SWT.V_SCROLL | SWT.BORDER);
		errorViewer.setSorter(getViewerSorter());
		errorViewer.getControl().addMouseListener(new MouseAdapter() {
			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.swt.events.MouseAdapter#mouseDoubleClick(org.eclipse.swt.events.MouseEvent)
			 */
			public void mouseDoubleClick(MouseEvent e) {
				openErrorDialog();
			}
		});
		errorViewer
				.addSelectionChangedListener(new ISelectionChangedListener() {
					public void selectionChanged(SelectionChangedEvent event) {

//						clearButton.setEnabled(!errorViewer.getSelection()
//								.isEmpty());
						setDetailsContents();
					}
				});
		Control control = errorViewer.getControl();
		GridData data = new GridData(GridData.FILL_BOTH
				| GridData.GRAB_HORIZONTAL | GridData.GRAB_VERTICAL);
		data.widthHint = convertWidthInCharsToPixels(60);
		data.heightHint = convertHeightInCharsToPixels(10);
		control.setLayoutData(data);
		initContentProvider();
		initLabelProvider();
		applyDialogFont(parent);

		createDetailsList(topArea);
		return topArea;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.dialogs.Dialog#createButtonsForButtonBar(org.eclipse.swt.widgets.Composite)
	 */
	protected void createButtonsForButtonBar(Composite parent) {
//		//TODO andrewd: remove clear Button.
//		clearButton = createButton(
//				parent,
//				IDialogConstants.CLIENT_ID + 2,
//				clearButtonTitle, false); //$NON-NLS-1$
//		clearButton.setEnabled(false);
//		clearButton.addSelectionListener(new SelectionAdapter() {
//			public void widgetSelected(SelectionEvent e) {
//				ISelection rawSelection = errorViewer.getSelection();
//				if (rawSelection != null
//						&& rawSelection instanceof IStructuredSelection) {
//					IStructuredSelection selection = (IStructuredSelection) rawSelection;
//					//getManager().removeErrors(selection.toList());
//				}
//				refresh();
//			}
//		});
		Button button = createButton(parent, IDialogConstants.CLOSE_ID,
				IDialogConstants.CLOSE_LABEL, true);
		button.addSelectionListener(new SelectionListener() {
			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			public void widgetSelected(SelectionEvent e) {
				close();
			}
			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			public void widgetDefaultSelected(SelectionEvent e) {
				close();
			}
		});
	}
	/**
	 * Return a viewer sorter for looking at the jobs.
	 * 
	 * @return
	 */
	private ViewerSorter getViewerSorter() {
		return new ViewerSorter() {
			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.jface.viewers.ViewerSorter#compare(org.eclipse.jface.viewers.Viewer,
			 *      java.lang.Object, java.lang.Object)
			 */
			public int compare(Viewer testViewer, Object e1, Object e2) {
				return ((Comparable) e1).compareTo(e2);
			}
		};
	}
	/**
	 * Sets the content provider for the viewer.
	 */
	protected void initContentProvider() {
		IContentProvider provider = new IStructuredContentProvider() {
			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
			 */
			public void dispose() {
				//Nothing of interest here
			}
			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
			 */
			public Object[] getElements(Object inputElement) {
				return getErrors();
			}
			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer,
			 *      java.lang.Object, java.lang.Object)
			 */
			public void inputChanged(Viewer viewer, Object oldInput,
					Object newInput) {
				if (newInput != null)
					refresh();
			}
		};
		errorViewer.setContentProvider(provider);
		errorViewer.setInput(getErrors());
	}
	
	private IStatus[] getErrors(){
		return this.errors;
	}
	
	/**
	 * Refresh the contents of the viewer.
	 */
	void refresh() {
		errorViewer.refresh();
	}
	private void initLabelProvider() {
		ITableLabelProvider provider = new ITableLabelProvider() {
			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.jface.viewers.IBaseLabelProvider#addListener(org.eclipse.jface.viewers.ILabelProviderListener)
			 */
			public void addListener(ILabelProviderListener listener) {
				//Do nothing
			}
			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
			 */
			public void dispose() {
				//Do nothing
			}
			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnImage(java.lang.Object,
			 *      int)
			 */
			public Image getColumnImage(Object element, int columnIndex) {
				return JFaceResources.getImageRegistry().get("ERROR_JOB");
			}
			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnText(java.lang.Object,
			 *      int)
			 */
			public String getColumnText(Object element, int columnIndex) {
				return ((IStatus) element).getMessage();
			}
			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.jface.viewers.IBaseLabelProvider#isLabelProperty(java.lang.Object,
			 *      java.lang.String)
			 */
			public boolean isLabelProperty(Object element, String property) {
				return false;
			}
			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.jface.viewers.IBaseLabelProvider#removeListener(org.eclipse.jface.viewers.ILabelProviderListener)
			 */
			public void removeListener(ILabelProviderListener listener) {
				//Do nothing
			}
		};
		errorViewer.setLabelProvider(provider);
	}
	/**
	 * Open the error dialog on the current selection.
	 */
	private void openErrorDialog() {
		IStatus element = getSingleSelection();
		if (element == null)
			return;
		ErrorDialog.openError(getShell(), element.getMessage(), null,
				element);
	}
	/**
	 * Get the single selection. Return null if the selection is not just one
	 * element.
	 * 
	 * @return ErrorInfo or <code>null</code>.
	 */
	private IStatus getSingleSelection() {
		ISelection rawSelection = errorViewer.getSelection();
		if (rawSelection != null
				&& rawSelection instanceof IStructuredSelection) {
			IStructuredSelection selection = (IStructuredSelection) rawSelection;
			if (selection.size() == 1)
				return (IStatus) selection.getFirstElement();
		}
		return null;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.dialogs.Dialog#close()
	 */
	public boolean close() {
		//getManager().clearAllErrors();
		boolean result = super.close();
		//ProgressManagerUtil.animateDown(shellPosition);
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.dialogs.Dialog#initializeBounds()
	 */
	protected void initializeBounds() {
		super.initializeBounds();
		//ProgressManagerUtil.animateUp(shellPosition);
	}

	/**
	 * Create this dialog's drop-down list component.
	 * 
	 * @param detailsParent
	 *            the parent composite
	 */
	private void createDetailsList(Composite detailsParent) {
		// create the list
		detailsList = new List(detailsParent, SWT.BORDER | SWT.H_SCROLL
				| SWT.V_SCROLL | SWT.MULTI);

		GridData data = new GridData(GridData.HORIZONTAL_ALIGN_FILL
				| GridData.GRAB_HORIZONTAL | GridData.VERTICAL_ALIGN_FILL
				| GridData.GRAB_VERTICAL);
		data.heightHint = detailsList.getItemHeight() * DETAILS_LIST_ITEM_COUNT;
		data.horizontalSpan = 2;
		detailsList.setLayoutData(data);
		Menu copyMenu = new Menu(detailsList);
		MenuItem copyItem = new MenuItem(copyMenu, SWT.NONE);
		copyItem.addSelectionListener(new SelectionListener() {
			/*
			 * @see SelectionListener.widgetSelected (SelectionEvent)
			 */
			public void widgetSelected(SelectionEvent e) {
				copyToClipboard();
			}
			/*
			 * @see SelectionListener.widgetDefaultSelected(SelectionEvent)
			 */
			public void widgetDefaultSelected(SelectionEvent e) {
				copyToClipboard();
			}
		});
		copyItem.setText(JFaceResources.getString("copy")); //$NON-NLS-1$
		detailsList.setMenu(copyMenu);
	}

	/**
	 * Set the contents of the details list to be the status from the selected
	 * error.
	 */
	private void setDetailsContents() {

		Collection statusList = new ArrayList();

		IStatus info = getSingleSelection();

		if (info != null) {
			selectedError = info;
			statusList.add(selectedError.getMessage());
			if (selectedError.getException() != null) {
				Throwable exception = selectedError.getException();
				statusList.add(exception.toString());
				StackTraceElement[] elements = exception.getStackTrace();
				for (int i = 0; i < elements.length; i++) {
					statusList.add(elements[i].toString());
				}
			}
			IStatus[] statuses = (selectedError.getChildren());
			for (int i = 0; i < statuses.length; i++) {
				statusList.add(NESTING_INDENT + statuses[i].getMessage());
			}
		}

		String[] items = new String[statusList.size()];
		statusList.toArray(items);

		detailsList.setItems(items);

	}

	/**
	 * Copy the contents of the statuses to the clipboard.
	 */
	private void copyToClipboard() {

		if (selectedError == null)
			return;

		if (clipboard != null)
			clipboard.dispose();

		StringBuffer statusBuffer = new StringBuffer();
		populateCopyBuffer(selectedError, statusBuffer, 0);
		clipboard = new Clipboard(detailsList.getDisplay());
		clipboard.setContents(new Object[]{statusBuffer.toString()},
				new Transfer[]{TextTransfer.getInstance()});
	}

	/**
	 * Put the details of the status of the error onto the stream.
	 * 
	 * @param buildingStatus
	 * @param buffer
	 * @param nesting
	 */
	private void populateCopyBuffer(IStatus buildingStatus,
			StringBuffer buffer, int nesting) {

		for (int i = 0; i < nesting; i++) {
			buffer.append(NESTING_INDENT); //$NON-NLS-1$
		}
		buffer.append(buildingStatus.getMessage());

		if (buildingStatus.getException() != null) {
			Throwable exception = buildingStatus.getException();
			buffer.append("\n"); //$NON-NLS-1$
			buffer.append(exception.toString());
			StackTraceElement[] elements = exception.getStackTrace();
			for (int i = 0; i < elements.length; i++) {
				buffer.append("\n"); //$NON-NLS-1$
				buffer.append(elements[i].toString());

			}
		}

		buffer.append("\n"); //$NON-NLS-1$
		IStatus[] children = buildingStatus.getChildren();
		for (int i = 0; i < children.length; i++) {
			populateCopyBuffer(children[i], buffer, nesting + 1);
		}
	}
}
