/*******************************************************************************
 * Copyright (c) 2000, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.browser;

import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

/**
 * 
 * This class is added for SPR NPEI7T64TS(Remove or seperate the Eclipse derivative work from WebControlSite.java)
 *
 */
public class TranslateAcceleratorHelper {
	
	WebControlSite site;
	OleFrame frame;
	boolean enabledJava2Applet;


	
	/**
	 * rebased from IES3.4RC2(3446) website.TranslateAccelerator
	 * @param lpMsg
	 * @param pguidCmdGroup
	 * @param nCmdID
	 * @return
	 */
	int TranslateAccelerator2(int /*long*/ lpMsg, int /*long*/ pguidCmdGroup, int nCmdID) {
		
		/*
		* Feature on Internet Explorer.  By default the embedded Internet Explorer control runs
		* the Internet Explorer shortcuts (e.g. Ctrl+F for Find).  This overrides the shortcuts
		* defined by SWT.  The workaround is to forward the accelerator keys to the parent window
		* and have Internet Explorer ignore the ones handled by the parent window.
		*/
		Menu menubar = site.getShell().getMenuBar();
		if (menubar != null && !menubar.isDisposed() && menubar.isEnabled()) {
			Shell shell = menubar.getShell();
			int /*long*/ hwnd = shell.handle;
			int /*long*/ hAccel = OS.SendMessage(hwnd, OS.WM_APP+1, 0, 0);
			if (hAccel != 0) {
				MSG msg = new MSG();
				OS.MoveMemory(msg, lpMsg, MSG.sizeof);
				if (OS.TranslateAccelerator(hwnd, hAccel, msg) != 0) return COM.S_OK;
			}
		}
		/*
		* By default the IE shortcuts are run.  However, F5 causes a refresh, which is not
		* appropriate when rendering HTML from memory, and CTRL-N opens a standalone IE,
		* which is undesirable and can cause a crash in some contexts.  The workaround is
		* to block IE from handling these shortcuts by answering COM.S_OK.
		*/
		int result = COM.S_FALSE;
		MSG msg = new MSG();
		OS.MoveMemory(msg, lpMsg, MSG.sizeof);
		if (msg.message == OS.WM_KEYDOWN) {
			switch ((int)/*64*/msg.wParam) {
				case OS.VK_F5:
					OleAutomation auto = new OleAutomation(site);
					int[] rgdispid = auto.getIDsOfNames(new String[] { "LocationURL" }); //$NON-NLS-1$
					Variant pVarResult = auto.getProperty(rgdispid[0]);
					auto.dispose();
					if (pVarResult != null) {
						if (pVarResult.getType() == OLE.VT_BSTR) {
							String url = pVarResult.getString();
							if (url.equals(IE.ABOUT_BLANK)) result = COM.S_OK;
						}
						pVarResult.dispose();
					}
					break;
				case OS.VK_UP:
				case OS.VK_DOWN:
				case OS.VK_LEFT:
				case OS.VK_RIGHT:
				case OS.VK_HOME:
				case OS.VK_END:
				case OS.VK_PRIOR:
				case OS.VK_NEXT:
					/* Do not translate/consume IE's keys for scrolling content. */
					break;
				case OS.VK_TAB:
					/* 
					 * Do not interfere with tab traversal since it's not known
					 * if it will be within IE or out to another Control.
					 */
					break;
				case OS.VK_RETURN:
					/*
					* Translating OS.VK_RETURN results in the native control handling it
					* twice (eg.- inserting two lines instead of one).  So this key is not
					* translated here, and instead is explicitly handled in the keypress
					* handler.
					*/
					break;
				case OS.VK_N:
					if (OS.GetKeyState (OS.VK_CONTROL) < 0 && OS.GetKeyState (OS.VK_MENU) >= 0 && OS.GetKeyState (OS.VK_SHIFT) >= 0) {
						frame.setData(site.CONSUME_KEY, "false"); //$NON-NLS-1$
						result = COM.S_OK;
						break;
					}
				case OS.VK_DELETE:
					/*
					 * For SPR# UKUR83VDFC and BMHL84KE5EU. For MIME mail, Notes will handle 
					 * delete keydown event to delete opened MIME mail. So we can not call
					 * frame.setData(site.CONSUME_KEY, "true"); to consume this key. 
					 */
					break;
					// FALL THROUGH
				default:
					if(!enabledJava2Applet){
						OS.TranslateMessage(msg);
						frame.setData(site.CONSUME_KEY, "true"); //$NON-NLS-1$						
					}					
					break;
			}
		}

		switch (msg.message) {
			case OS.WM_KEYDOWN:
			case OS.WM_KEYUP: {
				if (!OS.IsWinCE) {
					boolean isAccent = false;
					switch ((int)/*64*/msg.wParam) {
						case OS.VK_SHIFT:
						case OS.VK_MENU:
						case OS.VK_CONTROL:
						case OS.VK_CAPITAL:
						case OS.VK_NUMLOCK:
						case OS.VK_SCROLL:
							break;
						default: {
							/*
							* Bug in Windows. The high bit in the result of MapVirtualKey() on
							* Windows NT is bit 32 while the high bit on Windows 95 is bit 16.
							* They should both be bit 32.  The fix is to test the right bit.
							*/
							int mapKey = OS.MapVirtualKey ((int)/*64*/msg.wParam, 2);
							if (mapKey != 0) {
								isAccent = (mapKey & (OS.IsWinNT ? 0x80000000 : 0x8000)) != 0;
								if (!isAccent) {
									for (int i=0; i<site.ACCENTS.length; i++) {
										int value = OS.VkKeyScan (site.ACCENTS [i]);
										if (value != -1 && (value & 0xFF) == msg.wParam) {
											int state = value >> 8;
											if ((OS.GetKeyState (OS.VK_SHIFT) < 0) == ((state & 0x1) != 0) &&
												(OS.GetKeyState (OS.VK_CONTROL) < 0) == ((state & 0x2) != 0) &&
												(OS.GetKeyState (OS.VK_MENU) < 0) == ((state & 0x4) != 0)) {
													if ((state & 0x7) != 0) isAccent = true;
													break;
											}
										}
									}
								}
							}
							break;
						}
					};
					if (isAccent) result = COM.S_OK;
				}
			}
		}
		
		return result;
	}

	public TranslateAcceleratorHelper(WebControlSite site,OleFrame frame, boolean enabledJava2Applet) {
		this.site = site;
		this.frame = frame;
		this.enabledJava2Applet = enabledJava2Applet;
	}
	
}
