/*******************************************************************************
 * Copyright (c) 2003, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.swt.browser;

import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.ie.IEWebHistory;
import org.eclipse.swt.browser.ie.dom.html.JHTMLDocument;
import org.eclipse.swt.browser.ie.dom.html.JHTMLElement;
import org.eclipse.swt.browser.ie.dom.html.JHTMLElementFactory;
import org.eclipse.swt.browser.ie.dom.html.JHTMLFrameElement;
import org.eclipse.swt.browser.ie.dom.html.JHTMLIFrameElement;
import org.eclipse.swt.browser.ie.dom.html.JHTMLSelection;
import org.eclipse.swt.browser.ie.dom.html.JHTMLTxtRange;
import org.eclipse.swt.browser.ie.dom.html.JHTMLWindow;
import org.eclipse.swt.browser.ie.dom.html.JNavigator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMex;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.internal.ole.win32.IMessageFilter;
import org.eclipse.swt.internal.ole.win32.IOleCommandTarget;
import org.eclipse.swt.internal.ole.win32.IPersistStreamInit;
import org.eclipse.swt.internal.ole.win32.IServiceProvider;
import org.eclipse.swt.internal.ole.win32.ITravelLogEntry;
import org.eclipse.swt.internal.ole.win32.ITravelLogStg;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.ole.win32.OLECMD;
import org.eclipse.swt.internal.ole.win32.VARIANT2;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;

import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.ole.win32.Variant2;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.DisplayDispatcher;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.osgi.framework.Bundle;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.html.HTMLDocument;
import org.w3c.dom.html.HTMLElement;


import com.ibm.rcp.dombrowser.sso.BrowserProxySSOEntry;
import com.ibm.rcp.dombrowser.sso.BrowserSSOEntry;
import com.ibm.rcp.dombrowser.sso.BrowserSSOManager;
import com.ibm.rcp.dombrowser.sso.BrowserSSOUtil;

public class DOMBrowser extends Browser 
{
    private static final String  _packageName = DOMBrowser.class.getPackage().getName();
    private static final String _clazzName = DOMBrowser.class.getName();
    private static final String BUNDLE_NAME = "com.ibm.rcp.swt.browser.dom.ie"; //$NON-NLS-1$
    private static final String PREFERENCE_ENABLE_NATIVE_EXCEPTION_DUMP = "enableExceptionDump"; //$NON-NLS-1$
    private static final String PREFERENCE_NATIVE_EXCEPTION_DUMP_LOCATION = "exceptionDumpLocation"; //$NON-NLS-1$
    private static boolean bInitializedDUMPInfo = false;
    private boolean bInDisposing=false;    
	private IWebHistory webHistory;
	//Message Filter at IEOOP mode, resolve the Message rejecting
	private WeakReferenceManager weakReferenceManager;
//	private static final String IEOOPCLSID_INI						="IEOOP.cfg";
	private static final String IEOOPEXE							="IEOOP.exe";
	private static final String TLOGPSDLL							="tlogpsdll.dll";
	private static final String ABOUT_BLANK							="about:blank";
	//file protocol format: "file:///d:/abc/123.txt"
	static final String PROTOCOL_FILE = "file:///"; //$NON-NLS-1$
	//private static String IEOOPClsID;
	//private static  boolean bIEOOPRegistered=false;
	//private static boolean bTravelLogRegistered=false;

	protected static IMessageFilter messageFilter;
	//IEOOP control flag
	public static final int IEOOP_MODE							   = 0x03030000;
	
	/**
	 * Style constant for IE mode or IEOOP mode to support Browser Helper Object(BHO) on Windows platform.
	 */
	public static final int BHO_SUPPORT							   = 0x00800000;
	
	//MAX_CIRCLE_COUNT for get ole object
	private static final int MAX_CIRCLE_COUNT					   = 99;
	
	//ERR_CODE for Call was rejected by callee
	private static final int ERR_CODE      						   = -2147418111;
	
	// ambient control flags	
	public static final int DLCTL_NO_BEHAVIORS                     = 0x00008000;
	public static final int DLCTL_NO_METACHARSET                   = 0x00010000;
	public static final int DLCTL_URL_ENCODING_DISABLE_UTF8        = 0x00020000;
	public static final int DLCTL_URL_ENCODING_ENABLE_UTF8         = 0x00040000;
	public static final int DLCTL_OFFLINEIFNOTCONNECTED            = 0x80000000;
	public static final int DLCTL_OFFLINE                          = DLCTL_OFFLINEIFNOTCONNECTED;
	public static final int INET_E_RESOURCE_NOT_FOUND = 0x800C0005;
	
	// Constants for Web Browser ReadyState
	public static final int READYSTATE_UNINITIALIZED = 0;
	public static final int READYSTATE_LOADING = 1;
	public static final int READYSTATE_LOADED = 2;
	public static final int READYSTATE_INTERACTIVE = 3;
	public static final int READYSTATE_COMPLETE = 4;
	
	// Web Browser properties
	public static final int DISPID_READYSTATE = -525;
    
	// Web Browser Control Events 
	public static final int DISPID_BEFORENAVIGATE     = 100;   // this is sent before navigation to give a chance to abort
	public static final int DISPID_NAVIGATECOMPLETE   = 101;   // in async, this is sent when we have enough to show
	public static final int DISPID_STATUSTEXTCHANGE   = 102;
	public static final int DISPID_QUIT               = 103;
	public static final int DISPID_DOWNLOADCOMPLETE   = 104;
	public static final int DISPID_COMMANDSTATECHANGE = 105;
	public static final int DISPID_DOWNLOADBEGIN      = 106;
	public static final int DISPID_NEWWINDOW          = 107;   // sent when a new window should be created
	public static final int DISPID_PROGRESSCHANGE     = 108;   // sent when download progress is updated
	public static final int DISPID_WINDOWMOVE         = 109;   // sent when main window has been moved
	public static final int DISPID_WINDOWRESIZE       = 110;   // sent when main window has been sized
	public static final int DISPID_WINDOWACTIVATE     = 111;   // sent when main window has been activated
	public static final int DISPID_PROPERTYCHANGE     = 112;   // sent when the PutProperty method is called
	public static final int DISPID_TITLECHANGE        = 113;   // sent when the document title changes
	public static final int DISPID_TITLEICONCHANGE    = 114;   // sent when the top level window icon may have changed.

	public static final int DISPID_FRAMEBEFORENAVIGATE    = 200;
	public static final int DISPID_FRAMENAVIGATECOMPLETE  = 201;
	public static final int DISPID_FRAMENEWWINDOW         = 204;

	public static final int DISPID_BEFORENAVIGATE2      = 250;   // hyperlink clicked on
	public static final int DISPID_NEWWINDOW2           = 251;
	public static final int DISPID_NAVIGATECOMPLETE2    = 252;   // UIActivate new document
	public static final int DISPID_ONQUIT               = 253;
	public static final int DISPID_ONVISIBLE            = 254;   // sent when the window goes visible/hidden
	public static final int DISPID_ONTOOLBAR            = 255;   // sent when the toolbar should be shown/hidden
	public static final int DISPID_ONMENUBAR            = 256;   // sent when the menubar should be shown/hidden
	public static final int DISPID_ONSTATUSBAR          = 257;   // sent when the statusbar should be shown/hidden
	public static final int DISPID_ONFULLSCREEN         = 258;   // sent when kiosk mode should be on/off
	public static final int DISPID_DOCUMENTCOMPLETE     = 259;   // new document goes ReadyState_Complete
	public static final int DISPID_ONTHEATERMODE        = 260;   // sent when theater mode should be on/off
	public static final int DISPID_ONADDRESSBAR         = 261;   // sent when the address bar should be shown/hidden
	public static final int DISPID_WINDOWSETRESIZABLE   = 262;   // sent to set the style of the host window frame
	public static final int DISPID_WINDOWCLOSING        = 263;   // sent before script window.close closes the window 
	public static final int DISPID_WINDOWSETLEFT        = 264;   // sent when the put_left method is called on the WebOC
	public static final int DISPID_WINDOWSETTOP         = 265;   // sent when the put_top method is called on the WebOC
	public static final int DISPID_WINDOWSETWIDTH       = 266;   // sent when the put_width method is called on the WebOC
	public static final int DISPID_WINDOWSETHEIGHT      = 267;   // sent when the put_height method is called on the WebOC 
	public static final int DISPID_CLIENTTOHOSTWINDOW   = 268;   // sent during window.open to request conversion of dimensions
	public static final int DISPID_SETSECURELOCKICON    = 269;   // sent to suggest the appropriate security icon to show
	public static final int DISPID_FILEDOWNLOAD         = 270;   // Fired to indicate the File Download dialog is opening
	public static final int DISPID_NAVIGATEERROR        = 271;   // Fired to indicate the a binding error has occured
	public static final int DISPID_PRIVACYIMPACTEDSTATECHANGE   = 272;  // Fired when the user's browsing experience is impacted
	
	protected SecuritySettings securitySettings = new SecuritySettings();
	
	public static final String SHOW_SCRIPT_ERROR_TEXT_ID = "$$SHOWSCRIPTERRORS$$";

	
	//private static boolean killProcessRegistered = false;
			
	DocumentCompleteListener[] documentCompleteListeners = new DocumentCompleteListener[0];
	private boolean 			enabledJava2Applet;

	private static boolean      enabledLegacyMultiProcess=false;
	private int IEOOPProcessGroupID = 0;
	private static String[] IEOOPClsID = new String[1];
	private static  boolean[] bIEOOPRegistered= new boolean[1];
	private static String[] strSessionIDs = new String[1];
	private static boolean bTravelLogRegistered=false;
	private static final String IEOOP_Single_Process = "SingleProcess"; //$NON-NLS-1$
	private static final int MAX_Multi_IEOOP_Instance_Count = 100; //The MAX count of coexist IEOOP multi-process instances

	private static boolean      enabledSwitchLanguageWorkaround=false;
	private static boolean 		processIeoopIniFileDone=false;

	private boolean bIsDoneFocusInDoverb=false;
	
	int IEOOP_hwnd=0;
    static final String PROPERTY_NOMOREHANDLE = "org.eclipse.swt.browser.NoMoreHandle";

	//Used to store the multi-IEOOP process hwnd, to terminate the IEOOP multi-process 
	static HashMap<Integer, Integer> IEOOP_hwnd_Map = new HashMap<Integer, Integer>();
	static int[] IEOOP_hwnd_Array=new int[0];

	//Support File Download
	FileDownloadListener fileDownloadListener = null;
	FileDownloadListener[] fileDownloadListeners = new FileDownloadListener[0];
	
    /** IE ITravelLogEntry index */
	private ITravelLogEntry tlEntry;
	
	private SystemProxyHelper systemProxyHelper;
	private BrowserProxyInfo sysProxyInfo;
	static private boolean hasBrowserOwnProxy=false;
	private boolean 	bRet=false;
	private String		lastReadyState;
	boolean 	isInSetText=false;
	/*
	 Used to record if the main frame is in refresh state. If isTopNavigate is false,
	 then current page is in refresh state, otherwise, the page is in common state.
	 */
	boolean 	isTopNavigate=false;  
	
	String uncRedirect;
	
	private OleListener listener;
	
	//Accounts integration
	/**
	 * state for Client Single Sign On is supported
	 */
	private static boolean bSSOSupported=false;
	
	/**
	 *State for SSO initialized, and caches 
	 */
	private static boolean bSSOInitialized=false;
	
	/**
	 * State for BHO is supported
	 */
	boolean bBHOSupported=false;
	private static boolean bBHOSupportedPref=false;
	
	/**
	 * State for Client Single Sign On is enabled for browser instance
	 */
	private boolean bSSOEnabled = true; 
	public boolean isSSOEnabled() {
		return bSSOEnabled;
	}
	public void enableSSO(boolean enable) {
		bSSOEnabled = enable;
	}
	static {
		IPreferencesService pref = Platform.getPreferencesService();
		if(pref!=null){
			bBHOSupportedPref = pref.getBoolean("com.ibm.rcp.browser.service", "enableBHOSupport", false, null);
		}
	}
	/**
	 *Count for browser instance
	 */	
	private static int nIEOOPBrowserCount = 0;
	private static int nIEModeBrowserCount = 0;
	private static HashMap<Integer, Integer> IEOOPBrowserCountMap = new HashMap<Integer, Integer>();
	
	private synchronized static void increaseIEOOPBrowserCount(int processGroupID){
		if(processGroupID < 0) return;
		if(IEOOPBrowserCountMap.containsKey(processGroupID)){
			int count = IEOOPBrowserCountMap.get(processGroupID);
			// increase the count num
			count++;
			IEOOPBrowserCountMap.put(processGroupID, count);
		}else{
			IEOOPBrowserCountMap.put(processGroupID, 1);
		}
	}
	
	private synchronized static void decreaseIEOOPBrowserCount(int processGroupID){
		if(processGroupID < 0) return;
		if(IEOOPBrowserCountMap.containsKey(processGroupID)){
			int count = IEOOPBrowserCountMap.get(processGroupID);
			// decrease the count num
			if(count>0){
				count--;
				if(count==0){
					IEOOPBrowserCountMap.remove(processGroupID);
				}else{
					IEOOPBrowserCountMap.put(processGroupID, count); 
				}
			}
		}
	}

	private static boolean isIEOOPEmulationVersionInitialized;
	
	/**
	 * xpd62, hold reference for JHTMLElementFactory
	 */
	private JHTMLElementFactory elementFactory=null;	

	private boolean SSOCancel=false;
	public boolean isSSOCancel() {
		return SSOCancel;
	}
	public void setSSOCancel(boolean cancelable) {
		SSOCancel = cancelable;
	}	
	private WebSite getSite(){
		return (getIE()).site;
	}
	
	private OleFrame getFrame(){
		return (getIE()).frame;
	}
	

	private void setSite(WebSite site){
		(getIE()).site = site;
	}
	public IE getIE() {
		return (IE)webBrowser;
	}
	private void setAuto(OleAutomation auto){
		(getIE()).auto = auto;
	}
	
	//send SSO Status text event to status bar.
	public void updateSSOStatus(String statusString) {
		try{
			StatusTextEvent newEvent = new StatusTextEvent(DOMBrowser.this);
			newEvent.display = Display.getDefault();
			newEvent.widget = DOMBrowser.this;
			newEvent.text = statusString;
			for (int i = 0; i < getIE().statusTextListeners.length; i++){
				getIE().statusTextListeners[i].changed(newEvent);
			}
		}catch(Exception e){
			Logging.logp(Level.WARNING,_packageName, _clazzName, "DOMBrowser::updateSSOStatus()", "", e); //$NON-NLS-1$
		}
	}
		
	private void removeListeners(){
		documentCompleteListeners = new DocumentCompleteListener[0];
		getIE().locationListeners = new LocationListener[0];
		getIE().progressListeners = new ProgressListener[0];
		getIE().statusTextListeners = new StatusTextListener[0];
		getIE().titleListeners = new TitleListener[0];
		getIE().visibilityWindowListeners = new VisibilityWindowListener[0];
	}	

    /**
     * This constructor is really overwriting what the super(parent,style) constructor creates.  
     * 
     * Before creating the new components that will take the place holders of the parent's variables
     * we have to dispose of the native components, otherwise they will be leaked.  
     * 
     * The super constructor creates objects for the variables:
     *	1. site
     *	2. auto
     * 
     * Both have to be disposed of before being able to give them new references pointing to newly
     * created objects.  
     */
    public DOMBrowser(Composite parent, int style) {
    	this(parent, style, IEOOP_Single_Process);
    }
    
    /*
     * Return the process group id for current browser
     * For single process mode and unlimited process mode, this will always return 0 
     */
    public String getIEOOPSessionID(){
    	if(enabledLegacyMultiProcess){
    		return IEOOP_Single_Process; 
    	}
    	int len = strSessionIDs.length;
    	if(this.IEOOPProcessGroupID < len){
    		if(this.IEOOPProcessGroupID ==0 && strSessionIDs[this.IEOOPProcessGroupID] == null){
    			return IEOOP_Single_Process;
    		}else return strSessionIDs[this.IEOOPProcessGroupID];
    	}
    	return IEOOP_Single_Process;
    }
    private synchronized int getISessionID(String strSessionID){
    	if(enabledLegacyMultiProcess || strSessionID == null || strSessionID.trim().length() == 0 
    			|| strSessionID.trim().equalsIgnoreCase(IEOOP_Single_Process)){
    		strSessionIDs[0] = IEOOP_Single_Process;
    		return 0; // this should be legacy multi process mode, always return 0;
    	}
    	int len = strSessionIDs.length;
    	for(int i=0; i<len; i++){
    		if(strSessionIDs[i]!= null && strSessionIDs[i].equalsIgnoreCase(strSessionID)){
    			return i;
    		}
    	}
    	// reach the max count 
    	if(len >= MAX_Multi_IEOOP_Instance_Count){
    		// find the null position, and set the new session ID there
    		int j = 0;
    		for(j=1; j<len; j++){
        		if(strSessionIDs[j]== null){
        			strSessionIDs[j] = strSessionID;
        			return j;
        		}
        	}
    		if(j >= MAX_Multi_IEOOP_Instance_Count){
    			Logging.logp(Level.WARNING,_packageName, _clazzName, "getISessionID", "IEOOP multi process instacne count exceeds the Max count, switch to single process."); //$NON-NLS-1$
    			return 0;
    		}
    	}
    	// add new strSessionID into array
		String[] newStrSessionIDs = new String[strSessionIDs.length + 1];
		System.arraycopy(strSessionIDs, 0, newStrSessionIDs, 0, strSessionIDs.length);
		strSessionIDs = newStrSessionIDs;
		strSessionIDs[strSessionIDs.length - 1] = strSessionID;
		
		// extend the IEOOPClsID array
		String[] newIEOOPClsID = new String[IEOOPClsID.length + 1];
		System.arraycopy(IEOOPClsID, 0, newIEOOPClsID, 0, IEOOPClsID.length);
		IEOOPClsID = newIEOOPClsID;
		// extend the bIEOOPRegistered array
		boolean[] newbIEOOPRegistered = new boolean[bIEOOPRegistered.length + 1];
		System.arraycopy(bIEOOPRegistered, 0, newbIEOOPRegistered, 0, bIEOOPRegistered.length);
		bIEOOPRegistered = newbIEOOPRegistered;
		
		return strSessionIDs.length-1;
    }
    
    void addIEOOPProcessHandleID(int hwnd){
		IEOOP_hwnd_Map.put(IEOOPProcessGroupID, hwnd);
    }
    
    public DOMBrowser(Composite parent, int style, String processGroupID) {
		super(parent, (style&~IEOOP_MODE)&~BHO_SUPPORT);
    	Logging.logp(Level.FINEST, _packageName, _clazzName, "DOMBrowser Constructor", "Create a IE based browser!");  //$NON-NLS-1$  //$NON-NLS-2$
    	this.weakReferenceManager =  WeakReferenceManager.getWeakReferenceManager();
    	// This site has to be disposed before we create a new site since the object 
    	// with this reference is created in the Browser's super constructor
    	// We have to dispose this now or memory leaks will occurr.
    	if (getAutomation() != null){
    		getAutomation().dispose();
    	}
    	if((style & IEOOP_MODE) == IEOOP_MODE){
    		changeIEOOPEmulationVersion();
    	}
    	getSite().doVerb(0);
    	getSite().dispose(); 	
    	
    	//calling to process ieoop.ini file if not processed
    	if((style & IEOOP_MODE) ==IEOOP_MODE){
    		if(!processIeoopIniFileDone){
    			processIeoopIniFile();
        		WebControlSite.enabledLegacyMultiProcess = enabledLegacyMultiProcess;
    		}
    		this.IEOOPProcessGroupID = getISessionID(processGroupID);
    	}
    	
    	if((style & BHO_SUPPORT) ==BHO_SUPPORT){
    		bBHOSupported = true;
    	}else{
    		bBHOSupported = bBHOSupportedPref;
    	}
   	
       	try {
    		setSite( constructWebSite(getFrame(), style, this.IEOOPProcessGroupID) );
    	} catch (SWTException e) {
    		Logging.logp(Level.WARNING,_packageName, _clazzName, "DOMBrowser::DOMBrowser()", "SWTException in DOMBrowser", e); //$NON-NLS-1$
    		dispose();
    		SWT.error(SWT.ERROR_NO_HANDLES);
    	}    	
    	
    	// from Browser constructor start ////
    	
    	// Here we have to dispose of the OleAutomation site that is being created in the Browser's super constructor
    	// By disposing of this, 3 handles are cleaned up from being leaked from COMObjects
    	
    	getSite().doVerb(OLE.OLEIVERB_INPLACEACTIVATE);
    	setAuto( new OleAutomation(getSite()));

		// This cleans up the last instance of the OleAutomation that replaces the reference auto points to after the super constructor is called.
      	Listener swtlistener = new Listener() {
    		public void handleEvent(Event e) {
    			switch (e.type) {
	       			case SWT.Dispose: {
						removeListeners();
						removeOleListeners();
//						WebControlSite siteex = (WebControlSite)(DOMBrowser.this.getSite());
//						if (siteex != null)
//							siteex.rollbackIEOOPMsgHook();
						WebControlSite siteex = (WebControlSite)(DOMBrowser.this.getSite());
						
						if (siteex != null){
							siteex.DeleteHandleMapItem();
						}
	
						if (getAutomation() != null) {
							
							isClosing = true; //avoid invoking onbeforeunload trigger in IE.java
							
							if(getSite()!= null){
								getSite().ignoreAllMessages = true;
							}
							/*
							 * Fix spr: VROI7PFH4N - Need navigate to about:blank for both IE and IEOOP mode
							 * Fix spr: JJON7YSN8L - But if browser is in RTE edit mode, we can not navigate
							 */
							boolean bNavigate2Blank=false;
							if (enabledJava2Applet==true)
								bNavigate2Blank=true;
							else{
								try {
									JHTMLDocument jdoc=(JHTMLDocument)getDocument();
									bNavigate2Blank=!"on".equalsIgnoreCase(jdoc.getDesignMode());
								} catch (Exception e1) {
									Logging.logp(Level.FINEST,_packageName, _clazzName, "DOMBrowser::handleEvent()", "Exception in DOMBrowser", e1); //$NON-NLS-1$
								}
							}
							
							if(bNavigate2Blank){
								int loopTime = 0;
								bInDisposing = true;
								long startTime;
								long currentTime;
								long lastTime;
								long maxTime;
								try {
									int[] rgdispid = getAutomation().getIDsOfNames(
											new String[] { "Navigate", "URL" }); //$NON-NLS-1$ //$NON-NLS-2$
									//put some time checking
					    			//In some cases of IEOOP mode, the auto doesn't return the disID correctly due to busy
					    			//do a loop until it returns
					    			int loopCount = MAX_CIRCLE_COUNT;
					    			while((rgdispid == null)&&(loopCount>0)){
					    				rgdispid = getAutomation().getIDsOfNames(new String[] { "Navigate", "URL" });//$NON-NLS-1$ //$NON-NLS-2$
					    				--loopCount;    				
					    			}									
									Variant[] rgvarg = new Variant[1];
									rgvarg[0] = new Variant(ABOUT_BLANK);
									int[] rgdispidNamedArgs = new int[1];
									rgdispidNamedArgs[0] = rgdispid[1];
									Variant pVarResult = getAutomation().invoke(
											rgdispid[0], rgvarg, rgdispidNamedArgs);
									rgvarg[0].dispose();
									if (pVarResult != null){
										pVarResult.dispose();
									}
									rgdispid = getAutomation().getIDsOfNames(
											new String[] { "ReadyState" }); //$NON-NLS-1$
									//put some time checking
					    			//In some cases of IEOOP mode, the auto doesn't return the disID correctly due to busy
					    			//do a loop until it returns
					    			while((rgdispid == null)&&(loopCount>0)){
					    				rgdispid = getAutomation().getIDsOfNames(new String[] { "ReadyState" });//$NON-NLS-1$
					    				--loopCount;    				
					    			}
									startTime = System.currentTimeMillis();
									lastTime = startTime - 100;
									while (true) {
										if (DOMBrowser.this.isDisposed()) {
											return;
										}
										currentTime = System.currentTimeMillis();
										/**
										 * For SPR#LTZZ8THDLN. When open to much browser instances, COM.StgCreateDocfile will 
										 * fail (return 0x80070008) so that browser will fail to create new instances. If at this time
										 * trying to close XPD, due to browser's document massed up, ReadyState will not be "complete"
										 * that means each browser close need 30 seconds as design that make XPD looks hang. 
										 * So we need to shorten the waiting time for this case. 
										 */									
										String error=System.getProperty(PROPERTY_NOMOREHANDLE, "false");							
										maxTime =error.equalsIgnoreCase("true")  ? 300 : 30000;
										 if((currentTime-startTime)>=maxTime){
											 break;
										 }
										loopTime++;
		
										if (currentTime - lastTime > 100) {
											lastTime = currentTime;
											pVarResult = getAutomation().getProperty(
													rgdispid[0]);
											if (pVarResult != null) {
												int i = pVarResult.getInt();
												pVarResult.dispose();
												if (i == READYSTATE_COMPLETE) {
													break;
												}
											} 
										}
										//getDisplay().readAndDispatch();
										try {
											DisplayDispatcher.readAndDispatch(getDisplay());
										} catch (Throwable e1) {
											Logging.logp(Level.WARNING,_packageName, _clazzName, "DOMBrowser.readAndDispatch(getDisplay())", "Throwable in DOMBrowser", e1); //$NON-NLS-1$
										}
									}
								} catch (Throwable e1) {
									Logging.logp(Level.WARNING, _packageName, _clazzName, 
											"DOMBrowser : SWT.dispose ", "", e1);//$NON-NLS-1$ //$NON-NLS-2$
								}
								
								if(getSite()!= null){
									getSite().ignoreAllMessages = false;
								}

							}
							
							//Detach all the BHOs
							if( (bBHOSupported == true) && ((WebControlSite)(DOMBrowser.this.getSite())).bhoHelper!=null){
								((WebControlSite)(DOMBrowser.this.getSite())).bhoHelper.detachBHO();
							}
							if(getSite() !=null){								
								try {
									int rc = DOMBrowser.this.getSite().exec(45,0, null, null);//OLECMDID_CLOSE = 45 
									if(rc!=0)
										Logging.logp(Level.WARNING, _packageName, _clazzName, 
												"DOMBrowser : SWT.dispose ", Integer.toHexString(rc).toString());//$NON-NLS-1$			
								} catch (Exception e1) {
									Logging.logp(Level.WARNING, _packageName, _clazzName, 
											"DOMBrowser : SWT.dispose ", "", e1);//$NON-NLS-1$ //$NON-NLS-2$
								}							
							}
							
							//The COM references should be disposed before auto and site, to avoid SPR#HKOE7Y79CS and other random crashes
							DOMBrowser.this.disposeCOMReferences();
							//DOMBrowser.this.disposeIEWebBrowser();
							
							getAutomation().dispose();
							setAuto(null);
	
						}
	
						//dispose the COM ref again in case they have not been dispose
						DOMBrowser.this.disposeCOMReferences();
						DOMBrowser.this.disposeIEWebBrowser();
						
						if(getSite() != null){
							getSite().dispose();
						}					
						setSite(null);
						if (getIE() != null)
							getIE().lastNavigateURL = null;
						uncRedirect = null;
						// send the exit signal to IEOOP to exit the IEOOP.exe process
						if(enabledJava2Applet){
							try {
								/*
								 *  The IEOOP_hwnd value will be 0 for children windows, add the second check 
								 *  to exit the IEOOP.exe process when closing the last child window.
								 */
								if(IEOOP_hwnd!=0 || 
										(IEOOP_hwnd_Map.containsKey(IEOOPProcessGroupID) && IEOOP_hwnd_Map.get(IEOOPProcessGroupID)!=0)){
									//For the Legacy IEOOP multi-process mode
									if((enabledLegacyMultiProcess)){
										OS.PostMessage(IEOOP_hwnd, WebControlSite.IEOOP_WM_DOEXIT, 0, 0);
										IEOOP_hwnd=0;
									}
									//For the IEOOP multi-process on Demand mode
									if(IEOOPProcessGroupID !=0 && IEOOPBrowserCountMap.get(IEOOPProcessGroupID)==1){
										//OS.PostMessage(IEOOP_hwnd, WebControlSite.IEOOP_WM_DOEXIT, 0, 0);
										Display.getCurrent().timerExec(10*1000, new Runnable(){
											public void run() {
												OS.PostMessage(IEOOP_hwnd_Map.get(IEOOPProcessGroupID), WebControlSite.IEOOP_WM_DOEXIT, 0, 0);
												//System.out.println("IEOOP_WM_DOEXIT called to " + IEOOPProcessGroupID);
												IEOOP_hwnd=0;
												//Remove the hwnd from IEOOP_hwnd_Map since the IEOOP process was removed.
												IEOOP_hwnd_Map.remove(IEOOPProcessGroupID);
												strSessionIDs[IEOOPProcessGroupID] = null;
											}
										});
										// remove the sessionID/ClsID/bIEOOPRegistered from related array
										strSessionIDs[IEOOPProcessGroupID] = strSessionIDs[IEOOPProcessGroupID]+"-Removing";
										IEOOPClsID[IEOOPProcessGroupID] = null;
										bIEOOPRegistered[IEOOPProcessGroupID] = false;
									}
								}
							} catch (Exception e1) {
								Logging.logp(Level.WARNING,_packageName, _clazzName, "IEOOP_WM_DOEXIT", "", e1); //$NON-NLS-1$
							}finally{
								// decrease the browser count
								decreaseIEOOPBrowserCount(IEOOPProcessGroupID);
							}
						}
						break;
					}
    				case SWT.Resize: {
    					getFrame().setBounds(getClientArea());
    					break;
    				}
    				case SWT.KeyDown:
    				case SWT.KeyUp: {
    					notifyListeners(e.type, e);
    					break;
    				}
    				case SWT.FocusIn: {	
    					if(bInDisposing){
    						break;
    					}
           				/**
        				 * Fix for SPR# DMAS7QVNCM & SLDI7PE5XV & HFCG8E5DKR
        				 * We only call doverb() once for each browser instance to solve accessiblility issue.
        				 * Also, we wrap doVerb related vtblcall in swtIbmWrapper.dll to catch potential exception to avoid crash. 
        				 */
    					if(!bIsDoneFocusInDoverb){
    						bIsDoneFocusInDoverb=true;
    						getSite().doVerb(OLE.OLEIVERB_UIACTIVATE);
    					}
    					
    					// Make RCP Browser as a composite able to add focus listener and trace focus event.
    					Event focusInEvent = new Event ();
    					focusInEvent.type = e.type;
    					focusInEvent.widget = DOMBrowser.this;
    					DOMBrowser.this.notifyListeners(SWT.FocusIn, focusInEvent);
    					break;
    				}
    				case SWT.FocusOut:{
    					if(bInDisposing){
    						break;
    					}
    					// Make RCP Browser as a composite able to add focus listener and trace focus event.
    					Event focusOutEvent = new Event ();
    					focusOutEvent.type = e.type;
    					focusOutEvent.widget = DOMBrowser.this;
    					DOMBrowser.this.notifyListeners(SWT.FocusOut, focusOutEvent);
    					break;
    				}
    			}
    		}
    	};
    	
    	Listener[] swtList = this.getListeners(SWT.Dispose);
    	for (int i=0; i < swtList.length; i++)
    		this.removeListener(SWT.Dispose, swtList[i]);    	
    	
    	addListener(SWT.Dispose, swtlistener);
    	addListener(SWT.Resize, swtlistener);
    	getSite().addListener(SWT.KeyDown, swtlistener);
    	getSite().addListener(SWT.KeyUp, swtlistener);
    	getSite().addListener(SWT.FocusIn, swtlistener);
    	getSite().addListener(SWT.FocusOut, swtlistener);  
    	
    	listener = new OleListener() {
    		public void handleEvent(OleEvent event) {
    			try{
	    			switch (event.type) {
	    				case DISPID_NAVIGATEERROR:{
	    					//handle navigation error
	    					if (uncRedirect != null) {
								/*
								* This is the second error attempting to reach this UNC path, so
								* it does not exist.  Don't override the default error handling.
								*/
								uncRedirect = null;
								break;
							}
							Variant varResult = event.arguments[1];
							final String url = varResult.getString();
							if (url.startsWith("\\\\")) { //$NON-NLS-1$
								varResult = event.arguments[3];
								int statusCode = varResult.getInt();
								if (statusCode == INET_E_RESOURCE_NOT_FOUND) {
									int index = url.indexOf('\\', 2);
									if (index != -1) {
										final String host = url.substring(0, index);
										Variant cancel = event.arguments[4];
										if (cancel != null) {
											int /*long*/ pCancel = cancel.getByRef();
											COM.MoveMemory(pCancel, new short[] {COM.VARIANT_TRUE}, 2);
										}
										getIE().browser.getDisplay().asyncExec(new Runnable() {
											public void run() {
												if (getIE().browser.isDisposed()) return;
												/*
												* Feature of IE.  When a UNC path ends with a '\' character IE
												* drops this character when providing the path as an argument
												* to some IE listeners.  Remove this character here too in
												* order to match these other listener argument values.
												*/
												if (url.endsWith("\\")) { //$NON-NLS-1$
													uncRedirect = url.substring(0, url.length() - 1);
												} else {
													uncRedirect = url;
												}
												navigate(host,null, null, true);
											}
										});
									}
								}
							}
	    					break;
	    				}
	    					
	    				case IE.BeforeNavigate2 : {
	    					
	    					if (getIE().performingInitialNavigate) break;
	    					final String _method="DOMBrowser::IE.BeforeNavigate2";
	    					Variant varResult = event.arguments[1];
	    					String url = varResult.getString();
	    					Logging.getLogger(_packageName).entering(_clazzName, _method, url);
	    					/*
							 * Silently allow the navigate to proceed if the url is the first segment of a
							 * UNC path being navigated to (initiated by the NavigateError listener to show
							 * a name/password prompter), or if the url is the full UNC path (initiated by
							 * the NavigateComplete listener to redirect from the UNC's first segment to its
							 * full path).
							 */
							if (uncRedirect != null) {
								if (uncRedirect.equals(url) || (uncRedirect.startsWith(url) && uncRedirect.indexOf('\\', 2) == url.length())) {
									Variant cancel = event.arguments[6];
									if (cancel != null) {
										int /*long*/ pCancel = cancel.getByRef();
										COM.MoveMemory(pCancel, new short[] {COM.VARIANT_FALSE}, 2);
										
									}
									getIE().isAboutBlank = false;
									Logging.getLogger(_packageName).exiting(_clazzName, _method);
									break;
								} else {
									/*
									 * This navigate does not correspond to the previously-initiated
									 * UNC navigation so clear this state since it's no longer valid.
									 */
									uncRedirect = null;
								}
							}
							/*
							* Bug in IE.  For navigations on the local machine, BeforeNavigate2's url
							* field contains a string representing the file path in a non-URL format.
							* In order to be consistent with the other Browser implementations, this
							* case is detected and the string is changed to be a proper url string.
							*/
							if (url.indexOf(":/") == -1 && url.indexOf(":\\") != -1) { //$NON-NLS-1$ //$NON-NLS-2$
								url = PROTOCOL_FILE + url.replace('\\', '/');
							}
	    					LocationEvent newEvent = new LocationEvent(DOMBrowser.this);
	    					newEvent.display = getDisplay();
	    					newEvent.widget = DOMBrowser.this;
	    					newEvent.location = url;
	    					newEvent.doit = true;
	    					//To calculate the top value of LoacationEvent
	    					if(getAutomation()!=null){
	    						try{
		    						IDispatch dispatch = event.arguments[0].getDispatch();
		    						Variant variant = new Variant(getAutomation());
		    						IDispatch top = variant.getDispatch();
		    						newEvent.top = top.getAddress() == dispatch.getAddress();
	    						}catch(Exception e){
	    							Logging.logp(Level.FINEST,_packageName, _clazzName, 
	    									"DOMBrowser::IE.BeforeNavigate2", 	//$NON-NLS-1$
	    									"Failed to get top value of LocationEvent", e);	//$NON-NLS-1$
	    						}
	    					}
	    					try {
								for (int i = 0; i < getIE().locationListeners.length; i++){
									getIE().locationListeners[i].changing(newEvent);
								}
							} catch (Exception e) {
								Logging.logp(Level.WARNING,_packageName, _clazzName, "locationListeners", "", e); //$NON-NLS-1$
							}
	    					boolean doit = newEvent.doit && !DOMBrowser.this.isDisposed();
	    					Variant cancel = event.arguments[6];
	    					if (cancel != null) {
	    						int pCancel = cancel.getByRef();
	    						COM.MoveMemory(pCancel, new short[]{doit ? COM.VARIANT_FALSE : COM.VARIANT_TRUE}, 2);
	    					}
	    					if (doit){
	    						getIE().lastNavigateURL = url;
								if (newEvent.top) {
									getIE().isAboutBlank = url.startsWith(ABOUT_BLANK);
								}
	    					}
	    					if(doit && !ABOUT_BLANK.equalsIgnoreCase(url)){	    						
	    						/**
	    						 * the access is allowed after LocationListener by applications
	    						 */
	    						Logging.logp(Level.FINEST, _packageName, _clazzName, "IE.BeforeNavigate2", "Begin SSO!");  //$NON-NLS-1$  //$NON-NLS-2$
	    						ssoURL(url);
	    						Logging.logp(Level.FINEST, _packageName, _clazzName, "IE.BeforeNavigate2", "SSO Finshed!");  //$NON-NLS-1$  //$NON-NLS-2$
	    					}
	    					Logging.getLogger(_packageName).exiting(_clazzName, _method);
	    					break;
	    				}
	    				case IE.CommandStateChange : {
	    					boolean enabled = false;
	    					Variant varResult = event.arguments[0];
	    					int command = varResult.getInt();
	    					varResult = event.arguments[1];
	    					enabled = varResult.getBoolean();
	    					switch (command) {
	    						case IE.CSC_NAVIGATEBACK : getIE().back = enabled; break;
	    						case IE.CSC_NAVIGATEFORWARD : getIE().forward = enabled; break;
	    					}
	    					break;
	    				}
	    				case IE.DocumentComplete: {
	    		   			if(bInDisposing)
	    						return;
	    		   			if (getIE().performingInitialNavigate) {
	    		   				
								/* this event marks the completion of the initial navigate to about:blank */
	    		   				getIE().performingInitialNavigate = false;

								/* if browser content has been provided by the client then set it now */
								if (getIE().pendingText != null) {
									setText((String)getIE().pendingText[0], ((Boolean)getIE().pendingText[1]).booleanValue());
								} else if (getIE().pendingUrl != null) {
									setUrl((String)getIE().pendingUrl[0],(String)getIE().pendingUrl[1], (String[])getIE().pendingUrl[2]);
								}
								getIE().pendingText = getIE().pendingUrl = null;
								break;
							}
	    					boolean isTop=true;
	    					Variant varResult = event.arguments[0];
	    					IDispatch dispatch = varResult.getDispatch();
	    					if (getIE().html != null) {
	    						if (getIE().browser.isDisposed()) return;
	    						isInSetText=true;	    						
								
								int charCount = getIE().html.length();
								char[] chars = new char[charCount];
								getIE().html.getChars(0, charCount, chars, 0);
								getIE().html = null;
								int byteCount = OS.WideCharToMultiByte(OS.CP_UTF8, 0, chars, charCount, null, 0, null, null);
								/*
								* Note. Internet Explorer appears to treat the data loaded with 
								* nsIPersistStreamInit.Load as if it were encoded using the default
								* local charset.  There does not seem to be an API to set the
								* desired charset explicitly in this case.  The fix is to
								* prepend the UTF-8 Byte Order Mark signature to the data.
								*/
								byte[] UTF8BOM = {(byte)0xEF, (byte)0xBB, (byte)0xBF};
								int /*long*/ hGlobal = OS.GlobalAlloc(OS.GMEM_FIXED | OS.GMEM_ZEROINIT, UTF8BOM.length + byteCount);
								if (hGlobal != 0) {
									OS.MoveMemory(hGlobal, UTF8BOM, UTF8BOM.length);
									OS.WideCharToMultiByte(OS.CP_UTF8, 0, chars, charCount, hGlobal + UTF8BOM.length, byteCount, null, null);							
	    							int[] ppstm = new int[1];
	    							/* 
	    							* Note.  CreateStreamOnHGlobal is called with the flag fDeleteOnRelease.
	    							* If the call succeeds the buffer hGlobal is freed automatically
	    							* when the IStream object is released. If the call fails, free the buffer
	    							* hGlobal.
	    							*/
	    							if (OS.CreateStreamOnHGlobal(hGlobal, true, ppstm) == OS.S_OK) {
	    								if (getAutomation() != null) {
		    								int[] rgdispid = getAutomation().getIDsOfNames(new String[] {"Document"}); //$NON-NLS-1$
		    								Variant pVarResult = getAutomation().getProperty(rgdispid[0]);
		    								IDispatch dispatchDocument = pVarResult.getDispatch();
		    								int[] ppvObject = new int[1];
		    								int result = dispatchDocument.QueryInterface(COM.IIDIPersistStreamInit, ppvObject);
		    								if (result == OS.S_OK) {
		    									IPersistStreamInit persistStreamInit = new IPersistStreamInit(ppvObject[0]);
		    									if (persistStreamInit.InitNew() == OS.S_OK) {
		    										persistStreamInit.Load(ppstm[0]);
		    									}
		    									persistStreamInit.Release();
		    								}
		    								pVarResult.dispose();
		    								/*
		    								* This code is intentionally commented.  The IDispatch obtained from a Variant
		    								* did not increase the reference count for the enclosed interface.
		    								*/
		    								//dispatchDocument.Release();
		    								IUnknown stream = new IUnknown(ppstm[0]);
		    								stream.Release();
	    								}
	    							} else {
	    								OS.GlobalFree(hGlobal);
	    							}
	    						}
	    					} else {
	    						isInSetText=false;
	    						if (getAutomation() != null) {
		    						Variant variant = new Variant(getAutomation());
		    						IDispatch top = variant.getDispatch();
		    						varResult = event.arguments[1];
		    						String url = varResult.getString();
		    						
		    						/*
		    						* Bug in IE.  For navigations on the local machine, DocumentComplete's URL
		    						* field contains a string representing the file path in a non-URL format.
		    						* In order to be consistent with the other Browser implementations, this
		    						* case is detected and the string is changed to be a proper url string.
		    						*/
		    						if (url.indexOf(":/") == -1 && url.indexOf(":\\") != -1) { //$NON-NLS-1$ //$NON-NLS-2$
		    							url = PROTOCOL_FILE + url.replace('\\', '/');
		    						}
		    						LocationEvent locationEvent = new LocationEvent(DOMBrowser.this);
		    						locationEvent.display = getDisplay();
		    						locationEvent.widget = DOMBrowser.this;
		    						locationEvent.location = url;
		    						locationEvent.top = top.getAddress() == dispatch.getAddress();
		    						isTop=(top.getAddress() == dispatch.getAddress());
		    						locationEvent.top = isTop;
		    						if (isTop)
		    							isTopNavigate = false; //reset
		    						
		    						try {
										for (int i = 0; i < getIE().locationListeners.length; i++){
											getIE().locationListeners[i].changed(locationEvent);
										}
									} catch (Exception e) {
										Logging.logp(Level.WARNING,_packageName, _clazzName, "locationListeners.changed", "", e); //$NON-NLS-1$
									}
	    						}
	    						/*
	    						 * This code is intentionally commented.  A Variant constructed from an
	    						 * OleAutomation object does not increase its reference count.  The IDispatch
	    						 * obtained from this Variant did not increase the reference count for the
	    						 * OleAutomation instance either. 
	    						 */
	    						//top.Release();
	    						//variant.dispose();
	    						/*
	    						 * Note.  The completion of the page loading is detected as
	    						 * described in the MSDN article "Determine when a page is
	    						 * done loading in WebBrowser Control". 
	    						 */
	    						if (DOMBrowser.this.isDisposed()==false && getIE().globalDispatch != 0 && dispatch.getAddress() == getIE().globalDispatch) {
	    							getIE().globalDispatch = 0;
	    							ProgressEvent progressEvent = new ProgressEvent(DOMBrowser.this);
	    							progressEvent.display = getDisplay();
	    							progressEvent.widget = DOMBrowser.this;
	    							for (int i = 0; i < getIE().progressListeners.length; i++){
	    								getIE().progressListeners[i].completed(progressEvent);
	    							}
	    						}
	    					}
	    					
    						IEDocumentCompleteEvent newEvent = new IEDocumentCompleteEvent(DOMBrowser.this);
    						newEvent.webBrowser = dispatch; 
    						try {
    							if (documentCompleteListeners != null) {
    								for (int i = 0; i < documentCompleteListeners.length; i++){
    									documentCompleteListeners[i].changed(newEvent);
    								}
    							}
    						} catch (Exception e) {
    							
    							Logging.logp(Level.WARNING,_packageName, _clazzName, "documentCompleteListeners", "", e); //$NON-NLS-1$
    						}
	    					
	    					/*
	    					* This code is intentionally commented.  This IDispatch was received
	    					* as an argument from the OleEvent and it will be disposed along with
	    					* the other arguments.  
	    					*/
	    					//dispatch.Release();
	    					break;
	    				}
	    				case IE.NavigateComplete2: {
	    					Variant varResult = event.arguments[1];
							String url = varResult.getString();
							if (!getIE().performingInitialNavigate) {
								varResult = event.arguments[0];
								IDispatch dispatch = varResult.getDispatch();
								Variant variant = new Variant(getAutomation()); 
								IDispatch top = variant.getDispatch();
								if (top.getAddress() == dispatch.getAddress()) {
									getIE().isAboutBlank = url.startsWith(ABOUT_BLANK);
									getIE().lastNavigateURL = url;
								}
							}
							Variant variant = new Variant(getAutomation());
    						IDispatch top = variant.getDispatch();
    						
	    					IDispatch curDispatch = event.arguments[0].getDispatch();
	    					
	    					if(top.getAddress() == curDispatch.getAddress()){
	    						isTopNavigate=true;
	    					}
	    					
							/*
							* Bug in Acrobat Reader.  Opening > MAX_PDF PDF files causes Acrobat to not
							* clean up its shells properly when the container Browser is disposed.
							* This results in Eclipse crashing at shutdown time because the leftover
							* shells have invalid references to unloaded Acrobat libraries.  The
							* workaround is to not unload the Acrobat libraries if > MAX_PDF PDF
							* files have been opened.
							*/
							int extensionIndex = url.lastIndexOf('.');
							if (extensionIndex != -1) {
								String extension = url.substring(extensionIndex);
								if (extension.equalsIgnoreCase(IE.EXTENSION_PDF)) {
									IE.PDFCount++;
									if (IE.PDFCount > IE.MAX_PDF) {
										COM.FreeUnusedLibraries = false;
									}
								}
							}

							
							if (uncRedirect != null) {
								if (uncRedirect.equals(url)) {
									/* full UNC path has been successfully navigated */
									uncRedirect = null;
									break;
								}
								if (uncRedirect.startsWith(url)) {
									/*
									* UNC first segment has been successfully navigated,
									* now redirect to the full UNC path.
									*/ 
									navigate(uncRedirect,null, null, true);
									break;
								}
								uncRedirect = null;
							}
	    					
							varResult = event.arguments[0];	    					
	    					IDispatch dispatch = varResult.getDispatch();
	    					if (getIE().globalDispatch == 0) {
	    						getIE().globalDispatch = dispatch.getAddress();
	    					}
	    					break;
	    				}
	    				case IE.NewWindow2 : {
	    					WindowEvent newEvent = new WindowEvent(DOMBrowser.this);
	    					newEvent.display = getDisplay();
	    					newEvent.widget = DOMBrowser.this;
							newEvent.data = getIEOOPSessionID();
	    					for (int i = 0; i < getIE().openWindowListeners.length; i++){
	    						getIE().openWindowListeners[i].open(newEvent);
	    					}
	    					Browser browser = newEvent.browser;
	    					boolean doit = browser != null && !browser.isDisposed();
	    					if (doit) {
	    						Variant variant = new Variant(((DOMBrowser)browser).getIE().auto);
	    						IDispatch iDispatch = variant.getDispatch();
	    						if(((DOMBrowser)browser).enabledJava2Applet() || enabledJava2Applet()){
	    							iDispatch.AddRef();
	    							//this is a workaround to get refCounting correct in IEOOP mode
	    						}
	    						Variant ppDisp = event.arguments[0];
	    						int byref = ppDisp.getByRef();
	    						if (byref != 0){
	    							COM.MoveMemory(byref, new int[] {iDispatch.getAddress()}, 4);
	    						}
	    						/*
	    						* This code is intentionally commented.  A Variant constructed from an
	    						* OleAutomation object does not increase its reference count.  The IDispatch
	    						* obtained from this Variant did not increase the reference count for the
	    						* OleAutomation instance either. 
	    						*/
	    						//variant.dispose();
	    						//iDispatch.Release();
	    					}
							
	    					Variant cancel = event.arguments[1];
	    					int pCancel = cancel.getByRef();
	    					COM.MoveMemory(pCancel, new short[]{doit ? COM.VARIANT_FALSE : COM.VARIANT_TRUE}, 2);
	    					break;
	    				}
	    				case IE.OnMenuBar: {
	    					Variant arg0 = event.arguments[0];
	    					getIE().menuBar = arg0.getBoolean();
	    					break;
	    				}
	    				case IE.OnStatusBar: {
	    					Variant arg0 = event.arguments[0];
	    					getIE().statusBar = arg0.getBoolean();
	    					break;
	    				}
	    				case IE.OnToolBar: {
	    					Variant arg0 = event.arguments[0];
	    					getIE().toolBar = arg0.getBoolean();
	    					/*
	    					* Feature in Internet Explorer.  OnToolBar FALSE is emitted 
	    					* when both tool bar, address bar and menu bar must not be visible.
	    					* OnToolBar TRUE is emitted when either of tool bar, address bar
	    					* or menu bar is visible.
	    					*/
	    					if (!getIE().toolBar) {
	    						getIE().addressBar = false;
	    						getIE().menuBar = false;
	    					}
	    					break;
	    				}
	    				case IE.OnVisible : {
	    					Variant arg1 = event.arguments[0];
	    					boolean visible = arg1.getBoolean();
	    					WindowEvent newEvent = new WindowEvent(DOMBrowser.this);
	    					newEvent.display = getDisplay();
	    					newEvent.widget = DOMBrowser.this;
	    					if (visible) {
	    						if (getIE().addressBar) {
	    							/*
	    							* Bug in Internet Explorer.  There is no distinct notification for
	    							* the address bar.  If neither address, menu or tool bars are visible,
	    							* OnToolBar FALSE is emitted. For some reason, querying the value of
	    							* AddressBar in this case returns true even though it should not be
	    							* set visible.  The workaround is to only query the value of AddressBar
	    							* when OnToolBar FALSE has not been emitted.
	    							*/
	    							int[] rgdispid = getAutomation().getIDsOfNames(new String[] { "AddressBar" }); //$NON-NLS-1$
	    							Variant pVarResult = getAutomation().getProperty(rgdispid[0]);
	    							if (pVarResult != null ) {
	    								if( pVarResult.getType() == OLE.VT_BOOL )
	    									getIE().addressBar = pVarResult.getBoolean();
	    								pVarResult.dispose();
	    							}
	    						}
	    						newEvent.addressBar = getIE().addressBar;
	    						newEvent.menuBar = getIE().menuBar;
	    						newEvent.statusBar = getIE().statusBar;
	    						newEvent.toolBar = getIE().toolBar;
	    						newEvent.location = getIE().location;
	    						newEvent.size = getIE().size;
	    						for (int i = 0; i < getIE().visibilityWindowListeners.length; i++) {
	    							getIE().visibilityWindowListeners[i].show(newEvent);
	    						}
	    						getIE().location = null;
	    						getIE().size = null;
	    					} else {
	    						for (int i = 0; i < getIE().visibilityWindowListeners.length; i++){
	    							getIE().visibilityWindowListeners[i].hide(newEvent);
	    						}
	    					}
	    					break;
	    				}
	    				case IE.ProgressChange : {
							/* don't send client events if the initial navigate to about:blank has not completed */
	    					if (getIE().performingInitialNavigate) break;
							
	    					Variant arg1 = event.arguments[0];
	    					int nProgress = arg1.getType() != OLE.VT_I4 ? 0 : arg1.getInt(); // may be -1
	    					Variant arg2 = event.arguments[1];
	    					int nProgressMax = arg2.getType() != OLE.VT_I4 ? 0 : arg2.getInt();
	    					ProgressEvent newEvent = new ProgressEvent(DOMBrowser.this);
	    					newEvent.display = getDisplay();
	    					newEvent.widget = DOMBrowser.this;
	    					newEvent.current = nProgress;
	    					newEvent.total = nProgressMax;
	    					if (nProgress != -1) {
	    						for (int i = 0; i < getIE().progressListeners.length; i++){
	    							getIE().progressListeners[i].changed(newEvent);
	    						}
	    					}
	    					break;
	    				}
	    				case IE.StatusTextChange : {
							/* don't send client events if the initial navigate to about:blank has not completed */
	    					if (getIE().performingInitialNavigate) break;
							
	    					Variant arg1 = event.arguments[0];
	    					if (arg1.getType() == OLE.VT_BSTR) {
	    						String text = arg1.getString();
	    						StatusTextEvent newEvent = new StatusTextEvent(DOMBrowser.this);
	    						newEvent.display = getDisplay();
	    						newEvent.widget = DOMBrowser.this;
	    						newEvent.text = text;
	    						for (int i = 0; i < getIE().statusTextListeners.length; i++){
	    							getIE().statusTextListeners[i].changed(newEvent);
	    						}
	    					}
	    					break;
	    				}
	    				case IE.TitleChange : {
							/* don't send client events if the initial navigate to about:blank has not completed */
							if (getIE().performingInitialNavigate) break;
							
	    					Variant arg1 = event.arguments[0];
	    					if (arg1.getType() == OLE.VT_BSTR) {
	    						String title = arg1.getString();
	    						TitleEvent newEvent = new TitleEvent(DOMBrowser.this);
	    						newEvent.display = getDisplay();
	    						newEvent.widget = DOMBrowser.this;
	    						newEvent.title = title;
	    						for (int i = 0; i < getIE().titleListeners.length; i++){
	    							getIE().titleListeners[i].changed(newEvent);
	    						}
	    					}
	    					break;
	    				}
	    				case IE.WindowClosing : {
	    					
	    					//close window by javascript ,do not dispose window immediately. 
	    					Display.getCurrent().asyncExec(new Runnable() {
								public void run() {
									if (DOMBrowser.this.isDisposed()) return;
									
									WindowEvent newEvent = new WindowEvent(DOMBrowser.this);
			    					newEvent.display = getDisplay();
			    					newEvent.widget = DOMBrowser.this;
			    					
									try {
										for (int i = 0; i < getIE().closeWindowListeners.length; i++){
											getIE().closeWindowListeners[i].close(newEvent);
										}
									} catch (Exception e) {
										Logging.logp(Level.WARNING,_packageName, _clazzName, "closeWindowListeners", "", e); //$NON-NLS-1$
									}	
								}
						});
								
	    					Variant cancel = event.arguments[1];
	    					int pCancel = cancel.getByRef();
						/*
						 * don't dispose DOMBrowser here. 
						 * if we need to dispose DOMBrowser, add a WindowClose listener and dispose in it.
						 */
	    					COM.MoveMemory(pCancel, new short[]{COM.VARIANT_TRUE}, 2);
	    					break;
	    				}
	    				case IE.WindowSetHeight : {
	    					if (getIE().size == null) {
	    						getIE().size = new Point(0, 0);
	    					}
	    					Variant arg1 = event.arguments[0];
	    					getIE().size.y = arg1.getInt();
	    					break;
	    				}
	    				case IE.WindowSetLeft : {
	    					if (getIE().location == null) {
	    						getIE().location = new Point(0, 0);
	    					}
	    					Variant arg1 = event.arguments[0];
	    					getIE().location.x = arg1.getInt();
	    					break;
	    				}
	    				case IE.WindowSetTop : {
	    					if (getIE().location == null) {
	    						getIE().location = new Point(0, 0);
	    					}
	    					Variant arg1 = event.arguments[0];
	    					getIE().location.y = arg1.getInt();
	    					break;
	    				}
	    				case IE.WindowSetWidth : {
	    					if (getIE().size == null) {
	    						getIE().size = new Point(0, 0);
	    					}
	    					Variant arg1 = event.arguments[0];
	    					getIE().size.x = arg1.getInt();
	    					break;
	    				}
						case DISPID_READYSTATE: {
							if(bInDisposing){
								return;
							}
							IDispatch dispatch = null;
							JHTMLDocument doc = (JHTMLDocument) getDocument();
							// Reset the flag if it is any other state, this allows
							// the IE.DocumentComplete event to act as a fail safe.
							if (doc != null) {
								String readyState = doc.getReadyState();
								if ("complete".equalsIgnoreCase(readyState)) {
									if (lastReadyState!=null && (!"complete".equalsIgnoreCase(lastReadyState))){
											dispatch = new Variant(getAutomation()).getDispatch();
											// Only fire this document complete code when main frame is in refresh state.
											if ((!isTopNavigate) &&(dispatch != null)) {
												IEDocumentCompleteEvent newEvent = new IEDocumentCompleteEvent(DOMBrowser.this);
												newEvent.webBrowser = dispatch;  
												try {
													if (documentCompleteListeners != null) {
														for (int i = 0; i < documentCompleteListeners.length; i++){
															documentCompleteListeners[i].changed(newEvent);
														}
													}
												} catch (Exception e) {
													Logging.logp(Level.WARNING,_packageName, _clazzName, "documentCompleteListeners", "", e); //$NON-NLS-1$
												}
											}
										}									
								}
								lastReadyState = readyState;
							}
							break;
						}
	    			}
    			}catch(SWTException e)
    			{
    				Logging.logp(Level.INFO,_packageName, _clazzName, "OleEvent::handleEvent()", "", e); //$NON-NLS-1$
    			}
    			// changes from Eclipse bugzilla bug 405711
//    			finally
//    			{
//	    			/*
//	    			* Dispose all arguments passed in the OleEvent.  This must be
//	    			* done to properly release any IDispatch reference that was
//	    			* automatically addRef'ed when constructing the OleEvent.  
//	    			*/
//	    			Variant[] arguments = event.arguments;    			
//	    			if(arguments!=null){
//			    		for (int i = 0; i < arguments.length; i++){
//			    			if(arguments[i]!=null){
//			    				arguments[i].dispose();
//			    			}
//			    		}
//					}
//    			}
    		}
    	};
    	getSite().addEventListener(DISPID_NAVIGATEERROR, listener);
    	getSite().addEventListener(IE.BeforeNavigate2, listener);
    	getSite().addEventListener(IE.CommandStateChange, listener);
    	getSite().addEventListener(IE.DocumentComplete, listener);
    	getSite().addEventListener(IE.NavigateComplete2, listener);
    	getSite().addEventListener(IE.NewWindow2, listener);
    	getSite().addEventListener(IE.OnMenuBar, listener);
    	getSite().addEventListener(IE.OnStatusBar, listener);
    	getSite().addEventListener(IE.OnToolBar, listener);
    	getSite().addEventListener(IE.OnVisible, listener);
    	getSite().addEventListener(IE.ProgressChange, listener);
    	getSite().addEventListener(IE.StatusTextChange, listener);
    	getSite().addEventListener(IE.TitleChange, listener);
    	getSite().addEventListener(IE.WindowClosing, listener);
    	getSite().addEventListener(IE.WindowSetHeight, listener);
    	getSite().addEventListener(IE.WindowSetLeft, listener);
    	getSite().addEventListener(IE.WindowSetTop, listener);
    	getSite().addEventListener(IE.WindowSetWidth, listener);
    	getSite().addPropertyListener(DISPID_READYSTATE, listener);  
    	
    	Variant variant = new Variant(true);
    	if (getAutomation() != null){
    		getAutomation().setProperty(IE.RegisterAsBrowser, variant);
    	}
    	variant.dispose();
    	
    	// from Browser constructor end ////
		
		/*Comment out this code for SPR#LIBL7UNCW5.
		addDisposeListener (new DisposeListener() {
            public void widgetDisposed(DisposeEvent e) {
                DOMBrowser.this.disposeIEWebBrowser();
            }
        }); 
        */   
			
		/*getSite().addPropertyListener(DISPID_READYSTATE, new OleListener() {
			public void handleEvent(OleEvent event) {
				if (inetSecuritySettings.getShowScriptErrors()) {
					return;	
				}
				JHTMLDocument doc =(JHTMLDocument) getDocument();
				if (doc == null) {
					return;
				}
				String readyState = doc.getReadyState(); 
				if (readyState == null) {
					return;
				}
				readyState = readyState.trim();
				if (readyState.length() == 0 || 
					(!readyState.equalsIgnoreCase("complete") &&
					 !readyState.equalsIgnoreCase("loading") &&
					 !readyState.equalsIgnoreCase("interactive"))) {
					return;
				}
				if (doc.getElementById(SHOW_SCRIPT_ERROR_TEXT_ID) != null) {
					return;
				}
				JHTMLElementCollection coll = (JHTMLElementCollection) doc.getElementsByTagName("HEAD");
				JHTMLElement html = null;
				if (coll != null && coll.getLength() > 0) {
					html = (JHTMLElement)coll.item(0); 
				}
				if (html == null) {
					html = (JHTMLElement)doc.getBody(); 
				}
				if (html == null) {
					html = (JHTMLElement)doc.getDocumentElement(); 
				}
				if (html == null) {
					return;
				}
				html.insertAdjacentHTML("afterBegin",SHOW_SCRIPT_ERROR_TEXT);
				Variant[] arguments = event.arguments;
				if(arguments!=null){
		    		for (int i = 0; i < arguments.length; i++){
		    			if(arguments[i]!=null){
		    				arguments[i].dispose();
		    			}
		    		}
		    	}
				
			}
		});*/
		
		//
		 SecuritySettings securitySettings = getSecuritySettings();
	        securitySettings.setShowScriptErrors(false);
	            
        // Set IE Internet Options Languages for current locale.	  
	    // setIEInternetOptions(); // Really, it do nothing. Comment.
	    
	    initSystemProxy();
	        
	    if (enabledJava2Applet()){
	    	nIEOOPBrowserCount++;
			increaseIEOOPBrowserCount(IEOOPProcessGroupID);
	    }
	    else
	    	nIEModeBrowserCount++;
	    
	    // For spr#JYLU8JKC94, set native exception dump info into jni side
	    /*if(!enabledJava2Applet() && !bInitializedDUMPInfo){
	    	bInitializedDUMPInfo = true;
	    	
	    	boolean enableDump = Platform.getPreferencesService().getBoolean(BUNDLE_NAME,
	    			PREFERENCE_ENABLE_NATIVE_EXCEPTION_DUMP, false, null);
	    	Location dataStoreLocation = Platform.getInstanceLocation();
			String path = dataStoreLocation.getURL().getFile();
			path = path.substring(1);
			path = path + "logs\\";
	    	
	    	String dumpLocation = Platform.getPreferencesService().getString(BUNDLE_NAME,
	    			PREFERENCE_NATIVE_EXCEPTION_DUMP_LOCATION, path, null);
	    	dumpLocation = dumpLocation.replaceAll("/", "\\\\");
	    	if(dumpLocation != null){
	    		dumpLocation=dumpLocation.trim();
	    	}
	    	// Get java home path, and set into JNI side to load the JVM's dbghelp.dll for dumping call stack
	    	String javaHome = System.getProperty("java.home");
	    	boolean isBidi = (SWT.RIGHT_TO_LEFT == (parent.getParent().getStyle() & SWT.RIGHT_TO_LEFT));
	    	// use one jni call to pass all needed info to native side
	    	OS.setNativeDumpInfo2JNI(enableDump, isBidi, dumpLocation, 
	    			DOMBrowserNLS.NativeExceptoin_DUMP_MessageBox_Title, 
	    			DOMBrowserNLS.NativeException_DUMP_MessageBox_Content,
	    			DOMBrowserNLS.NativeException_DUMP_Complete_MessageBox_Title,
	    			NLS.bind(DOMBrowserNLS.NativeException_DUMP_Complete_MessageBox_Content, dumpLocation),	    			
	    			DOMBrowserNLS.NativeException_DUMP_Error_MessageBox_Title,
	    			DOMBrowserNLS.NativeException_DUMP_Error_MessageBox_Content,
	    			DOMBrowserNLS.NativeException_Warning_MessageBox_Title,
	    			DOMBrowserNLS.NativeException_Warning_MessageBox_Content,
	    			javaHome);
				
	    }*/
	    
	    // Add Account Integration Support
	    /*
	     * These code is used to re-sso the proxy after the ssoed IEOOP process exit entirely 
	     * and a new IEOOP process start up. 
	     */
	    if (bSSOSupported && enabledJava2Applet() && (nIEOOPBrowserCount == 1 || IEOOPBrowserCountMap.get(IEOOPProcessGroupID)==1)){
		    //Need reset variable "isSSOedIEOOPService". Fix for SPR #HFCG7KA9WZ
	    	BrowserProxySSOEntry proxyEntry=BrowserSSOManager.getInstance().getProxySSOEntry();
			if(proxyEntry!=null){
				proxyEntry.setSSOedIEOOPService(false);
				proxyEntry.IEOOPServiceSSOAttemptedCount=0;
			}
			BrowserSSOManager.getInstance().reInitializeSSOInfoCacheIEOOP();
	    }
	    else if (bSSOSupported && !enabledJava2Applet() && nIEModeBrowserCount == 1){
	    	BrowserProxySSOEntry proxyEntry=BrowserSSOManager.getInstance().getProxySSOEntry();
			if(proxyEntry!=null){
				proxyEntry.setSSOedIEService(false);
				proxyEntry.IEServiceSSOAttemptedCount=0;
			}
			BrowserSSOManager.getInstance().reInitializeSSOInfoCacheIEMode();
	    }
	}
    
    /*
     * After IE upgrading to IE8, for compatibility purposes, the WebBrowser control will run in 
     * IE7 Standards Mode by default if no FeatureControl Key value is defined for IEOOP.exe.
     * 
     * To run a WebBrowser control in IE8 Standards Mode, need add following new value into 
     * the registry:
     * [(HKEY_CURRENT_USER or HKEY_LOCAL_MACHINE)\Software\Microsoft\Internet Explorer\Main\
     * FeatureControl\FEATURE_BROWSER_EMULATION]
     * "IEOOP.exe" = 0x1F40
     * 
     * This method is derivative from eclipse bug 328609: 
     * https://bugs.eclipse.org/bugs/show_bug.cgi?id=328609
     */
    private void changeIEOOPEmulationVersion(){
    	if (!isIEOOPEmulationVersionInitialized) {
    		isIEOOPEmulationVersionInitialized = true;
    		int version = 0;
    		String versionProperty = System.getProperty(IE.PROPERTY_IEVERSION);
    		if (versionProperty != null) {
    			if (versionProperty.equalsIgnoreCase(IE.VALUE_DEFAULT)) {
    				version = -1;
    			} else {
    				try {
    					version = Integer.valueOf(versionProperty).intValue();
    				} catch (NumberFormatException e) {
    					/* 
    					 * An invalid value was specified for the IEVersion java property.  Ignore it
    					 * and continue with the usual steps for determining the version to specify.
    					 */
    				}
    			}
    		}
    		if (version == 0) {
    			if (IE.IEVersion != 0) {
    				version = IE.IEVersion * 1000;
    			} else {
    				version = IE.DEFAULT_IE_VERSION;
    			}
    		}

    		if (version != -1) {
    			int /*long*/[] key = new int /*long*/[1];
    			final TCHAR subkey = new TCHAR(0, "Software\\Microsoft\\Internet Explorer\\Main\\FeatureControl\\FEATURE_BROWSER_EMULATION", true);	//$NON-NLS-1$
    			if (OS.RegCreateKeyEx(OS.HKEY_CURRENT_USER, subkey, 0, null, OS.REG_OPTION_VOLATILE, OS.KEY_WRITE | OS.KEY_QUERY_VALUE, 0, key, null) == 0) {
    				// Ensure IEOOP.exe is in the FEATURE_BROWSER_EMULATION registry.
    				final TCHAR lpValueName = new TCHAR(0, IEOOPEXE, true);
    				if (OS.RegQueryValueEx(key[0], lpValueName, 0, null, (int[])null, null) == OS.ERROR_FILE_NOT_FOUND) {
    					if (OS.RegSetValueEx(key[0], lpValueName, 0, OS.REG_DWORD, new int[] {version}, 4) == 0) {
    						getDisplay().addListener(SWT.Dispose, new Listener() {			
    							public void handleEvent(Event event) {
    								int /*long*/[] key = new int /*long*/[1];
    								if (OS.RegOpenKeyEx(OS.HKEY_CURRENT_USER, subkey, 0, OS.KEY_WRITE, key) == 0) {
    									OS.RegDeleteValue(key[0], lpValueName);
    								}
    							}
    						});
    					}
    				}
    				OS.RegCloseKey(key[0]);
    			}
    		}
    	}
    }
    
    private void removeOleListeners(){
    	if(getSite()==null) return;

    	getSite().removeEventListener(IE.BeforeNavigate2, listener);
    	getSite().removeEventListener(IE.CommandStateChange, listener);
    	getSite().removeEventListener(IE.DocumentComplete, listener);
    	getSite().removeEventListener(IE.NavigateComplete2, listener);
    	getSite().removeEventListener(IE.NewWindow2, listener);
    	getSite().removeEventListener(IE.OnMenuBar, listener);
    	getSite().removeEventListener(IE.OnStatusBar, listener);
    	getSite().removeEventListener(IE.OnToolBar, listener);
    	getSite().removeEventListener(IE.OnVisible, listener);
    	getSite().removeEventListener(IE.ProgressChange, listener);
    	getSite().removeEventListener(IE.StatusTextChange, listener);
    	getSite().removeEventListener(IE.TitleChange, listener);
    	getSite().removeEventListener(IE.WindowClosing, listener);
    	getSite().removeEventListener(IE.WindowSetHeight, listener);
    	getSite().removeEventListener(IE.WindowSetLeft, listener);
    	getSite().removeEventListener(IE.WindowSetTop, listener);
    	getSite().removeEventListener(IE.WindowSetWidth, listener);
		getSite().removePropertyListener(DISPID_READYSTATE, listener);
		listener=null;
    }
       

    private boolean ssoURL(String url){
    	final String _method="ssoURL";
    	Logging.getLogger(_packageName).entering(_clazzName, _method, url);
    	if(!ABOUT_BLANK.equalsIgnoreCase(url) && isSSOEnabled()){
    		initSSOSupport();
    		if(isSSOSupported()){
    			try{
    				// if(systemProxyHelper.isSecured()==true){
    				// add by zhou xing, when manual proxy setting is enabled, secure proxy authentication can be used
    				if( systemProxyHelper!=null && systemProxyHelper.isManualProxyEnabled()==true && systemProxyHelper.isSecured()==true) {
    					BrowserProxySSOEntry proxyEntry=BrowserSSOManager.getInstance().getProxySSOEntry();
    					if(proxyEntry!=null){
    						proxyEntry.doSSO(DOMBrowser.this, url);		    								
    					}		    							
    				}
    				BrowserSSOEntry entry=BrowserSSOManager.getInstance().getBrowserSSOEntry(url);
    				if(entry!=null){
    					entry.doSSO(DOMBrowser.this, url);
    				}
    			}catch(Throwable th){
    				Logging.logp(Level.WARNING,_packageName, _clazzName, 
    						"DOMBrowser::IE.BeforeNavigate2", 	//$NON-NLS-1$
    						"SSO", th);	//$NON-NLS-1$
    				Logging.getLogger(_packageName).exiting(_clazzName, _method);
    			}			    				
    		}		   
    	}
    	Logging.getLogger(_packageName).exiting(_clazzName, _method);
    	return true;
    }
    protected void initSystemProxy(){
    	/**
    	 * It is not make as singleton because there is both IE & IEOOP mode
    	 * SystemProxyHelp needs to maintain a reference to DOMBrowser
    	 */
    	/**
    	 * Mechanism to handle Proxy Authentication
    	 * 1. Check is Secure Proxy
    	 * 2. Call ssoForProxy at first URL navigation rather than about:blank
    	 * 3. If return true, stop calling that. Otherwise continue call for next time
    	 * This is because we are not able to suppress the log in dialog, and Navigation Error happens after the dialog is cancelled
    	 * We are not able to capture the event before the log in dialog pops
    	 */
	    systemProxyHelper=new SystemProxyHelper(this);
	    systemProxyHelper.initSysProxy();
    	/**
    	 * Set system Proxy here
    	 */
	    sysProxyInfo=systemProxyHelper.getProxyInfo();
	    if(sysProxyInfo !=null){
	    	setProxy(sysProxyInfo, true);			 		    	
	    }
	    // Add proxy preference listener
	    systemProxyHelper.addSysProxyPreferenceChangeListener();
    }
  /*  public boolean callForProxySSO(String url){      
    	final String _method="callForProxySSO";
    	if(sysProxySSONeeded==true && sysProxySSODone==false && sysProxyInfo!=null){	
    		sysProxySSODone= BrowserSSOUtil.ssoForProxy(url, this);		
    		Logging.logp(Level.FINEST,_packageName, _clazzName,_method,"SSO Thread End time: "+Integer.toString((int)System.currentTimeMillis())); //$NON-NLS-1$
    		Logging.logp(Level.FINEST,_packageName, _clazzName,_method,"SSO Thread costs(ms): "+Integer.toString((int)(System.currentTimeMillis()-curTime))); //$NON-NLS-1$

    	}
    	return sysProxySSODone;
    }*/
    protected boolean isSSOSupported(){
    	return bSSOSupported;
    }
    
	private  synchronized void initSSOSupport(){
		if(bSSOInitialized==false){
			bSSOInitialized=true;
			if(Platform.getBundle("com.ibm.rcp.accounts")!=null){//$NON-NLS-1$
				//read preference setting for SSO support			
				//default to false
				bSSOSupported=Platform.getPreferencesService().getBoolean("com.ibm.rcp.browser.service", "SingleSignOn", true,null);
				BrowserSSOUtil.setSsoTimeOutValue(Platform.getPreferencesService().getInt("com.ibm.rcp.browser.service", "SingleSignOnTimeOut", 10000, null));
				if(bSSOSupported){
					/**
					 * Init the BrowserSSOManager, Caching is disabled in below code
					 */
					bSSOSupported=BrowserSSOManager.getInstance().initBrowserSSOManager();
					if(bSSOSupported && systemProxyHelper != null ){
						BrowserSSOManager.getInstance().updateProxySSOState(systemProxyHelper.isSecured());
					}
					/**
					 * Init the BrowserSSOManager, Caching is Enabled in below code
					 */
					//bSSOSupported=BrowserSSOManager.getInstance().initBrowserSSOManager(true);
				}
				
			}else{
				bSSOSupported=false;
			}	   	 
		}
	}
    private String getJNIPath(){
    	String domiepluginPath="";//Platform.getBundle("com.ibm.rcp.swt.browser.dom.ie").getEntry("/").toExternalForm();    	//$NON-NLS-1$	
    	try {
			URL baseUrl = FileLocator.resolve(Platform.getBundle("com.ibm.rcp.swt.browser.dom.ie").getEntry("/")); 	//$NON-NLS-1$
			domiepluginPath=baseUrl.toExternalForm();
		} catch (IOException e1) {
			Logging.logp(Level.WARNING,_packageName, _clazzName, "getJNIPath", "", e1); 	//$NON-NLS-1$
		}		
    	if(domiepluginPath.startsWith("file:/")){	//$NON-NLS-1$
            domiepluginPath=domiepluginPath.substring("file:/".length());	//$NON-NLS-1$
    	}
    	else if(domiepluginPath.startsWith("file://")){	//$NON-NLS-1$
            domiepluginPath=domiepluginPath.substring("file://".length());	//$NON-NLS-1$
    	}

		String fileSeparator="/";//System.getProperty("file.separator");	//$NON-NLS-1$
		
		domiepluginPath=domiepluginPath+"os"+fileSeparator+"win32"+fileSeparator+"x86"+fileSeparator; //$NON-NLS-1$
		domiepluginPath=domiepluginPath.replace('\\','/');//System registry doesn't accept '\\' //$NON-NLS-1$	
		
		return domiepluginPath;
    }
    private String getIEOOPUserID(){
    	String userID=getJNIPath()+IEOOPEXE;
    	userID=userID.replaceAll(" ","%20"); //Bugzilla: 119085,remove space char.	//$NON-NLS-1$
    	return userID;
    }
    private boolean getIEOOPCLSID(int gid){    	
    	String userID=getIEOOPUserID();//getJNIPath()+IEOOPEXE;
    	//Search in system registry
	    TCHAR lpSubKey = new TCHAR(0, "IEOOP.Registry\\"+userID+"\\CLSID."+gid, true); //$NON-NLS-1$
    	//If not, do register with this CLSID
	    /**
	     * On Vista, it is not allowed to register to HKEY_CLASS_ROOT as normal process.
	     * The fix is to register all the class  ID to HKCU\Software\Classes\CLSID, and 
	     * put IEOOP.registery to HKCU\IEOOP.registery.
	     * 
	     * To keep backword compatibility, we still check  HKCR.
	     */
        int[] phk = new int[1];  
        int ret;
        ret=OS.RegOpenKeyEx(OS.HKEY_CURRENT_USER, lpSubKey, 0, OS.KEY_READ, phk);
        if (0 ==ret ){
        	 TCHAR lpData = new TCHAR(0, 1024);
        	 TCHAR lpValueName = new TCHAR(0, "", true); //$NON-NLS-1$
             int[] lpcbData = {1024};             
             if(0== OS.RegQueryValueEx(phk[0], lpValueName, 0, null, lpData, lpcbData)){
             	IEOOPClsID[gid] = lpData.toString(0, lpData.strlen());
             	Logging.logp(Level.FINEST,_packageName, _clazzName, "getIEOOPCLSID", //$NON-NLS-1$
             			"At HKEY_CURRENT_USER, get the exist clsid for gid " + gid + ": " + IEOOPClsID[gid]);	//$NON-NLS-1$
            	//exist, true
                OS.RegCloseKey (phk [0]);             	
            	return true;
             }
             OS.RegCloseKey (phk [0]);
        }   
        ret=OS.RegOpenKeyEx(OS.HKEY_CLASSES_ROOT, lpSubKey, 0, OS.KEY_READ, phk);
        if (0 ==ret ){
        	 TCHAR lpData = new TCHAR(0, 1024);
        	 TCHAR lpValueName = new TCHAR(0, "", true); //$NON-NLS-1$
             int[] lpcbData = {1024};             
             if(0== OS.RegQueryValueEx(phk[0], lpValueName, 0, null, lpData, lpcbData)){
             	IEOOPClsID[gid] = lpData.toString(0, lpData.strlen());
             	Logging.logp(Level.FINEST,_packageName, _clazzName, "getIEOOPCLSID", //$NON-NLS-1$
             			"At HKEY_CLASSES_ROOT, get the exist clsid for gid " + gid + ": " + IEOOPClsID[gid]);	//$NON-NLS-1$
            	//exist, true,for XPD6.1
                OS.RegCloseKey (phk [0]);             	
            	return true;
             }
             OS.RegCloseKey (phk [0]);
        }   
       	return false;
    }
   
    

    
    private boolean checkIEOOPRegistry(int gid){
    	if(bIEOOPRegistered[gid]==true) {
    		return true;
    	}
    	//Check phisical files
    	File ieoop=new File(getJNIPath()+IEOOPEXE);
    	File tlogpsdll=new File(getJNIPath()+TLOGPSDLL);
    	if(ieoop ==null || tlogpsdll==null || (ieoop.exists()==false)||(tlogpsdll.exists()==false)){
			bIEOOPRegistered[gid]=false;
    		return false;
    	}
    	//read CLSID from registry
    	if((false==getIEOOPCLSID(gid)) ||IEOOPClsID[gid].length()<38){
    		//invalid CLSID
    		//Generate new one, the new ID will be registered 
			IEOOPClsID[gid]=COMex.CoCreateGuid();
			Logging.logp(Level.FINEST,_packageName, _clazzName, "checkIEOOPRegistry", //$NON-NLS-1$
					"Generate new clsID for gid " + gid + ": " + IEOOPClsID[gid]);	//$NON-NLS-1$
    	}else{
    		//Search in system registry
    	    TCHAR lpSubKey = new TCHAR(0, "CLSID\\"+IEOOPClsID[gid], true); //$NON-NLS-1$
        	//If not, do register with this CLSID
            int[] phk = new int[1];  
            if (0 == OS.RegOpenKeyEx(OS.HKEY_CLASSES_ROOT, lpSubKey, 0, OS.KEY_READ, phk)){
            	OS.RegCloseKey (phk [0]);
            	//exist, true
            	bIEOOPRegistered[gid]=true;
            	return true;
            }
    	} 
    	//do a self_register if there's no CLSID in registry!
		String [] cmdArray = new String[5];
		cmdArray[0]=getJNIPath()+IEOOPEXE;
		cmdArray[1]="/RegServer";	//$NON-NLS-1$
		cmdArray[2]=IEOOPClsID[gid];		
		cmdArray[3]=getIEOOPUserID();//getJNIPath()+IEOOPEXE;
		cmdArray[4]="" +gid;

		Process process;
		try{
			process=Runtime.getRuntime().exec(cmdArray);
			Logging.logp(Level.FINEST,_packageName, _clazzName, "checkIEOOPRegistry", //$NON-NLS-1$
					"run ieoop.exe to registy COM service for gid= " + gid + ": \n" + IEOOPClsID[gid]);	//$NON-NLS-1$
		}catch(Exception e){
			Logging.logp(Level.WARNING,_packageName, _clazzName, "checkIEOOPRegistry", "", e); //$NON-NLS-1$
	        bIEOOPRegistered[gid]=false;
	    	return false;				
		}
		
		//SPR#YHNN7W4HQ9
		//This thread need to wait above IEOOP register process terminated.
		//There are 2 ways to wait. Way #1 is to use "while(){sleep();}" as below
		//Way #2 is to use a process.waitFor() plug a timer. The timer would require to create a new thread.
		//Per test result on T61 and DesktopPC PentiumD, way #1 is faster than way#2
		//Since way#1 is better than way#2 in both CPU cycles and memory footprint, we adopt way#1
		boolean  bIEOOPTerminated = false;
		int nCountSleep = 0;
		int nCountException = 0;
		while (!bIEOOPTerminated && nCountSleep < 50 && nCountException < 100) {
			try {
				Thread.sleep(100);
				nCountSleep++;
			} catch (InterruptedException e1) {
				//No need to log
//				Logging.logp(Level.FINER,_packageName, _clazzName, "InterruptedException in checkIEOOPRegistry", "", e1); //$NON-NLS-1$
				nCountException++;
			}
			
			try {
				 process.exitValue();
				 bIEOOPTerminated = true;
			} catch (IllegalThreadStateException  e) {
				//No need to log
//				Logging.logp(Level.FINER,_packageName, _clazzName, "IllegalThreadStateException in checkIEOOPRegistry", "", e); //$NON-NLS-1$
			}
		}

		if(!bIEOOPTerminated){
	        bIEOOPRegistered[gid]=false;
	    	return false;				
		}

		//call register!
     	bIEOOPRegistered[gid]=true;
    	return true;

    }
    
    /**
     * check registry of tlogpsdll DLL, which is proxy/stub dll for IlogStg 
     * Will not bring up IEOOP solution if it doesn't exist and can't register.
     * @throws IOException
     */
    private boolean checkILogStgRegistry(){
    	if(bTravelLogRegistered==true){
    		return true;    	
    	}
    	//check registered DLL exist
	    TCHAR lpSubKey = new TCHAR(0, "CLSID\\"+COMex.IID_TlogStg+"\\InProcServer32", true); //$NON-NLS-1$
        int[] phk = new int[1];   
        try{
	        if (0 == OS.RegOpenKeyEx(OS.HKEY_CLASSES_ROOT, lpSubKey, 0, OS.KEY_READ, phk)){
	        	 TCHAR lpData = new TCHAR(0, 1024);
	        	 TCHAR lpValueName = new TCHAR(0, "", true); //$NON-NLS-1$
	             int[] lpcbData = {1024};             
	             if(0== OS.RegQueryValueEx(phk[0], lpValueName, 0, null, lpData, lpcbData)){
	                 String modal = lpData.toString(0, lpData.strlen());
	                 File f=new File(modal);
	                 OS.RegCloseKey (phk [0]);//close registry
	                 if(f!=null && f.exists()){
	                 	bTravelLogRegistered=true;
	                 	return bTravelLogRegistered;
	                 }

	             }
	             
	        }   
        }catch(Exception e){
        	Logging.logp(Level.WARNING,_packageName, _clazzName, "Exception in checkILogStgRegistry", "", e); //$NON-NLS-1$
        	bTravelLogRegistered=false;	
			return bTravelLogRegistered;
        }
        if(false==bTravelLogRegistered)
        {
			// tlogpsdll isn't registered correctly, run regsvr32.exe  
			try{			
		    	File tlogpsdll=new File(getJNIPath()+TLOGPSDLL);
		    	if(tlogpsdll==null ||(tlogpsdll.exists()==false)){
		    		bTravelLogRegistered=false;
		    		return bTravelLogRegistered;
		    	}				
				String [] cmdArray = new String[3];
				cmdArray[0]="regsvr32";
				cmdArray[1]="/s";
				cmdArray[2]=tlogpsdll.getAbsolutePath();				
				Runtime.getRuntime().exec(cmdArray);		
			}catch(Exception e){
				Logging.logp(Level.SEVERE,_packageName, _clazzName, "Exception in checkILogStgRegistry.regsvr32.exe", "", e); //$NON-NLS-1$
				bTravelLogRegistered=false;	
				return bTravelLogRegistered;
			}
			bTravelLogRegistered=true;
			return bTravelLogRegistered;
		}

    	return bTravelLogRegistered;
    }
    
	protected WebSite constructWebSite(OleFrame f,int style, int gid) {
		
		WebControlSite csite=null;
          			          
		if((style & DOMBrowser.IEOOP_MODE) ==DOMBrowser.IEOOP_MODE ){
			try{
		          if(checkIEOOPRegistry(gid)&& checkILogStgRegistry())
		          	//set Java2 Applet enabled
		          	enabledJava2Applet=true;
		          	//start IEOOP automation
		          	//Dynamic CLSID:
		      		csite= new WebControlSite(f, SWT.NONE, IEOOPClsID[gid],this);
					
				//	csite= new WebControlSite(f, SWT.NONE, "IEOOP.Browser",this);
					/*if (!killProcessRegistered) {
						//register listener
						//TODO: problems when multiple RCP applications share one IEOOP process. It terminates IEOOP causes other applications.					
						registerCloseListener();					
						killProcessRegistered = true;
					}*/
					//Register a MessageFilter to retry "Call was rejected by callee error".
					if(messageFilter == null) {
						messageFilter=new IMessageFilter();
						//We do not check the return value
						COMex.CoRegisterMessageFilter(messageFilter.getAddress());
						
					}
					return csite;
				}catch(SWTException e){
					Control[] children=f.getChildren();
					if(children.length==1){
						Control badSite=children[0];
						if(badSite.isDisposed()!=true){
							badSite.dispose();
						}
					}
					Logging.logp(Level.FINER,_packageName, _clazzName, "constructWebSite", "construct IEOOP mode fail, will fallback", e); //$NON-NLS-1$  //$NON-NLS-2$
					//fall back to normal mode.
				}
		  }
	  
				//default
		enabledJava2Applet=false;
		csite= new WebControlSite(f, SWT.NONE, "Shell.Explorer",this);
		return csite;
	}
	
	public boolean enabledJava2Applet(){
		return enabledJava2Applet;
	}
	
	public void enableContextMenu(boolean enable) {
		checkWidget();
		if (getIE().site != null){
			((WebControlSite) getIE().site).enableContextMenu(enable);
		}
	}

	public SecuritySettings getSecuritySettings() {
		//checkWidget();  //Commented out for SPR#JYLU82G667
		return securitySettings;
	}
	
	public void setAmbientControlFlags(int flags) {
		checkWidget();
		if (getIE().site != null){
			((WebControlSite) getIE().site).setAmbientControlFlags(flags);
		}
	}

	public int getAmbientControlFlags() {
		checkWidget();
		if (getIE().site != null){
			return ((WebControlSite) getIE().site).getAmbientControlFlags();
		}
		
		return 0;    
	}    	
	
	public void addDocumentCompleteListener(DocumentCompleteListener listener) {
		checkWidget();
		if (listener == null) {
			SWT.error(SWT.ERROR_NULL_ARGUMENT);	
		}
		DocumentCompleteListener[] newDocumentCompleteListeners = new DocumentCompleteListener[documentCompleteListeners.length + 1];
		System.arraycopy(documentCompleteListeners, 0, newDocumentCompleteListeners, 0, documentCompleteListeners.length);
		documentCompleteListeners = newDocumentCompleteListeners;
		documentCompleteListeners[documentCompleteListeners.length - 1] = listener;
	}
	
	public void removeDocumentCompleteListener(DocumentCompleteListener listener) {
		checkWidget();
		if (listener == null) {
			SWT.error(SWT.ERROR_NULL_ARGUMENT);
		}
		if (documentCompleteListeners.length == 0) {
			return;
		}
		int index = -1;
		for (int i = 0; i < documentCompleteListeners.length; i++) {
			if (listener == documentCompleteListeners[i]){
				index = i;
				break;
			}
		}
		if (index == -1) {
			return;
		}
		if (documentCompleteListeners.length == 1) {
			documentCompleteListeners = new DocumentCompleteListener[0];
			return;
		}
		DocumentCompleteListener[] newDocumentCompleteListeners = new DocumentCompleteListener[documentCompleteListeners.length - 1];
		System.arraycopy(documentCompleteListeners, 0, newDocumentCompleteListeners, 0, index);
		System.arraycopy(documentCompleteListeners, index + 1, newDocumentCompleteListeners, index, documentCompleteListeners.length - index - 1);
		documentCompleteListeners = newDocumentCompleteListeners;
	}
	
	public void disposeCOMReferences(){
		
		synchronized(_lock_ieoop_process){
			
//		if (WebControlSite.IEOOP_processID == 0 && enabledJava2Applet){
//			return;
//		}
		
		if(this.isDisposed()){
			return;
		} 
		
		if(weakReferenceManager != null){
			weakReferenceManager.disposeFinalizedCOMObjects(this, true);
		}
		
		
//		//iunknownEventArray		 
//        if (iunknownEventArray != null && !iunknownEventArray.isEmpty()) {
//        	for(int i=0;i<iunknownEventArray.size();i++){
//        		JOleEventSink wf = (JOleEventSink) iunknownEventArray.get(i);
//        		if (wf != null) {
//        		//	Logging.logp(Level.WARNING,_packageName, _clazzName,"disposeCOMReferences ","To dispose JOleEventSink :0x"+Integer.toHexString(wf.hashCode()));
//        			wf.dispose();
//        		}
//        	}
//        	iunknownEventArray.clear();		
//        	iunknownEventArray=null;
//        }   
        
//        if (weakReferenceManager != null) {
//			weakReferenceManager.dispose();
//			weakReferenceManager = null;
//		}
//        
//        if (oleEventSinkWeakReferenceManager != null) {
//        	oleEventSinkWeakReferenceManager.dispose();
//        	oleEventSinkWeakReferenceManager = null;
//		}
//		

		} //synchronized(_lock_ieoop_process)
	}	
	/**
	 * Cleanup
	 */
	public void disposeIEWebBrowser() {
        if (isDisposed()) {
            return;
        }
        
       if(systemProxyHelper!=null){
        	systemProxyHelper.removeSysProxyPreferenceChangeListener();  
        	systemProxyHelper=null;
        }		

        if (enabledJava2Applet()){
        	if(nIEOOPBrowserCount>0){
        		nIEOOPBrowserCount--;
        		//decreaseIEOOPBrowserCount(IEOOPProcessGroupID);
        	}
        }
	    else{
	    	if(nIEModeBrowserCount>0)
	    		nIEModeBrowserCount--;
	    }
     
	}
    
    
    public boolean setContent(String content) {
    	if (null == content){
    		return false;
    	}
    	
    	JHTMLDocument doc = (JHTMLDocument) getDocument(); 
       	doc.open();
    	doc.write(content);
    	doc.close();
    	return true;  
    }
    
//    public void addIUnknownSinkReference(JOleEventSink eventSink) {
//    	System.out.println("add iunkonwnsink");
//    	checkWidget();
//        if (null == eventSink){
//            return;
//        }
//        
//        if (null == iunknownEventArray){
//            iunknownEventArray = new ArrayList();   
//        }
//        
//        iunknownEventArray.add(eventSink);     
//    }  
//    
	
	IDispatch getDispatchDocument() {
		//put some time checking
		//In some cases of IEOOP mode, the auto doesn't return the disID correctly due to busy
		//do a loop until it returns
		int loopCount = MAX_CIRCLE_COUNT;
		OleAutomation auto = getAutomation();
		if (auto == null) {
			return null;
		}
		int[] rgdispid = auto.getIDsOfNames(new String[]{"Document"});
		while((rgdispid == null)&&(loopCount > 0)){
			rgdispid = auto.getIDsOfNames(new String[]{"Document"});
			--loopCount;
		}
		if (rgdispid == null) {
			return null;
		}
		int dispIdMember = rgdispid[0];
		Variant pVarResult = auto.getProperty(dispIdMember);
		if (pVarResult == null || pVarResult.getType() == COM.VT_EMPTY) {
			return null;
		}
		return pVarResult.getDispatch();
	}
	
	public ITravelLogStg getTravelLog()	{
		if (null == getIE().auto){
			return null;
		}
		
		int[] retVal = new int[1];
		//int rc = new IUnknown(Variant2.getOleAutomationAddress(getIE().auto)).QueryInterface(IServiceProvider.IIDIServiceProvider,retVal);      
		int rc = new IUnknown(Variant2.getOleAutomationAddress(getIE().auto)).QueryInterface(COM.IIDIServiceProvider,retVal);      

		if (rc != COM.S_OK || 0 == retVal[0]){
			return null;
		}
		
		IServiceProvider sp = new IServiceProvider(retVal[0]);
		retVal[0] = 0;
		rc = sp.QueryService(ITravelLogStg.SID_STravelLogCursor,ITravelLogStg.IIDITravelLogStg,retVal);
		sp.Release(); 
		if (rc != COM.S_OK || 0 == retVal[0]){
			return null; 
		}
		
		return new ITravelLogStg(retVal[0]);       
	}
        
 	public HTMLDocument getDocument() {
 		try{
	 		checkWidget();
			IDispatch pDisp = getDispatchDocument();
			if (null == pDisp){
				return null;
			}
			JHTMLDocument d = (JHTMLDocument) IUnknownWrapper.getObject(pDisp);
			if (null == d) {
				IUnknownWrapper wrapper = new IUnknownWrapper(this,pDisp);
				d = new JHTMLDocument(wrapper);
				IUnknownWrapper.putObject(pDisp, d);
			}
			pDisp.Release(); 
			return d;
 		}catch(Exception e){
 			Logging.logp(Level.INFO,_packageName, _clazzName, "getDocument", "NPE", e); //$NON-NLS-1$  //$NON-NLS-2$
 			return null;
 		}
	}
 	
	
	public JHTMLWindow getHTMLWindow() {
		checkWidget();
		JHTMLDocument doc = (JHTMLDocument) getDocument();
		if (null == doc){
			return null;
		}
		
		return doc.getParentWindow();
	}
	
	public String getUserAgent() {
		JHTMLWindow window = getHTMLWindow();
		if (window == null){
			return null;
		}
		
		JNavigator navigator = window.getNavigator();
		if (null == navigator){
			return null;
		}
		
		return navigator.getUserAgent();	
	}
 	
	public int execWB(int cmdID, int nCmdExecOpt, Variant2 inputArgs, Variant2[] outputArgs) {
		checkWidget();
		int addr = Variant2.getOleAutomationAddress(getIE().auto);
		if (0 == addr){
			return COM.E_NOINTERFACE;
		}
		
		int[] ppvObject = new int[1];
		IUnknown unk = new IUnknown(addr);
		int rc = unk.QueryInterface(COM.IIDIOleCommandTarget, ppvObject);
		if (rc != OS.S_OK) {
			return rc;
		}
		
		if (ppvObject[0] == 0) {
			return COM.E_NOINTERFACE;
		}
		
		IOleCommandTarget oct = new IOleCommandTarget(ppvObject[0]);
		VARIANT2 input = (inputArgs != null) ? new VARIANT2(inputArgs) : null;
		VARIANT2 output = (outputArgs != null) ? new VARIANT2() : null;
//		TODO put some time checking
		//In some cases of IEOOP mode, the auto doesn't response due to busy
		//do a loop until it response
		int loopCount=MAX_CIRCLE_COUNT;
		do{
			rc = oct.Exec(COMex.CGID_MSHTML,cmdID,nCmdExecOpt,(input != null) ? input.pData : 0,(output != null) ? output.pData : 0);
			--loopCount;
		}while((rc == ERR_CODE)&&(loopCount > 0));
		if (input != null) {
			input.dispose(); 
		}
		oct.Release(); 
		if (rc == COM.S_OK && output != null) {	
			outputArgs[0] = new Variant2();
			outputArgs[0].setData(output.pData);
		}	 
		
		if (output != null) {
			output.dispose();
		}
		 
		return rc; 
	}

	public JHTMLElementFactory getJHTMLElementFactory() {
		checkWidget();
		if(null==elementFactory){
			elementFactory=new JHTMLElementFactory();
		}
		return elementFactory; 
	}	

	public OleAutomation getAutomation() {
		checkWidget();
		return getIE().auto;
	}

	public TranslateAcceleratorListener getTranslateAcceleratorListener() {
		checkWidget();
		return ((WebControlSite)getIE().site).getTranslateAcceleratorListener();
	}

	public void setTranslateAcceleratorListener(TranslateAcceleratorListener l) {
		checkWidget();
		((WebControlSite)getIE().site).setTranslateAcceleratorListener(l);
	}
	
	public void checkWidget() {
		super.checkWidget();
	}
	
	public int[] getOffsets(HTMLElement element) {
		
		int[] offsets = new int[]{0,0};
		if (element != null) {
			offsets[0] = ((JHTMLElement)element).getOffsetLeft();
			offsets[1] = ((JHTMLElement)element).getOffsetTop();
		}
		
		return offsets;
	}
	
	boolean navigate(String url, String postData, String[] headers, boolean silent) {
		int count = 1;
		if (postData != null) count++;
		if (headers != null) count++;
		Variant[] rgvarg = new Variant[count];
		int[] rgdispidNamedArgs = new int[count];
		OleAutomation auto = getAutomation();
		int[] rgdispid = auto.getIDsOfNames(new String[] { "Navigate", "URL", "PostData", "Headers" }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
		int loopCount = MAX_CIRCLE_COUNT;
		while((rgdispid == null)&&(loopCount>0)){
			rgdispid = auto.getIDsOfNames(new String[] { "Navigate", "URL", "PostData", "Headers" }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			--loopCount;
		}
		if (rgdispid == null){
			return false;
		}
		int index = 0;
		rgvarg[index] = new Variant(url);
		rgdispidNamedArgs[index++] = rgdispid[1];
		if (postData != null) {
			rgvarg[index] = IE.createSafeArray(postData);
			rgdispidNamedArgs[index++] = rgdispid[2];
		}
		
		if (headers != null) {
			StringBuffer buffer = new StringBuffer();
			for (int i = 0; i < headers.length; i++) {
				String current = headers[i];
				if (current != null) {
					int sep = current.indexOf(':');
					if (sep != -1) {
						String key = current.substring(0, sep).trim();
						String value = current.substring(sep + 1).trim();
						if (key.length() > 0 && value.length() > 0) {
							buffer.append(key);
							buffer.append(':');
							buffer.append(value);
							buffer.append("\r\n");
						}
					}
				}
			}
			rgvarg[index] = new Variant(buffer.toString());
			rgdispidNamedArgs[index++] = rgdispid[3];
		}
		boolean oldValue = false;
		if (silent && !OS.IsWinCE && IE.IEVersion>= 7) {
			int hResult = OS.CoInternetIsFeatureEnabled(OS.FEATURE_DISABLE_NAVIGATION_SOUNDS, OS.GET_FEATURE_FROM_PROCESS);
			oldValue = hResult == COM.S_OK;
			OS.CoInternetSetFeatureEnabled(OS.FEATURE_DISABLE_NAVIGATION_SOUNDS, OS.SET_FEATURE_ON_PROCESS, true);
		}
		Variant pVarResult = auto.invoke(rgdispid[0], rgvarg, rgdispidNamedArgs);
		loopCount = MAX_CIRCLE_COUNT;
		if(pVarResult==null){
			try{
				while(pVarResult == null&&(loopCount>0)){
					if((url.toLowerCase().indexOf("file:")==0)||(url.toLowerCase().indexOf("ftp:")==0)||(url.trim().indexOf(":")==1)){
						break;
					}
					pVarResult = auto.invoke(rgdispid[0], rgvarg, rgdispidNamedArgs);
					--loopCount;
				}
			}catch(Exception e){
				Logging.logp(Level.WARNING,_packageName, _clazzName, "navigate(url,silent)", "pVarResult error.", e); //$NON-NLS-1$  //$NON-NLS-2$
			}
		}
		if (silent && !OS.IsWinCE && IE.IEVersion>= 7) {
			OS.CoInternetSetFeatureEnabled(OS.FEATURE_DISABLE_NAVIGATION_SOUNDS, OS.SET_FEATURE_ON_PROCESS, oldValue);
		}
		for (int i = 0; i < count; i++) {
			rgvarg[i].dispose();
		}
		if (pVarResult == null) return false;
		boolean result = pVarResult.getType() == OLE.VT_EMPTY;
		pVarResult.dispose();
		return result;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.swt.browser.Browser#setUrl(java.lang.String)
	 */
	public boolean setUrl (String url) {
		return setUrl(url, null, null);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.swt.browser.Browser#setUrl(java.lang.String, java.lang.String, java.lang.String[])
	 */
	public boolean setUrl(String url, String postData, String[] headers) {

		uncRedirect = null;
        	try{
        		
        		checkWidget();
    			if (url == null) {
    				SWT.error(SWT.ERROR_NULL_ARGUMENT);
    			}
    			OleAutomation auto = getAutomation();
				if (auto == null) {
					return false;
				}
				
				/*
				* If the browser has not shown any content yet then first navigate to
				* about:blank to work around IE bug http://support.microsoft.com/kb/320153,
				* then navigate to the requested url once about:blank has loaded.
				*/
				if (_getUrl().length() == 0 && !ABOUT_BLANK.equalsIgnoreCase(url)) {

					getIE().pendingText = null;
					getIE().pendingUrl = new Object[] {url, postData, headers};
					getIE().performingInitialNavigate = true;
					getIE().navigate (ABOUT_BLANK, null, null, true);
					return true;
				}
    			getIE().html = null;
    			if (url.endsWith(".xml")) {	//$NON-NLS-1$  		
    				int[] rgdispid = auto.getIDsOfNames(new String[] { "Stop" }); //$NON-NLS-1$
    				auto.invoke(rgdispid[0]);
    			}

    			return navigate(url,postData, headers, false);
        	}catch(Exception e){
        		Logging.logp(Level.WARNING,_packageName, _clazzName, "setUrl", "", e); //$NON-NLS-1$
        	}
    	return false;		
	}
	
	
	String _getUrl() {
		int[] rgdispid = getAutomation().getIDsOfNames(new String[] { "LocationURL" }); //$NON-NLS-1$
		Variant pVarResult = getAutomation().getProperty(rgdispid[0]);
		if (pVarResult == null || pVarResult.getType() != OLE.VT_BSTR) return ""; //$NON-NLS-1$
		String result = pVarResult.getString();
		pVarResult.dispose();
		return result;
	}
	
	/**
	 * Not activated
	 * @author wuhaijie
	 *
	 * TODO To change the template for this generated type comment go to
	 * Window - Preferences - Java - Code Style - Code Templates
	 */
	/*
	private void registerCloseListener() {
		if (PlatformUI.isWorkbenchRunning())
			PlatformUI.getWorkbench().addWindowListener(new IWindowListener() {
				public void windowActivated(IWorkbenchWindow arg0) {

				}	

				public void windowDeactivated(IWorkbenchWindow arg0) {

				}	

				public void windowClosed(IWorkbenchWindow arg0) {
					if (PlatformUI.getWorkbench().getWorkbenchWindowCount()<=1)
						killIEOOP();
				}

				public void windowOpened(IWorkbenchWindow arg0) {

				}
			});
	}
*/
	
	public boolean queryCommandEnabled(String name) {
		OleAutomation auto = getAutomation();
		if (auto == null){
			return false;
		}
		int addr = Variant2.getOleAutomationAddress(auto);
		if (addr == 0){
			return false;
		}

		int[] ppvObject = new int[1];
		IUnknown unk = new IUnknown(addr);
		int rc = unk.QueryInterface(COM.IIDIOleCommandTarget, ppvObject);
		if (rc != OS.S_OK){
			if (enabledJava2Applet && rc==0x8001010D){ /* Run-time error '-2147417843 (8001010D)':
														* Automation error
														* An outgoing call cannot be made since the application
														* is dispatching an input-synchronous call. 
														* For spr: WDXW785DYF 
														* */
				return true;
			}
			return false;
		}

		if (ppvObject[0] == 0){
			return false;
		}

		IOleCommandTarget oct = new IOleCommandTarget(ppvObject[0]);
		int cmdID;
		if ("copy".equalsIgnoreCase(name)){		//$NON-NLS-1$
			cmdID = 15; // IDM_COPY
		}
		else if ("cut".equalsIgnoreCase(name)){		//$NON-NLS-1$
			cmdID = 16; // IDM_CUT
		}
		else if ("delete".equalsIgnoreCase(name)){		//$NON-NLS-1$
			cmdID = 17; // IDM_DELETE
		}
		else if ("paste".equalsIgnoreCase(name)){		//$NON-NLS-1$
			cmdID = 26; // IDM_PASTE
		}
		else if ("selectall".equalsIgnoreCase(name)){		//$NON-NLS-1$
			cmdID = 31; // IDM_SELECTALL
		}
		else if ("unselect".equalsIgnoreCase(name)){		//$NON-NLS-1$
			cmdID = 2007; // IDM_CLEARSELECTION
		}
		else if("find".equalsIgnoreCase(name)){            //$NON-NLS-1$
			cmdID = 67;//IDM_FIND
		}
		else{
			return false;
		}

		OLECMD cmd = new OLECMD();
		cmd.cmdID = cmdID;
		rc = oct.QueryStatus(COMex.CGID_MSHTML, 1, cmd, null);
		oct.Release();
		if ((cmd.cmdf & 2) != 0){ // check OLECMDF_ENABLED
			return true;
		}

		return false;
	}
	
	/*
	 * Set IE Internet Options Languages for current locale.
	 */
	public void setIEInternetOptions() {
		String languages = ""; //$NON-NLS-1$

		TCHAR lpSubKey = new TCHAR(0,
				"Software\\Microsoft\\Internet Explorer\\International", true); //$NON-NLS-1$
		TCHAR lpValueName = new TCHAR(0, "AcceptLanguage", true); //$NON-NLS-1$
		TCHAR lpData = new TCHAR(0, 1024);

		int[] lpcbData = { 1024 };
		int[] phk = new int[1];

		int rc = OS.RegOpenKeyEx(OS.HKEY_CURRENT_USER, lpSubKey, 0,
				OS.KEY_READ, phk);
		if (rc == 0) {
			rc = OS.RegQueryValueEx(phk[0], lpValueName, 0, null, lpData,
					lpcbData);
		}
		if (rc == 0) {
			languages = lpData.toString(0, lpData.strlen());
		}

		// debug(lpSubKey.toString() + "\\" + lpValueName.toString() + " = " +
		// languages + " - rc: " + rc); //DEBUG

		// Prepend current locale to preference string
		languages = prependLocale(languages);

		lpData = new TCHAR(0, languages, true);
		lpcbData[0] = lpData.strlen();

		// The org.eclipse.swt.internal.win32.OS class allows the registry to be
		// read but not written.
		// TODO Need new SWT function or custom native code to write win32
		// registry keys.

		// rc = OS.RegSetValueEx(phk[0], lpValueName, 0, null, lpData,
		// lpcbData);

		// debug(lpSubKey.toString() + "\\" + lpValueName.toString() + " = " +
		// languages + " - rc: " + rc); //DEBUG

		OS.RegCloseKey(phk[0]);
	}
	
	private String prependLocale(String langStr) {
		Locale locale = Locale.getDefault();

		// debug("locale: " + locale);

		String newLang = locale.toString().toLowerCase();
		String langPart = ""; //$NON-NLS-1$

		StringTokenizer tok = new StringTokenizer(newLang, "_"); //$NON-NLS-1$

		while (tok.hasMoreTokens()) {
			if (!"".equals(langPart)){	//$NON-NLS-1$
				langPart += "-";  //$NON-NLS-2$
			}

			langPart += tok.nextToken();

			langStr = prepend(langPart, langStr);
		}

		return langStr;
	}
	
	private String prepend(String repstr, String oldstr) {
		String newstr = ""; //$NON-NLS-1$

		StringTokenizer tok = new StringTokenizer(oldstr, ","); //$NON-NLS-1$

		while (tok.hasMoreTokens()) {
			String curstr = tok.nextToken().trim();

			if (!repstr.equals(curstr)) {
				if (!"".equals(newstr)){	//$NON-NLS-1$
					newstr += ",";  //$NON-NLS-2$
				}

				newstr += curstr;
			}
		}

		if (!"".equals(newstr)){	//$NON-NLS-1$
			newstr = "," + newstr;  //$NON-NLS-2$
		}

		newstr = repstr + newstr;

		return newstr;
	}
	 
	public boolean setProxy(BrowserProxyInfo proxyInfo) {
		hasBrowserOwnProxy = setProxy(proxyInfo, false);
		if(!hasBrowserOwnProxy){
			Logging.logp(Level.FINER, _packageName, _clazzName, "setProxy", //$NON-NLS-1$
					"Fail to set proxy"); //$NON-NLS-1$

		}
		return hasBrowserOwnProxy;
	}
	
	
	boolean setProxy(BrowserProxyInfo proxyInfo, boolean useCurrentSystemProxy){
		/*
		 * If useCurrentSystemProxy is true, and component has it's own proxy setting,
		 * then using the component's own proxy setting, not set the system proxy.
		 * Return directly.
		 */ 
		if(useCurrentSystemProxy){
			if(hasBrowserOwnProxy){
				return false;
			}
		}
		if (proxyInfo == null){
			Logging.logp(Level.FINER, _packageName, _clazzName, "setProxy", //$NON-NLS-1$
			"proxyInfo == null"); //$NON-NLS-1$
			return false;
		}

		int rc = -1;
		String autoconfigURL = null;
		String proxy = null;
		String httpProxy = null;
		String ftpProxy = null;
		String gopherProxy = null;
		String sslProxy = null;
		String socksProxy = null;
		String proxyByPass = null;

		int proxyType=proxyInfo.getProxyType();
		switch(proxyType){
		case BrowserProxyInfo.proxy_USE_IE_SETTING: 
			/*
			 * when using this type, do not invoke native setproxy method.
			 * It will take external IE browser's proxy setting if no any proxy is set. 
			 */
			rc=0;
			break;
		case BrowserProxyInfo.PROXY_NOPROXY:
			if(enabledJava2Applet){
				// use "" instead of null to clean the proxy in IEOOP 
				rc = ((WebControlSite) getIE().site).setProxy("", null);
			}else{
				rc = COMex.SetProxy(null, null, null);
			}
			if(rc < 0 ){
				Logging.logp(Level.FINER, _packageName, _clazzName, "setProxy", //$NON-NLS-1$
				"PROXY_NOPROXY"); //$NON-NLS-1$
			}
			break;
		case BrowserProxyInfo.PROXY_AUTOCONFIG:
			autoconfigURL=proxyInfo.getAutoConfigURL();
			if(autoconfigURL!=null && autoconfigURL.length()!=0){
				// Fix the bug of auto proxy config url malfunction when it start with: "file:///"
				// Fix for spr: ZPEG7E659A
				String fileString="file:///";
				if(autoconfigURL.startsWith(fileString)){
					autoconfigURL="file://"+autoconfigURL.substring(fileString.length());
				}
				if(enabledJava2Applet){
					rc = ((WebControlSite) getIE().site).setProxy(autoconfigURL, "$");
				}else{
					rc = COMex.SetProxy(autoconfigURL, null, null);
				}
			}else{
				rc = -1;
			}
			if(rc < 0 ){
				Logging.logp(Level.FINER, _packageName, _clazzName, "setProxy", //$NON-NLS-1$
				"PROXY_AUTOCONFIG"); //$NON-NLS-1$
			}
			break;
		case BrowserProxyInfo.PROXY_MANUAL_SET:
			proxy = proxyInfo.getProxy();
			if (proxy == null || proxy.length()==0) {
				httpProxy = proxyInfo.getHTTPProxy();
				if (httpProxy != null && httpProxy.length()>0){
					proxy = httpProxy;
				}

				ftpProxy = proxyInfo.getFTPProxy();
				if (ftpProxy != null && ftpProxy.length()>0) {
					if (proxy == null || proxy.length()==0){
						proxy = ftpProxy;
					}
					else{
						proxy = proxy + ";" + ftpProxy;
					}
				}
				gopherProxy = proxyInfo.getGopherProxy();
				if (gopherProxy != null && gopherProxy.length()>0) {
					if (proxy == null || proxy.length()==0){
						proxy = gopherProxy;
					}
					else{
						proxy = proxy + ";" + gopherProxy;
					}
				}
				sslProxy = proxyInfo.getSSLProxy();
				if (sslProxy != null && sslProxy.length()>0) {
					if (proxy == null || proxy.length()==0){
						proxy = sslProxy;
					}
					else{
						proxy = proxy + ";" + sslProxy;
					}
				}
				socksProxy = proxyInfo.getSocksProxy();
				if (socksProxy != null && socksProxy.length()>0) {
					if (proxy == null || proxy.length()==0){
						proxy = socksProxy;
					}
					else{
						proxy = proxy + ";" + socksProxy;
					}
				}
			}
			proxyByPass = proxyInfo.getProxyByPass();
			proxyByPass = getProperProxyByPass(proxyByPass, "|", ";");
			if (proxyByPass != null && proxyByPass.length() == 0){
				proxyByPass = null;
			}
			// set proxy
			if(enabledJava2Applet){
				rc = ((WebControlSite) getIE().site).setProxy(proxy, proxyByPass);
			}else{
				rc = COMex.SetProxy(null, proxy, proxyByPass);
			}
			if(rc < 0 ){
				Logging.logp(Level.FINER, _packageName, _clazzName, "setProxy", //$NON-NLS-1$
				"PROXY_MANUAL_SET"); //$NON-NLS-1$
			}
		}
		
		if (rc >= 0){
			return true;
		}else{
			return false;
		}
	}
	/*
	 * Get external IE's proxy setting
	 */
	BrowserProxyInfo getIEProxySetting(){
		String strProxy=COMex.getProxy();
		/* examples: 
		 * 1
		 * 2::file:///mypac.pac
		 * 4::server=wtiisa.westford5.notesdev.ibm.com:8080 proxyByPass=www.baidu.com;www.google.cn
		 * 4::server=ftp=wtiisa.westford5.notesdev.ibm.com:8080;http=wtiisa.westford5.notesdev.ibm.com:8080;
		 * https=wtiisa.westford5.notesdev.ibm.com:8080 proxyByPass=www.baidu.com;www.google.cn;<local>
		 */
		// Parse the proxy string get from COMex
		if(strProxy==null){
			return null;
		}
		BrowserProxyInfo info=new BrowserProxyInfo();
		// direct connection
		if(strProxy.equalsIgnoreCase("1")){
			info.setProxyType(BrowserProxyInfo.PROXY_NOPROXY);
			return info;
		}
		// auto config url
		if(strProxy.startsWith("2::")){
			String configUrl=strProxy.substring("2::".length());
			info.setProxyType(BrowserProxyInfo.PROXY_AUTOCONFIG);
			info.setAutoconfigURL(configUrl);
			return info;
		}
		// manual proxy setting
		if(strProxy.startsWith("4::")){
			int indexServer=strProxy.indexOf("server=");
			int indexProxyByPass=strProxy.indexOf("proxyByPass=");
			String proxyServer = null;
			String proxyByPass = null;
			if(indexProxyByPass == -1){
				proxyServer=strProxy.substring(indexServer+"server=".length());
				proxyByPass="";
			}else{
				proxyServer=strProxy.substring(indexServer+"server=".length(), indexProxyByPass-1);
				proxyByPass=strProxy.substring(indexProxyByPass+"proxyByPass=".length());
			}
			info.setProxyType(BrowserProxyInfo.PROXY_MANUAL_SET);
			info.setWholeProxy(proxyServer);
			info.setProxyByPass(proxyByPass);
			return info;
		}
		
		return null;
	}
	private String getProperProxyByPass(String oldProxy, String originalToken, String replacedToken)
	{
		if(oldProxy!=null && oldProxy.length()!=0)
		{
			// trim and clean up with ""
			oldProxy=oldProxy.trim();
			if(oldProxy.startsWith("\"") && oldProxy.length()>1){
				oldProxy=oldProxy.substring(1);				
			}
			if(oldProxy.endsWith("\"") && oldProxy.length()>1){
				oldProxy=oldProxy.substring(0, oldProxy.length()-1);
			}			
			oldProxy=oldProxy.trim();	//trim again afer removing of ""
			
			StringTokenizer st = new StringTokenizer(oldProxy, originalToken);
			String returnStr = new String();
			while (st.hasMoreTokens()) {
				returnStr = returnStr + st.nextToken().trim() + replacedToken;
			}
			return returnStr;
		}
		return oldProxy;
	}
	
	public void releaseDocument(EventTarget htmldoc) {
		if (htmldoc != null && (htmldoc instanceof JHTMLDocument)) {
			JHTMLDocument jDoc = (JHTMLDocument) htmldoc;
			IUnknown i = (IUnknown) jDoc.getIUnknown();
			i.Release();
		}
	}
	
	public String[] initIEHistoryEntry(int index) {
		String[] str = new String[2];
		int rc;
		ITravelLogEntry pTLEntry[] = new ITravelLogEntry[1];
		int circleCount = MAX_CIRCLE_COUNT;
		do {
			--circleCount;
			rc = getTravelLog().GetRelativeEntry(index, pTLEntry);
		} while ((rc == ERR_CODE) && (circleCount > 0));

		tlEntry = pTLEntry[0];
		if(tlEntry!=null){
			String s[] = new String[1];

			tlEntry.GetURL(s);
			str[0] = s[0];

			tlEntry.GetTitle(s);
			str[1] = s[0];
			return str;
		}
		return null;
		
	}
	
	/**
     * Navigate to the web page specified by this history entry.
     */
    public void navigate() {

		int ret = 0;
		int circleCount = MAX_CIRCLE_COUNT;
		do {
			--circleCount;
			ret = getTravelLog().TravelTo(tlEntry);
		} while ((ret == ERR_CODE) && (circleCount > 0));

	}
    
    public void releaseTLEntry()
    {
    	tlEntry.Release();
    }
    
    public int getBackListCount()
    {
        int address[] = new int[1];
        getTravelLog().GetCount(ITravelLogStg.TLEF_RELATIVE_BACK, address);
        
        return address[0];        
    }
    
    public int getForwardListCount()
    {
        int address[] = new int[1];
        getTravelLog().GetCount(ITravelLogStg.TLEF_RELATIVE_FORE, address);
        
        return address[0];        
    }
    
    //Begin to RTE, Yang Zhi Guo    
	/*
	 * Get each attribute value, query form command
	 * added by GuoYun, 06/01/2005
	 */
    public String getCommandValue(String command){
		Variant2 v=null; 
		try{
			v = ((JHTMLDocument)getDocument()).queryCommandValue(command);
			
			switch(v.getType()){
				case COM.VT_BOOL: {
					if (v.getBoolean()) {
						return "true";
					}
					else {
						return "false"; 
					}
				}
				case COM.VT_BSTR:
					return v.getString();
				case COM.VT_I2:
					return String.valueOf(v.getShort());
				case COM.VT_I4:
					return String.valueOf(v.getInt());
				case COM.VT_R4:
					return String.valueOf(v.getFloat());
				default:
					return null;
			}
		}catch (Exception e)
		{
			Logging.logp(Level.WARNING,_packageName, _clazzName, "getCommandValue", "Exception", e); //$NON-NLS-1$  //$NON-NLS-2$
			return null;
		}
	}

	//Support File Download
    FileDownloadListener[] getFileDownloadListeners() {
    	return fileDownloadListeners;
    }

    public void addFileDownloadListener(FileDownloadListener aFileDownloadListener) {
    	checkWidget();
		if (aFileDownloadListener == null) {
			SWT.error (SWT.ERROR_NULL_ARGUMENT);
		}
		FileDownloadListener[] newFileDownloadListeners = new FileDownloadListener[fileDownloadListeners.length + 1];
		System.arraycopy(fileDownloadListeners, 0, newFileDownloadListeners, 0, fileDownloadListeners.length);
		fileDownloadListeners = newFileDownloadListeners;
		fileDownloadListeners[fileDownloadListeners.length - 1] = aFileDownloadListener;
		//enable IEOOP download control
		if (enabledJava2Applet){
			((WebControlSite) getIE().site).enableIEOOPDownloadControl();
		}
    }    
    
    public void removeFileDownloadListener(){
    	checkWidget();
		if (fileDownloadListeners.length == 0) {
			return;
		}
		fileDownloadListeners = new FileDownloadListener[0];
    }
    
    public void removeFileDownloadListener(FileDownloadListener aFileDownloadListener){
    	checkWidget();
		if (aFileDownloadListener == null) {
			SWT.error(SWT.ERROR_NULL_ARGUMENT);
		}
		if (fileDownloadListeners.length == 0) {
			return;
		}
		int index = -1;
		for (int i = 0; i < fileDownloadListeners.length; i++) {
			if (aFileDownloadListener == fileDownloadListeners[i]){
				index = i;
				break;
			}
		}
		if (index == -1) return;
		if (fileDownloadListeners.length == 1) {
			fileDownloadListeners = new FileDownloadListener[0];
			return;
		}
		FileDownloadListener[] newFileDownloadListeners = new FileDownloadListener[fileDownloadListeners.length - 1];
		System.arraycopy(fileDownloadListeners, 0, newFileDownloadListeners, 0, index);
		System.arraycopy(fileDownloadListeners, index + 1, newFileDownloadListeners, index, fileDownloadListeners.length - index - 1);
		fileDownloadListeners = newFileDownloadListeners;
    }
	//End Support File Download

    
    public boolean setCookie2(String cookie, String url){
    	return setCookie2Ex(cookie, url, false);
    }
    
    public boolean setCookie2Ex(String cookie, String url, boolean isHttpOnly){
    	if (url == null || url.length() == 0 || cookie == null)
    		return false;
    	
   		if (enabledJava2Applet){
   			//Set cookie setting for IEOOP
   			return ((WebControlSite) getIE().site).setCookie2(cookie, url, isHttpOnly);
   		} else {
   			int ret = COMex.setCookie(url, cookie, isHttpOnly?1:0);
   			return ret == 0;
   		}    	    		
    }
    
	public String getCookie2(String cookieName, String url) {
		if (url == null || url.length() == 0 || cookieName == null)
    		return null;
		if (enabledJava2Applet){
    		return ((WebControlSite) getIE().site).getCookie2(cookieName, url);
    	} else {
    		return IECookieHelper.getCookie2(cookieName, url);
    	}   	    		

	}
// Commmented out at Wayne and Beths request to get XPD6.3 build out 

//    public int setCookie(String url, String cookie){
//    	if (url != null && url.length() > 0 && cookie != null){    	
//    		if (enabledJava2Applet){
    			//Set cookie setting for IEOOP
//    			return ((WebControlSite) getIE().site).setCookie(url, cookie);
//    		} else {
//    			return COMex.setCookie(url, cookie);
//    		}    	    		
//    	}
//    	return -1;
//    }
    
    public IWebHistory getWebHistory(){
    	if(webHistory==null){
			try {
				webHistory=new IEWebHistory(this);
			} catch (Exception e) {
				Logging.logp(Level.WARNING,_packageName, _clazzName, "getWebHistory", "", e); //$NON-NLS-1$
			}
    	}
    	return (IWebHistory)webHistory;
    }
    private static byte[] _lock_ieoop_process=new byte[0];
    private static final native void killIEOOP(int processID);    
    public static void cleanupOnQuit(){
    	//quit IEOOP process if it is in IEOOP mode
    	Logging.logp(Level.INFO,_packageName, _clazzName, "cleanupOnQuit", "Calling cleanupOnQuit()");
    	
    	/**
    	 * For SPR#KKSS84ZAU9. Post exit message prior to calling TerminateProcess inside killIEOOP(). 
    	 * So that ieoop debug feature can get a chance to log an exit message when closing XPD/Notes directly.
    	 */
   	
    	//    	if((!enabledLegacyMultiProcess && IEOOPClsID.length==1) && WebControlSite.IEOOP_hwnd!=0){ 		
		//    		OS.PostMessage(WebControlSite.IEOOP_hwnd, WebControlSite.IEOOP_WM_DOEXIT, 0, 0);
		//    		WebControlSite.IEOOP_hwnd=0;
		//    	}
    	
    	if((!enabledLegacyMultiProcess)){ 	
    		if(IEOOP_hwnd_Map.size()>0){
    			Iterator<Integer> hwnds = IEOOP_hwnd_Map.values().iterator();
        		while(hwnds.hasNext()){
        			int hwnd=hwnds.next();
        			if(hwnd !=0){
    					OS.PostMessage(hwnd, WebControlSite.IEOOP_WM_DOEXIT, 0, 0);
    				}
        		}
    		}
    		IEOOP_hwnd_Map.clear();
    		IEOOP_hwnd_Map=null;
    		WebControlSite.IEOOP_hwnd=0;
    	}
		
		
//    	
//   		if(WebControlSite.IEOOP_processID!=0){
//   			synchronized(_lock_ieoop_process){
//     			killIEOOP(WebControlSite.IEOOP_processID);
//    			WebControlSite.IEOOP_processID=0;
//    		}
//    	}
    }
    
	public void stop() {
		uncRedirect = null;
		if(getAutomation()!=null){
			//don't call this if auto is disposed
			super.stop();
		}
	}
	public String getUrl() {
		if(getAutomation()!=null){
			return super.getUrl();
		}
		return "";
	}
	/**   
     *   @deprecated
     *   Please use boolean setBasicAuthEx(final String host, final int port, final String path,final  boolean isSecure,final  String name, final char[] password) instead.
   
     */
	public boolean setBasicAuthEx(final String host, final int port, final String path,final  boolean isSecure,final  String name, final String password){
		return setBasicAuthEx(  host,   port,   path,   isSecure,   name,  password.toCharArray());
	}
	public boolean setBasicAuthEx(final String host, final int port, final String path,final  boolean isSecure,final  String name, final char[] password){
		if(host==null||host.length()==0){
			return false;
		}
		if(port<0){
			return false;
		}		
		//TODO: IEOOP mode not implemented
		if (enabledJava2Applet){
			//Set cookie setting for IEOOP
			Display.getDefault().syncExec(new Runnable(){

				public void run() {
					bRet=((WebControlSite) getIE().site).setBasicAuthEx(host, port, path,isSecure, name, password);
				}
			});
			return bRet;
		}else{
			int len = password.length;
			char[] passwordHasEnd = new char[len+1];
			System.arraycopy(password,0,passwordHasEnd,0,len);
			passwordHasEnd[len]=0;
			int ret=0;
			/**
			 * return 1, ok
			 * return -1, incorrect input
			 * others, GetLastError();
			 */
			ret= COMex.SetBasicAuthEx(host, port, path,isSecure?1:0, name, passwordHasEnd);
			if(ret==1/*native returns TRUE*/){
				return true;
			}else{
				return false;
			}
		}
	}
	/**   
     *   @deprecated   
     *   Please use boolean setBasicAuth(final String host, final int port, final String path,final  boolean isSecure,final  String name, final char[] password) instead.
     */
	public boolean setBasicAuth(final String host, final int port, final String path,final  boolean isSecure,final  String name, final String password){
		return  setBasicAuth( host,   port,   path,   isSecure,   name,  password.toCharArray());
	}
	public boolean setBasicAuth(final String host, final int port, final String path,final  boolean isSecure,final  String name, final char[] password){

		if(host==null||host.length()==0){
			return false;
		}
		if(port<0){
			return false;
		}
		if(name==null||password==null){
			return false;
		}
		
		if (enabledJava2Applet){
			//Set cookie setting for IEOOP
			Display.getDefault().syncExec(new Runnable(){

				public void run() {
					bRet=((WebControlSite) getIE().site).setBasicAuth(host, port, path,isSecure, name, password);
				}
			});
			return bRet;
		} else {
			try{
				int len = password.length;
				char[] passwordHasEnd = new char[len+1];
				System.arraycopy(password,0,passwordHasEnd,0,len);
				passwordHasEnd[len]=0;
				int ret=-1;		
				/**
				 * isSecure, true to set 1, false to set 0;
				 */
				ret=COMex.SetBasicAuth(host, port, path,isSecure?1:0, name, passwordHasEnd);
				/**
				 * return 1, ok
				 * return -1, incorrect input
				 * others, GetLastError();
				 */
				if(ret==1){
					return true;
				}else{
					Logging.logp(Level.INFO,_packageName, _clazzName, "SetBasicAuth", "Fail to set with error code:"+ret);
					return false;
				}
			}catch(Throwable e){
				Logging.logp(Level.WARNING,_packageName, _clazzName, "SetBasicAuth", "", e); //$NON-NLS-1$
				return false;
			}
		}   


	}
	   public boolean execCommand(String name, boolean showUI, String v) {

		// if command is disabled, then don't execute
		if(!queryCommandEnabled(name)){
			return false;
		}
   		int cmdExecOpt = 0;
       	if (showUI){
       		cmdExecOpt |= 1; // OLECMDEXECOPT_PROMPTUSER
       	}
       	else{
       		cmdExecOpt |= 2; // OLECMDEXECOPT_DONTPROMPTUSER
       	}
       	
   		if ("copy".equalsIgnoreCase(name)){
   			execWB(15, cmdExecOpt, null, null);		// IDM_COPY
   		}
   		else if ("cut".equalsIgnoreCase(name)){
   			execWB(16, cmdExecOpt, null, null);		// IDM_CUT
   		}
   		else if ("delete".equalsIgnoreCase(name)){
   			execWB(17, cmdExecOpt, null, null);		// IDM_DELETE
   		}
   		else if ("paste".equalsIgnoreCase(name)){
   			execWB(26, cmdExecOpt, null, null);		// IDM_PASTE
   		}
   		else if ("selectall".equalsIgnoreCase(name)){
   			execWB(31, cmdExecOpt, null, null);		// IDM_SELECTALL
   		}
   		else if ("unselect".equalsIgnoreCase(name)){
   			execWB(2007, cmdExecOpt, null, null);		// IDM_CLEARSELECTION
   		}
   		else if("find".equalsIgnoreCase(name)){
   			execWB(67, cmdExecOpt, null, null);  //IDM_FIND
   		}
   		else {
   			return false;
   		}

   		return true;
   }
	   
	    public boolean onBeforeUnload(){
	    	//For SPR#KKSS8BGDY4 and SPR#KKSS8FUE9W, check current url before query IE.close() 
    		//The res:// is for some IE internal resource pages, which will not vote NO to closing.
    		//In case of res:// and about:, we should just return true and bypass the getIE().close().
	    	JHTMLDocument doc = (JHTMLDocument) getDocument();
	    	if (doc != null){
	    		String url = doc.getURL();
	    		url = url.toLowerCase();
	    		if ((url != null) && (url.startsWith("res:")))
	    			return true; 
	    		if ((url !=null) && (url.startsWith("about:")) && !(url.startsWith("about:blank")))
	    			return true;
	    	}
	    	
	    	return getIE().close();
	    }
	    
	    
	   public boolean home()
	    {
	        boolean result = false;
	       
	        OleAutomation oa =getAutomation();
	        if (oa == null){
	        	return false;
	        }
	        int ai[] = oa.getIDsOfNames(new String[]{"GoHome"}); //$NON-NLS-1$

	        Variant variant = oa.invoke(ai[0]);

	        // Normal case appears to be variant.getType() == 0
	        if ((variant == null) || (variant.getType() == 0))
	        {
	            result = true;
	        }
	        else
	        {
	            variant.getInt();
	            result = true;
	        }
	 
	    
	        return result;
	    }

	    public void print()
	    {
	      
	            final int IDM_PRINT = 27;

	            this.execWB(IDM_PRINT, 0, null, null);
	    }

	    public void printPreview()
	    {
	       final int IDM_PRINTPREVIEW = 2003;

	       this.execWB(IDM_PRINTPREVIEW, 1, null, null);
	    }
	    
	    public void pageSetup()
	    {   
	    	final int IDM_PAGESETUP = 2004;

	    	this.execWB(IDM_PAGESETUP, 0, null, null);
	    }
	    
	 
	   
	    public Event makeSWTEvent(org.w3c.dom.events.Event domEvent)
	    {
	        int keycode = 0;

	        boolean altkey = false;
	        boolean ctrlkey = false;
	        boolean shiftkey = false;

	        org.eclipse.swt.browser.ie.dom.events.JEvent event_IE =
	        (org.eclipse.swt.browser.ie.dom.events.JEvent)domEvent;

	        keycode = event_IE.getKeyCode();

	        altkey = event_IE.getAltKey();
	        ctrlkey = event_IE.getCtrlLeft();
	        shiftkey = event_IE.getShiftLeft();
	       

	        // Browser independent key event handling
	        int swtkey = keycode;
	        int swtstate = 0;
	        if (altkey)   {
	        	swtstate |= SWT.ALT;
	        }
	        if (ctrlkey)  {
	        	swtstate |= SWT.CTRL;
	        }
	        if (shiftkey) {
	        	swtstate |= SWT.SHIFT;
	        }

	        /*
	         * For the key events of interest, translate keycode
	         * from W3C DOM keycodes (based on Java AWT definitions)
	         * to SWT keycodes.
	         */

	        switch (keycode)
	        {
	          case 0x70:         swtkey = SWT.F1;           break; //KeyEvent.VK_F1
	          case 0x71:         swtkey = SWT.F2;           break; //KeyEvent.VK_F2
	          case 0x72:         swtkey = SWT.F3;           break; //KeyEvent.VK_F3
	          case 0x73:         swtkey = SWT.F4;           break; //KeyEvent.VK_F4
	          case 0x74:         swtkey = SWT.F5;           break; //KeyEvent.VK_F5
	          case 0x75:         swtkey = SWT.F6;           break; //KeyEvent.VK_F6
	          case 0x76:         swtkey = SWT.F7;           break; //KeyEvent.VK_F7
	          case 0x77:         swtkey = SWT.F8;           break; //KeyEvent.VK_F8
	          case 0x78:         swtkey = SWT.F9;           break; //KeyEvent.VK_F9
	          case 0x79:         swtkey = SWT.F10;          break; //KeyEvent.VK_F10
	          case 0x71A:        swtkey = SWT.F11;          break; //KeyEvent.VK_F11
	          case 0x7B:         swtkey = SWT.F12;          break; //KeyEvent.VK_F12
	          case 0x1B:         swtkey = SWT.ESC;          break; //KeyEvent.VK_ESCAPE
	          case 0x24:         swtkey = SWT.HOME;         break; //KeyEvent.VK_HOME
	          case 0x23:         swtkey = SWT.END;          break; //KeyEvent.VK_END
	          case 0x9B:         swtkey = SWT.INSERT;       break; //KeyEvent.VK_INSERT
	          case 0x7F:         swtkey = SWT.DEL;          break; //KeyEvent.VK_DELETE
	          case '\t':         swtkey = SWT.TAB;          break; //KeyEvent.VK_TAB
	          case 0x25:         swtkey = SWT.ARROW_LEFT;   break; //KeyEvent.VK_LEFT
	          case 0x27:         swtkey = SWT.ARROW_RIGHT;  break; //KeyEvent.VK_RIGHT
	          case 0x28:         swtkey = SWT.ARROW_DOWN;   break; //KeyEvent.VK_DOWN
	          case 0x26:         swtkey = SWT.ARROW_UP;     break; //KeyEvent.VK_UP
	          case 0x22:         swtkey = SWT.PAGE_DOWN;    break; //KeyEvent.VK_PAGE_DOWN
	          case 0x21:         swtkey = SWT.PAGE_UP;      break; //KeyEvent.VK_PAGE_UP
	          case '\b':         swtkey = SWT.BS;           break; //KeyEvent.VK_BACK_SPACE
	          case '\r':         swtkey = SWT.CR;           break;
	        }

	        /*
	         * Construct and return SWT Event object describing the DOM key event
	         */
	        Event swtEvent = new Event();

	        swtEvent.stateMask = swtstate;
	        swtEvent.keyCode = swtkey;

	        swtEvent.character = (char)keycode;
	        swtEvent.text = "KeyText";//java.awt.event.KeyEvent.getKeyText(keycode);

	        swtEvent.widget = this;

	        return swtEvent;
	    }

	    public void stopEvent(org.w3c.dom.events.Event domEvent)
	    {
	   
	            org.eclipse.swt.browser.ie.dom.events.JEvent event_IE =
	            (org.eclipse.swt.browser.ie.dom.events.JEvent)domEvent;

	            event_IE.setKeyCode(0);
	            event_IE.setCancelBubble(true);
	            event_IE.preventDefault();  
	    }
	    
	    public DOMBrowser getBrowser()
	    {
	        return (DOMBrowser)this;
	    }
	    public boolean isMSIE(){
	    	//TODO: please remove me!
	    	return true;
	    }
	       
	    public Browser getBrowserWidget()
	    {
	    	 return (Browser)this;
	 
	    }

	    public static void clearSessions () {	
	     if(enabledLegacyMultiProcess || IEOOPClsID.length > 1){
			Logging.logp(Level.WARNING, _packageName, _clazzName, 
						"DOMBrowser : clearSessions","Do not support clearSessions() in IEOOP multiprocess mode");//$NON-NLS-1$			
	    	 return;
	     }	    	
		 OS.InternetSetOption (0, OS.INTERNET_OPTION_END_BROWSER_SESSION, 0, 0); //clearSession for IE
		
		 if(IEOOPBrowserCountMap.containsKey(0) && IEOOPBrowserCountMap.get(0) > 0 && 
				 IEOOP_hwnd_Map.containsKey(0) && IEOOP_hwnd_Map.get(0)!=0){
			OS.SendMessage(IEOOP_hwnd_Map.get(0), WebControlSite.IEOOP_WM_CLEAR_SESSIONS, 0, 0); //clear session for IEOOP		   		   
		 }else{
			//kill ieoop
			if(IEOOP_hwnd_Map.containsKey(0) && IEOOP_hwnd_Map.get(0) !=0 ){
				OS.PostMessage(IEOOP_hwnd_Map.get(0), WebControlSite.IEOOP_WM_DOEXIT, 0, 0);
				IEOOP_hwnd_Map.put(0, 0);
			}
		 }		 
	 }
	    
	    //this method reads the preference of ieoopmultiprocess/alt+shift language switch from plugin_customization.ini and sets it in the ieoop.ini file to be processed further
	    public void processIeoopIniFile()
	    {
	    	processIeoopIniFileDone = true;
	    	enabledLegacyMultiProcess = Platform.getPreferencesService().getBoolean("com.ibm.rcp.browser.service", "enableIEOOPMultiProcess", false, null);
	    	enabledSwitchLanguageWorkaround = Platform.getPreferencesService().getBoolean("com.ibm.rcp.browser.service", "enableSwitchLanguageWorkaround", false, null);
	     	//set the value in IEOOP.ini
	    	try
			    {
	    		java.io.InputStream is = null;
	    		Bundle bl = Platform.getBundle("com.ibm.rcp.swt.browser.dom.ie");
	    		is = FileLocator.openStream(bl, new Path("os/win32/x86/ieoop.ini"),false);
	    		URL[] arr = FileLocator.findEntries(bl, new Path("/os/win32/x86/ieoop.ini"));
	    		URL IniFileUrl= FileLocator.toFileURL(arr[0]);
	    		String out_filename;
	            if(IniFileUrl.toString().startsWith("file:/"))
	    		 out_filename = IniFileUrl.toString().substring(6, IniFileUrl.toString().length());
	            else
	             out_filename = IniFileUrl.toString();
	      			
	            Properties props = new Properties();
	            props.load( is );
	            is.close();
	            String multiprocess_flag = props.getProperty( "ieoop.enable.multiProcess" );
	            String switchLanguage_flag = props.getProperty( "ieoop.enable.switchLanguageWorkaround" );
       	  
                if( multiprocess_flag!=null && multiprocess_flag.equals(new Boolean(enabledLegacyMultiProcess).toString())
                		&& switchLanguage_flag!=null && switchLanguage_flag.equals(new Boolean(enabledSwitchLanguageWorkaround).toString()))
       	        	return;

	            else if(multiprocess_flag!=null && switchLanguage_flag!=null){
		        	   	String val1 = null;
			            String buffer_newfile= new String();
						DataInputStream dis_out = null;
						is = FileLocator.openStream(bl, new Path("os/win32/x86/ieoop.ini"),false);
						dis_out = new DataInputStream(is);
					   
						int pref_str_len1 = "ieoop.enable.multiProcess".length();
						int pref_str_len2 = "ieoop.enable.switchLanguageWorkaround".length();
					      // dis_out.available() returns 0 if the file does not have more lines.
					    while (dis_out.available() != 0) 
					    {
					    	val1=dis_out.readLine();
					    	if(val1.length()>=pref_str_len1 && val1.substring(0,pref_str_len1).equals("ieoop.enable.multiProcess"))
					    	  	val1="ieoop.enable.multiProcess"+"="+enabledLegacyMultiProcess;
					    	else if(val1.length()>=pref_str_len2 && val1.substring(0,pref_str_len2).equals("ieoop.enable.switchLanguageWorkaround"))
					    		val1="ieoop.enable.switchLanguageWorkaround"+"="+enabledSwitchLanguageWorkaround;
					    	buffer_newfile+=val1+"\n";
			    		 } 
					    is.close();
				  		BufferedWriter out = new BufferedWriter(new FileWriter(out_filename));
			    	   	out.write(buffer_newfile);
			         	out.close(); 
                   }else 
                   {
                	   if (multiprocess_flag==null){
		               		BufferedWriter out = new BufferedWriter(new FileWriter(out_filename, true)); 
		               		out.write("\n## switch for IEOOP single process/multi process\nieoop.enable.multiProcess="+enabledLegacyMultiProcess+"\n");
		               		out.close(); 
                	   }
                	   if (switchLanguage_flag==null){
		               		BufferedWriter out = new BufferedWriter(new FileWriter(out_filename, true)); 
		               		out.write("\n## switch for alt+shift key workaround\nieoop.enable.switchLanguageWorkaround="+enabledSwitchLanguageWorkaround+"\n"); 
		               		out.close(); 
                	   }
                   }
		    	    
				}catch (FileNotFoundException e) 
			    {
					Logging.logp(Level.WARNING, _packageName, _clazzName, 
							"DOMBrowser : FileNotFoundException ", "", e);
			    } 
			    catch (IOException e) 
			    {
			    	Logging.logp(Level.WARNING, _packageName, _clazzName, 
							"DOMBrowser : IOException ", "", e);
				} 

	    }
		public boolean doesSelectionExist() {
			boolean retVal = false;
			try{
				JHTMLDocument htmlDoc = getSelectedHTMLDocument();
				String selType = htmlDoc.getSelection().getType();
				if (selType!=null && selType.equalsIgnoreCase("control")){	//$NON-NLS-1$
					retVal = true;
				}
				else if (selType!=null && selType.equalsIgnoreCase("text")) {	//$NON-NLS-1$
					JHTMLTxtRange txtRange = htmlDoc.getSelection().createRange().getTxtRange().duplicate();
					String strText = txtRange.getHtmlText();
					retVal = (strText != null);	
				}
				return retVal;							
			}catch(Exception e){
				Logging.logp(Level.FINER,_packageName, _clazzName, "doesSelectionExist", //$NON-NLS-1$
					"DOMException:"+e); //$NON-NLS-1$
				return false;
			}				
		}
		
		public String getSelectedText() {
			String sText = null;
			try{
				JHTMLDocument htmlDoc = getSelectedHTMLDocument();
				JHTMLSelection.CreateRangeResult rangeResult = htmlDoc.getSelection().createRange();
				if (rangeResult!=null && rangeResult.isTxtRange()) {
					sText = rangeResult.getTxtRange().getText();
					if(sText!=null && !sText.equalsIgnoreCase("")) {
						HTMLElement parentElement = rangeResult.getTxtRange().parentElement();
						if(parentElement.getNodeName().equalsIgnoreCase("input")) {
							if(parentElement.getAttribute("type").equalsIgnoreCase("password")) {
								char[] pwdStr = new char[sText.length()];
								for(int i=0;i<sText.length();i++) {
									pwdStr[i] = '*';
								}
								return String.valueOf(pwdStr);
							}
						}	
					}
				}
				return sText;
			}catch(Exception e){
				Logging.logp(Level.FINER,_packageName, _clazzName, "getSelectedText", //$NON-NLS-1$
						"DOMException:"+e); //$NON-NLS-1$
				return null;
			}			
		}

		private JHTMLDocument getSelectedHTMLDocument() {
			JHTMLDocument htmlDoc = (JHTMLDocument)getDocument();
			if(htmlDoc != null) {
				// SPR#JYLU8JN6RC, check on iframe and frame
	        	NodeList nodelist = htmlDoc.getElementsByTagName(JHTMLElement.NODE_NAME_HTML_IFRAME);
				for(int i=0; i<nodelist.getLength();i++) {
					JHTMLIFrameElement iframeElement = (JHTMLIFrameElement)nodelist.item(i);
					JHTMLDocument iframeDocument = (JHTMLDocument)iframeElement.getContentDocument();
					if(iframeDocument!=null) {
						JHTMLSelection selection = iframeDocument.getSelection();
						if(selection!=null) {
							String type = selection.getType();
							if(type!=null && !type.equalsIgnoreCase("none")) {
								return iframeDocument;					
							}
						}
					}								
				}
				nodelist = htmlDoc.getElementsByTagName(JHTMLElement.NODE_NAME_HTML_FRAME);
				for(int i=0; i<nodelist.getLength();i++) {
					JHTMLFrameElement frameElement = (JHTMLFrameElement)nodelist.item(i);
					JHTMLDocument frameDocument = (JHTMLDocument)frameElement.getContentDocument();
					if(frameDocument!=null) {
						JHTMLSelection selection = frameDocument.getSelection();
						if(selection!=null) {
							String type = selection.getType();
							if(type!=null && !type.equalsIgnoreCase("none")) {
								return frameDocument;						
							}
						}
					}								
				}
			}			
			return htmlDoc;
		}
		
		/**
		 * SPR PEDSA7QK9P
		 * call setUrl so that sso can be invoked.
		 */
		@Override
		public void refresh() {
			String url = this.getUrl();
			if(url != null && url.trim().length() != 0 && !url.equalsIgnoreCase("about:config") && !url.equalsIgnoreCase("about:blank")) {
				this.ssoURL(url);
			}
			super.refresh();
		}
		
}
