/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *	   Li Ming Zhan(IBM Corp.) Add new JNI interfaces and extend functions
 *******************************************************************************/
#pragma warning( disable : 4090 4047 4024 4133 )

#define VC_EXTRALEAN
#define STRICT
#ifndef _WIN32_WINNT
#define _WIN32_WINNT 0x0400
#endif

#include <windows.h>
#include <urlmon.h>
#include "jni.h"
#include  <Winreg.h>
#include  <Wininet.h>
#include <string.h>
//#include "olestd.h" 
#include "objidl.h"
#include "objbase.h"
#include "Tlhelp32.h"

#define COM_NATIVE(func) Java_org_eclipse_swt_internal_ole_win32_COMex_##func

typedef jint (STDMETHODCALLTYPE *P_OLE_FN_2)(jint, jint);
typedef jint (STDMETHODCALLTYPE *P_OLEF_FN_2)(jint, float);
typedef jint (STDMETHODCALLTYPE *P_OLEV_FN_2)(jint, VARIANT);
typedef jint (STDMETHODCALLTYPE *P_OLE_FN_3)(jint, jint, jint);
typedef jint (STDMETHODCALLTYPE *P_OLEV_FN_3)(jint, jint, VARIANT);
typedef jint (STDMETHODCALLTYPE *P_OLEV_FN_31)(jint, VARIANT, jint);
typedef jint (STDMETHODCALLTYPE *P_OLE_FN_4)(jint, jint, jint, jint);
typedef jint (STDMETHODCALLTYPE *P_OLEV_FN_4)(jint, jint, VARIANT, jint);
typedef jint (STDMETHODCALLTYPE *P_OLEV_FN_41)(jint, VARIANT, VARIANT, jint);
typedef jint (STDMETHODCALLTYPE *P_OLE_FN_5)(jint, jint, jint, jint, jint);
typedef jint (STDMETHODCALLTYPE *P_OLEV_FN_5)(jint, jint, jint, VARIANT, jint);
typedef jint (STDMETHODCALLTYPE *P_OLEV_FN_51)(jint, VARIANT, VARIANT, VARIANT, jint);
typedef jint (STDMETHODCALLTYPE *P_OLE_FN_6)(jint, jint, jint, jint, jint, jint);
typedef jint (STDMETHODCALLTYPE *P_OLEV_FN_6)(jint, jint, VARIANT, VARIANT, VARIANT, jint);
typedef jint (STDMETHODCALLTYPE *P_OLEV_FN_61)(jint, VARIANT, VARIANT, VARIANT, VARIANT, jint);
typedef jint (STDMETHODCALLTYPE *P_OLEV_FN_7)(jint, VARIANT, VARIANT, VARIANT, VARIANT, VARIANT, VARIANT);
typedef jint (STDMETHODCALLTYPE *P_OLE_FN_8)(jint, jint, jint, jint,jint, jint, jint, jint);
typedef jint (STDMETHODCALLTYPE *P_OLE_FN_9)(jint, jint, jint, jint,jint, jint, jint, jint, jint);

#ifndef NO_VARIANT

#ifndef NO_RECT
typedef struct RECT_FID_CACHE {
	int cached;
	jclass clazz;
	jfieldID left, top, right, bottom;
} RECT_FID_CACHE;

RECT_FID_CACHE RECTFc;

void cacheRECTFields(JNIEnv *env, jobject lpObject)
{
	if (RECTFc.cached) return;
	RECTFc.clazz = (*env)->GetObjectClass(env, lpObject);
	RECTFc.left = (*env)->GetFieldID(env, RECTFc.clazz, "left", "I");
	RECTFc.top = (*env)->GetFieldID(env, RECTFc.clazz, "top", "I");
	RECTFc.right = (*env)->GetFieldID(env, RECTFc.clazz, "right", "I");
	RECTFc.bottom = (*env)->GetFieldID(env, RECTFc.clazz, "bottom", "I");
	RECTFc.cached = 1;
}

RECT *getRECTFields(JNIEnv *env, jobject lpObject, RECT *lpStruct)
{
	if (!RECTFc.cached) cacheRECTFields(env, lpObject);
	lpStruct->left = (*env)->GetIntField(env, lpObject, RECTFc.left);
	lpStruct->top = (*env)->GetIntField(env, lpObject, RECTFc.top);
	lpStruct->right = (*env)->GetIntField(env, lpObject, RECTFc.right);
	lpStruct->bottom = (*env)->GetIntField(env, lpObject, RECTFc.bottom);
	return lpStruct;
}

void setRECTFields(JNIEnv *env, jobject lpObject, RECT *lpStruct)
{
	if (!RECTFc.cached) cacheRECTFields(env, lpObject);
	(*env)->SetIntField(env, lpObject, RECTFc.left, (jint)lpStruct->left);
	(*env)->SetIntField(env, lpObject, RECTFc.top, (jint)lpStruct->top);
	(*env)->SetIntField(env, lpObject, RECTFc.right, (jint)lpStruct->right);
	(*env)->SetIntField(env, lpObject, RECTFc.bottom, (jint)lpStruct->bottom);
}
#endif

typedef struct VARIANT_FID_CACHE {
	int cached;
	jclass clazz;
	jfieldID pData;
} VARIANT_FID_CACHE;

VARIANT_FID_CACHE VARIANTFc;

void cacheVARIANTFids(JNIEnv *env, jobject lpObject)
{
	if (VARIANTFc.cached) return;
	VARIANTFc.clazz = (*env)->GetObjectClass(env, lpObject);
	VARIANTFc.pData = (*env)->GetFieldID(env, VARIANTFc.clazz, "pData", "I");
	VARIANTFc.cached = 1;
}

VARIANT *getVARIANTFields(JNIEnv *env, jobject lpObject, VARIANT *lpStruct)
{
	jint p = 0;
	if (!VARIANTFc.cached) cacheVARIANTFids(env, lpObject);
	p = (*env)->GetIntField(env, lpObject, VARIANTFc.pData);
	CopyMemory(lpStruct,(void*) p,sizeof(VARIANT));
	return lpStruct;
}
#endif /* NO_VARIANT */

/*
For IEOOP solution
Not used
*/

static void DoKillProcess( char *szToKill ,int processID)
{
	HANDLE hProcessSnap;
	HANDLE hProcess;
	PROCESSENTRY32 pe32;
	//aleady have processID given, terminate it.
	if(processID!=0){
		hProcess = OpenProcess( PROCESS_ALL_ACCESS, FALSE, processID );	
		if( hProcess != NULL ) {
			TerminateProcess(hProcess, 0);
			CloseHandle( hProcess );
			return;
		}
		
	}
	// Take a snapshot of all processes in the system.
	hProcessSnap = CreateToolhelp32Snapshot( TH32CS_SNAPPROCESS, 0 );
	if( hProcessSnap == INVALID_HANDLE_VALUE )
	{
//		printError( "CreateToolhelp32Snapshot (of processes)" );
		return;
	}
	
	// Set the size of the structure before using it.
	pe32.dwSize = sizeof( PROCESSENTRY32 );
	
	// Retrieve information about the first process,
	// and exit if unsuccessful
	if( !Process32First( hProcessSnap, &pe32 ) )
	{
//		printError( "Process32First" );  // Show cause of failure
		CloseHandle( hProcessSnap );     // Must clean up the snapshot object!
		return;
	}
	
	// Now walk the snapshot of processes, and
	// display information about each process in turn
	do
	{
//		printf("process name:-) %s\n", pe32.szExeFile);
		
		if (_stricmp(pe32.szExeFile, szToKill) == 0) {
			
			hProcess = OpenProcess( PROCESS_ALL_ACCESS, FALSE, pe32.th32ProcessID );
			
			if( hProcess == NULL ) {
//				printError( "OpenProcess" );
				continue;
			}
			
			TerminateProcess(hProcess, 0);
//			printf("----------Killed____________LastError: %d\n", GetLastError());
			CloseHandle( hProcess );
		}
		
	} while( Process32Next( hProcessSnap, &pe32 ) );
	
	CloseHandle( hProcessSnap );
}


JNIEXPORT void JNICALL Java_org_eclipse_swt_browser_DOMBrowser_killIEOOP
(JNIEnv * env, jobject obj_this,jint processID)
{
	DoKillProcess("IEOOP.exe",(int)processID );	
}


/*
setCookie( url, cookieString)
*/
JNIEXPORT  jint  JNICALL COM_NATIVE(setCookie)
  (JNIEnv *env, jclass that, jstring jurl,jstring jcookie, jint jhttponly)
{
	
	DWORD		winerr = 0;
	char		*pTmpOut = NULL;

	const char *strurl = (*env)->GetStringUTFChars(env,jurl, 0);
	const char *strcookie = (*env)->GetStringUTFChars(env,jcookie,0);
	BOOL bCookieCreated = FALSE;
	if(jhttponly == 1)
		bCookieCreated = InternetSetCookieEx(strurl, NULL, strcookie, 8192,0); //8192=INTERNET_COOKIE_HTTPONLY
	else
		bCookieCreated = InternetSetCookie(strurl, NULL, strcookie);

	if	(!bCookieCreated)
		winerr = GetLastError();

	if(strurl)
	{
		(*env)->ReleaseStringUTFChars(env,jurl,strurl);
	}

	if(strcookie)
	{
		(*env)->ReleaseStringUTFChars(env,jcookie,strcookie);
	} 
	if(bCookieCreated==TRUE)
  	    return 0;
	else
		return -1;
}

/*
For IEOOP solution
CoCreateGuid create a new GUID, and write into "IEOOP.cfg" file
*/


JNIEXPORT  jstring  JNICALL COM_NATIVE(CoCreateGuid)
(JNIEnv * env, jclass that)
{
/*
	typedef struct {
    unsigned long  Data1;
    unsigned short Data2;
    unsigned short Data3;
    byte           Data4[ 8 ];
	} GUID;
*/
	// it doesn't work if running inside JVM
	GUID newID;
	jstring ret=NULL;

	HRESULT res=CoCreateGuid(&newID);   

	if(res==S_OK){
			char szBuf[40];
			sprintf_s(szBuf, 40, "{%08x-%04x-%04x-%02x%02x-%02x%02x%02x%02x%02x%02x}",newID.Data1,newID.Data2,newID.Data3,
				newID.Data4[0],newID.Data4[1],newID.Data4[2],newID.Data4[3],
				newID.Data4[4],newID.Data4[5],newID.Data4[6],newID.Data4[7]);

			ret=(*env)->NewStringUTF(env,(const char *)szBuf);	
	}

	return(ret);
}


/*
For IEOOP solution
CoRegisterMessageFilter
*/
JNIEXPORT jint JNICALL COM_NATIVE(CoRegisterMessageFilter)
(JNIEnv * env, jclass that, jint pMessage)
{
	//http://msdn.microsoft.com/library/default.asp?url=/library/en-us/com/html/caa5b277-ddbd-4ba9-892d-590d953b8433.asp
	jint *arg11=NULL;
	// it doesn't work if running inside JVM
	return (jint) CoRegisterMessageFilter((LPMESSAGEFILTER)pMessage, (LPMESSAGEFILTER *)arg11);   
}
/*
 FOR SPR#LHXE6DL9TQ
*/
JNIEXPORT jint JNICALL COM_NATIVE(ChangeInternetSecuritySetting)
  (JNIEnv *env, jclass that, jint arg0, jint arg1, jint arg2)
{
	//arg0: security zone
	//arg1: security id
	//arg2: value
	//
	int result;
	DWORD dwData=arg2;
	TCHAR szBuf[256];
	TCHAR szRegKey[8];

	HKEY hKey;
	wsprintf(szBuf,"SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\Zones\\%d",arg0);
	
	// open reg key
	result=RegOpenKeyEx(HKEY_CURRENT_USER,szBuf,0, KEY_READ|KEY_WRITE,&hKey);
	
	if(result != ERROR_SUCCESS)
	{
			return result;
	}
	//set reg key
	wsprintf(szRegKey,"%04x",arg1);
	result=RegSetValueEx(hKey, szRegKey,0,REG_DWORD,(LPBYTE)&dwData, sizeof(DWORD));

	//close reg key
	RegCloseKey(hKey);

	return result;
}
JNIEXPORT jint JNICALL COM_NATIVE(SetBasicAuthEx__Ljava_lang_String_2ILjava_lang_String_2ILjava_lang_String_2Ljava_lang_String_2)
(JNIEnv *env, jclass that, jstring jhost, jint jport, jstring jpath, jint isSecure, jstring juser, jstring jpassword) {

	DWORD result;
	DWORD closeResult;
	const char * defaultEncoding="Accept-Encoding:     gzip,     deflate\r\n";

	// get native 8-bit char array pointers from 16-bit Java strings
	const char *hostPtr = (*env)->GetStringUTFChars(env,jhost,0);
	const char *pathPtr = (*env)->GetStringUTFChars(env,jpath,0);
	const char *userPtr = (*env)->GetStringUTFChars(env,juser, 0);
	const char *passwordPtr = (*env)->GetStringUTFChars(env,jpassword,0);
	DWORD dwStatus;
	DWORD dwStatusSize = sizeof(dwStatus);
	int totalTry=3,tried=0;
	// open session and create request
	HINTERNET hSession =NULL;
	HINTERNET hConnection =NULL;
	HINTERNET hRequest =NULL ;
	//check input
	if(hostPtr==NULL||userPtr==NULL){
		return -1;
	}
	if((isSecure!=1)&&(isSecure!=0)){
		return -1;
	}
	hSession = InternetOpen("Web Browser", INTERNET_OPEN_TYPE_PRECONFIG , NULL, NULL, 0);
	hConnection = InternetConnect(hSession, hostPtr, (INTERNET_PORT)jport, NULL, NULL, INTERNET_SERVICE_HTTP, 0, 0);
	if(isSecure==1){
		//https
		hRequest= HttpOpenRequest(hConnection, "GET", pathPtr, "", "", 0, INTERNET_FLAG_RELOAD | INTERNET_FLAG_KEEP_CONNECTION|INTERNET_FLAG_SECURE, 0);
	}else if(isSecure==0){
		//http
		hRequest= HttpOpenRequest(hConnection, "GET", pathPtr, "", "", 0, INTERNET_FLAG_RELOAD | INTERNET_FLAG_KEEP_CONNECTION, 0);
	}
	InternetSetOption(hRequest, 
							  INTERNET_OPTION_PROXY_USERNAME, 
							  userPtr, 
							  strlen(userPtr)+1);
	InternetSetOption(hRequest, 
							  INTERNET_OPTION_PROXY_PASSWORD, 
							  passwordPtr, 
							  strlen(passwordPtr)+1);
	//resend 3 times if failed
FailReset:
	// send request.  do not care about the result since purpose is only to get the credentials cached.	
	result = HttpSendRequest(hRequest, NULL, 0, NULL, 0);
	if(result==TRUE){
		//noop
	}else{
		result=GetLastError();

	}
	if(result>=ERROR_INTERNET_SEC_CERT_DATE_INVALID&& result<=ERROR_INTERNET_SEC_CERT_REV_FAILED){
		//CA error
		DWORD dwFlags;
		DWORD dwBuffLen = sizeof(dwFlags);
		InternetQueryOption (hRequest, INTERNET_OPTION_SECURITY_FLAGS,
		(LPVOID)&dwFlags, &dwBuffLen);
		
		dwFlags |= SECURITY_FLAG_IGNORE_UNKNOWN_CA;
		dwFlags |= SECURITY_FLAG_IGNORE_CERT_CN_INVALID;
		dwFlags |= SECURITY_FLAG_IGNORE_CERT_DATE_INVALID;
		InternetSetOption (hRequest, INTERNET_OPTION_SECURITY_FLAGS,
						&dwFlags, sizeof (dwFlags) );
		goto FailReset;
	}
	result=HttpQueryInfo(hRequest, HTTP_QUERY_FLAG_NUMBER | 
              HTTP_QUERY_STATUS_CODE, &dwStatus, &dwStatusSize, NULL);
	
	switch (dwStatus)
	{		
		case HTTP_STATUS_DENIED:     // Server Authentication Required.
			InternetSetOption(hRequest, 
							  INTERNET_OPTION_USERNAME, 
							  userPtr, 
							  strlen(userPtr)+1);
			InternetSetOption(hRequest, 
							  INTERNET_OPTION_PASSWORD, 
							  passwordPtr, 
							  strlen(passwordPtr)+1);

			if(tried<totalTry){
				tried++;
				goto FailReset;
			}else{
				result= HTTP_STATUS_DENIED;
			}
			break;
		case HTTP_STATUS_PROXY_AUTH_REQ://Proxy Auth request
			InternetSetOption(hRequest, 
							  INTERNET_OPTION_PROXY_USERNAME, 
							  userPtr, 
							  strlen(userPtr)+1);
			InternetSetOption(hRequest, 
							  INTERNET_OPTION_PROXY_PASSWORD, 
							  passwordPtr, 
							  strlen(passwordPtr)+1);

			if(tried<totalTry){
				tried++;
				goto FailReset;
			}else{
				result= HTTP_STATUS_DENIED;
			}
			break;
		case HTTP_STATUS_SERVER_ERROR:	//internal server error, try with "Accept-Encoding"
			HttpAddRequestHeaders(hRequest, defaultEncoding,  
				-1,     HTTP_ADDREQ_FLAG_ADD|HTTP_ADDREQ_FLAG_REPLACE);   
			if(tried<totalTry){
				tried++;
				goto FailReset;
			}else{
				result= HTTP_STATUS_DENIED;
			}
			break;
	}

	// close wininet HINTERNET handles

	if (hRequest) {
		closeResult=InternetCloseHandle(hRequest);
	}
	if (hConnection) {
		closeResult=InternetCloseHandle(hConnection);
	}
	if (hSession) {
		closeResult=InternetCloseHandle(hSession);
	}

	// release Java strings
	if(userPtr)	{
		(*env)->ReleaseStringUTFChars(env,juser,userPtr);
	}
	if(passwordPtr)	{
		(*env)->ReleaseStringUTFChars(env,jpassword,passwordPtr);
	} 
	if(hostPtr) {
		(*env)->ReleaseStringUTFChars(env,jhost,hostPtr);
	} 
	if(pathPtr) {
		(*env)->ReleaseStringUTFChars(env,jpath,pathPtr);
	} 

	if(result!=TRUE&&result!=HTTP_STATUS_DENIED){
		result=GetLastError();
	}
	return result;
}


JNIEXPORT jint JNICALL COM_NATIVE(SetBasicAuthEx__Ljava_lang_String_2ILjava_lang_String_2ILjava_lang_String_2_3C)
(JNIEnv *env, jclass that, jstring jhost, jint jport, jstring jpath, jint isSecure, jstring juser, jcharArray jpassword) {

	DWORD result;
	DWORD closeResult;
	const char * defaultEncoding="Accept-Encoding:     gzip,     deflate\r\n";

	DWORD dwStatus;
	DWORD dwStatusSize = sizeof(dwStatus);
	int totalTry=3,tried=0;
	// open session and create request
	HINTERNET hSession =NULL;
	HINTERNET hConnection =NULL;
	HINTERNET hRequest =NULL ;
	// get native 8-bit char array pointers from 16-bit Java strings
	const char *hostPtr = (*env)->GetStringUTFChars(env,jhost,0);
	const char *pathPtr = (*env)->GetStringUTFChars(env,jpath,0);
	const char *userPtr = (*env)->GetStringUTFChars(env,juser, 0);
	//const char *passwordPtr = (*env)->GetStringUTFChars(env,jpassword,0);
	jchar *jpasswordPtr = (*env)->GetCharArrayElements(env, jpassword, NULL);
	wchar_t* wpasswordPtr = jpasswordPtr;
	const char* passwordPtr;
	int size = 0;
	int length = wcslen(wpasswordPtr);
	char* passwordPtrTemp = (char*)malloc( 2*length+1 );
	size = WideCharToMultiByte( CP_ACP, 0, (LPCWSTR)wpasswordPtr, length, passwordPtrTemp,(2*length+1), NULL, NULL );
	if( size <= 0 )
		return NULL;
	passwordPtrTemp[size] = 0;
	passwordPtr = passwordPtrTemp;

	//check input
	if(hostPtr==NULL||userPtr==NULL){
		return -1;
	}
	if((isSecure!=1)&&(isSecure!=0)){
		return -1;
	}
	hSession = InternetOpen("Web Browser", INTERNET_OPEN_TYPE_PRECONFIG , NULL, NULL, 0);
	hConnection = InternetConnect(hSession, hostPtr, (INTERNET_PORT)jport, NULL, NULL, INTERNET_SERVICE_HTTP, 0, 0);
	if(isSecure==1){
		//https
		hRequest= HttpOpenRequest(hConnection, "GET", pathPtr, "", "", 0, INTERNET_FLAG_RELOAD | INTERNET_FLAG_KEEP_CONNECTION|INTERNET_FLAG_SECURE, 0);
	}else if(isSecure==0){
		//http
		hRequest= HttpOpenRequest(hConnection, "GET", pathPtr, "", "", 0, INTERNET_FLAG_RELOAD | INTERNET_FLAG_KEEP_CONNECTION, 0);
	}
	InternetSetOption(hRequest, 
							  INTERNET_OPTION_PROXY_USERNAME, 
							  userPtr, 
							  strlen(userPtr)+1);
	InternetSetOption(hRequest, 
							  INTERNET_OPTION_PROXY_PASSWORD, 
							  passwordPtr, 
							  strlen(passwordPtr)+1);
	//resend 3 times if failed
FailReset:
	// send request.  do not care about the result since purpose is only to get the credentials cached.	
	result = HttpSendRequest(hRequest, NULL, 0, NULL, 0);
	if(result==TRUE){
		//noop
	}else{
		result=GetLastError();

	}
	if(result>=ERROR_INTERNET_SEC_CERT_DATE_INVALID&& result<=ERROR_INTERNET_SEC_CERT_REV_FAILED){
		//CA error
		DWORD dwFlags;
		DWORD dwBuffLen = sizeof(dwFlags);
		InternetQueryOption (hRequest, INTERNET_OPTION_SECURITY_FLAGS,
		(LPVOID)&dwFlags, &dwBuffLen);
		
		dwFlags |= SECURITY_FLAG_IGNORE_UNKNOWN_CA;
		dwFlags |= SECURITY_FLAG_IGNORE_CERT_CN_INVALID;
		dwFlags |= SECURITY_FLAG_IGNORE_CERT_DATE_INVALID;
		InternetSetOption (hRequest, INTERNET_OPTION_SECURITY_FLAGS,
						&dwFlags, sizeof (dwFlags) );
		goto FailReset;
	}
	result=HttpQueryInfo(hRequest, HTTP_QUERY_FLAG_NUMBER | 
              HTTP_QUERY_STATUS_CODE, &dwStatus, &dwStatusSize, NULL);
	
	switch (dwStatus)
	{		
		case HTTP_STATUS_DENIED:     // Server Authentication Required.
			InternetSetOption(hRequest, 
							  INTERNET_OPTION_USERNAME, 
							  userPtr, 
							  strlen(userPtr)+1);
			InternetSetOption(hRequest, 
							  INTERNET_OPTION_PASSWORD, 
							  passwordPtr, 
							  strlen(passwordPtr)+1);

			if(tried<totalTry){
				tried++;
				goto FailReset;
			}else{
				result= HTTP_STATUS_DENIED;
			}
			break;
		case HTTP_STATUS_PROXY_AUTH_REQ://Proxy Auth request
			InternetSetOption(hRequest, 
							  INTERNET_OPTION_PROXY_USERNAME, 
							  userPtr, 
							  strlen(userPtr)+1);
			InternetSetOption(hRequest, 
							  INTERNET_OPTION_PROXY_PASSWORD, 
							  passwordPtr, 
							  strlen(passwordPtr)+1);

			if(tried<totalTry){
				tried++;
				goto FailReset;
			}else{
				result= HTTP_STATUS_DENIED;
			}
			break;
		case HTTP_STATUS_SERVER_ERROR:	//internal server error, try with "Accept-Encoding"
			HttpAddRequestHeaders(hRequest, defaultEncoding,  
				-1,     HTTP_ADDREQ_FLAG_ADD|HTTP_ADDREQ_FLAG_REPLACE);   
			if(tried<totalTry){
				tried++;
				goto FailReset;
			}else{
				result= HTTP_STATUS_DENIED;
			}
			break;
	}

	// close wininet HINTERNET handles

	if (hRequest) {
		closeResult=InternetCloseHandle(hRequest);
	}
	if (hConnection) {
		closeResult=InternetCloseHandle(hConnection);
	}
	if (hSession) {
		closeResult=InternetCloseHandle(hSession);
	}

	// release Java strings
	if(userPtr)	{
		(*env)->ReleaseStringUTFChars(env,juser,userPtr);
	}
	if(passwordPtr)	{
		free(passwordPtr);
	} 
	if(jpasswordPtr) {
		(*env)->ReleaseCharArrayElements(env,jpassword, jpasswordPtr,0 );
	}  
	if(hostPtr) {
		(*env)->ReleaseStringUTFChars(env,jhost,hostPtr);
	} 
	if(pathPtr) {
		(*env)->ReleaseStringUTFChars(env,jpath,pathPtr);
	} 

	if(result!=TRUE&&result!=HTTP_STATUS_DENIED){
		result=GetLastError();
	}
	return result;
}
// cache a basic auth credential by opening a http request and setting username and password internet options
JNIEXPORT jint JNICALL COM_NATIVE(SetBasicAuth__Ljava_lang_String_2ILjava_lang_String_2ILjava_lang_String_2Ljava_lang_String_2)
(JNIEnv *env, jclass that, jstring jhost, jint jport, jstring jpath, jint isSecure, jstring juser, jstring jpassword) {

	DWORD result;
	DWORD closeResult;
	const char * defaultEncoding="Accept-Encoding:     gzip,     deflate\r\n";

	// get native 8-bit char array pointers from 16-bit Java strings
	const char *hostPtr = (*env)->GetStringUTFChars(env,jhost,0);
	const char *pathPtr = (*env)->GetStringUTFChars(env,jpath,0);
	const char *userPtr = (*env)->GetStringUTFChars(env,juser, 0);
	const char *passwordPtr = (*env)->GetStringUTFChars(env,jpassword,0);
	DWORD dwStatus;
	DWORD dwStatusSize = sizeof(dwStatus);
	int totalTry=3,tried=0;
	// open session and create request
	HINTERNET hSession =NULL;
	HINTERNET hConnection =NULL;
	HINTERNET hRequest =NULL ;
	//check input
	if(hostPtr==NULL||userPtr==NULL){
		return -1;
	}
	if((isSecure!=1)&&(isSecure!=0)){
		return -1;
	}
	hSession = InternetOpen("Web Browser", INTERNET_OPEN_TYPE_PRECONFIG , NULL, NULL, 0);
	hConnection = InternetConnect(hSession, hostPtr, (INTERNET_PORT)jport, NULL, NULL, INTERNET_SERVICE_HTTP, 0, 0);
	if(isSecure==1){
		//https
		hRequest= HttpOpenRequest(hConnection, "GET", pathPtr, "", "", 0, INTERNET_FLAG_RELOAD | INTERNET_FLAG_KEEP_CONNECTION|INTERNET_FLAG_SECURE, 0);
	}else if(isSecure==0){
		//http
		hRequest= HttpOpenRequest(hConnection, "GET", pathPtr, "", "", 0, INTERNET_FLAG_RELOAD | INTERNET_FLAG_KEEP_CONNECTION, 0);
	}
	
	// set basic authentication namd & pw.  these will be cached once set.
	result = InternetSetOption(hRequest, INTERNET_OPTION_USERNAME, (PWSTR)userPtr, strlen(userPtr)+1);
	result = InternetSetOption(hRequest, INTERNET_OPTION_PASSWORD, (PWSTR)passwordPtr, strlen(passwordPtr)+1);
	//resend 3 times if failed
FailReset:
	// send request.  do not care about the result since purpose is only to get the credentials cached.	
	result = HttpSendRequest(hRequest, NULL, 0, NULL, 0);
	if(result==TRUE){
		//noop
	}else{
		result=GetLastError();

	}
	if(result>=ERROR_INTERNET_SEC_CERT_DATE_INVALID&& result<=ERROR_INTERNET_SEC_CERT_REV_FAILED){
		//CA error
		DWORD dwFlags;
		DWORD dwBuffLen = sizeof(dwFlags);
		InternetQueryOption (hRequest, INTERNET_OPTION_SECURITY_FLAGS,
		(LPVOID)&dwFlags, &dwBuffLen);
		
		dwFlags |= SECURITY_FLAG_IGNORE_UNKNOWN_CA;
		dwFlags |= SECURITY_FLAG_IGNORE_CERT_CN_INVALID;
		dwFlags |= SECURITY_FLAG_IGNORE_CERT_DATE_INVALID;
		InternetSetOption (hRequest, INTERNET_OPTION_SECURITY_FLAGS,
						&dwFlags, sizeof (dwFlags) );
		goto FailReset;
	}
	result=HttpQueryInfo(hRequest, HTTP_QUERY_FLAG_NUMBER | 
              HTTP_QUERY_STATUS_CODE, &dwStatus, &dwStatusSize, NULL);
	
	switch (dwStatus)
	{		
		case HTTP_STATUS_DENIED:     // Server Authentication Required.
			InternetSetOption(hRequest, 
							  INTERNET_OPTION_USERNAME, 
							  userPtr, 
							  strlen(userPtr)+1);
			InternetSetOption(hRequest, 
							  INTERNET_OPTION_PASSWORD, 
							  passwordPtr, 
							  strlen(passwordPtr)+1);

			if(tried<totalTry){
				tried++;
				goto FailReset;
			}else{
				result= HTTP_STATUS_DENIED;
			}
			break;
		case HTTP_STATUS_PROXY_AUTH_REQ://Proxy Auth request
			InternetSetOption(hRequest, 
							  INTERNET_OPTION_PROXY_USERNAME, 
							  userPtr, 
							  strlen(userPtr)+1);
			InternetSetOption(hRequest, 
							  INTERNET_OPTION_PROXY_PASSWORD, 
							  passwordPtr, 
							  strlen(passwordPtr)+1);

			if(tried<totalTry){
				tried++;
				goto FailReset;
			}else{
				result= HTTP_STATUS_DENIED;
			}
			break;
		case HTTP_STATUS_SERVER_ERROR:	//internal server error, try with "Accept-Encoding"
			HttpAddRequestHeaders(hRequest, defaultEncoding,  
				-1,     HTTP_ADDREQ_FLAG_ADD|HTTP_ADDREQ_FLAG_REPLACE);   
			if(tried<totalTry){
				tried++;
				goto FailReset;
			}else{
				result= HTTP_STATUS_DENIED;
			}
			break;
	}

	// close wininet HINTERNET handles

	if (hRequest) {
		closeResult=InternetCloseHandle(hRequest);
	}
	if (hConnection) {
		closeResult=InternetCloseHandle(hConnection);
	}
	if (hSession) {
		closeResult=InternetCloseHandle(hSession);
	}

	// release Java strings
	if(userPtr)	{
		(*env)->ReleaseStringUTFChars(env,juser,userPtr);
	}
	if(passwordPtr)	{
		(*env)->ReleaseStringUTFChars(env,jpassword,passwordPtr);
	} 
	if(hostPtr) {
		(*env)->ReleaseStringUTFChars(env,jhost,hostPtr);
	} 
	if(pathPtr) {
		(*env)->ReleaseStringUTFChars(env,jpath,pathPtr);
	} 

	if(result!=TRUE&&result!=HTTP_STATUS_DENIED){
		result=GetLastError();
	}
	return result;
}

// cache a basic auth credential by opening a http request and setting username and password internet options
JNIEXPORT jint JNICALL COM_NATIVE(SetBasicAuth__Ljava_lang_String_2ILjava_lang_String_2ILjava_lang_String_2_3C)
(JNIEnv *env, jclass that, jstring jhost, jint jport, jstring jpath, jint isSecure, jstring juser, jcharArray jpassword) {

	DWORD result;
	DWORD closeResult;
	const char * defaultEncoding="Accept-Encoding:     gzip,     deflate\r\n";

	DWORD dwStatus;
	DWORD dwStatusSize = sizeof(dwStatus);
	int totalTry=3,tried=0;
	// open session and create request
	HINTERNET hSession =NULL;
	HINTERNET hConnection =NULL;
	HINTERNET hRequest =NULL ;
	// get native 8-bit char array pointers from 16-bit Java strings
	const char *hostPtr = (*env)->GetStringUTFChars(env,jhost,0);
	const char *pathPtr = (*env)->GetStringUTFChars(env,jpath,0);
	const char *userPtr = (*env)->GetStringUTFChars(env,juser, 0);
	//const char *passwordPtr = (*env)->GetStringUTFChars(env,jpassword,0);
	jchar *jpasswordPtr = (*env)->GetCharArrayElements(env, jpassword, NULL);
	wchar_t* wpasswordPtr = jpasswordPtr;
	const char* passwordPtr;
	int size = 0;
	int length = wcslen(wpasswordPtr);
	char* passwordPtrTemp = (char*)malloc( 2*length+1 );
	size = WideCharToMultiByte( CP_ACP, 0, (LPCWSTR)wpasswordPtr, length, passwordPtrTemp,(2*length+1), NULL, NULL );
	if( size <= 0 )
		return NULL;
	passwordPtrTemp[size] = 0;
	passwordPtr = passwordPtrTemp;


	//check input
	if(hostPtr==NULL||userPtr==NULL){
		return -1;
	}
	if((isSecure!=1)&&(isSecure!=0)){
		return -1;
	}
	hSession = InternetOpen("Web Browser", INTERNET_OPEN_TYPE_PRECONFIG , NULL, NULL, 0);
	hConnection = InternetConnect(hSession, hostPtr, (INTERNET_PORT)jport, NULL, NULL, INTERNET_SERVICE_HTTP, 0, 0);
	if(isSecure==1){
		//https
		hRequest= HttpOpenRequest(hConnection, "GET", pathPtr, "", "", 0, INTERNET_FLAG_RELOAD | INTERNET_FLAG_KEEP_CONNECTION|INTERNET_FLAG_SECURE, 0);
	}else if(isSecure==0){
		//http
		hRequest= HttpOpenRequest(hConnection, "GET", pathPtr, "", "", 0, INTERNET_FLAG_RELOAD | INTERNET_FLAG_KEEP_CONNECTION, 0);
	}
	
	// set basic authentication namd & pw.  these will be cached once set.
	result = InternetSetOption(hRequest, INTERNET_OPTION_USERNAME, (PWSTR)userPtr, strlen(userPtr)+1);
	result = InternetSetOption(hRequest, INTERNET_OPTION_PASSWORD, (PWSTR)passwordPtr, strlen(passwordPtr)+1);
	//resend 3 times if failed
FailReset:
	// send request.  do not care about the result since purpose is only to get the credentials cached.	
	result = HttpSendRequest(hRequest, NULL, 0, NULL, 0);
	if(result==TRUE){
		//noop
	}else{
		result=GetLastError();

	}
	if(result>=ERROR_INTERNET_SEC_CERT_DATE_INVALID&& result<=ERROR_INTERNET_SEC_CERT_REV_FAILED){
		//CA error
		DWORD dwFlags;
		DWORD dwBuffLen = sizeof(dwFlags);
		InternetQueryOption (hRequest, INTERNET_OPTION_SECURITY_FLAGS,
		(LPVOID)&dwFlags, &dwBuffLen);
		
		dwFlags |= SECURITY_FLAG_IGNORE_UNKNOWN_CA;
		dwFlags |= SECURITY_FLAG_IGNORE_CERT_CN_INVALID;
		dwFlags |= SECURITY_FLAG_IGNORE_CERT_DATE_INVALID;
		InternetSetOption (hRequest, INTERNET_OPTION_SECURITY_FLAGS,
						&dwFlags, sizeof (dwFlags) );
		goto FailReset;
	}
	result=HttpQueryInfo(hRequest, HTTP_QUERY_FLAG_NUMBER | 
              HTTP_QUERY_STATUS_CODE, &dwStatus, &dwStatusSize, NULL);
	
	switch (dwStatus)
	{		
		case HTTP_STATUS_DENIED:     // Server Authentication Required.
			InternetSetOption(hRequest, 
							  INTERNET_OPTION_USERNAME, 
							  userPtr, 
							  strlen(userPtr)+1);
			InternetSetOption(hRequest, 
							  INTERNET_OPTION_PASSWORD, 
							  passwordPtr, 
							  strlen(passwordPtr)+1);

			if(tried<totalTry){
				tried++;
				goto FailReset;
			}else{
				result= HTTP_STATUS_DENIED;
			}
			break;
		case HTTP_STATUS_PROXY_AUTH_REQ://Proxy Auth request
			InternetSetOption(hRequest, 
							  INTERNET_OPTION_PROXY_USERNAME, 
							  userPtr, 
							  strlen(userPtr)+1);
			InternetSetOption(hRequest, 
							  INTERNET_OPTION_PROXY_PASSWORD, 
							  passwordPtr, 
							  strlen(passwordPtr)+1);

			if(tried<totalTry){
				tried++;
				goto FailReset;
			}else{
				result= HTTP_STATUS_DENIED;
			}
			break;
		case HTTP_STATUS_SERVER_ERROR:	//internal server error, try with "Accept-Encoding"
			HttpAddRequestHeaders(hRequest, defaultEncoding,  
				-1,     HTTP_ADDREQ_FLAG_ADD|HTTP_ADDREQ_FLAG_REPLACE);   
			if(tried<totalTry){
				tried++;
				goto FailReset;
			}else{
				result= HTTP_STATUS_DENIED;
			}
			break;
	}

	// close wininet HINTERNET handles

	if (hRequest) {
		closeResult=InternetCloseHandle(hRequest);
	}
	if (hConnection) {
		closeResult=InternetCloseHandle(hConnection);
	}
	if (hSession) {
		closeResult=InternetCloseHandle(hSession);
	}

	// release Java strings
	if(userPtr)	{
		(*env)->ReleaseStringUTFChars(env,juser,userPtr);
	}
	if(passwordPtr)	{
		free(passwordPtr);
	} 
	if(jpasswordPtr) {
		(*env)->ReleaseCharArrayElements(env,jpassword, jpasswordPtr,0 );
	} 
	if(hostPtr) {
		(*env)->ReleaseStringUTFChars(env,jhost,hostPtr);
	} 
	if(pathPtr) {
		(*env)->ReleaseStringUTFChars(env,jpath,pathPtr);
	} 

	if(result!=TRUE&&result!=HTTP_STATUS_DENIED){
		result=GetLastError();
	}
	return result;
}
JNIEXPORT jint JNICALL COM_NATIVE(SetProxy)
  (JNIEnv *env, jclass that, jstring autoconfigURL, jstring proxy, jstring proxyByPass )
{
	INTERNET_PER_CONN_OPTION_LIST	List;
	INTERNET_PER_CONN_OPTION		Option[3];
	int								nSize = sizeof(INTERNET_PER_CONN_OPTION_LIST);
	HINTERNET						hInternet = NULL;
	int								optionNum = 0;
	char*							cautoconfigURL = NULL, *cproxy = NULL, *cproxyByPass = NULL;
	int								rc = 0;

	hInternet = InternetOpen("Web Browser", INTERNET_OPEN_TYPE_DIRECT, NULL, NULL, 0);
	if (autoconfigURL != NULL) {

		Option[0].dwOption = INTERNET_PER_CONN_FLAGS;
		Option[0].Value.dwValue = PROXY_TYPE_AUTO_PROXY_URL | PROXY_TYPE_DIRECT;

		cautoconfigURL = (*env)->GetStringUTFChars(env, autoconfigURL,0);
		Option[1].dwOption = INTERNET_PER_CONN_AUTOCONFIG_URL;
		Option[1].Value.pszValue = cautoconfigURL;

		optionNum = 2;

		rc = 2;
	} else {

		Option[0].dwOption = INTERNET_PER_CONN_FLAGS;
		Option[0].Value.dwValue = PROXY_TYPE_DIRECT | PROXY_TYPE_PROXY;
		optionNum++;

		if (proxy != NULL) {
			cproxy = (*env)->GetStringUTFChars(env, proxy, 0);
						
			Option[optionNum].dwOption = INTERNET_PER_CONN_PROXY_SERVER;
			Option[optionNum].Value.pszValue = cproxy;
			optionNum++;
		}

		if (proxyByPass != NULL) {
			cproxyByPass = (*env)->GetStringUTFChars(env, proxyByPass, 0);
			Option[optionNum].dwOption = INTERNET_PER_CONN_PROXY_BYPASS;
			Option[optionNum].Value.pszValue = cproxyByPass;
			optionNum++;
		}
		rc = optionNum;
	}

	List.dwSize = sizeof(INTERNET_PER_CONN_OPTION_LIST);
	List.pszConnection = NULL;
	List.dwOptionCount = optionNum;
	List.dwOptionError = 0;
	List.pOptions = Option;	
	
	
	if (!InternetSetOption(hInternet, INTERNET_OPTION_PER_CONNECTION_OPTION, &List, nSize))
	{
//		printf("InternetSetOption fialed!");
		
		rc = -1;
	}

	InternetSetOption(hInternet, INTERNET_OPTION_SETTINGS_CHANGED, NULL, 0);
    InternetSetOption(hInternet, INTERNET_OPTION_REFRESH , NULL, 0);
	
	if (autoconfigURL != NULL) {
//		printf("release autoconfigURL!\n");
		(*env)->ReleaseStringUTFChars(env, autoconfigURL, cautoconfigURL);
	}

	if (proxy != NULL) {
		rc += 4;
		(*env)->ReleaseStringUTFChars(env, proxy, cproxy);
	}

	if (proxyByPass != NULL) {
		rc += 5;
		(*env)->ReleaseStringUTFChars(env, proxyByPass, cproxyByPass);
	}

	InternetCloseHandle(hInternet);

	return rc;
}

JNIEXPORT jstring JNICALL COM_NATIVE(getProxy)
  (JNIEnv *env, jclass that)
{
	INTERNET_PER_CONN_OPTION_LIST    List;
	INTERNET_PER_CONN_OPTION         Option[5];
	unsigned long                    nSize = sizeof(INTERNET_PER_CONN_OPTION_LIST);

	jstring ret=NULL;
	char proxyType[512];
	char * retBuff=NULL;

	Option[0].dwOption = INTERNET_PER_CONN_AUTOCONFIG_URL;
	Option[1].dwOption = INTERNET_PER_CONN_AUTODISCOVERY_FLAGS;
	Option[2].dwOption = INTERNET_PER_CONN_FLAGS;
	Option[3].dwOption = INTERNET_PER_CONN_PROXY_BYPASS;
	Option[4].dwOption = INTERNET_PER_CONN_PROXY_SERVER;

	List.dwSize = sizeof(INTERNET_PER_CONN_OPTION_LIST);
	List.pszConnection = NULL;
	List.dwOptionCount = 5;
	List.dwOptionError = 0;
	List.pOptions = Option;

	if(!InternetQueryOption(NULL, INTERNET_OPTION_PER_CONNECTION_OPTION, &List, &nSize)){
	   printf("InternetQueryOption failed! (%d)\n", GetLastError());
	}

	// check which proxy type is used 
	if((Option[2].Value.dwValue & PROXY_TYPE_AUTO_PROXY_URL) == PROXY_TYPE_AUTO_PROXY_URL){
	 // printf("PROXY_TYPE_AUTO_PROXY_URL\n");
	  strcpy(proxyType,"2::"); // 2 -- auto config
	  if(Option[0].Value.pszValue != NULL){
		 retBuff=strcat(proxyType, Option[0].Value.pszValue);
		 ret=(*env)->NewStringUTF(env,(const char *)retBuff);
		 return (ret);
	  }
	}

	// auto detect is not used yet
/*	if((Option[2].Value.dwValue & PROXY_TYPE_AUTO_DETECT) == PROXY_TYPE_AUTO_DETECT){
	   printf("PROXY_TYPE_AUTO_DETECT\n");
	   strcpy(proxyType,"3"); // 3 -- auto detect
	   ret=(*env)->NewStringUTF(env,(const char *)proxyType);
	   return (ret);
	}
*/
	if((Option[2].Value.dwValue & PROXY_TYPE_PROXY) == PROXY_TYPE_PROXY){
	 //  printf("PROXY_TYPE_PROXY \n");
	   strcpy(proxyType,"4::"); // 4 -- manual proxy setting
	   if(Option[4].Value.pszValue != NULL){
		strcat(proxyType, "server=");
		retBuff=strcat(proxyType, Option[4].Value.pszValue);
		if(Option[3].Value.pszValue != NULL){
		  strcat(proxyType, " proxyByPass=");
		  retBuff=strcat(proxyType, Option[3].Value.pszValue);
		}
		ret=(*env)->NewStringUTF(env,(const char *)retBuff);
		return (ret);
	  }
	}

	if((Option[2].Value.dwValue & PROXY_TYPE_DIRECT) == PROXY_TYPE_DIRECT){
	//  printf("PROXY_TYPE_DIRECT\n");
	  strcpy(proxyType,"1"); // 1 -- direct connect
	  ret=(*env)->NewStringUTF(env,(const char *)proxyType);
	  return (ret);
	}

	if(Option[0].Value.pszValue != NULL)
	   GlobalFree(Option[0].Value.pszValue);

	if(Option[3].Value.pszValue != NULL)
	   GlobalFree(Option[3].Value.pszValue);

	if(Option[4].Value.pszValue != NULL)
	   GlobalFree(Option[4].Value.pszValue);

	ret=(*env)->NewStringUTF(env,(const char *)"NULL");
	return (ret);
}

JNIEXPORT jint JNICALL COM_NATIVE(CoGetMalloc)
  (JNIEnv *env, jclass clazz, jintArray arg0)
{ 
	jint *arg00=NULL;
	HRESULT   hr;

	if (arg0)
		arg00 = (*env)->GetIntArrayElements(env, arg0, NULL);

	hr = CoGetMalloc (1, (LPMALLOC *) arg00);

	if (arg0)
		(*env)->ReleaseIntArrayElements(env, arg0, arg00, 0);

	return hr;
}

JNIEXPORT jint JNICALL COM_NATIVE(OleStrLength)
  (JNIEnv *env, jclass that, jint arg0)
{
	return lstrlen(arg0);//OLESTRLEN(arg0); 
}

JNIEXPORT jint JNICALL COM_NATIVE(FileDownload)
  (JNIEnv *env, jclass that, jstring arg0, jstring arg1, jint arg2)
{
	//arg0: url
	//arg1: filepath
   
	int result = 0;	
    HRESULT   hr;
    jchar* url = (*env)->GetStringChars(env, arg0, 0);

//	int length = (*env)->GetStringLength(env, arg1);
	const jchar* jcstr = (*env)->GetStringChars(env, arg1, 0);

//	char* fpPath = (char*)malloc( length*2+1 );

//	int size = 0;

//	size = WideCharToMultiByte( CP_ACP, 0, (LPCWSTR)jcstr, length, fpPath, (length*2+1), NULL, NULL );
//	if( size <= 0 )
//		return NULL;
//	fpPath[size] = 0;

	//printf("%s", url);
	//printf("%s", "\n");
	//printf("%s", fpPath);
	//printf("%s", "\n");
 	//fflush(stdout);

	hr = URLDownloadToFileW ( NULL, (LPCTSTR)url, (LPCTSTR)jcstr, 0, (LPBINDSTATUSCALLBACK)arg2);
	if(arg0)
		(*env)->ReleaseStringChars(env, arg0, url);
	if(arg1)
		(*env)->ReleaseStringChars(env, arg1, jcstr );
//	free(fpPath);
//	fpPath = NULL;
   	
	return hr;
}

JNIEXPORT jint JNICALL COM_NATIVE(SafeArrayCreateVector)
  (JNIEnv *env, jclass clazz, jshort arg0, jint arg1, jint arg2)
{
	return (jint) SafeArrayCreateVector(arg0,arg1,arg2);
}

JNIEXPORT jint JNICALL COM_NATIVE(SafeArrayAccessData)
  (JNIEnv *env, jclass clazz, jint arg0, jintArray arg1)
{
	jint rc = 0;
	jint *arg11=NULL;

	if (arg1)
        arg11 = (*env)->GetIntArrayElements(env, arg1, NULL);
    	
	rc = SafeArrayAccessData((SAFEARRAY *) arg0, (void HUGEP **) arg11); 

	if (arg1)
       (*env)->ReleaseIntArrayElements(env, arg1, arg11, 0);

	return rc;
}

JNIEXPORT jint JNICALL COM_NATIVE(SafeArrayUnaccessData)
  (JNIEnv *env, jclass clazz, jint arg0)
{
	return SafeArrayUnaccessData((SAFEARRAY *) arg0);
}

JNIEXPORT jint JNICALL COM_NATIVE(SafeArrayDestroy)
  (JNIEnv *env, jclass clazz, jint arg0)
{
	return SafeArrayDestroy((SAFEARRAY *) arg0);
}

JNIEXPORT jint JNICALL COM_NATIVE(CoInternetCreateSecurityManager)
  (JNIEnv *env, jclass clazz, jint arg0, jintArray arg1, jint arg2)
{
	jint rc = 0;
	jint *arg11=NULL;

	if (arg1)
        arg11 = (*env)->GetIntArrayElements(env, arg1, NULL);
    	
	rc = CoInternetCreateSecurityManager((IServiceProvider *) arg0, (IInternetSecurityManager **) &arg11, arg2); 

	if (arg1)
       (*env)->ReleaseIntArrayElements(env, arg1, arg11, 0);

	return rc;
}
JNIEXPORT jint JNICALL COM_NATIVE(VtblCall__IILorg_eclipse_swt_internal_ole_win32_VARIANT2_2)
  (JNIEnv *env, jclass clazz, jint fnNumber, jint ppVtbl, jobject arg0)
{
	VARIANT var;
	P_OLEV_FN_2 fn; 
    jint rc = 0;

	VariantInit(&var); 
	fn = (P_OLEV_FN_2)(*(int **)ppVtbl)[fnNumber];
	if (arg0)
        getVARIANTFields(env, arg0, &var);
    	
	return fn(ppVtbl, var); 
}

JNIEXPORT jint JNICALL COM_NATIVE(VtblCall__IIILorg_eclipse_swt_internal_ole_win32_VARIANT2_2)
  (JNIEnv *env, jclass clazz, jint fnNumber, jint ppVtbl, jint arg0, jobject arg1)
{
	VARIANT var1;
	P_OLEV_FN_3 fn; 
   
	VariantInit(&var1); 
	fn = (P_OLEV_FN_3)(*(int **)ppVtbl)[fnNumber];
	if (arg1)
        getVARIANTFields(env, arg1, &var1);
    	
	return fn(ppVtbl, arg0, var1); 
}

JNIEXPORT jint JNICALL COM_NATIVE(VtblCall__IIILorg_eclipse_swt_internal_ole_win32_VARIANT2_2I)
  (JNIEnv *env, jclass clazz, jint fnNumber, jint ppVtbl, jint arg0, jobject arg1, jint arg2)
{
	VARIANT var;
	P_OLEV_FN_4 fn; 

	VariantInit(&var); 
	fn = (P_OLEV_FN_4)(*(int **)ppVtbl)[fnNumber];
	if (arg1)
        getVARIANTFields(env, arg1, &var);
    	
	return fn(ppVtbl, arg0, var, arg2); 
}
JNIEXPORT jint JNICALL COM_NATIVE(VtblCall__IIILorg_eclipse_swt_internal_ole_win32_VARIANT2_2_3I)
  (JNIEnv *env, jclass clazz, jint fnNumber, jint ppVtbl, jint arg0, jobject arg1, jintArray arg2)
{
	VARIANT var;
	P_OLEV_FN_4 fn; 
    jint rc = 0;
	jint *arg21=NULL;

	VariantInit(&var); 
	fn = (P_OLEV_FN_4)(*(int **)ppVtbl)[fnNumber];
	if (arg1)
        getVARIANTFields(env, arg1, &var);

	if (arg2)
        arg21 = (*env)->GetIntArrayElements(env, arg2, NULL);
    	
	rc = fn(ppVtbl, arg0, var, (jint)arg21); 

	if (arg2)
       (*env)->ReleaseIntArrayElements(env, arg2, arg21, 0);

	return rc;
}

JNIEXPORT jint JNICALL COM_NATIVE(VtblCall__IIIILorg_eclipse_swt_internal_ole_win32_VARIANT2_2_3I)
  (JNIEnv *env, jclass clazz, jint fnNumber, jint ppVtbl, jint arg0, jint arg1, jobject arg2, jintArray arg3)
{
	VARIANT var;
	P_OLEV_FN_5 fn; 
    jint rc = 0;
	jint *arg31=NULL;

	VariantInit(&var); 
	fn = (P_OLEV_FN_5)(*(int **)ppVtbl)[fnNumber];
	if (arg2)
        getVARIANTFields(env, arg2, &var);

	if (arg3)
        arg31 = (*env)->GetIntArrayElements(env, arg3, NULL);
    	
	rc = fn(ppVtbl, arg0, arg1, var, (jint)arg31); 

	if (arg3)
       (*env)->ReleaseIntArrayElements(env, arg3, arg31, 0);

	return rc;
}

JNIEXPORT jint JNICALL COM_NATIVE(VtblCall__IILorg_eclipse_swt_internal_ole_win32_VARIANT2_2Lorg_eclipse_swt_internal_ole_win32_VARIANT2_2_3I)
  (JNIEnv *env, jclass clazz, jint fnNumber, jint ppVtbl, jobject arg0, jobject arg1, jintArray arg2)
{
	VARIANT var0;
	VARIANT var1;
	P_OLEV_FN_41 fn; 
    jint rc = 0;
	jint *arg21=NULL;

	VariantInit(&var0); 
	VariantInit(&var1); 
	fn = (P_OLEV_FN_41)(*(int **)ppVtbl)[fnNumber];
	if (arg0)
        getVARIANTFields(env, arg0, &var0);

	if (arg1)
        getVARIANTFields(env, arg1, &var1);

	if (arg2)
        arg21 = (*env)->GetIntArrayElements(env, arg2, NULL);
    	
	rc = fn(ppVtbl, var0, var1, (jint)arg21); 

	if (arg2)
       (*env)->ReleaseIntArrayElements(env, arg2, arg21, 0);

	return rc;
}

JNIEXPORT jint JNICALL COM_NATIVE(VtblCall__IILorg_eclipse_swt_internal_ole_win32_VARIANT2_2Lorg_eclipse_swt_internal_ole_win32_VARIANT2_2Lorg_eclipse_swt_internal_ole_win32_VARIANT2_2_3I)
  (JNIEnv *env, jclass clazz, jint fnNumber, jint ppVtbl, jobject arg0, jobject arg1, jobject arg2, jintArray arg3)
{
	VARIANT var0;
	VARIANT var1;
	VARIANT var2;
	P_OLEV_FN_51 fn; 
    jint rc = 0;
	jint *arg31=NULL;

	VariantInit(&var0); 
	VariantInit(&var1); 
	VariantInit(&var2); 
	fn = (P_OLEV_FN_51)(*(int **)ppVtbl)[fnNumber];
	if (arg0)
        getVARIANTFields(env, arg0, &var0);

	if (arg1)
        getVARIANTFields(env, arg1, &var1);

	if (arg2)
        getVARIANTFields(env, arg2, &var2);

	if (arg3)
        arg31 = (*env)->GetIntArrayElements(env, arg3, NULL);
    	
	rc = fn(ppVtbl, var0, var1, var2, (jint)arg31); 

	if (arg3)
       (*env)->ReleaseIntArrayElements(env, arg3, arg31, 0);

	return rc;
}

JNIEXPORT jint JNICALL COM_NATIVE(VtblCall__IIILorg_eclipse_swt_internal_ole_win32_VARIANT2_2Lorg_eclipse_swt_internal_ole_win32_VARIANT2_2Lorg_eclipse_swt_internal_ole_win32_VARIANT2_2_3I)
  (JNIEnv *env, jclass clazz, jint fnNumber, jint ppVtbl, jint arg0, jobject arg1, jobject arg2, jobject arg3, jintArray arg4)
{
	VARIANT var1;
	VARIANT var2;
	VARIANT var3;
	P_OLEV_FN_6 fn; 
    jint rc = 0;
	jint *arg41=NULL;

	VariantInit(&var1); 
	VariantInit(&var2); 
	VariantInit(&var3); 
	fn = (P_OLEV_FN_6)(*(int **)ppVtbl)[fnNumber];
	if (arg1)
        getVARIANTFields(env, arg1, &var1);

	if (arg2)
        getVARIANTFields(env, arg2, &var2);

	if (arg3)
        getVARIANTFields(env, arg3, &var3);

	if (arg4)
        arg41 = (*env)->GetIntArrayElements(env, arg4, NULL);
    	
	rc = fn(ppVtbl, arg0, var1, var2, var3, (jint)arg41); 

	if (arg4)
       (*env)->ReleaseIntArrayElements(env, arg4, arg41, 0);

	return rc;
}

JNIEXPORT jint JNICALL COM_NATIVE(VtblCall__IILorg_eclipse_swt_internal_ole_win32_VARIANT2_2_3I)
  (JNIEnv *env, jclass clazz, jint fnNumber, jint ppVtbl, jobject arg0, jintArray arg1)
{
	VARIANT var0;
	P_OLEV_FN_31 fn; 
	jint rc = 0;
	jint *arg11=NULL;
   
	VariantInit(&var0); 
	fn = (P_OLEV_FN_31)(*(int **)ppVtbl)[fnNumber];
	if (arg0)
        getVARIANTFields(env, arg0, &var0);

	if (arg1)
        arg11 = (*env)->GetIntArrayElements(env, arg1, NULL);
    	
	rc = fn(ppVtbl, var0, (jint)arg11); 

	if (arg1)
       (*env)->ReleaseIntArrayElements(env, arg1, arg11, 0);

	return rc;
}

JNIEXPORT jint JNICALL COM_NATIVE(VtblCall__IILorg_eclipse_swt_internal_ole_win32_VARIANT2_2Lorg_eclipse_swt_internal_ole_win32_VARIANT2_2Lorg_eclipse_swt_internal_ole_win32_VARIANT2_2Lorg_eclipse_swt_internal_ole_win32_VARIANT2_2_3I)
  (JNIEnv *env, jclass clazz, jint fnNumber, jint ppVtbl, jobject arg0, jobject arg1, jobject arg2, jobject arg3, jintArray arg4)
{
	VARIANT var0;
	VARIANT var1;
	VARIANT var2;
	VARIANT var3;
	P_OLEV_FN_61 fn; 
    jint rc = 0;
	jint *arg41=NULL;

	VariantInit(&var0);
	VariantInit(&var1); 
	VariantInit(&var2); 
	VariantInit(&var3); 
	fn = (P_OLEV_FN_61)(*(int **)ppVtbl)[fnNumber];
	if (arg0)
        getVARIANTFields(env, arg0, &var0);

	if (arg1)
        getVARIANTFields(env, arg1, &var1);

	if (arg2)
        getVARIANTFields(env, arg2, &var2);

	if (arg3)
        getVARIANTFields(env, arg3, &var3);

	if (arg4)
        arg41 = (*env)->GetIntArrayElements(env, arg4, NULL);
    	
	rc = fn(ppVtbl, var0, var1, var2, var3, (jint)arg41); 

	if (arg4)
       (*env)->ReleaseIntArrayElements(env, arg3, arg41, 0);

	return rc;
}

JNIEXPORT jint JNICALL COM_NATIVE(VtblCall__IILorg_eclipse_swt_internal_ole_win32_VARIANT2_2Lorg_eclipse_swt_internal_ole_win32_VARIANT2_2Lorg_eclipse_swt_internal_ole_win32_VARIANT2_2Lorg_eclipse_swt_internal_ole_win32_VARIANT2_2Lorg_eclipse_swt_internal_ole_win32_VARIANT2_2Lorg_eclipse_swt_internal_ole_win32_VARIANT2_2)
  (JNIEnv *env, jclass clazz, jint fnNumber, jint ppVtbl, jobject arg0, jobject arg1, jobject arg2, jobject arg3, jobject arg4, jobject arg5)
{
	VARIANT var0;
	VARIANT var1;
	VARIANT var2;
	VARIANT var3;
	VARIANT var4;
	VARIANT var5;
	P_OLEV_FN_7 fn; 
   
	VariantInit(&var0);
	VariantInit(&var1); 
	VariantInit(&var2); 
	VariantInit(&var3); 
	VariantInit(&var4); 
	VariantInit(&var5); 
	fn = (P_OLEV_FN_7)(*(int **)ppVtbl)[fnNumber];
	if (arg0)
        getVARIANTFields(env, arg0, &var0);

	if (arg1)
        getVARIANTFields(env, arg1, &var1);

	if (arg2)
        getVARIANTFields(env, arg2, &var2);

	if (arg3)
        getVARIANTFields(env, arg3, &var3);

	if (arg4)
        getVARIANTFields(env, arg4, &var4);

	if (arg5)
        getVARIANTFields(env, arg5, &var5);
    	
	return fn(ppVtbl, var0, var1, var2, var3, var4, var5); 
}

JNIEXPORT jint JNICALL COM_NATIVE(VtblCall__IIIIII_3I)
  (JNIEnv *env, jclass clazz, jint fnNumber, jint ppVtbl, jint arg0, jint arg1, jint arg2, jint arg3, jintArray arg4)
{
	P_OLE_FN_6 fn; 
    jint rc = 0;
	jint *arg41=NULL;

	fn = (P_OLE_FN_6)(*(int **)ppVtbl)[fnNumber];
	if (arg4)
        arg41 = (*env)->GetIntArrayElements(env, arg4, NULL);
    	
	rc = fn(ppVtbl, arg0, arg1, arg2, arg3, (jint)arg41); 

	if (arg4)
       (*env)->ReleaseIntArrayElements(env, arg4, arg41, 0);

	return rc;
}

JNIEXPORT jint JNICALL COM_NATIVE(VtblCall__III_3I_3I)
  (JNIEnv *env, jclass clazz, jint fnNumber, jint ppVtbl, jint arg0, jintArray arg1, jintArray arg2)
{
	P_OLE_FN_4 fn; 
    jint rc = 0;
	jint *arg11=NULL;
	jint *arg21=NULL;

	fn = (P_OLE_FN_4)(*(int **)ppVtbl)[fnNumber];
	if (arg1)
        arg11 = (*env)->GetIntArrayElements(env, arg1, NULL);

	if (arg2)
        arg21 = (*env)->GetIntArrayElements(env, arg2, NULL);
    	
	rc = fn(ppVtbl, arg0, (jint)arg11, (jint)arg21); 

	if (arg1)
       (*env)->ReleaseIntArrayElements(env, arg1, arg11, 0);

	if (arg2)
       (*env)->ReleaseIntArrayElements(env, arg2, arg21, 0);

	return rc;
}

JNIEXPORT jint JNICALL COM_NATIVE(VtblCall__II_3I_3I)
  (JNIEnv *env, jclass clazz, jint fnNumber, jint ppVtbl, jintArray arg0, jintArray arg1)
{
	P_OLE_FN_3 fn; 
    jint rc = 0;
	jint *arg01=NULL;
	jint *arg11=NULL;

	fn = (P_OLE_FN_3)(*(int **)ppVtbl)[fnNumber];
	if (arg0)
        arg01 = (*env)->GetIntArrayElements(env, arg0, NULL);

	if (arg1)
        arg11 = (*env)->GetIntArrayElements(env, arg1, NULL);
    	
	rc = fn(ppVtbl, (jint)arg01, (jint)arg11); 

	if (arg0)
       (*env)->ReleaseIntArrayElements(env, arg0, arg01, 0);

	if (arg1)
       (*env)->ReleaseIntArrayElements(env, arg1, arg11, 0);

	return rc;
}

JNIEXPORT jint JNICALL COM_NATIVE(VtblCallFloat__IIF)
  (JNIEnv *env, jclass clazz, jint fnNumber, jint ppVtbl, jfloat arg0)
{
	P_OLEF_FN_2 fn; 
   
	fn = (P_OLEF_FN_2)(*(int **)ppVtbl)[fnNumber];
	
	return fn(ppVtbl, arg0); 
}

JNIEXPORT jint JNICALL COM_NATIVE(VtblCallFloat__II_3F)
  (JNIEnv *env, jclass clazz, jint fnNumber, jint ppVtbl, jfloatArray arg0)
{
	P_OLE_FN_2 fn; 
    jint rc = 0;
	jfloat *arg01=NULL;
	
	fn = (P_OLE_FN_2)(*(int **)ppVtbl)[fnNumber];
	if (arg0)
        arg01 = (*env)->GetFloatArrayElements(env, arg0, NULL);

	rc = fn(ppVtbl, (jint)arg01); 

	if (arg0)
       (*env)->ReleaseFloatArrayElements(env, arg0, arg01, 0);

	return rc;
}

JNIEXPORT jint JNICALL COM_NATIVE(VtblCall__II_3S)
  (JNIEnv *env, jclass clazz, jint fnNumber, jint ppVtbl, jshortArray arg0)
{
	P_OLE_FN_2 fn; 
    jint rc = 0;
	jshort *arg01=NULL;
	
	fn = (P_OLE_FN_2)(*(int **)ppVtbl)[fnNumber];
	if (arg0)
        arg01 = (*env)->GetShortArrayElements(env, arg0, NULL);

	rc = fn(ppVtbl, (jint)arg01); 

	if (arg0)
       (*env)->ReleaseShortArrayElements(env, arg0, arg01, 0);

	return rc;
}

JNIEXPORT jint JNICALL COM_NATIVE(VtblCall__IIII_3I_3I)
  (JNIEnv *env, jclass clazz, jint fnNumber, jint ppVtbl, jint arg0, jint arg1, jintArray arg2, jintArray arg3)
{
	P_OLE_FN_5 fn; 
    jint rc = 0;
	jint *arg21=NULL;
	jint *arg31=NULL;

	fn = (P_OLE_FN_5)(*(int **)ppVtbl)[fnNumber];
	if (arg2)
        arg21 = (*env)->GetIntArrayElements(env, arg2, NULL);

	if (arg2)
        arg31 = (*env)->GetIntArrayElements(env, arg3, NULL);
    	
	rc = fn(ppVtbl, arg0, arg1, (jint)arg21, (jint)arg31); 

	if (arg2)
       (*env)->ReleaseIntArrayElements(env, arg2, arg21, 0);

	if (arg3)
       (*env)->ReleaseIntArrayElements(env, arg3, arg31, 0);

	return rc;
}

JNIEXPORT jint JNICALL COM_NATIVE(VtblCall__III_3I_3I_3I)
  (JNIEnv *env, jclass clazz, jint fnNumber, jint ppVtbl, jint arg0, jintArray arg1, jintArray arg2, jintArray arg3)
{
	P_OLE_FN_5 fn; 
    jint rc = 0;
	jint *arg11=NULL;
	jint *arg21=NULL;
	jint *arg31=NULL;

	fn = (P_OLE_FN_5)(*(int **)ppVtbl)[fnNumber];
	if (arg1)
        arg11 = (*env)->GetIntArrayElements(env, arg1, NULL);

	if (arg2)
        arg21 = (*env)->GetIntArrayElements(env, arg2, NULL);

	if (arg2)
        arg31 = (*env)->GetIntArrayElements(env, arg3, NULL);
    	
	rc = fn(ppVtbl, arg0, (jint)arg11, (jint)arg21, (jint)arg31); 

	if (arg1)
       (*env)->ReleaseIntArrayElements(env, arg1, arg11, 0);

	if (arg2)
       (*env)->ReleaseIntArrayElements(env, arg2, arg21, 0);

	if (arg3)
       (*env)->ReleaseIntArrayElements(env, arg3, arg31, 0);

	return rc;
}

JNIEXPORT jint JNICALL COM_NATIVE(VtblCall__II_3II_3I_3I)
  (JNIEnv *env, jclass clazz, jint fnNumber, jint ppVtbl, jintArray arg0, jint arg1, jintArray arg2, jintArray arg3)
{
	P_OLE_FN_5 fn; 
    jint rc = 0;
	jint *arg01=NULL;
	jint *arg21=NULL;
	jint *arg31=NULL;

	fn = (P_OLE_FN_5)(*(int **)ppVtbl)[fnNumber];
	if (arg0)
        arg01 = (*env)->GetIntArrayElements(env, arg0, NULL);

	if (arg2)
        arg21 = (*env)->GetIntArrayElements(env, arg2, NULL);

	if (arg3)
        arg31 = (*env)->GetIntArrayElements(env, arg3, NULL);
    	
	rc = fn(ppVtbl, (jint)arg01, arg1, (jint)arg21, (jint)arg31); 

	if (arg0)
       (*env)->ReleaseIntArrayElements(env, arg0, arg01, 0);

	if (arg2)
       (*env)->ReleaseIntArrayElements(env, arg2, arg21, 0);

	if (arg3)
       (*env)->ReleaseIntArrayElements(env, arg3, arg31, 0);

	return rc;
}



JNIEXPORT jint JNICALL COM_NATIVE(VtblCall__III_3III)
  (JNIEnv *env, jclass clazz, jint fnNumber, jint ppVtbl, jint arg0, jintArray arg1, jint arg2, jint arg3)
{
	P_OLE_FN_5 fn; 
    jint rc = 0;
	jint *arg11=NULL;

	fn = (P_OLE_FN_5)(*(int **)ppVtbl)[fnNumber];
	if (arg1)
        arg11 = (*env)->GetIntArrayElements(env, arg1, NULL);

	rc = fn(ppVtbl, arg0, (jint)arg11, arg2, arg3); 

	if (arg1)
       (*env)->ReleaseIntArrayElements(env, arg1, arg11, 0);

	return rc;
}

JNIEXPORT jint JNICALL COM_NATIVE(VtblCall__III_3II)
  (JNIEnv *env, jclass clazz, jint fnNumber, jint ppVtbl, jint arg0, jintArray arg1, jint arg2)
{
	P_OLE_FN_4 fn; 
    jint rc = 0;
	jint *arg11=NULL;

	fn = (P_OLE_FN_4)(*(int **)ppVtbl)[fnNumber];
	if (arg1)
        arg11 = (*env)->GetIntArrayElements(env, arg1, NULL);

	rc = fn(ppVtbl, arg0, (jint)arg11, arg2); 

	if (arg1)
       (*env)->ReleaseIntArrayElements(env, arg1, arg11, 0);

	return rc;
}

JNIEXPORT jint JNICALL COM_NATIVE(VtblCall__IIII_3IIIIII)
  (JNIEnv *env, jclass clazz, jint fnNumber, jint ppVtbl, jint arg0, jint arg1, jintArray arg2, jint arg3, jint arg4,jint arg5,jint arg6,jint arg7)
{
	P_OLE_FN_9 fn; 
    jint rc = 0;
	jint *arg21=NULL;

	fn = (P_OLE_FN_9)(*(int **)ppVtbl)[fnNumber];

	if (arg2)
        arg21 = (*env)->GetIntArrayElements(env, arg2, NULL);

	rc = fn(ppVtbl, arg0, arg1, (jint)arg21, arg3, arg4, arg5, arg6, arg7); 

	if (arg2)
       (*env)->ReleaseIntArrayElements(env, arg2, arg21, 0);

	return rc;
}

JNIEXPORT jint JNICALL COM_NATIVE(VtblCall__IIII_3I_3IIII)
  (JNIEnv *env, jclass clazz, jint fnNumber, jint ppVtbl, jint arg0, jint arg1, jintArray arg2, jintArray arg3, jint arg4,jint arg5,jint arg6)
{
	P_OLE_FN_8 fn; 
    jint rc = 0;
	jint *arg21=NULL;
	jint *arg31=NULL;

	fn = (P_OLE_FN_8)(*(int **)ppVtbl)[fnNumber];

	if (arg2)
        arg21 = (*env)->GetIntArrayElements(env, arg2, NULL);

	if (arg3)
        arg31 = (*env)->GetIntArrayElements(env, arg3, NULL);
    	
	rc = fn(ppVtbl, arg0, arg1, (jint)arg21, (jint)arg31, arg4, arg5, arg6); 

	if (arg2)
       (*env)->ReleaseIntArrayElements(env, arg2, arg21, 0);

	if (arg3)
       (*env)->ReleaseIntArrayElements(env, arg3, arg31, 0);

	return rc;
}


JNIEXPORT jint JNICALL COM_NATIVE(LoadMenu)
	(JNIEnv *env, jclass that, jint arg0, jint arg1)
{
	return LoadMenu(arg0, MAKEINTRESOURCE(arg1)); 
}

JNIEXPORT jint JNICALL COM_NATIVE(GetSubMenu)
	(JNIEnv *env, jclass that, jint arg0, jint arg1)
{
	return GetSubMenu(arg0, MAKEINTRESOURCE(arg1)); 
}
JNIEXPORT jint JNICALL COM_NATIVE(TrackPopupMenu2)
	(JNIEnv *env, jclass that, jint arg0, jint arg1, jint arg2, jint arg3, jint arg4, jint arg5, jobject arg6)
{
	RECT _arg6, *lparg6=NULL;
	jint rc = 0;
	if (arg6) if ((lparg6 = getRECTFields(env, arg6, &_arg6)) == NULL) goto fail;
	rc = TrackPopupMenu((HMENU)arg0, arg1, arg2, arg3, arg4, (HWND)arg5, lparg6);
fail:
	if (arg6 && lparg6) setRECTFields(env, arg6, lparg6);
	return rc;
}

JNIEXPORT jint JNICALL COM_NATIVE(RegEnumValueA)
	(JNIEnv *env, jclass that, jint arg0, jint arg1, jbyteArray arg2, jintArray arg3, jintArray arg4, jintArray arg5, jbyteArray arg6, jintArray arg7)
{
	jbyte *lparg2=NULL;
	jint *lparg3=NULL;
	jint *lparg4=NULL;
	jint *lparg5=NULL;
	jbyte *lparg6=NULL;
	jint *lparg7=NULL;
	jint rc = 0;
	//OS_NATIVE_ENTER(env, that, RegEnumValueA_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetByteArrayElements(env, arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = (*env)->GetIntArrayElements(env, arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = (*env)->GetIntArrayElements(env, arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = (*env)->GetIntArrayElements(env, arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = (*env)->GetByteArrayElements(env, arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = (*env)->GetIntArrayElements(env, arg7, NULL)) == NULL) goto fail;
	rc = (jint)RegEnumValueA((HKEY)arg0, arg1, (LPSTR)lparg2, lparg3, lparg4, lparg5, (LPBYTE)lparg6, lparg7);
fail:
	if (arg7 && lparg7) (*env)->ReleaseIntArrayElements(env, arg7, lparg7, 0);
	if (arg6 && lparg6) (*env)->ReleaseByteArrayElements(env, arg6, lparg6, 0);
	if (arg5 && lparg5) (*env)->ReleaseIntArrayElements(env, arg5, lparg5, 0);
	if (arg4 && lparg4) (*env)->ReleaseIntArrayElements(env, arg4, lparg4, 0);
	if (arg3 && lparg3) (*env)->ReleaseIntArrayElements(env, arg3, lparg3, 0);
	if (arg2 && lparg2) (*env)->ReleaseByteArrayElements(env, arg2, lparg2, 0);
	//OS_NATIVE_EXIT(env, that, RegEnumValueA_FUNC);
	return rc;
}

JNIEXPORT jint JNICALL COM_NATIVE(RegEnumValueW)
	(JNIEnv *env, jclass that, jint arg0, jint arg1, jcharArray arg2, jintArray arg3, jintArray arg4, jintArray arg5, jcharArray arg6, jintArray arg7)
{
	jchar *lparg2=NULL;
	jint *lparg3=NULL;
	jint *lparg4=NULL;
	jint *lparg5=NULL;
	jchar *lparg6=NULL;
	jint *lparg7=NULL;
	jint rc = 0;
	//OS_NATIVE_ENTER(env, that, RegEnumValueW_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetCharArrayElements(env, arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = (*env)->GetIntArrayElements(env, arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = (*env)->GetIntArrayElements(env, arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = (*env)->GetIntArrayElements(env, arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = (*env)->GetCharArrayElements(env, arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = (*env)->GetIntArrayElements(env, arg7, NULL)) == NULL) goto fail;
	rc = (jint)RegEnumValueW((HKEY)arg0, arg1, (LPWSTR)lparg2, lparg3, lparg4, lparg5, (LPBYTE)lparg6, lparg7);
fail:
	if (arg7 && lparg7) (*env)->ReleaseIntArrayElements(env, arg7, lparg7, 0);
	if (arg6 && lparg6) (*env)->ReleaseCharArrayElements(env, arg6, lparg6, 0);
	if (arg5 && lparg5) (*env)->ReleaseIntArrayElements(env, arg5, lparg5, 0);
	if (arg4 && lparg4) (*env)->ReleaseIntArrayElements(env, arg4, lparg4, 0);
	if (arg3 && lparg3) (*env)->ReleaseIntArrayElements(env, arg3, lparg3, 0);
	if (arg2 && lparg2) (*env)->ReleaseCharArrayElements(env, arg2, lparg2, 0);
	//OS_NATIVE_EXIT(env, that, RegEnumValueW_FUNC);
	return rc;
}

