/*******************************************************************************
 * Copyright (c) 2008, 2010 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - initial implementation
 *******************************************************************************/
package com.ibm.rcp.app.os;

import com.ibm.rcp.os.internal.OS;


/**
 *  This class provides access to native methods of GtkSocket via JNI. 
 */
public class GtkSocketUtil {
	
	private static GtkSocketUtil instance = null;
	
	static {
		OS.initLibrary();
	}
	
	/**
	 * Returns an instance of the GtkSocketUtil object.
	 * 
	 * @return The GtkSocketUtil object instance.
	 */
	public static GtkSocketUtil getInstance() {
		if (instance == null) {
			instance = new GtkSocketUtil();
		}
		return instance;
	}
	
	/*
	 * Private constructor.
	 */
	private GtkSocketUtil () {
	}
	
	private static final native boolean _gtk_is_socket(int handle);
	
	/**
	 * This method checks to see if the provided handle is GtkSocket or not.
	 * 
	 * @param socket_handle - This is the socket_id of the Composite. parent.socketHandle
	 * @param plug_id - GtkPlug id of the application windw to be embedded.
	 * @return - Returns true if the <code> handle </code> is of GtkSocket type 
	 */
	public boolean gtk_is_socket(int handle){
		return _gtk_is_socket(handle);
	}

}
