/*******************************************************************************
 * Copyright (c) 2000, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.rcp.dombrowser.browser;

import java.util.HashSet;
import java.util.Set;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

import com.ibm.rcp.dombrowser.internal.mozilla.XPCOM;
import com.ibm.rcp.dombrowser.internal.mozilla.XPCOMObject;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIBaseWindow;
import com.ibm.rcp.dombrowser.internal.mozilla.nsID;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIURI;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIWebBrowser;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIWebBrowserChrome;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIWindowCreator2;
import com.ibm.rcp.dombrowser.support.NativeBrowser;

class WindowCreatorEx extends WindowCreator {
	private Set browsers = new HashSet();
	private XPCOMObject 	windowCreator2;
	
	public WindowCreatorEx() {
		super();
	}
	
	void addBrowser(DOMMozillaBrowser browser) {
		this.browsers.add(browser);
	}
	
	void removeBrowser(DOMMozillaBrowser browser) {
		this.browsers.remove(browser);
	}
	
	int queryInterface(int /*long*/ riid, int /*long*/ ppvObject) 	{
		
		int rc = super.queryInterface(riid,ppvObject);
		if (rc == XPCOM.NS_OK)
			return rc;
		
		if (riid == 0 || ppvObject == 0)
			return XPCOM.NS_ERROR_NO_INTERFACE;
	
		nsID guid = new nsID();
		XPCOM.memmove(guid, riid, nsID.sizeof);

		if (guid.Equals(nsIWindowCreator2.NS_IWINDOWCREATOR2_IID)) {
			XPCOM.memmove(ppvObject, new int /*long*/[] {windowCreator2.getAddress()}, XPCOMObject.PTR_SIZEOF);
			AddRef();
			return XPCOM.NS_OK;
		}
				
		XPCOM.memmove(ppvObject, new int /*long*/[] {0}, XPCOMObject.PTR_SIZEOF);
		return XPCOM.NS_ERROR_NO_INTERFACE;
	}
	
	void disposeCOMInterfaces () 	{
		super.disposeCOMInterfaces(); 
		if (windowCreator2 != null) {
			windowCreator2.dispose();
			windowCreator2 = null;
		}
	}

	protected void createCOMInterfaces() 
	{
		super.createCOMInterfaces();
		
		windowCreator2 = new XPCOMObject(new int[]{2, 0, 0, 3, 7, 1}){
			public int /*long*/ method0(int /*long*/[] args) {return queryInterface(args[0], args[1]);}
			public int /*long*/ method1(int /*long*/[] args) {return AddRef();}
			public int /*long*/ method2(int /*long*/[] args) {return Release();}
			public int /*long*/ method3(int /*long*/[] args) {return CreateChromeWindow(args[0], args[1], args[2]);}
			public int /*long*/ method4(int /*long*/[] args) {return CreateChromeWindow2(args[0], (int)/*64*/args[1], (int)/*64*/args[2],args[3],args[4], args[5], args[6]);}
			public int /*long*/ method5(int /*long*/[] args) {return SetScreenId(args[0]);}
		};
	}	
	
	int SetScreenId(int /*long*/ aScreenId) {
		return XPCOM.NS_OK;
	}
	
	int CreateChromeWindow2(int /*long*/ parent, int chromeFlags, int contextFlags,
			int /*long*/ uri, int /*long*/ openingTab, int /*long*/ cancel, int /*long*/ newChrome) {
		if (parent == 0 && (chromeFlags & nsIWebBrowserChrome.CHROME_OPENAS_CHROME) == 0) {
			return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
		}
		
		Composite src=null;
		final int[] cx = new int[1];
		final int[] cy = new int[1];
		
		nsIBaseWindow baseWindow=null;
		if(parent != 0){
			nsIWebBrowserChrome browserChromeParent = new nsIWebBrowserChrome(parent);
			int /*long*/[] aWebBrowser = new int /*long*/[1];
			int rc = browserChromeParent.GetWebBrowser(aWebBrowser);
			if (rc != XPCOM.NS_OK) MozillaBrowser.error(rc);
			if (aWebBrowser[0] == 0) MozillaBrowser.error(XPCOM.NS_ERROR_NO_INTERFACE);
			
			nsIWebBrowser webBrowser = new nsIWebBrowser(aWebBrowser[0]);
			int /*long*/[] result = new int /*long*/[1];
			rc = webBrowser.QueryInterface(nsIBaseWindow.NS_IBASEWINDOW_IID, result);
			if (rc != XPCOM.NS_OK) MozillaBrowser.error(rc);
			if (result[0] == 0) MozillaBrowser.error(XPCOM.NS_ERROR_NO_INTERFACE);
			webBrowser.Release();
			
			baseWindow = new nsIBaseWindow(result[0]);
			baseWindow.GetSize(cx, cy);
			
			result[0] = 0;
			int /*long*/[] aParentNativeWindow = new int /*long*/[1];
			rc = baseWindow.GetParentNativeWindow(aParentNativeWindow);
			if (rc != XPCOM.NS_OK) MozillaBrowser.error(rc);
			if (aParentNativeWindow[0] == 0) MozillaBrowser.error(XPCOM.NS_ERROR_NO_INTERFACE);
			baseWindow.Release();
	
			src = NativeBrowser.findBrowser(aParentNativeWindow[0]);
			
			/**
			 * Fix for SPR# YYSN7THBZK
			 * In oder to solve SWT# 193867, we call initSWTService() in each native fragments to force a
			 * SWT Browser created and then disposed. But this tricky will lead jvm crash when 
			 * opening a SWT Browser in a new window. That's because SWT Browser's callbacks have already been overridden
			 * and the SWT Browser will be cascaded to DOMBrowser.
			 * So, we need to rebase SWT Browser's callbacks to let it work as expected and without crash. 
			 */
			if(src instanceof Browser){
				return MozillaBrowser.openWindow(parent, chromeFlags, contextFlags, uri, cancel, newChrome);
			}
		}
		final MozillaBrowser browser;
		boolean doit = false;
		if ((chromeFlags & nsIWebBrowserChrome.CHROME_OPENAS_CHROME) != 0) {
			/*
			* Feature on Mozilla.  On platforms that lack a native dialog, Mozilla sends a
			* requests for a new Browser instance in a modal window. e.g. on Windows, Mozilla
			* brings up automatically a native Print Dialog in response to the javascript
			* command window.print() whereas on Linux Mozilla requests a new modal window
			* and a Browser to display an emulated HTML based print dialog. For this reason,
			* modal requests are handled here and not exposed to the user.
			*/
			int style = SWT.DIALOG_TRIM| SWT.MIN| SWT.CLOSE| SWT.MAX| SWT.RESIZE;
			if ((chromeFlags & nsIWebBrowserChrome.CHROME_MODAL) != 0) style |= SWT.APPLICATION_MODAL; 
			final Shell shell = src == null ?
				new Shell (style) :
				new Shell (src.getShell(), style);
			shell.setLayout(new FillLayout());
			browser = new DOMBrowser(shell, SWT.NONE);
			
			browser.addVisibilityWindowListener(new VisibilityWindowListener() {
				public void hide(WindowEvent event) {
				}
				public void show(WindowEvent event) {
					
					if (event.location != null) shell.setLocation(event.location);
					if (event.size != null) {
						Point size = event.size;
						shell.setSize(shell.computeSize(size.x, size.y));
					}else{
						
//						//workaround for SPR LGLG7R466U, make dialog's height higer to display the whole page. only needed on Mac and Linux	
//						if(!"w32".equals(SWT.getPlatform())){
//							Point point = shell.getSize();
//							shell.setSize(point.x,  point.y + point.y/3);
//						}
					
						Object chromeUrl = browser.getData("chromeUrl");
						if(chromeUrl != null && (((String)chromeUrl).indexOf("certViewer.xul")!=-1)){
							Monitor monitor = shell.getMonitor();
							int maxWidth = monitor.getBounds().width*2/3;
							int maxHeight = monitor.getBounds().height*3/4;
							shell.setSize( maxWidth, maxHeight);
							shell.setData("isAllowBrowserShellResize", "true"); 
						}
						
					   else{

							Monitor monitor = shell.getMonitor();
							int maxWidth = monitor.getBounds().width /3;
							int maxHeight = monitor.getBounds().height /3;
							shell.setSize( maxWidth, maxHeight);
							shell.setData("isAllowBrowserShellResize", "true"); 
						}
					}
					shell.open();
				}
			});
			browser.addCloseWindowListener(new CloseWindowListener() {
				public void close(WindowEvent event) {
					shell.close();
				}
			});
			browser.addTitleListener(new TitleListener(){
				public void changed(TitleEvent event) {
					if(!shell.isDisposed() && event !=null){
						shell.setText(event.title);
					}
				}
				
			});
			doit = true;
			
			// get url string
			String strURL = null;
			if (uri != 0) {
				nsIURI location = new nsIURI(uri);
				int /*long*/ aSpec = XPCOM.nsCString_new();
				if (location.GetSpec(aSpec) == XPCOM.NS_OK) {
					int length = XPCOM.nsCString_Length(aSpec);
					if(length>0){
						int /*long*/ buffer = XPCOM.nsCString_get(aSpec);
						byte[] dest = new byte[length];
						XPCOM.memmove(dest, buffer, length);
						strURL = new String(dest); 
							// PCR 11767, do not need "chrome://pippki/content/certerror.xul" for warning, we have InvalidCertError dialog
							if(strURL.equalsIgnoreCase("chrome://pippki/content/certerror.xul")) {
								doit = false;
							}
							else {
								browser.setUrl(strURL);
								browser.setData("chromeUrl", strURL);
							}
					}
				}
				XPCOM.nsCString_delete(aSpec);
			}	
			
		} else {
			
		
			WindowEvent event = new WindowEvent(src);
			event.display = src.getDisplay();
			event.widget = src;
			event.required = true;
			
			for (int i = 0; i < ((DOMBrowser)src).openWindowListeners.length; i++)
				((DOMBrowser)src).openWindowListeners[i].open(event);
			browser = event.browser;
			doit = browser != null && !browser.isDisposed();
			if (doit) {
				browser.mozillaEmbeddingSite.addressBar = (chromeFlags & nsIWebBrowserChrome.CHROME_LOCATIONBAR) != 0;
				browser.mozillaEmbeddingSite.menuBar = (chromeFlags & nsIWebBrowserChrome.CHROME_MENUBAR) != 0;
				browser.mozillaEmbeddingSite.statusBar = (chromeFlags & nsIWebBrowserChrome.CHROME_STATUSBAR) != 0;
				browser.mozillaEmbeddingSite.toolBar = (chromeFlags & nsIWebBrowserChrome.CHROME_TOOLBAR) != 0;
			}
		}
		
		if (doit) {
			int /*long*/ address = browser.mozillaEmbeddingSite.getWebBrowserChromeAddress();
			nsIWebBrowserChrome webBrowserChrome = new nsIWebBrowserChrome(address);
			webBrowserChrome.SetChromeFlags (chromeFlags);
			webBrowserChrome.AddRef();
			// for xul 10.0
			// XPCOM.memmove(cancel, new int[] {0}, 4);  /* PRBool */
			XPCOM.memmove(cancel, new int[] {0}, 1); /*bool*/
			XPCOM.memmove(newChrome, new int /*long*/[] {address}, XPCOMObject.PTR_SIZEOF);
		}
		

		return doit ? XPCOM.NS_OK : XPCOM.NS_ERROR_NOT_IMPLEMENTED;
		
	}
	
	
}