/*******************************************************************************
 * Copyright (c) 2003, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.rcp.dombrowser.browser;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

import com.ibm.rcp.dombrowser.internal.LoginHelper;
import com.ibm.rcp.dombrowser.internal.StringBundleHelper;
import com.ibm.rcp.dombrowser.internal.mozilla.WString;
import com.ibm.rcp.dombrowser.internal.mozilla.XPCOM;
import com.ibm.rcp.dombrowser.internal.mozilla.XPCOMObject;
import com.ibm.rcp.dombrowser.internal.mozilla.nsEmbedString;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIAuthInformation;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIAuthPrompt2;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIChannel;
import com.ibm.rcp.dombrowser.internal.mozilla.nsID;
import com.ibm.rcp.dombrowser.internal.mozilla.nsILoginInfo;
import com.ibm.rcp.dombrowser.internal.mozilla.nsILoginManager;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIMemory;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIPrompt;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIPromptService;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIPromptService2;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIServiceManager;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIStringBundle;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIStringBundleService;
import com.ibm.rcp.dombrowser.internal.mozilla.nsISupports;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIURI;
import com.ibm.rcp.dombrowser.internal.ui.ComfirmExDialog;
import com.ibm.rcp.dombrowser.internal.ui.PromptDialogEx;
import com.ibm.rcp.dombrowser.internal.ui.PromptUsernameAndPasswordDialog;
import com.ibm.rcp.dombrowser.mozilla.sso.AccountInfo;
import com.ibm.rcp.dombrowser.mozilla.sso.BrowserSSOManager;

class PromptService {
	XPCOMObject supports;
	XPCOMObject prompt; // for xul 10.0, implement /* nsIPrompt */
	XPCOMObject promptService;
	XPCOMObject promptService2;
	XPCOMObject authPrompt2;   // for xul 10.0, implement /* nsIAuthPrompt2*/
	int refCount = 0;
	int /*long*/ parentWindow = 0;  // for xul 10.0
	
	private static final String pwdManagerPropertyFile = "chrome://passwordmgr/locale/passwordmgr.properties";  //$NON-NLS-1$
	private static final String rememberPwdKey = "rememberPassword";  //$NON-NLS-1$
	
	static final String[] certErrorCodes = new String[] {
		"ssl_error_bad_cert_domain",
		"sec_error_ca_cert_invalid",
		"sec_error_expired_certificate",
		"sec_error_expired_issuer_certificate",
		"sec_error_inadequate_key_usage",
		"sec_error_unknown_issuer",
		"sec_error_untrusted_cert",
		"sec_error_untrusted_issuer",
	};	//$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$

	private static String PKG_Name=PromptService.class.getPackage().getName();
	private static String CLZ_Name=PromptService.class.getName();
	private static Logger logger=Logger.getLogger(PKG_Name);

	public PromptService() {
		createCOMInterfaces();
	}
	
	int AddRef() {
		refCount++;
		return refCount;
	}
	
	void createCOMInterfaces() {
		/* Create each of the interfaces that this object implements */
		supports = new XPCOMObject(new int[]{2, 0, 0}){
			public int /*long*/ method0(int /*long*/[] args) {return queryInterface(args[0], args[1]);}
			public int /*long*/ method1(int /*long*/[] args) {return AddRef();}
			public int /*long*/ method2(int /*long*/[] args) {return Release();}
		};
		
		/* nsIPrompt, xul 10.0 */
		prompt = new XPCOMObject(new int[]{2, 0, 0, 2, 4, 3, 5, 9, 6, 6, 7, 6}) {
			public int /*long*/ method0(int /*long*/[] args) {return queryInterface(args[0], args[1]);}
			public int /*long*/ method1(int /*long*/[] args) {return AddRef();}
			public int /*long*/ method2(int /*long*/[] args) {return Release();}
			public int /*long*/ method3(int /*long*/[] args) {return Alert(args[0], args[1]);}
			public int /*long*/ method4(int /*long*/[] args) {return AlertCheck(args[0], args[1], args[2], args[3]);}
			public int /*long*/ method5(int /*long*/[] args) {return Confirm(args[0], args[1], args[2]);}
			public int /*long*/ method6(int /*long*/[] args) {return ConfirmCheck(args[0], args[1], args[2], args[3], args[4]);}
			public int /*long*/ method7(int /*long*/[] args) {return ConfirmEx(args[0], args[1], (int)/*64*/args[2], args[3], args[4], args[5], args[6], args[7], args[8]);}
			public int /*long*/ method8(int /*long*/[] args) {return Prompt(args[0], args[1], args[2], args[3], args[4], args[5]);}			
			public int /*long*/ method9(int /*long*/[] args) {return PromptPassword(args[0], args[1], args[2], args[3], args[4], args[5]);}
			public int /*long*/ method10(int /*long*/[] args) {return PromptUsernameAndPassword(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);}
			public int /*long*/ method11(int /*long*/[] args) {return Select(args[0], args[1], (int)/*64*/args[2], args[3], args[4], args[5]);}
		};
		
		promptService = new XPCOMObject(new int[]{2, 0, 0, 3, 5, 4, 6, 10, 7, 8, 7, 7}){
			public int /*long*/ method0(int /*long*/[] args) {return queryInterface(args[0], args[1]);}
			public int /*long*/ method1(int /*long*/[] args) {return AddRef();}
			public int /*long*/ method2(int /*long*/[] args) {return Release();}
			public int /*long*/ method3(int /*long*/[] args) {return Alert(args[0], args[1], args[2]);}
			public int /*long*/ method4(int /*long*/[] args) {return AlertCheck(args[0], args[1], args[2], args[3], args[4]);}
			public int /*long*/ method5(int /*long*/[] args) {return Confirm(args[0], args[1], args[2], args[3]);}
			public int /*long*/ method6(int /*long*/[] args) {return ConfirmCheck(args[0], args[1], args[2], args[3], args[4], args[5]);}
			public int /*long*/ method7(int /*long*/[] args) {return ConfirmEx(args[0], args[1], args[2], (int)/*64*/args[3], args[4], args[5], args[6], args[7], args[8], args[9]);}
			public int /*long*/ method8(int /*long*/[] args) {return Prompt(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);}
			public int /*long*/ method9(int /*long*/[] args) {return PromptUsernameAndPassword(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7]);}
			public int /*long*/ method10(int /*long*/[] args) {return PromptPassword(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);}
			public int /*long*/ method11(int /*long*/[] args) {return Select(args[0], args[1], args[2], (int)/*64*/args[3], args[4], args[5], args[6]);}
		};	
		
		promptService2 = new XPCOMObject (new int[] {2, 0, 0, 3, 5, 4, 6, 10, 7, 8, 7, 7, 7, 9}) {
			public int /*long*/ method0 (int /*long*/[] args) {return queryInterface (args[0], args[1]);}
			public int /*long*/ method1 (int /*long*/[] args) {return AddRef ();}
			public int /*long*/ method2 (int /*long*/[] args) {return Release ();}
			public int /*long*/ method3 (int /*long*/[] args) {return Alert (args[0], args[1], args[2]);}
			public int /*long*/ method4 (int /*long*/[] args) {return AlertCheck (args[0], args[1], args[2], args[3], args[4]);}
			public int /*long*/ method5 (int /*long*/[] args) {return Confirm (args[0], args[1], args[2], args[3]);}
			public int /*long*/ method6 (int /*long*/[] args) {return ConfirmCheck (args[0], args[1], args[2], args[3], args[4], args[5]);}
			public int /*long*/ method7 (int /*long*/[] args) {return ConfirmEx (args[0], args[1], args[2], (int)/*64*/args[3], args[4], args[5], args[6], args[7], args[8], args[9]);}
			public int /*long*/ method8 (int /*long*/[] args) {return Prompt (args[0], args[1], args[2], args[3], args[4], args[5], args[6]);}
			public int /*long*/ method9 (int /*long*/[] args) {return PromptUsernameAndPassword (args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7]);}
			public int /*long*/ method10 (int /*long*/[] args) {return PromptPassword (args[0], args[1], args[2], args[3], args[4], args[5], args[6]);}
			public int /*long*/ method11 (int /*long*/[] args) {return Select (args[0], args[1], args[2], (int)/*64*/args[3], args[4], args[5], args[6]);}
			public int /*long*/ method12 (int /*long*/[] args) {return PromptAuth (args[0], args[1], (int)/*64*/args[2], args[3], args[4], args[5], args[6]);}
			public int /*long*/ method13 (int /*long*/[] args) {return AsyncPromptAuth (args[0], args[1], args[2], args[3], (int)/*64*/args[4], args[5], args[6], args[7], args[8]);}
		};
		
		// For xul 10.0
		authPrompt2 = new XPCOMObject(new int[] {2, 0, 0, 4, 6}) {
			public int /*long*/ method0 (int /*long*/[] args) {return queryInterface (args[0], args[1]);}
			public int /*long*/ method1 (int /*long*/[] args) {return AddRef ();}
			public int /*long*/ method2 (int /*long*/[] args) {return Release ();}
			public int /*long*/ method3 (int /*long*/[] args) {return PromptAuth (args[0], (int)/*64*/args[1], args[2], args[3]);}
			public int /*long*/ method4 (int /*long*/[] args) {return AsyncPromptAuth (args[0], args[1], args[2], (int)/*64*/args[3], args[4], args[5]);}
		};
	}
	
	void disposeCOMInterfaces() {
		if (supports != null) {
			supports.dispose();
			supports = null;
		}	
		
		// For xul 10.0
		if(prompt != null) {
			prompt.dispose();
			prompt = null;
		}
		
		if (promptService != null) {
			promptService.dispose();
			promptService = null;	
		}
		
		if (promptService2 != null) {
			promptService2.dispose ();
			promptService2 = null;	
		}
		
		// For xul 10.0
		if (authPrompt2 != null) {
			authPrompt2.dispose ();
			authPrompt2 = null;	
		}
	}
	
	int /*long*/ getAddress() {
		return promptService.getAddress();
	}
	
	int queryInterface(int /*long*/ riid, int /*long*/ ppvObject) {
		if (riid == 0 || ppvObject == 0) return XPCOM.NS_ERROR_NO_INTERFACE;
		nsID guid = new nsID();
		XPCOM.memmove(guid, riid, nsID.sizeof);
		
		if (guid.Equals(nsISupports.NS_ISUPPORTS_IID)) {
			XPCOM.memmove(ppvObject, new int /*long*/[] {supports.getAddress()}, XPCOMObject.PTR_SIZEOF);
			AddRef();
			return XPCOM.NS_OK;
		}
		
		// For xul 10.0, nsIPrompt
		if(guid.Equals(nsIPrompt.NS_IPROMPT_IID)) { 
			XPCOM.memmove(ppvObject, new int /*long*/[] {prompt.getAddress()}, XPCOMObject.PTR_SIZEOF);
			AddRef();
			return XPCOM.NS_OK;		
		}
		
		if (guid.Equals(nsIPromptService.NS_IPROMPTSERVICE_IID)) {
			XPCOM.memmove(ppvObject, new int /*long*/[] {promptService.getAddress()}, XPCOMObject.PTR_SIZEOF);
			AddRef();
			return XPCOM.NS_OK;
		}
		
		if (guid.Equals (nsIPromptService2.NS_IPROMPTSERVICE2_IID)) {
			XPCOM.memmove (ppvObject, new int /*long*/[] {promptService2.getAddress ()}, XPCOMObject.PTR_SIZEOF);
			AddRef ();
			return XPCOM.NS_OK;
		}

		// For xul 10.0, nsIAuthPrompt2
		if (guid.Equals (nsIAuthPrompt2.NS_IAUTHPROMPT2_IID)) {
			XPCOM.memmove (ppvObject, new int /*long*/[] {authPrompt2.getAddress ()}, XPCOMObject.PTR_SIZEOF);
			AddRef ();
			return XPCOM.NS_OK;
		}
		
		XPCOM.memmove(ppvObject, new int /*long*/[] {0}, XPCOMObject.PTR_SIZEOF);
		return XPCOM.NS_ERROR_NO_INTERFACE;
	}
	        	
	int Release() {
		refCount--;
		if (refCount == 0) disposeCOMInterfaces();
		return refCount;
	}
	
	static protected Composite getBrowser(int /*long*/ aDOMWindow) {
		Composite browser[] = new Composite[1];
		int rc = DOMBrowser.getBrowser(aDOMWindow, browser);
		if (rc != XPCOM.NS_OK) {
		logger.logp(Level.SEVERE, CLZ_Name, "getBrowser", new Integer(rc).toString());
			
		//	NativeBrowser.error(rc)
			return null;
		}
		
		return browser[0];
	}
	
	String getLabel(int buttonFlag, int index, int /*long*/ buttonTitle) {
		String label = null;
		int flag = (buttonFlag & (0xff * index)) / index;
		switch (flag) {
			case nsIPromptService.BUTTON_TITLE_CANCEL : label = SWT.getMessage("SWT_Cancel"); break; //$NON-NLS-1$
			case nsIPromptService.BUTTON_TITLE_NO : label = SWT.getMessage("SWT_No"); break; //$NON-NLS-1$
			case nsIPromptService.BUTTON_TITLE_OK : label = SWT.getMessage("SWT_OK"); break; //$NON-NLS-1$
			case nsIPromptService.BUTTON_TITLE_SAVE : label = SWT.getMessage("SWT_Save"); break; //$NON-NLS-1$
			case nsIPromptService.BUTTON_TITLE_YES : label = SWT.getMessage("SWT_Yes"); break; //$NON-NLS-1$
			case nsIPromptService.BUTTON_TITLE_IS_STRING : {
				label = WString.toNotNullString(buttonTitle);
			}
		}
		return label;
	}
	
	/* xul 10.0, nsIPrompt */
	public int Alert(int /*long*/ dialogTitle, int /*long*/ text) {
		return Alert(parentWindow, dialogTitle, text);
	}
	
	public int AlertCheck(int /*long*/ dialogTitle, int /*long*/ text, int /*long*/ checkMsg, int /*long*/ checkValue) {
		return AlertCheck(parentWindow, dialogTitle, text, checkMsg, checkValue);
	}
	
	public int Confirm(int /*long*/ dialogTitle, int /*long*/ text, int /*long*/ _retval) {
		return Confirm(parentWindow, dialogTitle, text, _retval);
	}
	
	public int ConfirmCheck(int /*long*/ dialogTitle, int /*long*/ text, int /*long*/ checkMsg, int /*long*/ checkValue, int /*long*/ _retval) {
		return ConfirmCheck(parentWindow, dialogTitle, text, checkMsg, checkValue, _retval);
	}
	
	public int ConfirmEx(int /*long*/ dialogTitle, int /*long*/ text, int buttonFlags, int /*long*/ button0Title, int /*long*/ button1Title, int /*long*/ button2Title, int /*long*/ checkMsg, int /*long*/ checkValue, int /*long*/ _retval) {
		return ConfirmEx(parentWindow, dialogTitle, text, buttonFlags, button0Title, button1Title, button2Title, checkMsg, checkValue, _retval);
	}
	
	public int Prompt(int /*long*/ dialogTitle, int /*long*/ text, int /*long*/ value, int /*long*/ checkMsg, int /*long*/ checkValue, int /*long*/ _retval) {
		return Prompt(parentWindow, dialogTitle, text, value, checkMsg, checkValue, _retval);
	}
	
	public int PromptUsernameAndPassword(int /*long*/ dialogTitle, int /*long*/ text, int /*long*/ username, int /*long*/ password, int /*long*/ checkMsg, int /*long*/ checkValue, int /*long*/ _retval) {
		return PromptUsernameAndPassword(parentWindow, dialogTitle, text, username, password, checkMsg, checkValue, _retval);
	}
	
	public int PromptPassword(int /*long*/ dialogTitle, int /*long*/ text, int /*long*/ password, int /*long*/ checkMsg, int /*long*/ checkValue, int /*long*/ _retval) {
		return PromptPassword(parentWindow, dialogTitle, text, password, checkMsg, checkValue, _retval);
	}
	
	public int Select(int /*long*/ dialogTitle, int /*long*/ text, int count, int /*long*/ selectList, int /*long*/ outSelection, int /*long*/ _retval) {
		return Select(parentWindow, dialogTitle, text, count, selectList, outSelection, _retval);
	}
	
	// xul 8.0, nsIPrompt
	public void setParentWindow(int /*long*/ parent) {
		parentWindow = parent;
	}
	
	public int /*long*/ getParentWindow() {
		return parentWindow;
	}
	
	/* nsIPromptService */
	//have been replaced by jface dialog
	public int Alert(int /*long*/ parent, int /*long*/ dialogTitle, int /*long*/ text) {
		Composite browser = getBrowser(parent);
	
			Shell shell = null;
			if (parent != 0) {
				if (browser != null)
					shell = browser.getShell(); 
			}
			if (shell == null) {
				Display display = Display.getCurrent();
			    if (null == display)
			    	display = Display.getDefault();
				
			    if (display != null) {
				    shell = display.getActiveShell();
				    if (null == shell)
				    	shell = new Shell(display);
			    }
			}
			if (null == shell)
				return XPCOM.NS_ERROR_FAILURE;
			
			String titleLabel = WString.toNotNullString(dialogTitle);
			String textLabel = WString.toNotNullString(text);

			/*
			* Bug in XULRunner 1.9.  On win32, Mozilla does not clear its background before content has
			* been set into it.  As a result, embedders appear broken if they do not immediately display
			* a URL or text.  The Mozilla bug for this is https://bugzilla.mozilla.org/show_bug.cgi?id=453523.
			* 
			* In this case SPR#RBAR8HWNDG, workaround is to setUrl("about:blank") directly.
			*/
			if(browser != null){
				if (textLabel.indexOf ("ssl_error_handshake_failure_alert") != -1) {
					DOMBrowser dombrowser = (DOMBrowser)browser;
					dombrowser.setUrl("about:blank");
				}
			}	
			
			/*
			* If mozilla is showing its errors with dialogs (as opposed to pages) then the only
			* opportunity to detect that a page has an invalid certificate, without receiving
			* all notification callbacks on the channel, is to detect the displaying of an alert
			* whose message contains an internal cert error code.  If a such a message is
			* detected then instead of showing it, re-navigate to the page with the invalid
			* certificate so that the browser's nsIBadCertListener2 will be invoked.
			*/
			if (browser != null) {
				for (int i = 0; i < certErrorCodes.length; i++) {
					if (textLabel.indexOf (certErrorCodes[i]) != -1) {
						DOMBrowser dombrowser = (DOMBrowser)browser;
						MozillaEmbeddingSite site =dombrowser.mozillaEmbeddingSite;
						site.isRetrievingBadCert = true;
						
						dombrowser.setUrl (site.lastNavigateURL);
						return XPCOM.NS_OK;	
					}
				}
			}
			
			/*
			 * For PCR 11767, if User add AlertListener, create AlertEvent to 
			 * let user have the chance to implement their customized Alert Dialog,
			 * or used the default Alert Dialog with customized information.
			 */
			if(browser instanceof MozillaBrowser && ((MozillaBrowser)browser).alertListeners.length > 0) {
				AlertEvent newAlertEvent = new AlertEvent(browser);
				newAlertEvent.alertText = textLabel; // set with the default alert text
				newAlertEvent.alertTitle = titleLabel;  // set with the default alert title
				
				try{
					for(int i = 0; i < ((MozillaBrowser)browser).alertListeners.length; i++) {
						logger.logp(Level.FINEST, CLZ_Name, "Alert", //$NON-NLS-1$
						"AlertListeners invoked!"); //$NON-NLS-1$
						
						((MozillaBrowser)browser).alertListeners[i].handleAlertDialog(newAlertEvent);					
					}
					// useDefaultDialog == true, show the default Alert Dialog, useDefaultDialog == false, show the customized Alert Dialog
					if(newAlertEvent.useDefaultDialog) { 
						// use the default AlertDialog
						MessageDialog.openInformation(shell, newAlertEvent.alertTitle, newAlertEvent.alertText);
					}
				} catch(Throwable e) {
					logger.log(Level.SEVERE, "AlertListener handleAlertDialog exception", e);  //$NON-NLS-1$
				}
			}
			else
				MessageDialog.openInformation(shell, titleLabel, textLabel);
			
		return XPCOM.NS_OK;
	}
	
	public int AlertCheck(int /*long*/ parent, int /*long*/ dialogTitle, int /*long*/ text, int /*long*/ checkMsg, int /*long*/ checkValue) {
		return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
	}
	
	
	//have been replaced with jface dialog.But havn't been validate.
	public int Confirm(int /*long*/ parent, int /*long*/ dialogTitle, int /*long*/ text, int /*long*/ _retval) {
		
			Composite browser = getBrowser(parent);
			if(browser instanceof DOMBrowser){
				DOMBrowser mBrowser = (DOMBrowser) browser;
				if (mBrowser != null && mBrowser.ignoreAllMessages) 
				{
					// for xul 10.0
					//XPCOM.memmove (_retval, new int[] {1}, 4); /* PRBool */
					XPCOM.memmove (_retval, new int[] {1}, 1); /*bool*/
					return XPCOM.NS_OK;
				}
			}
			
			String titleLabel = WString.toNotNullString(dialogTitle);
			String textLabel =  WString.toNotNullString(text);
			
			Shell shell = browser == null ? new Shell () : browser.getShell ();
			
			boolean ok = MessageDialog.openConfirm(shell, titleLabel, textLabel);
			int[] result = { ok ? 1: 0 };
			// for xul 10.0
			//XPCOM.memmove(_retval, result, 4);  /* PRBool */
			XPCOM.memmove(_retval, result, 1); /*bool*/
			
		return XPCOM.NS_OK;
	}
	
	public int ConfirmCheck(int /*long*/ parent, int /*long*/ dialogTitle, int /*long*/ text, int /*long*/ checkMsg, int /*long*/ checkValue, int /*long*/ _retval) {
		return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
	}
	
	//have been replaced with jface dialog.
	public int ConfirmEx(int /*long*/ parent, int /*long*/ dialogTitle, int /*long*/ text, int buttonFlags, int /*long*/ button0Title, int /*long*/ button1Title, int /*long*/ button2Title, int /*long*/ checkMsg, int /*long*/ checkValue, int /*long*/ _retval) {
		   final String METHOD = "ConfirmEx";  //$NON-NLS-1$
			Composite browser = getBrowser(parent);
			if(browser instanceof DOMBrowser){
				DOMBrowser mBrowser = (DOMBrowser) browser;
				if (mBrowser != null && mBrowser.ignoreAllMessages) 
				{
					XPCOM.memmove (_retval, new int[] {1}, 1); /*bool*/
					return XPCOM.NS_OK;
				}
			}
			
			String titleLabel = WString.toNotNullString(dialogTitle);
			String textLabel = WString.toNotNullString(text);
			String checkLabel = WString.toNotNullString(checkMsg);
					
			String button1Label = getLabel(buttonFlags, nsIPromptService.BUTTON_POS_0, button0Title);
			String button2Label = getLabel(buttonFlags, nsIPromptService.BUTTON_POS_1, button1Title);
			String button3Label = getLabel(buttonFlags, nsIPromptService.BUTTON_POS_2, button2Title);

			int[] check = new int[1];
			int[] result = new int[]{1};
			if (checkValue != 0){
				// for xul 10.0
				// XPCOM.memmove(check, (int) /* 64 */checkValue, 4);  /* PRBool */
				XPCOM.memmove(check, checkValue, 1); /*bool*/
			}
			Shell shell = browser == null ? new Shell () : browser.getShell ();
			
			/*
			 * If user had added <code>ConfirmListener</code> to browser, then create a ConfirmEvent 
    		 * to let user to have the chance to disable the default ConfirmEx Dialog, or use a customized
    		 * ConfirmEx Dialog to replace the default one 
		 	 */
			if(browser instanceof MozillaBrowser && ((MozillaBrowser)browser).confirmListeners.length > 0) {
				ConfirmEvent newEvent = new ConfirmEvent(browser, titleLabel, textLabel, button1Label,
						button2Label, button3Label, checkLabel, check);
				
				try{
					for(int i=0; i<((MozillaBrowser)browser).confirmListeners.length; i++) {
						logger.logp(Level.FINEST, CLZ_Name, METHOD, "ConfirmListeners invoked!"); //$NON-NLS-1$
						
						((MozillaBrowser)browser).confirmListeners[i].handleConfirmDialog(newEvent);
					}
					// useDefaultDialog == true, show the default ConfirmEx Dialog, 
					if(newEvent.useDefaultDialog) { 
						ComfirmExDialog dialog = new ComfirmExDialog(shell,
								newEvent.dialogTitle, newEvent.dialogText, newEvent.checkMsg, newEvent.buttonTitle[0], 
								newEvent.buttonTitle[1], newEvent.buttonTitle[2], newEvent.checkValue);
						dialog.open();
						result = dialog.getResult();
						check = dialog.getCheckValue();
					}
					else { // useDefaultDialog == false, show the customized ConfirmEx Dialog, or no ConfirmEx Dialog at all
						result = newEvent.optionValue;  // Get button chosen value from user setting
						check = newEvent.checkValue;  // Get checkbox chosen value from user setting
					}
				}catch(Throwable e) {
					logger.logp(Level.SEVERE, CLZ_Name, METHOD, "ConfirmListener handleConfirmDialog exception", e);  //$NON-NLS-1$
				}
			}
			else {  // Use Default ConfirmEx Dialog
				ComfirmExDialog dialog = new ComfirmExDialog(shell,
						titleLabel, textLabel, checkLabel, button1Label, button2Label,
						button3Label, check);
				dialog.open();
				result = dialog.getResult();
				check = dialog.getCheckValue();
			}
			
			// overwrite result
			if (checkValue != 0){
				// for xul 10.0
				// XPCOM.memmove(checkValue, dialog.getCheckValue(), 4); /* PRBool */
				XPCOM.memmove(checkValue, check, 1); /*bool*/
			}				
			XPCOM.memmove(_retval, result, 4);

		return XPCOM.NS_OK;
	}
	
	//have been replaced with jface dialog.
	public int Prompt(int /*long*/ parent, int /*long*/ dialogTitle, int /*long*/ text, int /*long*/ value, int /*long*/ checkMsg, int /*long*/ checkValue, int /*long*/ _retval) {
			Composite browser = getBrowser(parent);
			String titleLabel = WString.toNotNullString(dialogTitle);
			String textLabel = WString.toNotNullString(text);
			String checkLabel = WString.toNotNullString(checkMsg);
			
			int /*long*/[] valueAddr = new int /*long*/[1];
			XPCOM.memmove(valueAddr, value, XPCOMObject.PTR_SIZEOF);
			String[] valueLabel = new String[] { WString.toString(valueAddr[0]) };
					
			int[] dialogResult = new int[1];
			String promptValue = null;
			int[] promptCheckValue = new int[1];
			
			int[] check = new int[1];
			if (checkValue != 0) {
				// for xul 10.0
				// XPCOM.memmove(check, (int)/*64*/checkValue, 4); /* PRBool */
				XPCOM.memmove(check, checkValue, 1); /*bool*/
				
			}
			Shell shell = browser == null ? new Shell () : browser.getShell ();
			//Fix for SPR#JYLU8VFFSY
			if(browser instanceof MozillaBrowser && ((MozillaBrowser)browser).promptListeners.length > 0) {
				PromptEvent newPromptEvent = new PromptEvent(browser, titleLabel, textLabel, valueLabel[0], checkLabel, check);
				
				try{
					for(int i = 0; i < ((MozillaBrowser)browser).promptListeners.length; i++) {
						logger.logp(Level.FINEST, CLZ_Name, "Prompt", //$NON-NLS-1$
						"PromptListeners invoked!"); //$NON-NLS-1$
						
						((MozillaBrowser)browser).promptListeners[i].handlePromptDialog(newPromptEvent);
					}
					// useDefaultDialog == true, show the default prompt dialog, useDefaultDialog == false, show the customized prompt Dialog
					if(newPromptEvent.useDefaultDialog) { 
						// use the default PromptDialog
						PromptDialogEx dialog = new PromptDialogEx(shell,newPromptEvent.promptTitle, 
								newPromptEvent.promptText, newPromptEvent.checkMessage, 
								new String[]{newPromptEvent.promptValue}, newPromptEvent.checkValue);
						dialog.open();
						dialogResult = dialog.getResult();
						promptValue = dialog.getValue();
						promptCheckValue = dialog.getCheckValue();
						
					}else{
						/*
						 *  useDefaultDialog == false, show the customized Prompt dialog, or no prompt Dialog at all, 
						 *  but user need set the required value into event fields.
						 */
						dialogResult = newPromptEvent.dialogResult;
						promptValue = newPromptEvent.promptValue;
						promptCheckValue = newPromptEvent.checkValue;
					}
				} catch(Throwable e) {
					logger.log(Level.SEVERE, "PromptListener handlePromptDialog exception", e);  //$NON-NLS-1$
				}
			}else{
				PromptDialogEx dialog = new PromptDialogEx(shell, titleLabel, textLabel, checkLabel, valueLabel, check);
				dialog.open();
				dialogResult = dialog.getResult();
				promptValue = dialog.getValue();
				promptCheckValue = dialog.getCheckValue();
			}
			// for xul 10.0
			//XPCOM.memmove(_retval, dialog.getResult(), 4);  /* PRBool */ 
			XPCOM.memmove(_retval, dialogResult, 1); /*bool*/
			if (dialogResult[0] == 1) {
				/* 
				* User selected OK. User name and password are returned as PRUnichar values. Any default
				* value that we override must be freed using the nsIMemory service.
				*/
				int cnt, size;
				int /*long*/ ptr;
				char[] buffer;
				int /*long*/[] result2 = new int /*long*/[1];
				if (promptValue != null) {
				

					if (valueAddr[0] != 0) {
						int rc = XPCOM.NS_GetServiceManager(result2);
						if (rc != XPCOM.NS_OK) SWT.error(rc);
						if (result2[0] == 0) SWT.error(XPCOM.NS_NOINTERFACE);
					
						nsIServiceManager serviceManager = new nsIServiceManager(result2[0]);
						result2[0] = 0;
						byte[] tmp = XPCOM.NS_MEMORY_CONTRACTID.getBytes();
						byte[] aContractID = new byte[tmp.length + 1];
						System.arraycopy(tmp, 0, aContractID, 0, tmp.length);
						rc = serviceManager.GetServiceByContractID(aContractID, nsIMemory.NS_IMEMORY_IID, result2);
						if (rc != XPCOM.NS_OK) SWT.error(rc);
						if (result2[0] == 0) SWT.error(XPCOM.NS_NOINTERFACE);		
						serviceManager.Release();
						
						nsIMemory memory = new nsIMemory(result2[0]);
						result2[0] = 0;
						
						cnt = promptValue.length();
						buffer = new char[cnt + 1];
						promptValue.getChars(0, cnt, buffer, 0);
						size = buffer.length * 2;
						ptr = memory.Alloc(size);
						XPCOM.memmove(ptr, buffer, size);
						XPCOM.memmove(value, new int /*long*/[] {ptr}, XPCOMObject.PTR_SIZEOF);
						
						
						memory.Free(valueAddr[0]);
						memory.Release();
					}
				}
			}
			if (checkValue != 0) {
				// for xul 10.0
				// XPCOM.memmove(checkValue, dialog.getCheckValue(), 4); /* PRBool */ 
				XPCOM.memmove(checkValue, promptCheckValue, 1); /*bool*/
			}

		return XPCOM.NS_OK;
	}
	
	
	//have been replaced with jface dialog.
	public int PromptUsernameAndPassword(int /*long*/ parent, int /*long*/ dialogTitle, int /*long*/ text, int /*long*/ username, int /*long*/ password, int /*long*/ checkMsg, int /*long*/ checkValue, int /*long*/ _retval) {
		Composite browser = getBrowser(parent);
		String usernameData = null;
		char[] passwordData = null;
		
		if ((browser != null)&& (browser instanceof DOMBrowser)) {
			DOMBrowser dombrowser = (DOMBrowser)browser;
			MozillaEmbeddingSite site = dombrowser.mozillaEmbeddingSite;
			/*
			 * Do not invoke the listeners if this challenge has been failed too many
			 * times because a listener is likely giving incorrect credentials repeatedly
			 * and will do so indefinitely.
			 */
			if (site.authCount++ < 3) {
				try {
					for (int i = 0; i < dombrowser.authenticationListeners.length; i++) {
						AuthenticationEvent event = new AuthenticationEvent (browser);
						event.location = site.lastNavigateURL;
						dombrowser.authenticationListeners[i].authenticate (event);
						if (!event.doit) {
							// for xul 10.0
							//XPCOM.memmove (_retval, new int[] {0}, 4);	/* PRBool */
							XPCOM.memmove (_retval, new int[] {0}, 1); /*bool*/
							return XPCOM.NS_OK;
						}
						if (event.user != null && event.password != null) {
							usernameData = event.user;
							passwordData = event.password.toCharArray();
							// for xul 10.0
							//XPCOM.memmove (_retval, new int[] {1}, 4);	/* PRBool */
							XPCOM.memmove (_retval, new int[] {1}, 1); /*bool*/
							break;
						}
					}
				} catch (Throwable e) {
					logger.log(Level.SEVERE, "PromptUsernameAndPassword.authenticationListeners.authenticate", e);  //$NON-NLS-1$
				}
			}
		}

		if (usernameData == null) {
			/* no listener handled the challenge, so show an authentication dialog */
			String titleLabel = WString.toNotNullString(dialogTitle);
			String textLabel = WString.toNotNullString(text);
			String checkLabel = WString.toNotNullString(checkMsg);

			int /*long*/[] userAddr = new int /*long*/[1];
			XPCOM.memmove(userAddr, username, XPCOMObject.PTR_SIZEOF);
			String[] userLabel = new String[] { WString.toString(userAddr[0])};
					
			int /*long*/[] passAddr = new int /*long*/[1];
			XPCOM.memmove(passAddr, password, XPCOMObject.PTR_SIZEOF);
			char[] passLabel = WString.toCharArray(passAddr[0]);

			int[] check = new int[1];
			int[] result = new int[1];
			if (checkValue != 0) {
				// for xul 10.0
				// XPCOM.memmove(check, (int) /* 64 */checkValue, 4);  /* PRBool */
				XPCOM.memmove(check, checkValue, 1); /*bool*/
			}
			Shell shell = browser == null ? new Shell () : browser.getShell ();
			
			PromptUsernameAndPasswordDialog dialog = null;
			try {
				dialog = new PromptUsernameAndPasswordDialog(
						shell, titleLabel, textLabel, checkLabel,
						userLabel, passLabel, check);

				dialog.open();
				result = dialog.getResult();
			} catch (Exception e) {
				logger.log(Level.SEVERE, "callback exception", e);  //$NON-NLS-1$
				return XPCOM.NS_ERROR_FAILURE;
			}
			
			// for xul 10.0
			// XPCOM.memmove(_retval, result, 4); /* PRBool */
			XPCOM.memmove(_retval, result, 1); /*bool*/
				
			if ( result[0] == 1) {
				/* 
				* User selected OK. 
				*/
				usernameData = dialog.getUsername();
				passwordData = Arrays.copyOf(dialog.getPassword(), dialog.getPassword().length);
			}
			if (checkValue != 0) {
				// XPCOM.memmove(checkValue, dialog.getCheckValue(), 4); /* PRBool */
				XPCOM.memmove(checkValue, dialog.getCheckValue(), 1); /*bool*/
			}
		}
			
		if (usernameData != null) {
			/* 
			* User name and password are returned as PRUnichar values. Any default
			* value that we override must be freed using the nsIMemory service.
			*/
			int /*long*/[] userAddr = new int /*long*/[1];
			XPCOM.memmove(userAddr, username, XPCOMObject.PTR_SIZEOF);
			int /*long*/[] passAddr = new int /*long*/[1];
			XPCOM.memmove(passAddr, password, XPCOMObject.PTR_SIZEOF);
			
			int /*long*/[] result2 = new int /*long*/[1];
			int rc = XPCOM.NS_GetServiceManager(result2);
			if (rc != XPCOM.NS_OK) SWT.error(rc);
			if (result2[0] == 0) SWT.error(XPCOM.NS_NOINTERFACE);
		
			nsIServiceManager serviceManager = new nsIServiceManager(result2[0]);
			result2[0] = 0;
			byte[] tmp = XPCOM.NS_MEMORY_CONTRACTID.getBytes();
			byte[] aContractID = new byte[tmp.length + 1];
			System.arraycopy(tmp, 0, aContractID, 0, tmp.length);
			rc = serviceManager.GetServiceByContractID(aContractID, nsIMemory.NS_IMEMORY_IID, result2);
			if (rc != XPCOM.NS_OK) SWT.error(rc);
			if (result2[0] == 0) SWT.error(XPCOM.NS_NOINTERFACE);		
			serviceManager.Release();
			
		
			
			nsIMemory memory = new nsIMemory(result2[0]);
			if ((userAddr[0] != 0) || (passAddr[0] != 0)){

				if (userAddr[0] != 0) memory.Free (userAddr[0]);
				if (passAddr[0] != 0) memory.Free (passAddr[0]);
				
			}
			
			/* write the name and password values */
			int cnt, size;
			int /*long*/ ptr;
			char[] buffer;

			cnt = usernameData.length();
			buffer = new char[cnt + 1];
			usernameData.getChars(0, cnt, buffer, 0);
			size = buffer.length * 2;
			ptr = memory.Alloc(size);
			XPCOM.memmove(ptr, buffer, size);
			XPCOM.memmove(username, new int /*long*/ [] { ptr }, XPCOMObject.PTR_SIZEOF);

			if (passwordData != null && passwordData.length > 0) {
				cnt = passwordData.length;
				buffer = new char[cnt + 1];
				System.arraycopy(passwordData, 0, buffer, 0, cnt);
				size = buffer.length * 2;
				ptr = memory.Alloc(size);
				XPCOM.memmove(ptr, buffer, size);
				XPCOM.memmove(password, new int /*long*/ [] { ptr }, XPCOMObject.PTR_SIZEOF);
			}
			
			memory.Release();
		}

		return XPCOM.NS_OK;
	}
	
	public int PromptPassword(int /*long*/ parent, int /*long*/ dialogTitle, int /*long*/ text, int /*long*/ password, int /*long*/ checkMsg, int /*long*/ checkValue, int /*long*/ _retval) {
		return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
	}
	
	public int Select(int /*long*/ parent, int /*long*/ dialogTitle, int /*long*/ text, int count, int /*long*/ selectList, int /*long*/ outSelection, int /*long*/ _retval) {
		return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
	}
	

	int PromptAuth(int /*long*/ aParent, int /*long*/ aChannel, int level, int /*long*/ authInfo, int /*long*/ checkboxLabel, int /*long*/ checkboxValue, int /*long*/ _retval) {
		Composite browser = getBrowser(aParent);

		nsIAuthInformation auth = new nsIAuthInformation (authInfo);
		
		// Get realm
		int /*long*/ aRealm = XPCOM.nsEmbedString_new ();
		int rc = auth.GetRealm (aRealm);
		if (rc != XPCOM.NS_OK) SWT.error (rc);
		String realm=null;
		if(aRealm != 0){
			int length = XPCOM.nsEmbedString_Length (aRealm);
			int /*long*/ realmBuffer = XPCOM.nsEmbedString_get (aRealm);
			char[] chars = new char[length];
			XPCOM.memmove (chars, realmBuffer, length * 2);
			realm = new String (chars);
			XPCOM.nsEmbedString_delete (aRealm);
		}else{
			realm="";
		}
		
		// Get the auth flag
		int[] flags = new int[1];
		rc = auth.GetFlags(flags);
		if (rc != XPCOM.NS_OK) SWT.error (rc);
		if (flags[0] == 0) DOMBrowser.error (XPCOM.NS_NOINTERFACE);
		
		// Get url
		nsIChannel channel = new nsIChannel (aChannel);
		int /*long*/[] uri = new int /*long*/[1];
		rc = channel.GetURI (uri);
		if (rc != XPCOM.NS_OK) SWT.error (rc);
		if (uri[0] == 0) DOMBrowser.error (XPCOM.NS_NOINTERFACE);

		nsIURI nsURI = new nsIURI (uri[0]);
		int /*long*/ aSpec = XPCOM.nsEmbedCString_new ();
		rc = nsURI.GetSpec(aSpec);
		if (rc != XPCOM.NS_OK) SWT.error (rc);
		int length = XPCOM.nsEmbedCString_Length (aSpec);
		int /*long*/ buffer = XPCOM.nsEmbedCString_get (aSpec);
		byte[] bytes = new byte[length];
		XPCOM.memmove (bytes, buffer, length);
		XPCOM.nsEmbedCString_delete (aSpec);
		String url = new String (bytes);
		
		/*
		 * Do the browser SSO here! 
		 */
		if ((browser != null) && (browser instanceof DOMBrowser)) {
			DOMBrowser dombrowser = (DOMBrowser)browser;
			MozillaEmbeddingSite site = dombrowser.mozillaEmbeddingSite;
			
			// For SPR#LTZZ8QPCK8
			if (dombrowser.isSSOEnabled() && dombrowser.isSSOSupported() && !"about:blank".equalsIgnoreCase(url)){
				// do sso here to get the username and password from Account
				if((flags[0] & nsIAuthInformation.AUTH_PROXY) == nsIAuthInformation.AUTH_PROXY){
					// handle the proxy authentication here
					dombrowser.doProxySSO(url, realm);
				} 
				else{
					// handle the basic authentication here
					dombrowser.doBrowserSSO(url, realm);
				}
				// get username and password
				AccountInfo info = BrowserSSOManager.getInstance().getAccountInfo(url, realm);
				if(info != null){
					String username = info.getUsername();
					char[] password = info.getPassword();
					String actRealm = info.getRealm();
					if(actRealm.equalsIgnoreCase(realm)){
						// set the username/password to xulrunner
						nsEmbedString string = new nsEmbedString (username);
						rc = auth.SetUsername(string.getAddress ());
						if (rc != XPCOM.NS_OK) SWT.error (rc);
						string.dispose ();
						
						string = new nsEmbedString (String.valueOf(password));
						rc = auth.SetPassword(string.getAddress ());
						if (rc != XPCOM.NS_OK) SWT.error (rc);
						string.dispose ();
						// clear the account info after used
						BrowserSSOManager.getInstance().removeAccountInfo(url, realm);
						
						// for xul 10.0
						//XPCOM.memmove (_retval, new int[] {1}, 4);	/* PRBool */
						XPCOM.memmove (_retval, new int[] {1}, 1); /*bool*/
						return XPCOM.NS_OK;
					}
				}
			}
			
			/*
			 * Do not invoke the listeners if this challenge has been failed too many
			 * times because a listener is likely giving incorrect credentials repeatedly
			 * and will do so indefinitely.
			 */
			if (site.authCount++ < 3) {
				try {
					for (int i = 0; i < dombrowser.authenticationListeners.length; i++) {
						AuthenticationEvent event = new AuthenticationEvent (browser);
						event.location = site.lastNavigateURL;
						dombrowser.authenticationListeners[i].authenticate (event);
						if (!event.doit) {
							// for xul 10.0
							//XPCOM.memmove (_retval, new int[] {0}, 4);	/* PRBool */
							XPCOM.memmove (_retval, new int[] {0}, 1); /*bool*/
							return XPCOM.NS_OK;
						}
						if (event.user != null && event.password != null) {
							nsEmbedString string = new nsEmbedString (event.user);
							rc = auth.SetUsername (string.getAddress ());
							if (rc != XPCOM.NS_OK) SWT.error (rc);
							string.dispose ();
							string = new nsEmbedString (event.password);
							rc = auth.SetPassword (string.getAddress ());
							if (rc != XPCOM.NS_OK) SWT.error (rc);
							string.dispose ();
							// for xul 10.0
							//XPCOM.memmove (_retval, new int[] {1}, 4);	/* PRBool */
							XPCOM.memmove (_retval, new int[] {1}, 1); /*bool*/
							return XPCOM.NS_OK;
						}
					}
				} catch (Throwable e) {
					logger.log(Level.SEVERE, "PromptAuth.authenticationListeners.authenticate", e);  //$NON-NLS-1$
				}
			}
			/*
			 * SPR # JYJC8AD9QH, IF there is AuthenticationListener, use User set credential to try 3 times , if failed login,
			 * then prompt out "authentication dialog" to ask user to input correct credential, try 3 times, if failed login, then return. 
			 * IF there is no AuthenticationListener, then prompt out "authentication dialog" to ask user to input credential, try 3 times;
			 * Keep the same behavior with IE.
			 */
			if(((dombrowser.authenticationListeners.length > 0) && (site.authCount > 6)) || 
			   ((dombrowser.authenticationListeners.length == 0) && (site.authCount > 3))){
				// for xul 10.0
				//XPCOM.memmove (_retval, new int[] {0}, 4);	/* PRBool */
				XPCOM.memmove (_retval, new int[] {0}, 1); /*bool*/
				return XPCOM.NS_OK;
			}
		}

		/* no listener handled the challenge, so show an authentication dialog */
		
		String checkLabel = null;
		int[] checkValue = new int[1];
		String[] userNameValue = new String[1];
		char[] passwordValue = null;

		String title = SWT.getMessage ("SWT_Authentication_Required"); //$NON-NLS-1$

		/* compute the message text */

		aSpec = XPCOM.nsEmbedCString_new ();
		rc = nsURI.GetHost (aSpec);
		if (rc != XPCOM.NS_OK) SWT.error (rc);
		length = XPCOM.nsEmbedCString_Length (aSpec);
		buffer = XPCOM.nsEmbedCString_get (aSpec);
		bytes = new byte[length];
		XPCOM.memmove (bytes, buffer, length);
		XPCOM.nsEmbedCString_delete (aSpec);
		String host = new String (bytes);
		nsURI.Release ();

		String message;
		if (realm.length () > 0 && host.length () > 0) {
			message = Compatibility.getMessage ("SWT_Enter_Username_and_Password", new String[] {realm, host}); //$NON-NLS-1$
		} else {
			message = ""; //$NON-NLS-1$
		}
		
		nsEmbedString nsHost = new nsEmbedString(host);
		nsEmbedString nsRealm = new nsEmbedString(realm);
		nsILoginManager loginManager = LoginHelper.getLoginManager();
		int[] loginCount = new int[1];
		int /*long*/[] logins = new int /*long*/[1];
		nsILoginInfo loginInfoSavedBefore = null;
		
		//get user name and password
		
		rc = loginManager.CountLogins(nsHost.getAddress(), 0, nsRealm.getAddress(), loginCount);
		if (rc != XPCOM.NS_OK) SWT.error(rc);
		if(loginCount[0] > 0){
			checkValue[0] = 1;
			if (rc != XPCOM.NS_OK) SWT.error(rc);
			logins = new int /*long*/[loginCount[0]];
			//get all user nsLoginInfo by detail criterion		
			rc = loginManager.FindLogins(loginCount, nsHost.getAddress(), 0, nsRealm.getAddress(), logins);
			if (rc != XPCOM.NS_OK) SWT.error(rc);
			//get initial user name and password that entered last time
			loginInfoSavedBefore = new nsILoginInfo(logins[loginCount[0]-1]);
			int /*long*/ intUserName = XPCOM.nsEmbedString_new();
			int /*long*/ intPassword = XPCOM.nsEmbedString_new();
			rc = loginInfoSavedBefore.GetUsername(intUserName);
			if (rc != XPCOM.NS_OK) SWT.error(rc);
			int userNameLength = XPCOM.nsEmbedString_Length(intUserName);
			int /*long*/ userNameBuffer = XPCOM.nsEmbedString_get(intUserName);
			char[] userNameChars = new char[userNameLength];
			XPCOM.memmove(userNameChars, userNameBuffer, userNameLength*2);
			userNameValue[0] = String.valueOf(userNameChars);
			XPCOM.nsEmbedString_delete(intUserName);
			rc = loginInfoSavedBefore.GetPassword(intPassword);
			if (rc != XPCOM.NS_OK) SWT.error(rc);
			int passwordLength = XPCOM.nsEmbedString_Length(intPassword);
			int /*long*/ passwordBuffer = XPCOM.nsEmbedString_get(intPassword);
			passwordValue = new char[passwordLength];
			XPCOM.memmove(passwordValue, passwordBuffer, passwordLength*2);
			XPCOM.nsEmbedString_delete(intPassword);
		}
				
		checkLabel = getCheckLabel();
		
		/* open the prompter */
		Shell shell = browser == null ? new Shell () : browser.getShell ();
		
		PromptUsernameAndPasswordDialog dialog = new PromptUsernameAndPasswordDialog(
				shell, title, message, checkLabel,
				userNameValue, passwordValue, checkValue);

		dialog.open();
		
		// for xul 10.0
		// XPCOM.memmove(_retval, dialog.getResult(), 4);  /* PRBool */
		XPCOM.memmove(_retval, dialog.getResult(), 1); /*bool*/

		if (dialog.getResult()[0] == 1) {	/* User selected OK */
			nsEmbedString string = new nsEmbedString (dialog.getUsername());
			rc = auth.SetUsername(string.getAddress ());
			if (rc != XPCOM.NS_OK) SWT.error (rc);
			string.dispose ();
			
			char[] pw = new char[dialog.getPassword().length + 1];
			System.arraycopy(dialog.getPassword(), 0, pw, 0, dialog.getPassword().length);
			string = new nsEmbedString (pw);
			rc = auth.SetPassword(string.getAddress ());
			if (rc != XPCOM.NS_OK) SWT.error (rc);
			string.dispose ();
		}
		
		//save username and password 
		
		int[] saveEnabled = new int[1];
		rc = loginManager.GetLoginSavingEnabled(nsHost.getAddress(), saveEnabled);
		if(saveEnabled[0] == 0){
			saveEnabled[0] = 1;
			rc = loginManager.SetLoginSavingEnabled(nsHost.getAddress(), saveEnabled[0]);
		}
		if (rc != XPCOM.NS_OK) SWT.error(rc);
		if(dialog.getCheckValue()[0] == 1 && dialog.getResult()[0] == 1){
			if(dialog.getUsername().trim().length() > 0 && dialog.getPassword().length > 0){
				//remove the nsILoginInfo entered last time
				if(loginCount[0] > 0){
					rc = loginManager.RemoveLogin(logins[loginCount[0]-1]);
					if (rc != XPCOM.NS_OK) SWT.error(rc);
					if(loginInfoSavedBefore != null){
						loginInfoSavedBefore.Release();
					}
				}
				
				nsILoginInfo loginInfo = LoginHelper.getLoginInfo();
				
				nsEmbedString userName = new nsEmbedString(dialog.getUsername());
				char[] pw = new char[dialog.getPassword().length + 1];
				System.arraycopy(dialog.getPassword(), 0, pw, 0, dialog.getPassword().length);
				nsEmbedString password = new nsEmbedString(pw);		
				nsEmbedString usernameField = new nsEmbedString("");  //$NON-NLS-1$
				nsEmbedString passwordField = new nsEmbedString("");  //$NON-NLS-1$
				
				rc = loginInfo.SetHostname(nsHost.getAddress());
				rc = loginInfo.SetFormSubmitURL(0);
				if(nsRealm.toString().equals("")){  //$NON-NLS-1$
					rc = loginInfo.SetHttpRealm(nsHost.getAddress());
				}else{
					rc = loginInfo.SetHttpRealm(nsRealm.getAddress());
				}
				rc = loginInfo.SetUsername(userName.getAddress());
				rc = loginInfo.SetPassword(password.getAddress());
				rc = loginInfo.SetUsernameField(usernameField.getAddress());
				rc = loginInfo.SetPasswordField(passwordField.getAddress());
				
				//AddLogin method will fail if both the httprealm and formsubmiturl parameters are null
				rc = loginManager.AddLogin(loginInfo.getAddress());
				if (rc != XPCOM.NS_OK) SWT.error(rc);
				
				userName.dispose();
				password.dispose();
				usernameField.dispose();
				passwordField.dispose();
				loginInfo.Release();
			}
		}
		
		nsHost.dispose();
		nsRealm.dispose();		

		return XPCOM.NS_OK;
	}
	
	private String getCheckLabel(){
		nsIStringBundleService stringBundleService = StringBundleHelper.getStringBundleService();
		int /*long*/[] stringBundleResult = new int /*long*/[1];
		byte[] stringBundleBuffer = pwdManagerPropertyFile.getBytes();
		byte[] stringBundleSpec = new byte[stringBundleBuffer.length + 1];
		System.arraycopy(stringBundleBuffer, 0, stringBundleSpec, 0, stringBundleBuffer.length);
		int rc = stringBundleService.CreateBundle(stringBundleSpec, stringBundleResult);
		if(rc != XPCOM.NS_OK) SWT.error(rc);
		nsIStringBundle stringBundle = new nsIStringBundle(stringBundleResult[0]);

		stringBundleResult[0] = 0;
		char[] rpBuffer = rememberPwdKey.toCharArray();
		char[] rpName = new char[rpBuffer.length + 1];
		System.arraycopy(rpBuffer, 0, rpName, 0, rpBuffer.length);
		rc = stringBundle.GetStringFromName(rpName, stringBundleResult);
		stringBundle.Release();
		if(rc != XPCOM.NS_OK) SWT.error(rc);
		return WString.toNotNullString(stringBundleResult[0]);
	}
	
	int AsyncPromptAuth(int /*long*/ aParent, int /*long*/ aChannel, int /*long*/ aCallback, int /*long*/ aContext, int level, int /*long*/ authInfo, int /*long*/ checkboxLabel, int /*long*/ checkValue, int /*long*/ _retval) {
		return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
	}

	// For xul 10.0
	/* nsIAuthPrompt2 */
	public int PromptAuth(int /*long*/ aChannel, int level, int /*long*/ authInfo, int /*long*/ retVal) {
		/* nsIPromptService2 */
		return PromptAuth(parentWindow, aChannel, level, authInfo, 0, 0, retVal);
	}
	
	int AsyncPromptAuth(int /*long*/ aChannel, int /*long*/ aCallback, int /*long*/ aContext, int level, int /*long*/ authInfo, int /*long*/ _retval) {
		/* nsIPromptService2 */
		return AsyncPromptAuth(parentWindow, aChannel, aCallback, aContext, level, authInfo, 0, 0, _retval);
	}

}
