/*******************************************************************************

 * Copyright (c) 2000, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.rcp.dombrowser.browser;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Node;

import com.ibm.rcp.dombrowser.dom.JNode;
import com.ibm.rcp.dombrowser.internal.nsISupportsWrapper;
import com.ibm.rcp.dombrowser.internal.mozilla.LONG;
import com.ibm.rcp.dombrowser.internal.mozilla.WString;
import com.ibm.rcp.dombrowser.internal.mozilla.XPCOM;
import com.ibm.rcp.dombrowser.internal.mozilla.XPCOMObject;
import com.ibm.rcp.dombrowser.internal.mozilla.nsEmbedCString;
import com.ibm.rcp.dombrowser.internal.mozilla.nsEmbedString;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIArray;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIBadCertListener2;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIBaseWindow;
import com.ibm.rcp.dombrowser.internal.mozilla.nsICategoryManager;
import com.ibm.rcp.dombrowser.internal.mozilla.nsICertOverrideService;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIChannel;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIContextMenuInfo;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIContextMenuListener;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIContextMenuListener2;
import com.ibm.rcp.dombrowser.internal.mozilla.nsID;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIDOMEvent;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIDOMEventTarget;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIDOMKeyEvent;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIDOMMouseEvent;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIDOMNode;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIDOMWindow;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIDOMWindowCollection;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIDOMWindowInternal;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIEmbeddingSiteWindow;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIIOService;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIInterfaceRequestor;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIRequest;
import com.ibm.rcp.dombrowser.internal.mozilla.nsISSLStatus;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIServiceManager;
import com.ibm.rcp.dombrowser.internal.mozilla.nsISimpleEnumerator;
import com.ibm.rcp.dombrowser.internal.mozilla.nsISupports;
import com.ibm.rcp.dombrowser.internal.mozilla.nsISupportsWeakReference;
import com.ibm.rcp.dombrowser.internal.mozilla.nsITooltipListener;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIURI;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIURIContentListener;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIWeakReference;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIWebBrowser;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIWebBrowserChrome;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIWebBrowserChromeFocus;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIWebBrowserStream;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIWebNavigation;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIWebNavigationInfo;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIWebProgress;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIWebProgressListener;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIX509Cert;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIX509CertValidity;
import com.ibm.rcp.dombrowser.internal.ui.InvalidCertDialog;

class MozillaEmbeddingSite {

	protected MozillaBrowser browser;
	
	private static String PKG_Name=MozillaEmbeddingSite.class.getPackage().getName();
	private static final String CLASS_NAME = MozillaEmbeddingSite.class.getName();
	protected static Logger logger=Logger.getLogger(PKG_Name);
	List<Composite> childWindows = new ArrayList<>();
	
	/* Interfaces for this Mozilla embedding notification */
	private XPCOMObject supports;
	private XPCOMObject weakReference;
	private XPCOMObject webProgressListener;
	private XPCOMObject	webBrowserChrome;
	private XPCOMObject webBrowserChromeFocus;
	private XPCOMObject embeddingSiteWindow;
	private XPCOMObject interfaceRequestor;
	private XPCOMObject supportsWeakReference;
	private XPCOMObject contextMenuListener;	
	private XPCOMObject contextMenuListener2;	
	private XPCOMObject uriContentListener;
	private XPCOMObject tooltipListener;
	private XPCOMObject domEventListener;
	private XPCOMObject badCertListener;
	private int chromeFlags = nsIWebBrowserChrome.CHROME_DEFAULT;
	int registerFunctionsOnState = 0;
	private int refCount;
	private int /*long*/ request;
	private Point location;
	private Point size;
	private boolean visible;
	boolean addressBar, menuBar, statusBar, toolBar, isViewingErrorPage, isRetrievingBadCert;
	private boolean continueModalLoop;
		
	private static final String URI_FROMMEMORY = "file:///"; //$NON-NLS-1$
	private static final String ABOUT_BLANK = "about:blank"; //$NON-NLS-1$
	
	private static final String DOMEVENT_FOCUS = "focus"; //$NON-NLS-1$
	public static final String DOMEVENT_KEYUP = "keyup"; //$NON-NLS-1$
	public static final String DOMEVENT_KEYDOWN = "keydown"; //$NON-NLS-1$
	public static final String DOMEVENT_KEYPRESS = "keypress"; //$NON-NLS-1$
	public static final String DOMEVENT_MOUSEDOWN = "mousedown"; //$NON-NLS-1$
	
	boolean hasFocus;
	Listener listener;
	String lastNavigateURL;
	int authCount;
	boolean updateLastNavigateUrl;	
	
	private static final int VK_F = 102;
	private static final int VK_G = 103;
	private static final int VK_P = 112;
	
	protected boolean deferCompleted = false;

	// SPR XXZZ8PFBLS and RJBR8NHJMY
	static enum CertErrorNotifyState {
		INITIALIZE, NOTIFY_OK, NOTIFY_CANCEL, NOTIFY_PROMPT
	};
	static HashMap<String, CertErrorNotifyState> notificationCallbacks = new HashMap<String, CertErrorNotifyState>();

	public MozillaEmbeddingSite(MozillaBrowser browser) {
		this.browser = browser;
		createCOMInterfaces();
	}
	
	public int /*long*/ getWebBrowserChromeAddress() {
		return this.webBrowserChrome.getAddress();
	}
	public int /*long*/ getWeakReferenceAddress() {
		return this.weakReference.getAddress();
	}
	public int /*long*/ getURIContentListenerAddress() {
		return this.uriContentListener.getAddress();
	}
			
	protected void createCOMInterfaces() {
		// Create each of the interfaces that this object implements
		supports = new XPCOMObject(new int[]{2, 0, 0}){
			public int /*long*/ method0(int /*long*/[] args) {return QueryInterface(args[0], args[1]);}
			public int /*long*/ method1(int /*long*/[] args) {return AddRef();}
			public int /*long*/ method2(int /*long*/[] args) {return Release();}
		};
		
		weakReference = new XPCOMObject(new int[]{2, 0, 0, 2}){
			public int /*long*/ method0(int /*long*/[] args) {return QueryInterface(args[0], args[1]);}
			public int /*long*/ method1(int /*long*/[] args) {return AddRef();}
			public int /*long*/ method2(int /*long*/[] args) {return Release();}
			public int /*long*/ method3(int /*long*/[] args) {return QueryReferent(args[0], args[1]);}
		};
	
		webProgressListener = new XPCOMObject(new int[]{2, 0, 0, 4, 6, 4, 4, 3}){
			public int /*long*/ method0(int /*long*/[] args) {return QueryInterface(args[0], args[1]);}
			public int /*long*/ method1(int /*long*/[] args) {return AddRef();}
			public int /*long*/ method2(int /*long*/[] args) {return Release();}
			public int /*long*/ method3(int /*long*/[] args) {return OnStateChange(args[0], args[1], (int)/*64*/args[2],args[3]);}
			public int /*long*/ method4(int /*long*/[] args) {return OnProgressChange(args[0], args[1], args[2],args[3],args[4],args[5]);}
			public int /*long*/ method5(int /*long*/[] args) {return OnLocationChange(args[0], args[1], args[2], args[3]);}
			public int /*long*/ method6(int /*long*/[] args) {return OnStatusChange(args[0], args[1], (int)/*64*/args[2],args[3]);}
			public int /*long*/ method7(int /*long*/[] args) {return OnSecurityChange(args[0], args[1], (int)/*64*/args[2]);}
		};
		
		webBrowserChrome = new XPCOMObject(new int[]{2, 0, 0, 2, 1, 1, 1, 1, 0, 2, 0, 1, 1}){
			public int /*long*/ method0(int /*long*/[] args) {return QueryInterface(args[0], args[1]);}
			public int /*long*/ method1(int /*long*/[] args) {return AddRef();}
			public int /*long*/ method2(int /*long*/[] args) {return Release();}
			public int /*long*/ method3(int /*long*/[] args) {return SetStatus(args[0], args[1]);}
			public int /*long*/ method4(int /*long*/[] args) {return GetWebBrowser(args[0]);}
			public int /*long*/ method5(int /*long*/[] args) {return SetWebBrowser(args[0]);}
			public int /*long*/ method6(int /*long*/[] args) {return GetChromeFlags(args[0]);}
			public int /*long*/ method7(int /*long*/[] args) {return SetChromeFlags(args[0]);}
			public int /*long*/ method8(int /*long*/[] args) {return DestroyBrowserWindow();}
			public int /*long*/ method9(int /*long*/[] args) {return SizeBrowserTo(args[0], args[1]);}
			public int /*long*/ method10(int /*long*/[] args) {return ShowAsModal();}
			public int /*long*/ method11(int /*long*/[] args) {return IsWindowModal(args[0]);}
			public int /*long*/ method12(int /*long*/[] args) {return ExitModalEventLoop(args[0]);}
		};
		
		webBrowserChromeFocus = new XPCOMObject(new int[]{2, 0, 0, 0, 0}){
			public int /*long*/ method0(int /*long*/[] args) {return QueryInterface(args[0], args[1]);}
			public int /*long*/ method1(int /*long*/[] args) {return AddRef();}
			public int /*long*/ method2(int /*long*/[] args) {return Release();}
			public int /*long*/ method3(int /*long*/[] args) {return FocusNextElement();}
			public int /*long*/ method4(int /*long*/[] args) {return FocusPrevElement();}
		};
			
		embeddingSiteWindow = new XPCOMObject(new int[]{2, 0, 0, 5, 5, 0, 1, 1, 1, 1, 1, 0}){
			public int /*long*/ method0(int /*long*/[] args) {return QueryInterface(args[0], args[1]);}
			public int /*long*/ method1(int /*long*/[] args) {return AddRef();}
			public int /*long*/ method2(int /*long*/[] args) {return Release();}
			public int /*long*/ method3(int /*long*/[] args) {return SetDimensions((int)/*64*/args[0], (int)/*64*/args[1], (int)/*64*/args[2], (int)/*64*/args[3], (int)/*64*/args[4]);}
			public int /*long*/ method4(int /*long*/[] args) {return GetDimensions((int)/*64*/args[0], args[1], args[2], args[3], args[4]);}
			public int /*long*/ method5(int /*long*/[] args) {return SetFocus();}
			public int /*long*/ method6(int /*long*/[] args) {return GetVisibility(args[0]);}
			public int /*long*/ method7(int /*long*/[] args) {return SetVisibility(args[0]);}
			public int /*long*/ method8(int /*long*/[] args) {return GetTitle(args[0]);}
			public int /*long*/ method9(int /*long*/[] args) {return SetTitle(args[0]);}
			public int /*long*/ method10(int /*long*/[] args) {return GetSiteWindow(args[0]);}
			public int /*long*/ method11(int /*long*/[] args) {return Blur();}
		};
		
		interfaceRequestor = new XPCOMObject(new int[]{2, 0, 0, 2}){
			public int /*long*/ method0(int /*long*/[] args) {return QueryInterface(args[0], args[1]);}
			public int /*long*/ method1(int /*long*/[] args) {return AddRef();}
			public int /*long*/ method2(int /*long*/[] args) {return Release();}
			public int /*long*/ method3(int /*long*/[] args) {return GetInterface(args[0], args[1]);}
		};
			
		supportsWeakReference = new XPCOMObject(new int[]{2, 0, 0, 1}){
			public int /*long*/ method0(int /*long*/[] args) {return QueryInterface(args[0], args[1]);}
			public int /*long*/ method1(int /*long*/[] args) {return AddRef();}
			public int /*long*/ method2(int /*long*/[] args) {return Release();}
			public int /*long*/ method3(int /*long*/[] args) {return GetWeakReference(args[0]);}
		};
		
		contextMenuListener = new XPCOMObject(new int[]{2, 0, 0, 3}){
			public int /*long*/ method0(int /*long*/[] args) {return QueryInterface(args[0], args[1]);}
			public int /*long*/ method1(int /*long*/[] args) {return AddRef();}
			public int /*long*/ method2(int /*long*/[] args) {return Release();}
			public int /*long*/ method3(int /*long*/[] args) {return OnShowContextMenu(args[0],args[1],args[2]);}
		};
		
		contextMenuListener2 = new XPCOMObject(new int[]{2, 0, 0, 2}){
			public int /*long*/ method0(int /*long*/[] args) {return QueryInterface(args[0], args[1]);}
			public int /*long*/ method1(int /*long*/[] args) {return AddRef();}
			public int /*long*/ method2(int /*long*/[] args) {return Release();}
			public int /*long*/ method3(int /*long*/[] args) {return OnShowContextMenu2((int)/*64*/ args[0],args[1]);}
		};
		
		uriContentListener = new XPCOMObject(new int[]{2, 0, 0, 2, 5, 3, 4, 1, 1, 1, 1}) {
			public int /*long*/ method0(int /*long*/[] args) {return QueryInterface(args[0], args[1]);}
			public int /*long*/ method1(int /*long*/[] args) {return AddRef();}
			public int /*long*/ method2(int /*long*/[] args) {return Release();}
			public int /*long*/ method3(int /*long*/[] args) {return OnStartURIOpen(args[0], args[1]);}
			public int /*long*/ method4(int /*long*/[] args) {return DoContent(args[0], args[1], args[2], args[3], args[4]);}
			public int /*long*/ method5(int /*long*/[] args) {return IsPreferred(args[0], args[1], args[2]);}
			public int /*long*/ method6(int /*long*/[] args) {return CanHandleContent(args[0], args[1], args[2], args[3]);}
			public int /*long*/ method7(int /*long*/[] args) {return GetLoadCookie(args[0]);}
			public int /*long*/ method8(int /*long*/[] args) {return SetLoadCookie(args[0]);}
			public int /*long*/ method9(int /*long*/[] args) {return GetParentContentListener(args[0]);}
			public int /*long*/ method10(int /*long*/[] args) {return SetParentContentListener(args[0]);}		
		};
		
		tooltipListener = new XPCOMObject(new int[]{2, 0, 0, 3, 0}) {
			public int /*long*/ method0(int /*long*/[] args) {return QueryInterface(args[0], args[1]);}
			public int /*long*/ method1(int /*long*/[] args) {return AddRef();}
			public int /*long*/ method2(int /*long*/[] args) {return Release();}
			public int /*long*/ method3(int /*long*/[] args) {return OnShowTooltip(args[0], args[1], args[2]);}
			public int /*long*/ method4(int /*long*/[] args) {return OnHideTooltip();}		
		};
		
		domEventListener = new XPCOMObject (new int[] {2, 0, 0, 1}) {
			public int /*long*/ method0 (int /*long*/[] args) {return QueryInterface (args[0], args[1]);}
			public int /*long*/ method1 (int /*long*/[] args) {return AddRef ();}
			public int /*long*/ method2 (int /*long*/[] args) {return Release ();}
			public int /*long*/ method3 (int /*long*/[] args) {return HandleEvent (args[0]);}
		};
		badCertListener = new XPCOMObject (new int[] {2, 0, 0, 4}) {
			public int /*long*/ method0 (int /*long*/[] args) {return QueryInterface (args[0], args[1]);}
			public int /*long*/ method1 (int /*long*/[] args) {return AddRef ();}
			public int /*long*/ method2 (int /*long*/[] args) {return Release ();}
			public int /*long*/ method3 (int /*long*/[] args) {return NotifyCertProblem (args[0], args[1], args[2], args[3]);}
		};		
	}
	
	protected void disposeCOMInterfaces() {
		if (supports != null) {
			supports.dispose();
			supports = null;
		}	
		if (weakReference != null) {
			weakReference.dispose();
			weakReference = null;	
		}
		if (webProgressListener != null) {
			webProgressListener.dispose();
			webProgressListener = null;
		}
		if (webBrowserChrome != null) {
			webBrowserChrome.dispose();
			webBrowserChrome = null;
		}
		if (webBrowserChromeFocus != null) {
			webBrowserChromeFocus.dispose();
			webBrowserChromeFocus = null;
		}
		if (embeddingSiteWindow != null) {
			embeddingSiteWindow.dispose();
			embeddingSiteWindow = null;
		}
		if (interfaceRequestor != null) {
			interfaceRequestor.dispose();
			interfaceRequestor = null;
		}		
		if (supportsWeakReference != null) {
			supportsWeakReference.dispose();
			supportsWeakReference = null;
		}	
		if (contextMenuListener != null) {
			contextMenuListener.dispose();
			contextMenuListener = null;
		}
		
		if (contextMenuListener2 != null) {
			contextMenuListener2.dispose();
			contextMenuListener2 = null;
		}
		
		if (uriContentListener != null) {
			uriContentListener.dispose();
			uriContentListener = null;
		}
		if (tooltipListener != null) {
			tooltipListener.dispose();
			tooltipListener = null;
		}
		if(domEventListener != null){
			domEventListener.dispose();
			domEventListener = null;
		}
		if (badCertListener != null) {
			badCertListener.dispose ();
			badCertListener = null;
		}
	}
		
	/* nsISupports */
	
	protected int /*long*/ QueryInterface(int /*long*/ riid, int /*long*/ ppvObject) {
		if (riid == 0 || ppvObject == 0) return XPCOM.NS_ERROR_NO_INTERFACE;
	
		nsID guid = new nsID();
		XPCOM.memmove(guid, riid, nsID.sizeof);
	
		if (guid.Equals(nsISupports.NS_ISUPPORTS_IID)) {
			XPCOM.memmove(ppvObject, new int /*long*/[] {supports.getAddress()}, XPCOMObject.PTR_SIZEOF);
			AddRef();
			return XPCOM.NS_OK;
		}
		if (guid.Equals(nsIWeakReference.NS_IWEAKREFERENCE_IID)) {
			XPCOM.memmove(ppvObject, new int /*long*/[] {weakReference.getAddress()}, XPCOMObject.PTR_SIZEOF);
			AddRef();
			return XPCOM.NS_OK;
		}
		if (guid.Equals(nsIWebProgressListener.NS_IWEBPROGRESSLISTENER_IID)) {
			XPCOM.memmove(ppvObject, new int /*long*/[] {webProgressListener.getAddress()}, XPCOMObject.PTR_SIZEOF);
			AddRef();
			return XPCOM.NS_OK;
		}
		if (guid.Equals(nsIWebBrowserChrome.NS_IWEBBROWSERCHROME_IID)) {
			XPCOM.memmove(ppvObject, new int /*long*/[] {webBrowserChrome.getAddress()}, XPCOMObject.PTR_SIZEOF);
			AddRef();
			return XPCOM.NS_OK;
		}
		if (guid.Equals(nsIWebBrowserChromeFocus.NS_IWEBBROWSERCHROMEFOCUS_IID)) {
			XPCOM.memmove(ppvObject, new int /*long*/[] {webBrowserChromeFocus.getAddress()}, XPCOMObject.PTR_SIZEOF);
			AddRef();
			return XPCOM.NS_OK;
		}
		if (guid.Equals(nsIEmbeddingSiteWindow.NS_IEMBEDDINGSITEWINDOW_IID)) {
			XPCOM.memmove(ppvObject, new int /*long*/[] {embeddingSiteWindow.getAddress()}, XPCOMObject.PTR_SIZEOF);
			AddRef();
			return XPCOM.NS_OK;
		}
		if (guid.Equals(nsIInterfaceRequestor.NS_IINTERFACEREQUESTOR_IID)) {
			XPCOM.memmove(ppvObject, new int /*long*/[] {interfaceRequestor.getAddress()}, XPCOMObject.PTR_SIZEOF);
			AddRef();
			return XPCOM.NS_OK;
		}
		if (guid.Equals(nsISupportsWeakReference.NS_ISUPPORTSWEAKREFERENCE_IID)) {
			XPCOM.memmove(ppvObject, new int /*long*/[] {supportsWeakReference.getAddress()}, XPCOMObject.PTR_SIZEOF);
			AddRef();
			return XPCOM.NS_OK;
		}
		if (guid.Equals(nsIContextMenuListener.NS_ICONTEXTMENULISTENER_IID)) {
			XPCOM.memmove(ppvObject, new int /*long*/[] {contextMenuListener.getAddress()}, XPCOMObject.PTR_SIZEOF);
			AddRef();
			return XPCOM.NS_OK;
		}
		if (guid.Equals(nsIURIContentListener.NS_IURICONTENTLISTENER_IID)) {
			XPCOM.memmove(ppvObject, new int /*long*/[] {uriContentListener.getAddress()}, XPCOMObject.PTR_SIZEOF);
			AddRef();
			return XPCOM.NS_OK;
		}
		if (guid.Equals(nsITooltipListener.NS_ITOOLTIPLISTENER_IID)) {
			XPCOM.memmove(ppvObject, new int /*long*/[] {tooltipListener.getAddress()}, XPCOMObject.PTR_SIZEOF);
			AddRef();
			return XPCOM.NS_OK;
		}
		
		if (guid.Equals(nsIContextMenuListener2.NS_ICONTEXTMENULISTENER2_IID)) {
			XPCOM.memmove(ppvObject, new int /*long*/[] {contextMenuListener2.getAddress()}, XPCOMObject.PTR_SIZEOF);
			AddRef();
			return XPCOM.NS_OK;
		}
		if (guid.Equals (nsIBadCertListener2.NS_IBADCERTLISTENER2_IID)) {
			XPCOM.memmove (ppvObject, new int /*long*/[] {badCertListener.getAddress ()}, C.PTR_SIZEOF);
			AddRef ();
			return XPCOM.NS_OK;
		}		
		XPCOM.memmove(ppvObject, new int /*long*/[] {0}, XPCOMObject.PTR_SIZEOF);
		return XPCOM.NS_ERROR_NO_INTERFACE;
	}
		
	protected int /*long*/ AddRef() {
		refCount++;
		return refCount;
	}
	
	protected int /*long*/ Release() {
		refCount--;
		if (refCount == 0) disposeCOMInterfaces();
		return refCount;
	}
	
	/* nsIWeakReference */	
		
	protected int /*long*/ QueryReferent(int /*long*/ riid, int /*long*/ ppvObject) {
		return QueryInterface(riid,ppvObject);
	}
	
	/* nsIInterfaceRequestor */
	
	protected int /*long*/ GetInterface(int /*long*/ riid, int /*long*/ ppvObject) {
			if (riid == 0 || ppvObject == 0) return XPCOM.NS_ERROR_NO_INTERFACE;
			nsID guid = new nsID();
			XPCOM.memmove(guid, riid, nsID.sizeof);
			if (guid.Equals(nsIDOMWindow.NS_IDOMWINDOW_IID)) {
				int /*long*/[] aContentDOMWindow = new int /*long*/[1];
				nsIWebBrowser webBrowser = this.browser.getWebBrowser();
				
				if(webBrowser == null){
					return XPCOM.NS_ERROR_NO_INTERFACE;
				}
				
				int rc = webBrowser.GetContentDOMWindow(aContentDOMWindow);

				if (rc != XPCOM.NS_OK) MozillaBrowser.error(rc);
				if (aContentDOMWindow[0] == 0) MozillaBrowser.error(XPCOM.NS_ERROR_NO_INTERFACE);
				XPCOM.memmove(ppvObject, aContentDOMWindow, XPCOMObject.PTR_SIZEOF);
				return rc;
			}
		return QueryInterface(riid,ppvObject);
	}
	
	protected int /*long*/ GetWeakReference(int /*long*/ ppvObject) {
		XPCOM.memmove(ppvObject, new int /*long*/[] {weakReference.getAddress()}, XPCOMObject.PTR_SIZEOF);
		AddRef();
		return XPCOM.NS_OK;
	}
	
	/* nsIWebProgressListener */
	
	Vector unhookedDOMWindows = new Vector ();
	
	// SPR XXZZ8PFBLS and RJBR8NHJMY: Add CertError notification callback
	private void AddNotificationCallback(nsIRequest request) {
		int /*long*/[] result = new int /*long*/[1];
		int rc = request.QueryInterface (nsIChannel.NS_ICHANNEL_IID, result);
		if (rc == XPCOM.NS_OK && result[0] != 0) {
			nsIChannel channel = new nsIChannel (result[0]);
			rc = channel.SetNotificationCallbacks (interfaceRequestor.getAddress ());
			if (rc != XPCOM.NS_OK){
				logger.logp(Level.WARNING, CLASS_NAME, "AddNotificationCallback", //$NON-NLS-1$
						"Exception from MozillaEmbeddingSite"); //$NON-NLS-1$
			}
			channel.Release ();
		}				
	}
	
	protected int OnStateChange(int /*long*/ aWebProgress, int /*long*/ aRequest, int aStateFlags, int /*long*/ aStatus) {			
		if(registerFunctionsOnState != 0 && ((aStateFlags & registerFunctionsOnState)== registerFunctionsOnState)){
			registerFunctionsOnState = 0;
			Enumeration elements = this.browser.functions.elements();
			while(elements.hasMoreElements()){
				BrowserFunction function = (BrowserFunction) elements.nextElement();
				if (!function.isEvaluate){
					this.browser.execute(function.functionString);
				}
			}
		}	
		
		// get current url on statechange
		String currentURL = null;
		nsIRequest request_new = new nsIRequest (aRequest);
		nsEmbedCString name = new nsEmbedCString();
		int rc = request_new.GetName (name.getAddress());
		if (rc != XPCOM.NS_OK) {
			logger.logp(Level.WARNING, CLASS_NAME, "OnStateChange", //$NON-NLS-1$
			"Exception from MozillaEmbeddingSite"); //$NON-NLS-1$
		}
		currentURL = name.toString();
		name.dispose();
		
		boolean isHttps = currentURL.toLowerCase().trim().startsWith("https://");
		/*
			* Feature of Mozilla.  When a redirect occurs to a site with an invalid
			* certificate, no STATE_IS_DOCUMENT state transitions are received for the
			* new location, and an immediate attempt is made to show the invalid
			* certificate error.  However our invalid certificate handler must know
			* the site with the invalid certificate, not the site that redirected to
			* it.  The only opportunity to get this site before our invalid certificate
			* handler is invoked is in the subsequent STATE_START | STATE_IS_REQUEST
			* transition.  When this comes, if the request's name appears to be a
			* url then take this to be the new site, in case our invalid certificate
			* handler is about to be invoked.
			* 
			* Note that updateLastNavigateUrl is not reset to false here so that in
			* typical contexts where a redirect occurs without an accompanying invalid
			* certificate, the updated site will be retrieved from the channel (this
			* is more proper) on the next STATE_TRANSFERRING | STATE_IS_DOCUMENT transition.
			*/
			if (updateLastNavigateUrl && aStateFlags == (nsIWebProgressListener.STATE_IS_REQUEST | nsIWebProgressListener.STATE_START)) {				
				if(currentURL.indexOf (":/") != -1) { //$NON-NLS-1$
					lastNavigateURL = currentURL;
				}
			}

			// Register BrowserFunctin in the final STOP, when all the content is loaded  
			if((aStateFlags & nsIWebProgressListener.STATE_IS_WINDOW) != 0 && (aStateFlags & nsIWebProgressListener.STATE_IS_NETWORK) !=0
					&& (aStateFlags & nsIWebProgressListener.STATE_STOP) != 0) {
				if (!currentURL.toLowerCase().trim().startsWith (ABOUT_BLANK)) {
					Enumeration elements = this.browser.functions.elements();
					while(elements.hasMoreElements()){
						BrowserFunction function = (BrowserFunction) elements.nextElement();
						if (!function.isEvaluate){
							this.browser.execute(function.functionString);		
						}
					}
				}				
			}
			
			if ((aStateFlags & nsIWebProgressListener.STATE_IS_DOCUMENT) == 0) {
				// SPR XXZZ8PFBLS and RJBR8NHJMY, if CertError Notification is enabled for extend element and url is https, then continue
				if(!browser.isExtendedCertErrorNotificationEnabled() || !isHttps) {
					return XPCOM.NS_OK;
				}
				
			}
			
			if ((aStateFlags & nsIWebProgressListener.STATE_START) != 0) {
				int /*long*/[] result = new int /*long*/[1];
			   /*
				* When navigating to a site that is known to have a bad certificate, request notification
				* callbacks on the channel so that our nsIBadCertListener2 will be invoked.
				*/
				// SPR XXZZ8PFBLS and RJBR8NHJMY
				if(isHttps || isRetrievingBadCert) {  //$NON-NLS-1$	
					isRetrievingBadCert=false;
					// Use host:port as the hashmap's key
					String hostPort;
					URL formatURL = null;
					try {
						formatURL = new URL(currentURL);
					} catch (MalformedURLException e) {
						logger.logp(Level.FINEST, CLASS_NAME, "OnStateChange", //$NON-NLS-1$
							"MalformedURLException from MozillaEmbeddingSite", e); //$NON-NLS-1$
					}
					if(formatURL.getPort() == -1) {
						hostPort = formatURL.getHost() + ":" + 443;
					}
					else {
						hostPort = formatURL.getHost() + ":" + formatURL.getPort();
					}
					
					if(!notificationCallbacks.containsKey(hostPort) || 
								notificationCallbacks.get(hostPort) != CertErrorNotifyState.NOTIFY_OK) {
						AddNotificationCallback(request_new);	
						return XPCOM.NS_OK;
					}
				}
				
				if (request == 0) request = aRequest;		
				/*
				 * Add the page's nsIDOMWindow to the collection of windows that will
				 * have DOM listeners added to them later on in the page loading
				 * process.  These listeners cannot be added yet because the
				 * nsIDOMWindow is not ready to take them at this stage.
				 */

				nsIWebProgress progress = new nsIWebProgress (aWebProgress);
				rc = progress.GetDOMWindow (result);
				if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
				if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_NOINTERFACE);
				unhookedDOMWindows.addElement (new LONG (result[0]));
			} else if ((aStateFlags & nsIWebProgressListener.STATE_REDIRECTING) != 0) {
				if (request == aRequest) request = 0;
				updateLastNavigateUrl = true;
			} else if ((aStateFlags & nsIWebProgressListener.STATE_STOP) != 0) {
				/*
				* If this page's nsIDOMWindow handle is still in unhookedDOMWindows then
				* add its DOM listeners now.  It's possible for this to happen since
				* there is no guarantee that a STATE_TRANSFERRING state change will be
				* received for every window in a page, which is when these listeners
				* are typically added.
				*/
				int /*long*/[] result = new int /*long*/[1];
				nsIWebProgress progress = new nsIWebProgress (aWebProgress);
				rc = progress.GetDOMWindow (result);
				if (rc != XPCOM.NS_OK) {
					return XPCOM.NS_ERROR_FAILURE;
				}
				if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_NOINTERFACE);
				nsIDOMWindow domWindow = new nsIDOMWindow (result[0]);

				LONG ptrObject = new LONG (result[0]);
				result[0] = 0;
				int index = unhookedDOMWindows.indexOf (ptrObject);
				if (index != -1) {
					nsIWebBrowser wb = this.browser.getWebBrowser();
					
					if(wb == null){
						return XPCOM.NS_ERROR_FAILURE;
					}
					
					rc = wb.GetContentDOMWindow(result);
					if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
					if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_ERROR_NO_INTERFACE);
					boolean isTop = result[0] == domWindow.getAddress ();
					new nsISupports (result[0]).Release ();
					result[0] = 0;

					rc = domWindow.QueryInterface (nsIDOMEventTarget.NS_IDOMEVENTTARGET_IID, result);
					if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
					if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_ERROR_NO_INTERFACE);

					nsIDOMEventTarget target = new nsIDOMEventTarget (result[0]);
					result[0] = 0;
					hookDOMListeners (target, isTop);
					target.Release ();

					/*
					* Remove and unreference the nsIDOMWindow from the collection of windows
					* that are waiting to have DOM listeners hooked on them. 
					*/
					unhookedDOMWindows.remove (ptrObject);
					new nsISupports (ptrObject.value).Release ();
				}
				deferCompleted = false;
				/*
				 * If htmlBytes is not null then there is html from a previous setText() call
				 * waiting to be set into the about:blank page once it has completed loading. 
				 */				
				if (browser.htmlBytes != null) {
					nsIRequest req = new nsIRequest (aRequest);
					int /*long*/ tname = XPCOM.nsEmbedCString_new ();
					rc = req.GetName (tname);
					if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
					int length = XPCOM.nsEmbedCString_Length (tname);
					int /*long*/ buffer = XPCOM.nsEmbedCString_get (tname);
					byte[] dest = new byte[length];
					XPCOM.memmove (dest, buffer, length);
					String url = new String (dest);
					XPCOM.nsEmbedCString_delete (tname);

					if (url.startsWith (ABOUT_BLANK)) {
						/*
						 * Setting mozilla's content with nsIWebBrowserStream invalidates the 
						 * DOM listeners that were hooked on it (about:blank), so remove them and
						 * add new ones after the content has been set.
						 */
						unhookDOMListeners ();

						rc = XPCOM.NS_GetServiceManager (result);
						if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
						if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_NOINTERFACE);

						nsIServiceManager serviceManager = new nsIServiceManager (result[0]);
						result[0] = 0;
						rc = serviceManager.GetService (XPCOM.NS_IOSERVICE_CID, nsIIOService.NS_IIOSERVICE_IID, result);
						if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
						if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_NOINTERFACE);
						serviceManager.Release ();

						nsIIOService ioService = new nsIIOService (result[0]);
						result[0] = 0;
						byte[] aString;
						aString = Converter.wcsToMbcs (null, URI_FROMMEMORY, false);

						int /*long*/ aSpec = XPCOM.nsEmbedCString_new (aString, aString.length);
						rc = ioService.NewURI (aSpec, null, 0, result);
						if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
						if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_NOINTERFACE);
						XPCOM.nsEmbedCString_delete (aSpec);
						ioService.Release ();

						nsIURI uri = new nsIURI (result[0]);
						result[0] = 0;

						rc = this.browser.getWebBrowser().QueryInterface (nsIWebBrowserStream.NS_IWEBBROWSERSTREAM_IID, result);
						if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
						if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_NOINTERFACE);
						
						nsIWebBrowserStream stream = new nsIWebBrowserStream (result[0]);
						result[0] = 0;

						byte[] contentTypeBuffer = Converter.wcsToMbcs (null, "text/html", false); // $NON-NLS-1$
						int /*long*/ aContentType = XPCOM.nsEmbedCString_new (contentTypeBuffer, contentTypeBuffer.length);

						rc = stream.OpenStream (uri.getAddress (), aContentType);
						if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);

						/*
						* For Mozilla < 1.9.2, when content is being set via nsIWebBrowserStream, this
						* is the only place where registered functions can be re-installed such that
						* they will be invokable at load time by JS contained in the text.
						*/
						//@@@
						Enumeration elements = this.browser.functions.elements();
						while(elements.hasMoreElements()){
							BrowserFunction function = (BrowserFunction) elements.nextElement();
							if (!function.isEvaluate){
								this.browser.execute(function.functionString);
							}
						}
						/* 
						* For Mozilla >= 1.9.2, when content is being set via nsIWebBrowserStream,
						* registered functions must be re-installed in the subsequent Start Request
						* in order to be invokable at load time by JS contained in the text.
						*/
						registerFunctionsOnState = nsIWebProgressListener.STATE_IS_REQUEST | nsIWebProgressListener.STATE_START;

						int /*long*/ ptr = C.malloc (browser.htmlBytes.length);
						XPCOM.memmove (ptr, browser.htmlBytes, browser.htmlBytes.length);	
						int pageSize = 8192;
						int pageCount =browser.htmlBytes.length / pageSize + 1;
						int /*long*/ current = ptr;
						for (int i = 0; i < pageCount; i++) {
							length = i == pageCount - 1 ?browser.htmlBytes.length % pageSize : pageSize;
							if (length > 0) {
								rc = stream.AppendToStream (current, length);
								if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
							}
							current += pageSize;
						}
						rc = stream.CloseStream ();
						if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
						C.free (ptr);
						XPCOM.nsEmbedCString_delete (aContentType);
						stream.Release ();
						uri.Release ();
						browser.htmlBytes = null;
						/*
						* Browser content that is set via nsIWebBrowserStream is not parsed immediately.
						* Since clients depend on the Completed event to know when the browser's content
						* is available, delay the sending of this event so that the stream content will
						* be parsed first.
						*/
						deferCompleted = true;

						rc = this.browser.getWebBrowser().GetContentDOMWindow (result);
						if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
						if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_ERROR_NO_INTERFACE);
						boolean isTop = result[0] == domWindow.getAddress ();
						new nsISupports (result[0]).Release ();
						result[0] = 0;

						rc = domWindow.QueryInterface (nsIDOMEventTarget.NS_IDOMEVENTTARGET_IID, result);
						if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
						if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_ERROR_NO_INTERFACE);
						nsIDOMEventTarget target = new nsIDOMEventTarget (result[0]);
						result[0] = 0;
						hookDOMListeners (target, isTop);
						target.Release ();
					} else {
						registerFunctionsOnState = 0;
					}
				}					
				domWindow.Release();				
				
				/*
				* Feature on Mozilla.  When a request is redirected (STATE_REDIRECTING),
				* it never reaches the state STATE_STOP and it is replaced with a new request.
				* The new request is received when it is in the state STATE_STOP.
				* To handle this case,  the variable request is set to 0 when the corresponding
				* request is redirected. The following request received with the state STATE_STOP
				* - the new request resulting from the redirection - is used to send
				* the ProgressListener.completed event.
				*/
				if (request == aRequest || request == 0) {
					request = 0;
					StatusTextEvent event = new StatusTextEvent(this.browser);
					event.display = this.browser.getDisplay();
					event.widget = this.browser;
					event.text = ""; //$NON-NLS-1$
					for (int i = 0; i < this.browser.statusTextListeners.length; i++)
						this.browser.statusTextListeners[i].changed(event);

					
					final Display display = browser.getDisplay ();
					final ProgressEvent event2 = new ProgressEvent (browser);
					event2.display = display;
					event2.widget = browser;
					for (int i = 0; i < browser.progressListeners.length; i++) {
						browser.progressListeners[i].completed (event2);
					}
				}

			}  else if ((aStateFlags & nsIWebProgressListener.STATE_TRANSFERRING) != 0) {
				if (updateLastNavigateUrl) {
					updateLastNavigateUrl = false;
					int /*long*/[] result = new int /*long*/[1];
					nsIRequest request = new nsIRequest (aRequest);
		
					rc = request.QueryInterface (nsIChannel.NS_ICHANNEL_IID, result);
					if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
					if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_NOINTERFACE);
					nsIChannel channel = new nsIChannel (result[0]);
					result[0] = 0;
					rc = channel.GetURI (result);
					if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
					if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_ERROR_NULL_POINTER);
					channel.Release ();
		
					nsIURI uri = new nsIURI (result[0]);
					result[0] = 0;
					int /*long*/ aSpec = XPCOM.nsEmbedCString_new ();
					rc = uri.GetSpec (aSpec);
					if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
					int length = XPCOM.nsEmbedCString_Length (aSpec);
					int /*long*/ buffer = XPCOM.nsEmbedCString_get (aSpec);
					byte[] bytes = new byte[length];
					XPCOM.memmove (bytes, buffer, length);
					lastNavigateURL = new String (bytes);
					XPCOM.nsEmbedCString_delete (aSpec);
					uri.Release ();
				}
			
				/*
				* Hook DOM listeners to the page's nsIDOMWindow here because this is
				* the earliest opportunity to do so.    
				*/
				int /*long*/[] result = new int /*long*/[1];
				nsIWebProgress progress = new nsIWebProgress (aWebProgress);
				rc = progress.GetDOMWindow (result);
				if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
				if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_NOINTERFACE);
				nsIDOMWindow domWindow = new nsIDOMWindow (result[0]);

				LONG ptrObject = new LONG (result[0]);
				result[0] = 0;
				int index = unhookedDOMWindows.indexOf (ptrObject);
				if (index != -1) {
					nsIWebBrowser wb = this.browser.getWebBrowser();
					rc = wb.GetContentDOMWindow(result);
				//	wb.Release();
					if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
					if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_ERROR_NO_INTERFACE);
					boolean isTop = result[0] == domWindow.getAddress ();
					new nsISupports (result[0]).Release ();
					result[0] = 0;

					rc = domWindow.QueryInterface (nsIDOMEventTarget.NS_IDOMEVENTTARGET_IID, result);
					if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
					if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_ERROR_NO_INTERFACE);

					nsIDOMEventTarget target = new nsIDOMEventTarget (result[0]);
					result[0] = 0;
					hookDOMListeners (target, isTop);
					target.Release ();

					/*
					* Remove and unreference the nsIDOMWindow from the collection of windows
					* that are waiting to have DOM listeners hooked on them. 
					*/
					unhookedDOMWindows.remove (ptrObject);
					new nsISupports (ptrObject.value).Release ();
				}
				domWindow.Release ();
			}

		return XPCOM.NS_OK;
	}	
	
	protected int /*long*/ OnProgressChange(int /*long*/ aWebProgress, int /*long*/ aRequest, int /*long*/ aCurSelfProgress, int /*long*/ aMaxSelfProgress, int /*long*/ aCurTotalProgress, int /*long*/ aMaxTotalProgress) {
			if(browser==null || browser.isDisposed()) {
				return XPCOM.NS_ERROR_FAILURE;
			}
			
			if (this.browser.progressListeners.length == 0) return XPCOM.NS_OK;
			
			int /*long*/ total = aMaxTotalProgress;
			if (total <= 0) total = Integer.MAX_VALUE;
			ProgressEvent event = new ProgressEvent(this.browser);
			event.display = this.browser.getDisplay();
			event.widget = this.browser;
			event.current = (int)/*64*/aCurTotalProgress;
			event.total = (int)/*64*/aMaxTotalProgress;
			for (int i = 0; i < this.browser.progressListeners.length; i++)
				this.browser.progressListeners[i].changed(event);		
		return XPCOM.NS_OK;
	}		


	protected int /*long*/ OnLocationChange(int /*long*/ aWebProgress, int /*long*/ aRequest, int /*long*/ aLocation) {
		return OnLocationChange(aWebProgress, aRequest, aLocation, 0);
	}

	protected int /*long*/ OnLocationChange(int /*long*/ aWebProgress, int /*long*/ aRequest, int /*long*/ aLocation, int /*long*/ aFlags) {
		/*
		* Feature on Mozilla.  When a page is loaded via setText before a previous
		* setText page load has completed, the expected OnStateChange STATE_STOP for the
		* original setText never arrives because it gets replaced by the OnStateChange
		* STATE_STOP for the new request.  This results in the request field never being
		* cleared because the original request's OnStateChange STATE_STOP is still expected
		* (but never arrives).  To handle this case, the request field is updated to the new
		* overriding request since its OnStateChange STATE_STOP will be received next.
		*/
			
			if(browser==null || browser.isDisposed()) {
				return XPCOM.NS_ERROR_FAILURE;
			}
			
			if (request != 0 && request != aRequest) request = aRequest;
			if (this.browser.locationListeners.length == 0) return XPCOM.NS_OK;

			nsIWebProgress webProgress = new nsIWebProgress(aWebProgress);
			int /*long*/[] aDOMWindow = new int /*long*/[1];
			int rc = webProgress.GetDOMWindow(aDOMWindow);
			if (rc != XPCOM.NS_OK) MozillaBrowser.error(rc);
			if (aDOMWindow[0] == 0) MozillaBrowser.error(XPCOM.NS_ERROR_NO_INTERFACE);
			
			nsIDOMWindow domWindow = new nsIDOMWindow(aDOMWindow[0]);
			int /*long*/[] aTop = new int /*long*/[1];
			rc = domWindow.GetTop(aTop);
			if (rc != XPCOM.NS_OK) MozillaBrowser.error(rc);
			if (aTop[0] == 0) MozillaBrowser.error(XPCOM.NS_ERROR_NO_INTERFACE);
			domWindow.Release();
			
			nsIDOMWindow topWindow = new nsIDOMWindow(aTop[0]);
			topWindow.Release();
			
			nsIURI location = new nsIURI(aLocation);
			nsEmbedCString aSpec = new nsEmbedCString();
			location.GetSpec(aSpec.getAddress());
			////////////
			String url=aSpec.toString();
			/*
			 * As of Mozilla 1.8, the first time that a page is displayed, regardless of
			 * whether it's via Browser.setURL() or Browser.setText(), the GRE navigates
			 * to about:blank and fires the corresponding navigation events.  Do not send
			 * this event on the user since it is not expected.
			 */
			if (/*Is_1_8 && */aRequest == 0 && url.startsWith (ABOUT_BLANK)) return XPCOM.NS_OK;
			//////////
			LocationEvent event = new LocationEvent(this.browser);
			event.display = this.browser.getDisplay();
			event.widget = this.browser;
			event.location = aSpec.toString();
			aSpec.dispose();
			if (event.location.equals (URI_FROMMEMORY)) {
				/*
				 * If the URI indicates that the page is being rendered from memory
				 * (ie.- via setText()) then set the event location to about:blank
				 * to be consistent with win32.
				 */
				event.location = ABOUT_BLANK;
			}
			event.top = aTop[0] == aDOMWindow[0];
			for (int i = 0; i < this.browser.locationListeners.length; i++)
				this.browser.locationListeners[i].changed(event);
			
			/*
			* This could be the first content that is set into the browser, so
			* ensure that the custom subclass that works around Mozilla bug
			* https://bugzilla.mozilla.org/show_bug.cgi?id=453523 is removed.
			*/
			this.browser.removeWindowSubclass();
			
		return XPCOM.NS_OK;
	}
	
	
	private static Set protocolHandleByCurAppCache = new HashSet();
	
	public boolean isProtocolHandleBySelf(String url){
		String protocol = "";
		try {
			protocol = new URL(url).getProtocol();
		} catch (MalformedURLException e) {
			logger.logp(Level.FINEST, CLASS_NAME, "isProtocolHandleBySelf", //$NON-NLS-1$
					"MalformedURLException from MozillaEmbeddingSite", e); //$NON-NLS-1$
			return false;
		}
		
		if("http".equalsIgnoreCase(protocol) || "https".equalsIgnoreCase(protocol) || "ftp".equalsIgnoreCase(protocol)||"file".equalsIgnoreCase(protocol)){
			return false; //quick check for common protocols
		}
		
		if(protocolHandleByCurAppCache.contains(protocol)){
			return true;
		}
	
		int rc;
		int /*long*/ address[] = new int /*long*/[1]; 
		rc = XPCOM.NS_GetServiceManager(address);
		if (rc != XPCOM.NS_OK) { 
			return false;
		}	
		if (address[0] == 0) { 
			return false;	
		}
		nsIServiceManager serviceManager = new nsIServiceManager(address[0]);

		//byte[] buffer = XPCOM.NS_INTERNETCONFIG_SERVICE_CONTRACTID.getBytes();
		byte[] buffer = XPCOM.NS_IOSERVICE_CONTRACTID.getBytes();
		byte[] aContractID = new byte[buffer.length + 1];
		int /*long*/[] result = new int /*long*/[1];
		aContractID = new byte[buffer.length + 1];
		System.arraycopy(buffer, 0, aContractID, 0, buffer.length);
		//rc = serviceManager.GetServiceByContractID(aContractID, nsIInternetConfigService.NS_IINTERNETCONFIGSERVICE_IID,result);
		rc = serviceManager.GetServiceByContractID(aContractID, nsIIOService.NS_IIOSERVICE_IID,result);
		serviceManager.Release();
		if (rc != XPCOM.NS_OK) {
			return false;
		}
		
		if (result[0] == 0) 
			return false;	
	
		//nsIInternetConfigService config = new nsIInternetConfigService(result[0]);
		nsIIOService config = new nsIIOService(result[0]);
		


		byte[] headBuffer = protocol.getBytes();
		byte[] sheme = new byte[headBuffer.length + 1];
		System.arraycopy(headBuffer, 0, sheme, 0, headBuffer.length);
		
		int /*long*/[] returnResult = new int /*long*/[1];
		//int rv = config.HasProtocolHandler(sheme ,returnResult);
		int rv = config.GetProtocolHandler(sheme ,returnResult);
		
		//protocol is handled by current app
		if(rv == XPCOM.NS_ERROR_NOT_AVAILABLE){
			//store protocol string in cache
			protocolHandleByCurAppCache.add(protocol);
			return true;
		}

		return false;
		
	}
	  
	protected int /*long*/ OnStatusChange(int /*long*/ aWebProgress, int /*long*/ aRequest, int aStatus, int /*long*/ aMessage) {
		/*
		* Feature in Mozilla.  In Mozilla 1.7.5, navigating to an 
		* HTTPS link without a user profile set causes a crash.
		* Most requests for HTTPS pages are aborted in OnStartURIOpen.
		* However, https page requests that do not initially specify
		* https as their protocol will get past this check since they
		* are resolved afterwards.  The workaround is to check the url
		* whenever there is a status change, and to abort any https
		* requests that are detected.
		*/
/*		nsIRequest request = new nsIRequest(aRequest);
		nsEmbedCString aName = new nsEmbedCString();
		request.GetName(aName.getAddress());
		String value = aName.toString();
		aName.dispose();
		if (value.startsWith(XPCOM.HTTPS_PROTOCOL)) {
			request.Cancel(XPCOM.NS_BINDING_ABORTED);
			return XPCOM.NS_OK;
		}
		
		
*/	

			if(browser==null || browser.isDisposed()) {
				return XPCOM.NS_ERROR_FAILURE;
			}
			
			if (this.browser.statusTextListeners.length == 0) return XPCOM.NS_OK;

			StatusTextEvent event = new StatusTextEvent(this.browser);
			event.display = this.browser.getDisplay();
			event.widget = this.browser;
			event.text = WString.toNotNullString(aMessage);
			for (int i = 0; i < this.browser.statusTextListeners.length; i++){
				this.browser.statusTextListeners[i].changed(event);
			}
	
		return XPCOM.NS_OK;
	}		
	
	protected int /*long*/ OnSecurityChange(int /*long*/ aWebProgress, int /*long*/ aRequest, int state) {
		return XPCOM.NS_OK;
	}
	
	/* nsIWebBrowserChrome */
	
	protected int /*long*/ SetStatus(int /*long*/ statusType, int /*long*/ status) {
			
			if(browser==null || browser.isDisposed()) {
				return XPCOM.NS_ERROR_FAILURE;
			}
			
			StatusTextEvent event = new StatusTextEvent(this.browser);
			event.display = this.browser.getDisplay();
			event.widget = this.browser;
			event.text = WString.toNotNullString(status);
			for (int i = 0; i < this.browser.statusTextListeners.length; i++){
				this.browser.statusTextListeners[i].changed(event);
			}

		return XPCOM.NS_OK;
	}		
	
	protected int /*long*/ GetWebBrowser(int /*long*/ aWebBrowser) {

			if(browser==null || browser.isDisposed()) {
				return XPCOM.NS_ERROR_FAILURE;
			}
			
			int /*long*/[] ret = new int /*long*/[1];
			nsIWebBrowser webBrowser = this.browser.getWebBrowser();
			if (webBrowser != null) {
				ret[0] = webBrowser.getAddress();	
				webBrowser.AddRef();
			}
			
			
			XPCOM.memmove(aWebBrowser, ret, XPCOMObject.PTR_SIZEOF);
		return XPCOM.NS_OK;
	}
	
	protected int /*long*/ SetWebBrowser(int /*long*/ aWebBrowser) {
		if(browser==null || browser.isDisposed()) {
			return XPCOM.NS_ERROR_FAILURE;
		}
		
		this.browser.setWebBrowser(aWebBrowser != 0 ? new nsIWebBrowser(aWebBrowser) : null);
		return XPCOM.NS_OK;
	}
	   
	protected int /*long*/ GetChromeFlags(int /*long*/ aChromeFlags) {
		int[] ret = new int[1];
		ret[0] = chromeFlags;
		/* aChromeFlags is a pointer to a type of size 4 */
		XPCOM.memmove(aChromeFlags, ret, 4);
		return XPCOM.NS_OK;
	}
	
	protected int /*long*/ SetChromeFlags(int /*long*/ aChromeFlags) {
		chromeFlags = (int)/*64*/aChromeFlags;
		return XPCOM.NS_OK;
	}
	   
	protected int /*long*/ DestroyBrowserWindow() {
			if(browser==null || browser.isDisposed()) {
				return XPCOM.NS_ERROR_FAILURE;
			}
			
			if (this.browser.closeWindowListeners.length > 0) {
				WindowEvent newEvent = new WindowEvent(this.browser);
				newEvent.display = this.browser.getDisplay();
				newEvent.widget = this.browser;
				int length=this.browser.closeWindowListeners.length;
				for (int i = 0; i < length; i++){
					try {
						// The browser may be disposed in close() method, check again.
						if(this.browser == null || this.browser.isDisposed()){
							break; 
						}
					this.browser.closeWindowListeners[i].close(newEvent);
					} catch (Exception e) {
						logger.log(Level.SEVERE, "Closing Window exception", e);  //$NON-NLS-1$
					}
				}
			}
			/*
			* Note on Mozilla.  The DestroyBrowserWindow notification cannot be cancelled.
			* The browser widget cannot be used after this notification has been received.
			* The application is advised to close the window hosting the browser widget.
			* The browser widget must be disposed in all cases.
			*/
//			if(this.browser!=null && !this.browser.isDisposed()){
//				this.browser.dispose();
//			}
			
		return XPCOM.NS_OK;
	}
	   	
	protected int /*long*/ SizeBrowserTo(int /*long*/ aCX, int /*long*/ aCY) {
		this.size = new Point((int)/*64*/aCX, (int)/*64*/aCY);
		boolean isChrome = (chromeFlags & nsIWebBrowserChrome.CHROME_OPENAS_CHROME) != 0;
		if (isChrome) {
			Shell shell = browser.getShell ();
			shell.setSize (shell.computeSize (size.x, size.y));
		}
		return XPCOM.NS_OK;
	}
	
	private nsIDOMWindowInternal getDOMWindowInternal() {
		int /*long*/[] retVal= new int /*long*/[1];;
			nsIWebBrowser wb = this.browser.getWebBrowser();
			if (null == wb)
				return null;					
			int rc = wb.GetContentDOMWindow(retVal);

			if (rc != XPCOM.NS_OK || retVal[0] == 0)
				return null;
			  	
			nsIDOMWindow dw = new nsIDOMWindow(retVal[0]);
			retVal[0] = 0;
			rc = dw.QueryInterface(nsIDOMWindowInternal.NS_IDOMWINDOWINTERNAL_IID, retVal);
			dw.Release();
			if (rc != XPCOM.NS_OK || retVal[0] == 0)
				return null;

      	
		return new nsIDOMWindowInternal(retVal[0]);
	}
	
	private boolean getClosed(nsIDOMWindowInternal window) {
		int[] retVal = new int[1];
		int rc = window.GetClosed(retVal);
		if (rc != XPCOM.NS_OK)
			return false;

		return retVal[0] != 0;
	}
	
	protected int /*long*/ ShowAsModal() {

			if(browser==null || browser.isDisposed()) {
				return XPCOM.NS_ERROR_FAILURE;
			}
			
			
			nsIDOMWindowInternal window = getDOMWindowInternal();
			this.continueModalLoop = true;
			Display display = this.browser.getDisplay();
			while (this.continueModalLoop && !this.browser.isDisposed()) {
				if (!display.readAndDispatch()) {
					display.sleep();
				}	
				else {
					if (window != null && getClosed(window)) {
						this.continueModalLoop = false;
						display.syncExec( new Runnable () {
							public void run() {
								DestroyBrowserWindow();				
							}							
						});				
					}
				}
			}	
			if (window != null)
				window.Release();		
		return XPCOM.NS_OK;
	}
	   
	protected int /*long*/ IsWindowModal(int /*long*/ retval) {
		/* Note. boolean remains of size 4 on 64 bit machine */
		// for xul 10.0
		//XPCOM.memmove(retval, new int[] {this.continueModalLoop ? 1 : 0}, 4); /* PRBool */
		XPCOM.memmove(retval, new int[] {this.continueModalLoop ? 1 : 0}, 1); /*bool*/
		return XPCOM.NS_OK;
	}
	   
	protected int /*long*/ ExitModalEventLoop(int /*long*/ aStatus) {

			if(browser==null || browser.isDisposed()) {
				return XPCOM.NS_ERROR_FAILURE;
			}
			
			
			this.continueModalLoop = false;
			Display display = this.browser.getDisplay();
			if (display != null && !display.isDisposed()) 
				display.wake();
		return XPCOM.NS_OK;
	}
	
	/* nsIEmbeddingSiteWindow */ 	
	private boolean isAllowBrowserShellResize(Shell shell){
		if(shell== null || shell.isDisposed()){
			return false;
		}
		String value=(String)shell.getData("isAllowBrowserShellResize");
		if("true".equals(value)){
			return true;
		}
		return false;
	}
	
	int SetDimensions (int flags, int x, int y, int cx, int cy) {
			if(browser==null || browser.isDisposed()) {
				return XPCOM.NS_ERROR_FAILURE;
			}
			if(isAllowBrowserShellResize(browser.getShell())){
				if ((flags & nsIEmbeddingSiteWindow.DIM_FLAGS_POSITION) != 0) {
					location = new Point (x, y);
					browser.getShell ().setLocation (x, y);
				}
				if ((flags & nsIEmbeddingSiteWindow.DIM_FLAGS_SIZE_INNER) != 0) {
					browser.setSize (cx, cy);
				}
				if ((flags & nsIEmbeddingSiteWindow.DIM_FLAGS_SIZE_OUTER) != 0) {
					browser.getShell ().setSize (cx, cy);
				}
			}else{
				if ((flags & nsIEmbeddingSiteWindow.DIM_FLAGS_POSITION) != 0) {
					location = new Point (x, y);
				}
			}

		return XPCOM.NS_OK;
	}

	int GetDimensions (int flags, int /*long*/ x, int /*long*/ y, int /*long*/ cx, int /*long*/ cy) {

			if(browser==null || browser.isDisposed()) {
				return XPCOM.NS_ERROR_FAILURE;
			}
			
			if ((flags & nsIEmbeddingSiteWindow.DIM_FLAGS_POSITION) != 0) {
				Point location = browser.getShell ().getLocation ();
				if (x != 0) C.memmove (x, new int[] {location.x}, 4); /* PRInt32 */
				if (y != 0) C.memmove (y, new int[] {location.y}, 4); /* PRInt32 */
			}
			if ((flags & nsIEmbeddingSiteWindow.DIM_FLAGS_SIZE_INNER) != 0) {
				Point size = browser.getSize ();
				if (cx != 0) C.memmove (cx, new int[] {size.x}, 4); /* PRInt32 */
				if (cy != 0) C.memmove (cy, new int[] {size.y}, 4); /* PRInt32 */
			}
			if ((flags & nsIEmbeddingSiteWindow.DIM_FLAGS_SIZE_OUTER) != 0) {
				Point size = browser.getShell().getSize ();
				if (cx != 0) C.memmove (cx, new int[] {size.x}, 4); /* PRInt32 */
				if (cy != 0) C.memmove (cy, new int[] {size.y}, 4); /* PRInt32 */
			}
		return XPCOM.NS_OK;
	}
	
	protected int /*long*/ SetFocus() {

		int /*long*/[] result = new int /*long*/[1];

			// Test fix for LHEY9BELW8
			if (this.hasFocus) {
				return 0;
			}

			if(browser==null || browser.isDisposed()) {
				return XPCOM.NS_ERROR_FAILURE;
			}
			nsIWebBrowser webBrowser = this.browser.getWebBrowser();
			
			if(webBrowser == null){
				return XPCOM.NS_ERROR_FAILURE;
			}
			
			int rc = webBrowser.QueryInterface(nsIBaseWindow.NS_IBASEWINDOW_IID, result);

			if (rc != XPCOM.NS_OK) MozillaBrowser.error(rc);
			if (result[0] == 0) MozillaBrowser.error(XPCOM.NS_ERROR_NO_INTERFACE);
			
			nsIBaseWindow baseWindow = new nsIBaseWindow(result[0]);
			rc = baseWindow.SetFocus();
			if (rc != XPCOM.NS_OK) MozillaBrowser.error(rc);
			baseWindow.Release();

		/*
		* Note. Mozilla notifies here that one of the children took
		* focus. This could or should be used to fire an SWT.FOCUS_IN
		* event on Browser focus listeners.
		*/
		return XPCOM.NS_OK;     	
	}	
	
	protected int /*long*/ GetVisibility(int /*long*/ aVisibility) {

			if(browser==null || browser.isDisposed()) {
				return XPCOM.NS_ERROR_FAILURE;
			}
			
			boolean visible = browser.isVisible () && !browser.getShell ().getMinimized ();
			// for xul 10.0
			//XPCOM.memmove (aVisibility, new int[] {visible ? 1 : 0}, 4); /* PRBool */
			XPCOM.memmove (aVisibility, new int[] {visible ? 1 : 0}, 1); /*bool*/

		return XPCOM.NS_OK;     	
	}
	   
	protected int /*long*/ SetVisibility(int /*long*/ aVisibility) {
			if(browser==null || browser.isDisposed()) {
				return XPCOM.NS_ERROR_FAILURE;
			}
			
			WindowEvent event = new WindowEvent(this.browser);
			event.display = this.browser.getDisplay();
			event.widget = this.browser;
			if (aVisibility == 1) {
				/*
				* Bug in Mozilla.  When the JavaScript window.open is executed, Mozilla
				* fires multiple SetVisibility 1 notifications.  The workaround is
				* to ignore subsequent notifications. 
				*/
				if (!this.visible) {
					this.visible = true;
					event.location = this.location;
					event.size = this.size;
					event.addressBar = this.addressBar;
					event.menuBar = this.menuBar;
					event.statusBar = this.statusBar;
					event.toolBar = this.toolBar;
					for (int i = 0; i < this.browser.visibilityWindowListeners.length; i++)
						this.browser.visibilityWindowListeners[i].show(event);
					this.location = null;
					this.size = null;
				}
			} else {
				this.visible = false;
				for (int i = 0; i < this.browser.visibilityWindowListeners.length; i++)
					this.browser.visibilityWindowListeners[i].hide(event);
			}

		return XPCOM.NS_OK;     	
	}
	
	protected int /*long*/ GetTitle(int /*long*/ aTitle) {
		return XPCOM.NS_OK;     	
	}
	 
	protected int /*long*/ SetTitle(int /*long*/ aTitle) {
			if(browser==null || browser.isDisposed()) {
				return XPCOM.NS_ERROR_FAILURE;
			}
			if (this.browser.titleListeners.length == 0) return XPCOM.NS_OK;
			TitleEvent event = new TitleEvent(this.browser);
			event.display = this.browser.getDisplay();
			event.widget = this.browser;
			event.title = WString.toNotNullString(aTitle);
			if(event.title.length()==0){
				event.title=this.browser.getUrl();
			}
			for (int i = 0; i < this.browser.titleListeners.length; i++)
				this.browser.titleListeners[i].changed(event);
		return XPCOM.NS_OK;     	
	}
	private String getUrl(){
		
		try {
			nsIWebBrowser webBrowser = this.browser.getWebBrowser();
			
			if(webBrowser == null){
				return "";
			}
			int /*long*/ [] result = new int /*long*/ [1];
			String url;
			
			int rc = webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
			if (rc != XPCOM.NS_OK) MozillaBrowser.error(rc);
			if (result[0] == 0) MozillaBrowser.error(XPCOM.NS_ERROR_NO_INTERFACE);
			
			nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);		 	
			rc = webNavigation.GetCurrentURI(result);	
			if (rc != XPCOM.NS_OK) MozillaBrowser.error(rc);
			if (result[0] == 0) MozillaBrowser.error(XPCOM.NS_ERROR_NO_INTERFACE);
			webNavigation.Release();
			
			nsIURI location = new nsIURI(result[0]);
			nsEmbedCString aSpec = new nsEmbedCString();
			location.GetSpec(aSpec.getAddress());
			url = aSpec.toString();
			aSpec.dispose();
			return url;
		} catch (Throwable e){
			
			logger.log(Level.SEVERE, "getUrl exception", e);  //$NON-NLS-1$
			
		}
		return "";
	}
	protected int /*long*/ GetSiteWindow(int /*long*/ aSiteWindow) {
		/*
		* Note.  The handle is expected to be an HWND on Windows and
		* a GtkWidget* on GTK.  This callback is invoked on Windows
		* when the javascript window.print is invoked and the print
		* dialog comes up. If no handle is returned, the print dialog
		* does not come up on this platform.  
		*/

			if(browser==null || browser.isDisposed()) {
				return XPCOM.NS_ERROR_FAILURE;
			}
			if (XPCOM.isMacOSX) {
				XPCOM.memmove(aSiteWindow, new int /*long*/[] {this.browser.getEmbedHandle()}, XPCOMObject.PTR_SIZEOF);
			} else {
				/*
				* SPR # RRANBJRAB8 
				* XULRunner's printing facilities on Windows platform destroy
				* the HWND that is returned from here once the print dialog is dismissed
				* (originating bug: https://bugzilla.mozilla.org/show_bug.cgi?id=588735.
				* For this scenario it is now expected that the handle that is returned
				* here is a child of the browser handle, not the browser handle itself.
				*
				* The other scenario that requests this handle is the DOMBrowser.getBrowser()
				* implementation.  This method's GetSiteWindow() invocation is surrounded
				* by boolean flags to help differentiate it from the printing scenario,
				* since DOMBrowser.getBrowser() does not destroy the handle it receives back.
				*
				* All children that are created here are stored and then destroyed once
				* the current page is left.  This is guard code that should only be needed
				* if DOMBrowser.getSiteWindow() is ever invoked by a path other than one of
				* the two described above.
				* 
				* This is also expected to be the alternate implementation to support  
				* old logic of nsIJSContextStack in MozillaBroser.execute()
				*/
				if (MozillaBrowser.IsGettingSiteWindow) {
					XPCOM.memmove(aSiteWindow, new int /*long*/[] {this.browser.getEmbedHandle()}, XPCOMObject.PTR_SIZEOF);
				} else {
					DOMBrowser child = new DOMBrowser (browser, SWT.NONE);
					childWindows.add (child);
					XPCOM.memmove(aSiteWindow, new int /*long*/[] {child.getEmbedHandle()}, XPCOMObject.PTR_SIZEOF);
				}
			}
	
		return XPCOM.NS_OK;     	
	}  
	
	protected int /*long*/ Blur() {
		return XPCOM.NS_OK;     	
	} 
	 
	/* nsIWebBrowserChromeFocus */
	
	protected int /*long*/ FocusNextElement() {
		/*
		* Bug in Mozilla embedding API.  Mozilla takes back the focus after sending
		* this event.  This prevents tabbing out of Mozilla. This behaviour can be reproduced
		* with the Mozilla application TestGtkEmbed.  The workaround is to
		* send the traversal notification after this callback returns.
		*/

			if(browser==null || browser.isDisposed()) {
				return XPCOM.NS_ERROR_FAILURE;
			}
			
			this.browser.getDisplay().asyncExec(new Runnable() {
				public void run() {
					browser.traverse(SWT.TRAVERSE_TAB_NEXT);
				}
			});
	
		return XPCOM.NS_OK;  
	}
	
	protected int /*long*/ FocusPrevElement() {
		/*
		* Bug in Mozilla embedding API.  Mozilla takes back the focus after sending
		* this event.  This prevents tabbing out of Mozilla. This behaviour can be reproduced
		* with the Mozilla application TestGtkEmbed.  The workaround is to
		* send the traversal notification after this callback returns.
		*/

			if(browser==null || browser.isDisposed()) {
				return XPCOM.NS_ERROR_FAILURE;
			}
			
			
			this.browser.getDisplay().asyncExec(new Runnable() {
				public void run() {
					browser.traverse(SWT.TRAVERSE_TAB_PREVIOUS);
				}
			});
		return XPCOM.NS_OK;     	
	}
	
	/* nsIContextMenuListener */
	
	protected int /*long*/ OnShowContextMenu(int /*long*/ aContextFlags, int /*long*/ aEvent, int /*long*/ aNode) {

			if(browser==null || browser.isDisposed()) {
				return XPCOM.NS_ERROR_FAILURE;
			}
			
			
			nsIDOMEvent domEvent = new nsIDOMEvent(aEvent);
			int /*long*/[] result = new int /*long*/[1];
			int rc = domEvent.QueryInterface(nsIDOMMouseEvent.NS_IDOMMOUSEEVENT_IID, result);
			if (rc != XPCOM.NS_OK) MozillaBrowser.error(rc);
			if (result[0] == 0) MozillaBrowser.error(XPCOM.NS_NOINTERFACE);

			nsIDOMMouseEvent domMouseEvent = new nsIDOMMouseEvent(result[0]);
			int[] aScreenX = new int[1], aScreenY = new int[1];
			rc = domMouseEvent.GetScreenX(aScreenX);
			if (rc != XPCOM.NS_OK) MozillaBrowser.error(rc);
			rc = domMouseEvent.GetScreenY(aScreenY);
			if (rc != XPCOM.NS_OK) MozillaBrowser.error(rc);
			domMouseEvent.Release();
			
			Event event = new Event();
			event.x = (int)/*64*/ aScreenX[0];
			event.y = (int)/*64*/ aScreenY[0];
			this.browser.notifyListeners(SWT.MenuDetect, event);
			if (!event.doit) return XPCOM.NS_OK;
			Menu menu = this.browser.getMenu();
			if (menu != null && !menu.isDisposed ()) {
				if (aScreenX[0] != event.x || aScreenY[0] != event.y) {
					menu.setLocation (event.x, event.y);
				}
				menu.setVisible (true);
			}

		return XPCOM.NS_OK;     	
	}
	
	
	
	/* nsIContextMenuListener2 */	
	protected int /*long*/ OnShowContextMenu2(int aContextFlags, int /*long*/ aUtils) {

			if(browser==null || browser.isDisposed()) {
				return XPCOM.NS_ERROR_FAILURE;
			}
			
			ContextMenuListener[] listeners = ((DOMMozillaBrowser)this.browser).getContextMenuListeners();
			if (listeners.length==0){
				return XPCOM.NS_OK;
			}
			
			ContextMenuEvent event = new ContextMenuEvent(this);
			event.widget = this.browser;
			event.setContextFlag(aContextFlags);
	
			nsIContextMenuInfo info = new nsIContextMenuInfo(aUtils);
			int /*long*/[] result = new int /*long*/[1];
			

			int rc = info.GetTargetNode(result);
			if (rc != XPCOM.NS_OK) MozillaBrowser.error(rc);
			
			if(result[0] ==0){ //prevent crash
				return XPCOM.NS_ERROR_FAILURE;
			}
			
			nsIDOMNode domNode = new nsIDOMNode(result[0]);
			
			nsIWebBrowser browser = ((DOMMozillaBrowser)this.browser).getWebBrowser();
			
			if(browser == null){
				return XPCOM.NS_ERROR_FAILURE;
			}
			
			nsISupports nsIsupports = new nsISupports(browser.getAddress()); 
			nsISupportsWrapper wrapper = new nsISupportsWrapper(((DOMMozillaBrowser)this.browser).weakReferenceManager, nsIsupports/*((DOMMozillaBrowser)this.mozillaBrowser).profileDirServiceProvider*/);
			Node node = JNode.createNode(wrapper, domNode);
			
			event.setNode(node);	
			rc =  info.GetMouseEvent(result);
			if (rc != XPCOM.NS_OK) MozillaBrowser.error(rc);
			
			
			nsIDOMEvent domEvent = new nsIDOMEvent(result[0]);
		
			rc = domEvent.QueryInterface(nsIDOMMouseEvent.NS_IDOMMOUSEEVENT_IID, result);
			if (rc != XPCOM.NS_OK) MozillaBrowser.error(rc);
			if (result[0] == 0) MozillaBrowser.error(XPCOM.NS_NOINTERFACE);
			
			nsIDOMMouseEvent domMouseEvent = new nsIDOMMouseEvent(result[0]);
			int[] aScreenX = new int[1], aScreenY = new int[1];
			rc = domMouseEvent.GetScreenX(aScreenX);
			if (rc != XPCOM.NS_OK) MozillaBrowser.error(rc);
			rc = domMouseEvent.GetScreenY(aScreenY);
			if (rc != XPCOM.NS_OK) MozillaBrowser.error(rc);
			domMouseEvent.Release();
			
			event.setX(aScreenX[0]);
			event.setY(aScreenY[0]);

	
			if((aContextFlags &nsIContextMenuListener2.CONTEXT_LINK)!= 0){
				nsEmbedString link = new nsEmbedString();
				rc = info.GetAssociatedLink(link.getAddress());
				if (rc != XPCOM.NS_OK) MozillaBrowser.error(rc);
				event.setLink(link.toString());
				link.dispose();
			}
			

			if((aContextFlags & nsIContextMenuListener2.CONTEXT_IMAGE) !=0){
				int /*long*/[] imageSrc = new int /*long*/[1];
				rc = info.GetImageSrc(imageSrc);
				if (rc != XPCOM.NS_OK) MozillaBrowser.error(rc);
				nsIURI uri = new nsIURI(imageSrc[0]);
				

				nsEmbedCString str = new nsEmbedCString();
				rc = uri.GetSpec(str.getAddress());
				
				event.setImageSrc(str.toString());
				str.dispose();
				
				
			}
			

			for(int i=0; i<listeners.length; i++){
				listeners[i].show(event);
			}
			
			Menu menu = event.getMenu();
			if (menu != null && !menu.isDisposed ()) {
				// force to invisible the menu when event.doit is false
				if (!event.isDoit()){
					menu.setVisible(false);
					return XPCOM.NS_OK;
				}else{
					if (aScreenX[0] != event.getX() || aScreenY[0] != event.getY()) {
						menu.setLocation (event.getX(), event.getY());
					}
					menu.setVisible (true);
				}
			}

		return XPCOM.NS_OK;     	
		
	}
	
	
	/* nsIURIContentListener */
	
	protected int /*long*/ OnStartURIOpen(int /*long*/ aURI, int /*long*/ retval) {
		
		if (isRetrievingBadCert) return XPCOM.NS_OK;
		this.authCount = 0;
			if(browser==null || browser.isDisposed()) {
				return XPCOM.NS_ERROR_FAILURE;
			}
			
			
			nsIURI location = new nsIURI(aURI);
			nsEmbedCString aSpec = new nsEmbedCString();
			location.GetSpec(aSpec.getAddress());
			String value = aSpec.toString("UTF-8");
			aSpec.dispose();

			/*
			* Navigating to "...aboutCertError.xhtml", or to "javascript:showSecuritySection()" when
			* the page "netError.xhtml" is showing, indicates that the last attempted page view had
			* an invalid certificate.  When this happens, veto the current navigate and re-navigate
			* to the page with the bad certificate so that NotifyCertProblem will be invoked.
			*/
			if (value.indexOf ("aboutCertError.xhtml") != -1 || (isViewingErrorPage && value.indexOf ("javascript:showSecuritySection") != -1)) { //$NON-NLS-1$ //$NON-NLS-2$
				// for xul 10.0
				//XPCOM.memmove (retval, new int[] {1}, 4); /* PRBool */
				XPCOM.memmove (retval, new int[] {1}, 1); /*bool*/
				isRetrievingBadCert = true;
				browser.setUrl (lastNavigateURL);
				return XPCOM.NS_OK;
			}
			isViewingErrorPage = value.indexOf ("netError.xhtml") != -1; //$NON-NLS-1$
			
			boolean doit = true;
									

			if (this.browser.locationListeners.length !=0 && request == 0) {
				LocationEvent event = new LocationEvent(this.browser);
				event.display = this.browser.getDisplay();
				event.widget = this.browser;
				event.location = value;
				if (event.location.equals (URI_FROMMEMORY)) {
					/*
					 * If the URI indicates that the page is being rendered from memory
					 * (ie.- via setText()) then set the event location to about:blank
					 * to be consistent with win32.
					 */
					event.location = ABOUT_BLANK;
				}
				event.doit = doit;
				
				try {
					for (int i = 0; i < this.browser.locationListeners.length; i++)
						this.browser.locationListeners[i].changing(event);
				} catch (Exception e) {
					logger.log(Level.SEVERE, "Location changing exception", e);  //$NON-NLS-1$
				}
				
				doit = event.doit && browser!=null && !browser.isDisposed();
				
				// Handle Notes:// , mailto: url on Linux  for SPR # LQPG99MMPA
				if(doit && SWT.getPlatform().equalsIgnoreCase("gtk")){
					if(event.location!= null && ((event.location.trim().length() > 8 && 
							event.location.trim().substring(0, 8).equalsIgnoreCase("notes://")) || 
							(event.location.trim().length() > 7 && 
									event.location.trim().substring(0, 7).equalsIgnoreCase("mailto:")))) //$NON-NLS-1$
					{
						String[] commandArray = new String[2];
						commandArray[0] = "gnome-open";  //$NON-NLS-1$
						commandArray[1] = event.location;
						try{
							Runtime.getRuntime().exec(commandArray);
						}catch(Throwable e){
							logger.logp(Level.SEVERE, PKG_Name, CLASS_NAME, "OnStartURIOpen launch notes:// url failed", e); //$NON-NLS-1$ //$NON-NLS-1$
						}
						event.doit = false;  // stop the propagation.
					}
				}
				
				doit = event.doit && browser!=null && !browser.isDisposed();
				if(doit && !isViewingErrorPage) lastNavigateURL = value;
			}
			
						
			if(doit){
				/*
				 * SPR JLLU7J3DAC
				 * Mozilla feature on Mac. When Mozilla processing a url, if current app is registered
				 * to handle this protocol, Mozilla will pop up a alert saying "* is not a registered 
				 * protocol". This is not the expected behavior when Mozilla is embedding in other applications
				 * (e.g.Notes.app), so we use system launch service to launch url in this situation.
				 * 
				 * see "/uriloader/exthandler/mac/nsInternetConfigService.cpp" for reference
				 * 
				 */
				if(XPCOM.isMacOSX && isProtocolHandleBySelf(value)){
					Program.launch(value);
					doit = false;//stop loading url in mozilla
				}
			}
			/* Note. boolean remains of size 4 on 64 bit machine */
			// for xul 10.0
			//XPCOM.memmove(retval, new int[] {doit ? 0 : 1}, 4);
			XPCOM.memmove(retval, new int[] {doit ? 0 : 1}, 1); /*bool*/

		return XPCOM.NS_OK;
	}
	
	protected int /*long*/ DoContent(int /*long*/ aContentType, int /*long*/ aIsContentPreferred, int /*long*/ aRequest, int /*long*/ aContentHandler, int /*long*/ retval) {
		return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
	}
	
	protected int /*long*/ IsPreferred(int /*long*/ aContentType, int /*long*/ aDesiredContentType, int /*long*/ retval) {
			if(browser==null || browser.isDisposed()) {
				return XPCOM.NS_ERROR_FAILURE;
			}
			
			boolean preferred = false;
			int size = XPCOM.strlen(aContentType);
			if (size > 0) {
				byte[] typeBytes = new byte[size + 1];
				XPCOM.memmove(typeBytes, aContentType, size);
				String contentType = new String(typeBytes, 0, size);

				/* do not attempt to handle known problematic content types */
				if (!contentType.equals(XPCOM.CONTENT_MAYBETEXT) && !contentType.equals(XPCOM.CONTENT_MULTIPART)) {
					/* determine whether browser can handle the content type */
					int /*long*/[] result = new int /*long*/[1];
					int rc = XPCOM.NS_GetServiceManager(result);
					if (rc != XPCOM.NS_OK) MozillaBrowser.error(rc);
					if (result[0] == 0) MozillaBrowser.error(XPCOM.NS_NOINTERFACE);
					nsIServiceManager serviceManager = new nsIServiceManager(result[0]);
					result[0] = 0;
					
					/* First try to use the nsIWebNavigationInfo if it's available */
					byte[] aContractID = Converter.wcsToMbcs (null, XPCOM.NS_WEBNAVIGATIONINFO_CONTRACTID, true);
					rc = serviceManager.GetServiceByContractID (aContractID, nsIWebNavigationInfo.NS_IWEBNAVIGATIONINFO_IID, result);
					if (rc == XPCOM.NS_OK) {
						byte[] bytes = Converter.wcsToMbcs (null, contentType, true);
						int /*long*/ typePtr = XPCOM.nsEmbedCString_new (bytes, bytes.length);
						nsIWebNavigationInfo info = new nsIWebNavigationInfo (result[0]);
						result[0] = 0;
						int[] isSupportedResult = new int[1]; /* PRUint32 */
						rc = info.IsTypeSupported (typePtr, 0, isSupportedResult);
						if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
						info.Release ();
						XPCOM.nsEmbedCString_delete (typePtr);
						preferred = isSupportedResult[0] != 0;
					}else {
						/* nsIWebNavigationInfo is not available, so do the type lookup */
						rc = serviceManager.GetService(XPCOM.NS_CATEGORYMANAGER_CID, nsICategoryManager.NS_ICATEGORYMANAGER_IID, result);
						if (rc != XPCOM.NS_OK) MozillaBrowser.error(rc);
						if (result[0] == 0) MozillaBrowser.error(XPCOM.NS_NOINTERFACE);
	
						nsICategoryManager categoryManager = new nsICategoryManager(result[0]);
						result[0] = 0;
						byte[] categoryBytes = Converter.wcsToMbcs(null, "Gecko-Content-Viewers", true);	//$NON-NLS-1$
						rc = categoryManager.GetCategoryEntry(categoryBytes, typeBytes, result);
						categoryManager.Release();
						/* if no viewer for the content type is registered then rc == XPCOM.NS_ERROR_NOT_AVAILABLE */
						preferred = rc == XPCOM.NS_OK;
					}
					serviceManager.Release();
				}
			}

			/* note that boolean remains of size 4 on 64 bit machines */
			// for xul 10.0
			//XPCOM.memmove(retval, new int[] {preferred ? 1 : 0}, 4);  /* PRBool */
			XPCOM.memmove(retval, new int[] {preferred ? 1 : 0}, 1); /*bool*/
			if (preferred) {
				XPCOM.memmove (aDesiredContentType, new int /*long*/[] {0}, C.PTR_SIZEOF);
			}
		return XPCOM.NS_OK;
	}
	
	protected int /*long*/ CanHandleContent(int /*long*/ aContentType, int /*long*/ aIsContentPreferred, int /*long*/ aDesiredContentType, int /*long*/ retval) {
		return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
	}
	
	protected int /*long*/ GetLoadCookie(int /*long*/ aLoadCookie) {
		return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
	}
	
	protected int /*long*/ SetLoadCookie(int /*long*/ aLoadCookie) {
		return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
	}
	
	protected int /*long*/ GetParentContentListener(int /*long*/ aParentContentListener) {
		return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
	}
		
	protected int /*long*/ SetParentContentListener(int /*long*/ aParentContentListener) {
		return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
	}
	
	/* nsITooltipListener */
	
	protected int /*long*/ OnShowTooltip(int /*long*/ aXCoords, int /*long*/ aYCoords, int /*long*/ aTipText) {

			if(browser==null || browser.isDisposed()) {
				return XPCOM.NS_ERROR_FAILURE;
			}
			
			String text = WString.toNotNullString(aTipText);
			if (this.browser.tip != null && !this.browser.tip.isDisposed()) this.browser.tip.dispose();
			Display display = this.browser.getDisplay();
			Shell parent = this.browser.getShell();
			this.browser.tip = new Shell(parent, SWT.ON_TOP);
			this.browser.tip.setLayout(new FillLayout());
			Label label = new Label(this.browser.tip, SWT.CENTER);
			label.setForeground(display.getSystemColor(SWT.COLOR_INFO_FOREGROUND));
			label.setBackground(display.getSystemColor(SWT.COLOR_INFO_BACKGROUND));
			label.setText(text);
			/*
			* Bug in Mozilla embedded API.  Tooltip coordinates are wrong for 
			* elements inside an inline frame (IFrame tag).  The workaround is 
			* to position the tooltip based on the mouse cursor location.
			*/
			Point point = display.getCursorLocation();
			/* Assuming cursor is 21x21 because this is the size of
			 * the arrow cursor on Windows
			 */ 
			point.y += 21;
			this.browser.tip.setLocation(point);
			this.browser.tip.pack();
			this.browser.tip.setVisible(true);
			return XPCOM.NS_OK;
	}
	
	protected int /*long*/ OnHideTooltip() {
			if(browser==null || browser.isDisposed()) {
				return XPCOM.NS_ERROR_FAILURE;
			}
			
			if (this.browser.tip != null && !this.browser.tip.isDisposed()) this.browser.tip.dispose();
			this.browser.tip = null;
		return XPCOM.NS_OK;
	}
	
	int translateKey (int key) {
		for (int i = 0; i < KeyTable.length; i++) {
			if (KeyTable[i][0] == key) return KeyTable[i][1];
		}
		return 0;
	}
	int lastKeyCode, lastCharCode;

	/* Key Mappings */
	static final int [][] KeyTable = {
		/* Keyboard and Mouse Masks */
		{18,	SWT.ALT},
		{16,	SWT.SHIFT},
		{17,	SWT.CONTROL},
		{224,	SWT.COMMAND},

		/* Literal Keys */
		{65,	'a'},
		{66,	'b'},
		{67,	'c'},
		{68,	'd'},
		{69,	'e'},
		{70,	'f'},
		{71,	'g'},
		{72,	'h'},
		{73,	'i'},
		{74,	'j'},
		{75,	'k'},
		{76,	'l'},
		{77,	'm'},
		{78,	'n'},
		{79,	'o'},
		{80,	'p'},
		{81,	'q'},
		{82,	'r'},
		{83,	's'},
		{84,	't'},
		{85,	'u'},
		{86,	'v'},
		{87,	'w'},
		{88,	'x'},
		{89,	'y'},
		{90,	'z'},
		{48,	'0'},
		{49,	'1'},
		{50,	'2'},
		{51,	'3'},
		{52,	'4'},
		{53,	'5'},
		{54,	'6'},
		{55,	'7'},
		{56,	'8'},
		{57,	'9'},
		{32,	' '},
		{59,	';'},
		{61,	'='},
		{188,	','},
		{190,	'.'},
		{191,	'/'},
		{219,	'['},
		{221,	']'},
		{222,	'\''},
		{192,	'`'},
		{220,	'\\'},
		{108,	'|'},

		/* Non-Numeric Keypad Keys */
		{37,	SWT.ARROW_LEFT},
		{39,	SWT.ARROW_RIGHT},
		{38,	SWT.ARROW_UP},
		{40,	SWT.ARROW_DOWN},
		{45,	SWT.INSERT},
		{36,	SWT.HOME},
		{35,	SWT.END},
		{46,	SWT.DEL},
		{33,	SWT.PAGE_UP},
		{34,	SWT.PAGE_DOWN},

		/* Virtual and Ascii Keys */
		{8,		SWT.BS},
		{13,	SWT.CR},
		{9,		SWT.TAB},
		{27,	SWT.ESC},
		{12,	SWT.DEL},

		/* Functions Keys */
		{112,	SWT.F1},
		{113,	SWT.F2},
		{114,	SWT.F3},
		{115,	SWT.F4},
		{116,	SWT.F5},
		{117,	SWT.F6},
		{118,	SWT.F7},
		{119,	SWT.F8},
		{120,	SWT.F9},
		{121,	SWT.F10},
		{122,	SWT.F11},
		{123,	SWT.F12},
		{124,	SWT.F13},
		{125,	SWT.F14},
		{126,	SWT.F15},
		{127,	0},
		{128,	0},
		{129,	0},
		{130,	0},
		{131,	0},
		{132,	0},
		{133,	0},
		{134,	0},
		{135,	0},

		/* Numeric Keypad Keys */
		{96,	SWT.KEYPAD_0},
		{97,	SWT.KEYPAD_1},
		{98,	SWT.KEYPAD_2},
		{99,	SWT.KEYPAD_3},
		{100,	SWT.KEYPAD_4},
		{101,	SWT.KEYPAD_5},
		{102,	SWT.KEYPAD_6},
		{103,	SWT.KEYPAD_7},
		{104,	SWT.KEYPAD_8},
		{105,	SWT.KEYPAD_9},
		{14,	SWT.KEYPAD_CR},
		{107,	SWT.KEYPAD_ADD},
		{109,	SWT.KEYPAD_SUBTRACT},
		{106,	SWT.KEYPAD_MULTIPLY},
		{111,	SWT.KEYPAD_DIVIDE},
		{110,	SWT.KEYPAD_DECIMAL},

		/* Other keys */
		{20,	SWT.CAPS_LOCK},
		{144,	SWT.NUM_LOCK},
		{145,	SWT.SCROLL_LOCK},
		{44,	SWT.PRINT_SCREEN},
		{6,		SWT.HELP},
		{19,	SWT.PAUSE},
		{3,		SWT.BREAK},

	};

	int HandleEvent (int /*long*/ event) {
		nsIDOMEvent domEvent = new nsIDOMEvent (event);
		nsEmbedString type = new nsEmbedString ();
		int rc = domEvent.GetType (type.getAddress());
		if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
		String typeString = type.toString();
		type.dispose();

		if (XPCOM.DOMEVENT_UNLOAD.equals (typeString)) {
			int /*long*/[] result = new int /*long*/[1];
			rc = domEvent.GetCurrentTarget (result);
			if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
			if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_NOINTERFACE);

			nsIDOMEventTarget target = new nsIDOMEventTarget (result[0]);
			unhookDOMListeners (target);
			target.Release ();
			return XPCOM.NS_OK;
		}

		if (XPCOM.DOMEVENT_FOCUS.equals (typeString)) {	
			handleFocus();		
			return XPCOM.NS_OK;
		}

		if (XPCOM.DOMEVENT_KEYDOWN.equals (typeString)) {
			int /*long*/[] result = new int /*long*/[1];
			rc = domEvent.QueryInterface (nsIDOMKeyEvent.NS_IDOMKEYEVENT_IID, result);
			if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
			if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_NOINTERFACE);
			nsIDOMKeyEvent domKeyEvent = new nsIDOMKeyEvent (result[0]);
			result[0] = 0;

			int[] aKeyCode = new int[1]; /* PRUint32 */
			rc = domKeyEvent.GetKeyCode (aKeyCode);
			if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
			int keyCode = translateKey (aKeyCode[0]);

			/*
			* if keyCode == lastKeyCode then either a repeating key like Shift
			* is being held or a key for which key events are not sent has been
			* pressed.  In both of these cases a KeyDown should not be sent.
			*/
			if (keyCode != lastKeyCode) {
				lastKeyCode = keyCode;
				switch (keyCode) {
					case SWT.SHIFT:
					case SWT.CONTROL:
					case SWT.ALT:
					case SWT.CAPS_LOCK:
					case SWT.NUM_LOCK:
					case SWT.SCROLL_LOCK:
					case SWT.COMMAND: {
						/* keypress events will not be received for these keys, so send KeyDowns for them now */
						int[] aAltKey = new int[1], aCtrlKey = new int[1], aShiftKey = new int[1], aMetaKey = new int[1]; /* PRBool */
						rc = domKeyEvent.GetAltKey (aAltKey);
						if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
						rc = domKeyEvent.GetCtrlKey (aCtrlKey);
						if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
						rc = domKeyEvent.GetShiftKey (aShiftKey);
						if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
						rc = domKeyEvent.GetMetaKey (aMetaKey);
						if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);

						Event keyEvent = new Event ();
						keyEvent.widget = browser;
						keyEvent.type = SWT.KeyDown;
						keyEvent.keyCode = keyCode;
						keyEvent.stateMask = (aAltKey[0] != 0 ? SWT.ALT : 0) | (aCtrlKey[0] != 0 ? SWT.CTRL : 0) | (aShiftKey[0] != 0 ? SWT.SHIFT : 0) | (aMetaKey[0] != 0 ? SWT.COMMAND : 0);
						keyEvent.stateMask &= ~keyCode;		/* remove current keydown if it's a state key */
						browser.notifyListeners (keyEvent.type, keyEvent);
						if (!keyEvent.doit || browser.isDisposed ()) {
							domEvent.PreventDefault ();
						}
						break;
					}
					default: {
						/*
						* If the keydown has Meta (but not Meta+Ctrl) as a modifier then send a KeyDown event for it here
						* because a corresponding keypress event will not be received for it from the DOM.  If the keydown
						* does not have Meta as a modifier, or has Meta+Ctrl as a modifier, then then do nothing here
						* because its KeyDown event will be sent from the keypress listener.
						*/
						int[] aMetaKey = new int[1]; /* PRBool */
						rc = domKeyEvent.GetMetaKey (aMetaKey);
						if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
						if (aMetaKey[0] != 0) {
							int[] aCtrlKey = new int[1]; /* PRBool */
							rc = domKeyEvent.GetCtrlKey (aCtrlKey);
							if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
							if (aCtrlKey[0] == 0) {
								int[] aAltKey = new int[1], aShiftKey = new int[1]; /* PRBool */
								rc = domKeyEvent.GetAltKey (aAltKey);
								if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
								rc = domKeyEvent.GetShiftKey (aShiftKey);
								if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);

								Event keyEvent = new Event ();
								keyEvent.widget = browser;
								keyEvent.type = SWT.KeyDown;
								keyEvent.keyCode = lastKeyCode;
								keyEvent.stateMask = (aAltKey[0] != 0 ? SWT.ALT : 0) | (aCtrlKey[0] != 0? SWT.CTRL : 0) | (aShiftKey[0] != 0? SWT.SHIFT : 0) | (aMetaKey[0] != 0? SWT.COMMAND : 0);
								browser.notifyListeners (keyEvent.type, keyEvent);
								if (!keyEvent.doit || browser.isDisposed ()) {
									domEvent.PreventDefault ();
								}
							}
						}
					}
				}
			}

			domKeyEvent.Release ();
			return XPCOM.NS_OK;
		}

		if (XPCOM.DOMEVENT_KEYPRESS.equals (typeString)) {
			/*
			* if keydown could not determine a keycode for this key then it's a
			* key for which key events are not sent (eg.- the Windows key)
			*/
			if (lastKeyCode == 0) return XPCOM.NS_OK;

			/*
			* On linux only, unexpected keypress events are received for some
			* modifier keys.  The workaround is to ignore these events since
			* KeyDown events are sent for these keys in the keydown listener.
			*/
			switch (lastKeyCode) {
				case SWT.CAPS_LOCK:
				case SWT.NUM_LOCK:
				case SWT.SCROLL_LOCK: return XPCOM.NS_OK;
			}

			int /*long*/[] result = new int /*long*/[1];
			rc = domEvent.QueryInterface (nsIDOMKeyEvent.NS_IDOMKEYEVENT_IID, result);
			if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
			if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_NOINTERFACE);
			nsIDOMKeyEvent domKeyEvent = new nsIDOMKeyEvent (result[0]);
			result[0] = 0;

			int[] aAltKey = new int[1], aCtrlKey = new int[1], aShiftKey = new int[1], aMetaKey = new int[1]; /* PRBool */
			rc = domKeyEvent.GetAltKey (aAltKey);
			if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
			rc = domKeyEvent.GetCtrlKey (aCtrlKey);
			if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
			rc = domKeyEvent.GetShiftKey (aShiftKey);
			if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
			rc = domKeyEvent.GetMetaKey (aMetaKey);
			if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
			int[] aCharCode = new int[1]; /* PRUint32 */
			rc = domKeyEvent.GetCharCode (aCharCode);
			if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
			domKeyEvent.Release ();
			lastCharCode = aCharCode[0];
			if (lastCharCode == 0) {
				switch (lastKeyCode) {
					case SWT.TAB: lastCharCode = SWT.TAB; break;
					case SWT.CR: lastCharCode = SWT.CR; break;
					case SWT.BS: lastCharCode = SWT.BS; break;
					case SWT.ESC: lastCharCode = SWT.ESC; break;
					case SWT.DEL: lastCharCode = SWT.DEL; break;
				}
			}
			if (aCtrlKey[0] != 0 && (0 <= lastCharCode && lastCharCode <= 0x7F)) {
				if ('a'  <= lastCharCode && lastCharCode <= 'z') lastCharCode -= 'a' - 'A';
				if (64 <= lastCharCode && lastCharCode <= 95) lastCharCode -= 64;
			}

			Event keyEvent = new Event ();
			keyEvent.widget = browser;
			keyEvent.type = SWT.KeyDown;
			keyEvent.keyCode = lastKeyCode;
			keyEvent.character = (char)lastCharCode;
			keyEvent.stateMask = (aAltKey[0] != 0 ? SWT.ALT : 0) | (aCtrlKey[0] != 0 ? SWT.CTRL : 0) | (aShiftKey[0] != 0 ? SWT.SHIFT : 0) | (aMetaKey[0] != 0 ? SWT.COMMAND : 0);
			boolean doit = true;
			
			browser.notifyListeners (keyEvent.type, keyEvent);
			doit = keyEvent.doit;
			
			if (!doit || browser.isDisposed ()) {
				domEvent.PreventDefault ();
			}
			return XPCOM.NS_OK;
		}

		if (XPCOM.DOMEVENT_KEYUP.equals (typeString)) {
			int /*long*/[] result = new int /*long*/[1];
			rc = domEvent.QueryInterface (nsIDOMKeyEvent.NS_IDOMKEYEVENT_IID, result);
			if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
			if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_NOINTERFACE);
			nsIDOMKeyEvent domKeyEvent = new nsIDOMKeyEvent (result[0]);
			result[0] = 0;

			int[] aKeyCode = new int[1]; /* PRUint32 */
			rc = domKeyEvent.GetKeyCode (aKeyCode);
			if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
			int keyCode = translateKey (aKeyCode[0]);
			if (keyCode == 0) {
				/* indicates a key for which key events are not sent */
				domKeyEvent.Release ();
				return XPCOM.NS_OK;
			}
			if (keyCode != lastKeyCode) {
				/* keyup does not correspond to the last keydown */
				lastKeyCode = keyCode;
				lastCharCode = 0;
			}

			int[] aAltKey = new int[1], aCtrlKey = new int[1], aShiftKey = new int[1], aMetaKey = new int[1]; /* PRBool */
			rc = domKeyEvent.GetAltKey (aAltKey);
			if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
			rc = domKeyEvent.GetCtrlKey (aCtrlKey);
			if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
			rc = domKeyEvent.GetShiftKey (aShiftKey);
			if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
			rc = domKeyEvent.GetMetaKey (aMetaKey);
			if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
			domKeyEvent.Release ();

			Event keyEvent = new Event ();
			keyEvent.widget = browser;
			keyEvent.type = SWT.KeyUp;
			keyEvent.keyCode = lastKeyCode;
			keyEvent.character = (char)lastCharCode;
			keyEvent.stateMask = (aAltKey[0] != 0 ? SWT.ALT : 0) | (aCtrlKey[0] != 0 ? SWT.CTRL : 0) | (aShiftKey[0] != 0 ? SWT.SHIFT : 0) | (aMetaKey[0] != 0 ? SWT.COMMAND : 0);
			switch (lastKeyCode) {
				case SWT.SHIFT:
				case SWT.CONTROL:
				case SWT.ALT:
				case SWT.COMMAND: {
					keyEvent.stateMask |= lastKeyCode;
				}
			}
			browser.notifyListeners (keyEvent.type, keyEvent);
			if (!keyEvent.doit || browser.isDisposed ()) {
				domEvent.PreventDefault ();
			}
			lastKeyCode = lastCharCode = 0;
			return XPCOM.NS_OK;
		}
		
		
		/* mouse event */

		int /*long*/[] result = new int /*long*/[1];
		rc = domEvent.QueryInterface (nsIDOMMouseEvent.NS_IDOMMOUSEEVENT_IID, result);
		if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
		if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_NOINTERFACE);
		nsIDOMMouseEvent domMouseEvent = new nsIDOMMouseEvent (result[0]);
		result[0] = 0;

		int[] aScreenX = new int[1], aScreenY = new int[1]; /* PRInt32 */

		/*
		 * The position of mouse events is received in screen-relative coordinates
		 * in order to handle pages with frames, since frames express their event
		 * coordinates relative to themselves rather than relative to their top-
		 * level page.  Convert screen-relative coordinates to be browser-relative.
		 */
		rc = domMouseEvent.GetScreenX (aScreenX);
		if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
		rc = domMouseEvent.GetScreenY (aScreenY);
		if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
		Point position = DPIUtil.autoScaleDown(new Point (aScreenX[0], aScreenY[0]));// To Points
		position = browser.getDisplay ().map (null, browser, position);

		int[] aDetail = new int[1]; /* PRInt32 */
		rc = domMouseEvent.GetDetail (aDetail);
		if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
		short[] aButton = new short[1]; /* PRUint16 */
		rc = domMouseEvent.GetButton (aButton);
		if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
		int[] aAltKey = new int[1], aCtrlKey = new int[1], aShiftKey = new int[1], aMetaKey = new int[1]; /* PRBool */
		rc = domMouseEvent.GetAltKey (aAltKey);
		if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
		rc = domMouseEvent.GetCtrlKey (aCtrlKey);
		if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
		rc = domMouseEvent.GetShiftKey (aShiftKey);
		if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
		rc = domMouseEvent.GetMetaKey (aMetaKey);
		if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
		domMouseEvent.Release ();

		Event mouseEvent = new Event ();
		mouseEvent.widget = browser;
		mouseEvent.x = position.x; mouseEvent.y = position.y;
		mouseEvent.stateMask = (aAltKey[0] != 0 ? SWT.ALT : 0) | (aCtrlKey[0] != 0 ? SWT.CTRL : 0) | (aShiftKey[0] != 0 ? SWT.SHIFT : 0) | (aMetaKey[0] != 0 ? SWT.COMMAND : 0);

		if (XPCOM.DOMEVENT_MOUSEDOWN.equals (typeString)) {
			//handleMouseDown ();
			mouseEvent.type = SWT.MouseDown;
			mouseEvent.button = aButton[0] + 1;
			mouseEvent.count = aDetail[0];
		}
		
		browser.notifyListeners (mouseEvent.type, mouseEvent);
		if (browser.isDisposed ()) return XPCOM.NS_OK;
		if (aDetail[0] == 2 && XPCOM.DOMEVENT_MOUSEDOWN.equals (typeString)) {
			mouseEvent = new Event ();
			mouseEvent.widget = browser;
			mouseEvent.x = position.x; mouseEvent.y = position.y;
			mouseEvent.stateMask = (aAltKey[0] != 0 ? SWT.ALT : 0) | (aCtrlKey[0] != 0 ? SWT.CTRL : 0) | (aShiftKey[0] != 0 ? SWT.SHIFT : 0) | (aMetaKey[0] != 0 ? SWT.COMMAND : 0);
			mouseEvent.type = SWT.MouseDoubleClick;
			mouseEvent.button = aButton[0] + 1;
			mouseEvent.count = aDetail[0];
			browser.notifyListeners (mouseEvent.type, mouseEvent);
		}

		return XPCOM.NS_OK;
	}
	
	void unhookDOMListeners (nsIDOMEventTarget target) {
		nsEmbedString string = new nsEmbedString (DOMEVENT_FOCUS);
		target.RemoveEventListener (string.getAddress (), domEventListener.getAddress (), 0);
		string.dispose ();
		
		string = new nsEmbedString (DOMEVENT_KEYDOWN);
		target.RemoveEventListener (string.getAddress (), domEventListener.getAddress (), 0);
		string.dispose ();
		
		string = new nsEmbedString (DOMEVENT_KEYPRESS);
		target.RemoveEventListener (string.getAddress (), domEventListener.getAddress (), 0);
		string.dispose ();
		
		string = new nsEmbedString (DOMEVENT_KEYUP);
		target.RemoveEventListener (string.getAddress (), domEventListener.getAddress (), 0);
		string.dispose ();
		
		string = new nsEmbedString (DOMEVENT_MOUSEDOWN);
		target.RemoveEventListener (string.getAddress (), domEventListener.getAddress (), 0);
		string.dispose ();
	}

	void hookDOMListeners (nsIDOMEventTarget target, boolean isTop) {
		nsEmbedString string = new nsEmbedString (DOMEVENT_FOCUS);
		target.AddEventListener (string.getAddress (), domEventListener.getAddress (), 0);
		string.dispose ();
		
		string = new nsEmbedString (DOMEVENT_KEYDOWN);
		target.AddEventListener (string.getAddress (), domEventListener.getAddress (), 0);
		string.dispose ();
		
		string = new nsEmbedString (DOMEVENT_KEYPRESS);
		target.AddEventListener (string.getAddress (), domEventListener.getAddress (), 0);
		string.dispose ();
		
		string = new nsEmbedString (DOMEVENT_KEYUP);
		target.AddEventListener (string.getAddress (), domEventListener.getAddress (), 0);
		string.dispose ();
		
		string = new nsEmbedString (DOMEVENT_MOUSEDOWN);
		target.AddEventListener (string.getAddress (), domEventListener.getAddress (), 0);
		string.dispose ();
	}

	void unhookDOMListeners () {
		int /*long*/[] result = new int /*long*/[1];
		nsIWebBrowser wb = this.browser.getWebBrowser();
		if (null == wb)
			return;					
		int rc = wb.GetContentDOMWindow(result);
		

		if (rc != XPCOM.NS_OK || result[0] == 0) return;
		nsIDOMWindow window = new nsIDOMWindow (result[0]);
		result[0] = 0;
		rc = window.QueryInterface (nsIDOMEventTarget.NS_IDOMEVENTTARGET_IID, result);
		if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
		if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_ERROR_NO_INTERFACE);

		nsIDOMEventTarget target = new nsIDOMEventTarget (result[0]);
		result[0] = 0;
		unhookDOMListeners (target);
		target.Release ();

		/* Listeners must be unhooked in pages contained in frames */
		rc = window.GetFrames (result);
		if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
		if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_ERROR_NO_INTERFACE);
		nsIDOMWindowCollection frames = new nsIDOMWindowCollection (result[0]);
		result[0] = 0;
		int[] frameCount = new int[1];
		rc = frames.GetLength (frameCount); /* PRUint32 */
		if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
		int count = frameCount[0];

		if (count > 0) {
			for (int i = 0; i < count; i++) {
				rc = frames.Item (i, result);
				if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
				if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_ERROR_NO_INTERFACE);

				nsIDOMWindow frame = new nsIDOMWindow (result[0]);
				result[0] = 0;
				rc = frame.QueryInterface (nsIDOMEventTarget.NS_IDOMEVENTTARGET_IID, result);
				if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
				if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_ERROR_NO_INTERFACE);

				target = new nsIDOMEventTarget (result[0]);
				result[0] = 0;
				unhookDOMListeners (target);
				target.Release ();
				frame.Release ();
			}
		}
		frames.Release ();
		window.Release ();
	}
	
	void handleFocus () {
		if(browser==null || browser.isDisposed()) return;
		if (hasFocus) return;
		hasFocus = true;
		listener = new Listener () {
			public void handleEvent (Event event) {
				if(browser==null || browser.isDisposed()) return;
				if (event.widget == browser) return;
				browser.Deactivate();
				hasFocus = false;
				browser.getDisplay ().removeFilter (SWT.FocusIn, this);
				browser.getShell ().removeListener (SWT.Deactivate, this);
				listener = null;
			}
		};
		browser.getDisplay ().addFilter (SWT.FocusIn, listener);
		browser.getShell ().addListener (SWT.Deactivate, listener);
	}

	void handleMouseDown () {
		if(!browser.active) browser.Activate();
	}
	
	void onDispose () {
		if(browser==null || browser.isDisposed()) return;
		if (listener != null) {
			browser.getDisplay ().removeFilter (SWT.FocusIn, listener);
			browser.getShell ().removeListener (SWT.Deactivate, listener);
			listener = null;
		}
		//SPR # RRANBJRAB8
		childWindows.clear();
		childWindows = null;
		
		browser = null;
		unhookedDOMWindows=null;
	}

/* nsIBadCertListener2 */
int NotifyCertProblem (int /*long*/ socketInfo, int /*long*/ status, int /*long*/ targetSite, int /*long*/ _suppressError) {

	if(browser==null || browser.isDisposed()) {
		return XPCOM.NS_ERROR_FAILURE;
	}
	
	/* determine the host name and port */
	int length = XPCOM.nsEmbedCString_Length (targetSite);
	int /*long*/ buffer = XPCOM.nsEmbedCString_get (targetSite);
	byte[] dest = new byte[length];
	XPCOM.memmove (dest, buffer, length);
	final String urlPort = new String (dest);
	int index = urlPort.indexOf (':');
	final String host = urlPort.substring (0,index);
	final int port = Integer.valueOf (urlPort.substring (index + 1)).intValue ();

	// SPR XXZZ8PFBLS and RJBR8NHJMY
	if(notificationCallbacks.containsKey(urlPort) &&
			notificationCallbacks.get(urlPort) != CertErrorNotifyState.NOTIFY_CANCEL) {
		C.memmove (_suppressError, new int[] {1}, 4); /* PRInt32 */
		return XPCOM.NS_OK;
	}
	notificationCallbacks.put(urlPort, CertErrorNotifyState.INITIALIZE);
	
	/* create text descriptions of the certificate problem(s) */

	int /*long*/[] result = new int /*long*/[1];
	nsISupports supports = new nsISupports (status);
	int rc = supports.QueryInterface (nsISSLStatus.NS_ISSLSTATUS_IID, result);
	if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
	if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_NOINTERFACE);

	nsISSLStatus sslStatus = new nsISSLStatus (result[0]);
	result[0] = 0;
	rc = sslStatus.GetServerCert (result);
	if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
	if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_ERROR_NULL_POINTER);

	final nsIX509Cert cert = new nsIX509Cert (result[0]);
	result[0] = 0;
	String[] problems = new String[3];
	int problemCount = 0, flags = 0;
	int[] intResult = new int[1];

	rc = sslStatus.GetIsDomainMismatch (intResult);
	if (intResult[0] != 0) {
		int /*long*/ ptr = XPCOM.nsEmbedString_new ();
		rc = cert.GetCommonName (ptr);
		if (rc != XPCOM.NS_OK) SWT.error (rc);
		length = XPCOM.nsEmbedString_Length (ptr);
		buffer = XPCOM.nsEmbedString_get (ptr);
		char[] chars = new char[length];
		XPCOM.memmove (chars, buffer, length * 2);
		String name = new String (chars);
		problems[problemCount++] = Compatibility.getMessage ("SWT_InvalidCert_InvalidName", new String[] {name}); //$NON-NLS-1$
		flags |= nsICertOverrideService.ERROR_MISMATCH;
		XPCOM.nsEmbedString_delete (ptr);
	}
	intResult[0] = 1;
	
	rc = sslStatus.GetIsNotValidAtThisTime (intResult);
	if (intResult[0] != 0) {
		rc = cert.GetValidity (result);
		if (rc != XPCOM.NS_OK) SWT.error (rc);
		if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_ERROR_NULL_POINTER);

		nsIX509CertValidity validity = new nsIX509CertValidity(result[0]);
		result[0] = 0;

		int /*long*/ ptr = XPCOM.nsEmbedString_new ();
		rc = validity.GetNotBeforeGMT (ptr);
		if (rc != XPCOM.NS_OK) SWT.error (rc);
		length = XPCOM.nsEmbedString_Length (ptr);
		buffer = XPCOM.nsEmbedString_get (ptr);
		char[] chars = new char[length];
		XPCOM.memmove (chars, buffer, length * 2);
		String notBefore = new String (chars);
		XPCOM.nsEmbedString_delete (ptr);

		ptr = XPCOM.nsEmbedString_new ();
		rc = validity.GetNotAfterGMT (ptr);
		if (rc != XPCOM.NS_OK) SWT.error (rc);
		length = XPCOM.nsEmbedString_Length (ptr);
		buffer = XPCOM.nsEmbedString_get (ptr);
		chars = new char[length];
		XPCOM.memmove (chars, buffer, length * 2);
		String notAfter = new String (chars);
		XPCOM.nsEmbedString_delete (ptr);

		String range = notBefore + " - " + notAfter; //$NON-NLS-1$
		problems[problemCount++] = Compatibility.getMessage ("SWT_InvalidCert_NotValid", new String[] {range}); //$NON-NLS-1$
		flags |= nsICertOverrideService.ERROR_TIME;
		validity.Release ();
	}
	intResult[0] = 0;

	rc = sslStatus.GetIsUntrusted (intResult);
	if (intResult[0] != 0) {
		int /*long*/ ptr = XPCOM.nsEmbedString_new ();
		rc = cert.GetIssuerCommonName (ptr);
		if (rc != XPCOM.NS_OK) SWT.error (rc);
		length = XPCOM.nsEmbedString_Length (ptr);
		buffer = XPCOM.nsEmbedString_get (ptr);
		char[] chars = new char[length];
		XPCOM.memmove (chars, buffer, length * 2);
		String name = new String (chars);
		problems[problemCount++] = Compatibility.getMessage ("SWT_InvalidCert_NotTrusted", new String[] {name}); //$NON-NLS-1$
		flags |= nsICertOverrideService.ERROR_UNTRUSTED;
		XPCOM.nsEmbedString_delete (ptr);
	}
	intResult[0] = 0;
	sslStatus.Release ();
	
	//Task 27922, get the raw binary encoding of each Certificate in the Certificate Chain in DER format
	ArrayList<byte[]> rawCertDERArray = new ArrayList<byte[]>();
	try {
		getRawCertificateInDERFormat(cert, rawCertDERArray);
	}catch (Exception e) {
		if(logger.isLoggable(Level.FINEST)) {
			logger.logp(Level.FINEST, CLASS_NAME, "NotifyCertProblem", //$NON-NLS-1$
				"Exception from getRawCertificateInDERFormat", e); //$NON-NLS-1$
		}
	}
	
	// PCR 11767, if User add CertificateErrorListener, don't prompt default invalid certificate dialog
	// create CertificateErrorEvent to let user have the chance to implement their customized 
	// Invalid Certification Dialog.
	if(browser.certificateErrorListeners.length > 0) {
		CertificateErrorEvent newCertEvent = new CertificateErrorEvent(browser);
		newCertEvent.host = host;
		newCertEvent.port = port;
		newCertEvent.errorFlags = flags;
		newCertEvent.ErrorMismatchStr = problems[0];
		newCertEvent.ErrorTimeStr = problems[1];
		newCertEvent.ErrorUntrustedStr = problems[2];
		newCertEvent.rawCertInDERArray = rawCertDERArray;
		
		try {
			for(int i = 0; i < browser.certificateErrorListeners.length; i++) {
				logger.logp(Level.FINEST, CLASS_NAME, "NotifyCertProblem", //$NON-NLS-1$
						"CertificateErrorListeners invoked"); //$NON-NLS-1$
				browser.certificateErrorListeners[i].handleCertificateError(newCertEvent);
				if(logger.isLoggable(Level.FINEST)){
					logger.logp(Level.FINEST, CLASS_NAME, "NotifyCertProblem", "newCertEvent.doit after:" + newCertEvent.doit + ", browser.certificateErrorListeners[" + i + "]:" + browser.certificateErrorListeners[i]);
				}
				//
				if(newCertEvent.doit)   // event.doit == true -> stop passing to next errListener. 
					break;
			}
		} catch(Throwable e) {
			logger.log(Level.SEVERE, "CertificateErrorListener handleCertificateError exception", e);  //$NON-NLS-1$
		}
		
		// if the last confirmed certificateErrorListener's event.doit == true
		// then continue navigation.
		if(newCertEvent.doit && !browser.isDisposed()) {
			// SPR XXZZ8PFBLS and RJBR8NHJMY
	    	notificationCallbacks.put(urlPort, CertErrorNotifyState.NOTIFY_OK);
			OverrideCert(host, port, lastNavigateURL, cert, flags, !newCertEvent.storeCertPermanently);
		}
		else {
			// SPR XXZZ8PFBLS and RJBR8NHJMY
	    	notificationCallbacks.put(urlPort, CertErrorNotifyState.NOTIFY_CANCEL);
		}
		cert.Release ();
		// for xul 10.0
		// C.memmove (_suppressError, new int[] {1}, 4); /* PRBool */
		C.memmove (_suppressError, new int[] {1}, 1); /*bool*/
		return XPCOM.NS_OK;
	}
	
	/*
	* The invalid certificate dialog must be shown asynchronously because
	* NotifyCertProblem implementations cannot block.
	*/
	final int finalFlags = flags;
	final String[] finalProblems = new String[problemCount];
	System.arraycopy (problems, 0, finalProblems, 0, problemCount);
	final String url = lastNavigateURL;
	browser.getDisplay().asyncExec(new Runnable() {
		public void run() {
			if (browser.isDisposed ()) return;
			if (!url.equals (lastNavigateURL)) return;	/* user has navigated elsewhere */

			// SPR XXZZ8PFBLS and RJBR8NHJMY
			// There's only one CertError Dialog should be prompted out at one time, others waiting..
			for(Object obj : notificationCallbacks.keySet()) {
				if(notificationCallbacks.get(obj) == CertErrorNotifyState.NOTIFY_PROMPT) {
					browser.getDisplay().timerExec(500, this);						
					return;												
				}
			}
			
			String message = Compatibility.getMessage ("SWT_InvalidCert_Message", new String[] {urlPort}); //$NON-NLS-1$
			notificationCallbacks.put(urlPort, CertErrorNotifyState.NOTIFY_PROMPT);
			try{
				if (new InvalidCertDialog(browser.getShell ()).invalidCert ((DOMBrowser)browser, message, finalProblems, (nsIX509Cert)cert)) {
			    	// SPR XXZZ8PFBLS and RJBR8NHJMY
			    	notificationCallbacks.put(urlPort, CertErrorNotifyState.NOTIFY_OK);
			    	OverrideCert(host, port, url, cert, finalFlags, true); // Store the cert temporarily
				}
			    else {
			    	// SPR XXZZ8PFBLS and RJBR8NHJMY
			    	notificationCallbacks.put(urlPort, CertErrorNotifyState.NOTIFY_CANCEL);
			    }
			}
			catch(Exception e) {
				logger.logp(Level.SEVERE, CLASS_NAME, "NotifyCertProblem", //$NON-NLS-1$
					"Exception from MozillaEmbeddingSite"); //$NON-NLS-1$
				notificationCallbacks.put(urlPort, CertErrorNotifyState.NOTIFY_CANCEL);
			}
		    
			cert.Release ();
		}
	});
	// for xul 10.0
	//C.memmove (_suppressError, new int[] {1}, 4); /* PRBool */
	C.memmove (_suppressError, new int[] {1}, 1); /*bool*/
	return XPCOM.NS_OK;
}
	
void OverrideCert(String host, int port, String url, nsIX509Cert cert, int finalFlags, boolean storeFlag) {
	int /*long*/[] result = new int /*long*/[1];
	int rc = XPCOM.NS_GetServiceManager (result);
	if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
	if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_NOINTERFACE);

	nsIServiceManager serviceManager = new nsIServiceManager (result[0]);
	result[0] = 0;
	byte[] aContractID = Converter.wcsToMbcs (null, XPCOM.NS_CERTOVERRIDE_CONTRACTID, true);
	rc = serviceManager.GetServiceByContractID (aContractID, nsICertOverrideService.NS_ICERTOVERRIDESERVICE_IID, result);
	if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
	if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_NOINTERFACE);
	serviceManager.Release ();

	nsICertOverrideService overrideService = new nsICertOverrideService (result[0]);
	result[0] = 0;
	byte[] hostBytes = Converter.wcsToMbcs (null, host, false);
	int /*long*/ hostString = XPCOM.nsEmbedCString_new (hostBytes, hostBytes.length);
	rc = overrideService.RememberValidityOverride (hostString, port, cert.getAddress (), finalFlags, storeFlag?1:0);
	browser.setUrl (url);
	XPCOM.nsEmbedCString_delete (hostString);
	overrideService.Release ();
}

	//Task 27922, get the raw binary encoding of each Certificate in the Certificate Chain in DER format
	private void getRawCertificateInDERFormat(nsIX509Cert cert, ArrayList<byte[]> rawCertDERArray) {
		
		int /*long*/[] retArray = new int /*long*/[1];
		int rc = cert.GetChain(retArray);
		if(rc != XPCOM.NS_OK && retArray[0] == 0) {
			MozillaBrowser.error(rc);
		}
		nsIArray chainArray = new nsIArray(retArray[0]);
		int /*long*/[] item = new int /*long*/[1];
		rc = chainArray.Enumerate(item);
		if(rc != XPCOM.NS_OK && item[0] == 0) {
			MozillaBrowser.error(rc);
		}
		nsISimpleEnumerator enumerator = new nsISimpleEnumerator (item [0]);
		int[] moreElements = new int[1];
		rc = enumerator.HasMoreElements (moreElements);
		if (rc != XPCOM.NS_OK) {
			MozillaBrowser.error (rc);
		}
		
		int[] lenItem = new int[1];
		int /*long*/[] dataItem = new int /*long*/[1];
		while(moreElements[0] != 0){
			int /*long*/[] ret = new int /*long*/[1];
			rc = enumerator.GetNext(ret);
			if (rc != XPCOM.NS_OK) {
				MozillaBrowser.error (rc);
			}
			nsIX509Cert certItem = new nsIX509Cert (ret[0]);

			rc = certItem.GetRawDER(lenItem, dataItem);
			if (rc != XPCOM.NS_OK) {
				MozillaBrowser.error (rc);
			}
			byte[] byteItem = new byte[lenItem[0]];
			XPCOM.memmove(byteItem, dataItem[0], lenItem[0]);
			rawCertDERArray.add(byteItem);
			
			// Reset the conditions
			rc = enumerator.HasMoreElements (moreElements);
			if (rc != XPCOM.NS_OK) {
				MozillaBrowser.error (rc);
			}
		}
	}

}
