/*******************************************************************************
 * Copyright (c) 2000, 2016 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.rcp.dombrowser.browser;


import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

import com.ibm.rcp.dombrowser.XULRunnerVersion;
import com.ibm.rcp.dombrowser.internal.DOMBrowserNLS;
import com.ibm.rcp.dombrowser.internal.DownloadHelper;
import com.ibm.rcp.dombrowser.internal.NativeLoaderProxy;
import com.ibm.rcp.dombrowser.internal.mozilla.Execute;
import com.ibm.rcp.dombrowser.internal.mozilla.WString;
import com.ibm.rcp.dombrowser.internal.mozilla.XPCOM;
import com.ibm.rcp.dombrowser.internal.mozilla.nsDynamicFunctionLoad;
import com.ibm.rcp.dombrowser.internal.mozilla.nsEmbedCString;
import com.ibm.rcp.dombrowser.internal.mozilla.nsEmbedString;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIAppShell;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIBaseWindow;
import com.ibm.rcp.dombrowser.internal.mozilla.nsICategoryManager;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIComponentManager;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIComponentRegistrar;
import com.ibm.rcp.dombrowser.internal.mozilla.nsICookieService;
import com.ibm.rcp.dombrowser.internal.mozilla.nsID;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIDOMSerializer;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIDOMWindow;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIDirectoryService;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIDocShell;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIFactory;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIFile;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIFocusManager;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIHttpProtocolHandler;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIIOService;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIInterfaceRequestor;
import com.ibm.rcp.dombrowser.internal.mozilla.nsILocalFile;
import com.ibm.rcp.dombrowser.internal.mozilla.nsILoginManager;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIMIMEInputStream;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIObserverService;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIPrefBranch;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIPrefLocalizedString;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIPrefService;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIServiceManager;
import com.ibm.rcp.dombrowser.internal.mozilla.nsISupports;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIURI;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIVariant;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIWebBrowser;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIWebBrowserFocus;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIWebBrowserStream;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIWebNavigation;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIWebProgressListener;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIWindowWatcher;
import com.ibm.rcp.dombrowser.support.NativeBrowser;

abstract class MozillaBrowser extends NativeBrowser {
	private static final String DONT_OVERRIDE_XULRUNNER_FACTORY = "org.eclipse.swt.browser.MozillaFactoriesRegistered";  //$NON-NLS-1$
	private nsIWebBrowser webBrowser;
	private static final String CLASS_NAME = MozillaBrowser.class.getName();
	private static final String PKG = MozillaBrowser.class.getPackage().getName();
	private static Logger logger = Logger.getLogger(PKG);
	static boolean isMacOSX =  "carbon".equals(SWT.getPlatform()) || "cocoa".equals(SWT.getPlatform());
	public static boolean IsGettingSiteWindow;
	/**
	 * the point.x of current Display
	 */
	static int DPIx = 0;
	
	/* External Listener management */
	Listener listener;
	int[] folderEvents;
	
	/*
	 * Fix for SPR#BTRY7T2SUL. 
	 * Make listener pointed to static singleton field pointing to a single zero length array,
	 * so that only one instance per class is needed. 
	 */
	private static CloseWindowListener[] emtpyCloseWindowListener = new CloseWindowListener[0];
	private static LocationListener[] emtpyLocationListener = new LocationListener[0];
	private static OpenWindowListener[] emtpyOpenWindowListener = new OpenWindowListener[0];
	private static ProgressListener[] emtpyProgressListener = new ProgressListener[0];
	private static StatusTextListener[] emtpyStatusTextListener = new StatusTextListener[0];
	private static TitleListener[] emtpyTitleListener = new TitleListener[0];
	private static VisibilityWindowListener[] emtpyVisibilityWindowListener = new VisibilityWindowListener[0];
	private static AuthenticationListener[] emtpyAuthenticationListener = new AuthenticationListener[0];
	private static CertificateErrorListener[] emtpyCertificateErrorListener = new CertificateErrorListener[0];
	private static AlertListener[] emtpyAlertListener = new AlertListener[0];
	private static ConfirmListener[] emtpyConfirmListener = new ConfirmListener[0];
	private static PromptListener[] emtpyPromptListener = new PromptListener[0];
	
	static final String EXECUTE_ID = "DOMMozillaBrowserExecuteTemporaryFunction";
	/* Set the NextJSFunctionIndex to 10000 rather than 1 to avoid the conflict with SWT BrowserFunction 
	 * in External.callJava(), and give a chance to invoke the SWT's BrowserFunction method. */
	static int NextJSFunctionIndex = 10000;
	Object evaluateResult;
	static Hashtable AllFunctions = new Hashtable ();
	Hashtable functions = new Hashtable ();
	
	CloseWindowListener[] closeWindowListeners =emtpyCloseWindowListener;// new CloseWindowListener[0];
	LocationListener[] locationListeners = emtpyLocationListener;//new LocationListener[0];
	OpenWindowListener[] openWindowListeners = emtpyOpenWindowListener;//new OpenWindowListener[0];
	ProgressListener[] progressListeners = emtpyProgressListener;//new ProgressListener[0];
	StatusTextListener[] statusTextListeners = emtpyStatusTextListener;//new StatusTextListener[0];
	TitleListener[] titleListeners = emtpyTitleListener;//new TitleListener[0];
	VisibilityWindowListener[] visibilityWindowListeners = emtpyVisibilityWindowListener;//new VisibilityWindowListener[0];
	AuthenticationListener[] authenticationListeners = emtpyAuthenticationListener;
	CertificateErrorListener[] certificateErrorListeners = emtpyCertificateErrorListener;
	AlertListener[] alertListeners = emtpyAlertListener;
	ConfirmListener[] confirmListeners = emtpyConfirmListener;
	PromptListener[] promptListeners = emtpyPromptListener;
	
	protected MozillaEmbeddingSite mozillaEmbeddingSite;
	protected Shell tip;
	
	private boolean isShellDeactived = false;
	
	private ShellAdapter shellAdapter = new ShellAdapter(){
		public void shellActivated(ShellEvent e) {
			isShellDeactived  = false;
		}    		
		public void shellDeactivated(ShellEvent e) {
			isShellDeactived = true;
		}
	};
	
	protected boolean isShellDeactived(){
		return isShellDeactived;
	}
	
	static nsIAppShell AppShell;
	private static nsIPrefBranch prefBranch;
	static WindowCreator WindowCreator;
	static int BrowserCount;
	static boolean initialized=false, ignoreDispose, initialized_XPCOM;
	byte[] htmlBytes;	
	static boolean ignoreDispose2;
	static File grePath = null;
	static AppFileLocProvider LocProvider; 
			
	static final String URI_FROMMEMORY = "file:///"; //$NON-NLS-1$
	static final String ABOUT_BLANK = "about:blank"; //$NON-NLS-1$
	static final String HEADER_CONTENTTYPE = "Content-Type"; //$NON-NLS-1
	static final String MIMETYPE_FORMURLENCODED = "application/x-www-form-urlencoded"; //$NON-NLS-1$
	static final String DISPOSE_LISTENER_HOOKED = "org.eclipse.swt.browser.Mozilla.disposeListenerHooked"; //$NON-NLS-1$
	static final String PREFERENCE_NOTES_PROTOCOL="network.protocol-handler.warn-external.notes";
	static final String PREFERENCE_MAILTO_PROTOCOL="network.protocol-handler.warn-external.mailto";
	static final String PREFERENCE_CAI_PROTOCOL="network.protocol-handler.warn-external.cai";
	static final String PREFERENCE_LANGUAGES = "intl.accept_languages"; //$NON-NLS-1$
	static final String PREFERENCE_CHARSET = "intl.charset.default"; //$NON-NLS-1$
	static final String PREFERENCE_LOCALE = "general.useragent.locale"; //$NON-NLS-1$
	static final String PREFERENCE_SCRIPTTIME = "dom.max_script_run_time"; //$NON-NLS-1$
	static final String PREFERENCE_SCROLLBAR_SIDE = "layout.scrollbar.side";  //$NON-NLS-1$
	static final String PREFERENCE_DEVPIXELSPERPX = "layout.css.devPixelsPerPx";  //$NON-NLS-1$
	
	static final String PREFERENCE_PROFILE_PATH = "profile.path";
	static final String PREFERENCE_DOM_ALLOW_XULXBL_FILE = "dom.allow_XUL_XBL_for_file";
	static final String PREFERENCE_DOM_USE_XULSCOPE_REMOTEXUL = "dom.use_xbl_scopes_for_remote_xul";
	static final String PREFERENCE_BROWSER_NEVERASK_SAVETODISK = "browser.helperApps.neverAsk.saveToDisk";
	static final String PREFERENCE_BROWSER_NEVERASK_OPENFILE = "browser.helperApps.neverAsk.openFile";	
	
	static final String PREFERENCE_TEXT_MIMETYPES = "text/plain,text/xml,text/css,text/javascript,text/html,text/*";	
	static final String PREFERENCE_IMAGE_MIMETYPES = "image/jpeg,image/gif,image/png,image/svg+xml,image/*,"
			+ "image/pjpeg,image/jpg,image/x-ms-bmp,image/bmp,image/x-icon,image/vnd.microsoft.icon,image/icon,image/x-png,image/ico,image/icon-ms,image/ico-ms,"
			+ "image/jpeg,image/bmp,image/webp";	
	static final String PREFERENCE_AUDIO_MIMETYPES = "audio/midi,audio/mpeg,audio/webm,audio/ogg,audio/wav,"
			+ "audio/mpeg,audio/ogg,audio/wave,audio/*";	
	static final String PREFERENCE_VIDEO_MIMETYPES = "video/webm,video/ogg,video/mp4,video/*";	
	static final String PREFERENCE_MULTIPART_MIMETYPES = "multipart/form-data,multipart/byteranges";	
	static final String PREFERENCE_APPLICATION_MIMETYPES = "application/x-shockwave-flash, "
			+ "application/*,application/json,application/javascript,application/ecmascript, "
			+ "application/octet-stream,application/pkcs12,application/vnd.mspowerpoint,application/xhtml+xml,application/xml,application/pdf";	
	static final String PREFERENCE_MIMETYPES = PREFERENCE_TEXT_MIMETYPES + PREFERENCE_IMAGE_MIMETYPES + PREFERENCE_AUDIO_MIMETYPES + 
			PREFERENCE_VIDEO_MIMETYPES + PREFERENCE_MULTIPART_MIMETYPES + PREFERENCE_APPLICATION_MIMETYPES;
	
	static final String PREF_EM_LAST_APP_VERSION = "extensions.lastAppVersion";
	static final String PREF_ACCEPTED_MIME_TYPES = "AcceptedMimeTypes";
	static final String PREF_ACCEPTED_MIME_TYPES_VAL = "IMAGES_AND_DOCUMENTS";
	static final String CHAR_ONE = "1";
	static final String PREF_NETWORK_PROTOCOL_HANDLER_WARN = "network.protocol-handler.warn-external-default";
	static final String PREF_GFX_DIRECT2D_DISABLED = "gfx.direct2d.disabled";
	static final String PREF_GFX_DIRECT2D_FORCE_ENABLED = "gfx.direct2d.force-enabled";
	static final String PREF_LAYERS_ACCELERATION_DISABLED = "layers.acceleration.disabled";
	static final String PREF_LAYERS_ACCELERATION_FORCE_ENABLED = "layers.acceleration.force-enabled";
	static final String PREF_LAYERS_COMPOSITOR_LRU_SIZE = "layers.compositor-lru-size";
	static final String PREF_LOGGING_ENABLED = "extensions.logging.enabled";
	static final String PREF_ACCESSIBILITY_TABFOCUS = "accessibility.tabfocus";
	static final String PREF_ACCESSIBILITY_TABFOCUS_FOR_XUL = "accessibility.tabfocus_applies_to_xul";
	
	/**
	 * whether set browser DPI automatically according to current system.
	 */
	static boolean enableDPIAutoConfig = false;  //$NON-NLS-1$
	static final String ENABLE_DPI_AUTO = "enableDPIAutoConfig";
	
    /**
	 * whether trust the cert in Notes.
	 */
	static boolean enableCrossCertificate = false;  //$NON-NLS-1$
	static final String ENABLE_CROSS_CERTIFICATE = "enableCrossCertificate";

	static final String PREFERENCE_REMEMBERSIGNONS = "signon.rememberSignons"; //$NON-NLS-1$
	static final String PREFERENCE_EXPIREMASTERPASSWORD = "signon.expireMasterPassword"; //$NON-NLS-1$
	static final String PREFERENCE_PREFILLFORMS = "signon.prefillForms"; //$NON-NLS-1$
	static final String PREFERENCE_SIGNONFILENAME = "signon.SignonFileName"; //$NON-NLS-1$
	static final String PREFERENCE_SIGNONFILENAME2 = "signon.SignonFileName2"; //$NON-NLS-1$
	static final String PREFERENCE_SECURITY_ENABLE_JAVA = "security.enable_java"; //$NON-NLS-1$
	static final String PREFERENCE_OOPP_ENABLE_APPLET_WIN32 = "dom.ipc.plugins.enabled.npjp2.dll"; //$NON-NLS-1$
	static final String PREFERENCE_OOPP_ENABLE_APPLET_LINUX = "dom.ipc.plugins.enabled.libnpjp2.so"; //$NON-NLS-1$
	
	static final String PREFERENCE_ECDH_RSA_RC4_128_SHA= "security.ssl3.ecdh_rsa_rc4_128_sha"; //$NON-NLS-1$
	static final String PREFERENCE_ECDH_ECDSA_RC4_128_SHA = "security.ssl3.ecdh_ecdsa_rc4_128_sha"; //$NON-NLS-1$
	static final String PREFERENCE_ECDHE_ECDSA_RC4_128_SHA = "security.ssl3.ecdhe_ecdsa_rc4_128_sha"; //$NON-NLS-1$
	static final String PREFERENCE_ECDHE_RSA_RC4_128_SHA = "security.ssl3.ecdhe_rsa_rc4_128_sha"; //$NON-NLS-1$
	static final String PREFERENCE_RSA_RC4_128_MD5 = "security.ssl3.rsa_rc4_128_md5"; //$NON-NLS-1$
	static final String PREFERENCE_RSA_RC4_128_SHA = "security.ssl3.rsa_rc4_128_sha"; //$NON-NLS-1$
	
	static final String PREFERENCE_DHE_DSS_AES_128_SHA= "security.ssl3.dhe_dss_aes_128_sha"; //$NON-NLS-1$
	static final String PREFERENCE_DHE_DSS_AES_256_SHA = "security.ssl3.dhe_dss_aes_256_sha"; //$NON-NLS-1$
	static final String PREFERENCE_DHE_DSS_CAMELLIA_128_SHA = "security.ssl3.dhe_dss_camellia_128_sha"; //$NON-NLS-1$
	static final String PREFERENCE_DHE_DSS_CAMELLIA_256_SHA = "security.ssl3.dhe_dss_camellia_256_sha"; //$NON-NLS-1$
	static final String PREFERENCE_DHE_RSA_AES_128_SHA = "security.ssl3.dhe_rsa_aes_128_sha"; //$NON-NLS-1$
	static final String PREFERENCE_DHE_RSA_AES_256_SHA = "security.ssl3.dhe_rsa_aes_256_sha"; //$NON-NLS-1$
	static final String PREFERENCE_DHE_RSA_CAMELLIA_128_SHA = "security.ssl3.dhe_rsa_camellia_128_sha"; //$NON-NLS-1$
	static final String PREFERENCE_DHE_RSA_CAMELLIA_256_SHA = "security.ssl3.dhe_rsa_camellia_256_sha"; //$NON-NLS-1$
	static final String PREFERENCE_DHE_RSA_DES_SHA = "security.ssl3.dhe_rsa_des_ede3_sha"; //$NON-NLS-1$
	static final String PREFERENCE_DHE_DSS_DES_EDE3_SHA = "security.ssl3.dhe_dss_des_ede3_sha";//$NON-NLS-1$
			
	static final String PREFERENCE_ECDH_ECDSA_AES_128_SHA = "security.ssl3.ecdh_ecdsa_aes_128_sha";//$NON-NLS-1$
	static final String PREFERENCE_ECDH_ECDSA_AES_256_SHA = "security.ssl3.ecdh_ecdsa_aes_256_sha";//$NON-NLS-1$
	static final String PREFERENCE_ECDH_ECDSA_DES_EDE3_SHA= "security.ssl3.ecdh_ecdsa_des_ede3_sha";//$NON-NLS-1$
	static final String PREFERENCE_ECDH_RSA_AES_128_SHA = "security.ssl3.ecdh_rsa_aes_128_sha";//$NON-NLS-1$
	static final String PREFERENCE_ECDH_RSA_AES_256_SHA = "security.ssl3.ecdh_rsa_aes_256_sha";//$NON-NLS-1$
	static final String PREFERENCE_ECDH_RSA_DES_EDE3_SHA = "security.ssl3.ecdh_rsa_des_ede3_sha";//$NON-NLS-1$
	
	static final String PROFILE_DO_CHANGE = "profile-do-change"; //$NON-NLS-1$
	static final String PROFILE_AFTER_CHANGE = "profile-after-change"; //$NON-NLS-1$
	static final String PROFILE_BEFORE_CHANGE = "profile-before-change"; //$NON-NLS-1$
	static final String PREFERENCE_DOWNLOAD_MANANGER_RETENTION="browser.download.manager.retention";//$NON-NLS-1$
	static final int DOM_SCRIPTTIME = 0; //$NON-NLS-1$
	static final String SEPARATOR_LOCALE = "-"; //$NON-NLS-1$
	static final String TOKENIZER_LOCALE = ","; //$NON-NLS-1$
	static final int PREFERENCE_FALSE = 0; //$NON-NLS-1$
	static final int PREFERENCE_TRUE = 1; //$NON-NLS-1$
	static final int PREFERENCE_DOWNLOAD_MANANGER_RETENTION_VALUE = 2;
	static final String SEPARATOR_OS = System.getProperty ("file.separator"); //$NON-NLS-1$
	static final String PROFILE_DIR = SEPARATOR_OS + "eclipse" + SEPARATOR_OS; //$NON-NLS-1$
	static final String SHUTDOWN_PERSIST = "shutdown-persist"; //$NON-NLS-1$
	static final String STARTUP = "startup"; //$NON-NLS-1$
	
	static final String XULRUNNER_INITIALIZED = "org.eclipse.swt.browser.XULRunnerInitialized"; //$NON-NLS-1$
	static final String XULRUNNER_PATH = "org.eclipse.swt.browser.XULRunnerPath"; //$NON-NLS-1$
	static final String PLUGIN_NAME = "com.ibm.rcp.dombrowser"; //$NON-NLS-1$
	final String PREFERENCE_ENABLE_APPLET = "enableApplet"; //$NON-NLS-1$
	static Listener DisplayListener;
	static final String PREFERENCE_ENABLE_SSLV3 = "security.enable_ssl3"; //$NON-NLS-1$
	private static String enableRC4Property = "com.ibm.jsse2.enableRC4";//$NON-NLS-1$
	private static String enableDHProperty = "com.ibm.jsse2.enableDH";//$NON-NLS-1$
	private static String enableECDHProperty = "com.ibm.jsse2.enableECDH";//$NON-NLS-1$
	private static boolean isEnableRC4 = System.getProperty(enableRC4Property) != null && 
	System.getProperty(enableRC4Property).equalsIgnoreCase("true");//$NON-NLS-1$	
	
	private static boolean isEnableDHE = System.getProperty(enableDHProperty) != null && 
	System.getProperty(enableDHProperty).equalsIgnoreCase("true");//$NON-NLS-1$
	
	private static boolean isEnableECDH = System.getProperty(enableECDHProperty) != null && 
	System.getProperty(enableECDHProperty).equalsIgnoreCase("true");	//$NON-NLS-1$
	
	
	boolean active;
	
	private static final String BROWSER_PREFERENCE_NODE = "com.ibm.rcp.browser";
	
	// SPR # RJBR8NHJMY
	/**
	 * status of whether to enable the notification of certificate errors when loading javascript/css/image 
	 * elements via https.
	 */
	private boolean bExtendedCENotifiyEnabled = false;
	{
		try {
			bExtendedCENotifiyEnabled = Platform.getPreferencesService().getBoolean("com.ibm.rcp.browser.service", 
					"ExtendedCertErrorNotify", false, null);
		}catch(Exception e) {
			logger.logp(Level.WARNING, CLASS_NAME, "bExtendedCENotifiyEnabled", //$NON-NLS-1$
					"Exception from MozillaBrowser", e); //$NON-NLS-1$
			bExtendedCENotifiyEnabled = false;
		}
	}
	
	public boolean isExtendedCertErrorNotificationEnabled() {
		return bExtendedCENotifiyEnabled;
	}
	public void enableExtendedCertErrorNotification(boolean enable) {
		bExtendedCENotifiyEnabled = enable;
	}
	
	static{
		DisplayListener = new Listener () {

			public void handleEvent(Event event) {
				if (BrowserCount > 0) return; /* another display is still active */

				int /*long*/[] result = new int /*long*/[1];
				int rc = XPCOM.NS_GetServiceManager (result);
				if (rc != XPCOM.NS_OK) error (rc);
				if (result[0] == 0) error (XPCOM.NS_NOINTERFACE);

				nsIServiceManager serviceManager = new nsIServiceManager (result[0]);
				result[0] = 0;		
				byte[] buffer = Converter.wcsToMbcs (null, XPCOM.NS_OBSERVER_CONTRACTID, true);
				rc = serviceManager.GetServiceByContractID (buffer, nsIObserverService.NS_IOBSERVERSERVICE_IID, result);
				if (rc != XPCOM.NS_OK) error (rc);
				if (result[0] == 0) error (XPCOM.NS_NOINTERFACE);

				nsIObserverService observerService = new nsIObserverService (result[0]);
				result[0] = 0;
				buffer = Converter.wcsToMbcs (null, PROFILE_BEFORE_CHANGE, true);
				int length = SHUTDOWN_PERSIST.length ();
				char[] chars = new char [length + 1];
				SHUTDOWN_PERSIST.getChars (0, length, chars, 0);
				rc = observerService.NotifyObservers (0, buffer, chars);
				if (rc != XPCOM.NS_OK) error (rc);
				observerService.Release ();

				if (LocProvider != null) {
					String prefsLocation = LocProvider.profilePath + AppFileLocProvider.PREFERENCES_FILE;
					nsEmbedString pathString = new nsEmbedString (prefsLocation);
					rc = XPCOM.NS_NewLocalFile (pathString.getAddress (), true, result);
					if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
					if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_ERROR_NULL_POINTER);
					pathString.dispose ();

					nsILocalFile localFile = new nsILocalFile (result [0]);
					result[0] = 0;
				    rc = localFile.QueryInterface (nsIFile.NS_IFILE_IID, result); 
					if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
					if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_ERROR_NO_INTERFACE);
					localFile.Release ();

					nsIFile prefFile = new nsIFile (result[0]);
					result[0] = 0;

					buffer = Converter.wcsToMbcs (null, XPCOM.NS_PREFSERVICE_CONTRACTID, true);
					rc = serviceManager.GetServiceByContractID (buffer, nsIPrefService.NS_IPREFSERVICE_IID, result);
					if (rc != XPCOM.NS_OK) error (rc);
					if (result[0] == 0) error (XPCOM.NS_NOINTERFACE);

					nsIPrefService prefService = new nsIPrefService (result[0]);
					result[0] = 0;
					rc = prefService.SavePrefFile(prefFile.getAddress ());
					prefService.Release ();
					prefFile.Release ();
			}
				
				serviceManager.Release ();
				// release downloadManager
				if(DownloadHelper.downloadManager!=null){
					DownloadHelper.downloadManager.Release();
				}
				if(DownloadHelper.downloadManagerUI!=null){
					DownloadHelper.downloadManagerUI.Release();
				}

				/*
				 * Comment this line to fix bug of JVM crash during dispose the browser's display. 
				 * Related Eclipse bug: https://bugs.eclipse.org/bugs/show_bug.cgi?id=287458
				 * And there's no memory leak after commented this line, reason is XPCOM.XPCOMGlueShutdown()
				 * only can be invoked when disposing the browser's display, once the display is disposed,
				 * the whole JVM application is disposed too. No memory leak in browser.
				 */
				//XPCOM.XPCOMGlueShutdown ();
				initialized = false;
			}
			
		};

		//init some pref
		IPreferencesService preferencesService = Platform.getPreferencesService();
		Preferences pPref = preferencesService.getRootNode().node(DefaultScope.SCOPE).node(PLUGIN_NAME); 
		if(pPref instanceof IEclipsePreferences){
			IEclipsePreferences ePref = ((IEclipsePreferences)pPref);
			enableDPIAutoConfig = ePref.getBoolean(ENABLE_DPI_AUTO, false) || preferencesService.getBoolean(PLUGIN_NAME, ENABLE_DPI_AUTO, false, null);
			enableCrossCertificate = ePref.getBoolean(ENABLE_CROSS_CERTIFICATE, false) || preferencesService.getBoolean(PLUGIN_NAME, ENABLE_CROSS_CERTIFICATE, false, null);
			if(logger.isLoggable(Level.FINEST)){
				logger.logp(Level.FINEST, CLASS_NAME, "MozillaBrowser static init", "enableDPIAutoConfig:" + enableDPIAutoConfig);
				logger.logp(Level.FINEST, CLASS_NAME, "MozillaBrowser static init", "enableCrossCertificate:" + enableCrossCertificate);
			}
		}
	}
	
	protected MozillaBrowser(Composite parent, int style) {
		super(parent, style);

		if(logger.isLoggable(Level.FINEST)){
			logger.logp(Level.FINEST, CLASS_NAME, "MozillaBrowser Constructor", "Create a xulrunner based browser!");  //$NON-NLS-1$  //$NON-NLS-2$
		}
		Display display = parent.getDisplay ();
		int /*long*/[] result = new int /*long*/[1];
		if (!initialized) {
			int /*long*/ [] retVal = new int /*long*/[1];
			int rc=0;
			try {
				grePath = NativeLoaderProxy.getXULRunnerPath();
//				NativeLoaderProxy.loadXULRunnerLibrary();				
			}catch (Exception e) {
				logger.logp(Level.WARNING, CLASS_NAME, "MozillaBrowser", //$NON-NLS-1$
						"Exception from MozillaBrowser.NativeLoaderProxy.getXULRunnerPath()", e); //$NON-NLS-1$
				dispose();
				SWT.error(SWT.ERROR_NO_HANDLES, e, " [Can not get Xulrunner Path]"); //$NON-NLS-1$
			}
			String mozillaPath = grePath.getAbsolutePath();
			if (mozillaPath == null) {
				dispose();
				SWT.error(SWT.ERROR_NO_HANDLES, null, " [Unknown Mozilla path]"); //$NON-NLS-1$
			}
			
			try {
				NativeLoaderProxy.loadJNI();
			}
			catch (Exception e) {
				logger.logp(Level.WARNING, CLASS_NAME, "MozillaBrowser", //$NON-NLS-1$
						"Exception from MozillaBrowser.NativeLoaderProxy.loadJNI()", e); //$NON-NLS-1$
				dispose();
				SWT.error(SWT.ERROR_NO_HANDLES, e, " [Failed to load swtxpcom library]"); //$NON-NLS-1$
			}
			try {
				/*
				* Remove the trailing xpcom lib name from mozillaPath because the
				* Mozilla.initialize and NS_InitXPCOM2 invocations require a directory name only.
				*/
				loadAdditionalLibraries (mozillaPath);
				byte[] path;
				if (isMacOSX) {
					path = Converter.wcsToMbcs (null, mozillaPath + 
							SEPARATOR_OS + "MacOS" + SEPARATOR_OS +
							NativeLoaderProxy.getXULRunnerLibrary(), true);
				} else {
					path = Converter.wcsToMbcs (null, mozillaPath + SEPARATOR_OS +
							NativeLoaderProxy.getXULRunnerLibrary(), true);
				}
				rc = XPCOM.XPCOMGlueStartup (path);
				if (rc != XPCOM.NS_OK) {
					dispose();
					throw new Exception("XPCOMGlueStartup failed. rc = " +rc); //$NON-NLS-1$
				}
			}catch (Exception e) {
				logger.logp(Level.WARNING, CLASS_NAME, "MozillaBrowser", //$NON-NLS-1$
						"Exception from MozillaBrowser", e); //$NON-NLS-1$
				dispose();
				SWT.error(SWT.ERROR_NO_HANDLES, e, " [XPCOMGlueStartup failed]"); //$NON-NLS-1$
			}	
			/**
			 * Check if other components have already initialized MOZILLA XULRunner runtime
			 * This happens when SWT.Browser creates MOZILLA based browser prior to any RCP browser
			 */
			String xulrunnerInitialized = System.getProperty(XULRUNNER_INITIALIZED);
			if("true".equalsIgnoreCase(xulrunnerInitialized)) {
				initialized_XPCOM = true;
			}else{
				initialized_XPCOM = false;
			}
			
			if(!initialized_XPCOM) {
				try{
					nsEmbedString path = new nsEmbedString(mozillaPath);
					rc = XPCOM.NS_NewLocalFile(path.getAddress(), true, retVal);
					path.dispose();
					if (rc != XPCOM.NS_OK) error(rc);
					if (retVal[0] == 0) error(XPCOM.NS_ERROR_NULL_POINTER);
					
					LocProvider = new AppFileLocProvider(mozillaPath);
					LocProvider.AddRef();
					
					String profilePath;
					try {
						profilePath = new File(Platform.getInstanceLocation().getURL().getFile()).getPath() //create profile in Application Data directory
						+ SEPARATOR_OS + "BrowserProfile" + SEPARATOR_OS;//$NON-NLS-1$
					} catch (Exception e) {
						
						profilePath = mozillaPath + SEPARATOR_OS+  "BrowserProfile" + SEPARATOR_OS; //$NON-NLS-1$
					}

					LocProvider.setProfilePath (profilePath);
					
					//Copy cert8.db file into browser profile directory 
					copyCert8DBFile(profilePath);
					
					//Initialize external.xpt for browserFunction	
					initOldExternal (profilePath);
					
					//Initialize swt.xpt for browserFunction	
					initExternal (profilePath);
					
					nsILocalFile localFile = new nsILocalFile(retVal[0]);
										
					int size = XPCOM.nsDynamicFunctionLoad_sizeof ();
					/* alloc memory for two structs, the second is empty to signify the end of the list */
					int /*long*/ ptr = C.malloc (size * 2);
					C.memset (ptr, 0, (int /*long*/) size * 2);
					nsDynamicFunctionLoad functionLoad = new nsDynamicFunctionLoad();
					//byte[] bytes = Converter.wcsToMbcs (null, "XRE_InitEmbedding", true); //$NON-NLS-1$
					// From XULRunner 2.0+, "XRE_InitEmbedding" -> "XRE_InitEmbedding2", for xul 10.0
					byte[] bytes = Converter.wcsToMbcs (null, "XRE_InitEmbedding2", true); //$NON-NLS-1$
					functionLoad.functionName = C.malloc (bytes.length);
					C.memmove (functionLoad.functionName, bytes, bytes.length);
					functionLoad.function = C.malloc (C.PTR_SIZEOF);
					C.memmove (functionLoad.function, new int /*long*/[] {0} , C.PTR_SIZEOF);
					XPCOM.memmove (ptr, functionLoad, XPCOM.nsDynamicFunctionLoad_sizeof ());
					XPCOM.XPCOMGlueLoadXULFunctions (ptr);
					C.memmove (result, functionLoad.function, C.PTR_SIZEOF);
					int /*long*/ functionPtr = result[0];
					result[0] = 0;
					C.free (functionLoad.function);
					C.free (functionLoad.functionName);
					C.free (ptr);
					//rc = XPCOM.Call (functionPtr, localFile.getAddress (), localFile.getAddress (), LocProvider.getAddress (), 0, 0);
					// for xul 10.0
					System.out.println("localfile :: " + Long.toHexString(localFile.getAddress()));
					System.out.println("LocProvider :: " + Long.toHexString(LocProvider.getAddress()));
					rc = XPCOM.Call (functionPtr, localFile.getAddress (), localFile.getAddress (), LocProvider.getAddress ());
					if (rc == XPCOM.NS_OK) {
						System.setProperty (XULRUNNER_PATH, mozillaPath);
					}


	//				rc = XPCOM.NS_InitXPCOM2(0, localFile.getAddress(), LocProvider.getAddress());
					
					
					localFile.Release();
	
					if (rc != XPCOM.NS_OK) {
						if (LocProvider != null)
							LocProvider.Release();
						LocProvider = null;
						dispose();
						SWT.error(SWT.ERROR_NO_HANDLES,null,
											" [NS_InitEmbedding " + mozillaPath + " error " + rc + "]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					}
					
					// add for xul 10.0, add BrowserProfile/chrome.manifest for register external.xpt
					addManifestLocation(profilePath);
					// add for register NLS components
					addManifestLocation(AppFileLocProvider.getNLPath(""));
				}catch(Throwable th){
					logger.logp(Level.WARNING, CLASS_NAME, "MozillaBrowser", //$NON-NLS-1$
							"Throwable from MozillaBrowser", th); //$NON-NLS-1$
					dispose();
					SWT.error(SWT.ERROR_NO_HANDLES, th);
				}
				initialized_XPCOM=true;
				/**
				 *  Set property back after it is correctly initiazlied. 
				 */
				System.setProperty(XULRUNNER_INITIALIZED, "true");
				System.setProperty(XULRUNNER_PATH,grePath.getAbsolutePath());
			}						
			/**
			 * SWT# 193867
			 * SWT browser has conflicts with XULRunner browser on Linux. OR SWT.MOZILLA style.
			 * In this work around, we call initSWTService()(In each native fragments to force a
			 * SWT Browser is created and then disposed at this point.
			 * 
			 * The root cause is: Mozilla provide service factory callbacks than hosting
			 * applications can register, while within JVM, we have both SWT Browser & XULRunner browser will try to register
			 * with their factory classes. The Mozilla rule is later wins!
			 * 
			 * This causes problem that if SWT browser is initialized after xulrunner browser, our callbacks will be overridden, and then
			 * unexpected result/crash when handling many services: open window/ prompt/ download.
			 * 
			 * Side impacts:
			 * -To create/dispose a hidden shell on Linux and then a browser widget inside it. About 1/3 Second time is used in a normal machine.
			 * This only happens once for the runtime. 
			 * -If the swtbrowser already initialized before any xulrunner browser, we won't create that hidden shell
			 * 
			 */
			//initSWTService();
			
			String msg[] = new String[1]; 
			rc = checkVersion(msg);
			if (rc != XPCOM.NS_OK) {
				dispose();
				error(rc);
			}
			if (msg[0] != null) {
				dispose();
				SWT.error(SWT.ERROR_NO_HANDLES, null,msg[0]);
			}

			rc = XPCOM.NS_GetComponentManager(result);
			if (rc != XPCOM.NS_OK) error(rc);
			if (result[0] == 0) error(XPCOM.NS_NOINTERFACE);
			
			nsIComponentManager componentManager = new nsIComponentManager(result[0]);
			result[0] = 0;

//			/*
//			 * modified by peina 2007.9.24
//			 * on MacOX, AppShell.Spinup() cause odd behavior, so remove the spinUp on MacOX
//			 * fix SPR XKRN76KD56
//			 */
//			if(isInitAppShell()){
//				initAppShell(componentManager);
//			}
			
			WindowCreator = new WindowCreator();
			WindowCreator.AddRef();
			
			rc = XPCOM.NS_GetServiceManager(result);
			if (rc != XPCOM.NS_OK) error(rc);
			if (result[0] == 0) error(XPCOM.NS_NOINTERFACE);
			
			nsIServiceManager serviceManager = new nsIServiceManager(result[0]);
			result[0] = 0;		
			
			
			/////////////////////////////////// moved the code below after setting profile.path in moz char pref
			//Get an instance of the login manager service to init signons.sqlite  in browser profile				
//			byte[] buffer = Converter.wcsToMbcs (null, "@mozilla.org/security/pk11tokendb;1", true);//$NON-NLS-1$
//			rc = serviceManager.GetServiceByContractID (buffer, nsIPK11TokenDB.NS_IPK11TOKENDB_IID, result);//$NON-NLS-1$
//			nsIPK11TokenDB nsIPK11TokenDB = new nsIPK11TokenDB(result[0]);
//			rc = nsIPK11TokenDB.GetInternalKeyToken(result);
//			nsIPK11Token nsIPK11Token = new nsIPK11Token(result[0]);
//			buffer = Converter.wcsToMbcs (null, "@mozilla.org/login-manager;1", true);//$NON-NLS-1$
//			// xul 10.0, nsILoginManager.idl, uuid: 1f02142f-7e3f-4d02-b3e0-495c5f83ad7d
//			rc = serviceManager.GetServiceByContractID (buffer, nsILoginManager.NS_ILOGINMANAGER_IID, result);//$NON-NLS-1$
//			if (rc != XPCOM.NS_OK){
//				logger.logp(Level.WARNING, CLASS_NAME, "MozillaBrowser", //$NON-NLS-1$
//						"Error from MozillaBrowser.serviceManager.GetServiceByContractID()"); //$NON-NLS-1$
//			}
//			if (result[0] == 0) {
//				logger.logp(Level.WARNING, CLASS_NAME, "MozillaBrowser", //$NON-NLS-1$
//				"Error from MozillaBrowser.serviceManager.GetServiceByContractID(), XPCOM.NS_NOINTERFACE"); //$NON-NLS-1$
//			}
			///////////////////////////
			
			/////////////////////////
			//Always set browser to on-line mode
			rc = serviceManager.GetService (XPCOM.NS_IOSERVICE_CID, nsIIOService.NS_IIOSERVICE_IID, result);
			if (rc != XPCOM.NS_OK) error (rc);
			if (result[0] == 0) error (XPCOM.NS_NOINTERFACE);

			nsIIOService ioService = new nsIIOService (result[0]);
			rc = ioService.SetOffline(0);
			if (rc != XPCOM.NS_OK) error(rc);
			///////////////////////////
			
			result[0] = 0;
			byte[] buffer = XPCOM.NS_WINDOWWATCHER_CONTRACTID.getBytes();
			byte[] aContractID = new byte[buffer.length + 1];
			System.arraycopy(buffer, 0, aContractID, 0, buffer.length);
			rc = serviceManager.GetServiceByContractID(aContractID, nsIWindowWatcher.NS_IWINDOWWATCHER_IID, result);
			if (rc != XPCOM.NS_OK) error(rc);
			if (result[0] == 0) error(XPCOM.NS_NOINTERFACE);		
	
			nsIWindowWatcher windowWatcher = new nsIWindowWatcher(result[0]);
			result[0] = 0;
			rc = windowWatcher.SetWindowCreator(WindowCreator.getAddress());
			if (rc != XPCOM.NS_OK) error(rc);
			windowWatcher.Release();
	
			/* compute the profile directory and set it on the AppFileLocProvider */
			if (LocProvider != null) {
				buffer = Converter.wcsToMbcs (null, XPCOM.NS_DIRECTORYSERVICE_CONTRACTID, true);
				rc = serviceManager.GetServiceByContractID (buffer, nsIDirectoryService.NS_IDIRECTORYSERVICE_IID, result);
				if (rc != XPCOM.NS_OK) {
					dispose ();
					error (rc);
				}
				if (result[0] == 0) {
					dispose ();
					error (XPCOM.NS_NOINTERFACE);
				}

				/* notify observers of a new profile directory being used */
				buffer = Converter.wcsToMbcs (null, XPCOM.NS_OBSERVER_CONTRACTID, true);
				rc = serviceManager.GetServiceByContractID (buffer, nsIObserverService.NS_IOBSERVERSERVICE_IID, result);
				if (rc != XPCOM.NS_OK) {
					dispose ();
					error (rc);
				}
				if (result[0] == 0) {
					dispose ();
					error (XPCOM.NS_NOINTERFACE);
				}

				nsIObserverService observerService = new nsIObserverService (result[0]);
				result[0] = 0;
				buffer = Converter.wcsToMbcs (null, PROFILE_DO_CHANGE, true);
				int length = STARTUP.length ();
				char[] chars = new char [length + 1];
				STARTUP.getChars (0, length, chars, 0);
				rc = observerService.NotifyObservers (0, buffer, chars);
				if (rc != XPCOM.NS_OK) {
					dispose ();
					error (rc);
				}
				buffer = Converter.wcsToMbcs (null, PROFILE_AFTER_CHANGE, true);
				rc = observerService.NotifyObservers (0, buffer, chars);
				if (rc != XPCOM.NS_OK) {
					dispose ();
					error (rc);
				}
				observerService.Release ();
				backupNSMenu();
				
				int size = XPCOM.nsDynamicFunctionLoad_sizeof ();
				/* alloc memory for two structs, the second is empty to signify the end of the list */
				int /*long*/ ptr = C.malloc (size * 2);
				C.memset (ptr, 0, size * 2);
				nsDynamicFunctionLoad functionLoad = new nsDynamicFunctionLoad ();
				byte[] bytes = Converter.wcsToMbcs (null, "XRE_NotifyProfile", true); //$NON-NLS-1$
				functionLoad.functionName = C.malloc (bytes.length);
				C.memmove (functionLoad.functionName, bytes, bytes.length);
				functionLoad.function = C.malloc (C.PTR_SIZEOF);
				C.memmove (functionLoad.function, new int /*long*/[] {0} , C.PTR_SIZEOF);
				XPCOM.memmove (ptr, functionLoad, XPCOM.nsDynamicFunctionLoad_sizeof ());
				XPCOM.XPCOMGlueLoadXULFunctions (ptr);
				C.memmove (result, functionLoad.function, C.PTR_SIZEOF);
				int /*long*/ functionPtr = result[0];
				result[0] = 0;
				C.free (functionLoad.function);
				C.free (functionLoad.functionName);
				C.free (ptr);
				/* functionPtr == 0 for xulrunner < 1.9 */
				if (functionPtr != 0) {
					rc = XPCOM.Call (functionPtr);
	            	if (rc != XPCOM.NS_OK) {
	            		dispose ();
	            		error (rc);
	            	}
				}
		}
			restoreNSMenu();
			
			/*
			 * As a result of not using profiles, the user's locale and charset default
			 * to en_us and iso-8859-1, which are not the correct values for users in
			 * other locales.  The fix for this is to set mozilla's locale and charset
			 * preference values according to the user's current locale and charset.
			 */
			buffer = XPCOM.NS_PREFSERVICE_CONTRACTID.getBytes();
			aContractID = new byte[buffer.length + 1];
			System.arraycopy(buffer, 0, aContractID, 0, buffer.length);
			rc = serviceManager.GetServiceByContractID(aContractID, nsIPrefService.NS_IPREFSERVICE_IID, result);
			serviceManager.Release();
			if (rc != XPCOM.NS_OK) error(rc);
			if (result[0] == 0) error(XPCOM.NS_NOINTERFACE);
	
			nsIPrefService prefService = new nsIPrefService(result[0]);
			result[0] = 0;
			buffer = new byte[1];
			rc = prefService.GetBranch(buffer, result);	/* empty buffer denotes root preference level */
			prefService.Release();
			if (rc != XPCOM.NS_OK) error(rc);
			if (result[0] == 0) error(XPCOM.NS_NOINTERFACE);
	
			prefBranch = new nsIPrefBranch(result[0]);
			result[0] = 0;
			
			rc = setMozCharPref(prefBranch, PREF_EM_LAST_APP_VERSION, getXulrunnerVersion());  
			if (rc != XPCOM.NS_OK) error(rc);
				
			/* get Mozilla's current locale preference value */
			String prefLocales = null;
			nsIPrefLocalizedString localizedString=null;
			buffer = Converter.wcsToMbcs(null, PREFERENCE_LANGUAGES, true);
			rc = prefBranch.GetComplexValue(buffer, nsIPrefLocalizedString.NS_IPREFLOCALIZEDSTRING_IID, result);
			if (rc != XPCOM.NS_OK|| result[0]==0){
				/**
				 * MBJL7EE5TJ
				 */
				prefLocales="en-us,en" + TOKENIZER_LOCALE;	//$NON-NLS-1$
			}else{				
				localizedString = new nsIPrefLocalizedString(result[0]);
				result[0] = 0;
				rc = localizedString.ToString(result);
				if (rc != XPCOM.NS_OK) error(rc);
				if (result[0] == 0) error(XPCOM.NS_NOINTERFACE);
				prefLocales = WString.toNotNullString(result[0]) + TOKENIZER_LOCALE;
			}
			/*
			 * construct the new locale preference value by prepending the
			 * user's current locale and language to the original value 
			 */
			Locale locale = Locale.getDefault();
			String language = locale.getLanguage();
			//SPR ZPEG7HVAWA,When setting system locale to hebrew, the language we got from Locale.getDefault() is "iw", but "he" is needed by xulrunner
			if("iw".equals(language)){
				language = "he";
			}
			if("no".equals(language)){
				language = "nn";
			}
			String country = locale.getCountry();
			StringBuffer stringBuffer = new StringBuffer (language);
			if ((country!=null)&(country.trim().length()!=0)) {
				stringBuffer.append(SEPARATOR_LOCALE);
				stringBuffer.append(country.toLowerCase());
			}			
			stringBuffer.append(TOKENIZER_LOCALE);
			stringBuffer.append(language);
			stringBuffer.append(TOKENIZER_LOCALE);
			String newLocales = stringBuffer.toString();
			StringTokenizer tokenzier = new StringTokenizer(prefLocales, TOKENIZER_LOCALE);
			while (tokenzier.hasMoreTokens()) {
				String token = (tokenzier.nextToken() + TOKENIZER_LOCALE).trim();
				/* ensure that duplicate locale values are not added */
				if (newLocales.indexOf(token) == -1) {
					stringBuffer.append(token);
				}
			}
			newLocales = stringBuffer.toString();
			if (!newLocales.equals(prefLocales)) {
				/* write the new locale value */
				newLocales = newLocales.substring(0, newLocales.length() - TOKENIZER_LOCALE.length ()); /* remove trailing tokenizer */
				int length = newLocales.length();
				char[] charBuffer = new char[length + 1];
				newLocales.getChars(0, length, charBuffer, 0);
				if (localizedString == null) {
					byte[] contractID = Converter.wcsToMbcs (null, "@mozilla.org/pref-localizedstring;1", true);
					rc = componentManager.CreateInstanceByContractID (contractID, 0, nsIPrefLocalizedString.NS_IPREFLOCALIZEDSTRING_IID, result);
					if (rc != XPCOM.NS_OK) {					
						error (rc);
					}
					if (result[0] == 0) {
						error (XPCOM.NS_NOINTERFACE);
					}
					localizedString = new nsIPrefLocalizedString (result[0]);
					result[0] = 0;
				}
				localizedString.SetDataWithLength(length, charBuffer);
				rc = prefBranch.SetComplexValue(buffer, nsIPrefLocalizedString.NS_IPREFLOCALIZEDSTRING_IID, localizedString.getAddress());
				if (rc != XPCOM.NS_OK) error(rc);
			}
			if(localizedString!=null){
				localizedString.Release();
				localizedString=null;
			}
			
			/* set Mozilla's current locale preference value */
			buffer = Converter.wcsToMbcs(null, PREFERENCE_LOCALE, true);
			locale = Locale.getDefault();
			language = locale.getLanguage();
			//SPR ZPEG7HVAWA,When setting system locale to hebrew, the language we got from Locale.getDefault() is "iw", but "he" is needed by xulrunner
			if("iw".equals(language)){
				language = "he";
			}
			if("no".equals(language)){
				language = "nn";
			}
			country = locale.getCountry();
			if ((country!=null)&&(country.trim().length()!=0)) {
				newLocales = language + SEPARATOR_LOCALE + country;
			}
			else {
				newLocales = language;
			}
			byte[] value = Converter.wcsToMbcs(null, newLocales, true);
			rc = prefBranch.SetCharPref(buffer, value);
			if (rc != XPCOM.NS_OK) error(rc);
			
			rc = setMozCharPref(prefBranch, PREFERENCE_PROFILE_PATH, LocProvider.profilePath);
			if (rc != XPCOM.NS_OK) error(rc);
			
			///////////////////////////////////
			buffer = Converter.wcsToMbcs (null, XPCOM.NS_LOGINMANAGER_CONTRACTID, true);//$NON-NLS-1$
			// xul 10.0, nsILoginManager.idl, uuid: 1f02142f-7e3f-4d02-b3e0-495c5f83ad7d
			rc = serviceManager.GetServiceByContractID (buffer, nsILoginManager.NS_ILOGINMANAGER_IID, result);//$NON-NLS-1$
			if (rc != XPCOM.NS_OK){
			logger.logp(Level.WARNING, CLASS_NAME, "MozillaBrowser", //$NON-NLS-1$
				"Error from MozillaBrowser.serviceManager.GetServiceByContractID()"); //$NON-NLS-1$
			}
			if (result[0] == 0) {
			logger.logp(Level.WARNING, CLASS_NAME, "MozillaBrowser", //$NON-NLS-1$
			"Error from MozillaBrowser.serviceManager.GetServiceByContractID(), XPCOM.NS_NOINTERFACE"); //$NON-NLS-1$
			}
			///////////////////////////

			rc = setMozIntPref(prefBranch, PREF_ACCESSIBILITY_TABFOCUS, 7);  
			if (rc != XPCOM.NS_OK) error(rc);
			
			rc = setMozBoolPref(prefBranch, PREF_ACCESSIBILITY_TABFOCUS_FOR_XUL, PREFERENCE_TRUE);  
			if (rc != XPCOM.NS_OK) error(rc);

			/* Set retention value = 2: Mozilla's downloads will never be removed automatically. */
			rc = setMozIntPref(prefBranch, PREFERENCE_DOWNLOAD_MANANGER_RETENTION, PREFERENCE_DOWNLOAD_MANANGER_RETENTION_VALUE);  
			if (rc != XPCOM.NS_OK) error(rc);
			
			/* set Mozilla's current DOM SCRIPT RUNTIME preference value */
			rc = setMozIntPref(prefBranch, PREFERENCE_SCRIPTTIME, DOM_SCRIPTTIME);  
			if (rc != XPCOM.NS_OK) error(rc);
			
			rc = setMozBoolPref(prefBranch, PREF_LOGGING_ENABLED, PREFERENCE_TRUE);  
			if (rc != XPCOM.NS_OK) error(rc);
			
			rc = setMozBoolPref(prefBranch, PREFERENCE_DOM_ALLOW_XULXBL_FILE, PREFERENCE_TRUE);  
			if (rc != XPCOM.NS_OK) error(rc);
			
			rc = setMozBoolPref(prefBranch, PREFERENCE_DOM_USE_XULSCOPE_REMOTEXUL, PREFERENCE_TRUE);  
			if (rc != XPCOM.NS_OK) error(rc);
			
			rc = setMozBoolPref(prefBranch, PREF_NETWORK_PROTOCOL_HANDLER_WARN, PREFERENCE_FALSE);  
			if (rc != XPCOM.NS_OK) error(rc);
			
			if (isMacOSX) {
				rc = setMozBoolPref(prefBranch, PREF_GFX_DIRECT2D_DISABLED, PREFERENCE_TRUE);  
				if (rc != XPCOM.NS_OK) error(rc);
	
				rc = setMozBoolPref(prefBranch, PREF_GFX_DIRECT2D_FORCE_ENABLED, PREFERENCE_FALSE);  
				if (rc != XPCOM.NS_OK) error(rc);
				
				rc = setMozBoolPref(prefBranch, PREF_LAYERS_ACCELERATION_DISABLED, PREFERENCE_FALSE);  
				if (rc != XPCOM.NS_OK) error(rc);
				
				rc = setMozBoolPref(prefBranch, PREF_LAYERS_ACCELERATION_FORCE_ENABLED, PREFERENCE_TRUE);  
				if (rc != XPCOM.NS_OK) error(rc);
				
				rc = setMozIntPref(prefBranch, PREF_LAYERS_COMPOSITOR_LRU_SIZE, 100);  
				if (rc != XPCOM.NS_OK) error(rc);		
			} else {
				rc = setMozBoolPref(prefBranch, PREF_GFX_DIRECT2D_DISABLED, PREFERENCE_FALSE);  
				if (rc != XPCOM.NS_OK) error(rc);

				rc = setMozBoolPref(prefBranch, PREF_GFX_DIRECT2D_FORCE_ENABLED, PREFERENCE_TRUE);  
				if (rc != XPCOM.NS_OK) error(rc);
			}
			
			rc = setMozCharPref(prefBranch, PREFERENCE_BROWSER_NEVERASK_SAVETODISK, CHAR_ONE);  
			if (rc != XPCOM.NS_OK) error(rc);
			
			rc = setMozCharPref(prefBranch, PREFERENCE_BROWSER_NEVERASK_OPENFILE, CHAR_ONE);  
			if (rc != XPCOM.NS_OK) error(rc);
			
			rc = setMozCharPref(prefBranch, PREF_ACCEPTED_MIME_TYPES, PREF_ACCEPTED_MIME_TYPES_VAL);  
			if (rc != XPCOM.NS_OK) error(rc);
						
			/*Trust "Notes" protocol, no warning dialog */
			rc = setMozBoolPref(prefBranch, PREFERENCE_NOTES_PROTOCOL, PREFERENCE_FALSE);  
			if (rc != XPCOM.NS_OK) error(rc);
			
			/*Trust "MailTo" protocol, no warning dialog */
			rc = setMozBoolPref(prefBranch, PREFERENCE_MAILTO_PROTOCOL, PREFERENCE_FALSE);  
			if (rc != XPCOM.NS_OK) error(rc);
			
			/*Trust "cai" protocol, no warning dialog , added for SPR JCDL7TQAPW*/
			rc = setMozBoolPref(prefBranch, PREFERENCE_CAI_PROTOCOL, PREFERENCE_FALSE);  
			if (rc != XPCOM.NS_OK) error(rc);
			
			// SPR#MMMW8BQ4PV, lock preference for "dom.ipc.plugins.enabled.npjp2.dll" as true
			// SPR#JDMS8C5NLB
			String appletOOPPPref=PREFERENCE_OOPP_ENABLE_APPLET_WIN32;
			if("gtk".equalsIgnoreCase(SWT.getPlatform())){
				appletOOPPPref=PREFERENCE_OOPP_ENABLE_APPLET_LINUX;
			}
			byte[] buffer1 = Converter.wcsToMbcs(null, appletOOPPPref, true);
			rc = prefBranch.LockPref(buffer1);
			// if (rc != XPCOM.NS_OK) error(rc); // not check the result, 
			rc = 0; 
			
			/* Enable applet by default on Windows/Linux, and disable it when user set
			 * com.ibm.rcp.dombrowser/enableApplet preference to false in 
			 * plugin_customization.ini file. 
			 * 
			 * Applet is disabled on Mac.
			 * 
			 * */
			if(!isAppletEnabled()){
				rc = setMozBoolPref(prefBranch, PREFERENCE_SECURITY_ENABLE_JAVA, PREFERENCE_FALSE);  
				if (rc != XPCOM.NS_OK) error(rc);
			}else{
				rc = setMozBoolPref(prefBranch, PREFERENCE_SECURITY_ENABLE_JAVA, PREFERENCE_TRUE);  
				if (rc != XPCOM.NS_OK) error(rc);
			}
			
			/* Enable Xulrunner's Password Manager */
			rc = setMozBoolPref(prefBranch, PREFERENCE_REMEMBERSIGNONS, PREFERENCE_TRUE);  
			if (rc != XPCOM.NS_OK) error(rc);		
			
			rc = setMozBoolPref(prefBranch, PREFERENCE_EXPIREMASTERPASSWORD, PREFERENCE_FALSE);  
			if (rc != XPCOM.NS_OK) error(rc);

			rc = setMozBoolPref(prefBranch, PREFERENCE_PREFILLFORMS, PREFERENCE_TRUE);  
			if (rc != XPCOM.NS_OK) error(rc);
						
			rc = setMozCharPref(prefBranch, PREFERENCE_SIGNONFILENAME, "signons.txt");  //$NON-NLS-1$
			if (rc != XPCOM.NS_OK) error(rc);
									
			rc = setMozCharPref(prefBranch, PREFERENCE_SIGNONFILENAME2, "signons2.txt");  //$NON-NLS-1$
			if (rc != XPCOM.NS_OK) error(rc);
						
			/* get Mozilla's current charset preference value */
			String prefCharsets=null;
			buffer = Converter.wcsToMbcs(null, PREFERENCE_CHARSET, true);
			rc = prefBranch.GetComplexValue(buffer, nsIPrefLocalizedString.NS_IPREFLOCALIZEDSTRING_IID, result);			
			if (rc != XPCOM.NS_OK||result[0]==0){
				/**
				 * MBJL7EE5TJ
				 */
				prefCharsets = "ISO-8859-1";	//$NON_NLS-1$
			}else{

				localizedString = new nsIPrefLocalizedString(result[0]);
				result[0] = 0;
				rc = localizedString.ToString(result);
				if (rc != XPCOM.NS_OK) error(rc);
				if (result[0] == 0) error(XPCOM.NS_NOINTERFACE);
				prefCharsets = WString.toNotNullString(result[0]);
			}
			String newCharset = System.getProperty("file.encoding");	// $NON-NLS-1$
			if (!newCharset.equals(prefCharsets)) {
				/* write the new charset value */
				int length = newCharset.length();
				char[] charBuffer = new char[length + 1];
				newCharset.getChars(0, length, charBuffer, 0);
				if (localizedString == null) {
					byte[] contractID = Converter.wcsToMbcs (null, "@mozilla.org/pref-localizedstring;1", true);
					rc = componentManager.CreateInstanceByContractID (contractID, 0, nsIPrefLocalizedString.NS_IPREFLOCALIZEDSTRING_IID, result);
					if (rc != XPCOM.NS_OK) {					
						error (rc);
					}
					if (result[0] == 0) {
						error (XPCOM.NS_NOINTERFACE);
					}
					localizedString = new nsIPrefLocalizedString (result[0]);
					result[0] = 0;
				}
				localizedString.SetDataWithLength(length, charBuffer);
				rc = prefBranch.SetComplexValue(buffer, nsIPrefLocalizedString.NS_IPREFLOCALIZEDSTRING_IID, localizedString.getAddress());
				if (rc != XPCOM.NS_OK) error(rc);
			}
			if(localizedString!=null){
				localizedString.Release();
			}
			
			if(SWT.RIGHT_TO_LEFT == ((parent.getParent().getStyle() & SWT.RIGHT_TO_LEFT))){
				// set the 'layout.scrollbar.side' preference value to 1 to set the vertical scroll bar to left for RTL languages.
				rc = setMozIntPref(prefBranch, PREFERENCE_SCROLLBAR_SIDE, 1);  
	        } else {
	        	rc = setMozIntPref(prefBranch, PREFERENCE_SCROLLBAR_SIDE, 0);
	        }
			
			// SPR#SQLI9QX453, [POODLE]need to disable SSLv3 from XPD Embedded browser
			if(isMacOSX) {
				// On Mac, disable SSLV3 by default
				rc = setMozBoolPref(prefBranch, PREFERENCE_ENABLE_SSLV3, PREFERENCE_FALSE);
				if (rc != XPCOM.NS_OK) error(rc);
			}
			else {
				// On Windows and Linux, based on JVM property to decide whether to disable SSLV3 or not, disable by default
				String jvmDisableSSLV3 = System.getProperty("com.ibm.jsse2.disableSSLv3"); //$NON-NLS-1$
				if(jvmDisableSSLV3 != null && jvmDisableSSLV3.equalsIgnoreCase("false")) { //$NON-NLS-1$
					// only when jvm require to enable SSLV3, then enable 
					rc = setMozBoolPref(prefBranch, PREFERENCE_ENABLE_SSLV3, PREFERENCE_TRUE);
					if (rc != XPCOM.NS_OK) error(rc);
				}				
				else {
					// otherwise, disable SSLV3 by default
					rc = setMozBoolPref(prefBranch, PREFERENCE_ENABLE_SSLV3, PREFERENCE_FALSE);
					if (rc != XPCOM.NS_OK) error(rc);
				}
			}
			
			
			if(!isEnableRC4){
				rc = setMozBoolPref(prefBranch, PREFERENCE_ECDH_ECDSA_RC4_128_SHA, PREFERENCE_FALSE);
				if (rc != XPCOM.NS_OK) error(rc);
				
				rc = setMozBoolPref(prefBranch, PREFERENCE_ECDH_RSA_RC4_128_SHA, PREFERENCE_FALSE);
				if (rc != XPCOM.NS_OK) error(rc);
				
				rc = setMozBoolPref(prefBranch, PREFERENCE_ECDHE_ECDSA_RC4_128_SHA, PREFERENCE_FALSE);
				if (rc != XPCOM.NS_OK) error(rc);
				
				rc = setMozBoolPref(prefBranch, PREFERENCE_ECDHE_RSA_RC4_128_SHA, PREFERENCE_FALSE);
				if (rc != XPCOM.NS_OK) error(rc);
				
				rc = setMozBoolPref(prefBranch, PREFERENCE_RSA_RC4_128_MD5, PREFERENCE_FALSE);
				if (rc != XPCOM.NS_OK) error(rc);
				
				rc = setMozBoolPref(prefBranch, PREFERENCE_RSA_RC4_128_SHA, PREFERENCE_FALSE);
				if (rc != XPCOM.NS_OK) error(rc);
			}

			
			if(!isEnableDHE){
				rc = setMozBoolPref(prefBranch, PREFERENCE_DHE_DSS_AES_128_SHA, PREFERENCE_FALSE);
				if (rc != XPCOM.NS_OK) error(rc);
				
				rc = setMozBoolPref(prefBranch, PREFERENCE_DHE_DSS_AES_256_SHA, PREFERENCE_FALSE);
				if (rc != XPCOM.NS_OK) error(rc);
				
				rc = setMozBoolPref(prefBranch, PREFERENCE_DHE_DSS_CAMELLIA_128_SHA, PREFERENCE_FALSE);
				if (rc != XPCOM.NS_OK) error(rc);
				
				rc = setMozBoolPref(prefBranch, PREFERENCE_DHE_DSS_CAMELLIA_256_SHA, PREFERENCE_FALSE);
				if (rc != XPCOM.NS_OK) error(rc);
				
				rc = setMozBoolPref(prefBranch, PREFERENCE_DHE_RSA_AES_128_SHA, PREFERENCE_FALSE);
				if (rc != XPCOM.NS_OK) error(rc);
				
				rc = setMozBoolPref(prefBranch, PREFERENCE_DHE_RSA_AES_256_SHA, PREFERENCE_FALSE);
				if (rc != XPCOM.NS_OK) error(rc);
				
				rc = setMozBoolPref(prefBranch, PREFERENCE_DHE_RSA_CAMELLIA_128_SHA, PREFERENCE_FALSE);
				if (rc != XPCOM.NS_OK) error(rc);
				
				rc = setMozBoolPref(prefBranch, PREFERENCE_DHE_RSA_CAMELLIA_256_SHA, PREFERENCE_FALSE);
				if (rc != XPCOM.NS_OK) error(rc);
				
				rc = setMozBoolPref(prefBranch, PREFERENCE_DHE_RSA_DES_SHA, PREFERENCE_FALSE);
				if (rc != XPCOM.NS_OK) error(rc);
				
				rc = setMozBoolPref(prefBranch, PREFERENCE_DHE_DSS_DES_EDE3_SHA, PREFERENCE_FALSE);
				if (rc != XPCOM.NS_OK) error(rc);
			}
			
			
			if(!isEnableECDH){
				rc = setMozBoolPref(prefBranch, PREFERENCE_ECDH_ECDSA_AES_128_SHA, PREFERENCE_FALSE);
				if (rc != XPCOM.NS_OK) error(rc);
				
				rc = setMozBoolPref(prefBranch, PREFERENCE_ECDH_ECDSA_AES_256_SHA, PREFERENCE_FALSE);
				if (rc != XPCOM.NS_OK) error(rc);
				
				rc = setMozBoolPref(prefBranch, PREFERENCE_ECDH_ECDSA_DES_EDE3_SHA, PREFERENCE_FALSE);
				if (rc != XPCOM.NS_OK) error(rc);
				
				rc = setMozBoolPref(prefBranch, PREFERENCE_ECDH_RSA_AES_128_SHA, PREFERENCE_FALSE);
				if (rc != XPCOM.NS_OK) error(rc);
				
				rc = setMozBoolPref(prefBranch, PREFERENCE_ECDH_RSA_AES_256_SHA, PREFERENCE_FALSE);
				if (rc != XPCOM.NS_OK) error(rc);
				
				rc = setMozBoolPref(prefBranch, PREFERENCE_ECDH_RSA_DES_EDE3_SHA, PREFERENCE_FALSE);
				if (rc != XPCOM.NS_OK) error(rc);
				
			}
			
			
			/**
			 * End of pref changes
			 */
			
			rc = componentManager.QueryInterface(nsIComponentRegistrar.NS_ICOMPONENTREGISTRAR_IID, result);
			if (rc != XPCOM.NS_OK) error(rc);
			if (result[0] == 0) error(XPCOM.NS_NOINTERFACE);
			
			nsIComponentRegistrar componentRegistrar = new nsIComponentRegistrar(result[0]);
			result[0] = 0;
			
			//GRE version is >= 1.9, no Download factory is registered because this functionality is 
			//provided by the GRE. Remove following Download factory registration section
			// Since Xul 1.9 						
//			DownloadFactory downloadFactory = new DownloadFactory();
//			downloadFactory.AddRef();
//			
//			buffer = XPCOM.NS_TRANSFER_CONTRACTID.getBytes();
//			aContractID = new byte[buffer.length + 1];
//			System.arraycopy(buffer, 0, aContractID, 0, buffer.length);
//			buffer = "Download".getBytes(); //$NON-NLS-1$
//			byte[] aClassName = new byte[buffer.length + 1];
//			System.arraycopy(buffer, 0, aClassName, 0, buffer.length);
//			rc = componentRegistrar.RegisterFactory(XPCOM.NS_DOWNLOAD_CID, aClassName, aContractID, downloadFactory.getAddress());
//			if (rc != XPCOM.NS_OK) error(rc);
//			downloadFactory.Release();
			//end Since Xul 1.9
			
			FilePickerFactory pickerFactory = new FilePickerFactory();
			pickerFactory.AddRef();
	
			buffer = XPCOM.NS_FILEPICKER_CONTRACTID.getBytes();
			aContractID = new byte[buffer.length + 1];
			System.arraycopy(buffer, 0, aContractID, 0, buffer.length);
			buffer = "FilePicker".getBytes(); //$NON-NLS-1$
			byte[] aClassName = new byte[buffer.length + 1];
			System.arraycopy(buffer, 0, aClassName, 0, buffer.length);
			rc = componentRegistrar.RegisterFactory(XPCOM.NS_FILEPICKER_CID, aClassName, aContractID, pickerFactory.getAddress());
			if (rc != XPCOM.NS_OK) error(rc);
			pickerFactory.Release();

			//Initialize external factory	
			//First check if there's SWT external factory registered.
			rc = componentRegistrar.IsCIDRegistered(XPCOM.EXTERNAL_CID, result);
			if(result[0] == 1){
				// Get the registered the external factory address
				rc = componentManager.GetClassObject(XPCOM.EXTERNAL_CID, nsIFactory.NS_IFACTORY_IID, result);
				if(rc==XPCOM.NS_OK && result[0] != 0){
					//unregister the external factory
					rc = componentRegistrar.UnregisterFactory(XPCOM.EXTERNAL_CID, result[0]);
				}
			}
			// Register the EB's external factory
			ExternalFactory externalFactory = new ExternalFactory ();
			externalFactory.AddRef ();
			aContractID = Converter.wcsToMbcs (null, XPCOM.EXTERNAL_CONTRACTID, true); 
			aClassName = Converter.wcsToMbcs (null, "External", true); //$NON-NLS-1$
			rc = componentRegistrar.RegisterFactory (XPCOM.EXTERNAL_CID, aClassName, aContractID, externalFactory.getAddress ());
			if (rc != XPCOM.NS_OK) {
				dispose ();
				error (rc);
			}
			externalFactory.Release ();

			rc = serviceManager.GetService (XPCOM.NS_CATEGORYMANAGER_CID, nsICategoryManager.NS_ICATEGORYMANAGER_IID, result);
			if (rc != XPCOM.NS_OK) error (rc);
			if (result[0] == 0) error (XPCOM.NS_NOINTERFACE);

			nsICategoryManager categoryManager = new nsICategoryManager (result[0]);
			result[0] = 0;
			// xul 10.0, XPCOM changes in Gecko 2.0, Changed category names from "JavaScript global property" into "JavaScript-global-property"
			byte[] category = Converter.wcsToMbcs (null, "JavaScript-global-property", true); //$NON-NLS-1$
			byte[] entry = Converter.wcsToMbcs (null, "external", true); //$NON-NLS-1$
			// xul 10.0, mozilla\xpcom\components\nsCategoryManager.cpp:573, "Category manager doesn't support persistence"
			rc = categoryManager.AddCategoryEntry(category, entry, aContractID, 0, 1, result);
			result[0] = 0;
			categoryManager.Release ();			

			componentRegistrar.Release();
			componentManager.Release();
			System.setProperty(DONT_OVERRIDE_XULRUNNER_FACTORY, "true");
			
			try {
				NativeLoaderProxy.loadComponents();
			}
			catch (Exception e) {
				logger.logp(Level.WARNING, CLASS_NAME, "MozillaBrowser", //$NON-NLS-1$
						"Exception from MozillaBrowser", e); //$NON-NLS-1$
			}
			
			initialized = true;
		}
		/**
		 * PMR#33717,841,758 need to auto set when switch another monitor with different DPI.
		 */
		setDPI();
		if (display.getData (DISPOSE_LISTENER_HOOKED) == null) {
			display.setData (DISPOSE_LISTENER_HOOKED, DISPOSE_LISTENER_HOOKED);
			display.addListener (SWT.Dispose, DisplayListener);
		}
				

		BrowserCount++;
		
	
		
		result[0] = 0;
		int rc = XPCOM.NS_GetComponentManager(result);
		if (rc != XPCOM.NS_OK) error(rc);
		if (result[0] == 0) error(XPCOM.NS_NOINTERFACE);
		
		nsIComponentManager componentManager = new nsIComponentManager(result[0]);
		result[0] = 0;
		//nsID NS_IWEBBROWSER_CID = new nsID("F1EAC761-87E9-11d3-AF80-00A024FFC08C"); //$NON-NLS-1$
		// for xul45 use the correct webbrowser cid from embedding/browser/nsWebBrowser.h
		nsID NS_IWEBBROWSER_CID = new nsID("cda5863a-aa9c-411e-be49-ea0d525ab4b5"); //$NON-NLS-1$
		rc = componentManager.CreateInstance(NS_IWEBBROWSER_CID, 0, nsIWebBrowser.NS_IWEBBROWSER_IID, result);
		if (rc != XPCOM.NS_OK) error(rc);
		if (result[0] == 0) error(XPCOM.NS_NOINTERFACE);
		componentManager.Release();
	
		this.webBrowser = new nsIWebBrowser(result[0]);
		this.mozillaEmbeddingSite = createEmbeddingSite();
		this.mozillaEmbeddingSite.AddRef();
	
		rc = this.webBrowser.SetContainerWindow(this.mozillaEmbeddingSite.getWebBrowserChromeAddress());
		if (rc != XPCOM.NS_OK) error(rc);
				
		rc = this.webBrowser.QueryInterface(nsIBaseWindow.NS_IBASEWINDOW_IID, result);
		if (rc != XPCOM.NS_OK) error(rc);
		if (result[0] == 0) error(XPCOM.NS_ERROR_NO_INTERFACE);
		
		nsIBaseWindow baseWindow = new nsIBaseWindow(result[0]);	
		Rectangle rect = DPIUtil.autoScaleUp(getClientArea());
		if (rect.isEmpty()) {
			rect.width = 1;
			rect.height = 1;
		}
		
		createBrowserHandle();
	
		rc = baseWindow.InitWindow(getEmbedHandle(), 0, 0, 0, rect.width, rect.height);
		if (rc != XPCOM.NS_OK) error(XPCOM.NS_ERROR_FAILURE);
		backupNSMenu();
		rc = baseWindow.Create();
		restoreNSMenu();
		if (rc != XPCOM.NS_OK) error(XPCOM.NS_ERROR_FAILURE);
		Activate();
		rc = baseWindow.SetVisibility(1);
		if (rc != XPCOM.NS_OK) error(XPCOM.NS_ERROR_FAILURE);
		baseWindow.Release();
		/*
		* Bug in XULRunner 1.9.  On win32, Mozilla does not clear its background before content has
		* been set into it.  As a result, embedders appear broken if they do not immediately display
		* a URL or text.  The Mozilla bug for this is https://bugzilla.mozilla.org/show_bug.cgi?id=453523.
		* 
		* The workaround is to subclass the Mozilla window and clear it whenever WM_ERASEBKGND is received.
		* This subclass should be removed once content has been set into the browser.
		*/

		addWindowSubclass();
		
		rc = this.webBrowser.AddWebBrowserListener(this.mozillaEmbeddingSite.getWeakReferenceAddress(), nsIWebProgressListener.NS_IWEBPROGRESSLISTENER_IID);
		if (rc != XPCOM.NS_OK) error(rc);
	
		rc = this.webBrowser.SetParentURIContentListener(this.mozillaEmbeddingSite.getURIContentListenerAddress());
		if (rc != XPCOM.NS_OK) error(rc);
	
		initializeBrowser();
				
		listener = new Listener() {
			public void handleEvent(Event event) {
				switch (event.type) {
					case SWT.Dispose: {
						/* make this handler run after other dispose listeners */
						if (ignoreDispose) {
							ignoreDispose = false;
							break;
						}
						ignoreDispose = true;
						notifyListeners (event.type, event);
						event.type = SWT.NONE;
						onDispose(event.display);
						break;
					}
				case SWT.Resize:
					{
						onResize();
						break;
					}

					case SWT.Activate: Activate(); break;
					case SWT.FocusIn: Activate(); break;
					case SWT.Deactivate: {				
						Display display = event.display;
						if (MozillaBrowser.this == display.getFocusControl()) Deactivate();
						break;
					}
					case SWT.Show: {
						/*
						* Feature on GTK Mozilla.  Mozilla does not show up when
						* its container (a GTK fixed handle) is made visible
						* after having been hidden.  The workaround is to reset
						* its size after the container has been made visible. 
						*/
						Display display = event.display;
						display.asyncExec(new Runnable() {
							public void run() {
								if (MozillaBrowser.this.isDisposed()) return;
								onResize();
							}
						});
						
						
						break;
					}
					
				}
			}
		};	
		folderEvents = new int[]{
			SWT.Dispose,
			SWT.Resize,  
			SWT.FocusIn, 
			SWT.KeyDown,
			SWT.Activate,
			SWT.Deactivate,
			SWT.Show,
		};
		for (int i = 0; i < folderEvents.length; i++) {
			addListener(folderEvents[i], listener);
		}
		
		/*
		* In XULRunner versions > 4, sending WM_GETDLGCODE to a WM_KEYDOWN's MSG hwnd answers 0
		* instead of the expected DLGC_WANTALLKEYS.  This causes the default traversal framework
		* perform traversals outside of the Browser when it should not.  Hook a Traverse listener
		* to work around these problems.
		*/
		addListener (SWT.Traverse, new Listener () {
			@Override
			public void handleEvent (Event event) {
				switch (event.detail) {
					case SWT.TRAVERSE_RETURN: {
						/* always veto the traversal */
						event.doit = false;
						break;
					}
					case SWT.TRAVERSE_TAB_NEXT:
					case SWT.TRAVERSE_TAB_PREVIOUS: {
						/* veto the traversal whenever an element in the browser has focus */
						int /*long*/[] result = new int /*long*/[1];
						int rc = XPCOM.NS_GetServiceManager (result);
						if (rc != XPCOM.NS_OK) SWT.error (rc);
						if (result[0] == 0) SWT.error (XPCOM.NS_NOINTERFACE);
						nsIServiceManager serviceManager = new nsIServiceManager (result[0]);
						result[0] = 0;
						byte[] aContractID = Converter.wcsToMbcs (null, XPCOM.NS_FOCUSMANAGER_CONTRACTID, true);
						rc = serviceManager.GetServiceByContractID (aContractID, nsIFocusManager.NS_IFOCUSMANAGER_IID, result);
						serviceManager.Release ();

						if (rc == XPCOM.NS_OK && result[0] != 0) {
							nsIFocusManager focusManager = new nsIFocusManager (result[0]);
							result[0] = 0;
							rc = focusManager.GetFocusedElement (result);
							focusManager.Release ();
							event.doit = result[0] == 0;
							if (rc == XPCOM.NS_OK && result[0] != 0) {
								new nsISupports (result[0]).Release ();
							}
						}
						break;
					}
				}
			}
		});
		
		System.setProperty(XULRUNNER_INITIALIZED, "true");
		
		this.getShell().addShellListener(shellAdapter);
		
    	
	}
	
	/**
	 * PMR#73435,L6Q,000 to fix the dpi problem
	 */
	private void setDPI() {
		if(!enableDPIAutoConfig) {
			if(logger.isLoggable(Level.FINEST))
				logger.logp(Level.FINEST, CLASS_NAME, "setDPI", "enableDPIAutoConfig:false. dpi not set");  //$NON-NLS-1$
			return;
		}
		
		Point point = Display.getCurrent().getDPI();
		//if no DPI change, then just return.
		if(point.x == DPIx) {
			if(logger.isLoggable(Level.FINEST))
				logger.logp(Level.FINEST, CLASS_NAME, "setDPI", "DPI point.x:" + point.x + " unchanged. return.");
			return;
		}
		try{
			//on mac, default DPI is 0.75, which is too small(need to scale to 4/3)
			String sysDPI = new BigDecimal(isMacOSX ? point.x * 4 / (double)(96 * 3) : point.x/(double)96).setScale(2, BigDecimal.ROUND_HALF_UP).toPlainString();
			setMozCharPref(prefBranch, PREFERENCE_DEVPIXELSPERPX, sysDPI);
			DPIx = point.x; 
			if(logger.isLoggable(Level.FINEST)){
				logger.logp(Level.FINEST, CLASS_NAME, "setDPI", new StringBuilder("sysDPI:").append(sysDPI).append(" ,point.x:").append(point.x).toString());  //$NON-NLS-1$  //$NON-NLS-2$
			}
		} catch(Exception e) {
			logger.logp(Level.WARNING, CLASS_NAME, "MozillaBrowser", //$NON-NLS-1$
					"Exception when set sysDPI to layout.css.devPixelsPerPx", e); //$NON-NLS-1$
		}
	}
	
	private int setMozIntPref(nsIPrefBranch prefBranch, String Preference, int value) {
		byte[] buffer = Converter.wcsToMbcs(null, Preference, true);
		int rc = prefBranch.SetIntPref(buffer, value);
		return rc;
	}
	
	private int setMozBoolPref(nsIPrefBranch prefBranch, String Preference, int value) {
		byte[] buffer = Converter.wcsToMbcs(null, Preference, true);
		int rc = prefBranch.SetBoolPref(buffer, value);
		return rc;
	}
	
	private int setMozCharPref(nsIPrefBranch prefBranch, String Preference, String value) {
		byte[] buffer = Converter.wcsToMbcs(null, Preference, true);
		byte[] valueByte = Converter.wcsToMbcs(null, value, true);		//$NON-NLS-1$
		int rc = prefBranch.SetCharPref(buffer, valueByte);		
		return rc;
	}
	
//	private void initAppShell( nsIComponentManager componentManager) {
//		int rc;
//		int[] result = new int[1];
//		rc = componentManager.CreateInstance(XPCOM.NS_APPSHELL_CID, 0, nsIAppShell.NS_IAPPSHELL_IID, result);
//	
//		if (rc == XPCOM.NS_OK){ 
//			AppShell = new nsIAppShell(result[0]);
//			rc = AppShell.Create(0, null);
//			if (rc != XPCOM.NS_OK) error(rc);
//			rc = AppShell.Spinup();
//			if (rc != XPCOM.NS_OK) error(rc);
//		}
//	}
	
	
	protected MozillaEmbeddingSite createEmbeddingSite() {
    	return new MozillaEmbeddingSite(this);
    }
	
	public static void clearSessions () {
		return;
		
//		int /*long*/[] result = new int /*long*/[1];
//		int rc = XPCOM.NS_GetServiceManager (result);
//		if (rc != XPCOM.NS_OK) error (rc);
//		if (result [0] == 0) error (XPCOM.NS_NOINTERFACE);
//		nsIServiceManager serviceManager = new nsIServiceManager (result [0]);
//		result [0] = 0;
//		byte[] buffer = XPCOM.NS_COOKIEMANAGER_CONTRACTID.getBytes ();
//		byte[] aContractID = new byte [buffer.length + 1];
//		System.arraycopy (buffer, 0, aContractID, 0, buffer.length);
//		rc = serviceManager.GetServiceByContractID (aContractID, nsICookieManager.NS_ICOOKIEMANAGER_IID, result);
//		if (rc != XPCOM.NS_OK) error (rc);
//		if (result [0] == 0) error (XPCOM.NS_NOINTERFACE);
//		serviceManager.Release ();
//	
//		nsICookieManager manager = new nsICookieManager (result [0]);
//		result [0] = 0;
//		rc = manager.GetEnumerator (result);
//		if (rc != XPCOM.NS_OK) error (rc);
//		manager.Release ();
//	
//		nsISimpleEnumerator enumerator = new nsISimpleEnumerator (result [0]);
//		int[] moreElements = new int [1];
//		rc = enumerator.HasMoreElements (moreElements);
//		if (rc != XPCOM.NS_OK) error (rc);
//		while (moreElements [0] == 1) {
//			result [0] = 0;
//			rc = enumerator.GetNext (result);
//			if (rc != XPCOM.NS_OK) error (rc);
//			//nsICookie cookie = new nsICookie (result [0]);
//			nsICookie2 cookie = new nsICookie2 (result [0]);
//			long[] expires = new long [1];
//			rc = cookie.GetExpires (expires);
//			if (expires [0] == 0) {
//				/* indicates a session cookie */
//				nsEmbedCString domain = new nsEmbedCString();
//				nsEmbedCString name = new nsEmbedCString();
//				nsEmbedCString path = new nsEmbedCString();
//				cookie.GetHost (domain.getAddress());
//				cookie.GetName (name.getAddress());
//				cookie.GetPath (path.getAddress());
//				rc = manager.Remove(domain.getAddress(), name.getAddress(), path.getAddress(), 0);
//				domain.dispose();
//				name.dispose();
//				path.dispose();
//				if (rc != XPCOM.NS_OK) error (rc);
//			}
//			cookie.Release ();
//			rc = enumerator.HasMoreElements (moreElements);
//			if (rc != XPCOM.NS_OK) error (rc);
//		}
//		enumerator.Release ();
	}
			
	/**	 
	 * Adds the listener to receive events.
	 * <p>
	 *
	 * @param listener the listener
	 *
	 * @exception IllegalArgumentException <ul>
	 *    <li>ERROR_NULL_ARGUMENT - if the listener is null</li>
	 * </ul>
	 * 
	 * @exception SWTException <ul>
	 *    <li>ERROR_THREAD_INVALID_ACCESS when called from the wrong thread</li>
	 *    <li>ERROR_WIDGET_DISPOSED when the widget has been disposed</li>
	 * </ul>
	 *
	 * @since 3.0
	 */
	public void addCloseWindowListener(CloseWindowListener listener) {
		checkWidget();
		if (listener == null) SWT.error(SWT.ERROR_NULL_ARGUMENT);	
		CloseWindowListener[] newCloseWindowListeners = new CloseWindowListener[closeWindowListeners.length + 1];
		System.arraycopy(closeWindowListeners, 0, newCloseWindowListeners, 0, closeWindowListeners.length);
		closeWindowListeners = newCloseWindowListeners;
		closeWindowListeners[closeWindowListeners.length - 1] = listener;
	}
	
	public void addAuthenticationListener (AuthenticationListener listener) {
		AuthenticationListener[] newAuthenticationListeners = new AuthenticationListener[authenticationListeners.length + 1];
		System.arraycopy(authenticationListeners, 0, newAuthenticationListeners, 0, authenticationListeners.length);
		authenticationListeners = newAuthenticationListeners;
		authenticationListeners[authenticationListeners.length - 1] = listener;
	}

	public void addCertificateErrorListener(CertificateErrorListener listener) {
		CertificateErrorListener[] newCertificateErrorListeners = new CertificateErrorListener[certificateErrorListeners.length + 1];
		System.arraycopy(certificateErrorListeners, 0, newCertificateErrorListeners, 0, certificateErrorListeners.length);
		certificateErrorListeners = newCertificateErrorListeners;
		certificateErrorListeners[certificateErrorListeners.length - 1] = listener;
	}
	
	public void addAlertListener(AlertListener listener) {
		AlertListener[] newAlertListeners = new AlertListener[alertListeners.length + 1];
		System.arraycopy(alertListeners, 0, newAlertListeners, 0, alertListeners.length);
		alertListeners = newAlertListeners;
		newAlertListeners[newAlertListeners.length - 1] = listener;
	}
	
	public void addConfirmListener(ConfirmListener listener) {
		ConfirmListener[] newListeners = new ConfirmListener[confirmListeners.length + 1];
		System.arraycopy(confirmListeners, 0, newListeners, 0, confirmListeners.length);
		confirmListeners = newListeners;
		newListeners[newListeners.length - 1] = listener;
	}
	
	public void addPromptListener(PromptListener listener) {
		if (listener == null) SWT.error(SWT.ERROR_NULL_ARGUMENT);
		PromptListener[] newPromptListeners = new PromptListener[promptListeners.length + 1];
		System.arraycopy(promptListeners, 0, newPromptListeners, 0, promptListeners.length);
		promptListeners = newPromptListeners;
		newPromptListeners[newPromptListeners.length - 1] = listener;
	}
	
	/**	 
	 * Adds the listener to receive events.
	 * <p>
	 *
	 * @param listener the listener
	 *
	 * @exception IllegalArgumentException <ul>
	 *    <li>ERROR_NULL_ARGUMENT - if the listener is null</li>
	 * </ul>
	 * 
	 * @exception SWTException <ul>
	 *    <li>ERROR_THREAD_INVALID_ACCESS when called from the wrong thread</li>
	 *    <li>ERROR_WIDGET_DISPOSED when the widget has been disposed</li>
	 * </ul>
	 *
	 * @since 3.0
	 */
	public void addLocationListener(LocationListener listener) {
		checkWidget();
		if (listener == null) SWT.error (SWT.ERROR_NULL_ARGUMENT);
		LocationListener[] newLocationListeners = new LocationListener[locationListeners.length + 1];
		System.arraycopy(locationListeners, 0, newLocationListeners, 0, locationListeners.length);
		locationListeners = newLocationListeners;
		locationListeners[locationListeners.length - 1] = listener;
	}
	
	/**	 
	 * Adds the listener to receive events.
	 * <p>
	 *
	 * @param listener the listener
	 *
	 * @exception IllegalArgumentException <ul>
	 *    <li>ERROR_NULL_ARGUMENT - if the listener is null</li>
	 * </ul>
	 * 
	 * @exception SWTException <ul>
	 *    <li>ERROR_THREAD_INVALID_ACCESS when called from the wrong thread</li>
	 *    <li>ERROR_WIDGET_DISPOSED when the widget has been disposed</li>
	 * </ul>
	 *
	 * @since 3.0
	 */
	public void addOpenWindowListener(OpenWindowListener listener) {
		checkWidget();
		if (listener == null) SWT.error(SWT.ERROR_NULL_ARGUMENT);
		OpenWindowListener[] newOpenWindowListeners = new OpenWindowListener[openWindowListeners.length + 1];
		System.arraycopy(openWindowListeners, 0, newOpenWindowListeners, 0, openWindowListeners.length);
		openWindowListeners = newOpenWindowListeners;
		openWindowListeners[openWindowListeners.length - 1] = listener;
	}
	
	/**	 
	 * Adds the listener to receive events.
	 * <p>
	 *
	 * @param listener the listener
	 *
	 * @exception IllegalArgumentException <ul>
	 *    <li>ERROR_NULL_ARGUMENT - if the listener is null</li>
	 * </ul>
	 * 
	 * @exception SWTException <ul>
	 *    <li>ERROR_THREAD_INVALID_ACCESS when called from the wrong thread</li>
	 *    <li>ERROR_WIDGET_DISPOSED when the widget has been disposed</li>
	 * </ul>
	 *
	 * @since 3.0
	 */
	public void addProgressListener(ProgressListener listener) {
		checkWidget();
		if (listener == null) SWT.error (SWT.ERROR_NULL_ARGUMENT);
		ProgressListener[] newProgressListeners = new ProgressListener[progressListeners.length + 1];
		System.arraycopy(progressListeners, 0, newProgressListeners, 0, progressListeners.length);
		progressListeners = newProgressListeners;
		progressListeners[progressListeners.length - 1] = listener;
	}
	
	/**	 
	 * Adds the listener to receive events.
	 * <p>
	 *
	 * @param listener the listener
	 *
	 * @exception IllegalArgumentException <ul>
	 *    <li>ERROR_NULL_ARGUMENT - if the listener is null</li>
	 * </ul>
	 * 
	 * @exception SWTException <ul>
	 *    <li>ERROR_THREAD_INVALID_ACCESS when called from the wrong thread</li>
	 *    <li>ERROR_WIDGET_DISPOSED when the widget has been disposed</li>
	 * </ul>
	 *
	 * @since 3.0
	 */
	public void addStatusTextListener(StatusTextListener listener) {
		checkWidget();
		if (listener == null) SWT.error (SWT.ERROR_NULL_ARGUMENT);
		StatusTextListener[] newStatusTextListeners = new StatusTextListener[statusTextListeners.length + 1];
		System.arraycopy(statusTextListeners, 0, newStatusTextListeners, 0, statusTextListeners.length);
		statusTextListeners = newStatusTextListeners;
		statusTextListeners[statusTextListeners.length - 1] = listener;
	}
	
	/**	 
	 * Adds the listener to receive events.
	 * <p>
	 *
	 * @param listener the listener
	 *
	 * @exception IllegalArgumentException <ul>
	 *    <li>ERROR_NULL_ARGUMENT - if the listener is null</li>
	 * </ul>
	 * 
	 * @exception SWTException <ul>
	 *    <li>ERROR_THREAD_INVALID_ACCESS when called from the wrong thread</li>
	 *    <li>ERROR_WIDGET_DISPOSED when the widget has been disposed</li>
	 * </ul>
	 *
	 * @since 3.0
	 */
	public void addTitleListener(TitleListener listener) {
		checkWidget();
		if (listener == null) SWT.error(SWT.ERROR_NULL_ARGUMENT);
		TitleListener[] newTitleListeners = new TitleListener[titleListeners.length + 1];
		System.arraycopy(titleListeners, 0, newTitleListeners, 0, titleListeners.length);
		titleListeners = newTitleListeners;
		titleListeners[titleListeners.length - 1] = listener;
	}
	
	/**	 
	 * Adds the listener to receive events.
	 * <p>
	 *
	 * @param listener the listener
	 *
	 * @exception IllegalArgumentException <ul>
	 *    <li>ERROR_NULL_ARGUMENT - if the listener is null</li>
	 * </ul>
	 * 
	 * @exception SWTException <ul>
	 *    <li>ERROR_THREAD_INVALID_ACCESS when called from the wrong thread</li>
	 *    <li>ERROR_WIDGET_DISPOSED when the widget has been disposed</li>
	 * </ul>
	 *
	 * @since 3.0
	 */
	public void addVisibilityWindowListener(VisibilityWindowListener listener) {
		checkWidget();
		if (listener == null) SWT.error(SWT.ERROR_NULL_ARGUMENT);
		VisibilityWindowListener[] newVisibilityWindowListeners = new VisibilityWindowListener[visibilityWindowListeners.length + 1];
		System.arraycopy(visibilityWindowListeners, 0, newVisibilityWindowListeners, 0, visibilityWindowListeners.length);
		visibilityWindowListeners = newVisibilityWindowListeners;
		visibilityWindowListeners[visibilityWindowListeners.length - 1] = listener;
	}
	
	
	
	protected boolean viewPageSource(String url){
		checkWidget();	
		// create a shell to carry the new browser to its final location
		Shell shell = new Shell(this.getShell());
		DOMBrowser browser = new DOMBrowser(shell, SWT.NONE);
		FillLayout layout = new FillLayout();
		shell.setLayout(layout);
		browser.setUrl("view-source:"+url);
		shell.open();
		return true;
		
	}


	/**
	 * Navigate to the previous session history item.
	 *
	 * @return <code>true</code> if the operation was successful and <code>false</code> otherwise
	 *
	 * @exception SWTException <ul>
	 *    <li>ERROR_THREAD_INVALID_ACCESS when called from the wrong thread</li>
	 *    <li>ERROR_WIDGET_DISPOSED when the widget has been disposed</li>
	 * </ul>
	 *
	 * @see #forward
	 * 
	 * @since 3.0
	 */
	public boolean back() {
		checkWidget();
		htmlBytes = null;
		int /*long*/[] result = new int /*long*/[1];
		int rc = webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
		if (rc != XPCOM.NS_OK) error(rc);
		if (result[0] == 0) error(XPCOM.NS_ERROR_NO_INTERFACE);
		
		nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);		 	
		rc = webNavigation.GoBack();	
		webNavigation.Release();
		
		return rc == XPCOM.NS_OK;
	}
	
	public boolean onBeforeUnload() {
		checkWidget();
		final boolean[] result = new boolean[] { false };
		LocationListener[] oldListeners = locationListeners;
		locationListeners = new LocationListener[] { new LocationListener() {

			public void changed(LocationEvent event) {
			}

			public void changing(LocationEvent event) {
				result[0] = true;
			}

			@Override
			public void changing(com.ibm.rcp.dombrowser.browser.LocationEvent event) { }

			@Override
			public void changed(com.ibm.rcp.dombrowser.browser.LocationEvent event) {
				result[0] = true;
			}

		} };
		//execute("window.location.replace('about:blank');"); //$NON-NLS-1$
		//For SPR#GGAR8F9L2B, we take setUrl("about:blank") instead.
		setUrl("about:blank");
		locationListeners = oldListeners;

		return result[0] ? true:false;
	}
	
	static String getMozillaPath () {
		if (LocProvider != null) return LocProvider.mozillaPath;
		return null;
	}

	public boolean execute(String script) {
		checkWidget();
		if (script == null) SWT.error(SWT.ERROR_NULL_ARGUMENT);
		/*
		* As of mozilla 1.9 executing javascript via the javascript: protocol no
		* longer happens synchronously.  As a result, the result of executing JS
		* is not returned to the java side when expected by the client.  The
		* workaround is to invoke the javascript handler directly via C++, which is
		* exposed as of mozilla 1.9.
		*/
		int /*long*/[] result = new int /*long*/[1];
		
		//
		nsIWebBrowser webBrowser = getWebBrowser();		
		if(null == webBrowser){
			return false;
		}
		
		int rc = webBrowser.QueryInterface(nsIInterfaceRequestor.NS_IINTERFACEREQUESTOR_IID, result);
		if (rc != XPCOM.NS_OK) error (rc);
		if (result[0] == 0) error (XPCOM.NS_NOINTERFACE);
		nsIInterfaceRequestor interfaceRequestor = new nsIInterfaceRequestor (result[0]);
		result[0] = 0;
		rc = XPCOM.NS_GetServiceManager (result);
		if (rc != XPCOM.NS_OK) error (rc);
		if (result[0] == 0) error (XPCOM.NS_NOINTERFACE);

		nsIServiceManager serviceManager = new nsIServiceManager (result[0]);
		result[0] = 0;
		rc = interfaceRequestor.GetInterface (nsIDOMWindow.NS_IDOMWINDOW_IID, result);
		if (rc != XPCOM.NS_OK) error (rc);
		if (result[0] == 0) error (XPCOM.NS_NOINTERFACE);
		interfaceRequestor.Release ();

		nsIDOMWindow window = new nsIDOMWindow (result[0]);
		result[0] = 0;
		byte[] aContractID = Converter.wcsToMbcs (null, XPCOM.EXECUTE_CONTRACTID, true);
		rc = serviceManager.GetServiceByContractID (aContractID, Execute.NS_IEXECUTE_IID_STR, result);
		if (rc != XPCOM.NS_OK) error (rc);
		if (result[0] == 0) error (XPCOM.NS_NOINTERFACE);

		Execute execute = new Execute (result[0]);
		result[0] = 0;
		nsEmbedString data = new nsEmbedString (script);
		rc = execute.EvalInWindow (window, data, result);
		if (result[0] != 0)
			new nsIVariant (result[0]).Release ();
		data.dispose ();
		execute.Release ();
		window.Release();
		serviceManager.Release();
		
		return rc == XPCOM.NS_OK;
		//
			
//		int rc = XPCOM.NS_GetServiceManager (result);
//		if (rc != XPCOM.NS_OK) error (rc);
//		if (result[0] == 0) error (XPCOM.NS_NOINTERFACE);
//
//		nsIServiceManager serviceManager = new nsIServiceManager (result[0]);
//		result[0] = 0;
//		nsIPrincipal principal = null;
//		byte[] aContractID = Converter.wcsToMbcs (null, XPCOM.NS_SCRIPTSECURITYMANAGER_CONTRACTID, true);
//		rc = serviceManager.GetServiceByContractID (aContractID, nsIScriptSecurityManager.NS_ISCRIPTSECURITYMANAGER_IID, result);
//		if (rc == XPCOM.NS_OK && result[0] != 0) {
//			nsIScriptSecurityManager securityManager = new nsIScriptSecurityManager (result[0]);
//			result[0] = 0;
//			rc = securityManager.GetSystemPrincipal (result);
//			if (rc != XPCOM.NS_OK) error (rc);
//			if (result[0] == 0) error (XPCOM.NS_ERROR_NULL_POINTER);
//			principal = new nsIPrincipal (result[0]);
//			result[0] = 0;
//			securityManager.Release ();
//		} 
//
//		if (principal != null) {
//			rc = webBrowser.QueryInterface (nsIInterfaceRequestor.NS_IINTERFACEREQUESTOR_IID, result);
//			if (rc != XPCOM.NS_OK) error (rc);
//			if (result[0] == 0) error (XPCOM.NS_ERROR_NO_INTERFACE);
//
//			nsIInterfaceRequestor interfaceRequestor = new nsIInterfaceRequestor (result[0]);
//			result[0] = 0;
//			//nsID scriptGlobalObjectNSID = new nsID ("08f73284-26e3-4fa6-bf89-8326f92a94b3"); /* nsIScriptGlobalObject */ //$NON-NLS-1$
//			nsID scriptGlobalObjectNSID = new nsID ("876f83bd-6314-460a-a045-1c8f462fb8e1"); /* nsIScriptGlobalObject */ //$NON-NLS-1$
//			rc = interfaceRequestor.GetInterface (scriptGlobalObjectNSID, result);
//			interfaceRequestor.Release ();
//
//			if (rc == XPCOM.NS_OK && result[0] != 0) {
//				int /*long*/ scriptGlobalObject = result[0];
//				result[0] = 0;
//				rc = XPCOM.nsIScriptGlobalObject_EnsureScriptEnvironment (scriptGlobalObject, 2); /* nsIProgrammingLanguage.JAVASCRIPT */
//				if (rc != XPCOM.NS_OK) error (rc);
//				int /*long*/ scriptContext = XPCOM.nsIScriptGlobalObject_GetScriptContext (scriptGlobalObject, 2); /* nsIProgrammingLanguage.JAVASCRIPT */
//				//int /*long*/ globalJSObject = XPCOM.nsIScriptGlobalObject_GetScriptGlobal (scriptGlobalObject, 2); /* nsIProgrammingLanguage.JAVASCRIPT */
//				new nsISupports (scriptGlobalObject).Release ();
//
//				if (scriptContext != 0 /*&& globalJSObject != 0*/) {
//					/* ensure that the received nsIScriptContext implements the expected interface */
//					//nsID scriptContextNSID = new nsID ("2e583bf4-3c1f-432d-8283-8dee7eccc88b"); /* nsIScriptContext */ //$NON-NLS-1$
//					nsID scriptContextNSID = new nsID ("901f0d5e-217a-45fa-9aca-450fe72f109a"); /* nsIScriptContext */ //$NON-NLS-1$	
//					rc = new nsISupports (scriptContext).QueryInterface (scriptContextNSID, result);
//					if (rc == XPCOM.NS_OK && result[0] != 0) {
//						new nsISupports (result[0]).Release ();
//						result[0] = 0;
//
//						int /*long*/ nativeContext = XPCOM.nsIScriptContext_GetNativeContext (scriptContext);
//						if (nativeContext != 0) {
//							int length = script.length ();
//							char[] scriptChars = new char[length];
//							script.getChars(0, length, scriptChars, 0);
//							byte[] urlbytes = Converter.wcsToMbcs (null, getUrl (), true);
//							rc = principal.GetJSPrincipals (nativeContext, result);
//							if (rc == XPCOM.NS_OK && result[0] != 0) {
//								int /*long*/ principals = result[0];
//								result[0] = 0;
//								principal.Release ();									
//								String mozillaPath = grePath.getAbsolutePath() + SEPARATOR_OS + NativeLoaderProxy.getJSLibraryName () + '\0';
//								byte[] pathBytes = null;
//								try {
//									pathBytes = mozillaPath.getBytes ("UTF-8"); //$NON-NLS-1$
//								} catch (UnsupportedEncodingException e) {
//									logger.logp(Level.WARNING, CLASS_NAME, "execute", //$NON-NLS-1$
//											"UnsupportedEncodingException from MozillaBrowser", e); //$NON-NLS-1$
//									pathBytes = mozillaPath.getBytes ();
//								}
////								rc = XPCOM.JS_EvaluateUCScriptForPrincipals (pathBytes, nativeContext, globalJSObject, principals, scriptChars, length, urlbytes, 0, result);
////								return rc != 0;
//								int globalJSObject = XPCOM.JS_GetGlobalObject (pathBytes, nativeContext);
//								aContractID = Converter.wcsToMbcs (null, XPCOM.NS_CONTEXTSTACK_CONTRACTID, true);
//								rc = serviceManager.GetServiceByContractID (aContractID, nsIJSContextStack.NS_IJSCONTEXTSTACK_IID, result);
//								if (rc != XPCOM.NS_OK) error (rc);
//								if (result[0] == 0) error (XPCOM.NS_NOINTERFACE);
//								serviceManager.Release ();
//
//								nsIJSContextStack stack = new nsIJSContextStack (result[0]);
//								result[0] = 0;
//								rc = stack.Push (nativeContext);
//								if (rc != XPCOM.NS_OK) error (rc);
//								//SPR#FPAI9NCLY6,FPAI9NCLHA, related Eclipse bug#392229
//								boolean success = XPCOM.JS_EvaluateUCScriptForPrincipals (pathBytes, nativeContext, globalJSObject, principals, scriptChars, length, urlbytes, 0, null) != 0;
//								result[0] = 0;
//								rc = stack.Pop (result);
//								if (rc != XPCOM.NS_OK) error (rc);
//								stack.Release ();
//
//								new nsISupports (scriptGlobalObject).Release ();
//								principal.Release ();
//								return success;								
//								}
//							}
//						}
//					}
//				}
//				principal.Release ();
//			}
//		serviceManager.Release ();
//		return false;
		
		/* fall back to the pre-1.9 approach */

//		String url = PREFIX_JAVASCRIPT + script + ";void(0);";	//$NON-NLS-1$
//		int rc = webBrowser.QueryInterface (nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
//		if (rc != XPCOM.NS_OK) error (rc);
//		if (result[0] == 0) error (XPCOM.NS_ERROR_NO_INTERFACE);
//		
//		nsIWebNavigation webNavigation = new nsIWebNavigation (result[0]);
//		char[] arg = url.toCharArray ();
//		char[] c = new char[arg.length+1];
//		System.arraycopy (arg, 0, c, 0, arg.length);
//		rc = webNavigation.LoadURI (c, nsIWebNavigation.LOAD_FLAGS_NONE, 0, 0, 0);
//		webNavigation.Release ();
//		return rc == XPCOM.NS_OK;
	}
		
	/**
	 * Navigate to the next session history item.
	 *
	 * @return <code>true</code> if the operation was successful and <code>false</code> otherwise
	 *
	 * @exception SWTException <ul>
	 *    <li>ERROR_THREAD_INVALID_ACCESS when called from the wrong thread</li>
	 *    <li>ERROR_WIDGET_DISPOSED when the widget has been disposed</li>
	 * </ul>
	 * 
	 * @see #back
	 * 
	 * @since 3.0
	 */
	public boolean forward() {
		checkWidget();
		htmlBytes = null;
		int /*long*/[] result = new int /*long*/[1];
		int rc = webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
		if (rc != XPCOM.NS_OK) error(rc);
		if (result[0] == 0) error(XPCOM.NS_ERROR_NO_INTERFACE);
		
		nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
		rc = webNavigation.GoForward();
		webNavigation.Release();
	
		return rc == XPCOM.NS_OK;
	}
	
	/**
	 * Returns the current URL.
	 *
	 * @return the current URL or an empty <code>String</code> if there is no current URL
	 *
	 * @exception SWTException <ul>
	 *    <li>ERROR_THREAD_INVALID_ACCESS when called from the wrong thread</li>
	 *    <li>ERROR_WIDGET_DISPOSED when the widget has been disposed</li>
	 * </ul>
	 *
	 * @see #setUrl
	 * 
	 * @since 3.0
	 */
	public String getUrl() {
		checkWidget();
		int /*long*/[] result = new int /*long*/[1];
		int rc = webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
		if (rc != XPCOM.NS_OK) error(rc);
		if (result[0] == 0) error(XPCOM.NS_ERROR_NO_INTERFACE);
		
		nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
		int /*long*/[] aCurrentURI = new int /*long*/[1];
		rc = webNavigation.GetCurrentURI(aCurrentURI);
		if (rc != XPCOM.NS_OK) error(rc);
		/*
		 * This code is intentionally commented.  aCurrentURI is 0
		 * when no location has previously been set.
		 */
		//if (aCurrentURI[0] == 0) error(XPCOM.NS_ERROR_NO_INTERFACE);
		webNavigation.Release();
		
		String location = null;
		if (aCurrentURI[0] != 0) {
			nsIURI uri = new nsIURI(aCurrentURI[0]);
			nsEmbedCString aSpec = new nsEmbedCString();
			rc = uri.GetSpec(aSpec.getAddress());
			uri.Release();
			if (rc != XPCOM.NS_OK) error(rc);
			location = aSpec.toString("UTF-8");
			aSpec.dispose();
		}
		if (location == null) return ""; //$NON-NLS-1$
		/*
		 * If the URI indicates that the current page is being rendered from
		 * memory (ie.- via setText()) then answer about:blank as the URL
		 * to be consistent with win32.
		 */
		if (location.equals (URI_FROMMEMORY)) location = ABOUT_BLANK;
		return location;
	}
	
	
	
	/**
	 * Returns <code>true</code> if the receiver can navigate to the 
	 * previous session history item, and <code>false</code> otherwise.
	 *
	 * @return the receiver's back command enabled state
	 *
	 * @exception SWTException <ul>
	 *    <li>ERROR_WIDGET_DISPOSED - if the receiver has been disposed</li>
	 *    <li>ERROR_THREAD_INVALID_ACCESS - if not called from the thread that created the receiver</li>
	 * </ul>
	 * 
	 * @see #back
	 */
	public boolean isBackEnabled() {
		checkWidget();
		int /*long*/[] result = new int /*long*/[1];
		int rc = webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
		if (rc != XPCOM.NS_OK) error(rc);
		if (result[0] == 0) error(XPCOM.NS_ERROR_NO_INTERFACE);
		
		nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
		int[] aCanGoBack = new int[1];
		rc = webNavigation.GetCanGoBack(aCanGoBack);	
		webNavigation.Release();
		
		return aCanGoBack[0] != 0;
	}
	
	/**
	 * Returns <code>true</code> if the receiver can navigate to the 
	 * next session history item, and <code>false</code> otherwise.
	 *
	 * @return the receiver's forward command enabled state
	 *
	 * @exception SWTException <ul>
	 *    <li>ERROR_WIDGET_DISPOSED - if the receiver has been disposed</li>
	 *    <li>ERROR_THREAD_INVALID_ACCESS - if not called from the thread that created the receiver</li>
	 * </ul>
	 * 
	 * @see #forward
	 */
	public boolean isForwardEnabled() {
		checkWidget();
		int /*long*/[] result = new int /*long*/[1];
		int rc = webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
		if (rc != XPCOM.NS_OK) error(rc);
		if (result[0] == 0) error(XPCOM.NS_ERROR_NO_INTERFACE);
		
		nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
		int[] aCanGoForward = new int[1];
		rc = webNavigation.GetCanGoForward(aCanGoForward);
		webNavigation.Release();
	
		return aCanGoForward[0] != 0;
	}
	
	protected void onDispose(Display display) {
		super.onDispose(display);		
		
		int rc = XPCOM.NS_OK;
		if (this.mozillaEmbeddingSite != null) {
			this.mozillaEmbeddingSite.unhookDOMListeners();
			this.mozillaEmbeddingSite.onDispose();
			if (this.webBrowser != null) {
				rc = this.webBrowser.RemoveWebBrowserListener(this.mozillaEmbeddingSite.getWeakReferenceAddress(), nsIWebProgressListener.NS_IWEBPROGRESSLISTENER_IID);
				if (rc != XPCOM.NS_OK) error(rc);
			}
			this.mozillaEmbeddingSite.Release();
			this.mozillaEmbeddingSite = null;
		}
		
		if (listener != null && folderEvents != null) {
			for (int i = 0; i < folderEvents.length; i++) {
				removeListener (folderEvents[i], listener);
			}
			removeListener (SWT.Traverse, listener);
			listener = null;
			folderEvents = null;
		}
		
		if (this.webBrowser != null) {	
			rc = this.webBrowser.SetParentURIContentListener(0);
			if (rc != XPCOM.NS_OK) error(rc);
			rc = webBrowser.SetContainerWindow (0);
			if (rc != XPCOM.NS_OK) error (rc);
					
			int /*long*/[] result = new int /*long*/[1];
			rc = this.webBrowser.QueryInterface(nsIBaseWindow.NS_IBASEWINDOW_IID, result);
			if (rc != XPCOM.NS_OK) error(rc);
			if (result[0] == 0) error(XPCOM.NS_ERROR_NO_INTERFACE);
			

			nsIBaseWindow baseWindow = new nsIBaseWindow(result[0]); 
			rc = baseWindow.Destroy();
			if (rc != XPCOM.NS_OK) error(rc);
			baseWindow.Release();
		
			Enumeration elements = functions.elements ();
			while (elements.hasMoreElements ()) {
				BrowserFunction function = ((BrowserFunction)elements.nextElement ());
				AllFunctions.remove (new Integer (function.index));
				function.dispose (false);
			}
			functions = null;
						
			this.webBrowser.Release();
			this.webBrowser = null;
			
			if(this.getShell() != null ){
				this.getShell().removeShellListener(shellAdapter);
			}

			shellAdapter = null;
			
		}
		
		if (tip != null && !tip.isDisposed()) tip.dispose();
		tip = null;
		
		BrowserCount--;
		htmlBytes = null;
		
		/*
		* This code is intentionally commented.  It is not possible to reinitialize
		* Mozilla once it has been terminated.  NS_InitEmbedding always fails after
		* NS_TermEmbedding has been called.  The workaround is to call NS_InitEmbedding
		* once and never call NS_TermEmbedding.
		*/
	//	if (BrowserCount == 0) {
	//		if (AppShell != null) {
	//			// Shutdown the appshell service.
	//			rc = AppShell.Spindown();
	//			if (rc != XPCOM.NS_OK) error(rc);
	//			AppShell.Release();
	//			AppShell = null;
	//		}
	//		WindowCreator.Release();
	//		WindowCreator = null;
	//		PromptService.Release();
	//		PromptService = null;
	//		XPCOM.NS_TermEmbedding();
	//		mozilla = false;
	//	}
	}
	
	
	protected void Activate() {
		active = true;
		int /*long*/[] result = new int /*long*/[1];
		int rc = webBrowser.QueryInterface(nsIWebBrowserFocus.NS_IWEBBROWSERFOCUS_IID, result);
		if (rc != XPCOM.NS_OK) error(rc);
		if (result[0] == 0) error(XPCOM.NS_ERROR_NO_INTERFACE);
		
		nsIWebBrowserFocus webBrowserFocus = new nsIWebBrowserFocus(result[0]);
		rc = webBrowserFocus.Activate();
		if (rc != XPCOM.NS_OK) error(rc);
		webBrowserFocus.Release();
	}		
		
	protected void Deactivate() {
		active = false;
		int /*long*/[] result = new int /*long*/[1];
		int rc = webBrowser.QueryInterface(nsIWebBrowserFocus.NS_IWEBBROWSERFOCUS_IID, result);
		if (rc != XPCOM.NS_OK) error(rc);
		if (result[0] == 0) error(XPCOM.NS_ERROR_NO_INTERFACE);
		
		nsIWebBrowserFocus webBrowserFocus = new nsIWebBrowserFocus(result[0]);
		rc = webBrowserFocus.Deactivate();
		if (rc != XPCOM.NS_OK) error(rc);
		webBrowserFocus.Release();
	}
	
	protected void SetFocusAtFirstElement() {
		int /*long*/[] result = new int /*long*/[1];
		int rc = webBrowser.QueryInterface(nsIWebBrowserFocus.NS_IWEBBROWSERFOCUS_IID, result);
		if (rc != XPCOM.NS_OK) error(rc);
		if (result[0] == 0) error(XPCOM.NS_ERROR_NO_INTERFACE);
		
		nsIWebBrowserFocus webBrowserFocus = new nsIWebBrowserFocus(result[0]);
		rc = webBrowserFocus.SetFocusAtFirstElement();
		if (rc != XPCOM.NS_OK) error(rc);
		webBrowserFocus.Release();
	}
	
	protected void onResize() {
		int /*long*/[] result = new int /*long*/[1];
		int rc = webBrowser.QueryInterface(nsIBaseWindow.NS_IBASEWINDOW_IID, result);
		if (rc != XPCOM.NS_OK) error(rc);
		if (result[0] == 0) error(XPCOM.NS_ERROR_NO_INTERFACE);
	
		super.onResize(); 
		/*
		* SPR-RSSNBGQH57 fix to sync Device Zoom value with DPIUtil's deviceZoom value
		* as DPIUtil's deviceZoom was failing to get correct value in case of
		* multiple monitor setup
		*/
		Rectangle topShellrect = getShell().getBounds();
		getDeviceZoom(topShellrect.x);
		Rectangle rect = DPIUtil.autoScaleUp(getClientArea());
		nsIBaseWindow baseWindow = new nsIBaseWindow(result[0]);
		rc = baseWindow.SetPositionAndSize(rect.x, rect.y, rect.width, rect.height, 1);
		
		if (rc != XPCOM.NS_OK) error(rc);
		baseWindow.Release();
	}
	
	/**
	 * Refresh the current page.
	 *
	 * @exception SWTException <ul>
	 *    <li>ERROR_THREAD_INVALID_ACCESS when called from the wrong thread</li>
	 *    <li>ERROR_WIDGET_DISPOSED when the widget has been disposed</li>
	 * </ul>
	 *
	 * @since 3.0
	 */
	public void refresh() {
		checkWidget();
		htmlBytes = null;
		int /*long*/[] result = new int /*long*/[1];
		int rc = webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
		if (rc != XPCOM.NS_OK) error(rc);
		if (result[0] == 0) error(XPCOM.NS_ERROR_NO_INTERFACE);
		
		nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);	
		try {
			rc = webNavigation.Reload(nsIWebNavigation.LOAD_FLAGS_NONE);
			/*
			* Feature in Mozilla.  Reload returns an error code NS_ERROR_INVALID_POINTER
			* when it is called immediately after a request to load a new document using
			* LoadURI.  The workaround is to ignore this error code.
			* 
			* Feature in Mozilla.  Attempting to reload a file that no longer exists
			* returns an error code of NS_ERROR_FILE_NOT_FOUND.  This is equivalent to
			* attempting to load a non-existent local url, which is not a Browser error,
			* so this error code should be ignored. 
			*/
			if (rc != XPCOM.NS_OK && rc != XPCOM.NS_ERROR_INVALID_POINTER && rc != XPCOM.NS_ERROR_FILE_NOT_FOUND && rc != XPCOM.NS_BINDING_ABORTED) {
				int /*long*/[] aCurrentURI = new int /*long*/[1];
				rc = webNavigation.GetCurrentURI(aCurrentURI);
				if (rc != XPCOM.NS_OK) error(rc);
				String location = null;
				if (aCurrentURI[0] != 0) {
					nsIURI uri = new nsIURI(aCurrentURI[0]);
					nsEmbedCString aSpec = new nsEmbedCString();
					rc = uri.GetSpec(aSpec.getAddress());
					uri.Release();
					if (rc != XPCOM.NS_OK) error(rc);
					location = aSpec.toString();
					aSpec.dispose();
				}
				/*
				 * If the URI indicates that the current page is being rendered from
				 * memory (ie.- via setText()) then just return
				 */
				if (!URI_FROMMEMORY.equals(location))
					error(rc);
			}
		}
		finally {
			webNavigation.Release();
		}
	}
	
	/**	 
	 * Removes the listener.
	 *
	 * @param listener the listener
	 *
	 * @exception IllegalArgumentException <ul>
	 *    <li>ERROR_NULL_ARGUMENT - if the listener is null</li>
	 * </ul>
	 * 
	 * @exception SWTException <ul>
	 *    <li>ERROR_THREAD_INVALID_ACCESS when called from the wrong thread</li>
	 *    <li>ERROR_WIDGET_DISPOSED when the widget has been disposed</li>
	 * </ul>
	 * 
	 * @since 3.0
	 */
	public void removeCloseWindowListener(CloseWindowListener listener) {
		checkWidget();
		if (listener == null) SWT.error(SWT.ERROR_NULL_ARGUMENT);
		if (closeWindowListeners.length == 0) return;
		int index = -1;
		for (int i = 0; i < closeWindowListeners.length; i++) {
			if (listener == closeWindowListeners[i]){
				index = i;
				break;
			}
		}
		if (index == -1) return;
		if (closeWindowListeners.length == 1) {
			closeWindowListeners = new CloseWindowListener[0];
			return;
		}
		CloseWindowListener[] newCloseWindowListeners = new CloseWindowListener[closeWindowListeners.length - 1];
		System.arraycopy(closeWindowListeners, 0, newCloseWindowListeners, 0, index);
		System.arraycopy(closeWindowListeners, index + 1, newCloseWindowListeners, index, closeWindowListeners.length - index - 1);
		closeWindowListeners = newCloseWindowListeners;
	}
	

	public void removeAuthenticationListener (AuthenticationListener listener) {
		if (authenticationListeners.length == 0) return;
		int index = -1;
		for (int i = 0; i < authenticationListeners.length; i++) {
			if (listener == authenticationListeners[i]) {
				index = i;
				break;
			}
		}
		if (index == -1) return;
		if (authenticationListeners.length == 1) {
			authenticationListeners = new AuthenticationListener[0];
			return;
		}
		AuthenticationListener[] newAuthenticationListeners = new AuthenticationListener[authenticationListeners.length - 1];
		System.arraycopy (authenticationListeners, 0, newAuthenticationListeners, 0, index);
		System.arraycopy (authenticationListeners, index + 1, newAuthenticationListeners, index, authenticationListeners.length - index - 1);
		authenticationListeners = newAuthenticationListeners;
	}

	public void removeCertificateErrorListener(CertificateErrorListener listener) {
		if(certificateErrorListeners.length == 0) return;
		int index = -1;
		for(int i = 0; i < certificateErrorListeners.length; i++) {
			if(listener == certificateErrorListeners[i]) {
				index = i;
				break;
			}
		}
		if(index == -1) return;
		if(certificateErrorListeners.length == 1) {
			certificateErrorListeners = new CertificateErrorListener[0];
			return;
		}
		
		CertificateErrorListener[] newCertificateErrorListeners = new CertificateErrorListener[certificateErrorListeners.length - 1];
		System.arraycopy(certificateErrorListeners, 0, newCertificateErrorListeners, 0, index);
		System.arraycopy(certificateErrorListeners, index + 1, newCertificateErrorListeners, index, certificateErrorListeners.length - index -1);
		certificateErrorListeners = newCertificateErrorListeners;
	}
	
	public void removeAlertListener(AlertListener listener) {
		if(alertListeners.length == 0) return;
		int index = -1;
		for(int i = 0; i < alertListeners.length; i++) {
			if(listener == alertListeners[i]) {
				index = i;
				break;
			}
		}
		if(index == -1) return;
		if(alertListeners.length == 1) {
			alertListeners = new AlertListener[0];
			return;
		}
		
		AlertListener[] newAlertListeners = new AlertListener[alertListeners.length - 1];
		System.arraycopy(alertListeners, 0, newAlertListeners, 0, index);
		System.arraycopy(alertListeners, index + 1, newAlertListeners, index, alertListeners.length - index -1);
		alertListeners = newAlertListeners;
	}
	
	public void removeConfirmListener(ConfirmListener listener) {
		if(confirmListeners.length == 0) return;
		int index = -1;
		for(int i = 0; i < confirmListeners.length; i++) {
			if(listener == confirmListeners[i]) {
				index = i;
				break;
			}
		}
		if(index == -1) {
			return;
		}
		if(confirmListeners.length == 1) {
			confirmListeners = new ConfirmListener[0];
			return;
		}
		
		ConfirmListener[] newListeners = new ConfirmListener[confirmListeners.length - 1];
		System.arraycopy(confirmListeners, 0, newListeners, 0, index);
		System.arraycopy(confirmListeners, index + 1, newListeners, index, confirmListeners.length - index -1);
		confirmListeners = newListeners;		
	}
	
	public void removePromptListener(PromptListener listener) {
		if (listener == null) SWT.error(SWT.ERROR_NULL_ARGUMENT);
		if(promptListeners.length == 0) return;
		int index = -1;
		for(int i = 0; i < promptListeners.length; i++) {
			if(listener == promptListeners[i]) {
				index = i;
				break;
			}
		}
		if(index == -1) return;
		if(promptListeners.length == 1) {
			promptListeners = new PromptListener[0];
			return;
		}
		
		PromptListener[] newPromptListeners = new PromptListener[promptListeners.length - 1];
		System.arraycopy(promptListeners, 0, newPromptListeners, 0, index);
		System.arraycopy(promptListeners, index + 1, newPromptListeners, index, promptListeners.length - index -1);
		promptListeners = newPromptListeners;
	}
	
	/**	 
	 * Removes the listener.
	 *
	 * @param listener the listener
	 *
	 * @exception IllegalArgumentException <ul>
	 *    <li>ERROR_NULL_ARGUMENT - if the listener is null</li>
	 * </ul>
	 * 
	 * @exception SWTException <ul>
	 *    <li>ERROR_THREAD_INVALID_ACCESS when called from the wrong thread</li>
	 *    <li>ERROR_WIDGET_DISPOSED when the widget has been disposed</li>
	 * </ul>
	 * 
	 * @since 3.0
	 */
	public void removeLocationListener(LocationListener listener) {
		checkWidget();
		if (listener == null) SWT.error(SWT.ERROR_NULL_ARGUMENT);
		if (locationListeners.length == 0) return;
		int index = -1;
		for (int i = 0; i < locationListeners.length; i++) {
			if (listener == locationListeners[i]){
				index = i;
				break;
			}
		}
		if (index == -1) return;
		if (locationListeners.length == 1) {
			locationListeners = new LocationListener[0];
			return;
		}
		LocationListener[] newLocationListeners = new LocationListener[locationListeners.length - 1];
		System.arraycopy(locationListeners, 0, newLocationListeners, 0, index);
		System.arraycopy(locationListeners, index + 1, newLocationListeners, index, locationListeners.length - index - 1);
		locationListeners = newLocationListeners;
	}
	
	/**	 
	 * Removes the listener.
	 *
	 * @param listener the listener
	 *
	 * @exception IllegalArgumentException <ul>
	 *    <li>ERROR_NULL_ARGUMENT - if the listener is null</li>
	 * </ul>
	 * 
	 * @exception SWTException <ul>
	 *    <li>ERROR_THREAD_INVALID_ACCESS when called from the wrong thread</li>
	 *    <li>ERROR_WIDGET_DISPOSED when the widget has been disposed</li>
	 * </ul>
	 * 
	 * @since 3.0
	 */
	public void removeOpenWindowListener(OpenWindowListener listener) {
		checkWidget();
		if (listener == null) SWT.error(SWT.ERROR_NULL_ARGUMENT);
		if (openWindowListeners.length == 0) return;
		int index = -1;
		for (int i = 0; i < openWindowListeners.length; i++) {
			if (listener == openWindowListeners[i]){
				index = i;
				break;
			}
		}
		if (index == -1) return;
		if (openWindowListeners.length == 1) {
			openWindowListeners = new OpenWindowListener[0];
			return;
		}
		OpenWindowListener[] newOpenWindowListeners = new OpenWindowListener[openWindowListeners.length - 1];
		System.arraycopy(openWindowListeners, 0, newOpenWindowListeners, 0, index);
		System.arraycopy(openWindowListeners, index + 1, newOpenWindowListeners, index, openWindowListeners.length - index - 1);
		openWindowListeners = newOpenWindowListeners;
	}
	
	/**	 
	 * Removes the listener.
	 *
	 * @param listener the listener
	 *
	 * @exception IllegalArgumentException <ul>
	 *    <li>ERROR_NULL_ARGUMENT - if the listener is null</li>
	 * </ul>
	 * 
	 * @exception SWTException <ul>
	 *    <li>ERROR_THREAD_INVALID_ACCESS when called from the wrong thread</li>
	 *    <li>ERROR_WIDGET_DISPOSED when the widget has been disposed</li>
	 * </ul>
	 * 
	 * @since 3.0
	 */
	public void removeProgressListener(ProgressListener listener) {
		checkWidget();
		if (listener == null) SWT.error(SWT.ERROR_NULL_ARGUMENT);
		if (progressListeners.length == 0) return;
		int index = -1;
		for (int i = 0; i < progressListeners.length; i++) {
			if (listener == progressListeners[i]){
				index = i;
				break;
			}
		}
		if (index == -1) return;
		if (progressListeners.length == 1) {
			progressListeners = new ProgressListener[0];
			return;
		}
		ProgressListener[] newProgressListeners = new ProgressListener[progressListeners.length - 1];
		System.arraycopy(progressListeners, 0, newProgressListeners, 0, index);
		System.arraycopy(progressListeners, index + 1, newProgressListeners, index, progressListeners.length - index - 1);
		progressListeners = newProgressListeners;
	}
	
	/**	 
	 * Removes the listener.
	 *
	 * @param listener the listener
	 *
	 * @exception IllegalArgumentException <ul>
	 *    <li>ERROR_NULL_ARGUMENT - if the listener is null</li>
	 * </ul>
	 * 
	 * @exception SWTException <ul>
	 *    <li>ERROR_THREAD_INVALID_ACCESS when called from the wrong thread</li>
	 *    <li>ERROR_WIDGET_DISPOSED when the widget has been disposed</li>
	 * </ul>
	 * 
	 * @since 3.0
	 */
	public void removeStatusTextListener(StatusTextListener listener) {
		checkWidget();
		if (listener == null) SWT.error(SWT.ERROR_NULL_ARGUMENT);
		if (statusTextListeners.length == 0) return;
		int index = -1;
		for (int i = 0; i < statusTextListeners.length; i++) {
			if (listener == statusTextListeners[i]){
				index = i;
				break;
			}
		}
		if (index == -1) return;
		if (statusTextListeners.length == 1) {
			statusTextListeners = new StatusTextListener[0];
			return;
		}
		StatusTextListener[] newStatusTextListeners = new StatusTextListener[statusTextListeners.length - 1];
		System.arraycopy(statusTextListeners, 0, newStatusTextListeners, 0, index);
		System.arraycopy(statusTextListeners, index + 1, newStatusTextListeners, index, statusTextListeners.length - index - 1);
		statusTextListeners = newStatusTextListeners;
	}
	
	/**	 
	 * Removes the listener.
	 *
	 * @param listener the listener
	 *
	 * @exception IllegalArgumentException <ul>
	 *    <li>ERROR_NULL_ARGUMENT - if the listener is null</li>
	 * </ul>
	 * 
	 * @exception SWTException <ul>
	 *    <li>ERROR_THREAD_INVALID_ACCESS when called from the wrong thread</li>
	 *    <li>ERROR_WIDGET_DISPOSED when the widget has been disposed</li>
	 * </ul>
	 * 
	 * @since 3.0
	 */
	public void removeTitleListener(TitleListener listener) {
		checkWidget();
		if (listener == null) SWT.error(SWT.ERROR_NULL_ARGUMENT);
		if (titleListeners.length == 0) return;
		int index = -1;
		for (int i = 0; i < titleListeners.length; i++) {
			if (listener == titleListeners[i]){
				index = i;
				break;
			}
		}
		if (index == -1) return;
		if (titleListeners.length == 1) {
			titleListeners = new TitleListener[0];
			return;
		}
		TitleListener[] newTitleListeners = new TitleListener[titleListeners.length - 1];
		System.arraycopy(titleListeners, 0, newTitleListeners, 0, index);
		System.arraycopy(titleListeners, index + 1, newTitleListeners, index, titleListeners.length - index - 1);
		titleListeners = newTitleListeners;
	}
	
	/**	 
	 * Removes the listener.
	 *
	 * @param listener the listener
	 *
	 * @exception IllegalArgumentException <ul>
	 *    <li>ERROR_NULL_ARGUMENT - if the listener is null</li>
	 * </ul>
	 * 
	 * @exception SWTException <ul>
	 *    <li>ERROR_THREAD_INVALID_ACCESS when called from the wrong thread</li>
	 *    <li>ERROR_WIDGET_DISPOSED when the widget has been disposed</li>
	 * </ul>
	 * 
	 * @since 3.0
	 */
	public void removeVisibilityWindowListener(VisibilityWindowListener listener) {
		checkWidget();
		if (listener == null) SWT.error(SWT.ERROR_NULL_ARGUMENT);
		if (visibilityWindowListeners.length == 0) return;
		int index = -1;
		for (int i = 0; i < visibilityWindowListeners.length; i++) {
			if (listener == visibilityWindowListeners[i]){
				index = i;
				break;
			}
		}
		if (index == -1) return;
		if (visibilityWindowListeners.length == 1) {
			visibilityWindowListeners = new VisibilityWindowListener[0];
			return;
		}
		VisibilityWindowListener[] newVisibilityWindowListeners = new VisibilityWindowListener[visibilityWindowListeners.length - 1];
		System.arraycopy(visibilityWindowListeners, 0, newVisibilityWindowListeners, 0, index);
		System.arraycopy(visibilityWindowListeners, index + 1, newVisibilityWindowListeners, index, visibilityWindowListeners.length - index - 1);
		visibilityWindowListeners = newVisibilityWindowListeners;
	}
	
	
	/**
	 * Renders HTML.
	 * 
	 * @param html the HTML content to be rendered
	 *
	 * @return true if the operation was successful and false otherwise.
	 *
	 * @exception IllegalArgumentException <ul>
	 *    <li>ERROR_NULL_ARGUMENT - if the html is null</li>
	 * </ul>
	 * 
	 * @exception SWTException <ul>
	 *    <li>ERROR_THREAD_INVALID_ACCESS when called from the wrong thread</li>
	 *    <li>ERROR_WIDGET_DISPOSED when the widget has been disposed</li>
	 * </ul>
	 *  
	 * @see #setUrl
	 * 
	 * @since 3.0
	 */
	public boolean setText(String html) {
		if(html==null){
			return false;
		}

				
		/**
		 * It is rebased from swt3.4m6
		 */
	
		if (this != getDisplay ().getFocusControl ()) Deactivate ();

		/* convert the String containing HTML to an array of bytes with UTF-8 data */
		byte[] data = null;
		try {
			data = html.getBytes ("UTF-8"); //$NON-NLS-1$
		} catch (UnsupportedEncodingException e) {
			logger.logp(Level.WARNING, CLASS_NAME, "setText", //$NON-NLS-1$
					"UnsupportedEncodingException from MozillaBrowser", e); //$NON-NLS-1$
			return false;
		}
		int /*long*/[] result = new int /*long*/[1];
		int rc = webBrowser.QueryInterface (nsIWebBrowserStream.NS_IWEBBROWSERSTREAM_IID, result);
		if (rc == XPCOM.NS_OK && result[0] != 0) {
			/*
			* Setting mozilla's content through nsIWebBrowserStream does not cause a page
			* load to occur, so the events that usually accompany a page change are not
			* fired.  To make this behave as expected, navigate to about:blank first and
			* then set the html content once the page has loaded.
			*/
			new nsISupports (result[0]).Release ();
			result[0] = 0;

			/*
			* If htmlBytes is not null then the about:blank page is already being loaded,
			* so no Navigate is required.  Just set the html that is to be shown.
			*/
			boolean blankLoading = htmlBytes != null;
			htmlBytes = data;
			//untrustedText = !trusted;@@@
			if (blankLoading) return true;

			/* navigate to about:blank */
			rc = webBrowser.QueryInterface (nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
			if (rc != XPCOM.NS_OK) error (rc);
			if (result[0] == 0) error (XPCOM.NS_ERROR_NO_INTERFACE);
			nsIWebNavigation webNavigation = new nsIWebNavigation (result[0]);
			result[0] = 0;
			char[] uri = new char[ABOUT_BLANK.length () + 1];
			ABOUT_BLANK.getChars (0, ABOUT_BLANK.length (), uri, 0);
			rc = webNavigation.LoadURI (uri, nsIWebNavigation.LOAD_FLAGS_NONE, 0, 0, 0);
			if (rc != XPCOM.NS_OK) error (rc);
			webNavigation.Release ();
		} else {
		
			byte[] contentTypeBuffer = Converter.wcsToMbcs (null, "text/html", true); // $NON-NLS-1$
			int /*long*/ aContentType = XPCOM.nsEmbedCString_new (contentTypeBuffer, contentTypeBuffer.length);
			byte[] contentCharsetBuffer = Converter.wcsToMbcs (null, "UTF-8", true);	//$NON-NLS-1$
			int /*long*/ aContentCharset = XPCOM.nsEmbedCString_new (contentCharsetBuffer, contentCharsetBuffer.length);

			rc = XPCOM.NS_GetServiceManager (result);
			if (rc != XPCOM.NS_OK) error (rc);
			if (result[0] == 0) error (XPCOM.NS_NOINTERFACE);
	
			nsIServiceManager serviceManager = new nsIServiceManager (result[0]);
			result[0] = 0;
			rc = serviceManager.GetService (XPCOM.NS_IOSERVICE_CID, nsIIOService.NS_IIOSERVICE_IID, result);
			if (rc != XPCOM.NS_OK) error (rc);
			if (result[0] == 0) error (XPCOM.NS_NOINTERFACE);
			serviceManager.Release ();
	
			nsIIOService ioService = new nsIIOService (result[0]);
			result[0] = 0;
			/*
			 * Note.  Mozilla ignores LINK tags used to load CSS stylesheets
			 * when the URI protocol for the nsInputStreamChannel
			 * is about:blank.  The fix is to specify the file protocol.
			 */
			byte[] aString = Converter.wcsToMbcs (null, URI_FROMMEMORY, false);
			int /*long*/ aSpec = XPCOM.nsEmbedCString_new (aString, aString.length);
			rc = ioService.NewURI (aSpec, null, 0, result);
			if (rc != XPCOM.NS_OK) error (rc);
			if (result[0] == 0) error (XPCOM.NS_NOINTERFACE);
			XPCOM.nsEmbedCString_delete (aSpec);
			ioService.Release ();
	
			nsIURI uri = new nsIURI (result[0]);
			result[0] = 0;
	
			rc = webBrowser.QueryInterface (nsIInterfaceRequestor.NS_IINTERFACEREQUESTOR_IID, result);
			if (rc != XPCOM.NS_OK) error (rc);
			if (result[0] == 0) error (XPCOM.NS_ERROR_NO_INTERFACE);
			nsIInterfaceRequestor interfaceRequestor = new nsIInterfaceRequestor (result[0]);
			result[0] = 0;
	
			/*
			 * Feature in Mozilla. LoadStream invokes the nsIInputStream argument
			 * through a different thread.  The callback mechanism must attach 
			 * a non java thread to the JVM otherwise the nsIInputStream Read and
			 * Close methods never get called.
			 */
			InputStream inputStream = new InputStream (data);
			inputStream.AddRef ();
	
			rc = interfaceRequestor.GetInterface(nsIDocShell.NS_IDOCSHELL_IID, result);
			if (rc == XPCOM.NS_OK) {
				if (result[0] == 0) error (XPCOM.NS_ERROR_NO_INTERFACE);
				nsIDocShell docShell = new nsIDocShell (result[0]);
				rc = docShell.LoadStream (inputStream.getAddress (), uri.getAddress (), aContentType,  aContentCharset, 0);
				docShell.Release ();
			}else {
				error (rc);
			}
			result[0] = 0;
	
			inputStream.Release ();
			interfaceRequestor.Release ();
			uri.Release ();
			XPCOM.nsEmbedCString_delete (aContentCharset);
			XPCOM.nsEmbedCString_delete (aContentType);
		}
		return true;
	}
	
	public String getText () {

		int /*long*/[] result = new int /*long*/[1];
		int rc = webBrowser.GetContentDOMWindow (result);
		if (rc != XPCOM.NS_OK) error (rc);
		if (result[0] == 0) error (XPCOM.NS_NOINTERFACE);

		nsIDOMWindow window = new nsIDOMWindow (result[0]);
		result[0] = 0;
		rc = window.GetDocument (result);
		if (rc != XPCOM.NS_OK) error (rc);
		if (result[0] == 0) error (XPCOM.NS_NOINTERFACE);
		window.Release ();

		int /*long*/ document = result[0];
		result[0] = 0;
		rc = XPCOM.NS_GetComponentManager (result);
		if (rc != XPCOM.NS_OK) error (rc);
		if (result[0] == 0) error (XPCOM.NS_NOINTERFACE);

		nsIComponentManager componentManager = new nsIComponentManager (result[0]);
		result[0] = 0;
		byte[] contractID = Converter.wcsToMbcs (null, XPCOM.NS_DOMSERIALIZER_CONTRACTID, true);
		char[] chars = null;

		rc = componentManager.CreateInstanceByContractID (contractID, 0, nsIDOMSerializer.NS_IDOMSERIALIZER_IID, result);
		if (rc == XPCOM.NS_OK) {	/* mozilla >= 1.7 */
			if (result[0] == 0) error (XPCOM.NS_NOINTERFACE);

			nsIDOMSerializer serializer = new nsIDOMSerializer (result[0]);
			result[0] = 0;
			int /*long*/ string = XPCOM.nsEmbedString_new ();
			rc = serializer.SerializeToString (document, string);
			serializer.Release ();

			int length = XPCOM.nsEmbedString_Length (string);
			int /*long*/ buffer = XPCOM.nsEmbedString_get (string);
			chars = new char[length];
			XPCOM.memmove (chars, buffer, length * 2);
			XPCOM.nsEmbedString_delete (string);
		} 
		componentManager.Release ();
		new nsISupports (document).Release ();
		return new String (chars);
	}

	
	/**
	 * Loads a URL.
	 * 
	 * @param url the URL to be loaded
	 *
	 * @return true if the operation was successful and false otherwise.
	 *
	 * @exception IllegalArgumentException <ul>
	 *    <li>ERROR_NULL_ARGUMENT - if the url is null</li>
	 * </ul>
	 * 
	 * @exception SWTException <ul>
	 *    <li>ERROR_THREAD_INVALID_ACCESS when called from the wrong thread</li>
	 *    <li>ERROR_WIDGET_DISPOSED when the widget has been disposed</li>
	 * </ul>
	 *  
	 * @see #getUrl
	 * 
	 * @since 3.0
	 */
	public boolean setUrl(String url) {		
		return this.setUrl(url, null, null);
	}
	
	
	public boolean setUrl (String url, String postData, String[] headers) {
		
		checkWidget();
		if (url == null) SWT.error(SWT.ERROR_NULL_ARGUMENT);
		htmlBytes = null;
		int /*long*/[] result = new int /*long*/[1];
		int rc = webBrowser.QueryInterface (nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
		if (rc != XPCOM.NS_OK) error (rc);
		if (result[0] == 0) error (XPCOM.NS_ERROR_NO_INTERFACE);

		nsIWebNavigation webNavigation = new nsIWebNavigation (result[0]);
		result[0] = 0;
		char[] uri = new char[url.length () + 1];
		url.getChars (0, url.length (), uri, 0);

		nsIMIMEInputStream postDataStream = null;
		InputStream dataStream = null;
		if (postData != null) {
			rc = XPCOM.NS_GetComponentManager (result);
			if (rc != XPCOM.NS_OK) error (rc);
			if (result[0] == 0) error (XPCOM.NS_NOINTERFACE);
			nsIComponentManager componentManager = new nsIComponentManager (result[0]);
			result[0] = 0;
			byte[] contractID = Converter.wcsToMbcs (null, "@mozilla.org/network/mime-input-stream;1", true);
			rc = componentManager.CreateInstanceByContractID (contractID, 0, nsIMIMEInputStream.NS_IMIMEINPUTSTREAM_IID, result);
			componentManager.Release();

			if (rc == XPCOM.NS_OK && result[0] != 0) { /* nsIMIMEInputStream is not in mozilla 1.4 */
				byte[] bytes = Converter.wcsToMbcs (null, postData, false);
				dataStream = new InputStream (bytes);
				dataStream.AddRef ();
				postDataStream = new nsIMIMEInputStream (result[0]);
				rc = postDataStream.SetData (dataStream.getAddress ());
				if (rc != XPCOM.NS_OK) error (rc);
				rc = postDataStream.SetAddContentLength (1);
				if (rc != XPCOM.NS_OK) error (rc);
				byte[] name = Converter.wcsToMbcs (null, HEADER_CONTENTTYPE, true);
				byte[] value = Converter.wcsToMbcs (null, MIMETYPE_FORMURLENCODED, true);
				rc = postDataStream.AddHeader (name, value);
				if (rc != XPCOM.NS_OK) error (rc);
			}
			result[0] = 0;
		}

		InputStream headersStream = null;
	    if (headers != null) {
			StringBuffer buffer = new StringBuffer ();
			for (int i = 0; i < headers.length; i++) {
				String current = headers[i];
				if (current != null) {
					int sep = current.indexOf (':');
					if (sep != -1) {
						String key = current.substring (0, sep).trim ();
						String value = current.substring (sep + 1).trim ();
						if (key.length () > 0 && value.length () > 0) {
							buffer.append (key);
							buffer.append (':');
							buffer.append (value);
							buffer.append ("\r\n");
						}
					}
				}
			}
			byte[] bytes = Converter.wcsToMbcs (null, buffer.toString (), true);
			headersStream = new InputStream (bytes);
			headersStream.AddRef ();
	    }

		rc = webNavigation.LoadURI (
			uri,
			nsIWebNavigation.LOAD_FLAGS_NONE,
			0,
			postDataStream == null ? 0 : postDataStream.getAddress (),
			headersStream == null ? 0 : headersStream.getAddress ());
		if (dataStream != null) dataStream.Release ();
		if (headersStream != null) headersStream.Release ();
		webNavigation.Release ();
		return rc == XPCOM.NS_OK;
	}
	
	/**
	 * Stop any loading and rendering activity.
	 *
	 * @exception SWTException <ul>
	 *    <li>ERROR_THREAD_INVALID_ACCESS when called from the wrong thread</li>
	 *    <li>ERROR_WIDGET_DISPOSED when the widget has been disposed</li>
	 * </ul>
	 *
	 * @since 3.0
	 */
	public void stop() {
		checkWidget();
		htmlBytes = null;
		int /*long*/[] result = new int /*long*/[1];
		int rc = webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
		if (rc != XPCOM.NS_OK) error(rc);
		if (result[0] == 0) error(XPCOM.NS_ERROR_NO_INTERFACE);
		
		nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);	 	
		rc = webNavigation.Stop(nsIWebNavigation.STOP_ALL);
		if (rc != XPCOM.NS_OK) error(rc);
		webNavigation.Release();
	}
		
	protected static int checkVersion(String msg[]) {
		msg[0] = null; 
		int /*long*/[] result = new int /*long*/[1]; 
	    int rc = XPCOM.NS_GetServiceManager(result); 
	    if (rc != XPCOM.NS_OK) 
	    	return rc;
	    
	    if (0 == result[0]) 
	    	return XPCOM.NS_ERROR_NO_INTERFACE; 
		
	    nsIServiceManager serviceManager = new nsIServiceManager(result[0]); 
	    result[0] = 0;
		rc = serviceManager.GetService(XPCOM.NS_HTTPPROTOCOLHANDLER_CID, nsIHttpProtocolHandler.NS_IHTTPPROTOCOLHANDLER_IID, result);
		serviceManager.Release(); 
		if (rc != XPCOM.NS_OK) 
			return rc;
		
		if (0 == result[0]) 
	    	return XPCOM.NS_ERROR_NO_INTERFACE; 		
	
		nsIHttpProtocolHandler http = new nsIHttpProtocolHandler(result[0]);
		String userAgent = null;
		nsEmbedCString uaString = new nsEmbedCString();
		rc = http.GetUserAgent(uaString.getAddress());
		if (rc == XPCOM.NS_OK) {
			userAgent = uaString.toString();
			uaString.dispose();
		}
		http.Release();
		if (userAgent == null)
			return rc;
		
		int startIdx = userAgent.indexOf("rv:") + 3;
		if (-1 == startIdx) 
			return rc;
		
		int endIdx = userAgent.indexOf(")",startIdx);
		if (-1 == endIdx) 
			endIdx = userAgent.indexOf(" ",startIdx);
		
		if (-1 == endIdx) 
			endIdx = userAgent.length();
		
		String versionStr = userAgent.substring(startIdx, endIdx).trim();
		if (versionStr.length() == 0)
			return rc;
		
		String version = versionStr;
		endIdx = versionStr.indexOf('.'); 
		if (-1 == endIdx) 
			endIdx = versionStr.length();
		
		int major = 0;
		int minor = 0;
		try {
			major = Integer.parseInt(versionStr.substring(0,endIdx).trim());
			if (endIdx < versionStr.length()) {
				versionStr = versionStr.substring(endIdx + 1);
				endIdx = versionStr.indexOf('.'); 
				if (-1 == endIdx) 
					endIdx = versionStr.length();
				
				minor = Integer.parseInt(versionStr.substring(0,endIdx).trim());
			}
		}
		catch (NumberFormatException e) {
			logger.logp(Level.WARNING, CLASS_NAME, "checkVersion", //$NON-NLS-1$
					"NumberFormatException from MozillaBrowser", e); //$NON-NLS-1$
			return rc;
		}		
		
		// add for XULRunner 2.0+
		if(major > 1) {
			return rc;
		}
		
		if (major != XULRunnerVersion.getMajor() || minor < XULRunnerVersion.getMinor()) {
			StringBuffer buff = new StringBuffer();
			buff.append("Mozilla version ");
			buff.append(XULRunnerVersion.getMajor());
			buff.append('.');
			buff.append(XULRunnerVersion.getMinor());
			buff.append(" is required. Current version is: ");
			buff.append(version);
			msg[0] = buff.toString(); 
		}		
		return rc;
	}
	protected int /*long*/ getEmbedHandle() {
		return super.getEmbedHandle();
	}
	public nsIWebBrowser getWebBrowser() {
		checkWidget();
	    if (null == webBrowser)
		   return null;
            
	  //  webBrowser.AddRef();
	    return webBrowser;  
	}
	protected void setWebBrowser(nsIWebBrowser aWebBrowser) {
		if (this.webBrowser != null) 
			this.webBrowser.Release();
		this.webBrowser = aWebBrowser; 	
		if (this.webBrowser != null) 
			this.webBrowser.AddRef();
	}

	
	protected static byte[] mozBytes(String s) { 
        byte[] buffer = s.getBytes(); 
        byte[] output = new byte[buffer.length + 1]; 
        System.arraycopy(buffer, 0, output, 0, buffer.length); 
        return output; 
	} 
	
	public boolean setCookie2(String cookie, String url){
		if (url == null || url.length() == 0 || cookie == null)
			return false;
		
		int /*long*/[] result = new int /*long*/[1];
		int rc = XPCOM.NS_GetServiceManager (result);
		if (rc != XPCOM.NS_OK) error (rc);
		if (result[0] == 0) error (XPCOM.NS_NOINTERFACE);

		nsIServiceManager serviceManager = new nsIServiceManager (result[0]);
		result[0] = 0;
		rc = serviceManager.GetService (XPCOM.NS_IOSERVICE_CID, nsIIOService.NS_IIOSERVICE_IID, result);
		if (rc != XPCOM.NS_OK) error (rc);
		if (result[0] == 0) error (XPCOM.NS_NOINTERFACE);

		nsIIOService ioService = new nsIIOService (result[0]);
		result[0] = 0;
		byte[] bytes = Converter.wcsToMbcs (null, url, false);
		int /*long*/ aSpec = XPCOM.nsEmbedCString_new (bytes, bytes.length);
		rc = ioService.NewURI (aSpec, null, 0, result);
		XPCOM.nsEmbedCString_delete (aSpec);
		ioService.Release ();
		if (rc != XPCOM.NS_OK) {
			serviceManager.Release ();
			return false;
		}
		if (result[0] == 0) error (XPCOM.NS_ERROR_NULL_POINTER);

		nsIURI aURI = new nsIURI(result[0]);
		result[0] = 0;
		byte[] aCookie = Converter.wcsToMbcs (null, cookie, true);
		byte[] aContractID = Converter.wcsToMbcs (null, "@mozilla.org/cookieService;1", true);
		rc = serviceManager.GetServiceByContractID (aContractID, nsICookieService.NS_ICOOKIESERVICE_IID, result);
		if (rc != XPCOM.NS_OK) error (rc);
		if (result[0] == 0) error (XPCOM.NS_NOINTERFACE);
		nsICookieService cookieService = new nsICookieService (result[0]);
		//rc = cookieService.SetCookieString(aURI.getAddress(), 0, aCookie, 0);
		rc = cookieService.SetCookieStringFromHttp(aURI.getAddress(), aURI.getAddress(), 0, aCookie, null, 0);
		cookieService.Release ();

		result[0] = 0;
		aURI.Release ();
		serviceManager.Release ();
			
    	return rc == 0;
    }
    
	public String getCookie2(String cookieName, String url) {

		if (url == null || url.length() == 0 || cookieName == null)
			return null;

		String cookieValue = null;

		int /*long*/[] result = new int /*long*/[1];
		int rc = XPCOM.NS_GetServiceManager(result);
		if (rc != XPCOM.NS_OK)
			error(rc);
		if (result[0] == 0)
			error(XPCOM.NS_NOINTERFACE);

		nsIServiceManager serviceManager = new nsIServiceManager(result[0]);
		result[0] = 0;
		rc = serviceManager.GetService(XPCOM.NS_IOSERVICE_CID,
				nsIIOService.NS_IIOSERVICE_IID, result);
		if (rc != XPCOM.NS_OK)
			error(rc);
		if (result[0] == 0)
			error(XPCOM.NS_NOINTERFACE);

		nsIIOService ioService = new nsIIOService(result[0]);
		result[0] = 0;
		byte[] bytes = Converter.wcsToMbcs(null, url, false);
		int /*long*/aSpec = XPCOM.nsEmbedCString_new(bytes, bytes.length);
		rc = ioService.NewURI(aSpec, null, 0, result);
		XPCOM.nsEmbedCString_delete(aSpec);
		ioService.Release();
		if (rc != XPCOM.NS_OK) {
			serviceManager.Release();
			return null;
		}
		if (result[0] == 0)
			error(XPCOM.NS_ERROR_NULL_POINTER);

		nsIURI aURI = new nsIURI(result[0]);
		result[0] = 0;
		byte[] aContractID = Converter.wcsToMbcs(null,"@mozilla.org/cookieService;1", true);
		rc = serviceManager.GetServiceByContractID(aContractID,
				nsICookieService.NS_ICOOKIESERVICE_IID, result);

		if (rc != XPCOM.NS_OK)
			error(rc);
		if (result[0] == 0)
			error(XPCOM.NS_NOINTERFACE);

		int /*long*/cookieString;
		nsICookieService cookieService = new nsICookieService(result[0]);
		result[0] = 0;
		//rc = cookieService.GetCookieString(aURI.getAddress(), 0, result);
		rc = cookieService.GetCookieStringFromHttp(aURI.getAddress(), aURI.getAddress(), 0, result);
		cookieService.Release();
		if (rc != XPCOM.NS_OK)
			error(rc);
		if (result[0] == 0) {
			aURI.Release();
			serviceManager.Release();
			return null;
		}
		cookieString = result[0];

		aURI.Release();
		serviceManager.Release();
		result[0] = 0;

		int length = C.strlen(cookieString);
		bytes = new byte[length];
		XPCOM.memmove(bytes, cookieString, length);
		//C.free(cookieString);
		XPCOM.nsfree(cookieString);
		String allCookies = new String(Converter.mbcsToWcs(null, bytes));
		StringTokenizer tokenizer = new StringTokenizer(allCookies, ";"); //$NON-NLS-1$
		while (tokenizer.hasMoreTokens()) {
			String cookie = tokenizer.nextToken();
			int index = cookie.indexOf('=');
			if (index != -1) {
				String name = cookie.substring(0, index).trim();
				if (name.equals(cookieName)) {
					cookieValue = cookie.substring(index + 1).trim();
					break;
				}
			}
		}

		return cookieValue;
	}
	
	public static String getXulrunnerVersion(){ 
		//String xulVersion= "1.9.1.3"; //$NON-NLS-1$
		//String xulVersion= "1.9.2.10"; //$NON-NLS-1$
		String xulVersion= "43.0.4"; //$NON-NLS-1$
		return xulVersion;
	}

	private boolean isAppletEnabled(){
		
		if(isMacOSX){
			//always disable applet on Mac
			return false;
		}
		
		try{
			IPreferencesService service = Platform.getPreferencesService();
			IEclipsePreferences root = service.getRootNode();
			Preferences pPref = root.node(DefaultScope.SCOPE).node(PLUGIN_NAME); 
			if(pPref instanceof IEclipsePreferences){
				IEclipsePreferences ePref = ((IEclipsePreferences)pPref);
				return ePref.getBoolean(PREFERENCE_ENABLE_APPLET, true);  
			}
		}catch(Exception e){
			logger.logp(Level.WARNING, CLASS_NAME, "isAppletEnabled", //$NON-NLS-1$
					"Exception from MozillaBrowser", e); //$NON-NLS-1$
			return false;
		}
		return false;
	}
	private void copyCert8DBFile(String profilePath){
		if(profilePath==null){
			return;
		}
		// Read related preferences
		IPreferencesService prefs = Platform.getPreferencesService();
		IScopeContext[] scopes = new IScopeContext[]{new InstanceScope(), new ConfigurationScope(), new DefaultScope()};
		String certDBFileVersion = prefs.getString(BROWSER_PREFERENCE_NODE, "cert8DBVersion", null, scopes); //Default value is NULL
		if(certDBFileVersion==null){
			logger.logp(Level.FINE, CLASS_NAME, "copyCert8DBFile", //$NON-NLS-1$
					"cert8DBVersion preference is not set. "); //$NON-NLS-1$
			return;
		}
		certDBFileVersion = certDBFileVersion.trim();
		logger.logp(Level.FINE, CLASS_NAME, "copyCert8DBFile", //$NON-NLS-1$
				"cert8DBVersion value set in preference is: " + certDBFileVersion); //$NON-NLS-1$
		
		String certDBFilePath= prefs.getString(BROWSER_PREFERENCE_NODE, "cert8DBFilePath", null, scopes); //Default value is NULL
		if(certDBFilePath==null){
			logger.logp(Level.FINE, CLASS_NAME, "copyCert8DBFile", //$NON-NLS-1$
					"cert8DBFilePath preference is not set. "); //$NON-NLS-1$
			return;
		}
		certDBFilePath = certDBFilePath.trim();
		
		if(certDBFilePath.indexOf("${user.home}")!=-1){ //$NON-NLS-1$
			String userHome = System.getProperty("user.home"); //$NON-NLS-1$
			certDBFilePath = certDBFilePath.replace("${user.home}", userHome); //$NON-NLS-1$
		}else if(certDBFilePath.indexOf("${rcp.home}")!=-1){ //$NON-NLS-1$
			String installLocation = Platform.getInstallLocation().getURL().getFile();
			installLocation = installLocation.substring(0, installLocation.length()-("/eclipse/".length())); // Remove the eclipse/ 
			certDBFilePath = certDBFilePath.replace("${rcp.home}", installLocation); //$NON-NLS-1$
		}
		logger.logp(Level.FINE, CLASS_NAME, "copyCert8DBFile", //$NON-NLS-1$
				"cert8DBFilePath value set in preference is: " + certDBFilePath); //$NON-NLS-1$
		
		// If the file does not exist, return directly
		if(!new File(certDBFilePath).exists()){
			logger.logp(Level.INFO, CLASS_NAME, "copyCert8DBFile",//$NON-NLS-1$
					certDBFilePath + " does not exist.");//$NON-NLS-1$
			return;
		}
		
		// Get the preference 
		String version = null;
		String prefCopiedCertDBVersion = "copiedCertDBVersion"; //$NON-NLS-1$
    	IPreferencesService service = Platform.getPreferencesService();
    	IEclipsePreferences root = service.getRootNode();
    	Preferences pPref = root.node(InstanceScope.SCOPE).node("com.ibm.rcp.dombrowser");
    	version = pPref.get(prefCopiedCertDBVersion, "");
		
		// Need to check if the version changed, if it is not changed, then return directly, otherwise, copy it.
		if(version == null || certDBFileVersion.equalsIgnoreCase(version)){
			logger.logp(Level.FINE, CLASS_NAME, "copyCert8DBFile", //$NON-NLS-1$
					certDBFilePath + " is not copied due to the stored version is same as the one in preference. "); //$NON-NLS-1$
			return;
		}
		
		// Copy the file
		boolean isCopyCorrect = true;
		int read;
		java.io.InputStream is = null;
		FileOutputStream os = null;
		byte [] buffer = new byte [4096];
		File file = new File (profilePath, "cert8.db"); //$NON-NLS-1$
		try {
			is = new FileInputStream(certDBFilePath);
			os = new FileOutputStream (file);
			while ((read = is.read (buffer)) != -1) {
				os.write(buffer, 0, read);
			}
		} catch (FileNotFoundException e) {
			logger.logp(Level.INFO, CLASS_NAME, "copyCert8DBFile", //$NON-NLS-1$
					"FileNotFoundException from copyCert8DBFile()", e); //$NON-NLS-1$
			isCopyCorrect = false;
		} catch (IOException e) {
			logger.logp(Level.INFO, CLASS_NAME, "copyCert8DBFile", //$NON-NLS-1$
					"IOException from copyCert8DBFile()", e); //$NON-NLS-1$
			isCopyCorrect = false;
		}finally {
			try {
				if (os != null) os.close();
				if (is != null) is.close();
			} catch (IOException e) {}
		}
		if(!isCopyCorrect){
			logger.logp(Level.INFO, CLASS_NAME, "copyCert8DBFile", //$NON-NLS-1$
					"Error occurs when copying "+ certDBFilePath + " file."); //$NON-NLS-1$
			return;
		}
		logger.logp(Level.FINE, CLASS_NAME, "copyCert8DBFile", //$NON-NLS-1$
				certDBFilePath + " is copied into BrowserProfile. "); //$NON-NLS-1$
		//Store the version into preference
		if(pPref!=null){
			pPref.put(prefCopiedCertDBVersion, certDBFileVersion);
			try {
				// Forces to save the preferences
				pPref.flush();
		  	} catch (BackingStoreException e) {
		  		e.printStackTrace();
		  	}
		}
	}
	
	void initOldExternal (String profilePath) {
		File componentsDir = new File (profilePath, AppFileLocProvider.COMPONENTS_DIR);
		java.io.InputStream is = getClass().getResourceAsStream ("/external.xpt"); //$NON-NLS-1$
		if (is != null) {
			if (!componentsDir.exists ()) {
				componentsDir.mkdirs ();
				logger.logp(Level.FINEST, CLASS_NAME, "initExternal",//$NON-NLS-1$
						"Make folder " + componentsDir.getPath());//$NON-NLS-1$
			}
			int read;
			byte [] buffer = new byte [4096];
			File file = new File (componentsDir, "external.xpt"); //$NON-NLS-1$
			try {
				FileOutputStream os = new FileOutputStream (file);
				while ((read = is.read (buffer)) != -1) {
					os.write(buffer, 0, read);
				}
				os.close ();
				is.close ();
			} catch (FileNotFoundException e) {
				logger.logp(Level.WARNING, CLASS_NAME, "initExternal", //$NON-NLS-1$
						"Exception from initExternal()", e); //$NON-NLS-1$
			} catch (IOException e) {
				logger.logp(Level.WARNING, CLASS_NAME, "initExternal", //$NON-NLS-1$
						"Exception from initExternal()", e); //$NON-NLS-1$
			}
		} else {
			logger.logp(Level.WARNING, CLASS_NAME, "initExternal", //$NON-NLS-1$
					"Failed to get resource file external.xpt file"); //$NON-NLS-1$
		}
		// Create manifest for external.xpt
		File file = new File(profilePath, "chrome.manifest");
		try{
			FileOutputStream os = new FileOutputStream (file);
			String content = "interfaces components/external.xpt";
			os.write(content.getBytes());
			os.close();
		}catch (IOException e) {
			logger.logp(Level.WARNING, CLASS_NAME, "initExternal", //$NON-NLS-1$
					"Exception from initExternal()", e); //$NON-NLS-1$
		}
	}
	
	void initExternal (String profilePath) {
		File componentsDir = new File (profilePath, AppFileLocProvider.COMPONENTS_DIR);
		java.io.InputStream is = getClass().getResourceAsStream ("/swt.xpt"); //$NON-NLS-1$
		if (is != null) {
			if (!componentsDir.exists ()) {
				componentsDir.mkdirs ();
			}
			int read;
			byte [] buffer = new byte [4096];
			File file = new File (componentsDir, "swt.xpt"); //$NON-NLS-1$
			try {
				FileOutputStream os = new FileOutputStream (file);
				while ((read = is.read (buffer)) != -1) {
					os.write(buffer, 0, read);
				}
				os.close ();
				is.close ();
			} catch (FileNotFoundException e) {
			} catch (IOException e) {
			}
		}
		is = getClass().getResourceAsStream ("/swt.js"); //$NON-NLS-1$
		if (is != null) {
			if (!componentsDir.exists ()) {
				componentsDir.mkdirs ();
			}
			int read;
			byte [] buffer = new byte [4096];
			File file = new File (componentsDir, "swt.js"); //$NON-NLS-1$
			try {
				FileOutputStream os = new FileOutputStream (file);
				while ((read = is.read (buffer)) != -1) {
					os.write(buffer, 0, read);
				}
				os.close ();
				is.close ();
			} catch (FileNotFoundException e) {
			} catch (IOException e) {
			}
		}
		is = getClass().getResourceAsStream ("/chrome.manifest"); //$NON-NLS-1$
		if (is != null) {
			int read;
			byte [] buffer = new byte [4096];
			File file = new File (profilePath, "chrome.manifest"); //$NON-NLS-1$
			try {
				FileOutputStream os = new FileOutputStream (file, true);
				os.write(System.getProperty("line.separator").getBytes());
				while ((read = is.read (buffer)) != -1) {
					os.write(buffer, 0, read);
				}
				os.close ();
				is.close ();
			} catch (FileNotFoundException e) {
			} catch (IOException e) {
			}
		}
	}

	public void createFunction (BrowserFunction browserFunction) {
		/*
		 * TODO need check the BrowserFunction enable status here. If the 
		 * status is disabled, then disallow creating the BrowserFunction, and 
		 * log a message to notify user the reason. 
		 */
		String _method = "createFunction";
		
		/*
		 *  If there's no "com.ibm.rcp.browser/enableBrowserFunction" preference setting, 
		 *  then the BrowserFunction is enabled by default.  
		 */
		IPreferencesService prefs = Platform.getPreferencesService();
		IScopeContext[] scopes = new IScopeContext[]{new InstanceScope(), new ConfigurationScope(), new DefaultScope()};
		boolean jsBridgeEnabled = prefs.getBoolean(BROWSER_PREFERENCE_NODE, "enableBrowserFunction", true, scopes);

		if(!jsBridgeEnabled){
			logger.logp(Level.WARNING, CLASS_NAME, _method, DOMBrowserNLS.BrowserFunction_Disabled); 
			return;
		}
		
		/* 
		 * If an existing function with the same name is found then
		 * remove it so that it is not recreated on subsequent pages
		 * (the new function overwrites the old one).
		 */
		Enumeration keys = functions.keys ();

		while (keys.hasMoreElements ()) {
			Object key = keys.nextElement ();
			BrowserFunction current = (BrowserFunction)functions.get (key);
			if (current.name.equals (browserFunction.name)) {
				deregisterFunction(current);
				break;
			}
		}

		browserFunction.index = getNextFunctionIndex ();
		registerFunction (browserFunction);

		StringBuffer buffer = new StringBuffer ("window."); //$NON-NLS-1$
		buffer.append (browserFunction.name);
		buffer.append (" = function "); //$NON-NLS-1$
		buffer.append (browserFunction.name);
		buffer.append ("() {var result = window.external.callJava("); //$NON-NLS-1$
		buffer.append (browserFunction.index);
		buffer.append (",'"); //$NON-NLS-1$
		buffer.append (browserFunction.token);
		buffer.append ("',Array.prototype.slice.call(arguments)); if (typeof result == 'string' && result.indexOf('"); //$NON-NLS-1$
		buffer.append (CLASS_NAME);
		buffer.append ("') == 0) {var error = new Error(result.substring("); //$NON-NLS-1$
		buffer.append (CLASS_NAME.length ());
		buffer.append (")); throw error;} return result;};"); //$NON-NLS-1$
		//Comment to secure BrowserFunction in iframes
//		buffer.append ("for (var i = 0; i < frames.length; i++) {try { frames[i]."); //$NON-NLS-1$
//		buffer.append (browserFunction.name);
//		buffer.append (" = window."); //$NON-NLS-1$
//		buffer.append (browserFunction.name);
//		buffer.append (";} catch (e) {} };"); //$NON-NLS-1$
		browserFunction.functionString = buffer.toString ();
		execute (browserFunction.functionString);
	}

	public void destroyFunction (BrowserFunction browserFunction) {
		String deleteString = getDeleteFunctionString (browserFunction.name); 
		StringBuffer buffer = new StringBuffer ("for (var i = 0; i < frames.length; i++) {try {frames[i].eval(\""); //$NON-NLS-1$
		buffer.append (deleteString);
		buffer.append ("\");} catch (e) {}}"); //$NON-NLS-1$
		execute (buffer.toString ());
		execute (deleteString);
		deregisterFunction (browserFunction);
	}
	
	public Object evaluate (String script) throws SWTException {
		BrowserFunction function = new EvaluateFunction ((DOMBrowser)this, ""); // $NON-NLS-1$
		int index = getNextFunctionIndex ();
		function.index = index;
		function.isEvaluate = true;
		registerFunction (function);
		String functionName = EXECUTE_ID + index;

		StringBuffer buffer = new StringBuffer ("window."); // $NON-NLS-1$
		buffer.append (functionName);
		buffer.append (" = function "); // $NON-NLS-1$
		buffer.append (functionName);
		buffer.append ("() {\n"); // $NON-NLS-1$
		buffer.append (script);
		buffer.append ("\n};"); // $NON-NLS-1$
		execute (buffer.toString ());

		buffer = new StringBuffer ("if (window."); // $NON-NLS-1$
		buffer.append (functionName);
		buffer.append (" == undefined) {window.external.callJava("); // $NON-NLS-1$
		buffer.append (index);
		buffer.append (",'"); //$NON-NLS-1$
		buffer.append (function.token);
		buffer.append ("', ['"); // $NON-NLS-1$
		buffer.append (CLASS_NAME);
		buffer.append ("']);} else {try {var result = "); // $NON-NLS-1$
		buffer.append (functionName);
		buffer.append ("(); window.external.callJava("); // $NON-NLS-1$
		buffer.append (index);
		buffer.append (",'"); //$NON-NLS-1$
		buffer.append (function.token);
		buffer.append ("', [result]);} catch (e) {window.external.callJava("); // $NON-NLS-1$
		buffer.append (index);
		buffer.append (",'"); //$NON-NLS-1$
		buffer.append (function.token);
		buffer.append ("', ['"); // $NON-NLS-1$
		buffer.append (CLASS_NAME);
		buffer.append ("' + e.message]);}}"); // $NON-NLS-1$
		execute (buffer.toString ());
		execute (getDeleteFunctionString (functionName));
		deregisterFunction (function);

		Object result = evaluateResult;
		evaluateResult = null;
		if (result instanceof SWTException) throw (SWTException)result;
		return result;
	}
	
	public class EvaluateFunction extends BrowserFunction {
		public EvaluateFunction (DOMBrowser browser, String name) {
			super (browser, name, false);
		}
		public Object function (Object[] arguments) {
			if (arguments[0] instanceof String) {
				String string = (String)arguments[0];
				if (string.startsWith (CLASS_NAME)) {
					String errorString = ExtractError (string);
					if (errorString.length () > 0) {
						evaluateResult = new SWTException (SWT.ERROR_FAILED_EVALUATE, errorString);
					} else {
						evaluateResult = new SWTException (SWT.ERROR_FAILED_EVALUATE);
					}
					return null;
				}
			}
			evaluateResult = arguments[0];
			return null;
		}
	}
	
	String getDeleteFunctionString (String functionName) {
		return "delete window." + functionName;	//$NON-NLS-1$
	}

	int getNextFunctionIndex () {
		return NextJSFunctionIndex++;
	}
	void registerFunction (BrowserFunction function) {
		functions.put (new Integer (function.index), function);
		AllFunctions.put (new Integer (function.index), function);
	}
	void deregisterFunction (BrowserFunction function) {
		functions.remove (new Integer (function.index));
		AllFunctions.remove (new Integer (function.index));
	}	
	static String ExtractError (String error) {
		return error.substring (CLASS_NAME.length ());
	}
	
	// add for xul 10.0, add "chrome.manifest" in profilePath
	void addManifestLocation(String manifestPath) {
		File file = new File(manifestPath, "chrome.manifest");
		// add for xul 7.0, use "XRE_AddManifestLocation()" to add another chrome.manifest file
		int rc = 0;
		int /*long*/[] result = new int /*long*/[1];
		nsEmbedString path = new nsEmbedString(file.getAbsolutePath());
		rc = XPCOM.NS_NewLocalFile(path.getAddress(), true, result);
		path.dispose();
		if (rc != XPCOM.NS_OK) error(rc);
		if (result[0] == 0) error(XPCOM.NS_ERROR_NULL_POINTER);	
		nsILocalFile localFile = new nsILocalFile(result[0]);
		result[0] = 0;
		
		int size = XPCOM.nsDynamicFunctionLoad_sizeof();
		/* alloc memory for two structs, the second is empty to signify the end of the list */
		int /*long*/ ptr = C.malloc(size*2);
		C.memset(ptr, 0, size*2);
		
		nsDynamicFunctionLoad functionLoad = new nsDynamicFunctionLoad();
		byte[] bytes = Converter.wcsToMbcs(null, "XRE_AddManifestLocation", true); //$NON-NLS-1$
		functionLoad.functionName = C.malloc(bytes.length);
		C.memmove(functionLoad.functionName, bytes, bytes.length);
		functionLoad.function = C.malloc(C.PTR_SIZEOF);
		C.memmove(functionLoad.function, new int /*long*/[] {0}, C.PTR_SIZEOF);
		XPCOM.memmove(ptr, functionLoad, XPCOM.nsDynamicFunctionLoad_sizeof());
		XPCOM.XPCOMGlueLoadXULFunctions(ptr);
		C.memmove(result, functionLoad.function, C.PTR_SIZEOF);
		int /*long*/ functionPtr = result[0];
		result[0] = 0;
		C.free(functionLoad.function);
		C.free(functionLoad.functionName);
		C.free(ptr);
		// NS_COMPONENT_LOCATION = 0
		rc = XPCOM.Call(functionPtr, 0, localFile.getAddress());
		if (rc != XPCOM.NS_OK) {
			dispose ();
    		error (rc);
			logger.logp(Level.WARNING, CLASS_NAME, "addManifestLocation", //$NON-NLS-1$
			"Failed to call XRE_AddManifestLocation()"); //$NON-NLS-1$
		}
	}
}
