/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.rcp.dombrowser.browser;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.*;

import com.ibm.rcp.dombrowser.internal.mozilla.*;
import com.ibm.rcp.dombrowser.internal.ui.*;

class HelperAppLauncherService extends FactoryMember {
	
	ProgressDialogEx progressDialog;
	XPCOMObject supports;
	XPCOMObject helperAppLauncherDialog;
	XPCOMObject webProgressListener2;
	XPCOMObject supportsWeakReference;
	XPCOMObject weakReference;
	int refCount;
	
	public HelperAppLauncherService() {
		createCOMInterfaces();
	}
	
	public int AddRef() {
		refCount++;
		return refCount;
	}
	
	void createCOMInterfaces() {
		/* Create each of the interfaces that this object implements */
		supports = new XPCOMObject(new int[]{2, 0, 0}){
			public int /*long*/ method0(int /*long*/[] args) {return QueryInterface(args[0], args[1]);}
			public int /*long*/ method1(int /*long*/[] args) {return AddRef();}
			public int /*long*/ method2(int /*long*/[] args) {return Release();}
		};
		
		helperAppLauncherDialog = new XPCOMObject(new int[]{2, 0, 0, 3, 5}){
			public int /*long*/ method0(int /*long*/[] args) {return QueryInterface(args[0], args[1]);}
			public int /*long*/ method1(int /*long*/[] args) {return AddRef();}
			public int /*long*/ method2(int /*long*/[] args) {return Release();}
			public int /*long*/ method3(int /*long*/[] args) {return Show(args[0], args[1], (int)/*64*/args[2]);}
			public int /*long*/ method4(int /*long*/[] args) {return PromptForSaveToFile(args[0], args[1], args[2], args[3], args[4]);}
		};
		
		webProgressListener2 = new XPCOMObject(new int[]{2, 0, 0, 4, 6, 4, 4, 3, 6, 5}){
			public int /*long*/ method0(int /*long*/[] args) {return QueryInterface(args[0], args[1]);}
			public int /*long*/ method1(int /*long*/[] args) {return AddRef();}
			public int /*long*/ method2(int /*long*/[] args) {return Release();}
			public int /*long*/ method3(int /*long*/[] args) {return OnStateChange(args[0], args[1], (int)/*64*/args[2],args[3]);}
			public int /*long*/ method4(int /*long*/[] args) {return OnProgressChange(args[0], args[1], args[2],args[3],args[4],args[5]);}
			public int /*long*/ method5(int /*long*/[] args) {return OnLocationChange(args[0], args[1], args[2],args[3]);}
			public int /*long*/ method6(int /*long*/[] args) {return OnStatusChange(args[0], args[1], (int)/*64*/args[2], args[3]);}
			public int /*long*/ method7(int /*long*/[] args) {return OnSecurityChange(args[0], args[1], (int)/*64*/args[2]);}
			public int /*long*/ method8(int /*long*/[] args) {return OnProgressChange64(args[0], args[1],args[2],args[3],args[4],args[5]);}
			public int /*long*/ method9(int /*long*/[] args) {return OnRefreshAttempted(args[0], args[1],args[2],args[3],args[4]);}
		};
		
		supportsWeakReference = new XPCOMObject(new int[]{2, 0, 0, 1}){
			public int /*long*/ method0(int /*long*/[] args) {return QueryInterface(args[0], args[1]);}
			public int /*long*/ method1(int /*long*/[] args) {return AddRef();}
			public int /*long*/ method2(int /*long*/[] args) {return Release();}
			public int /*long*/ method3(int /*long*/[] args) {return GetWeakReference(args[0]);}
		};
		
		weakReference = new XPCOMObject(new int[]{2, 0, 0, 2}){
			public int /*long*/ method0(int /*long*/[] args) {return QueryInterface(args[0], args[1]);}
			public int /*long*/ method1(int /*long*/[] args) {return AddRef();}
			public int /*long*/ method2(int /*long*/[] args) {return Release();}
			public int /*long*/ method3(int /*long*/[] args) {return QueryReferent(args[0], args[1]);}
		};
	}
	
	public void disposeCOMInterfaces() {
		if (this.progressDialog != null) { 
//        	this.progressDialog.dispose(); 
        	this.progressDialog = null;
        }
		if (supports != null) {
			supports.dispose();
			supports = null;
		}	
		if (helperAppLauncherDialog != null) {
			helperAppLauncherDialog.dispose();
			helperAppLauncherDialog = null;	
		}
		if (weakReference != null) {
			weakReference.dispose();
			weakReference = null;	
		}
		if (supportsWeakReference != null) {
			supportsWeakReference.dispose();
			supportsWeakReference = null;
		}	
		if (webProgressListener2 != null) {
			webProgressListener2.dispose();
			webProgressListener2 = null;
		}
	}
	
	int /*long*/ getAddress() {
		return helperAppLauncherDialog.getAddress();
	}
	
	public int QueryInterface(int /*long*/ riid, int /*long*/ ppvObject) {
		if (riid == 0 || ppvObject == 0) return XPCOM.NS_ERROR_NO_INTERFACE;
		nsID guid = new nsID();
		XPCOM.memmove(guid, riid, nsID.sizeof);
		
		if (guid.Equals(nsISupports.NS_ISUPPORTS_IID)) {
			XPCOM.memmove(ppvObject, new int /*long*/[] {supports.getAddress()}, XPCOMObject.PTR_SIZEOF);
			AddRef();
			return XPCOM.NS_OK;
		}
		if (guid.Equals(nsIHelperAppLauncherDialog.NS_IHELPERAPPLAUNCHERDIALOG_IID)) {
			XPCOM.memmove(ppvObject, new int /*long*/[] {helperAppLauncherDialog.getAddress()}, XPCOMObject.PTR_SIZEOF);
			AddRef();
			return XPCOM.NS_OK;
		}
		if (guid.Equals(nsIWebProgressListener2.NS_IWEBPROGRESSLISTENER2_IID)) {
			XPCOM.memmove(ppvObject, new int /*long*/[] {webProgressListener2.getAddress()}, XPCOMObject.PTR_SIZEOF);
			AddRef();
			return XPCOM.NS_OK;
		}
		if (guid.Equals(nsIWeakReference.NS_IWEAKREFERENCE_IID)) {
			XPCOM.memmove(ppvObject, new int /*long*/[] {weakReference.getAddress()}, XPCOMObject.PTR_SIZEOF);
			AddRef();
			return XPCOM.NS_OK;
		}
		if (guid.Equals(nsISupportsWeakReference.NS_ISUPPORTSWEAKREFERENCE_IID)) {
			XPCOM.memmove(ppvObject, new int /*long*/[] {supportsWeakReference.getAddress()}, XPCOMObject.PTR_SIZEOF);
			AddRef();
			return XPCOM.NS_OK;
		}
		
		XPCOM.memmove(ppvObject, new int[] {0}, XPCOMObject.PTR_SIZEOF);
		return XPCOM.NS_ERROR_NO_INTERFACE;
	}
	        	
	public int Release() {
		refCount--;
		if (refCount == 0) disposeCOMInterfaces();
		return refCount;
	}
		
	/* nsIHelperAppLauncherDialog */
	
	int Show(int /*long*/ aLauncher, int /*long*/ aContext, int aForced) {
		if (aLauncher == 0) return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
		
		Display display = Display.getCurrent();
	    if (null == display)
	    	display = Display.getDefault();
		
	    Shell shell = null;
	    if (display != null) {
		    shell = display.getActiveShell();
		    if (null == shell)
		    shell = new Shell(display);
	    }
	    if (null == shell)
	    	return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
	    
	    nsIHelperAppLauncher helperLauncher = new nsIHelperAppLauncher(aLauncher);	
			
		ChooseActionDialogEx dlg = new ChooseActionDialogEx(shell);
		int rc = dlg.open();
		if (rc == 0)  
			return helperLauncher.Cancel(XPCOM.NS_ERROR_ABORT);
					
		if (rc == 2)
			return helperLauncher.SaveToDisk(0, 0);
				
		return helperLauncher.LaunchWithApplication(0, 0);
	}

	int PromptForSaveToFile(int /*long*/ aLauncher, int /*long*/ aContext, int /*long*/ aDefaultFile, 
			int /*long*/ aSuggestedFileExtension, int /*long*/ retVal) {
		
		if (aLauncher == 0) return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
		
		Display display = Display.getCurrent();
	    if (null == display)
	    	display = Display.getDefault();
		
	    Shell shell = null;
	    if (display != null) {
		    shell = display.getActiveShell();
		    if (null == shell)
		    shell = new Shell(display);
	    }
	    if (null == shell)
	    	return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
		    
	    nsIHelperAppLauncher helperAppLauncher = new nsIHelperAppLauncher(aLauncher);	
		    
	    String defaultFile = WString.toNotNullString(aDefaultFile);
		String suggestedFileExtension = WString.toNotNullString(aSuggestedFileExtension);
		   	    
		int rc = XPCOM.NS_OK;
    	FileDialog fileDialog = new FileDialog(shell, SWT.PRIMARY_MODAL | SWT.SAVE);
    	fileDialog.setFileName(defaultFile);
    	fileDialog.setFilterExtensions(new String[] {suggestedFileExtension});
    	String fullpath = fileDialog.open();
    	if (null == fullpath) {
    		if (helperAppLauncher != null) {
    			rc = helperAppLauncher.Cancel(XPCOM.NS_ERROR_FAILURE);
    			if (rc != XPCOM.NS_OK) MozillaBrowser.error(rc);
    			return XPCOM.NS_OK;
    		}
    		return XPCOM.NS_ERROR_FAILURE;
    	}
       	nsEmbedString file = new nsEmbedString(fullpath);
       	int /*long*/[] ret = new int /*long*/[1];
    	rc = XPCOM.NS_NewLocalFile(file.getAddress(), false, ret);
    	file.dispose();
		if (rc == XPCOM.NS_OK) {
			if (retVal != 0) XPCOM.memmove(retVal, ret, XPCOMObject.PTR_SIZEOF);
	//		if (helperAppLauncher != null) 
	//			ShowProgressDialog(helperAppLauncher.getAddress());
		}
		return rc;
	}
	
	int ShowProgressDialog(int aLauncher) {
		if (aLauncher == 0) return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
		
		Display display = Display.getCurrent();
	    if (null == display)
	    	display = Display.getDefault();
		
	    Shell shell = null;
	    if (display != null) {
		    shell = display.getActiveShell();
		    if (null == shell)
		    	shell = new Shell(display);
	    }
	    if (null == shell)
	    	return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
	   	    
		nsIHelperAppLauncher helperLauncher = new nsIHelperAppLauncher(aLauncher);
		helperLauncher.SetWebProgressListener(webProgressListener2.getAddress());
//		if (this.progressDialog != null) this.progressDialog.dispose();
//		this.progressDialog = new ProgressDialog(shell,helperLauncher);
		return XPCOM.NS_OK;
	}
	
	/* nsIWeakReference */	
	
	int QueryReferent(int /*long*/ riid, int /*long*/ ppvObject) {
		return QueryInterface(riid,ppvObject);
	}
	
	int GetWeakReference(int /*long*/ ppvObject) {
		XPCOM.memmove(ppvObject, new int /*long*/[] {weakReference.getAddress()}, XPCOMObject.PTR_SIZEOF);
		AddRef();
		return XPCOM.NS_OK;
	}
	
	/* nsIWebProgressListener */

	int OnStateChange(int /*long*/ aWebProgress, int /*long*/ aRequest, int aStateFlags, int /*long*/ aStatus) {
		
		if ((aStateFlags & nsIWebProgressListener.STATE_STOP) != 0)  {
	        
			// We've completed the download - close the progress window
	        if (this.progressDialog != null) { 
	        	this.progressDialog.close(); 
	        	this.progressDialog = null;
	        }
	    }
		return XPCOM.NS_OK;
	}	

	int OnProgressChange(int /*long*/ aWebProgress, int /*long*/ aRequest, int /*long*/ aCurSelfProgress, int /*long*/ aMaxSelfProgress, int /*long*/ aCurTotalProgress, int /*long*/ aMaxTotalProgress) {
	
		// Update the progress control
	    if (this.progressDialog != null) 
	    	this.progressDialog.setRange(aCurTotalProgress,aMaxTotalProgress);
	    
		return XPCOM.NS_OK;
	}		

	int OnLocationChange(int /*long*/ aWebProgress, int /*long*/ aRequest, int /*long*/ aLocation, int /*long*/ aFlags) {
		return XPCOM.NS_OK;
	}
	  
	int OnStatusChange(int /*long*/ aWebProgress, int /*long*/ aRequest, int aStatus, int /*long*/ aMessage) {
		if (aMessage != 0) {
			Display display = Display.getCurrent();
		    if (null == display)
		    	display = Display.getDefault();
			
		    Shell shell = null;
		    if (display != null) {
			    shell = display.getActiveShell();
			    if (null == shell)
			    	shell = new Shell(display);
		    }
		    if (shell != null) {
		    	String textLabel = WString.toNotNullString(aMessage);
		    	MessageDialog.openInformation(shell, "", textLabel);

		    }
		}
		return XPCOM.NS_OK;
	}		

	int OnSecurityChange(int /*long*/ aWebProgress, int /*long*/ aRequest, int state) {
		return XPCOM.NS_OK;
	}
	
	/* nsIWebProgressListener2 */
	//changed for xul45
	int OnProgressChange64(int /*long*/ aWebProgress, int /*long*/ aRequest, int /*long*/ aCurSelfProgress,
			int /*long*/ aMaxSelfProgress, int /*long*/ aCurTotalProgress, int /*long*/ aMaxTotalProgress) {
		
		// Update the progress control
	    if (this.progressDialog != null) 
	    	this.progressDialog.setRange(aCurTotalProgress,aMaxTotalProgress);
	    
		return XPCOM.NS_OK;
	}
	
/* nsIWebProgressListener2 */
	// added for xul45
	int OnRefreshAttempted(int /*long*/ aWebProgress, int /*long*/ aRefreshURI, int /*long*/ aMillis, int /*long*/ aSameURI, int /*long*/ retVal) {
	    
		return XPCOM.NS_OK;
	}
}