/*******************************************************************************
 * Copyright (c) 2000, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.rcp.dombrowser.browser;

import java.io.File;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

import com.ibm.rcp.dombrowser.internal.DOMBrowserNLS;
import com.ibm.rcp.dombrowser.internal.DownloadHelper;
import com.ibm.rcp.dombrowser.internal.mozilla.XPCOM;
import com.ibm.rcp.dombrowser.internal.mozilla.XPCOMObject;
import com.ibm.rcp.dombrowser.internal.mozilla.nsEmbedString;
import com.ibm.rcp.dombrowser.internal.mozilla.nsID;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIDocShell;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIHelperAppLauncher;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIHelperAppLauncherDialog;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIInterfaceRequestor;
import com.ibm.rcp.dombrowser.internal.mozilla.nsISupports;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIURI;

class HelperAppLauncherDialog {
	
	public static final nsID NS_HELPERAPPLAUNCHERDIALOG_CID = new nsID("f68578eb-6ec2-4169-ae19-8c6243f0abe2"); //$NON-NLS-1$
	public static final String NS_HELPERAPPLAUNCHERDIALOG_CONTRACTID = "@mozilla.org/helperapplauncherdialog;1"; //$NON-NLS-1$
	
	XPCOMObject supports;
	XPCOMObject helperAppLauncherDialog;
	DOMMozillaBrowser browser;
	int refCount = 0;	
	FileDownloadListener[] fileDownloadListeners = null;
	FileDownloadEvent fileDownloadEvent = new FileDownloadEvent(this);
	
	private String PKG_Name=HelperAppLauncherDialog.class.getPackage().getName();
	private String CLZ_Name=HelperAppLauncherDialog.class.getName();
	private Logger logger=Logger.getLogger(PKG_Name);

public HelperAppLauncherDialog () {
	createCOMInterfaces ();
}

int AddRef () {
	refCount++;
	return refCount;
}

void createCOMInterfaces () {
	/* Create each of the interfaces that this object implements */
	supports = new XPCOMObject (new int[] {2, 0, 0}) {
		public int /*long*/ method0 (int /*long*/[] args) {return QueryInterface (args[0], args[1]);}
		public int /*long*/ method1 (int /*long*/[] args) {return AddRef ();}
		public int /*long*/ method2 (int /*long*/[] args) {return Release ();}
	};
	
	helperAppLauncherDialog = new XPCOMObject (new int[] {2, 0, 0, 3, 5}) {
		public int /*long*/ method0 (int /*long*/[] args) {return QueryInterface (args[0], args[1]);}
		public int /*long*/ method1 (int /*long*/[] args) {return AddRef ();}
		public int /*long*/ method2 (int /*long*/[] args) {return Release ();}
		public int /*long*/ method3 (int /*long*/[] args) {return Show (args[0], args[1], args[2]);}
		public int /*long*/ method4 (int /*long*/[] args) {return PromptForSaveToFile (args[0], args[1], args[2], args[3], (int)/*64*/args[4]);}
	};		
}

void disposeCOMInterfaces () {
	if (supports != null) {
		supports.dispose ();
		supports = null;
	}	
	if (helperAppLauncherDialog != null) {
		helperAppLauncherDialog.dispose ();
		helperAppLauncherDialog = null;	
	}
}

int /*long*/ getAddress () {
	return helperAppLauncherDialog.getAddress ();
}

int /*long*/ QueryInterface (int /*long*/ riid, int /*long*/ ppvObject) {
	if (riid == 0 || ppvObject == 0) return XPCOM.NS_ERROR_NO_INTERFACE;
	nsID guid = new nsID ();
	XPCOM.memmove (guid, riid, nsID.sizeof);
	
	if (guid.Equals (nsISupports.NS_ISUPPORTS_IID)) {
		XPCOM.memmove (ppvObject, new int /*long*/[] {supports.getAddress ()}, MozillaBrowser.PTR_SIZEOF);
		AddRef ();
		return XPCOM.NS_OK;
	}
	if (guid.Equals (nsIHelperAppLauncherDialog.NS_IHELPERAPPLAUNCHERDIALOG_IID)) {
		XPCOM.memmove (ppvObject, new int /*long*/[] {helperAppLauncherDialog.getAddress ()}, MozillaBrowser.PTR_SIZEOF);
		AddRef ();
		return XPCOM.NS_OK;
	}
	
	XPCOM.memmove (ppvObject, new int /*long*/[] {0}, MozillaBrowser.PTR_SIZEOF);
	return XPCOM.NS_ERROR_NO_INTERFACE;
}
        	
int Release () {
	refCount--;
	/*
	* Note.  This instance lives as long as the download it is binded to.
	* Its reference count is expected to go down to 0 when the download
	* has completed or when it has been cancelled. E.g. when the user
	* cancels the File Dialog, cancels or closes the Download Dialog
	* and when the Download Dialog goes away after the download is completed.
	*/
	if (refCount == 0) disposeCOMInterfaces ();
	return refCount;
}

/* nsIHelperAppLauncherDialog */

public int /*long*/ Show(int /*long*/ aLauncher, int /*long*/ aContext, int /*long*/ aForced) {
	
	nsISupports supports = new nsISupports(aLauncher);
	int /*long*/[] result = new int /*long*/[1];
	int rc = supports.QueryInterface(nsIHelperAppLauncher.NS_IHELPERAPPLAUNCHER_IID, result);
	if (rc != 0) return rc;
	nsIHelperAppLauncher helperAppLauncher = new nsIHelperAppLauncher(result[0]);
	//Support File Download, Yang Zhi Guo
	nsISupports context = new nsISupports(aContext);
	rc = context.QueryInterface(nsIInterfaceRequestor.NS_IINTERFACEREQUESTOR_IID, result);
	if (rc == 0){
		nsIInterfaceRequestor ir = new nsIInterfaceRequestor(result[0]);
		rc = ir.GetInterface(nsIDocShell.NS_IDOCSHELL_IID, result);			
		if (rc == 0){
			nsIDocShell ds = new nsIDocShell(result[0]);
			browser = DOMBrowser.getBrowserByIDocShellAddress(ds.getAddress());
			if (browser != null){
				fileDownloadListeners = browser.getFileDownloadListeners();					
			}
			ds.Release();
		}
		ir.Release();
	}
	if (fileDownloadListeners != null && fileDownloadListeners.length>0) {
		fileDownloadEvent.setUrl(getSourceURIFullPath(helperAppLauncher));
//		fileDownloadEvent.mimeType = getSourceMIMEInfo(helperLauncher);
		for(int i=0; i<fileDownloadListeners.length; i++){
			fileDownloadListeners[i].handleEvent(fileDownloadEvent);
		}

		if (!fileDownloadEvent.isDoit()) {
			rc = helperAppLauncher.Cancel(XPCOM.NS_ERROR_ABORT);
			if (helperAppLauncher != null){
				helperAppLauncher.Release();
				helperAppLauncher = null;
			}
			return rc;
		}				
	} 
	rc = helperAppLauncher.SaveToDisk(0, 0);
	helperAppLauncher.Release();
	return rc;
}

public int /*long*/ PromptForSaveToFile(int /*long*/ arg0, int /*long*/ arg1, int /*long*/ aDefaultFileName, int /*long*/ aSuggestedFileExtension, int aForcePrompt) {
	String method_Name="PromptForSaveToFile";
	int /*long*/ retval = 0;
	int /*long*/[] result = new int /*long*/[1];
	
	nsISupports support = new nsISupports(arg0);
	int rc = support.QueryInterface(nsIHelperAppLauncher.NS_IHELPERAPPLAUNCHER_IID, result);
	if (rc == 0) {
		nsISupports supports = new nsISupports(result[0]);
		supports.Release();
	}	
	//Support File Download, Yang Zhi Guo
	String fullpath = null;	
	//aForcePrompt = 1;
	if (fileDownloadListeners != null && fileDownloadListeners.length>0){// Control file download
		if (fileDownloadEvent.isDoit()) {
			fullpath = fileDownloadEvent.getPath();
			if (fullpath == null) {
				logger.logp(Level.SEVERE, CLZ_Name, method_Name, DOMBrowserNLS.Error_No_Download_Path);
				nsIHelperAppLauncher launcher = new nsIHelperAppLauncher(arg0);
				rc = launcher.Cancel(XPCOM.NS_BINDING_ABORTED);
				if (rc != XPCOM.NS_OK) {
					logger.logp(Level.INFO, CLZ_Name, method_Name, Integer.toString(rc));
					//DOMBrowser.error(rc);
				}
				return XPCOM.NS_OK;
			}
			
			String directory=findDownloadDirectory(fullpath);
			if(!validateDirectory(directory)){
				return XPCOM.NS_OK;
			}	
			// if path contained '/' on Windows or '\' on Linux platform, download will failed!
			fullpath=convertPathSeparater(fullpath); 
			
			/*
			 *  Check if there's a download to same target is downloading. If yes and the 
			 *  overwritten property is set to true, then thrown an error message out and 
			 *  cancel current download.
			 */
			if(DownloadHelper.hasSameDownload(fullpath) && fileDownloadEvent.isAllowDownloadOverwrite()){
				logger.logp(Level.SEVERE, CLZ_Name, method_Name, 
						NLS.bind(DOMBrowserNLS.Error_Can_Not_Download_To_Same_Path,
								fullpath));
				return XPCOM.NS_OK;
			}
			
			File f = new File(fullpath);
			if (f.exists() && !fileDownloadEvent.isAllowDownloadOverwrite()){
				String fileName = fullpath.substring(fullpath.lastIndexOf(File.separator) + 1);
				String newFileName = fileName.substring(0, fileName.lastIndexOf(".")) + "." + new Date().getTime() + fileName.substring(fileName.lastIndexOf("."));
				fullpath = fullpath.substring(0,fullpath.lastIndexOf(File.separator) +1) + newFileName;
			}
		}
	} else if (aForcePrompt !=0) { // force set aForcePrompt to 1, to avoid save dialog
		String directory=findDownloadDirectory(fullpath);
		if(!validateDirectory(directory)){
			return XPCOM.NS_OK;
		}	
		// if path contained '/' on Windows or '\' on Linux platform, download will failed!
		fullpath=convertPathSeparater(fullpath);
		
		File f = new File(fullpath);
		if (f.exists()){
			String fileName = fullpath.substring(fullpath.lastIndexOf(File.separator) + 1);
			String newFileName = fileName.substring(0, fileName.lastIndexOf(".")) + "." + new Date().getTime() + fileName.substring(fileName.lastIndexOf("."));
			fullpath = fullpath.substring(0,fullpath.lastIndexOf(File.separator) +1) + newFileName;
		}
	} else { // Default file download
		int length = XPCOM.strlen_PRUnichar(aDefaultFileName);
		char[] dest = new char[length];
		XPCOM.memmove(dest, aDefaultFileName, length * 2);
		String defaultFile = new String(dest);

		length = XPCOM.strlen_PRUnichar(aSuggestedFileExtension);
		dest = new char[length];
		XPCOM.memmove(dest, aSuggestedFileExtension, length * 2);
		String suggestedFileExtension = new String(dest);

		Shell shell = new Shell();
		FileDialog fileDialog = new FileDialog(shell, SWT.SAVE);
		
		fileDialog.setOverwrite(true);
		
		fileDialog.setFileName(defaultFile);
		fileDialog.setFilterExtensions(new String[] {"*"+suggestedFileExtension});
		String name = fileDialog.open();
		shell.close();
		if (name == null) {
			return XPCOM.NS_OK;
		}
		fullpath = name;
	}
	
	/*
	 *  Check if there's a download to same target is downloading. If have, then set a 
	 *  new name to current download, new name format is: current name + current time stamp.
	 */
	if(DownloadHelper.hasSameDownload(fullpath)){
		// add timestamp to file name
		String fileName = fullpath.substring(fullpath.lastIndexOf(File.separator) + 1);
		String newFileName = fileName.substring(0, fileName.lastIndexOf(".")) + "." + new Date().getTime() + fileName.substring(fileName.lastIndexOf("."));
		fullpath = fullpath.substring(0,fullpath.lastIndexOf(File.separator) +1) + newFileName;
	}
	
	nsEmbedString path = new nsEmbedString(fullpath);
	rc = XPCOM.NS_NewLocalFile(path.getAddress(), true, result);
	path.dispose();
	if (rc != XPCOM.NS_OK) DOMBrowser.error(rc);
	if (result[0] == 0) DOMBrowser.error(XPCOM.NS_ERROR_NULL_POINTER);
	/* since xul43 expilcit call to pass file path to nsIHelperAppLauncher.saveDestination */
	nsIHelperAppLauncher launcher = new nsIHelperAppLauncher(arg0);
	launcher.SaveDestinationAvailable(result[0]);
	//XPCOM.memmove(retval, result, MozillaBrowser.PTR_SIZEOF);	
	return XPCOM.NS_OK;
}

private String findDownloadDirectory(String filePath){
	if(filePath==null){
		return filePath;
	}
	String path=filePath.substring(0, filePath.lastIndexOf(File.separator));
	return path;
}
private boolean validateDirectory(String directory){
	String method_Name="validateDirectory";
	if(directory==null){
		return false;
	}
	File file=new File(directory);
	if(!file.exists()){
		logger.logp(Level.SEVERE, CLZ_Name, method_Name, 
				NLS.bind(DOMBrowserNLS.Error_DownloadPath_Not_Exist,
						directory));
		return false;
	}
	if(!file.canWrite()){
		logger.logp(Level.SEVERE, CLZ_Name, method_Name, 
				NLS.bind(DOMBrowserNLS.Error_DownloadPath_No_Write_Access,
						directory));
		return false;
	}
	return true;
}
private String convertPathSeparater(String path){
	if(path==null){
		return null;
	}
	File file=new File(path);
	return file.getAbsolutePath();
}
//Support File Download, Yang Zhi Guo
/*private String getSourceMIMEInfo(nsIHelperAppLauncher aHelperLauncher){
	int aMIMEInfo[] = new int[1];
	aHelperLauncher.GetMIMEInfo(aMIMEInfo);
	nsIMIMEInfo IMIMEInfo = new nsIMIMEInfo(aMIMEInfo[0]);
	int aMIMEInfoSpec[] = new int[1];
	IMIMEInfo.GetMIMEType(aMIMEInfoSpec[0]);
	int length = 100;
	byte[] destMIMEType = new byte[length];
	XPCOM.memmove(destMIMEType, aMIMEInfoSpec[0], length);
	String MIMEType = new String(destMIMEType);
	return MIMEType.substring(0, MIMEType.indexOf('\0'));
}*/

private String getSourceURIFullPath(nsIHelperAppLauncher aHelperLauncher){
	int /*long*/ source[] = new int /*long*/[1];
	aHelperLauncher.GetSource(source);
	nsIURI sourceURI = new nsIURI(source[0]);

	int /*long*/ aSpecPath = XPCOM.nsEmbedCString_new();
	sourceURI.GetPrePath(aSpecPath);
	int lengthPrePath = XPCOM.nsEmbedCString_Length(aSpecPath);
	int /*long*/ bufferPrePath = XPCOM.nsEmbedCString_get(aSpecPath);
	byte[] destPrePath = new byte[lengthPrePath];
	XPCOM.memmove(destPrePath, bufferPrePath, lengthPrePath);
	XPCOM.nsEmbedCString_delete(aSpecPath);
	String prePath = new String(destPrePath);

	int /*long*/ aPath = XPCOM.nsEmbedCString_new();
	sourceURI.GetPath(aPath);
	int lengthPath = XPCOM.nsEmbedCString_Length(aPath);
	int /*long*/ bufferPath = XPCOM.nsEmbedCString_get(aPath);
	byte[] destPath = new byte[lengthPath];
	XPCOM.memmove(destPath, bufferPath, lengthPath);
	XPCOM.nsEmbedCString_delete(aPath);
	String path = new String(destPath);
	return prePath + path;
}





}
