/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.rcp.dombrowser.browser;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.*;

import com.ibm.rcp.dombrowser.internal.mozilla.*;
import com.ibm.rcp.dombrowser.support.*;

class FilePicker {
	private static final String CLASS_NAME = FilePicker.class.getName();
	private static final String PKG = FilePicker.class.getPackage().getName();
	private static Logger logger = Logger.getLogger(PKG);
	XPCOMObject supports;
	XPCOMObject filePicker;

	int refCount = 0;

	int mode;
	int /*long*/ parentHandle;
	String[] files, masks;
	String defaultFilename, directory, title;
	private int /*long*/ parent;

	static final String SEPARATOR = System.getProperty ("file.separator"); //$NON-NLS-1$
	
	public FilePicker () {
		createCOMInterfaces ();
	}
	
	int AddRef () {
		refCount++;
		return refCount;
	}
	
	void createCOMInterfaces () {
		/* Create each of the interfaces that this object implements */
		supports = new XPCOMObject (new int[] {2, 0, 0}){
			public int /*long*/ method0 (int /*long*/[] args) {return queryInterface(args [0], args [1]);}
			public int /*long*/ method1 (int /*long*/[] args) {return AddRef ();}
			public int /*long*/ method2 (int /*long*/[] args) {return Release ();}
		};
	
		filePicker = new XPCOMObject (new int[] {2, 0, 0, 3, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}) {
			public int /*long*/ method0 (int /*long*/[] args) {return queryInterface (args [0], args [1]);}
			public int /*long*/ method1 (int /*long*/[] args) {return AddRef ();}
			public int /*long*/ method2 (int /*long*/[] args) {return Release ();}
			public int /*long*/ method3 (int /*long*/[] args) {return Init (args [0], args [1], args [2]);}
			public int /*long*/ method4 (int /*long*/[] args) {return AppendFilters (args [0]);}
			public int /*long*/ method5 (int /*long*/[] args) {return AppendFilter (args [0], args [1]);}
			public int /*long*/ method6 (int /*long*/[] args) {return GetDefaultString (args [0]);}
			public int /*long*/ method7 (int /*long*/[] args) {return SetDefaultString (args [0]);}
			public int /*long*/ method8 (int /*long*/[] args) {return GetDefaultExtension (args [0]);}
			public int /*long*/ method9 (int /*long*/[] args) {return SetDefaultExtension (args [0]);}
			public int /*long*/ method10 (int /*long*/[] args) {return GetFilterIndex (args [0]);}
			public int /*long*/ method11 (int /*long*/[] args) {return SetFilterIndex (args [0]);}
			public int /*long*/ method12 (int /*long*/[] args) {return GetDisplayDirectory (args [0]);}
			public int /*long*/ method13 (int /*long*/[] args) {return SetDisplayDirectory (args [0]);}
			public int /*long*/ method14 (int /*long*/[] args) {return GetFile (args [0]);}
			public int /*long*/ method15 (int /*long*/[] args) {return GetFileURL (args [0]);}			
			public int /*long*/ method16 (int /*long*/[] args) {return GetFiles (args [0]);}
			public int /*long*/ method17 (int /*long*/[] args) {return GetDomFile (args [0]);}
			public int /*long*/ method18 (int /*long*/[] args) {return GetDomFiles (args [0]);}
			public int /*long*/ method19 (int /*long*/[] args) {return GetAddToRecentDocs(args [0]);}
			public int /*long*/ method20 (int /*long*/[] args) {return SetAddToRecentDocs(args [0]);}
			public int /*long*/ method21 (int /*long*/[] args) {return Show (args[0]);}
			public int /*long*/ method22 (int /*long*/[] args) {return Open (args[0]);}
			public int /*long*/ method23 (int /*long*/[] args) {return GetMode (args[0]);}
		};
	}
	
	void disposeCOMInterfaces () {
		if (supports != null) {
			supports.dispose ();
			supports = null;
		}	
		if (filePicker != null) {
			filePicker.dispose ();
			filePicker = null;	
		}
	}
	
	int /*long*/ getAddress () {
		return filePicker.getAddress ();
	}
	
	int /*long*/ queryInterface (int /*long*/ riid, int /*long*/ ppvObject) {
		if (riid == 0 || ppvObject == 0) return XPCOM.NS_ERROR_NO_INTERFACE;
		nsID guid = new nsID ();
		XPCOM.memmove (guid, riid, nsID.sizeof);
	
		if (guid.Equals (nsISupports.NS_ISUPPORTS_IID)) {
			XPCOM.memmove (ppvObject, new int /*long*/[] {supports.getAddress ()}, XPCOMObject.PTR_SIZEOF);
			AddRef ();
			return XPCOM.NS_OK;
		}
		if (guid.Equals (nsIFilePicker.NS_IFILEPICKER_IID)) {
			XPCOM.memmove(ppvObject, new int /*long*/[] {filePicker.getAddress ()}, XPCOMObject.PTR_SIZEOF);
			AddRef ();
			return XPCOM.NS_OK;
		}
		XPCOM.memmove (ppvObject, new int /*long*/[] {0}, XPCOMObject.PTR_SIZEOF);
		return XPCOM.NS_ERROR_NO_INTERFACE;
	}
	
	int Release () {
		refCount--;
		if (refCount == 0) disposeCOMInterfaces ();
		return refCount;
	}
	
	/* nsIFilePicker */
	
	int /*long*/ Init (int /*long*/ parent, int /*long*/ title, int /*long*/ mode) {
		this.parent = parent;
		int /*long*/[] handle = new int /*long*/[1];	
		int rc = getHandleFromDOMWindow(parent,handle);
		if (rc != XPCOM.NS_OK)
			return rc;
		
		this.parentHandle = handle[0];
		this.mode = (int)/*64*/mode;
	//	this.title = WString.toString(title);

		if(title != 0){
		int length = XPCOM.nsEmbedString_Length (title);
			int /*long*/ buffer = XPCOM.nsEmbedString_get (title);
			char[] chars = new char[length];
			XPCOM.memmove (chars, buffer, length * 2);
			
			this.title = new String(chars);
		}

		return XPCOM.NS_OK;
	}
	
	int /*long*/ Open (int /*long*/ aFilePickerShownCallback) {
		if (mode == nsIFilePicker.modeGetFolder) {
			/* picking a directory */
			int result = showDirectoryPicker();
			if (aFilePickerShownCallback != 0) {
				new nsIFilePickerShownCallback(aFilePickerShownCallback).Done((short) result);
			}
			return XPCOM.NS_OK;
		}
	
		/* picking a file */
		int style = mode == nsIFilePicker.modeSave ? SWT.SAVE : SWT.OPEN;
		if (mode == nsIFilePicker.modeOpenMultiple) style |= SWT.MULTI;
		Shell parent = null;
		try {
			if (parentHandle != 0) 
				parent = NativeBrowser.newShell(Display.getCurrent (), parentHandle);
			else 
				parent = new Shell (Display.getCurrent ());
		}
		catch (Exception e) {
			logger.logp(Level.WARNING, CLASS_NAME, "Show", //$NON-NLS-1$
					"Exception from FilePicker", e);  //$NON-NLS-1$
			return XPCOM.NS_ERROR_UNEXPECTED;
		}
		FileDialog dialog = new FileDialog (parent, style);
		if (title != null) dialog.setText (title);
		if (directory != null) dialog.setFilterPath (directory);
		if (masks != null) dialog.setFilterExtensions (masks);
		if (defaultFilename != null) dialog.setFileName (defaultFilename);
		String filename = dialog.open ();
		files = dialog.getFileNames ();
		directory = dialog.getFilterPath ();
		title = defaultFilename = null;
		masks = null;
		int result = filename == null ? nsIFilePicker.returnCancel : nsIFilePicker.returnOK; 
		if (aFilePickerShownCallback != 0) {
			new nsIFilePickerShownCallback(aFilePickerShownCallback).Done((short) result);
		}
		return XPCOM.NS_OK;
	}
	
	int showDirectoryPicker () {
		Shell parent = null;
		try {
			if (parentHandle != 0) 
				parent = NativeBrowser.newShell(Display.getCurrent (), parentHandle);
			else 
				parent = new Shell (Display.getCurrent ());
		}
		catch (Exception e) {
			logger.logp(Level.WARNING, CLASS_NAME, "showDirectoryPicker", //$NON-NLS-1$
					"Exception from FilePicker", e);  //$NON-NLS-1$
			return XPCOM.NS_ERROR_UNEXPECTED;
		}
		DirectoryDialog dialog = new DirectoryDialog (parent, SWT.NONE);
		if (title != null) dialog.setText (title);
		if (directory != null) dialog.setFilterPath (directory);
		directory = dialog.open ();
		title = defaultFilename = null;
		files = masks = null;
		return directory == null ? nsIFilePicker.returnCancel : nsIFilePicker.returnOK;
	}
	
	int /*long*/ GetFiles (int /*long*/ aFiles) {
		return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
	}
	
	int /*long*/ GetDomFiles (int /*long*/ aFiles) {
		return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
	}
	
	int /*long*/ GetDomFile (int /*long*/ aFile) {
		nsIDOMWindow window = new nsIDOMWindow(this.parent);
		int /*long*/[] result = new int /*long*/[1];
		window.QueryInterface(nsIInterfaceRequestor.NS_IINTERFACEREQUESTOR_IID, result);
		window.Release();
		nsIInterfaceRequestor requester = new nsIInterfaceRequestor(result[0]);
		result[0]=0;
		requester.GetInterface(nsIDOMWindowUtils.NS_IDOMWINDOWUTILS_IID, result);
		requester.Release();
		nsIDOMWindowUtils windowUtils = new nsIDOMWindowUtils(result[0]);
	
		String filename = ""; //$NON-NLS-1$
		if (directory != null)
			filename += directory + SEPARATOR;
		if (files != null && files.length > 0)
			filename += files[0];
		nsEmbedString path = new nsEmbedString(filename);
		int /*long*/[] file = new int /*long*/[1];
		int rc = XPCOM.NS_NewLocalFile(path.getAddress(), true, file);
		path.dispose();
		if (rc != XPCOM.NS_OK)
			MozillaBrowser.error(rc);
		if (file[0] == 0)
			MozillaBrowser.error(XPCOM.NS_ERROR_NULL_POINTER);
		nsILocalFile localFile = new nsILocalFile(file[0]);
		file[0] = 0;
		rc = localFile.QueryInterface(nsIFile.NS_IFILE_IID, file);
		if (rc != XPCOM.NS_OK)
			MozillaBrowser.error(rc);
		if (file[0] == 0)
			MozillaBrowser.error(XPCOM.NS_ERROR_NULL_POINTER);
		int /*long*/[] retVal = new int /*long*/[1];
		windowUtils.WrapDOMFile(file[0], retVal);
		windowUtils.Release();
		XPCOM.memmove(aFile, new int /*long*/[] { retVal[0] }, XPCOMObject.PTR_SIZEOF);
		localFile.Release();
		return XPCOM.NS_OK;
	}
	
	int /*long*/ Show (int /*long*/ _retval) {
		return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
	}
	
	int /*long*/ GetMode (int /*long*/ mode) {
		return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
	}
	
	int /*long*/ GetFileURL (int /*long*/ aFileURL) {
		return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
	}
	
	int /*long*/ GetFile (int /*long*/ aFile) {
		String filename = "";	//$NON-NLS-1$
		if (directory != null) filename += directory + SEPARATOR;
		if (files != null && files.length > 0) filename += files [0];
		nsEmbedString path = new nsEmbedString (filename);
		int /*long*/[] file = new int /*long*/[1];
		int rc = XPCOM.NS_NewLocalFile (path.getAddress (), true, file);
		path.dispose ();
		if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
		if (file [0] == 0) MozillaBrowser.error (XPCOM.NS_ERROR_NULL_POINTER);
		XPCOM.memmove (aFile, file, XPCOMObject.PTR_SIZEOF);
		return XPCOM.NS_OK;
	}
	
	int /*long*/ SetDisplayDirectory (int /*long*/ aDisplayDirectory) {
		if (aDisplayDirectory == 0) return XPCOM.NS_OK;
		nsILocalFile file = new nsILocalFile (aDisplayDirectory);
		nsEmbedCString pathname = new nsEmbedCString();
		file.GetNativePath (pathname.getAddress());
		directory = pathname.mbcsToWcs();
		pathname.dispose();
		return XPCOM.NS_OK;
	}
	
	int /*long*/ GetDisplayDirectory (int /*long*/ aDisplayDirectory) {
		String directoryName = directory != null ? directory : "";	//$NON-NLS-1$
		nsEmbedString path = new nsEmbedString (directoryName);
		int /*long*/[] file = new int /*long*/[1];
		int rc = XPCOM.NS_NewLocalFile (path.getAddress (), true, file);
		path.dispose ();
		if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
		if (file [0] == 0) MozillaBrowser.error (XPCOM.NS_ERROR_NULL_POINTER);
		XPCOM.memmove (aDisplayDirectory, file, XPCOMObject.PTR_SIZEOF);
		return XPCOM.NS_OK;
	}
	
	int /*long*/ SetFilterIndex (int /*long*/ aFilterIndex) {
		return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
	}
	
	int /*long*/ GetFilterIndex (int /*long*/ aFilterIndex) {
		return XPCOM.NS_OK;
	}
	
	int /*long*/ SetDefaultExtension (int /*long*/ aDefaultExtension) {
		return XPCOM.NS_OK;
	}
	
	int /*long*/ GetDefaultExtension (int /*long*/ aDefaultExtension) {
		return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
	}
	
	int /*long*/ GetAddToRecentDocs(int /*long*/ addToRecentDocs) {
		return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
	}

	int /*long*/ SetAddToRecentDocs(int /*long*/ addToRecentDocs) {
		return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
	}
	
	int /*long*/ SetDefaultString (int /*long*/ aDefaultString) {
		int length = XPCOM.nsEmbedString_Length (aDefaultString);
		int /*long*/ buffer = XPCOM.nsEmbedString_get (aDefaultString);
		char[] chars = new char[length];
		XPCOM.memmove (chars, buffer, length * 2);
		this.defaultFilename = new String(chars);
		
		return XPCOM.NS_OK;
	}
	
	int /*long*/ GetDefaultString (int /*long*/ aDefaultString) {
		return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
	}
	
	int /*long*/ AppendFilter (int /*long*/ title, int /*long*/ filter) {
		return XPCOM.NS_OK;
	}
	
	int /*long*/ AppendFilters (int /*long*/ filterMask) {
		String[] addFilters = null;
		switch ((int)/*64*/filterMask) {
			case nsIFilePicker.filterAll:
			case nsIFilePicker.filterApps:
				masks = null;			/* this is equivalent to no filter */
				break;
			case nsIFilePicker.filterHTML:
				addFilters = new String[] {"*.htm;*.html"}; //$NON-NLS-1$
				break;
			case nsIFilePicker.filterImages:
				addFilters = new String[] {"*.gif;*.jpeg;*.jpg;*.png"};	//$NON-NLS-1$
				break;
			case nsIFilePicker.filterText:
				addFilters = new String[] {"*.txt"};	//$NON-NLS-1$
				break;
			case nsIFilePicker.filterXML:
				addFilters = new String[] {"*.xml"};	//$NON-NLS-1$
				break;
			case nsIFilePicker.filterXUL:
				addFilters = new String[] {"*.xul"};	//$NON-NLS-1$
				break;
		}
		if (masks == null) {
			masks = addFilters;
		} else {
			if (addFilters != null) {
				String[] newFilters = new String [masks.length + addFilters.length];
				System.arraycopy (masks, 0, newFilters, 0, masks.length);
				System.arraycopy (addFilters, 0, newFilters, masks.length, addFilters.length);
				masks = newFilters;
			}
		}
		return XPCOM.NS_OK;
	}
	
	static private int getHandleFromDOMWindow(int /*long*/ aDOMWindow,int /*long*/[] handle) {
		handle[0] = 0;
		if (aDOMWindow == 0)
			return XPCOM.NS_ERROR_NULL_POINTER;
		
		nsIDOMWindow window = new nsIDOMWindow(aDOMWindow);
		int /*long*/[] result = new int /*long*/[1];
		int rc = window.GetTop(result);
		if (rc != XPCOM.NS_OK) 
			return rc;
		
		if (result[0] == 0) 
			return XPCOM.NS_NOINTERFACE;
		
		nsIDOMWindow topWindow = new nsIDOMWindow(result[0]);
		
		result[0] = 0;
		rc = XPCOM.NS_GetServiceManager(result);
		if (rc != XPCOM.NS_OK) {
			topWindow.Release();
			return rc;
		}	
		
		if (result[0] == 0) {
			topWindow.Release();
			return XPCOM.NS_NOINTERFACE;
		}	
				
		nsIServiceManager serviceManager = new nsIServiceManager(result[0]);
		result[0] = 0;
		byte[] buffer = XPCOM.NS_WINDOWWATCHER_CONTRACTID.getBytes();
		byte[] aContractID = new byte[buffer.length + 1];
		System.arraycopy(buffer, 0, aContractID, 0, buffer.length);
		rc = serviceManager.GetServiceByContractID(aContractID, nsIWindowWatcher.NS_IWINDOWWATCHER_IID, result);
		serviceManager.Release();
		if (rc != XPCOM.NS_OK) {
			topWindow.Release();
			return rc;
		}	
		
		if (result[0] == 0) {
			topWindow.Release();
			return XPCOM.NS_NOINTERFACE;
		}		
		
		nsIWindowWatcher windowWatcher = new nsIWindowWatcher(result[0]);
		result[0] = 0;
		rc = windowWatcher.GetChromeForWindow(topWindow.getAddress(), result);
		topWindow.Release();
		windowWatcher.Release();	
		if (rc != XPCOM.NS_OK) 
			return rc;
		
		if (result[0] == 0) 
			return XPCOM.NS_NOINTERFACE;	
				
		nsIWebBrowserChrome webBrowserChrome = new nsIWebBrowserChrome(result[0]);
		result[0] = 0;
		rc = webBrowserChrome.QueryInterface(nsIEmbeddingSiteWindow.NS_IEMBEDDINGSITEWINDOW_IID, result);
		webBrowserChrome.Release();
		if (rc != XPCOM.NS_OK) 
			return rc;
		
		if (result[0] == 0) 
			return XPCOM.NS_NOINTERFACE;		
				
		nsIEmbeddingSiteWindow embeddingSiteWindow = new nsIEmbeddingSiteWindow(result[0]);
		result[0] = 0;
		rc = embeddingSiteWindow.GetSiteWindow(result);
		embeddingSiteWindow.Release();
		if (rc != XPCOM.NS_OK) 
			return rc;
		
		if (result[0] == 0) 
			return XPCOM.NS_NOINTERFACE;
		
		handle[0] = result[0]; 
		return rc;
	}
}
