/*******************************************************************************
 * Copyright (c) 2000, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.rcp.dombrowser.browser;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.osgi.framework.Bundle;

import com.ibm.rcp.dombrowser.internal.NativeLoaderProxy;
import com.ibm.rcp.dombrowser.internal.mozilla.XPCOM;
import com.ibm.rcp.dombrowser.internal.mozilla.XPCOMObject;
import com.ibm.rcp.dombrowser.internal.mozilla.nsEmbedString;
import com.ibm.rcp.dombrowser.internal.mozilla.nsID;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIDirectoryServiceProvider;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIDirectoryServiceProvider2;
import com.ibm.rcp.dombrowser.internal.mozilla.nsIFile;
import com.ibm.rcp.dombrowser.internal.mozilla.nsILocalFile;
import com.ibm.rcp.dombrowser.internal.mozilla.nsISupports;

class AppFileLocProvider {
	XPCOMObject supports;
	XPCOMObject directoryServiceProvider;
	XPCOMObject directoryServiceProvider2;	
	int refCount = 0;	
	String mozillaPath, profilePath;
	String[] pluginDirs;
	String[] chromeDirs;
	
	static final String SEPARATOR_OS = System.getProperty ("file.separator"); //$NON-NLS-1$
	static final String CHROME_DIR = "chrome"; //$NON-NLS-1$
	static final String LOCAL_DIR = "local"; //$NON-NLS-1$
	static final String COMPONENTS_DIR = "components"; //$NON-NLS-1$
	static final String HISTORY_FILE = "history.dat"; //$NON-NLS-1$
	static final String LOCALSTORE_FILE = "localstore.rdf"; //$NON-NLS-1$
	static final String MIMETYPES_FILE = "mimeTypes.rdf"; //$NON-NLS-1$
	static final String PLUGINS_DIR = "plugins"; //$NON-NLS-1$
	static final String USER_PLUGINS_DIR = ".mozilla" + SEPARATOR_OS + "plugins"; //$NON-NLS-1$ //$NON-NLS-2$
	static final String PREFERENCES_FILE = "prefs.js"; //$NON-NLS-1$
	static final String REGISTERED_COMPONENTS_FILE = "compreg.dat"; //$NON-NLS-1$
	static final String REGISTERED_INTERFACES_FILE = "xpti.dat"; //$NON-NLS-1$
	private static String NLbundleName="com.ibm.rcp.xulrunner.runtime.nl";//$NON-NLS-1$

	private static String PKG_Name=AppFileLocProvider.class.getPackage().getName();
	private static Logger logger=Logger.getLogger(PKG_Name);
	
	
	public AppFileLocProvider(String path) {
		mozillaPath = path + SEPARATOR_OS;
		if (mozillaPath == null) MozillaBrowser.error(XPCOM.NS_ERROR_FAILURE);	
		createCOMInterfaces();
	}
	
	int AddRef() {
		refCount++;
		return refCount;
	}
	
	void createCOMInterfaces() {
		/* Create each of the interfaces that this object implements */
		supports = new XPCOMObject(new int[]{2, 0, 0}){
			public int /*long*/ method0(int /*long*/[] args) {return queryInterface(args[0], args[1]);}
			public int /*long*/ method1(int /*long*/[] args) {return AddRef();}
			public int /*long*/ method2(int /*long*/[] args) {return Release();}
		};
		
		directoryServiceProvider = new XPCOMObject(new int[]{2, 0, 0, 3}){
			public int /*long*/ method0(int /*long*/[] args) {return queryInterface(args[0], args[1]);}
			public int /*long*/ method1(int /*long*/[] args) {return AddRef();}
			public int /*long*/ method2(int /*long*/[] args) {return Release();}
			public int /*long*/ method3(int /*long*/[] args) {return getFile(args[0], args[1], args[2]);}
		};
			
		directoryServiceProvider2 = new XPCOMObject(new int[]{2, 0, 0, 3, 2}){
			public int /*long*/ method0(int /*long*/[] args) {return queryInterface(args[0], args[1]);}
			public int /*long*/ method1(int /*long*/[] args) {return AddRef();}
			public int /*long*/ method2(int /*long*/[] args) {return Release();}
			public int /*long*/ method3(int /*long*/[] args) {return getFile(args[0], args[1], args[2]);}
			public int /*long*/ method4(int /*long*/[] args) {return getFiles(args[0], args[1]);}
		};
	}
	
	void disposeCOMInterfaces() {
		if (supports != null) {
			supports.dispose();
			supports = null;
		}	
		if (directoryServiceProvider != null) {
			directoryServiceProvider.dispose();
			directoryServiceProvider = null;	
		}
		if (directoryServiceProvider2 != null) {
			directoryServiceProvider2.dispose();
			directoryServiceProvider2 = null;	
		}	
	}
	
	int /*long*/ getAddress() {
		return directoryServiceProvider.getAddress();
	}
	
	int queryInterface(int /*long*/ riid, int /*long*/ ppvObject) {
		if (riid == 0 || ppvObject == 0) return XPCOM.NS_ERROR_NO_INTERFACE;
		nsID guid = new nsID();
		XPCOM.memmove(guid, riid, nsID.sizeof);
		
		if (guid.Equals(nsISupports.NS_ISUPPORTS_IID)) {
			XPCOM.memmove(ppvObject, new int /*long*/[] {supports.getAddress()}, XPCOMObject.PTR_SIZEOF);
			AddRef();
			return XPCOM.NS_OK;
		}
		if (guid.Equals(nsIDirectoryServiceProvider.NS_IDIRECTORYSERVICEPROVIDER_IID)) {
			XPCOM.memmove(ppvObject, new int /*long*/[] {directoryServiceProvider.getAddress()}, XPCOMObject.PTR_SIZEOF);
			AddRef();
			return XPCOM.NS_OK;
		}
		if (guid.Equals(nsIDirectoryServiceProvider2.NS_IDIRECTORYSERVICEPROVIDER2_IID)) {
			XPCOM.memmove(ppvObject, new int /*long*/[] {directoryServiceProvider2.getAddress()}, XPCOMObject.PTR_SIZEOF);
			AddRef();
			return XPCOM.NS_OK;
		}
		
		XPCOM.memmove(ppvObject, new int[] {0}, XPCOMObject.PTR_SIZEOF);
		return XPCOM.NS_ERROR_NO_INTERFACE;
	}
	        	
	int Release() {
		refCount--;
		if (refCount == 0) disposeCOMInterfaces();
		return refCount;
	}
	
	/* nsIDirectoryServiceProvider implementation */
	int getFile(int /*long*/ prop, int /*long*/ persistent, int /*long*/ _retval) {
		try {
			int size = XPCOM.strlen (prop);
			byte[] bytes = new byte[size];
			XPCOM.memmove (bytes, prop, size);
			String propertyName = new String (Converter.mbcsToWcs (null, bytes));
			logger.log(Level.FINE, "Calling getFile propertyName=" + propertyName);
			String propertyValue = null;

			if (propertyName.equals (XPCOM.NS_APP_HISTORY_50_FILE)&& ( profilePath!=null)) {
				propertyValue = profilePath + HISTORY_FILE;
			} else if (propertyName.equals (XPCOM.NS_APP_USER_MIMETYPES_50_FILE)&& ( profilePath!=null)) {
				propertyValue = profilePath + MIMETYPES_FILE;
			} else if (propertyName.equals (XPCOM.NS_APP_PREFS_50_FILE)&& ( profilePath!=null)) {
				propertyValue = profilePath + PREFERENCES_FILE;
			} else if (propertyName.equals (XPCOM.NS_APP_PREFS_50_DIR)&& ( profilePath!=null)) {
				propertyValue = profilePath;
			} else if (propertyName.equals (XPCOM.NS_APP_USER_CHROME_DIR)&& ( profilePath!=null)) {
				propertyValue = profilePath + CHROME_DIR;
			} else if (propertyName.equals (XPCOM.NS_APP_USER_PROFILE_50_DIR)&& ( profilePath!=null)) {
				propertyValue = profilePath;
			} else if (propertyName.equals (XPCOM.NS_APP_PERMISSION_PARENT_DIR)&& ( profilePath!=null)) {
				propertyValue = profilePath;
			} else if (propertyName.equals (XPCOM.NS_APP_USER_PROFILE_LOCAL_50_DIR)&& ( profilePath!=null)) {
				propertyValue = profilePath + LOCAL_DIR;
			} else if (propertyName.equals (XPCOM.NS_APP_LOCALSTORE_50_FILE)&& ( profilePath!=null)) {
				propertyValue = profilePath + LOCALSTORE_FILE;
			} else if (propertyName.equals (XPCOM.NS_APP_CACHE_PARENT_DIR)&& ( profilePath!=null)) {
				propertyValue = profilePath;
			} else if (propertyName.equals (XPCOM.NS_OS_HOME_DIR)) {
				propertyValue = System.getProperty("user.home");	//$NON-NLS-1$
				propertyValue = translateStringWithEnvironmentSetting(propertyValue);
			} else if (propertyName.equals (XPCOM.NS_OS_TEMP_DIR)) {
				propertyValue = System.getProperty("java.io.tmpdir");	//$NON-NLS-1$
				propertyValue = translateStringWithEnvironmentSetting(propertyValue);
			} else if (propertyName.equals (XPCOM.NS_GRE_DIR)&& ( mozillaPath!=null)) {
				propertyValue = mozillaPath;
			} else if (propertyName.equals (XPCOM.NS_GRE_COMPONENT_DIR)&& ( mozillaPath!=null)) {
				propertyValue = mozillaPath + COMPONENTS_DIR;
			} else if (propertyName.equals (XPCOM.NS_XPCOM_INIT_CURRENT_PROCESS_DIR)&& ( mozillaPath!=null)) {
				propertyValue = mozillaPath;
			} else if (propertyName.equals (XPCOM.NS_OS_CURRENT_PROCESS_DIR)&& ( mozillaPath!=null)) {
				propertyValue = mozillaPath;
			} else if (propertyName.equals (XPCOM.NS_XPCOM_COMPONENT_DIR)&& ( mozillaPath!=null)) {
				propertyValue = profilePath != null ? profilePath + COMPONENTS_DIR : mozillaPath + COMPONENTS_DIR;
			} else if (propertyName.equals (XPCOM.NS_XPCOM_CURRENT_PROCESS_DIR)&& ( mozillaPath!=null)) {
				propertyValue = mozillaPath;
			} else if (propertyName.equals (XPCOM.NS_XPCOM_COMPONENT_REGISTRY_FILE)&& ( profilePath!=null)) {
				propertyValue = profilePath + REGISTERED_COMPONENTS_FILE;
			} else if (propertyName.equals (XPCOM.NS_XPCOM_XPTI_REGISTRY_FILE)&& ( profilePath!=null)) {
				propertyValue = profilePath + REGISTERED_INTERFACES_FILE;
			} else if (propertyName.equals (XPCOM.NS_APP_PLUGIN_SCAN_QUICKTIME)&& ( profilePath!=null)) {
				propertyValue = profilePath + "quicktime.dat";
			} else if (propertyName.equals (XPCOM.NS_APP_PREF_DEFAULTS_50_DIR) && ( profilePath!=null)) {
				propertyValue = profilePath;
			} else if (propertyName.equals (XPCOM.NS_APP_USER_APP_DATA_DIR) && ( profilePath!=null)) {
				propertyValue = profilePath;
			}
			logger.log(Level.FINE, "Calling getFile propertyValue=" + propertyValue);

			// for xul 10.0
			//XPCOM.memmove (persistent, new int[] {1}, 4); /* PRBool */
			XPCOM.memmove (persistent, new int[] {1}, 1); /* bool */
			XPCOM.memmove (_retval, new int /*long*/[] {0}, C.PTR_SIZEOF);
			if (propertyValue != null && propertyValue.length () > 0) {
				int /*long*/[] result = new int /*long*/[1];
				nsEmbedString pathString = new nsEmbedString (propertyValue);
				int rc = XPCOM.NS_NewLocalFile (pathString.getAddress (), true, result);
				if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
				if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_ERROR_NULL_POINTER);
				pathString.dispose ();
				
				nsILocalFile localFile = new nsILocalFile (result [0]);
				result[0] = 0;
			    rc = localFile.QueryInterface (nsIFile.NS_IFILE_IID, result); 
				if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
				if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_ERROR_NULL_POINTER);

				XPCOM.memmove (_retval, new int /*long*/[] {result[0]}, C.PTR_SIZEOF);
				localFile.Release ();
				return XPCOM.NS_OK;
			}
		} catch (Throwable e) {
			logger.log(Level.SEVERE, "exception in callback context", e); //$NON-NLS-1$
		}
	
		return XPCOM.NS_ERROR_FAILURE;
	}
	
	/* nsIDirectoryServiceProvider2 implementation */	
	int getFiles (int /*long*/ prop, int /*long*/ _retval) {
		try {
			int size = XPCOM.strlen (prop);
			byte[] bytes = new byte[size];
			XPCOM.memmove (bytes, prop, size);
			String propertyName = new String (Converter.mbcsToWcs (null, bytes));
			//System.out.println("getFiles propertyName=" + propertyName);
			String[] propertyValues = null;

			if (propertyName.equals(XPCOM.NS_APP_PLUGINS_DIR_LIST)) {

				/* set the next value to the GRE path + "plugins" */
			//	pluginDirs[index++] = mozillaPath + PLUGINS_DIR;

				/* set the next value to the home directory + "/.mozilla/plugins" */
			//	pluginDirs[index++] = System.getProperty("user.home") + SEPARATOR_OS + USER_PLUGINS_DIR;
				
				
				if (pluginDirs == null) {
					try {
						pluginDirs = NativeLoaderProxy.getPlugInPaths();
					} catch (Exception e) {
						// ignore any exceptions here
						logger.log(Level.WARNING, "exception in callback context", e); //$NON-NLS-1$
					}
				}

				propertyValues = pluginDirs;
			}
			
			if(propertyName.equals(XPCOM.NS_APP_CHROME_DIRS)){
				propertyValues = getChromePaths();
					
			}

			XPCOM.memmove(_retval, new int /*long*/[] {0}, C.PTR_SIZEOF);
			if (propertyValues != null) {
				int /*long*/[] result = new int /*long*/[1];
				nsISupports[] files = new nsISupports [propertyValues.length];
				for (int i = 0; i < propertyValues.length; i++) {
					nsEmbedString pathString = new nsEmbedString (propertyValues[i]);
					int rc = XPCOM.NS_NewLocalFile (pathString.getAddress (), true, result);
					if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
					if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_ERROR_NULL_POINTER);
					pathString.dispose ();

					nsILocalFile localFile = new nsILocalFile (result[0]);
					result[0] = 0;
				    rc = localFile.QueryInterface (nsIFile.NS_IFILE_IID, result); 
					if (rc != XPCOM.NS_OK) MozillaBrowser.error (rc);
					if (result[0] == 0) MozillaBrowser.error (XPCOM.NS_ERROR_NULL_POINTER);
					localFile.Release ();

					nsIFile file = new nsIFile (result[0]);
					result[0] = 0;
					files[i] = file;
				}

				SingletonEnumerator enumerator = new SingletonEnumerator (files);
				enumerator.AddRef ();

				XPCOM.memmove (_retval, new int /*long*/[] {enumerator.getAddress ()}, C.PTR_SIZEOF);
				return XPCOM.NS_OK;
			}
		} catch (Throwable e) {
			logger.log(Level.SEVERE, "exception in callback context", e); //$NON-NLS-1$
		}

		return XPCOM.NS_ERROR_FAILURE;
	}	
	
	void setProfilePath (String path) {
		if(path==null || path.length()==0){
			return;
		}
		profilePath = path;
		if (!Compatibility.fileExists (path, "")) { //$NON-NLS-1$
			int /*long*/[] result = new int /*long*/[1];
			nsEmbedString pathString = new nsEmbedString (path);
			int rc = XPCOM.NS_NewLocalFile (pathString.getAddress (), false, result);
			if (rc != XPCOM.NS_OK){
				//MozillaBrowser.error (rc);
				return;
			} 
			if (result[0] == 0){
				//MozillaBrowser.error (XPCOM.NS_ERROR_NULL_POINTER);
				return;
			}
			pathString.dispose ();

			nsILocalFile file = new nsILocalFile (result [0]);
			rc = file.Create (nsILocalFile.DIRECTORY_TYPE, 0700);
			if (rc != XPCOM.NS_OK){
				//MozillaBrowser.error (rc);
				return;
			}
			file.Release ();
		}
	}
	
	
	
	private  String[] getChromePaths(){
		if(chromeDirs == null &&  mozillaPath!=null){
			chromeDirs = new String[2];
			chromeDirs[0] = mozillaPath + CHROME_DIR;
			chromeDirs[1] = getNLPath(CHROME_DIR) ;
		}		
		
		return chromeDirs;
	}
	
	static String getNLPath(String subDir) {
		Bundle hostBundle=Platform.getBundle(NLbundleName);
		
		if(hostBundle == null){
			return "";
		}

		URL chromePathURL = FileLocator.find(hostBundle, new Path(subDir), null); //$NON-NLS-1$
		if (chromePathURL != null) {
			try	{
				chromePathURL = FileLocator.toFileURL(chromePathURL);
			}
			catch (IOException e) {

			}
		}

		if (chromePathURL != null) {
			try	{
				URI fileUri = new URI(chromePathURL.getProtocol(), chromePathURL.getPath(), null);

				File tempFile = new File(fileUri);
				return tempFile.getAbsolutePath();
			}
			catch (URISyntaxException e) {
				
			}
		}
		return "";
	}
	
	/*Added for SPR#PLOS854M7X*/
	private static String translateStringWithEnvironmentSetting(String str){
		String str1 = str;
		if ("win32".equalsIgnoreCase(SWT.getPlatform())) {
			while (true) {
				/*
				 * search for substring of %varname% and replace with the
				 * environment setting
				 */
				int iStart = str1.indexOf('%');
				if (iStart < 0)
					break;
				int iEnd = str1.indexOf('%', iStart + 1);
				if (iEnd < 0)
					break;
				String varName = str1.substring(iStart+1, iEnd);
				if ((varName == null) || (varName.length() == 0)) {
					str1 = str1.substring(iEnd + 1);
					continue;
				}
				String str2 = "";
				if (iStart > 0)
					str2 = str1.substring(0, iStart);
				str2 = str2 + System.getenv(varName);
				if (iEnd + 1 < str1.length())
					str2 = str2 + str1.substring(iEnd + 1);
				str1 = str2;
			}
		}		
		return str1;
	}
	
}
