/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.internal;

import org.eclipse.swt.internal.win32.OS;

public final class Converter {
	public static final byte [] NullByteArray = new byte [1];
	public static final byte [] EmptyByteArray = new byte [0];
	public static final char [] EmptyCharArray = new char [0];

	public static char[] mbcsToWcs(String code, byte [] bytes) {
		int codePage = (code != null) ? Integer.parseInt(code) : 0;
		if (OS.IsUnicode) {
			return new String(bytes).toCharArray();
		} else {
			int length = bytes.length; 
			char [] chars = new char [length];
			int cp = codePage != 0 ? codePage : OS.CP_ACP;
			int charCount = OS.MultiByteToWideChar (cp, OS.MB_PRECOMPOSED, bytes, length, chars, length);
			char[] result = new char[charCount];
			System.arraycopy (chars, 0, result, 0, charCount);
			return result;
		}
	}
	
	public static byte[] wcsToMbcs (String codePage, String string, boolean terminate) {
		int byteCount;
		char[] chars = new char[string.length()];
		string.getChars (0, chars.length, chars, 0);
		byte[] bytes = new byte[byteCount = chars.length * 2 + (terminate ? 1 : 0)];
		byteCount = OS.WideCharToMultiByte (OS.CP_UTF8, 0, chars, chars.length, bytes, byteCount, null, null);
		if (terminate) {
			byteCount++;
		} else {
			if (bytes.length != byteCount) {
				byte[] result = new byte[byteCount];
				System.arraycopy (bytes, 0, result, 0, byteCount);
				bytes = result;
			}
		}
		return bytes;
	}
	
	public static byte[] wcsToMbcs(String code, char [] chars, boolean terminate) {
		byte [] bytes = null;
		int charCount = chars.length;
		int codePage = (code != null) ? Integer.parseInt(code) : 0;
		int byteCount = charCount * 2 + (terminate ? 1 : 0);
		int cp = codePage != 0 ? codePage : OS.CP_ACP;
		bytes = new byte [byteCount];
		byteCount = OS.WideCharToMultiByte (cp, 0, chars, charCount, bytes, byteCount, null, null);
		return bytes;
	}
	

}