/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.rcp.dombrowser.support;

import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.BrowserUtil;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class NativeBrowser extends Composite {

	static public final int PTR_SIZEOF = 4;
	
	private static final String NO_INPUT_METHOD = "org.eclipse.swt.internal.gtk.noInputMethod"; //$NON-NLS-1$
	
	/*
	 * SPR#MBUT8FESXK & SPR#RBAR8HWNDG
	 * Change to use static subclassProc Callback. DOMBrowser only maintain one Callback for 
	 * drawing the background. And remove it when browser has real content, and at disposing time.
	 */
	static private int /*long*/ mozillaProc;
	static private Callback subclassProc;

	public void addWindowSubclass() {
		int /*long*/ hwndChild = OS.GetWindow (handle, OS.GW_CHILD);
		if (subclassProc == null) {			
			subclassProc = new Callback (NativeBrowser.class, "windowProc", 4); //$NON-NLS-1$
		}
		mozillaProc = OS.GetWindowLongPtr (hwndChild, OS.GWL_WNDPROC);
		OS.SetWindowLongPtr (hwndChild, OS.GWL_WNDPROC, subclassProc.getAddress ());
	}

	public void removeWindowSubclass () {
		if (subclassProc == null) return;
		int /*long*/ hwndChild = OS.GetWindow (handle, OS.GW_CHILD);
		OS.SetWindowLongPtr (hwndChild, OS.GWL_WNDPROC, mozillaProc);
	}

	static int /*long*/ windowProc (int /*long*/ hwnd, int /*long*/ msg, int /*long*/ wParam, int /*long*/ lParam) {
		switch (msg) {
			case OS.WM_ERASEBKGND:
				RECT rect = new RECT ();
				OS.GetClientRect (hwnd, rect);
				OS.FillRect (wParam, rect, OS.GetSysColorBrush (OS.COLOR_WINDOW));
				break;
		}
		return OS.CallWindowProc (mozillaProc, hwnd, msg, wParam, lParam);
	}

	
	public NativeBrowser(Composite parent, int style) {
		super(fixIM(parent), style);
		Display display = parent.getDisplay();	
		display.setData(NO_INPUT_METHOD, null);
	}
	
	
	private boolean initAppShell = false;
	
	protected boolean isInitAppShell(){
		return initAppShell;
	}

	protected void createBrowserHandle() {
	}
	protected int getEmbedHandle() {
		return this.handle;
	}
	public void initializeBrowser() {
	}
	protected void onResize() {
	}
	protected void onDispose(Display display) {
		/*
		* Need to remove the workaround for Mozilla bug: 
		* https://bugzilla.mozilla.org/show_bug.cgi?id=453523, 
		* otherwise, the JVM would crash.
		*/
		if (subclassProc != null) {
			removeWindowSubclass();
		}
	}	
	
	public static String error(int code) {
		throw new SWTError("XPCOM error "+code); //$NON-NLS-1$
	}
		
	public static Composite findBrowser(int /*long*/ handle) {
		Display display = Display.getCurrent();
		return (Composite)display.findWidget(handle); 
	}
	
	public static Shell newShell(Display display, int handle) {
		return Shell.win32_new(display, handle);
	}
	
	private static Composite fixIM(Composite parent) {
		/*
		* Note.  Mozilla provides all IM suport needed for text input in webpages.
		* If SWTcreates another input method context for the widget it will cause
		* undetermine results to happen (hungs and crashes). The fix is to prevent 
		* SWT from creating an input method context for the  Browser widget.
		*/
		if (parent != null && !parent.isDisposed()) {
			Display display = parent.getDisplay();
			if (display != null) {
				if (display.getThread() == Thread.currentThread ()) {
					display.setData (NO_INPUT_METHOD, "true");
				}
			}
		}
		return parent;
	}
	protected boolean initSWTService(){
		return true;
	}
	public static int openWindow(int parent,int chromeFlags,int contextFlags,
			int uri,int cancel, int newChrome){
		return BrowserUtil.openWindow(parent, chromeFlags, contextFlags, uri, cancel, newChrome);
	}
	public void restoreNSMenu(){}
	public void backupNSMenu(){}
	public static void loadAdditionalLibraries(String mozillaPath){}

	/*
	 * SPR-RSSNBGQH57 - No implementation For window
	 * as caller function call is only for mac osx.
	 */
	protected void getDeviceZoom(int topshell_xValue) {}
}