/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.internal;

import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.OS;

public final class Converter {
	
	private static final byte[] NullByteArray = new byte[1];
	private static final byte[] EmptyByteArray = new byte[0];
	
	public static char[] mbcsToWcs(String codepage, byte[] buffer) {
		char[] chars = null;
		int encoding = OS.kCFStringEncodingUTF8;
		int cfstring = OS.CFStringCreateWithBytes(OS.kCFAllocatorDefault, buffer, buffer.length, encoding, true);
		if (cfstring != 0) {
			try {
				int length = OS.CFStringGetLength(cfstring);
				if (length > 0) {
					chars = new char[length];
					CFRange range = new CFRange();
					range.length = length;
					OS.CFStringGetCharacters(cfstring, range, chars);
				}
			} 
			finally {
				OS.CFRelease(cfstring);
			}
		}
		return chars;
	}
	
	public static byte[] wcsToMbcs(String code, String string, boolean terminate) {
		int encoding = OS.kCFStringEncodingUTF8;
		byte[] buffer = null;
		char[] chars = string.toCharArray();
		int cfstring = OS.CFStringCreateWithCharacters(OS.kCFAllocatorDefault, chars, chars.length);
		if (cfstring != 0) {
			try {
				CFRange range = new CFRange();
				range.length = chars.length;
				int[] size = new int[1];
				int numChars = OS.CFStringGetBytes(cfstring, range, encoding, (byte)'0', true, null, 0, size);
				if (numChars != 0) {
					buffer = new byte[size[0]];
					numChars = OS.CFStringGetBytes(cfstring, range, encoding, (byte)'0', true, buffer, size [0], size);
				}
			}
			finally {
				OS.CFRelease(cfstring);
			}
		}
		if (buffer == null)
			buffer = (terminate) ? NullByteArray : EmptyByteArray;
		else {
			if (terminate) {
				byte[] newBuffer = new byte[buffer.length + 1];
				System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
				buffer = newBuffer;
			}
		}
		return buffer;
	}
}
