/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.rcp.dombrowser.support;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.HILayoutInfo;
import org.eclipse.swt.internal.carbon.HISideBinding;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.cocoa.Cocoa;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public abstract class NativeBrowser extends Composite {

	boolean hasFocus;
	Callback callback3;
	
	int[] outRef = new int[1];
	Listener listener;
	int mainMenu = 0;
	int application = 0;
	
	static int[] keyMapping = new int[256];
	
	/* Key Mappings */
	static final int [][] KeyTable = {
		/* Literal Keys */
		{0,		'a'},
		{11,	'b'},
		{8,		'c'},
		{2,		'd'},
		{14,	'e'},
		{3,		'f'},
		{5,		'g'},

		{4,		'h'},
		{34,	'i'},
		{38,	'j'},
		{40,	'k'},
		{37,	'l'},
		{46,	'm'},
		{45,	'n'},

		
		{31,	'o'},
		{35,	'p'},
		{12,	'q'},
		{15,	'r'},
		{1,		's'},
		{17,	't'},
	
		{32,	'u'},
		{9,		'v'},
		{13,	'w'},
		{7,		'x'},
		{16,	'y'},
		{6,		'z'},
		
		
		{29,	'0'},
		{18,	'1'},
		{19,	'2'},
		{20,	'3'},
		{21,	'4'},
		{22,	'5'},
		{23,	'6'},
		{24,	'7'},
		{25,	'8'},
		{26,	'9'},
		
		
		{49,	' '},
		{41,	';'},
		{24,	'='},
		{43,	','},
		{47,	'.'},
		
		{44,	'/'},
		{33,	'['},
		{30,	']'},
		{42,	'\''},
		{50,	'`'},
	

		/* Virtual and Ascii Keys */
		{48,	SWT.TAB},
		{53,	SWT.ESC},
		{51,	SWT.DEL},

		/* Functions Keys */
		{122,	SWT.F1},
		{120,	SWT.F2},
		{99,	SWT.F3},
		{118,	SWT.F4},
		{96,	SWT.F5},
		{97,	SWT.F6},
		{98,	SWT.F7},
		{100,	SWT.F8},
		{101,	SWT.F9},
		{109,	SWT.F10},
		{103,	SWT.F11},
		{111,	SWT.F12},
		{114,   SWT.HELP}

	};

	static {
		for(int i=0;i<KeyTable.length;i++){
			keyMapping[KeyTable[i][0]] = KeyTable[i][1];			
		}
	}
	
	private int embedHandle = 0;
	
	private boolean initAppShell = false;
	
	private static boolean isMacPPC(){
		return "ppc".equalsIgnoreCase(System.getProperty("os.arch"));
	}
	
	
	protected boolean isInitAppShell(){
		return initAppShell;
	}
	
	
	public int eventProc3(int nextHandler, int theEvent, int userData) {
		int eventKind = OS.GetEventKind(theEvent);
		switch (OS.GetEventClass(theEvent)) {

		case OS.kEventClassControl:{
			short[] part = new short[1];
			OS.GetEventParameter(theEvent, OS.kEventParamControlPart, OS.typeControlPartCode, null, 2, null, part);
			if (part[0] == OS.kControlFocusNoPart)
			{
				return OS.eventNotHandledErr;
			}

			return OS.noErr;

		}
		
		case OS.kEventClassKeyboard: {
			switch (eventKind) {
			case OS.kEventRawKeyDown: {

				int[] keyCode = new int[1];
				int[] modifiers = new int[1];
				OS.GetEventParameter(theEvent, OS.kEventParamKeyCode, OS.typeUInt32, null, keyCode.length * 4, null, keyCode);
				OS.GetEventParameter(theEvent, OS.kEventParamKeyModifiers,OS.typeUInt32, null, 4, null, modifiers);
			


				
				
			 
				//handle shortcut keys consumed by swt, including Esc key for SPR SLAE7W6GUE.
				if(modifiers[0] != 0 || keyMapping[keyCode[0]]== SWT.ESC){

					int command = ((modifiers[0]&OS.cmdKey)!=0) ? SWT.COMMAND:0;
					int alt = ((modifiers[0]&OS.optionKey)!=0) ? SWT.ALT:0;
					int ctrl = ((modifiers[0]&OS.controlKey)!=0) ? SWT.CONTROL:0;
					int shift = ((modifiers[0]&OS.shiftKey)!=0) ? SWT.SHIFT:0;

					
					Event keyEvent = new Event ();
					keyEvent.widget = this;				
					keyEvent.type = SWT.KeyDown;
					keyEvent.keyCode = keyMapping[keyCode[0]];
					keyEvent.stateMask = command|alt|ctrl|shift;
					
					OS.CFRetain (subHIView);//retain subHIView, to prevent crash if browser has already been disposed by one of its listeners
					this.notifyListeners(keyEvent.type, keyEvent);
					OS.CFRelease (subHIView);
					
					if(keyEvent.doit == false || NativeBrowser.this.isDisposed()){//if event.doit was set to false or browser has already been disposed, stop the handler chain.
						return OS.noErr;
						
					}else{

					       	/*
                             * SPR ZYXE837B8E,eclipse bug 307345
                             * Pressing the OSX shortcut to put focus into the menu bar does not work in
                             * embedded mozilla.  If this shortcut is not handled here then it falls through
                             * all of the key handlers for some reason.  The workaround is to detect this
                             * shortcut here and put focus into the menu bar.
                             */
						if ((keyMapping[keyCode[0]] == SWT.F2) && (modifiers[0] & OS.controlKey) != 0)
						{
							int[] event = new int[1];
							OS.CreateEvent(0, OS.kEventClassApplication, 8/*OS.kEventAppFocusMenuBar*/, 0.0, 0, event);
							if (event[0] != 0)
							{
								OS.SetEventParameter(event[0], OS.kEventParamKeyModifiers, OS.typeUInt32, 4, modifiers);
								int result = OS.SendEventToEventTarget(event[0], OS.GetApplicationEventTarget());
								OS.ReleaseEvent(event[0]);
								return result;
							}
						}

						//SPR MLUO7TX5GM
						//1.User presses cmd+c/p/a/x.
						//2.Browser handle the keyevent, do copy/paste/select all/cut operation.
						//3.Browser translate the keyevent to a SWT event, notify all its listeners, so that Sametime will get the chance to do its own work here.


						if ((modifiers[0] & OS.cmdKey) != 0)
						{

							switch (keyCode[0])
							{
								case 0:
									{
										execCommand("selectall", false, null);//$NON-NLS-1$ // process 'command+a'
										return OS.noErr; //return OS.noErr to fix SPR CREH8AFQMV, if we return OS.eventNotHandledErr here, there will be "Funk" 
										//sound occurs if there is no other eventHandler which handles 'command+a' in applicaiton.
									}

								case 7:
									{
										execCommand("cut", false, null);//$NON-NLS-1$ // process 'command+x'
										return OS.noErr;
									}

								case 8:
									{
										execCommand("copy", false, null);//$NON-NLS-1$ // process 'command+c'
										return OS.noErr;
									}

								case 9:
									{
										execCommand("paste", false, null);//$NON-NLS-1$ // process 'command+v'
										return OS.noErr;
									}
//								case 3:
//									{
//										execCommand("find", false, null);//$NON-NLS-1$ // process 'command+f'
//										return OS.noErr;
//									}
//								case 5:
//									{
//										if( (modifiers[0] & OS.shiftKey ) !=0 )
//											execCommand("findnext", false, "p");//$NON-NLS-1$ //$NON-NLS-2$ // process 'command+shift+g';
//										else
//											execCommand("findnext", false, null);//$NON-NLS-1$ // process 'command+g';	
//										
//										return OS.noErr;
//									}

							}
					}
					}

					return OS.eventNotHandledErr;
					
				}
				
			
				//other keys
				OS.CFRetain (subHIView);
				int result = OS.CallNextEventHandler (nextHandler, theEvent);
				OS.CFRelease (subHIView);
				
				return result;
				
				
			}
			}
			
			break;
		}
		}
			
		return OS.eventNotHandledErr;

	}
	

	int subHIView;

	
	static private Map handles = new HashMap();
	static public final int PTR_SIZEOF = 4;
	
	// private Frame frame;

	public NativeBrowser(Composite parent, int style) {
		super(parent, style|SWT.MOZILLA);	
	}
	protected void createBrowserHandle() {
	// this.frame = SWT_AWT.new_Frame(this);
	}
	protected int getEmbedHandle() {
	
		
		if(embedHandle == 0){
			int[] outControl = new int[1];		
		
			embedHandle = Cocoa.objc_msgSend (Cocoa.C_NSImageView, Cocoa.S_alloc);
			if (embedHandle == 0){
				this.dispose();
				SWT.error (SWT.ERROR_NO_HANDLES);
				}
            
			NSRect r = new NSRect ();
			embedHandle = Cocoa.objc_msgSend (embedHandle, Cocoa.S_initWithFrame, r);
			
			int rc;
			if(isMacPPC()){
				rc = Cocoa.HIJavaViewCreateWithCocoaView (outControl, embedHandle);
				
			}else{
				rc = Cocoa.HICocoaViewCreate (embedHandle, 0, outControl);
			}
			
			
			if (rc != OS.noErr || outControl[0] == 0) {
				Cocoa.objc_msgSend (embedHandle, Cocoa.S_release);
				this.dispose();
				SWT.error (SWT.ERROR_NO_HANDLES);
			}
			
			subHIView = outControl[0];
			HILayoutInfo newLayoutInfo = new HILayoutInfo ();
			newLayoutInfo.version = 0;
			OS.HIViewGetLayoutInfo (subHIView, newLayoutInfo);
			HISideBinding biding = newLayoutInfo.binding.top;
			biding.toView = 0;
			biding.kind = OS.kHILayoutBindMin;
			biding.offset = 0;
			biding = newLayoutInfo.binding.left; 
			biding.toView = 0;
			biding.kind = OS.kHILayoutBindMin;
			biding.offset = 0;
			biding = newLayoutInfo.binding.bottom;
			biding.toView = 0;
			biding.kind = OS.kHILayoutBindMax;
			biding.offset = 0;
			biding = newLayoutInfo.binding.right;
			biding.toView = 0;
			biding.kind = OS.kHILayoutBindMax;
			biding.offset = 0;
			OS.HIViewSetLayoutInfo (subHIView, newLayoutInfo);
			OS.HIViewChangeFeatures (subHIView, OS.kHIViewFeatureIsOpaque, 0);
		
			OS.HIViewSetVisible (subHIView, true);
			CGRect rect = new CGRect ();
			OS.HIViewGetFrame (handle, rect);
			rect.x = rect.y = 0;
			OS.HIViewSetFrame (subHIView, rect);
			OS.HIViewAddSubview(handle, subHIView);
	
			handles.put (new Integer (embedHandle), new Integer(this.handle));
			
			callback3 = new Callback (this, "eventProc3", 3); //$NON-NLS-1$





			if(callback3.getAddress() ==0){
				this.dispose();
				}

			//register raw key events.
			int [] mask = new int [] {
				OS.kEventClassKeyboard, OS.kEventRawKeyDown,
				OS.kEventClassControl, OS.kEventControlSetFocusPart,
			};
			int controlTarget = OS.GetControlEventTarget (subHIView);
			OS.InstallEventHandler (controlTarget, callback3.getAddress (), mask.length / 2, mask, subHIView, outRef);

			
		}
			
		return embedHandle;
	}
	
	

	
	public void initializeBrowser() {
		 
	}
	
	protected void onResize() {
	
	}
	
	protected void onDispose(Display display) {
	
		if(outRef[0] !=0){
			OS.RemoveEventHandler(outRef[0]);
			outRef[0] = 0;
		}
		
		if (callback3 != null){
			callback3.dispose();
			callback3 = null;
			}
		
		if(subHIView != 0){
			OS.HIViewRemoveFromSuperview(subHIView);
			}
     }	
	public static String error(int code) {
		throw new SWTError("XPCOM error "+code); //$NON-NLS-1$
	}	
	public static Composite findBrowser(int /*long*/ handle) {
		Integer value = (Integer)handles.get(new Integer(handle));
		if (value != null) {
			Display display = Display.getCurrent();
			return (Composite)display.findWidget(value.intValue());
		}
		return null;
	}
	public static Shell newShell(Display display, int handle) {
		return new Shell(display);
	}	

	protected boolean initSWTService(){
		return true;
	}
	
	protected void setSize (int embedHandle, int width, int height) {
		// TODO
	}

	protected abstract void Deactivate();
	protected abstract boolean execCommand(String name, boolean showUI, String v);

	public static int openWindow(int parent,int chromeFlags,int contextFlags,
			int uri,int cancel, int newChrome){
		return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
	}
	
	public void addWindowSubclass(){}
	public void removeWindowSubclass () {}

}
