/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.layout.FillLayout;

public class ShellMozilla extends Shell
{
	static private Integer staticHandle = new Integer(0); 
	
	static public Composite newShell(Display display, int handle) {
			ShellMozilla c = null;
			synchronized (staticHandle) {
					staticHandle = new Integer(handle);
					c = new ShellMozilla(display);
			}
			c.setVisible(true);
			c.setLayout(new FillLayout());   
			Composite ret = new Composite(c,SWT.LEFT);
			c.layout();
			return ret; 
	}
	
	private ShellMozilla(Display d) {
		super(d);
	}

	void createHandle (int index) {
		state |= HANDLE | CANVAS;
		//int type = OS.GTK_WINDOW_TOPLEVEL;
		shellHandle = staticHandle.intValue(); 
		if (shellHandle == 0) SWT.error (SWT.ERROR_NO_HANDLES);
		fixedHandle = shellHandle;
		handle = shellHandle;
	}
	void showWidget () {
	//	OS.gtk_container_add (shellHandle, fixedHandle);
		if (scrolledHandle != 0) OS.gtk_widget_show (scrolledHandle);
		if (handle != 0) OS.gtk_widget_show (handle);
		if (fixedHandle != 0) OS.gtk_widget_show (fixedHandle);
	}
	void setInitialSize () {
		Rectangle rc = getBounds ();
		oldWidth = rc.width;
		oldHeight = rc.height ;
	}
	void setInitialBounds () {
/*		Monitor monitor = getMonitor ();
		Rectangle rect = monitor.getClientArea ();
		int width = rect.width * 5 / 8;
		int height = rect.height * 5 / 8;
		OS.gtk_widget_set_size_request (scrolledHandle, width, height);
		OS.gtk_window_resize (shellHandle, width, height);
		GtkRequisition requisition = new GtkRequisition ();
		OS.gtk_widget_size_request (fixedHandle, requisition);
		OS.gtk_container_resize_children (fixedHandle);*/
	}
	void adjustTrim () 	{
	}
	public Composite getParent () {
		return null;
	}
	public void dispose () {
	
		if (isDisposed()) return;
		
		handle = 0;
		fixedHandle = 0;
		shellHandle = 0;
		if (!isValidThread ()) error (SWT.ERROR_THREAD_INVALID_ACCESS);
		releaseWidget ();	
		destroyWidget ();
	}
	void releaseWidget () {
	}
	void releaseChildren () {
	}
	int gtk_size_allocate (int widget, int allocation)
	{
		Rectangle rc = getBounds ();
		if (oldWidth != rc.width || oldHeight != rc.height) {
			oldWidth = rc.width;
			oldHeight = rc.height ;
			resizeBounds (rc.width , rc.height, true);
		}
		return 0;
	}
	public Point getSize ()
	{
		Rectangle rc = getBounds ();
		return new Point (rc.width,rc.height);
	}
	void resizeBounds (int width, int height, boolean notify)
	{
		Rectangle rc = getBounds ();
		rc.width = width;
		rc.height = height;
		setBounds(rc);
	}
	public Rectangle getBounds ()
	{
		checkWidget();
		int topHandle = topHandle ();
		int x = OS.GTK_WIDGET_X (topHandle);
		int y = OS.GTK_WIDGET_Y (topHandle);
		int width = OS.GTK_WIDGET_WIDTH (topHandle);
		int height = OS.GTK_WIDGET_HEIGHT (topHandle);
		return new Rectangle (x, y, width, height);
	}
	int setBounds (int x, int y, int width, int height, boolean move, boolean resize) {
		boolean changed = setBoundsControl (x, y, width, height, move, resize);
		if (changed && resize && layout != null) layout.layout (this, false);
		int result = 0;
		if (changed) {
			if (move) 
				result |= MOVED;
		
			if (resize) 
				result |= RESIZED;
		}
		return result;
	}

	private boolean setBoundsControl (int x, int y, int width, int height, boolean move, boolean resize) 
	{
		int topHandle = topHandle ();
		int flags = OS.GTK_WIDGET_FLAGS (topHandle);
		OS.GTK_WIDGET_SET_FLAGS (topHandle, OS.GTK_VISIBLE);
		boolean sameOrigin = true, sameExtent = true;
		if (move) {
			int oldX = OS.GTK_WIDGET_X (topHandle);
			int oldY = OS.GTK_WIDGET_Y (topHandle);
			sameOrigin = x == oldX && y == oldY;
			if (!sameOrigin) moveHandle (x, y);
		}
		if (resize) {
			width = Math.max (1, width);
			height = Math.max (1, height);
			int oldWidth = OS.GTK_WIDGET_WIDTH (topHandle);
			int oldHeight = OS.GTK_WIDGET_HEIGHT (topHandle);
			sameExtent = width == oldWidth && height == oldHeight;
			if (!sameExtent) resizeHandle (width, height);
		}
		if ((flags & OS.GTK_VISIBLE) == 0) {
			OS.GTK_WIDGET_UNSET_FLAGS (topHandle, OS.GTK_VISIBLE);	
		}
		if (!sameOrigin) sendEvent (SWT.Move);
		if (!sameExtent) sendEvent (SWT.Resize);
		return !sameOrigin || !sameExtent;
	}
	public void setVisible (boolean visible) 
	{
		checkWidget();
		int topHandle = topHandle();
		if (visible) {
			sendEvent (SWT.Show);
			OS.gtk_widget_show (topHandle);
		} else {	
			OS.gtk_widget_hide (topHandle);
			int imHandle = imHandle ();
			if (imHandle == 0) OS.gtk_widget_unrealize (topHandle);
			sendEvent (SWT.Hide);
		}
	}
	void destroyWidget ()
	{
		//int topHandle = topHandle ();
		releaseHandle ();
	}
	void deregister () {
	}
	void hookEvents () {
	}
	void forceResize () {
	//	forceResize (OS.GTK_WIDGET_WIDTH (vboxHandle), OS.GTK_WIDGET_HEIGHT (vboxHandle));
	}
	void forceResize (int width, int height) {
	/*	int flags = OS.GTK_WIDGET_FLAGS (vboxHandle);
		OS.GTK_WIDGET_SET_FLAGS (vboxHandle, OS.GTK_VISIBLE);
		GtkRequisition requisition = new GtkRequisition ();
		OS.gtk_widget_size_request (vboxHandle, requisition);
		GtkAllocation allocation = new GtkAllocation ();
		allocation.width = width;
		allocation.height = height;
		OS.gtk_widget_size_allocate (vboxHandle, allocation);
		if ((flags & OS.GTK_VISIBLE) == 0) {
			OS.GTK_WIDGET_UNSET_FLAGS (vboxHandle, OS.GTK_VISIBLE);	
		}*/
	}
}