/*******************************************************************************
 * Copyright (c) 2003, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Platform;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.nsIBaseWindow;
import org.eclipse.swt.internal.mozilla.nsIURI;
import org.eclipse.swt.internal.mozilla.nsIWebBrowser;
import org.eclipse.swt.internal.mozilla.nsIWebBrowserChrome;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SWTBrowserInitializer {

	private static Shell hiddenShell=null;
	
	/**
	 * Rebased from IES3.4.2 WindowCreator2.CreateChromeWindow2
	 * @param parent
	 * @param chromeFlags
	 * @param contextFlags
	 * @param uri
	 * @param cancel
	 * @param newChrome
	 * @return
	 */
	public static int openWindow(int parent,int chromeFlags,int contextFlags,
			int uri,int cancel, int newChrome){
		if (parent == 0 && (chromeFlags & nsIWebBrowserChrome.CHROME_OPENAS_CHROME) == 0) {
			return XPCOM.NS_ERROR_NOT_IMPLEMENTED;
		}
		Browser src = null; 
		if (parent != 0) {
			nsIWebBrowserChrome browserChromeParent = new nsIWebBrowserChrome (parent);
			int /*long*/[] aWebBrowser = new int /*long*/[1];
			int rc = browserChromeParent.GetWebBrowser (aWebBrowser);
			if (rc != XPCOM.NS_OK) Mozilla.error (rc);
			if (aWebBrowser[0] == 0) Mozilla.error (XPCOM.NS_ERROR_NO_INTERFACE);

			nsIWebBrowser webBrowser = new nsIWebBrowser (aWebBrowser[0]);
			int /*long*/[] result = new int /*long*/[1];
			rc = webBrowser.QueryInterface (nsIBaseWindow.NS_IBASEWINDOW_10_IID, result);
			if (rc != XPCOM.NS_OK) {
				rc = webBrowser.QueryInterface (nsIBaseWindow.NS_IBASEWINDOW_IID, result);
				if (rc != XPCOM.NS_OK) Mozilla.error (rc);
			}
			if (result[0] == 0) Mozilla.error (XPCOM.NS_ERROR_NO_INTERFACE);
			webBrowser.Release ();

			nsIBaseWindow baseWindow = new nsIBaseWindow (result[0]);
			result[0] = 0;
			int /*long*/[] aParentNativeWindow = new int /*long*/[1];
			rc = baseWindow.GetParentNativeWindow (aParentNativeWindow);
			if (rc != XPCOM.NS_OK) Mozilla.error (rc);
			if (aParentNativeWindow[0] == 0) Mozilla.error (XPCOM.NS_ERROR_NO_INTERFACE);
			baseWindow.Release ();

			src = Mozilla.findBrowser (aParentNativeWindow[0]);
		}
		final Browser browser;
		boolean doit = true;
		if ((chromeFlags & nsIWebBrowserChrome.CHROME_OPENAS_CHROME) != 0) {
			/*
			* Mozilla will request a new Browser in a modal window in order to emulate a native
			* dialog that is not available to it (eg.- a print dialog on Linux).  For this
			* reason modal requests are handled here so that the user is not exposed to them.
			*/
			int style = SWT.NONE;
			if ((chromeFlags & nsIWebBrowserChrome.CHROME_WINDOW_POPUP) == 0) {
				/* add dialog trim for all windows except pop-ups */
				style |= SWT.DIALOG_TRIM;
			}
			if ((chromeFlags & nsIWebBrowserChrome.CHROME_MODAL) != 0) style |= SWT.APPLICATION_MODAL; 
			final Shell shell = src == null ?
				new Shell (style) :
				new Shell (src.getShell(), style);
			shell.setLayout (new FillLayout ());
			browser = new Browser (shell, src == null ? SWT.MOZILLA : src.getStyle () & SWT.MOZILLA);
			browser.addVisibilityWindowListener (new VisibilityWindowListener () {
				public void hide (WindowEvent event) {
				}
				public void show (WindowEvent event) {
					if (event.location != null) shell.setLocation (event.location);
					if (event.size != null) {
						Point size = event.size;
						shell.setSize (shell.computeSize (size.x, size.y));
					}
					shell.open ();
				}
			});
			browser.addCloseWindowListener (new CloseWindowListener () {
				public void close (WindowEvent event) {
					shell.close ();
				}
			});
			if (uri != 0) {
				nsIURI location = new nsIURI (uri);
				int /*long*/ aSpec = XPCOM.nsEmbedCString_new ();
				if (location.GetSpec (aSpec) == XPCOM.NS_OK) {
					int length = XPCOM.nsEmbedCString_Length (aSpec);
					if (length > 0) {
						int /*long*/ buffer = XPCOM.nsEmbedCString_get (aSpec);
						byte[] dest = new byte[length];
						XPCOM.memmove (dest, buffer, length);
						browser.setUrl (new String (dest));
					}
				}
				XPCOM.nsEmbedCString_delete (aSpec);
			}
		} else {
			WindowEvent event = new WindowEvent (src);
			event.display = src.getDisplay ();
			event.widget = src;
			event.required = true;
			for (int i = 0; i < src.webBrowser.openWindowListeners.length; i++) {
				src.webBrowser.openWindowListeners[i].open (event);
			}
			browser = event.browser;

			/* Ensure that the Browser provided by the client is valid for use */ 
			doit = browser != null && !browser.isDisposed ();
			if (doit) {
				String platform = Platform.PLATFORM;
				boolean isMozillaNativePlatform = platform.equals ("gtk") || platform.equals ("motif"); //$NON-NLS-1$ //$NON-NLS-2$
				doit = isMozillaNativePlatform || (browser.getStyle () & SWT.MOZILLA) != 0;
			}
		}
		if (doit) {
			Mozilla mozilla = (Mozilla)browser.webBrowser;
			mozilla.isChild = true;
			int /*long*/ chromePtr = mozilla.webBrowserChrome.getAddress ();
			nsIWebBrowserChrome webBrowserChrome = new nsIWebBrowserChrome (chromePtr);
			webBrowserChrome.SetChromeFlags (chromeFlags);
			webBrowserChrome.AddRef ();
			XPCOM.memmove (newChrome, new int /*long*/[] {chromePtr}, C.PTR_SIZEOF);
		} else {
			if (cancel != 0) {
				XPCOM.memmove (cancel, new boolean[] {true});
			}
		}
		return doit ? XPCOM.NS_OK : XPCOM.NS_ERROR_NOT_IMPLEMENTED;
		
	}
	
	
	public static boolean initSWTService(){
		try{
			if(Mozilla.Initialized==true){
				return true;
			}
			hiddenShell=new Shell();
			new Browser(hiddenShell, SWT.NONE);
			Display.getDefault().asyncExec(new Runnable(){
				public void run() {
					try {	
						hiddenShell.dispose();
						hiddenShell=null;
					} catch (Throwable th) {
						//TODO: Log
						th.printStackTrace();
					}
				}
			});
			return true;
		}catch(Throwable th){
			//TODO
			th.printStackTrace();
			return false;
		}

	}
}
