/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.rcp.dombrowser.support;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.SWTBrowserInitializer;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public abstract class NativeBrowser extends Composite {

	static public final int PTR_SIZEOF = 4;
	
	private static final String NO_INPUT_METHOD = "org.eclipse.swt.internal.gtk.noInputMethod"; //$NON-NLS-1$
	private static final String ADD_WIDGET_KEY = "org.eclipse.swt.internal.addWidget"; //$NON-NLS-1$
	private static final int STOP_PROPOGATE = 1;
	
	private static Callback eventCallback;
	private static int /*long*/ eventProc;
	
	private boolean initAppShell = true;
	
	protected boolean isInitAppShell(){
		return initAppShell;
	}
	
	private int /*long*/ embedHandle;
	private int /*long*/ mozillaHandle;
	
	public NativeBrowser(Composite parent, int style) {
		super(fixIM(parent), style);
		Display display = parent.getDisplay();	
		display.setData(NO_INPUT_METHOD, null);
	}
	
	protected void createBrowserHandle() {
		/*
		* Bug in Mozilla Linux GTK.  Embedding Mozilla into a GtkFixed
		* handle causes problems with some Mozilla plug-ins.  For some
		* reason, the Flash plug-in causes the child of the GtkFixed
		* handle to be resized to 1 when the Flash document is loaded.
		* That could be due to gtk_container_resize_children being called
		* by Mozilla - or one of its plug-ins - on the GtkFixed handle,
		* causing the child of the GtkFixed handle to be resized to 1.
		* The workaround is to embed Mozilla into a GtkHBox handle.
		*/
		this.embedHandle = OS.gtk_hbox_new (false, 0);
		OS.gtk_container_add (handle, this.embedHandle);
		OS.gtk_widget_show (this.embedHandle);
		
		if (eventCallback == null) {
			eventCallback = new Callback(NativeBrowser.class, "eventProc", 3);
			eventProc = eventCallback.getAddress();
			if (eventProc == 0) error(SWT.ERROR_NO_MORE_CALLBACKS);
		}
	}
	protected int getEmbedHandle() {
		return this.embedHandle;
	}
	public void initializeBrowser() {
		/*
		* Feature in Mozilla.  GtkEvents such as key down, key pressed may be consumed
		* by Mozilla and never be received by the parent embedder.  The workaround
		* is to find the top Mozilla gtk widget that receives all the Mozilla GtkEvents,
		* i.e. the first child of the parent embedder. Then hook event callbacks and
		* forward the event to the parent embedder before Mozilla received and consumed
		* them.
		*/
		int /*long*/ list = OS.gtk_container_get_children(embedHandle);
		if (list != 0) {
			mozillaHandle = OS.g_list_data(list);
			OS.g_list_free(list);
			
			if (mozillaHandle != 0) {			
				getDisplay().setData(ADD_WIDGET_KEY, new Object[] {new LONG(mozillaHandle), this});
	
				/* Note. Callback to get events before Mozilla receives and consumes them. */
				OS.g_signal_connect (mozillaHandle, OS.event, eventProc, 0);
				
				/* 
				* Note.  Callback to get the events not consumed by Mozilla - and to block 
				* them so that they don't get propagated to the parent handle twice.  
				* This hook is set after Mozilla and is therefore called after Mozilla's 
				* handler because GTK dispatches events in their order of registration.
				*/
				OS.g_signal_connect (mozillaHandle, OS.key_press_event, eventProc, STOP_PROPOGATE);
				OS.g_signal_connect (mozillaHandle, OS.key_release_event, eventProc, STOP_PROPOGATE);
			}
		}
	}
	protected void onResize() {
		Rectangle rect = getClientArea();
		OS.gtk_widget_set_size_request(getEmbedHandle(), rect.width, rect.height);
	}
	protected void onDispose(Display display) {
		display.setData(ADD_WIDGET_KEY, new Object[] {new LONG(mozillaHandle), null});
	}	
		
	public static String error(int code) {
		throw new SWTError("XPCOM error "+code); //$NON-NLS-1$
	}
	
	static int /*long*/ eventProc (int /*long*/ handle, int /*long*/ gdkEvent, int /*long*/ pointer) {
		Widget widget = Display.getCurrent().findWidget(handle);
		if (widget != null && widget instanceof NativeBrowser) {
			return ((NativeBrowser)widget).gtk_event(handle, gdkEvent, pointer);
		}
		return 0;
	}

	protected abstract void Activate();
	
	int /*long*/ gtk_event (int /*long*/ handle, int /*long*/ gdkEvent, int /*long*/ pointer) {
		/* 
		* Stop the propagation of events that are not consumed by Mozilla, before
		* they reach the parent embedder.  These event have already been received.
		*/
		if (pointer == STOP_PROPOGATE) return 1;
	
		GdkEvent event = new GdkEvent ();
		OS.memmove (event, gdkEvent, GdkEvent.sizeof);
		// Added for #SPR LQPG875FWT
		if(event.type == OS.GDK_KEY_PRESS ){
			Activate() ;
		}
		// end
		switch (event.type) {
			case OS.GDK_BUTTON_PRESS:
			case OS.GDK_BUTTON_RELEASE: {
				/* 
				* Forward the event to the parent embedder before Mozilla receives it, 
				* as Mozilla may or may not consume it.
				*/
				OS.gtk_widget_event (this.handle, gdkEvent);
				break;
			}
		}
		return 0;
	}
	
	public static Shell newShell(Display display, int handle) {
		return Shell.gtk_new(display, handle);
	}
	
	public static Composite findBrowser(int /*long*/ handle) {
		/*
		* Note.  On GTK, Mozilla is embedded into a GtkHBox handle
		* and not directly into the parent Composite handle.
		*/
		int /*long*/ parent = OS.gtk_widget_get_parent(handle);
		Display display = Display.getCurrent();
		return (Composite)display.findWidget(parent); 
	}
	
	private static Composite fixIM(Composite parent) {
		/*
		* Note.  Mozilla provides all IM suport needed for text input in webpages.
		* If SWTcreates another input method context for the widget it will cause
		* undetermine results to happen (hungs and crashes). The fix is to prevent 
		* SWT from creating an input method context for the  Browser widget.
		*/
		if (parent != null && !parent.isDisposed()) {
			Display display = parent.getDisplay();
			if (display != null) {
				if (display.getThread() == Thread.currentThread ()) {
					display.setData (NO_INPUT_METHOD, "true");
				}
			}
		}
		return parent;
	}
	
	protected boolean initSWTService(){
		return SWTBrowserInitializer.initSWTService();
	}
	
	public static int openWindow(int parent,int chromeFlags,int contextFlags,
			int uri,int cancel, int newChrome){
		return SWTBrowserInitializer.openWindow(parent, chromeFlags, contextFlags,
				 uri, cancel,  newChrome);
	}
	
	public void addWindowSubclass(){}
	public void removeWindowSubclass () {}

	public void restoreNSMenu(){
		//Do nothing for Windows
	}
	public void backupNSMenu(){
		//Do nothing for Windows
	}
	public static void loadAdditionalLibraries(String mozillaPath){}
}