# /unix/nui/installer/tools/lib/tty.pl
#
# Used for Domino 11 fixpacks
# Used for Domino 12 fixpacks
#
# Used for Domino  9 hotfixes
# Used for Domino 10 hotfixes
# Used for Domino 11 hotfixes
# Used for Domino 12 hotfixes
#
## Copyright (c) 1996, Lotus Development Corporation.
## All Rights Reserved.



package TtyMode;

CdPath::Require("tty.nls");      import tty_nls;

# presuming pre-defined System package (SysCmd.pl) system-command vars


# Available in main:
#	TtyMode( raw|cooked )
#	TtyModeRestore()


sub main'TtyMode {
	local($Mode) = @_;
	local($raw) = "raw";
	local($raw_min0) = "raw_min0";
	local($cooked) = "cooked";
	local($zero, $one, $four);

	# Save the previous tty mode, only try once
	if (!$OldTtySaved) {
		$OldTty = `$Sys::stty -g`;
		chop($OldTty);
		if ($?) {
			print "$txt{'Cant_save'}\n";
			$OldTty = "";
		};
		$OldTtySaved = 1;
	}

	# Note: AIX needs different values to represent "1" and "0"
	# for setting "min" and "time" (they are the ascii character
	# which have 1 and 0 as their code value).
	$zero = ($ENV{'NUI_ARCH'} =~ /^aix/i) ? '\^@' : '0';
	$one =  ($ENV{'NUI_ARCH'} =~ /^aix/i) ? '\^A' : '1';
	$four = ($ENV{'NUI_ARCH'} =~ /^aix/i) ? '\^D' : '4';


	if ($Mode =~ /^$raw$/i && $mode ne $raw) {
		
		# Set stty mode at first execution, so we can read one
		# character at a time from stdin
		# non-canonical input, no echo, check for INTR and QUIT,
		# map <carrage return> to <new line>, enable reading of
		# one character at a time

		system(
		  "$Sys::stty -icanon -echo isig icrnl min $one time $zero");
		$mode = $raw;
		return;
	}
	if ($Mode =~ /^$raw_min0$/i && $mode ne $raw_min0) {
		        system(
          "$Sys::stty -icanon -echo isig icrnl min $zero time $zero");
        $mode = $raw_min0;
        return;
    }
	if ($Mode =~ /$cooked/i && $mode ne $cooked) {

		# Restore to our version of canonical input
		# Here we are setting min to 4 and time to 0

		system(
		  "$Sys::stty icanon echo isig icrnl min $four time $zero");
		$mode = $cooked;
		return;
	}
}


sub main'TtyModeRestore {
	if ( $OldTtySaved && $OldTty ) {
# !!!
#		&main'System("$Sys::stty '$OldTty'");
		system("$Sys::stty '$OldTty'");
	} else {
		&main'TtyMode("cooked");
	}
}

package main;

1;
