# /unix/nui/installer/tools/lib/UIS.pm
#
# Used for Domino 11 fixpacks
# Used for Domino 12 fixpacks
#
# Used for Domino  9 hotfixes
# Used for Domino 10 hotfixes
# Used for Domino 11 hotfixes
# Used for Domino 12 hotfixes
#
## Copyright (c) 1998, Lotus Development Corporation.
## All Rights Reserved.

if ( $ENV{'NUI_ARCH'} ne "os390") {
        CdPath::Require("UIS.nls");
} else {
         CdPath::Require("os390_UIS.nls");
}


CdPath::Require("tty.pl");

# base class of all screen types
package UIS; # "user interface screen(S?)"


CdPath::Require("PerlUtil.pl");  import PerlUtil;
CdPath::Require("MiscUtil.pl");  import MiscUtil;
CdPath::Require("PrmptUsr.pl");  import PrmptUsr;

# this needs to be in a BEGIN block for sub-classes of UIS to have it in
# their own namespace (??)
BEGIN { require "CdPath.pl"; CdPath::Require("More.pm"); }



# "class static" vars
#
$rows = 0;
$cols = 0;
#

sub new {
	local($class) = @_;

	$self = {};
	bless $self;

	return $self;
}


sub GetData {
	local($self, $var, $type) = @_;

	# GetData - get ref to data in one of several namespaces

	# in:
	#	$var:	variable name in string form
	#	$type:	type of variable data; "scalar" | "array" | "hash"
	# out: none
	# returns:
	#	Reference to data item located in one of several namespaces.
	#	location precedence:
	#		UIC_*		the custom screen object
	#		UIC			the general custom namespace (not a class)
	#		UIS_*		the specific screen type class 
	#					for the particular custom screen (baseclass of 
	#					the custom screen object)
	#		UIS			the baseclass of all screen classes

	local($uic, $uicbase, $uis, $uisbase, $pfx);

	if ($type eq "scalar") {
		$pfx = "\$";
	} elsif ($type eq "array") {
		$pfx = "\@";
	} elsif ($type eq "hash") {
		$pfx = "\%";
	}
		
	eval("\$uic		= \\$pfx$self->{UIC}::$var");
	eval("\$uicbase	= \\${pfx}UIC::$var");
	eval("\$uis		= \\$pfx$self->{UIS}::$var");
	eval("\$uisbase	= \\${pfx}UIS::$var");

	# This is a mess.  Doing scalars the 'old' way to avoid side-effects of this change.
	if ($type eq "scalar")
	{
		eval("defined(${pfx}\$uic)") && return $uic;
		eval("defined(${pfx}\$uicbase)") && return $uicbase;
		eval("defined(${pfx}\$uis)") && return $uis;
	}
	else
	{
		eval("${pfx}\$uic") && return $uic;
		eval("${pfx}\$uicbase") && return $uicbase;
		eval("${pfx}\$uis") && return $uis;
	}

	return $uisbase;
}


sub GetString {
	local($self, $var) = @_;

	local($data) = $self->GetData($var, "scalar");
	return $$data;
}


sub GenBanner {
	local($self, $txt) = @_;

	local($out);

	$out = '=' x ($UIS::cols-1) . "\n";
	$out .= ' ' x (($UIS::cols - length($txt))/2-2);
	$out .= "$txt\n";
	$out .= '=' x ($UIS::cols-1) . "\n";

	return $out;
}


sub DoNavText {
    local($self, $txt) = @_;
 
    local($out);

	if ( ! $txt) {
	    $txt = $self->GetString("navtext");
	}
 
    $out = '-' x ($UIS::cols-1) . "\n";
    $out .= $txt;
    $out .= '-' x ($UIS::cols-1) . "\n";
 
    print $out;
}


sub GetAction {
    local( $self, @ActionsSolicited ) = @_;

 
	local($_);
    local( @validchars, $retChar );

    foreach (@ActionsSolicited) {
        push( @validchars, @{$UIS_Action{$_}} );
    }
 
    $retChar = &GetMenuKey( @validchars );
	# !!!
	main::TtyModeRestore();
 
    foreach (@ActionsSolicited) {
        &IsMember( $retChar, @{$UIS_Action{$_}} ) &&
            return $_;
    }
}


sub GetInputString {
    local( $self ) = @_;
 
    local($_);
 
    main::TtyMode("cooked");
    $_ = <STDIN>;
 
    chomp;
    s/^\s+//;
    s/\s+$//;
 
    /\033/ && ($_ = "");
 
    return $_;
}



######################################################################
#
package UIS_Info;
@ISA = (UIS);

sub new {
	local($class) = @_;

	local($self) = new UIS (); 
    bless $self;
	$self->{UIS} = "UIS_Info";
    return $self;

}

sub GetAction {
	local($self) = @_;

	local($action);
	local(@validActions);

	if (defined($self->{ValidActions})) {
		@validActions = @{$self->{ValidActions}};
	} else {
		@validActions = qw(help exit prev next);
	}

	while (1) {
		system("tput clear");
		print $self->GenBanner($self->GetString("banner"));
		print $self->GetString("bodytext");
		$self->DoNavText();

		$action = $self->UIS::GetAction(@validActions);

        if ( $action eq "help" ) {
            system("tput clear");
            local( $more ) = new More ($UIS::rows, $UIS::cols);
            $more->Print( $self->GenBanner( $self->GetString("helpbanner") ) );
            $more->Print( $self->GetString("helptext") );
            $more->Print( "\n" . $self->GetString("returnfromhelp") );
            $more->Close();

			$self->UIS::GetAction(qw(next prev));
 
        } else {
            return $action;
        }
	}

}
#
######################################################################


######################################################################
#
package UIS_Scrolltext;
@ISA = (UIS);
 
sub new {
    local($class) = @_;
 
    local($self) = new UIS ();
    bless $self;
    $self->{UIS} = "UIS_Scrolltext";
    return $self;
 
}
 
sub GetAction {
    local($self) = @_;
 
    local($action);
    local(@validActions);
 
    if (defined($self->{ValidActions})) {
        @validActions = @{$self->{ValidActions}};
    } else {
        @validActions = qw(prev next);
    }

	system("tput clear");
	local($more) = new More ($UIS::rows, $UIS::cols);
	$more->Print($self->GenBanner($self->GetString("banner")));
	$more->Print($self->GetString("bodytext"));
	$more->Print("\n" . $self->GetString("navtext"));
	$more->Close();

	return $self->UIS::GetAction(@validActions);
}


sub DrawBody {
	local($self) = @_;

	system("tput clear");
	local($more) = new More ($UIS::rows, $UIS::cols);
	$more->Print($self->GenBanner($self->GetString("banner")));
	$more->Print($self->GetString("bodytext"));
	$more->Close();
}


#
######################################################################


######################################################################
#
package UIS_ListCycle;
@ISA = (UIS);
 
sub new {
    local($class) = @_;
 
    local($self) = new UIS ();
    bless $self;
    $self->{UIS} = "UIS_ListCycle";

    return $self;
 
}
 
sub GetAction {
    local($self, 
		$retTag		# \$retTag
	) = @_;
 
    local($action);
    local(@validActions, $defaultTag);
 
	# these are the actions to return on (cycle is handled by ListCycle())
	# though help is handled in here
    if (defined($self->{ValidActions})) {
        @validActions = @{$self->{ValidActions}};
    } else {
        @validActions = qw(prev next exit help);
    }

	$defaultTag = $self->{defaultTag};
 
    while (1) {
        system("tput clear");
        print $self->GenBanner($self->GetString("banner"));
        print $self->GetString("bodytext");
        $self->DoNavText();
		print "\n";
 
        $action = 
			$self->DoListCycle(
				$self->GetString("prompt"),
				$self->GetData("tags", "array"),
				$self->GetData("tagText", "hash"),
				$defaultTag,
				\@validActions,
				$retTag
			);

 
        if ( $action eq "help" ) {
			$defaultTag = $$retTag;
            system("tput clear");
            local( $more ) = new More ($UIS::rows, $UIS::cols);
            $more->Print( $self->GenBanner( $self->GetString("helpbanner") ) );
            $more->Print( $self->GetString("helptext") );
            $more->Print( "\n" . $self->GetString("returnfromhelp") );
            $more->Close();
 
            $self->UIS::GetAction(qw(next prev));
 
        } else {
            return $action;
        }
    }
}


sub DoListCycle {
	local($self, 
		$prompt,		# $prompt
		$tags,			# \@tags
		$tagText,		# \%tagText
		$defaultTag,	# $defaultTag
		$actions,		# \@actions
		$retTag			# \$retTag
	) = @_;

	local($_);
	local($maxlen);
	local(@cycleLines);
	local($tmpLine);
	local($i);


	# if prompt is multi-line, print all but the last, and eat prior
	#
	if ($prompt =~ /\n/) {
		local($prePrompt);
		($prePrompt) = ($prompt =~ /(^.*\n)[^\n]*$/s);
		print $prePrompt;
		($prompt) = ($prompt =~ /^.*\n([^\n]*$)/s);

	}

	# determine the length of the longest cycle string
	#
	$maxlen = 0;
	foreach (@$tags) {
		if ($maxlen < length($tagText->{$_})) {
			$maxlen = length($tagText->{$_});
		}
	}

	# setup list of premade cycle lines
	#
	@cycleLines = ();
	foreach $_ (@$tags) {
		$tmpLine = $prompt . '[' . $tagText->{$_} . 
			' ' x ($maxlen - length($tagText->{$_})) .
			']';
		push(@cycleLines, $tmpLine);
	}

	# determine the default index
	#
	for ($i=0; $i <= $#{$tags}; $i++) {
		if ($$tags[$i] eq "$defaultTag") {
			last;
		}
	}

	# cycle it, oh yah
	$$retTag = $defaultTag;
	while (1) {
		print "\015";
		print $cycleLines[$i];

		$action = $self->UIS::GetAction((@$actions, "cycle"));

		if ($action ne "cycle") {
			return $action;
		}

		++$i;
		if ($i > $#{$tags}) {
			$i = 0;
		}
		$$retTag = $$tags[$i];
	}
}

#
######################################################################


######################################################################
#
package UIS_BoolCycle;
@ISA = (UIS_ListCycle);

sub new {
	local($class) = @_;

	local($self) = new UIS_ListCycle ();
	bless $self;
	$self->{UIS} = "UIS_BoolCycle";

	return $self;
}


sub GetAction {
	local($self, $retVal) = @_;

	$self->{defaultTag} = $self->{defaultVal};
	return $self->UIS_ListCycle::GetAction($retVal);
}
#
######################################################################


######################################################################
#
package UIS_StringEdit;
@ISA = (UIS);

sub new {
	local($class) = @_;

	local($self) = new UIS ();
    bless $self;
    $self->{UIS} = "UIS_StringEdit";
 
    return $self;
}


sub GetAction {
	local($self, 
		$retStr		# \retStr
	) = @_;

	local($action, @validActions);

	
	$$retStr = $self->{defaultStr};


	if (defined($self->{ValidActions})) {
		@validActions = @{$self->{ValidActions}};
	} else {
		@validActions = qw(edit prev next exit help);
	}

	
	while (1) {
		system("tput clear");
		print $self->GenBanner($self->GetString("banner"));
		print $self->GetString("bodytext");
		$self->DoNavText();
		print "\n";
		print $self->GetString("stringtext") . $$retStr . "\n";

		# display the string & prompt
		# get the string

		$action = $self->UIS::GetAction(@validActions);

		if ($action eq "edit") {
			system("tput clear");
			print $self->GenBanner($self->GetString("banner"));
			print $self->GetString("bodytext");
			$self->DoNavText($self->GetString("navtext_edit"));
			print "\n";
			print $self->GetString("stringtext") . $$retStr . "\n\n";
			print $self->GetString("prompttext");

			$tmpStr = $self->GetInputString();

			if ($tmpStr) {
				if ($self->{CustomManipulateString}) {
					$$retStr = $self->CustomManipulateString($tmpStr);
				} else {
					$$retStr = $tmpStr;
				}
			}
	

		} elsif ($action eq "help") {
            system("tput clear");
            local( $more ) = new More ($UIS::rows, $UIS::cols);
            $more->Print( $self->GenBanner( $self->GetString("helpbanner") ) );
            $more->Print( $self->GetString("helptext") );
            $more->Print( "\n" . $self->GetString("returnfromhelp") );
            $more->Close();
 
            $self->UIS::GetAction(qw(next prev));

		} else {
			return $action;
		}
	}
}

#
######################################################################


######################################################################
#
package UIS_NumberEdit;
@ISA = (UIS);

sub new {
	local($class) = @_;

	local($self) = new UIS ();
    bless $self;
    $self->{UIS} = "UIS_NumberEdit";
 
    return $self;
}


sub GetAction {
	local($self, 
		$retVal		# \retVal
	) = @_;

	local($action, @validActions);

	
	$$retVal = $self->{defaultVal};


	if (defined($self->{ValidActions})) {
		@validActions = @{$self->{ValidActions}};
	} else {
		@validActions = qw(edit prev next exit help);
	}

	
	while (1) {
		system("tput clear");
		print $self->GenBanner($self->GetString("banner"));
		print $self->GetString("bodytext");
		$self->DoNavText();
		print "\n";
		print $self->GetString("stringtext") . $$retVal . "\n";

		# display the string & prompt
		# get the number

		$action = $self->UIS::GetAction(@validActions);

		if ($action eq "edit") {
			system("tput clear");
			print $self->GenBanner($self->GetString("banner"));
			print $self->GetString("bodytext");
			$self->DoNavText($self->GetString("navtext_edit"));
			print "\n";
			print $self->GetString("stringtext") . $$retVal . "\n\n";
			print $self->GetString("prompttext");

			$tmpStr = $self->GetInputString();

			# keep it only if it is a number, and in the specified range
			local ($_) = $tmpStr;
			s/\s*//g;
			s/$\\+//;
			if (/^\d+$/ || /^-\d+$/) {
				if ( (! $self->{minVal}) || ($_ >= $self->{minVal})) {
					if ( (! $self->{maxVal}) || ($_ <=  $self->{maxVal})) {
						$$retVal = $_;
					}
				}
			}
	

		} elsif ($action eq "help") {
            system("tput clear");
            local( $more ) = new More ($UIS::rows, $UIS::cols);
            $more->Print( $self->GenBanner( $self->GetString("helpbanner") ) );
            $more->Print( $self->GetString("helptext") );
            $more->Print( "\n" . $self->GetString("returnfromhelp") );
            $more->Close();
 
            $self->UIS::GetAction(qw(next prev));

		} else {
			return $action;
		}
	}
}

#
######################################################################

1;
