# /unix/nui/installer/tools/lib/ShScript.pm
#
# Used for Domino 11 fixpacks
# Used for Domino 12 fixpacks
#
# Used for Domino  9 hotfixes
# Used for Domino 10 hotfixes
# Used for Domino 11 hotfixes
# Used for Domino 12 hotfixes
#
## Copyright (c) 1997, Lotus Development Corporation.
## All Rights Reserved.


require 5.000;

package ShScript;

CdPath::Require("ShScript.nls"); import ShScript_nls;

CdPath::Require("MiscUtil.pl");  import MiscUtil;

# presuming pre-defined Sys package (syscmd.pl) system-command vars

# new 
# GetError 
# SetLocalHost 
# RunScript 
# RunScriptLocalFromFile 
# RunScriptRemoteFromFile 
# RunScriptPipeToRemote 
# RunScriptPipeDataToRemote 

sub new {
	local($class) = @_;

	my $self = {};
	bless $self;

	%$self = (
		'error'				=> "",
		'localhost'			=> "",
		'shellmap'			=> {},
		'defaultshell'		=> "sh",
		
	);

	return $self;
}


sub GetError {
	local($self) = @_;
	
	return $self->{'error'};
}


sub SetLocalHost {
	local($self, $localhost) = @_;

	$self->{'localhost'} = $localhost;
}


sub RunScript {
	local($self, $host, $cmd, $r_status, $r_output) = @_;

	local($scriptfile);
	local(*SCRIPTFILE);
	local($ret);

	$scriptfile = "/tmp/ShScript.$$." . &GetDateTimeFormattedInteger();
	if ( ! open(SCRIPTFILE, ">$scriptfile")) {
		$self->{'error'} = $!;
		return 0;
	}
	print SCRIPTFILE $cmd;
	if ( ! close(SCRIPTFILE)) {
		$self->{'error'} = $!;
		return 0;
	}

	
	if ($host eq $self->{'localhost'}) {
		$ret = $self->RunScriptLocalFromFile($scriptfile, $r_status, $r_output);
	} else {
		$ret = 
			$self->RunScriptRemoteFromFile(
				$host, $scriptfile, $r_status, $r_output
			);
	}

	unlink($scriptfile);

	return $ret;
}


sub RunScriptLocalFromFile {
	local($self, $cmdfile, $r_status, $r_output) = @_;

	local($shcmd) = "<$cmdfile sh 2>&1";

	$$r_output = `$shcmd`;
	$$r_status = ($? >> 8);

	return 1;
}


sub RunScriptRemoteFromFile {
	local($self, $host, $cmdfile, $r_status, $r_output) = @_;

	local($shell, $tmp, $rshcmd, $tmpret);

	# If we haven't already determined what shell to use, we
	# have to do it now (Thanks alot, HP)
	#
	if ( ! ($shell = $self->{'shellmap'}->{$host})) {
		$tmp = `$Sys::rsh $host "uname" 2>&1`;
		chomp($tmp);
		if ($tmp eq "HP-UX") {
			$tmp = `$Sys::rsh $host "/usr/bin/ls /usr/old/bin/sh" 2>&1`;
			chomp($tmp);
			if ($tmp eq "/usr/old/bin/sh") {
				$shell = $self->{'shellmap'}->{$host} = "/usr/old/bin/sh";
			} else {
				$shell = $self->{'shellmap'}->{$host} = "sh";
			}
		} else {
			$shell = $self->{'shellmap'}->{$host} = $self->{'defaultshell'};
		}
	}

	$rshcmd = 
		"<$cmdfile $Sys::rsh $host \"$shell -c " .
		"'(2>&1 $shell; ret=\\\$?; sleep 1; echo status=\\\$ret)'\"";
	
	$tmp = `$rshcmd 2>&1`;
	if ($?) {
		$self->{'error'} = "$txt{'unable_rsh'}    $tmp";
		return 0;
	}
#print "RunScriptRemoteFromFile out:>\n$tmp\n<\n";
	
	chomp($tmp);
	@tmp = split('\n', $tmp);
	$tmpret = pop(@tmp);
	$tmp = join("\n", @tmp);
	$tmp .= "\n";
#print "--->\n";
#print "tmp    : $tmp\n";
#print "tmpret : $tmpret\n";
#print "<---\n";

	if ( ! ($tmpret =~ /^status=[0-9]+$/)) {
		$self->{'error'} = "$txt{'unknown_rsh'}\n";
		return 0;
	}
	$tmpret =~ /^status=([0-9]+)$/;
	$$r_status = $1;

	$$r_output = $tmp;

	
	return 1;
}


sub RunScriptPipeToRemote {
	local($self, $host, $localcmd, $remotecmd, $r_status, $r_output) = @_;

	local($shell, $tmp, $cmd, $tmpret);

	# If we haven't already determined what shell to use, we
	# have to do it now (Thanks alot, HP)
	#
	if ( ! ($shell = $self->{'shellmap'}->{$host})) {
		$tmp = `$Sys::rsh $host "uname" 2>&1`;
		chomp($tmp);
		if ($tmp eq "HP-UX") {
			$tmp = `$Sys::rsh $host "/usr/bin/ls /usr/old/bin/sh" 2>&1`;
			chomp($tmp);
			if ($tmp eq "/usr/old/bin/sh") {
				$shell = $self->{'shellmap'}->{$host} = "/usr/old/bin/sh";
			} else {
				$shell = $self->{'shellmap'}->{$host} = "sh";
			}
		} else {
			$shell = $self->{'shellmap'}->{$host} = $self->{'defaultshell'};
		}
	}


	if ($host ne $self->{'localhost'}) {
		$cmd = 
			"(${localcmd} | " .
			"$Sys::rsh $host " .
			"\"$shell -c '(2>&1 ${remotecmd} 2>&1; " .
			"ret=\\\$?; sleep 1; echo status=\\\$ret)'\")";
	} else {
		$cmd = 
			"${localcmd} | " .
			"${remotecmd} 2>&1; ret=\$?; sleep 1; echo status=\$ret";
	}
	
	$tmp = `$cmd 2>&1`;
	$$r_output = $tmp;
	if ($$r_status = $?) {
		$self->{'error'} = "$txt{'unknown_pipe'}\n$tmp";
		return 0;
	}
	
	chomp($tmp);
	@tmp = split('\n', $tmp);
	$tmpret = pop(@tmp);
	$tmp = join("\n", @tmp);
	$tmp .= "\n";

	if ( ! ($tmpret =~ /^status=[0-9]+$/)) {
		$self->{'error'} = "$txt{'unknown_pipe'}\n";
		$$r_status = 255;
		return 0;
	}

	$tmpret =~ /^status=([0-9]+)$/;
	$$r_status = $1;

	$$r_output = $tmp;
	
	return 1;
}


sub RunScriptPipeDataToRemote {
	local($self, 
		$host, $data, $remotecmd, $r_status, $r_output) = @_;


	local(*DATAFILE);

	local($datafile) = "/tmp/ShScriptData.$$";
    if ( ! open(DATAFILE, ">$datafile")) {
        $self->{'error'} = $!;
        return 0;
    }
    print DATAFILE $data;
    if ( ! close(DATAFILE)) {
        $self->{'error'} = $!;
        return 0;
    }


	local($localcmd) = "$Sys::cat $datafile";

	local($ret) = 
		$self->RunScriptPipeToRemote($host, $localcmd, $remotecmd, $r_status, $r_output);

	unlink($datafile);

	return $ret;
}


1;
