# /unix/nui/installer/tools/lib/PerlUtil.pl
#
# Used for Domino 11 fixpacks
# Used for Domino 12 fixpacks
#
# Used for Domino  9 hotfixes
# Used for Domino 10 hotfixes
# Used for Domino 11 hotfixes
# Used for Domino 12 hotfixes
#

require 5.000;

## Copyright (c) 1998, Lotus Development Corporation.
## All Rights Reserved.


package PerlUtil;

CdPath::Require("Exporter.pm");
@ISA = (Exporter);
@EXPORT = qw(	
	CopyData
	CopyDataWOKeyLists
	DumpData
	DumpDataToString
);


sub CopyData {
	local($in, $nokeylist) = @_;

	local($out);

	if (ref($in) eq "REF") {
		local($newref);
		$out = \$newref;
		$$out = &CopyData($$in, $nokeylist);

	} elsif (ref($in) eq "SCALAR") {
		local($newscalar);
		$newscalar = $$in;
		$out = \$newscalar;

	} elsif (ref($in) eq "ARRAY") {
		local($elem);
		$out = [];
		foreach $elem (@$in) {
			push(@$out, &CopyData($elem, $nokeylist));
		}

	} elsif (ref($in) eq "HASH") {
		local($key);
		$out = {};
		foreach $key (keys(%$in)) {
			if ($nokeylist) {
				($key eq "_KeyList_") && next;
			}
			$out->{$key} = &CopyData($in->{$key}, $nokeylist);
		}

	} else {
		$out = $in
	}


	return $out;
}


sub CopyDataWOKeyLists {
	local($in) = @_;

	return &CopyData($in, 1);
}


sub DumpData{

	# print DumpDataToString(...) prints nothing (??)
	local($out) = DumpDataToString(@_);
	print $out;
}


sub DumpDataToString {
	local($in, $indent, $nolabel, @hashKeyExceptionList) = @_;

	$indent  = defined($indent)  ? $indent  : 0;
	$nolabel = defined($nolabel) ? $nolabel : 0;

	local($_);
	local($indentinc) = 2;
	local($out) = "";

	local(%hashKeyExceptionHash);
	foreach (@hashKeyExceptionList) {
			$hashKeyExceptionHash{$_} = 1;
	}

	if (!ref($in)) {
		$out .= " " x $indent;
		$out .= ">${in}<\n";

	} elsif (ref($in) eq "SCALAR") {
		if (! $nolabel) {
			$out .= " " x $indent;
			$out .= "(scalar ref)\n";
		}
		$out .= DumpDataToString($$in, ($indent+$indentinc));

	} elsif (ref($in) eq "REF") {
		if (! $nolabel) {
			$out .= " " x $indent;
			$out .= "(ref ref)\n";
		}
		$out .= DumpDataToString($$in, ($indent+$indentinc));

	} elsif (ref($in) eq "ARRAY") {
		if (! $nolabel) {
			$out .= " " x $indent;
			$out .= "(array ref)\n";
		}
		foreach (@{$in}) {
			$out .= DumpDataToString($_, ($indent+$indentinc));
		}

	} else {
		if (! $nolabel) {
			$out .= " " x $indent;
			if (ref($in) eq "HASH") {
				$out .= "(hash ref)\n";
			} else {
				$out .= "(" . ref($in) . ")\n";
			}
		}
		foreach (sort(keys(%{$in}))) {
			if ($hashKeyExceptionHash{$_}) {
				next;
			}
			if ($_ eq "_KeyList_") {
				next;
			}
			$out .= " " x $indent;
			$out .= "key: >$_<  ";
			$nolabel = 0;
			if (ref($in->{$_}) eq "ARRAY") {
				$out .= "(array ref)\n";
				$nolabel = 1;
			} elsif (ref($in->{$_}) eq "HASH") {
				$out .= "(hash ref)\n";
				$nolabel = 1;
			} else {
				$out .= "\n";
			}
			$out .= DumpDataToString($in->{$_}, ($indent+5), $nolabel);
		}
	}

	return $out;
}


1;
