# /unix/nui/installer/tools/lib/More.pm
#
# Used for Domino 11 fixpacks
# Used for Domino 12 fixpacks
#
# Used for Domino  9 hotfixes
# Used for Domino 10 hotfixes
# Used for Domino 11 hotfixes
# Used for Domino 12 hotfixes
#
## Copyright (c) 1996, Lotus Development Corporation.
## All Rights Reserved.


require 5.000;
package More;

CdPath::Require("More.nls"); import More_nls;

CdPath::Require("MiscUtil.pl"); import MiscUtil;
CdPath::Require("tty.pl"); import TtyMode;


# only one 'more' instance at a time - duh
#
local( *READFH, *WRITEFH );

sub new {
    local( $class, $rows, $cols ) = @_;
 
    my $self = {};
    bless $self;

	# config
	#
	$self->{rows} = $rows;
	$self->{cols} = $cols;

	# state
	#
	$self->{cScrRows} = $self->{rows} - 1;
	$self->{cCurRow} = 1;

	return $self->Init();
}


sub Init {
	local( $self ) = @_;

	pipe( READFH, WRITEFH ) || return undef;

	if ($self->{'child'} = fork()) {
		# parent - writer
		$ENV{'NI_DEBUG_MORE'} && print "More child is $self->{'child'}\n";

		close( READFH );
		$self->{'parent'} = 1;
		select( WRITEFH );
		$| = 1;

		return $self;

	} elsif (defined $self->{'child'}) {
		# child - reader
	
		close( WRITEFH );
		while (<READFH>) {
			$self->Print( $_ );
		}
		close( READFH );

		exit 0;

	} else {
		return undef;
	}
}


sub Print {
	local( $self, $toprint ) = @_;

	local($_, @lines, $line, @words, $ret);
	local($bLineDone, $text, $newlen);
	local( $trailing_newlines ) = 0;


	local( $oldfh ) = select( STDOUT ); 
	$| = 1;
	

	if ( defined( $self->{'parent'} ) ) {
		print WRITEFH $toprint;
		return 1;
	}

	
	if ($toprint =~ /^\s*\n\s*$/) {
		print "\n";
		select($oldfh);
		return 1;
	}

	@lines = split(/\n/, $toprint);
	foreach $line (@lines) {
		if ( ! $line) {
			print "\n";
			++$self->{cCurRow};
            if ($self->{cCurRow} > $self->{cScrRows}) {
                $self->Wait();
                $self->{cCurRow} = 1;
            }
			next;
		}
		@words = split(/ /, $line);
		while (@words) {
			$text = "";
			$bLineDone=0;
			# to handle very long word, for example, a HTTP web link 
			if (length($words[0]) >= $self->{cols}) {
				$text .= $words[0] . " ";			
				$text =~ s/ $//;
				print "$text\n";
				shift(@words);
				$self->{cCurRow} += int(length($words[0]) / $self->{cols});
				if ($self->{cCurRow} > $self->{cScrRows}) {
					$self->Wait();
					$self->{cCurRow} = 1;
				}
				next;
			}
			while (! $bLineDone) {
				$newlen = 
					length($text) +
					length($words[0]) + 
					(length($text) ? 1 : 0);
				if ($newlen < $self->{cols}) {
					$text .= $words[0] . " ";
					shift(@words);
					$bLineDone = (! scalar(@words));
				} else {
					$bLineDone = 1;
				}
			}
			$text =~ s/ $//;
			print "$text\n";
			++$self->{cCurRow};
			if ($self->{cCurRow} > $self->{cScrRows}) {
				$self->Wait();
				$self->{cCurRow} = 1;
			}
		}
	}

	

if (0) {
	@lines = split( /\n/, $toprint );

	while (defined($line = shift(@lines))) {
		print $line;
		if (@lines) {
			print "\n";
			++$self->{'num_thusfar'};
			if ( $self->{'num_thusfar'} == $num_toprint ) {
				$self->{'flag_beginscroll'} = 0;
				$self->{'num_thusfar'} = 0;
				$self->Wait();
			}
		}
	}

	while ($trailing_newlines--) {
		print "\n";
		++$self->{'num_thusfar'};
		if ( $self->{'num_thusfar'} == $num_toprint ) {
			$self->{'flag_beginscroll'} = 0;
			$self->{'num_thusfar'} = 0;
			$self->Wait();
		}
	}
}
	select( $oldfh );
}


sub Wait {
	local( $self ) = @_;

	local( $waitmsglen ) = length( $txt{'continue'} );
	local( $c );

	print $txt{'continue'};

	# This works on hppa100, sunspa54, ibmpow41, & solx8654
	# This is necessary rather than a normal read because of
	# what appears to be a bug in hp.  If blocked on a read here while
	# some other process finishes with which there was a pipe in this
	# process, the read would block indefinately.
	#
	&main::TtyMode("raw");
	&main::TtyMode("raw_min0");
	&WaitStdinReady();

	&main::TtyMode("raw");
	read( STDIN, $c, 1 );

	print "\b" x $waitmsglen;
	print " "  x $waitmsglen;
	print "\b" x $waitmsglen;
}


sub Close {
	local( $self ) = @_;

	local( $ret );


	$ENV{'NI_DEBUG_MORE'} && print "about to close WRITEFH\n";
	close( WRITEFH );

	$ENV{'NI_DEBUG_MORE'} && print "about to waitpid on $self->{'child'}\n";
	$ret = waitpid( $self->{'child'}, 0 );
	$ENV{'NI_DEBUG_MORE'} && print "waitpid on $self->{'child'}: $ret\n";

	undef $self->{'parent'};
	undef $self->{'child'};
	
	return 1;
}


1;
