# /unix/nui/installer/tools/lib/MiscUtil.pl
#
# Used for Domino 11 fixpacks
# Used for Domino 12 fixpacks
#
# Used for Domino  9 hotfixes
# Used for Domino 10 hotfixes
# Used for Domino 11 hotfixes
# Used for Domino 12 hotfixes
#
require 5.000;

## Copyright (c) 1997, Lotus Development Corporation.
## All Rights Reserved.


CdPath::Require("PerlUtil.pl");  import PerlUtil;

package MiscUtil;

CdPath::Require("Exporter.pm");
@ISA = (Exporter);
@EXPORT = qw(	IsMember 
				ListBoolInclude
				ListBoolOrderInclude
				HashMergeCopy
				WaitStdinReady
				Nap
				IndentText
				AddItemToArrayHash
				StringListIsEqual
				PrintIndented
				LengthOfLastLine
				IndentAfterFirstLine
				GetPathData
				GetDateTimeFormattedInteger
				PrintText
				TreeChangeCase
);


$level_indent = 4;

sub IsMember {
	local( $element, @list ) = @_;

	return( grep( /^$element$/, @list ) );
}


sub ListBoolInclude {
	local( $listref, $member, $boolval ) = @_;

	if ($boolval) {
		if ( ! grep( /^$member$/, @$listref ) ) {
			push( @$listref, $member );
		}
	} else {
		if ( grep( /^$member$/, @$listref ) ) {
			for (0..$#{$listref}) {
				if ( ${$listref}[$_] eq $member ) {
					splice( @$listref, $_, 1 );
				}
			}
		}
	}
}

sub ListBoolOrderInclude {
	local( $listref, $member, $boolval, $orderlistref ) = @_;

	local( @newlist ) = ();

	foreach $i (@{$orderlistref}) {
		if ($member eq $i) {
			$boolval && push( @newlist, $member );
		} elsif ( grep( /^$i$/, @$listref ) ) {
			push( @newlist, $i );
		}
	}

	@$listref = @newlist;
}


sub HashMergeCopy {
	local( $dsthash, $srchash ) = @_;

	foreach $key (keys(%$srchash)) {
		$dsthash->{$key} = &CopyData($srchash->{$key});
	}
}


sub WaitStdinReady {
    local($rin) = "";
    local($nfd);
    vec($rin, fileno(STDIN), 1) = 1;
    return $nfd = select($rin,undef,undef,undef);
}
 

sub Nap {
    local( $time ) = @_;
    select(undef, undef, undef, $time );
}


sub IndentText {
    local( $indent, $text ) = @_;
 
    local( @lines, $tmp );
	local( $trailing_newlines ) = 0;
	local( $newtext ) = "";
 
	# chomp doesn't seem to always chomp > 1 as doc'd
	#
	while ( $tmp = chomp( $text ) ) {
		$trailing_newlines += $tmp;
	}

    @lines = split('\n', $text);
    while (@lines) {
        $_ = shift(@lines);
		$newtext .= " " x $indent;
		$newtext .= $_;
        (@lines) && ($newtext .= "\n");
    }
	$newtext .= "\n" x $trailing_newlines;
}


sub AddItemToArrayHash {
	local( $hashref, $key, $item ) = @_;

	if ( ref($hashref->{$key}) ne "ARRAY" ) {
		$hashref->{$key} = [];
	}

	push( @{$hashref->{$key}}, $item );
}


sub StringListIsEqual {
	local( $listref1, $listref2 ) = @_;

	(scalar(@{$listref1}) != scalar(@{$listref2})) && return 0;

	for ($i=0; $i<scalar(@{$listref1}); $i++) {
		(${$listref1}[$i] ne ${$listref2}[$i]) && return 0;
	}

	return 1;
}


sub PrintIndented {
	local( $indent, $toprint ) = @_;
	
	local( @lines, $trailing_newlines );

	$trailing_newlines = chomp( $toprint );
	@lines = split('\n', $toprint);
	while (@lines) {
		$_ = shift(@lines);
		print " " x $indent;
		print;
		(@lines) && print "\n";
    }
	print "\n" x $trailing_newlines;
}


sub IndentAfterFirstLine {
	local( $indent, $text ) = @_;

	local( $line, @lines, $trailing_newlines, $tmp );
	local( $newtext ) = "";

    while ( $tmp = chomp( $text ) ) {
        $trailing_newlines += $tmp;
    }
    @lines = split('\n', $text);
	$newtext = shift(@lines);
	(@lines) && ($newtext .= "\n");
    while (@lines) {
        $line = shift(@lines);
        $newtext .= " " x $indent;
        $newtext .= $line;
        (@lines) && ($newtext .= "\n");
    }
    $newtext .=  "\n" x $trailing_newlines;
}


sub LengthOfLastLine {
	local( $text ) = @_;

	(chomp( $text ) > 1 ) && return 0;

	local( @lines ) = split( '\n', $text );

	return length($lines[$#lines]);
}


sub GetPathData {
	local( $arch, $path, $rFreeSpace, $rMountPoint ) = @_;

	# in:	$arch - sol, solx86, aix, hpux, linux, zlinux, os390
	#		$path - absolute path for which to check disk space, 
	#				does not need to exist
	# out:	$$rFreeSpace - free space in k for $path
	#		$$rMountPoint - the filesystem mountpoint corresponding to $path
	# returns:  undef for usage error, else true


	local( $cmd, *DFOUT, $existPath );
	local( $dfout ) = "";
	
	$existPath = $path;
    while ( ! -d $existPath) {
        $existPath =  `$Sys::dirname $existPath`; chomp($existPath)
    }

	if ( $arch =~ /^sol/ ) {
		$cmd = "/usr/sbin/df -k $existPath";
	} elsif ( $arch =~ /^aix/ ) {
		$cmd = "/usr/bin/df -k $existPath";
	} elsif ( $arch =~ /^hpux/ ) {
		$cmd = "/usr/bin/df -k $existPath";
	} elsif ( $arch =~ /^linux/ ) {
		$cmd = "/bin/df -kP $existPath";
	} elsif ( $arch =~ /^zlinux/ ) {
		$cmd = "/bin/df -kP $existPath";
	} elsif ( $arch =~ /^os390/ ) {
		$cmd = "/bin/df -kP $existPath";
	} else {
		return undef;
	}

	open( DFOUT, "$cmd |" ) || return undef;
	while (<DFOUT>) {
		$dfout .= $_;
	}
	close( DFOUT );

	if (($arch =~ /^sol/) || ($arch =~ /linux/) || ($arch =~ /zlinux/)) {
		$$rFreeSpace = (split( /[ \t\n]+/, (split( /^/, $dfout ))[1] ))[3];
		$$rMountPoint = (split( /[ \t\n]+/, (split( /^/, $dfout ))[1] ))[5];

	} elsif ($arch =~ /^aix/) {
		$$rFreeSpace = (split( /[ \t\n]+/, (split( /^/, $dfout ))[1] ))[2];
		$$rMountPoint = (split( /[ \t\n]+/, (split( /^/, $dfout ))[1] ))[6];

	} elsif ($arch eq "os390") {
		$$rFreeSpace = (split( /[ \t\n]+/, (split( /^/, $dfout ))[1] ))[3];
		$$rMountPoint = (split( /[ \t\n]+/, (split( /^/, $dfout ))[1] ))[5];

	} elsif ($arch eq "hpux") {
		$$rFreeSpace = (split( /[ \t\n]+/, (split( /^/, $dfout ))[1] ))[1];
		$$rMountPoint = (split( /[ \t\n]+/, (split( /^/, $dfout ))[0] ))[0];
	}

	return 1;
}


sub GetDateTimeFormattedInteger {

	local(@lt) = localtime(time());

	return(
		sprintf(
			"%02d%02d%02d.%02d%02d%02d",
			$lt[5],
			$lt[4]+1,
			$lt[3],
			$lt[2],
			$lt[1],
			$lt[0]
		)
	);
}


sub PrintText {
    local( $text, $indent, $special ) = @_;
 
    local( @lines, $trailing_newlines, $tmp );
 
    $trailing_newlines = 0;
    while( $tmp = chomp( $text ) ) {
        $trailing_newlines += $tmp;
    }
    @lines = split('\n', $text);
    if ( $special eq "noindent_firstline" ) {
        print shift(@lines);
        (@lines) && print "\n";
    }
    while (@lines) {
        $_ = shift(@lines);
        print " " x $indent;
        print;
        (@lines) && print "\n";
    }
    print "\n" x $trailing_newlines;
}


sub TreeChangeCase {
	local( $tree, $case ) = @_;

	local(*FIND, $treeparent, $dir, $file);
     if ( $ENV{'NUI_ARCH'} ne "os390") {
     	local($dirname)		= "/usr/bin/dirname";
	local($basename)	= "/usr/bin/basename";
	local($find)		= "/usr/bin/find";
	local($mv)			= "/usr/bin/mv";
     } else {
	local($dirname)		= "/bin/dirname";
	local($basename)	= "/bin/basename";
	local($find)		= "/bin/find";
	local($mv)			= "/bin/mv";
     }
	if (! $case) {
		$case = "lower";
	}

	if ($case ne "upper" && $case ne "lower") {
		return 0;
	}

	(-d $tree) || return 0;

	open(FIND, "$find $tree -depth -print|") || return 0;
	while (<FIND>) {
		chomp;
		$dir = `$dirname $_`;
		chomp($dir);
		$file = `$basename $_`;
		chomp($file);
		$newfile = $file;
		if ($case eq "lower") {
			$newfile =~ y/[A-Z]/[a-z]/;
		} else {
			$newfile =~ y/[a-z]/[A-Z]/;
		}
		if ($file ne $newfile) {
			system("$mv $dir/$file $dir/$newfile");
			if ($?) {
				return 0;
			}
		}
	}
	return 1;
}


1;
