# /unix/nui/installer/tools/lib/InvUtil.pl
#
# Used for Domino 11 fixpacks
# Used for Domino 12 fixpacks
#
# Used for Domino  9 hotfixes
# Used for Domino 10 hotfixes
# Used for Domino 11 hotfixes
# Used for Domino 12 hotfixes
#
require 5.000;

## Copyright (c) 1996, Lotus Development Corporation.
## All Rights Reserved.


package InvUtil;

CdPath::Require("Exporter.pm");
@ISA = (Exporter);
@EXPORT = qw(	GenInv
				VerifyInv
				GetChecksum
);


CdPath::Require("InvUtil.pl");  import InvUtil;


sub InitSysCmds {

     if ( $ENV{'NUI_ARCH'} ne "os390") {
	$System::sum = "/usr/bin/sum";
     } else {
	$System::sum = "/bin/sum";
     }

	($ENV{'LARCH_NOREV'} eq "ibmpow") && 
		($System::sum = "/usr/bin/sum -o");
}


sub GenInv {
	local( $err_ref, $root, $filelist_ref, $attrs_ref ) = @_;

	undef $$err_ref;

	local( @invlist, $invline, $file, $tmp, @tmp );

	&InitSysCmds();

	if ( ! chdir($root) ) {
		$$err_ref = "$txt{'cant_chdir $root'}\n";
		return 0;
	}

	foreach $file (@{$filelist_ref}) {
		$invline = $file;

		foreach $attr (@{$attrs_ref}) {

			if ($attr eq "sum") {
				if ( -d $file ) {
					$invline .= " d";
					next;
				}
				$_ = `$System::sum $file 2>&1`;
				if ($? != 0) {
					$$err_ref = "$txt{'cant'} $System::sum $file\n";
					return 0;
				}
				$invline .= " " . (split())[0]
			} elsif ($attr eq "mode") {
				@tmp = stat($file);
				if ( ! @tmp) {
					$$err_ref = "$txt{'cant_stat'} $file\n";
					return 0;
				}
				$tmp = $tmp[2];
				$tmp = $tmp & oct("07777");
				$tmp = sprintf("0%lo", $tmp);
				$invline .= " " . $tmp;
			} elsif ($attr eq "size") {
				@tmp = stat($file);
				if ( ! @tmp) {
					$$err_ref = "$txt{'cant_stat'} $file\n";
					return 0;
				}
				$tmp = $tmp[7];
				$invline .= " " . $tmp;
			}
		}

		push( @invlist, $invline );
	}

	return \@invlist;
}


sub GetChecksum {
	local( $err_ref, $file ) = @_;

	local( $sum );
	
	&InitSysCmds();

	undef $$err_ref;

	if ( -d $file ) {
		return "d";
	}

	$_ = `$System::sum $file 2>&1`;
	if ($? != 0) {
		$$err_ref = "$txt{'cant'} $System::sum $file\n";
		return 0;
	}
	
	chomp($_);

	return (split())[0];
}



sub VerifyInv {
	local( $err_ref, $root, $invlist_ref, $attrs_ref ) = @_;

	undef $$err_ref;

	local( $invline, $tmp, @tmp, $file, $attr, $sum, $mode );
	local( $ret ) = 1;

	&InitSysCmds();

	if ( ! chdir($root) ) {
        $$err_ref = "$txt{'cant_chdir $root'}\n";
        return 0;
    }
 
    foreach $invline (@{$invlist_ref}) {

		$_ = $invline;
		@tmp = split();
		$file = shift( @tmp );

		foreach $attr (@{$attrs_ref}) {

			if ($attr eq "sum") {
				$sum = shift( @tmp );
				if (-d $file) {
					if ($sum ne "d") {
						$$err_ref .= 
							"$txt{'sum_dir_err'} $file $txt{'notdir'}\n";
						$ret = 0;
					}
					next;
				}
				$_ = `$System::sum $file 2>&1`;
				if ($? != 0) {
					$$err_ref .= "$txt{'cant'} $System::sum $file\n";
					$ret = 0;
					next;
				}	
				if ( $sum != (split())[0] ) {
					$$err_ref .= 
						"$txt{'sum_err'} $file " . (split())[0] .
						" $txt{'should_be'} $sum\n";
					$ret = 0;
				}
			} elsif ($attr eq "mode") {
				$mode = shift( @tmp );
				@tmp = stat($file);
				if ( ! @tmp) {
					$$err_ref .= "$txt{'cant_stat'} $file\n";
					$ret = 0;
					next;
				}
				$tmp = $tmp[2] & oct("07777");
				$tmp = sprintf("0%lo", $tmp);
				if ( $mode != $tmp ) {
					$$err_ref .=
						"$txt{'mode_err'} $file $tmp $txt{'should_be'} " .
						"$mode\n";
					$ret = 0;
				}
			}
		}
	}

	return $ret;
}


1;
