# /unix/nui/installer/tools/lib/CfgData.pm
#
# Used for Domino 11 fixpacks
# Used for Domino 12 fixpacks
#
# Used for Domino  9 hotfixes
# Used for Domino 10 hotfixes
# Used for Domino 11 hotfixes
# Used for Domino 12 hotfixes
#
## Copyright (c) 1997, Lotus Development Corporation.
## All Rights Reserved.
 
require 5.000;
 
package CfgData;

CdPath::Require("CfgData.nls");	import CfgData_nls;
CdPath::Require("PerlUtil.pl");	import PerlUtil;


# external:
#	new
#	InitFromFile
#	InitFromScalar
#	GetErrorMessage
# 	GetData
# obsolete (???): 
#   GetTopDataRef
#	GetDataStandardHashRef
#   GenCfgFromHashRef
# internal:
#   ParseTheWholeDarnThingOhYah
#   ParseHash 
#   ParseRValue 
#   GetToken 
#   GetLineAndCharNum 
#   GenGenericSyntaxError 



# tokens
#
$ERROR			= 0;
$EOD			= 1;
$LPAREN			= 2;
$RPAREN			= 3;
$LCURLEY		= 4;
$RCURLEY		= 5;
$COLON			= 6;
$ASSIGN			= 7;
$STRING			= 8;
$QUOTEDSTRING	= 9;
$COMMA			= 10;


sub new {
	local($class) = shift(@_);

	my $self = {};
	bless $self;

	%$self = (
		'errormsg'				=> "",
		'data'					=> "",	# will eventually be a hash ref
		'file_pathname'			=> "",
		'rawlines'				=> [],
		'rawchars'				=> [],
		'line_start_indices'	=> [],
		'cur_char_index'		=> 0,
		'cur_line_number'		=> 0,
		'cur_char_number'		=> 0,
		'tok_data'				=> "",
		'cur_tok'				=> 0,
	);

	return $self;
}


sub InitFromFile {
	local($self, $file_pathname) = @_;

    local( *FILE );
 
	$self->{'file_pathname'} = $file_pathname;

	$self->{'rawlines'} = [];
 
    if ( ! open( FILE, "<$file_pathname" ) ) {
        $self->{'errormsg'} =
			"$txt{'cantopen_1'}" .
			"$file_pathname" .
			"$txt{'cantopen_2'}" .
			"$!\n";
        return 0;
    }
 
    while (<FILE>) {
        chomp;
        push( @{$self->{'rawlines'}}, $_ );
    }
    close( FILE );
 
	if ( ! scalar(@{$self->{'rawlines'}}) ) {
        $self->{'errormsg'} =
			$txt{'isempty_1'} .
			$file_pathname .
			$txt{'isempty_2'} .
			"\n";
        return 0;
    }

	return $self->ParseTheWholeDarnThingOhYah();
}


sub InitFromScalar {
	local($self, $data) = @_;

	foreach (split('\n', $data)) {
		chomp;
		push( @{$self->{'rawlines'}}, $_ );
	}

	return $self->ParseTheWholeDarnThingOhYah();
}


sub GetErrorMessage {
	local($self) = @_;

	return $self->{'errormsg'};
}


sub GetData {
	local($self) = @_;

	return PerlUtil::CopyDataWOKeyLists($self->{data});
}


sub GetTopDataRef {
	local($self) = @_;

	return $self->{'data'};
}


sub GetDataStandardHashRef {
	local($self) = @_;

	local($tmp);

	$tmp = &CopyData($self->{'data'});

	delete($tmp->{'_KeyList_'});

	return $tmp;
}


sub GetDataStandardHashRefWOKeyLists {
    local($self) = @_;
 
    local($tmp);
 
    $tmp = &CopyDataWOKeyLists($self->{'data'});
 
    return $tmp;
}


sub GenCfgFromHashRef {
	local($self, $r_datahash, $indent) = @_;

	defined($indent) || ($indent = 2);

	local($_);
	local(@keylist)			= ();
	local($outcfg, $key)	= ("","");


	if (ref($r_datahash->{'_KeyList_'}) eq "ARRAY") {
		@keylist = @{$r_datahash->{'_KeyList_'}};
	} else {
		@keylist = sort(keys(%{$r_datahash}));
	}

	foreach $key (@keylist) {
		
		if (defined($r_datahash->{$key}) && (!ref($r_datahash->{$key}))) {
		          if ($key =~ /cfp_lp_/ ) {
			      $outcfg .= "$key = $r_datahash->{$key}\n";
			      next;
			  }       #701FP! fix
	
            # it's just gotta be a simple scalar (not a ref)
            # and we're gonna output it as a quoted string unless it's a number
            #

			if ($r_datahash->{$key} =~ /^\d+$/) {
				$outcfg .= "$key = $r_datahash->{$key}\n";
				next;
			}

            local(@buf) = split(//, $r_datahash->{$key});
			local($out)	= "";
			$outcfg .= "$key = \"";

			foreach (@buf) {
				if (/\\/) {
					$outcfg .= "\\\\";
				} elsif (/\n/) {
					$outcfg .= "\\n";
				} elsif (/"/) {
					$outcfg .= "\\\"";
				} else {
					$outcfg .= $_;
				}
			}

			$outcfg .= "\"\n";
				
		} elsif (
			defined($r_datahash->{$key}) && 
			(ref($r_datahash->{$key}) eq "ARRAY")
		) {

			# a list
			# presuming all elements are simple scalars (not refs)
			#
			local($already) = 0;
			local(@c);

			$outcfg .= "$key = (";
			foreach (@{$r_datahash->{$key}}) {
				$already && ($outcfg .= ", ");

				$outcfg .= "\"";

				@c = split(//, $_);
	            foreach (@c) {
	                if (/\\/) {
	                    $outcfg .= "\\\\";
	                } elsif (/\n/) {
	                    $outcfg .= "\\n";
	                } elsif (/"/) {
	                    $outcfg .= "\\\"";
	                } else {
	                    $outcfg .= $_;
	                }
	            }

				$outcfg .= "\"";

				$already = 1;
			}
			$outcfg .= ")\n";

		} elsif (
			defined($r_datahash->{$key}) && 
			(ref($r_datahash->{$key}) eq "HASH")
		) {
			# a hash
			# 
			if ($key =~ /^\w*$/) {
				$outcfg .= "$key {\n";
			} else {
				$outcfg .= "\"${key}\" {\n";
			}
			local($hashcfg) = 
				$self->GenCfgFromHashRef($r_datahash->{$key}, $indent);
			foreach (split(/\n/, $hashcfg)) {
				$outcfg .= " " x $indent . $_ . "\n";
			}
			$outcfg .= "}\n";

		} elsif ($key =~ /:/) {

			# a "double hash"
			#
			local($bighash,$littlehash) = split(/:/, $key);
			$outcfg .= "$key {\n";
			local($hashcfg) =
				$self->GenCfgFromHashRef(
					$r_datahash->{$bighash}->{$littlehash});
			foreach (split(/\n/, $hashcfg)) {
				$outcfg .= " " x $indent . $_ . "\n";
			}
			$outcfg .= "}\n";
		}
	}
	
	return $outcfg;
}


sub ParseTheWholeDarnThingOhYah {
	local($self) = @_;

	local($i)		= 0;
	local($char)	= "";
	local(@line)	= ();

	$self->{'rawchars'}				= [];
	$self->{'line_start_indices'}	= [];

	# create a list ('rawchars') of characters (element == 1 char), 
	#   with newlines
	# and create list ('line_start_indices') of raw char indices which 
	#   come right after newlines (includes 0 automatically)
	#
	for $i (0..$#{$self->{'rawlines'}}) {
		push( @{$self->{'line_start_indices'}}, $#{$self->{'rawchars'}}+1 );
		@line = split(//, ${$self->{'rawlines'}}[$i]);
		push( @{$self->{'rawchars'}}, @line, "\n" );
	}

	$self->GetToken()  || return 0;
	$self->ParseHash( \$self->{'data'} ) || return 0;
	if ($self->{'cur_tok'} != $EOD) {
		$self->GenGenericSyntaxError();
		return 0;
	}

	return 1;
}


sub ParseHash {
	local($self, $rr_data) = @_;

	local($id) = "";
	local($r_thishash) = {};
	
	$r_thishash->{'_KeyList_'} = [];

	while (
		($self->{'cur_tok'} == $STRING) || 
		($self->{'cur_tok'} == $QUOTEDSTRING)
	) {
		$id = $self->{'tok_data'};

		$self->GetToken() || return 0;

		if ($self->{'cur_tok'} == $ASSIGN) {

			# id = value, or id = (list)

			$self->GetToken() || return 0;
			$self->ParseRValue( \$r_thishash->{$id} ) || return 0;
			if (! grep(/^$id$/, @{$r_thishash->{'_KeyList_'}})) {
				push(@{$r_thishash->{'_KeyList_'}}, $id);
			}

		} elsif ($self->{'cur_tok'} == $LCURLEY) {

			# a hash
			
			$self->GetToken() || return 0;
			$self->ParseHash( \$r_thishash->{$id} ) || return 0;
			if (! grep(/$id/, @{$r_thishash->{'_KeyList_'}})) {
				push(@{$r_thishash->{'_KeyList_'}}, $id);
			}

			if ($self->{'cur_tok'} != $RCURLEY) {
				$self->GenGenericSyntaxError();
				return 0;
			}
			$self->GetToken() || return 0;

		} elsif ($self->{'cur_tok'} == $COLON) {

			# a "double hash"
			#
			# bighash: subhash1 { ... }	# (this is a "double hash" def)
			# bighash: subhash2 { ... }	# (this is why)

			local($subhash_id, $r_subhash) = ("","");

			# the $id we already have must be either undefined 
			# or an existing hash in the current scope
			#
			if (
				defined($r_thishash->{$id}) && 
				(ref($r_thishash->{$id}) ne "HASH")
			) {
				$self->GenGenericSyntaxError();
				$self->{'errormsg'} .=
					$txt{'nothash_1'} .
					$id .
					$txt{'nothash_2'} .
					"\n";
				return 0;
			}

			# get the subhash identifier
			#
			$self->GetToken() || return 0;
			if ( 
				($self->{'cur_tok'} == $STRING) || 
				($self->{'cur_tok'} == $QUOTEDSTRING)
			) {

				$subhash_id = $self->{'tok_data'};

			} else {
				$self->GenGenericSyntaxError();
				return 0;
			}

			# eat the expected '{'
			#
			$self->GetToken() || return 0;
            if ($self->{'cur_tok'} != $LCURLEY) {
				$self->GenGenericSyntaxError();
				return 0;
			}
			
			# do the subhash itself
			#
			$self->GetToken() || return 0;
			$self->ParseHash(\$r_subhash) || return 0;
	
			$r_thishash->{$id}->{$subhash_id} = $r_subhash;
#			local($keylistid) = "${id}:${subhash_id}";
#			if (! grep(/$keylistid/, @{$r_thishash->{'_KeyList_'}})) {
#				push(@{$r_thishash->{'_KeyList_'}}, $keylistid);
#			}
			if ( ! grep(/$id/, @{$r_thishash->{'_KeyList_'}})) {
				push(@{$r_thishash->{'_KeyList_'}}, $id);
			}
			if ( ! grep(/$subhash_id/, @{$r_thishash->{$id}->{'_KeyList_'}})) {
				push(@{$r_thishash->{$id}->{'_KeyList_'}}, $subhash_id);
			}

			# eat the expected '}'
			#
			if ($self->{'cur_tok'} != $RCURLEY) {
				$self->GenGenericSyntaxError();
				return 0;
			}
			
			$self->GetToken() || return 0;

		} else {
			# unexpected token
			$self->GenGenericSyntaxError();
			return 0;
		}
	}

	$$rr_data = $r_thishash;
	return 1;
}


sub ParseRValue {
	local($self, $rr_data) = @_;

	local($r_tok)	= \$self->{'cur_tok'};
	local(@buf) 	= ();


	if ( ($$r_tok == $STRING) || ($$r_tok == $QUOTEDSTRING)) {

		$$rr_data = $self->{'tok_data'};

	} elsif ($$r_tok == $LPAREN) {
		# do a list
		#
		while (1) {
			$self->GetToken() || return 0;

			if (($$r_tok == $STRING) || ($$r_tok == $QUOTEDSTRING)) {
				push(@buf, $self->{'tok_data'});
			} else {
				$self->GenGenericSyntaxError();
				return 0;
			}

			$self->GetToken() || return 0;
			($$r_tok == $COMMA) && next;

			if ($$r_tok == $RPAREN) {
				$$rr_data = \@buf;
				last;
			} else {
				$self->GenGenericSyntaxError();
				return 0;
			}
		}
	
	} else {
		
		# unexpected token
		$self->GenGenericSyntaxError();
		return 0;
	}

	$self->GetToken() || return 0;
	return 1;
}


sub GetToken {
	local($self) = @_;

	local($i)	= 0;
	local($buf)	= "";

	while (($i=$self->{'cur_char_index'}++) <= $#{$self->{'rawchars'}}) {

		# slurp whitespace & newlines
		#
		(${$self->{'rawchars'}}[$i] =~ /\s/) && next;

		# slurp comments (#) to endofline
		#
		if (${$self->{'rawchars'}}[$i] eq '#') {
			while (
				(${$self->{'rawchars'}}[$i] ne "\n") &&
				($i <= $#{$self->{'rawchars'}})
			) {
				++$i;
			}
			$self->{'cur_char_index'} = $i+1;
			next;
		}

		# save current line & char numbers corresponding to cur_char_index
		#
		$self->GetLineAndCharNum( 
			$i,
			\$self->{'cur_line_number'},
			\$self->{'cur_char_number'}
		);

		# single char tokens
		#
		(${$self->{'rawchars'}}[$i] eq '(')
			&& return ($self->{'cur_tok'} = $LPAREN);
		(${$self->{'rawchars'}}[$i] eq ')')
			&& return ($self->{'cur_tok'} = $RPAREN);
		(${$self->{'rawchars'}}[$i] eq '{') 
			&& return ($self->{'cur_tok'} = $LCURLEY);
		(${$self->{'rawchars'}}[$i] eq '}') 
			&& return ($self->{'cur_tok'} = $RCURLEY);
		(${$self->{'rawchars'}}[$i] eq ':') 
			&& return ($self->{'cur_tok'} = $COLON);
		(${$self->{'rawchars'}}[$i] eq '=') 
			&& return ($self->{'cur_tok'} = $ASSIGN);
		(${$self->{'rawchars'}}[$i] eq ',') 
			&& return ($self->{'cur_tok'} = $COMMA);

		# string token ([a-zA-Z0-9_]+)
		#
		if (${$self->{'rawchars'}}[$i] =~ /[\w-]/) {
			$buf = "";
			while (${$self->{'rawchars'}}[$i] =~ /[\w-]/) {
				$buf .= ${$self->{'rawchars'}}[$i];
				++$i;
			}
			$self->{'cur_char_index'} = $i;
			$self->{'tok_data'} = $buf;
			$self->{'cur_tok'} = $STRING;
			return $STRING;
		}

		# quoted string token
		#
		if (${$self->{'rawchars'}}[$i] eq '"') {
			++$i;
			$buf = "";
			while (${$self->{'rawchars'}}[$i] ne '"') {

				# ensure we don't go beyond endoffile looking for match
				#
				if ( $i > $#{$self->{'rawchars'}} ) {
					$self->{'errormsg'} = 
						$txt{'unbaldquote_1'} .
						$self->{'cur_line_number'} .
						$txt{'unbaldquote_2'} .
						$self->{'cur_char_number'} .
						$txt{'unbaldquote_3'} .
						"\n";
					return ($self->{'cur_tok'} = $ERROR);
				}

				if (${$self->{'rawchars'}}[$i] eq '\\') {

					# deal with escaped chars (\" & \n)

					if (${$self->{'rawchars'}}[$i+1] eq '\\') {
						$buf .= '\\';
						$i += 2;
					} elsif (${$self->{'rawchars'}}[$i+1] eq 'n') {
						$buf .= "\n";
						$i += 2;
					} elsif (${$self->{'rawchars'}}[$i+1] eq '"') {
						$buf .= '"';
						$i += 2;
					} else {
						++$i;
					}

				} else {

					# add "normal" chars to the buffer

					$buf .= ${$self->{'rawchars'}}[$i];
					++$i;
				}
			}
			$self->{'cur_char_index'} = ++$i;

			# now see if this quoted string is appended to by another with '.'
			#
			while (${$self->{'rawchars'}}[$i] =~ /\s/) {
				++$i
			}
			if (${$self->{'rawchars'}}[$i] eq '.') {
				++$i;
				while (${$self->{'rawchars'}}[$i] =~ /\s/) {
					++$i
				}
				$self->{'cur_char_index'} = $i;
				if ($self->GetToken() == $QUOTEDSTRING) {
					$buf .= $self->{'tok_data'};
				} else {
					if (! $self->{'errormsg'}) {
						$self->{'errormsg'} =
							$txt{'quoted_str_1'} .
							$self->{'cur_line_number'} .
							$txt{'quoted_str_2'} .
							$self->{'cur_char_number'} .
							$txt{'quoted_str_3'} .
							"\n";
					}
					return ($self->{'cur_tok'} = $ERROR);
				}
			}

			$self->{'tok_data'} = $buf;
			$self->{'cur_tok'} = $QUOTEDSTRING;
			return $QUOTEDSTRING;
		}

		# here only if token not identified
		#
		$self->{'errormsg'} =
			$txt{'parse_err1_1'} .
			$self->{'cur_line_number'} .
			$txt{'parse_err1_2'} .
			$self->{'cur_char_number'} .
			$txt{'parse_err1_3'} .
			"\n";
		return ($self->{'cur_tok'} = $ERROR);
	}

	return ($self->{'cur_tok'} = $EOD);
}


sub GetLineAndCharNum {
	local($self, $charindex, $r_linenum, $r_charnum) = @_;

	# from the specified char index, determine corresponding
	# line & char numbers in "file"

	for $i (0..$#{$self->{'line_start_indices'}}) {

		if ( $charindex < ${$self->{'line_start_indices'}}[$i] ) {
			# the specified char is after a line start on some line other
			# than the last
			$$r_linenum = $i;
			$$r_charnum = 
				($charindex - ${$self->{'line_start_indices'}}[$i-1]) + 1;
			last;
		} elsif ( $charindex == ${$self->{'line_start_indices'}}[$i] ) {
			# the specified char is a line start
			$$r_linenum = $i+1;
			$$r_charnum = 1;
			last;
		} elsif ($i == $#{$self->{'line_start_indices'}}) {
			# the specified char is somewhere on the last line
			$$r_linenum = $i+1;
			$$r_charnum = 
				($charindex - ${$self->{'line_start_indices'}}[$i]) + 1;
			last;
		}
	}

	return 1;
}


sub GenGenericSyntaxError {
	local($self) = @_;

	$self->{'errormsg'} =
		$txt{'genericsyntax_1'} .
		$self->{'cur_line_number'} .
		$txt{'genericsyntax_2'} .
		$self->{'cur_char_number'} .
		$txt{'genericsyntax_3'} .
		"\n>" .
		"${$self->{'rawlines'}}[$self->{'cur_line_number'}-1]" .
		"<\n";

	return 1;
}

