# /unix/nui/installer/tools/lib/CDFFile.pm
#
# Used for Domino 11 fixpacks
# Used for Domino 12 fixpacks
#
# Used for Domino  9 hotfixes
# Used for Domino 10 hotfixes
# Used for Domino 11 hotfixes
# Used for Domino 12 hotfixes
#
## Copyright (c) 1998, Lotus Development Corporation.
## All Rights Reserved.
 
 
require 5.000;

 
CdPath::Require("IniFile.pm");
#	import IniFile;
#	import IniSection;
#	import IniLine;


######################################################################
#
package CDFFile;
@ISA = (IniFile);

CdPath::Require("CDFFile.nls");	import CDFFile_nls;
CdPath::Require("PerlUtil.pl"); 	import PerlUtil;


sub new {
    local($class) = @_;
 
    local($self) = IniFile->new();
 
    bless $self;
}

sub GetFileGroupDestination {
	local($self, $fgroup) = @_;

	local($comp, $compsec, $compfgroup, $compfgroups);

	local($comps) = $self->GetAllComponentsList();
	
	foreach $comp (@{$comps}) {
	        $compsec = $self->GetSection($comp);
		# comp not defined...
		$compsec || die("$txt{1.1}$comp$txt{1.2}$cdf_file$txt{1.3}");
		$compfgroup = $compsec->GetValue("filegroup0");
		if ( $compfgroup eq $fgroup){
		    return $compsec->GetValue('TARGET');
		}
	}	
}

sub GetSetupTypeList {
	local($self) = @_;

	local($sec) = $self->GetSection("SetupType");

	defined($sec) || return undef;

	return $sec->GetEnumeratedKeysValueList("setuptype");
}


sub GetSetupTypeComponentList {
    local($self, $setupType) = @_;
 
    local($sec) = $self->GetSection("SetupTypeItem-" . $setupType);
 
    defined($sec) || return undef;

	return $sec->GetEnumeratedKeysValueList("item");
}


sub GetAllComponentsList {
	local($self) = @_;

	# in:		(self)
	# out:		-
	# returns:	list of all component names defined as sections in ini file

	local($sec) = $self->GetSection("Components");

	defined($sec) || return undef;

	return $sec->GetEnumeratedKeysValueList("Component");

}


sub GetAllFilegroupsList {
	local($self) = @_;

	# in: 		(self)
	# out:		-
	# returns:	list of all filegroup names referenced in all comp sections

	local($comp, $compsec, $compfgroup, $compfgroups);
	local(@fgroups) = ();
	local(%fgroups) = {};

	local($comps) = $self->GetAllComponentsList();

	foreach $comp (@{$comps}) {
		$compsec = $self->GetSection($comp);
		# comp not defined...
		$compsec || die("$txt{1.1}$comp$txt{1.2}$cdf_file$txt{1.3}");
		$compfgroups = $compsec->GetEnumeratedKeysValueList("filegroup");
		foreach $compfgroup (@{$compfgroups}) {
			$fgroups{$compfgroup} && next;
			push(@fgroups, $compfgroup);
			$fgroups{$compfgroup} = 1;
		}
	}

	return \@fgroups;
}


sub GetMemberList {
	local($self, $comp) = @_;

	local($sec) = $self->GetSection($comp);
	defined($sec) || return undef;

	return $sec->GetEnumeratedKeysValueList("member");
}


sub GetFilegroupList {
	local($self, $comp) = @_;

	local($sec) = $self->GetSection($comp);
	defined($sec) || return undef;

	return $sec->GetEnumeratedKeysValueList("filegroup");
}


sub GetExpandedComponentList {
	local($self, $inList) = @_;

	local($_);

	local(
		@toCheck,
		%checked,
		$comp,
		@outList,
		$memberComp
	);

	@toCheck = @{$inList};
	%checked = {};
	@outlist = ();

	while ($comp = shift(@toCheck)) {

		$memberList = $self->GetMemberList($comp);

		$memberList || next;

		if ( ! $checked{$comp}) {
			push(@outList, $comp);
			$checked{$comp} = 1;
		}


		if (scalar(@{$memberList})) {
			foreach $memberComp (@{$memberList}) {
				if ( ! $checked{$memberComp}) {
					push(@toCheck, $memberComp);
				}
			}
		}
	}

	local(@sortedOut) = sort(@outList);
	return \@sortedOut;
}


sub GetCustomOnlyComponentList {
	local($self) = @_;

	local($setupType, $setupTypes);
	local($comp, $comps);
	local(%allNonCustomOnlyComps);
	local(@customOnly);

	$setupTypes = $self->GetSetupTypeList();

	foreach $setupType (@{$setupTypes}) {
		($setupType eq "Custom") && next;

		$comps = $self->GetExpandedComponentList(
            $self->GetSetupTypeComponentList($setupType));

		foreach $comp (@{$comps}) {
			$allNonCustomOnlyComps{$comp} = 1;
		}
	}

	$comps = $self->GetExpandedComponentList(
		$self->GetSetupTypeComponentList("Custom"));

	foreach $comp (@{$comps}) {
		if (! $allNonCustomOnlyComps{$comp}) {
			push(@customOnly, $comp);
		}
	}

	return(\@customOnly);
}



# package CDFFile
######################################################################


1;
