/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rcp.diff.internal.ioutils;

import com.ibm.rcp.diff.internal.ioutils.ByteArrayFile;
import com.ibm.rcp.diff.internal.ioutils.RandomAccessInputStream;
import java.io.IOException;

public class ByteArrayFileInputStream
extends RandomAccessInputStream {
    ByteArrayFile file;

    public ByteArrayFileInputStream() {
        this.file = new ByteArrayFile();
    }

    public ByteArrayFileInputStream(int n) {
        this.file = new ByteArrayFile(n);
    }

    public ByteArrayFileInputStream(ByteArrayFile byteArrayFile) {
        this.file = byteArrayFile;
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        this.file.read(byArray, 0, 1);
        return byArray[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.file.read(byArray, n, n2);
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.file.read(byArray, 0, byArray.length);
    }

    @Override
    public long skip(long l) throws IOException {
        return this.file.skipBytes((int)l);
    }

    @Override
    public void seek(long l) throws IOException {
        this.skip(Integer.MAX_VALUE);
        this.file.seek((int)l);
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.file.getFilePointer();
    }

    @Override
    public long length() throws IOException {
        return this.file.length();
    }

    public ByteArrayFile getByteArrayFile() {
        return this.file;
    }
}

