/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rcp.diff.internal;

import com.ibm.rcp.diff.internal.DiffArgs;
import com.ibm.rcp.diff.internal.DiffFactory;
import com.ibm.rcp.diff.internal.DiffMessage;
import com.ibm.rcp.diff.internal.JBDiff;
import com.ibm.rcp.diff.internal.TreeFileDiff;
import com.ibm.rcp.diff.internal.Util;
import com.ibm.rcp.diff.internal.ZipFilePatch;
import com.ibm.rcp.diff.internal.ioutils.ByteArrayFile;
import com.ibm.rcp.diff.internal.ioutils.ByteArrayFileInputStream;
import com.ibm.rcp.diff.internal.ioutils.ByteArrayFileOutputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipFileDiff {
    public static final String VERSION_NUM = "0.1.1";
    public static final String VERSION = ZipFilePatch.VERSION;
    public static final int VERSION_ID = 257;
    public static final String LIST_NAME = ZipFilePatch.LIST_NAME;
    public static final String VERSION_NAME = "version";
    public static final String CORE_DIFF_NAME = "core.diff";
    public static final String POST_DIFF_NAME = "post.diff";
    protected DiffMessage msg;
    protected DiffFactory factory;

    protected ZipFileDiff(DiffMessage diffMessage, DiffFactory diffFactory) {
        this.msg = diffMessage;
        this.factory = diffFactory;
    }

    public void zipDiff(File file, File file2, File file3) throws IOException {
        this.msg.msgln(2, 0, "Creating UncompressedZipFileDiff \"" + file3.getPath() + "\" from \"" + file.getPath() + "\" to \"" + file2.getPath() + "\"...");
        this.msg.addIndent(1);
        ZipFile zipFile = new ZipFile(file);
        ZipFile zipFile2 = new ZipFile(file2);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file3));
        this.zipDiff(zipFile, zipFile2, bufferedOutputStream);
        bufferedOutputStream.close();
        zipFile2.close();
        zipFile.close();
        this.msg.addIndent(-1);
        this.msg.msgln(2, 0, "UncompressedZipFileDiff success!! diff file size=" + file3.length());
    }

    public void zipDiff(ZipFile zipFile, ZipFile zipFile2, OutputStream outputStream) throws IOException {
        ZipOutputStream zipOutputStream = System.getProperty("java.version").startsWith("1.6") ? new ZipOutputStream(outputStream) : new ZipOutputStream(outputStream, Charset.forName("US-ASCII"));
        this.zipDiff(zipFile, zipFile2, zipOutputStream);
        zipOutputStream.finish();
    }

    boolean equals(byte[] byArray, byte[] byArray2) throws IOException {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public void zipDiff(ZipFile zipFile, ZipFile zipFile2, ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry zipEntry;
        HashSet<String> hashSet = new HashSet<String>();
        JBDiff jBDiff = this.factory.getJBDiff(this.msg);
        ZipFilePatch.CtrlData ctrlData = new ZipFilePatch.CtrlData();
        ctrlData.flags |= 1;
        byte[] byArray = Util.getFileBytes(new File(zipFile.getName()));
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        ctrlData.oldFileSize = byArray.length;
        ctrlData.oldFileCrc = (int)cRC32.getValue();
        this.msg.msgln(3, 0, "orig file zip file name=" + zipFile.getName() + ", orig file length=" + ctrlData.oldFileSize + ", crc=" + ctrlData.oldFileCrc);
        ByteArrayFile byteArrayFile = new ByteArrayFile();
        ByteArrayFileOutputStream byteArrayFileOutputStream = new ByteArrayFileOutputStream(byteArrayFile);
        ZipOutputStream zipOutputStream2 = System.getProperty("java.version").startsWith("1.6") ? new ZipOutputStream(byteArrayFileOutputStream) : new ZipOutputStream((OutputStream)byteArrayFileOutputStream, Charset.forName("US-ASCII"));
        Util.uncompressZip(zipFile, zipOutputStream2, null);
        zipOutputStream2.finish();
        zipOutputStream2.close();
        byte[] byArray2 = byteArrayFile.getByteBuffer();
        ctrlData.inflatedOldFileSize = byArray2.length;
        cRC32 = new CRC32();
        cRC32.update(byArray2);
        ctrlData.inflatedOldFileCrc = (int)cRC32.getValue();
        this.msg.msgln(3, 0, "inflated orig file length=" + ctrlData.inflatedOldFileSize + ", crc=" + ctrlData.inflatedOldFileCrc);
        ByteArrayFile byteArrayFile2 = new ByteArrayFile();
        byteArrayFileOutputStream = new ByteArrayFileOutputStream(byteArrayFile2);
        zipOutputStream2 = System.getProperty("java.version").startsWith("1.6") ? new ZipOutputStream(byteArrayFileOutputStream) : new ZipOutputStream((OutputStream)byteArrayFileOutputStream, Charset.forName("US-ASCII"));
        Util.uncompressZip(zipFile2, zipOutputStream2, hashSet);
        zipOutputStream2.finish();
        zipOutputStream2.close();
        byte[] byArray3 = byteArrayFile2.getByteBuffer();
        ctrlData.inflatedNewFileSize = byArray3.length;
        cRC32 = new CRC32();
        cRC32.update(byArray3);
        ctrlData.inflatedNewFileCrc = (int)cRC32.getValue();
        this.msg.msgln(3, 0, "inflated target file length=" + ctrlData.inflatedNewFileSize + ", crc=" + ctrlData.inflatedNewFileCrc);
        if (!this.equals(byArray2, byArray3)) {
            zipEntry = new ZipEntry(CORE_DIFF_NAME);
            zipOutputStream.putNextEntry(zipEntry);
            this.msg.addIndent(1);
            jBDiff.bsdiff(byArray2, byArray3, zipOutputStream);
            this.msg.addIndent(-1);
            zipOutputStream.closeEntry();
            byArray2 = null;
            byteArrayFile = null;
            byArray3 = null;
            System.gc();
            ctrlData.corePatchSize = (int)zipEntry.getSize();
            ctrlData.corePatchCrc = (int)zipEntry.getCrc();
            this.msg.msgln(3, 0, "inflated file diff length=" + ctrlData.corePatchSize + ", crc=" + ctrlData.corePatchCrc);
        }
        byteArrayFile2.seek(0);
        ZipInputStream zipInputStream = System.getProperty("java.version").startsWith("1.6") ? new ZipInputStream(new ByteArrayFileInputStream(byteArrayFile2)) : new ZipInputStream((InputStream)new ByteArrayFileInputStream(byteArrayFile2), Charset.forName("US-ASCII"));
        ByteArrayFile byteArrayFile3 = new ByteArrayFile();
        zipOutputStream2 = System.getProperty("java.version").startsWith("1.6") ? new ZipOutputStream(new ByteArrayFileOutputStream(byteArrayFile3)) : new ZipOutputStream((OutputStream)new ByteArrayFileOutputStream(byteArrayFile3), Charset.forName("US-ASCII"));
        Util.compressZip(zipInputStream, zipOutputStream2, hashSet);
        zipOutputStream2.finish();
        zipOutputStream2.close();
        byteArrayFile2 = null;
        byte[] byArray4 = byteArrayFile3.getByteBuffer();
        cRC32 = new CRC32();
        cRC32.update(byArray4);
        ctrlData.deflatedPostFileSize = byArray4.length;
        ctrlData.deflatedPostFileCrc = (int)cRC32.getValue();
        this.msg.msgln(3, 0, "re-deflated target file diff length=" + ctrlData.deflatedPostFileSize + ", crc=" + ctrlData.deflatedPostFileCrc);
        File file = new File(zipFile2.getName());
        byte[] byArray5 = Util.getFileBytes(file);
        cRC32 = new CRC32();
        cRC32.update(byArray5);
        ctrlData.newFileSize = byArray5.length;
        ctrlData.newFileCrc = (int)cRC32.getValue();
        this.msg.msgln(3, 0, "target file diff length=" + ctrlData.newFileSize + ", crc=" + ctrlData.newFileCrc);
        if (!this.equals(byArray4, byArray5)) {
            zipEntry = new ZipEntry(POST_DIFF_NAME);
            zipOutputStream.putNextEntry(zipEntry);
            this.msg.addIndent(1);
            jBDiff.bsdiff(byArray4, byArray5, zipOutputStream);
            this.msg.addIndent(-1);
            zipOutputStream.closeEntry();
            ctrlData.postPatchSize = (int)zipEntry.getSize();
            ctrlData.postPatchCrc = (int)zipEntry.getCrc();
            this.msg.msgln(3, 0, "post file diff length=" + ctrlData.postPatchSize + ", crc=" + ctrlData.postPatchCrc);
        }
        zipEntry = new ZipEntry(LIST_NAME);
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        ctrlData.saveCtrlData(dataOutputStream, hashSet.size());
        for (String string : hashSet) {
            dataOutputStream.writeUTF(string);
            this.msg.msgln(4, 1, "recorded uncompressed target file: " + string);
        }
        zipOutputStream.closeEntry();
        zipEntry = new ZipEntry(VERSION_NAME);
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.write(VERSION.getBytes("US-ASCII"));
        zipOutputStream.closeEntry();
        this.msg.msgln(4, 1, "recorded version, " + VERSION);
    }

    public static void main(String[] stringArray) {
        DiffArgs diffArgs = Util.getArgs(stringArray, TreeFileDiff.class.getName(), null);
        if (diffArgs == null) {
            return;
        }
        ZipFileDiff zipFileDiff = DiffFactory.getDiffFactory().getZipFileDiff(new DiffMessage(diffArgs.out, diffArgs.err, diffArgs.verboseLevel, 0));
        try {
            zipFileDiff.zipDiff(diffArgs.src.get(0), diffArgs.dst, diffArgs.diffArchive);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(diffArgs.err);
        }
    }
}

