/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rcp.diff.internal;

import com.ibm.rcp.diff.internal.DiffArgs;
import com.ibm.rcp.diff.internal.ioutils.ByteArrayFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Util {
    private static final int F_errSet = 0x1000000;

    public static final int memcmp(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = byArray.length - n;
        if (n3 > byArray2.length - n2) {
            n3 = byArray2.length - n2;
        }
        for (int i = 0; i < n3; ++i) {
            if (byArray[i + n] == byArray2[i + n2]) continue;
            return byArray[i + n] < byArray2[i + n2] ? -1 : 1;
        }
        return 0;
    }

    public static final boolean readFromStream(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (int i = 0; i < n2; i += n3) {
            n3 = inputStream.read(byArray, n + i, n2 - i);
            if (n3 >= 0) continue;
            System.err.println("readFromStream(): returning prematurely. Read " + i + " bytes");
            return false;
        }
        return true;
    }

    static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[16384];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    static byte[] getStreamBytes(InputStream inputStream) throws IOException {
        ByteArrayFile byteArrayFile = Util.getStreamByteArrayFile(inputStream);
        return byteArrayFile.getByteBuffer();
    }

    static ByteArrayFile getStreamByteArrayFile(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[16384];
        ByteArrayFile byteArrayFile = new ByteArrayFile();
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayFile.write(byArray, 0, n);
        }
        return byteArrayFile;
    }

    static void compressZip(ZipInputStream zipInputStream, ZipOutputStream zipOutputStream, HashSet<String> hashSet) throws IOException {
        ZipEntry zipEntry;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            ZipEntry zipEntry2 = new ZipEntry(zipEntry);
            if (hashSet.contains(zipEntry2.getName())) {
                zipEntry2.setMethod(0);
            } else {
                zipEntry2.setMethod(8);
            }
            zipEntry2.setCompressedSize(-1L);
            zipOutputStream.putNextEntry(zipEntry2);
            Util.copyStream(zipInputStream, zipOutputStream);
            zipOutputStream.closeEntry();
        }
    }

    static void compressZip(ZipFile zipFile, ZipOutputStream zipOutputStream, HashSet<String> hashSet) throws IOException {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            ZipEntry zipEntry2 = new ZipEntry(zipEntry);
            if (hashSet.contains(zipEntry2.getName())) {
                zipEntry2.setMethod(0);
            } else {
                zipEntry2.setMethod(8);
            }
            zipEntry2.setCompressedSize(-1L);
            zipOutputStream.putNextEntry(zipEntry2);
            Util.copyStream(zipFile.getInputStream(zipEntry), zipOutputStream);
            zipOutputStream.closeEntry();
        }
    }

    static void uncompressZip(ZipInputStream zipInputStream, ZipOutputStream zipOutputStream, HashSet<String> hashSet) throws IOException {
        ZipEntry zipEntry;
        zipOutputStream.setLevel(0);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            ZipEntry zipEntry2 = new ZipEntry(zipEntry);
            zipEntry2.setMethod(0);
            zipEntry2.setCompressedSize(-1L);
            if (zipEntry2.getSize() == -1L) {
                zipEntry2.setSize(0L);
            }
            zipOutputStream.putNextEntry(zipEntry2);
            Util.copyStream(zipInputStream, zipOutputStream);
            if (hashSet == null || zipEntry.getSize() <= 0L || zipEntry.getMethod() == 8) continue;
            hashSet.add(zipEntry.getName());
        }
    }

    static void uncompressZip(ZipFile zipFile, ZipOutputStream zipOutputStream, HashSet<String> hashSet) throws IOException {
        zipOutputStream.setLevel(0);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            ZipEntry zipEntry2 = new ZipEntry(zipEntry);
            zipEntry2.setMethod(0);
            zipEntry2.setCompressedSize(-1L);
            zipOutputStream.putNextEntry(zipEntry2);
            Util.copyStream(zipFile.getInputStream(zipEntry), zipOutputStream);
            if (hashSet != null && zipEntry.getSize() > 0L && zipEntry.getMethod() != 8) {
                hashSet.add(zipEntry.getName());
            }
            zipOutputStream.closeEntry();
        }
    }

    static byte[] getFileBytes(File file) throws IOException {
        int n;
        byte[] byArray = new byte[(int)file.length()];
        byte[] byArray2 = new byte[16384];
        FileInputStream fileInputStream = new FileInputStream(file);
        for (int i = 0; i < byArray.length; i += n) {
            int n2 = byArray2.length;
            if (n2 > byArray.length - i) {
                n2 = byArray.length - i;
            }
            n = fileInputStream.read(byArray2, 0, n2);
            System.arraycopy(byArray2, 0, byArray, i, n);
        }
        fileInputStream.close();
        return byArray;
    }

    private static void parseArg(String string, DiffArgs diffArgs) {
        if (string.startsWith("root=")) {
            diffArgs.root = new File(string.substring(5));
        } else if (string.startsWith("src=")) {
            File file = new File(string.substring(4));
            if (!file.isAbsolute()) {
                file = new File(diffArgs.root, string.substring(4));
            }
            diffArgs.src.add(file);
        } else if (string.startsWith("dst=")) {
            File file = new File(string.substring(4));
            if (!file.isAbsolute()) {
                file = new File(diffArgs.root, string.substring(4));
            }
            diffArgs.dst = file;
        } else if (string.startsWith("diff=")) {
            File file = new File(string.substring(5));
            if (!file.isAbsolute()) {
                file = new File(diffArgs.root, string.substring(5));
            }
            diffArgs.diffArchive = file;
        } else if (string.startsWith("-")) {
            if (string.equalsIgnoreCase("-continue_on_error")) {
                diffArgs.flags |= 1;
            } else if (string.startsWith("-show=")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string.substring(6), ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (string2.equalsIgnoreCase("progress")) {
                        diffArgs.flags |= 0x40;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("modified")) {
                        diffArgs.flags |= 0x6000;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("copied")) {
                        diffArgs.flags |= 0x1000;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("patched")) {
                        diffArgs.flags |= 0x2000;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("embedded")) {
                        diffArgs.flags |= 0x4000;
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("allfiles")) continue;
                    diffArgs.flags |= 0xF000;
                }
            } else if (string.startsWith("-v")) {
                int n = 0;
                for (int i = 1; i < string.length(); ++i) {
                    if (string.charAt(i) != 'v') {
                        System.err.println("Unknown option " + string);
                        n = 0;
                        break;
                    }
                    ++n;
                }
                diffArgs.verboseLevel += n;
            } else if (string.equalsIgnoreCase("-noversion")) {
                diffArgs.flags |= 0x10000;
            } else {
                try {
                    int n;
                    diffArgs.verboseLevel = n = Integer.parseInt(string.substring(1));
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Unknown option " + string);
                }
            }
        } else if (string.startsWith("out=")) {
            String string3 = string.substring(4);
            try {
                diffArgs.out = new PrintStream(new FileOutputStream(string3));
                if ((diffArgs.flags & 0x1000000) != 0x1000000) {
                    diffArgs.err = diffArgs.out;
                }
            }
            catch (IOException iOException) {
                diffArgs.err.println("Unable to open out file: " + string3);
                iOException.printStackTrace(diffArgs.err);
                diffArgs.err.println();
            }
        } else if (string.startsWith("err=")) {
            String string4 = string.substring(4);
            try {
                diffArgs.err = new PrintStream(new FileOutputStream(string4));
                diffArgs.flags |= 0x1000000;
            }
            catch (IOException iOException) {
                diffArgs.err.println("Unable to open err file: " + string4);
                iOException.printStackTrace(diffArgs.err);
                diffArgs.err.println();
            }
        } else if (string.startsWith("crcignore=")) {
            diffArgs.crcIgnoreList.add(new File(string.substring(10).trim()));
        } else if (string.startsWith("patchignore=")) {
            diffArgs.patchFailList.add(new File(string.substring(12).trim()));
        } else if (string.startsWith("srcignore=")) {
            diffArgs.ignoreList.add(new File(string.substring(10).trim()));
        } else if (string.startsWith("srcembed=")) {
            diffArgs.embedList.add(new File(string.substring(9).trim()));
        } else if (string.startsWith("@")) {
            String string5 = string.substring(1);
            try {
                String string6;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string5));
                while ((string6 = bufferedReader.readLine()) != null) {
                    if ((string6 = string6.trim()).length() <= 0 || string6.startsWith("#")) continue;
                    Util.parseArg(string6, diffArgs);
                }
            }
            catch (IOException iOException) {
                diffArgs.err.println("Error reading from args file: " + string5);
                iOException.printStackTrace(diffArgs.err);
            }
        } else if (!string.startsWith("#")) {
            diffArgs.err.println("Unknown option: " + string);
        }
    }

    static DiffArgs getArgs(String[] stringArray, String string, DiffArgs diffArgs) {
        int n;
        if (diffArgs == null) {
            diffArgs = new DiffArgs();
        }
        for (n = 0; n < stringArray.length; ++n) {
            Util.parseArg(stringArray[n], diffArgs);
        }
        int n2 = n = diffArgs.flagSet(16) && (diffArgs.flags & 0xF000) != 0 ? 1 : 0;
        if (diffArgs.diffArchive == null || n == 0 && (diffArgs.src == null || diffArgs.dst == null)) {
            diffArgs.err.println(string + ":");
            diffArgs.err.println("\t\tsrc={oldDir}");
            diffArgs.err.println("\t\tdst={newDir}");
            diffArgs.err.println("\t\tdiff={diffArchive}");
            diffArgs.err.println("\t\t[-v{vvv}]");
            diffArgs.err.println("\t\t[out={msgFile}]      - write output messages to file.");
            diffArgs.err.println("\t\t[err={errFile}]      - write error messages to file.");
            if (diffArgs.flagSet(16)) {
                diffArgs.err.println("\t\t[crcignore={path}]   - path OK if CRC check fails for copied src.");
                diffArgs.err.println("\t\t[patchignore={path}] - path OK for if patch of src fails, copy src instead.");
                diffArgs.err.println("\t\t[-continue_on_error] - attempt to patch all files even if an error is encountered.");
                diffArgs.err.println("\t\t[-show={progress,modified,copied,patched,embedded,allfiles}]");
                diffArgs.err.println("\t\t                     - show patch info to stdout.");
            }
            if (diffArgs.flagSet(32)) {
                diffArgs.err.println("\t\t[crcignore={path}]   - path OK if CRC check fails for copied src.");
                diffArgs.err.println("\t\t[patchignore={path}] - path OK for if patch of src fails, copy src instead.");
                diffArgs.err.println("\t\t[srcignore={path}]   - src path to exclude on diff generation.");
                diffArgs.err.println("\t\t[srcembed={path}]    - src path to embed in diff generation as if a new file.");
            }
            diffArgs.err.println("\t\t[@argsfile]          - file name to read args from.");
            return null;
        }
        return diffArgs;
    }
}

