/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rcp.diff.internal;

import com.ibm.rcp.diff.internal.DiffArgs;
import com.ibm.rcp.diff.internal.DiffFactory;
import com.ibm.rcp.diff.internal.DiffMessage;
import com.ibm.rcp.diff.internal.JBPatch;
import com.ibm.rcp.diff.internal.TreeFileDiff;
import com.ibm.rcp.diff.internal.TreeFileEntry;
import com.ibm.rcp.diff.internal.Util;
import com.ibm.rcp.diff.internal.ZipFilePatch;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class TreeFilePatch {
    public static final String VERSION_NUM = "0.1.1";
    public static final int VERSION_ID = 257;
    private static final String CLASS_NAME = TreeFilePatch.class.getSimpleName();
    private static final String NAME_BASE = CLASS_NAME.substring(0, CLASS_NAME.length() - 5) + "Diff";
    public static final String VERSION = NAME_BASE + "_" + "0.1.1";
    public static final String LIST_NAME = NAME_BASE + ".dat";
    public static final String VERSION_NAME = NAME_BASE + ".version";
    protected static final String DIFF_EXT = "._" + NAME_BASE;
    protected static final String EXT_PATH = "lib" + File.separator + "ext" + File.separator;
    private ZipFilePatch zipPatcher;
    private JBPatch filePatcher;
    protected DiffMessage msg;
    private Hashtable<TreeFileEntry, File> fileMap = new Hashtable();
    protected DiffArgs diffArgs;

    protected TreeFilePatch(DiffMessage diffMessage, DiffFactory diffFactory) {
        this.msg = diffMessage;
        this.filePatcher = diffFactory.getJBPatch(diffMessage);
        this.zipPatcher = diffFactory.getZipFilePatch(diffMessage);
    }

    protected void srcCopy(File file, File file2, String string) throws IOException {
        File file3 = new File(file, string);
        File file4 = new File(file2, string);
        if (file3.exists()) {
            if (file3.isDirectory()) {
                File[] fileArray = file3.listFiles();
                file4.mkdirs();
                if (fileArray.length == 0) {
                    return;
                }
                for (int i = 0; i < fileArray.length; ++i) {
                    File file5 = new File(new File(string), fileArray[i].getName());
                    this.srcCopy(file, file2, file5.getPath());
                }
            } else {
                DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file4));
                FileInputStream fileInputStream = new FileInputStream(file3);
                Util.copyStream(fileInputStream, dataOutputStream);
                ((InputStream)fileInputStream).close();
                dataOutputStream.close();
            }
        }
    }

    static boolean filenameMatches(String string, String string2, DiffMessage diffMessage) {
        block7: {
            StringBuilder stringBuilder = new StringBuilder(string2.length() + 10);
            stringBuilder.append('^');
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (c == '?') {
                    stringBuilder.append(".");
                    continue;
                }
                if (c == '*') {
                    stringBuilder.append(".*");
                    continue;
                }
                if ("[]{}+()^$.|\\".indexOf(c) != -1) {
                    stringBuilder.append('\\');
                    stringBuilder.append(c);
                    continue;
                }
                stringBuilder.append(c);
            }
            stringBuilder.append('$');
            try {
                String string3 = stringBuilder.toString();
                Pattern pattern = Pattern.compile(string3);
                Matcher matcher = pattern.matcher(string);
                if (matcher.find()) {
                    return true;
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                if (diffMessage == null) break block7;
                diffMessage.msgln(3, 0, "filenameMatch exception: " + patternSyntaxException.getMessage());
            }
        }
        return false;
    }

    static boolean containsEntry(File file, HashSet<File> hashSet) {
        if (hashSet.contains(file)) {
            return true;
        }
        for (File file2 : hashSet) {
            if (!TreeFilePatch.filenameMatches(file.getPath(), file2.getPath(), null)) continue;
            return true;
        }
        return false;
    }

    static void getEntryFlags(TreeFileEntry treeFileEntry, DiffArgs diffArgs) {
        File file = new File(treeFileEntry.path);
        if (TreeFilePatch.containsEntry(file, diffArgs.crcIgnoreList)) {
            treeFileEntry.flags |= 0x20;
        }
        if (TreeFilePatch.containsEntry(file, diffArgs.patchFailList)) {
            treeFileEntry.flags |= 0x40;
        }
    }

    protected File findFile(File file, TreeFileEntry treeFileEntry, String string) {
        int n;
        if (string == null) {
            int n2 = treeFileEntry.path.lastIndexOf(47);
            n = treeFileEntry.path.lastIndexOf(92);
            if (n > n2) {
                n2 = n;
            }
            string = n2 == -1 ? treeFileEntry.path : treeFileEntry.path.substring(n2 + 1);
        }
        File[] fileArray = file.listFiles();
        for (n = 0; n < fileArray.length; ++n) {
            Object object;
            File file2 = fileArray[n];
            if (file2.isDirectory()) {
                object = this.findFile(file2, treeFileEntry, string);
                if (object == null) continue;
                return object;
            }
            object = treeFileEntry.srcFiles.iterator();
            byte[] byArray = null;
            CRC32 cRC32 = null;
            while (object.hasNext()) {
                TreeFileEntry.SrcFileEntry srcFileEntry = (TreeFileEntry.SrcFileEntry)object.next();
                if (file2.length() != (long)srcFileEntry.size) continue;
                try {
                    if (byArray == null) {
                        byArray = Util.getFileBytes(file2);
                    }
                    if (byArray.length != srcFileEntry.size) continue;
                    if (cRC32 == null) {
                        cRC32 = new CRC32();
                        cRC32.update(byArray);
                    }
                    if (srcFileEntry.crc != (int)cRC32.getValue()) continue;
                    this.fileMap.put(treeFileEntry, file2);
                    treeFileEntry.foundSrcFile = srcFileEntry;
                    return file2;
                }
                catch (IOException iOException) {
                }
            }
        }
        return null;
    }

    protected File findOldFile(File file, TreeFileEntry treeFileEntry) throws IOException {
        Object object;
        File file2 = this.fileMap.get(treeFileEntry);
        if (file2 != null) {
            return file2;
        }
        file2 = new File(file, treeFileEntry.path);
        if (file2.isFile()) {
            if (treeFileEntry.flagSet(2) && treeFileEntry.srcFiles.size() == 0) {
                treeFileEntry.addSrcFile(treeFileEntry.newSize, treeFileEntry.newCrc, 2, null);
            }
            object = treeFileEntry.srcFiles.iterator();
            byte[] byArray = null;
            CRC32 cRC32 = null;
            while (object.hasNext()) {
                TreeFileEntry.SrcFileEntry srcFileEntry = object.next();
                if (file2.length() == (long)srcFileEntry.size) {
                    try {
                        if (byArray == null) {
                            byArray = Util.getFileBytes(file2);
                        }
                        if (byArray.length == srcFileEntry.size) {
                            if (cRC32 == null) {
                                cRC32 = new CRC32();
                                cRC32.update(byArray);
                            }
                            if (srcFileEntry.crc == (int)cRC32.getValue()) {
                                this.fileMap.put(treeFileEntry, file2);
                                treeFileEntry.foundSrcFile = srcFileEntry;
                                return file2;
                            }
                            this.msg.msgln(4, 0, "DEBUG: file crc didn't match expected, \"" + treeFileEntry.path + "\", crc=" + (int)cRC32.getValue() + ", expected " + srcFileEntry.crc + ", continuing search...");
                            continue;
                        }
                        this.msg.msgln(0, 0, "WARNING: file read length didn't match file size, \"" + treeFileEntry.path + "\", fileSize=" + srcFileEntry.size + ", readSize=" + byArray.length + ", continuing search...");
                    }
                    catch (IOException iOException) {
                        this.msg.errln(0, iOException);
                    }
                    continue;
                }
                this.msg.msgln(4, 0, "DEBUG: file length didn't match expected, \"" + treeFileEntry.path + "\", fileSize=" + file2.length() + ", expectedSize=" + srcFileEntry.size + ", continuing search...");
            }
            this.msg.msgln(0, 0, "WARNING: couldn't find matching file \"" + treeFileEntry.path + "\", size=" + treeFileEntry.newSize + ", crc32=" + treeFileEntry.newCrc + ", continuing search...");
        } else {
            if (treeFileEntry.path.endsWith(".pdb")) {
                return null;
            }
            this.msg.msgln(0, 0, "WARNING: couldn't find file \"" + treeFileEntry.path + "\", continuing search...");
            file2 = null;
        }
        object = this.findFile(file, treeFileEntry, null);
        if (object == null) {
            if (treeFileEntry.flagSet(32)) {
                if (file2 != null) {
                    this.fileMap.put(treeFileEntry, file2);
                }
                treeFileEntry.flags |= 0x100;
                return file2;
            }
            if (file2 != null && treeFileEntry.flagSet(64)) {
                this.fileMap.put(treeFileEntry, file2);
                treeFileEntry.flags |= 0x100;
                return file2;
            }
            throw new IOException("Patching is unable to find matching file \"" + treeFileEntry.path + "\"");
        }
        this.msg.msgln(1, 0, "WARNING: found matching file with another name, " + ((File)object).getPath() + ", expected " + file2.getPath());
        this.fileMap.put(treeFileEntry, (File)object);
        return object;
    }

    protected void verifyOldFiles(File file, ArrayList<TreeFileEntry> arrayList) throws IOException {
        for (TreeFileEntry treeFileEntry : arrayList) {
            TreeFilePatch.getEntryFlags(treeFileEntry, this.diffArgs);
            if (treeFileEntry.flagSet(2) || treeFileEntry.flagSet(16)) continue;
            try {
                this.findOldFile(file, treeFileEntry);
            }
            catch (IOException iOException) {
                if (!this.diffArgs.flagSet(1)) {
                    throw iOException;
                }
                this.msg.errln(0, iOException);
                this.msg.errln(0, "Warning! Continuing after error");
            }
        }
    }

    protected void showProgress(int n, int n2) {
        if (this.diffArgs.flagSet(64)) {
            float f = (float)n2 * 100.0f / (float)n;
            String string = Float.toString(f);
            int n3 = string.indexOf(46);
            if (n3 == -1) {
                string = string + ".0";
            } else if (string.length() > n3 + 2) {
                string = string.substring(0, n3 + 2);
            }
            System.out.println("[" + string + "%]");
            System.out.flush();
        }
    }

    protected void showInfo(List<TreeFileEntry> list) {
        for (TreeFileEntry treeFileEntry : list) {
            boolean bl = false;
            if (this.diffArgs.flagSet(16384) && treeFileEntry.flagSet(2)) {
                bl = true;
            } else {
                Iterator<TreeFileEntry.SrcFileEntry> iterator = treeFileEntry.srcFiles.iterator();
                while (!bl && iterator.hasNext()) {
                    TreeFileEntry.SrcFileEntry srcFileEntry = iterator.next();
                    if (this.diffArgs.flagSet(4096) && (srcFileEntry.flags & 1) != 0) {
                        bl = true;
                        continue;
                    }
                    if (!this.diffArgs.flagSet(8192) || (srcFileEntry.flags & 0xC) == 0) continue;
                    bl = true;
                }
            }
            if (!bl) continue;
            System.out.println(treeFileEntry.path + " : " + treeFileEntry.newSize + " : " + treeFileEntry.newCrc + " : " + treeFileEntry.newTime);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int treePatch(File file, File file2, File file3) throws IOException {
        if (file2 != null && file != null) {
            this.msg.msgln(1, 0, "Patching tree diff from \"" + file.getPath() + "\" to \"" + file2.getPath() + "\" using diff file \"" + file3.getPath() + "\"...");
        }
        this.msg.addIndent(1);
        ZipFile zipFile = new ZipFile(file3);
        if (this.diffArgs.flagSet(65536)) {
            try {
                this.treePatch(file, file2, zipFile);
            }
            catch (IOException iOException) {
                this.msg.errln(0, iOException);
                this.msg.msgln(0, 0, "Tree diff file patch failed.");
                zipFile.close();
                return -1;
            }
            zipFile.close();
            this.msg.addIndent(-1);
        } else {
            InputStream inputStream = zipFile.getInputStream(zipFile.getEntry("dst"));
            int n = 1;
            while (inputStream != null) {
                byte[] byArray = new byte[150];
                inputStream.read(byArray);
                this.diffArgs.versions.add(new String(byArray, "US-ASCII"));
                inputStream = zipFile.getEntry("src" + n) != null ? zipFile.getInputStream(zipFile.getEntry("src" + n)) : null;
                ++n;
            }
            String string = this.diffArgs.getVersionInfo(file, this.msg);
            boolean bl = false;
            for (String string2 : this.diffArgs.versions) {
                if (!string2.startsWith("src") || !string2.substring(string2.indexOf(" ") + 1).trim().equals(string)) continue;
                bl = true;
            }
            if (bl) {
                try {
                    this.treePatch(file, file2, zipFile);
                }
                catch (IOException iOException) {
                    this.msg.errln(0, iOException);
                    this.msg.msgln(0, 0, "Tree diff file patch failed.");
                    zipFile.close();
                    return -1;
                }
                zipFile.close();
                this.msg.addIndent(-1);
            } else {
                zipFile.close();
                this.msg.addIndent(1);
                this.msg.msgln(0, 0, "You are attempting to patch:");
                this.msg.msgln(0, 1, string);
                this.msg.msgln(0, 0, "With a patch that is valid for:");
                Iterator<String> iterator = this.diffArgs.versions.iterator();
                while (true) {
                    String string2;
                    if (!iterator.hasNext()) {
                        this.msg.msgln(0, 0, "Tree diff file patch failed.");
                        return -1;
                    }
                    string2 = iterator.next();
                    if (!string2.startsWith("src")) continue;
                    this.msg.msgln(0, 1, string2.trim());
                }
            }
        }
        if (this.diffArgs.getErrorCount() == 0) {
            this.msg.msgln(2, 0, "Tree diff file patch successful!");
            return 0;
        }
        this.msg.msgln(0, 0, "Tree diff file patch completed with " + this.diffArgs.getErrorCount() + " errors!");
        return this.diffArgs.getErrorCount();
    }

    public void treePatch(File file, File file2, ZipFile zipFile) throws IOException {
        if (file != null && !file.isDirectory()) {
            throw new IOException("Invalid directory " + file.getName());
        }
        if (file2 != null && file2.exists() && !file2.isDirectory()) {
            throw new IOException("Invalid directory " + file2.getName());
        }
        if (file2 != null && file2.exists() && file2.listFiles().length > 0) {
            this.msg.msgln(0, 0, "Warning! Patch output to an existing directory with existing contents!");
        }
        this.srcCopy(file, file2, EXT_PATH);
        ArrayList<TreeFileEntry> arrayList = TreeFileEntry.getFileList(zipFile);
        this.showInfo(arrayList);
        if (file == null) {
            return;
        }
        this.verifyOldFiles(file, arrayList);
        Iterator<TreeFileEntry> iterator = arrayList.iterator();
        if (file2 == null) {
            return;
        }
        int n = 0;
        this.showProgress(arrayList.size(), n);
        while (iterator.hasNext()) {
            TreeFileEntry treeFileEntry = iterator.next();
            try {
                this.treePatch(file, file2, treeFileEntry, zipFile);
            }
            catch (IOException iOException) {
                this.diffArgs.addErrorCount();
                if (!this.diffArgs.flagSet(1)) {
                    throw iOException;
                }
                this.msg.errln(0, iOException);
                this.msg.errln(0, "Warning! Continuing after error");
            }
            this.showProgress(arrayList.size(), n++);
        }
    }

    protected void treePatch(File file, File file2, TreeFileEntry treeFileEntry, ZipFile zipFile) throws IOException {
        File file3;
        File file4;
        File file5 = null;
        if (!treeFileEntry.flagSet(2)) {
            file5 = this.findOldFile(file, treeFileEntry);
            if (treeFileEntry.path.endsWith(".pdb")) {
                String string = "INFO: Missing PDB file - " + treeFileEntry.path + ".  Some missing PDB files on Windows client kits are expected.";
                this.msg.msgln(2, 0, string);
                return;
            }
            if (treeFileEntry.flagSet(256)) {
                for (TreeFileEntry.SrcFileEntry srcFileEntry : treeFileEntry.srcFiles) {
                    treeFileEntry.flags |= srcFileEntry.flags;
                }
                boolean bl = false;
                if (treeFileEntry.flagSet(1) && treeFileEntry.flagSet(32)) {
                    bl = true;
                } else if (file5 != null && treeFileEntry.flagSet(4) && treeFileEntry.flagSet(64)) {
                    bl = true;
                } else if (file5 != null && treeFileEntry.flagSet(8) && treeFileEntry.flagSet(64)) {
                    bl = true;
                }
                String string = "Matching source file can not be located, \"" + treeFileEntry.path + "\". ";
                if (file5 == null || !bl) {
                    if (bl) {
                        String string2 = "Ignoring missing file due to ignore flag set.";
                        this.msg.msgln(0, 0, string + string2);
                        return;
                    }
                    throw new IOException(string);
                }
                Object object = "Copy on error available, attempting to copy original file.";
                this.msg.msgln(0, 0, string + (String)object);
                object = null;
                try {
                    object = (TreeFileEntry)treeFileEntry.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                ((TreeFileEntry)object).flags = 513;
                this.treePatch(file, file2, (TreeFileEntry)object, zipFile);
                return;
            }
        }
        if (!(file4 = (file3 = new File(file2, treeFileEntry.path)).getParentFile()).isDirectory()) {
            file4.mkdirs();
        }
        if (treeFileEntry.foundSrcFile != null) {
            treeFileEntry.flags |= treeFileEntry.foundSrcFile.flags;
        }
        CRC32 cRC32 = new CRC32();
        DataOutputStream dataOutputStream = new DataOutputStream(new CheckedOutputStream(new FileOutputStream(file3), cRC32));
        if (treeFileEntry.flagSet(2)) {
            this.msg.msgln(3, 0, "Extracting new file: " + treeFileEntry.path);
            File file6 = new File(treeFileEntry.path);
            String string = file6.getPath().replace('\\', '/');
            ZipEntry zipEntry = zipFile.getEntry(string);
            if (zipEntry == null) {
                throw new IOException("Unable to find new file in diff archive: " + treeFileEntry.path);
            }
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            Util.copyStream(inputStream, dataOutputStream);
            dataOutputStream.close();
            inputStream.close();
        } else {
            if (treeFileEntry.flagSet(128)) {
                if (treeFileEntry.path.contains(EXT_PATH)) {
                    dataOutputStream.close();
                    file3.delete();
                    this.msg.msgln(3, 0, "Deleting removed file: " + treeFileEntry.path);
                }
                return;
            }
            if (treeFileEntry.flagSet(1)) {
                this.msg.msgln(4, 0, "Copying unchanged file: " + treeFileEntry.path);
                FileInputStream fileInputStream = new FileInputStream(file5);
                Util.copyStream(fileInputStream, dataOutputStream);
                dataOutputStream.close();
                ((InputStream)fileInputStream).close();
                if (treeFileEntry.flagSet(512)) {
                    return;
                }
            } else if (treeFileEntry.flagSet(4)) {
                this.msg.msgln(2, 0, "Patching file: " + treeFileEntry.path);
                this.msg.addIndent(1);
                InputStream inputStream = null;
                try {
                    File file7 = new File(new File("" + treeFileEntry.foundSrcFile.idx), treeFileEntry.path + DIFF_EXT);
                    String string = file7.getPath().replace('\\', '/');
                    ZipEntry zipEntry = zipFile.getEntry(string);
                    if (zipEntry == null) {
                        throw new IOException("Unable to find diff patch file from diff archive: " + treeFileEntry.path + DIFF_EXT);
                    }
                    inputStream = zipFile.getInputStream(zipEntry);
                    this.filePatcher.bspatch(file5, (OutputStream)dataOutputStream, inputStream);
                    dataOutputStream.close();
                }
                catch (IOException iOException) {
                    dataOutputStream.close();
                    if (treeFileEntry.flagSet(64)) {
                        this.msg.msgln(0, 0, iOException.getMessage());
                        this.msg.msgln(0, 0, "Copy on patch error available, attempting to copy original file instead of patching");
                        treeFileEntry.flags |= 0x100;
                        this.treePatch(file, file2, treeFileEntry, zipFile);
                        return;
                    }
                    throw iOException;
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                this.msg.addIndent(-1);
            } else if (treeFileEntry.flagSet(8)) {
                this.msg.msgln(2, 0, "Zip patching file: " + treeFileEntry.path);
                this.msg.addIndent(1);
                InputStream inputStream = null;
                ZipFile zipFile2 = null;
                try {
                    if (treeFileEntry.flagSet(256)) {
                        throw new IOException("File modified from original and can not be patched: " + treeFileEntry.path);
                    }
                    File file8 = new File(new File("" + treeFileEntry.foundSrcFile.idx), treeFileEntry.path + DIFF_EXT);
                    String string = file8.getPath().replace('\\', '/');
                    ZipEntry zipEntry = zipFile.getEntry(string);
                    if (zipEntry == null) {
                        throw new IOException("Unable to find diff patch file from diff archive: " + treeFileEntry.path + DIFF_EXT);
                    }
                    inputStream = zipFile.getInputStream(zipEntry);
                    zipFile2 = new ZipFile(file5);
                    this.zipPatcher.zipPatch(zipFile2, (OutputStream)dataOutputStream, inputStream);
                    dataOutputStream.close();
                }
                catch (IOException iOException) {
                    dataOutputStream.close();
                    if (treeFileEntry.flagSet(64)) {
                        this.msg.msgln(0, 0, iOException.getMessage());
                        this.msg.msgln(0, 0, "Copy on patch error available, attempting to copy original file instead of patching");
                        treeFileEntry.flags |= 0x100;
                        this.treePatch(file, file2, treeFileEntry, zipFile);
                        return;
                    }
                    throw iOException;
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (zipFile2 != null) {
                        zipFile2.close();
                    }
                }
                this.msg.addIndent(-1);
            } else if (treeFileEntry.flagSet(16)) {
                this.msg.msgln(2, 0, "Creating empty directory: " + treeFileEntry.path);
                if (!file3.mkdirs()) {
                    throw new IOException("Unable to create directory " + file3.getPath());
                }
            } else {
                dataOutputStream.close();
                file3.delete();
                throw new IOException("Unknown diff file entry: " + treeFileEntry.path);
            }
        }
        if (treeFileEntry.newTime != 0L) {
            file3.setLastModified(treeFileEntry.newTime);
        }
        if (dataOutputStream.size() != treeFileEntry.newSize) {
            throw new IOException("New file size does not verify, " + dataOutputStream.size() + ", expected " + treeFileEntry.newSize + ", " + treeFileEntry.path);
        }
        if ((int)cRC32.getValue() != treeFileEntry.newCrc) {
            throw new IOException("New file crc does not verify, " + (int)cRC32.getValue() + ", expected " + treeFileEntry.newCrc);
        }
    }

    public static int treePatch(String[] stringArray) {
        DiffArgs diffArgs = new DiffArgs();
        diffArgs.flags |= 0x10;
        diffArgs = Util.getArgs(stringArray, TreeFileDiff.class.getName(), diffArgs);
        if (diffArgs == null) {
            return -1;
        }
        TreeFilePatch treeFilePatch = DiffFactory.getDiffFactory().getTreeFilePatch(new DiffMessage(diffArgs.out, diffArgs.err, diffArgs.verboseLevel, 0));
        treeFilePatch.diffArgs = diffArgs;
        try {
            File file = null;
            if (diffArgs.src.size() > 0) {
                file = diffArgs.src.get(0);
            }
            return treeFilePatch.treePatch(file, diffArgs.dst, diffArgs.diffArchive);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(diffArgs.err);
            return -1;
        }
    }

    public static void main(String[] stringArray) {
        System.exit(TreeFilePatch.treePatch(stringArray));
    }
}

