/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rcp.diff.internal;

import com.ibm.rcp.diff.internal.TreeFilePatch;
import com.ibm.rcp.diff.internal.ioutils.ByteArrayFileOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class TreeFileEntry
implements Cloneable {
    static final int F_NOCHANGE = 1;
    static final int F_NEWFILE = 2;
    static final int F_JBDIFF = 4;
    static final int F_ZIPDIFF = 8;
    static final int F_DIRECTORY = 16;
    static final int F_COPY_ON_CRC_ERR = 32;
    static final int F_COPY_ON_PATCH_ERR = 64;
    static final int F_DELETED = 128;
    static final int F_FILE_ERROR = 256;
    static final int F_FILE_ERROR_COPY = 512;
    int flags;
    String path;
    long newTime;
    int newSize;
    int newCrc;
    ArrayList<SrcFileEntry> srcFiles = new ArrayList();
    int errorCount;
    SrcFileEntry foundSrcFile;

    TreeFileEntry() {
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected SrcFileEntry newSrcFileEntry() {
        return new SrcFileEntry();
    }

    protected SrcFileEntry addSrcFile(int n, int n2, int n3, File file) {
        SrcFileEntry srcFileEntry = this.newSrcFileEntry();
        srcFileEntry.size = n;
        srcFileEntry.crc = n2;
        srcFileEntry.flags = n3;
        srcFileEntry.idx = this.srcFiles.size();
        srcFileEntry.file = file;
        this.srcFiles.add(srcFileEntry);
        return srcFileEntry;
    }

    protected static void writeFileList(ArrayList<TreeFileEntry> arrayList, OutputStream outputStream) throws IOException {
        Iterator<TreeFileEntry> iterator = arrayList.iterator();
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(257);
        dataOutputStream.writeInt(0);
        while (iterator.hasNext()) {
            TreeFileEntry treeFileEntry = iterator.next();
            dataOutputStream.writeByte(treeFileEntry.flags);
            dataOutputStream.writeUTF(treeFileEntry.path);
            if (treeFileEntry.flagSet(16)) continue;
            if (!treeFileEntry.flagSet(2)) {
                dataOutputStream.writeByte(treeFileEntry.srcFiles.size());
                for (SrcFileEntry srcFileEntry : treeFileEntry.srcFiles) {
                    dataOutputStream.writeByte(srcFileEntry.idx);
                    dataOutputStream.writeByte(srcFileEntry.flags);
                    dataOutputStream.writeInt(srcFileEntry.size);
                    dataOutputStream.writeInt(srcFileEntry.crc);
                }
            }
            dataOutputStream.writeLong(treeFileEntry.newTime);
            dataOutputStream.writeInt(treeFileEntry.newSize);
            dataOutputStream.writeInt(treeFileEntry.newCrc);
        }
    }

    protected static ArrayList<TreeFileEntry> getFileList(ZipFile zipFile) throws IOException {
        ZipEntry zipEntry = zipFile.getEntry(TreeFilePatch.LIST_NAME);
        if (zipEntry == null) {
            throw new IOException("Unable to find file list in diff zip file.");
        }
        DataInputStream dataInputStream = new DataInputStream(zipFile.getInputStream(zipEntry));
        int n = dataInputStream.readInt();
        if (n > 257) {
            throw new IOException("Invalid patch file version 0x" + Integer.toHexString(n) + ", expected 0x" + Integer.toHexString(257));
        }
        dataInputStream.readInt();
        ArrayList<TreeFileEntry> arrayList = new ArrayList<TreeFileEntry>();
        try {
            while (true) {
                TreeFileEntry treeFileEntry = new TreeFileEntry();
                treeFileEntry.flags = dataInputStream.readByte();
                treeFileEntry.path = dataInputStream.readUTF();
                if (treeFileEntry.flagSet(16)) continue;
                if (!treeFileEntry.flagSet(2)) {
                    for (int i = dataInputStream.readByte(); i > 0; --i) {
                        SrcFileEntry srcFileEntry = new SrcFileEntry();
                        srcFileEntry.idx = dataInputStream.readByte();
                        srcFileEntry.flags = dataInputStream.readByte();
                        srcFileEntry.size = dataInputStream.readInt();
                        srcFileEntry.crc = dataInputStream.readInt();
                        treeFileEntry.srcFiles.add(srcFileEntry);
                    }
                }
                treeFileEntry.newTime = dataInputStream.readLong();
                treeFileEntry.newSize = dataInputStream.readInt();
                treeFileEntry.newCrc = dataInputStream.readInt();
                arrayList.add(treeFileEntry);
            }
        }
        catch (EOFException eOFException) {
            return arrayList;
        }
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof TreeFileEntry)) {
            return false;
        }
        return this.path.equals(((TreeFileEntry)object).path);
    }

    protected boolean flagSet(int n) {
        return (this.flags & n) == n;
    }

    public static class SrcFileEntry {
        public int idx;
        public int flags;
        public int size;
        public int crc;
        File file;
        ByteArrayFileOutputStream data;
    }
}

