/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rcp.diff.internal;

import com.ibm.rcp.diff.internal.DiffArgs;
import com.ibm.rcp.diff.internal.DiffFactory;
import com.ibm.rcp.diff.internal.DiffMessage;
import com.ibm.rcp.diff.internal.JBDiff;
import com.ibm.rcp.diff.internal.TreeFileEntry;
import com.ibm.rcp.diff.internal.TreeFilePatch;
import com.ibm.rcp.diff.internal.Util;
import com.ibm.rcp.diff.internal.ZipFileDiff;
import com.ibm.rcp.diff.internal.ioutils.ByteArrayFileInputStream;
import com.ibm.rcp.diff.internal.ioutils.ByteArrayFileOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class TreeFileDiff {
    public static final String VERSION_NUM = "0.1.1";
    public static final String VERSION = TreeFilePatch.VERSION;
    public static final int VERSION_ID = 257;
    public static final String LIST_NAME = TreeFilePatch.LIST_NAME;
    public static final String VERSION_NAME = TreeFilePatch.VERSION_NAME;
    protected static final String DIFF_EXT = TreeFilePatch.DIFF_EXT;
    protected static final String EXT_PATH = TreeFilePatch.EXT_PATH;
    protected DiffFactory factory;
    private ZipFileDiff zipDiffer;
    private JBDiff fileDiffer;
    private DiffMessage msg;
    private DiffArgs diffArgs;

    protected TreeFileDiff(DiffMessage diffMessage, DiffFactory diffFactory) {
        this.msg = diffMessage;
        this.factory = diffFactory;
        this.fileDiffer = diffFactory.getJBDiff(diffMessage);
        this.zipDiffer = diffFactory.getZipFileDiff(diffMessage);
    }

    boolean equals(byte[] byArray, byte[] byArray2) throws IOException {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    int getCrc(byte[] byArray) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        return (int)cRC32.getValue();
    }

    /*
     * WARNING - void declaration
     */
    protected void treeDiff(List<File> list, File file, String string, ZipOutputStream zipOutputStream, ArrayList<TreeFileEntry> arrayList) throws IOException {
        ZipEntry zipEntry;
        Object object3;
        Object object4;
        Object object5;
        File file2 = new File(file, string);
        ArrayList<File[]> arrayList2 = new ArrayList<File[]>();
        if (file2.toString().contains(EXT_PATH)) {
            object5 = list.iterator();
            while (object5.hasNext()) {
                object4 = (File)object5.next();
                object3 = new File((File)object4, string);
                if (!((File)object3).exists()) continue;
                arrayList2.add((File[])object3);
            }
        }
        if (TreeFilePatch.containsEntry((File)(object5 = new File(string)), this.diffArgs.ignoreList)) {
            this.msg.msgln(2, 0, "ignoring dst file: " + string);
            return;
        }
        if (file2.isDirectory()) {
            Object object6;
            void file3;
            object4 = new ArrayList();
            object3 = file2.listFiles();
            int n = ((File[])object3).length;
            boolean bl = false;
            while (file3 < n) {
                File file4 = object3[file3];
                ((ArrayList)object4).add(file4);
                ++file3;
            }
            object3 = new ArrayList();
            for (File file5 : arrayList2) {
                for (File file6 : file5.listFiles()) {
                    ((ArrayList)object3).add(file6);
                }
            }
            if (this.msg.msgLevel >= 3) {
                this.msg.msgln(3, 0, "Sub folder tree diff: " + string);
                this.msg.addIndent(1);
            }
            if (((ArrayList)object4).size() == 0) {
                object6 = new TreeFileEntry();
                ((TreeFileEntry)object6).path = string;
                ((TreeFileEntry)object6).flags = 16;
                this.msg.msgln(3, 0, "Recorded empty folder: " + string);
            }
            object6 = ((ArrayList)object3).iterator();
            while (object6.hasNext()) {
                File file6 = (File)object6.next();
                if (TreeFilePatch.containsEntry(file6, this.diffArgs.ignoreList) || ((ArrayList)object4).contains(new File(file, string + File.separator + file6.getName()))) continue;
                TreeFileEntry treeFileEntry = new TreeFileEntry();
                treeFileEntry.path = string;
                TreeFilePatch.getEntryFlags(treeFileEntry, this.diffArgs);
                byte[] byArray = Util.getFileBytes(file6);
                treeFileEntry.addSrcFile((int)file6.length(), this.getCrc(byArray), 128, file6);
                this.msg.msgln(3, 0, "Recorded deleted file: " + file6.getPath());
                treeFileEntry.path = string + File.separator + file6.getName();
                arrayList.add(treeFileEntry);
            }
            for (int i = 0; i < ((ArrayList)object4).size(); ++i) {
                File object2 = new File(new File(string), ((File)((ArrayList)object4).get(i)).getName());
                this.treeDiff(list, file, object2.getPath(), zipOutputStream, arrayList);
            }
            if (this.msg.msgLevel >= 3) {
                this.msg.addIndent(-1);
            }
            return;
        }
        object4 = new TreeFileEntry();
        ((TreeFileEntry)object4).path = string;
        ((TreeFileEntry)object4).newSize = (int)file2.length();
        ((TreeFileEntry)object4).newTime = file2.lastModified();
        object3 = Util.getFileBytes(file2);
        ((TreeFileEntry)object4).newCrc = this.getCrc((byte[])object3);
        TreeFilePatch.getEntryFlags((TreeFileEntry)object4, this.diffArgs);
        if (TreeFilePatch.containsEntry((File)object5, this.diffArgs.embedList)) {
            this.msg.msgln(3, 0, "embeding dst file: " + string);
            ((TreeFileEntry)object4).flags |= 2;
        }
        Iterator<File> iterator = list.iterator();
        while (!((TreeFileEntry)object4).flagSet(2) && iterator.hasNext()) {
            File file7 = new File(iterator.next(), string);
            if (file7.isFile()) continue;
            ((TreeFileEntry)object4).flags |= 2;
        }
        if (!((TreeFileEntry)object4).flagSet(2)) {
            void var13_32;
            ByteArrayFileOutputStream byteArrayFileOutputStream = new ByteArrayFileOutputStream();
            if (System.getProperty("java.version").startsWith("1.6")) {
                ZipOutputStream zipOutputStream2 = new ZipOutputStream(byteArrayFileOutputStream);
            } else {
                ZipOutputStream zipOutputStream3 = new ZipOutputStream((OutputStream)byteArrayFileOutputStream, Charset.forName("US-ASCII"));
            }
            zipEntry = new ZipEntry(((TreeFileEntry)object4).path);
            var13_32.putNextEntry(zipEntry);
            Util.copyStream(new ByteArrayInputStream((byte[])object3), (OutputStream)var13_32);
            var13_32.closeEntry();
            int n = (int)byteArrayFileOutputStream.length();
            var13_32.close();
            Object var12_22 = null;
            Object var13_33 = null;
            iterator = list.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                TreeFileEntry.SrcFileEntry srcFileEntry = this.diffSrcFile(string, iterator.next(), file2, (byte[])object3, (TreeFileEntry)object4);
                if (srcFileEntry != null && (srcFileEntry.flags & 0xC) != 0) {
                    n2 = (int)((long)n2 + srcFileEntry.data.length());
                }
                if (n2 < n) continue;
                break;
            }
            if (n2 >= n) {
                ((TreeFileEntry)object4).flags |= 2;
                ((TreeFileEntry)object4).srcFiles.clear();
                this.msg.msgln(3, 0, "Diff sizes exceed the target file. Storing target file instead...");
            } else {
                for (TreeFileEntry.SrcFileEntry srcFileEntry : ((TreeFileEntry)object4).srcFiles) {
                    if ((srcFileEntry.flags & 0xC) == 0) continue;
                    ByteArrayFileInputStream byteArrayFileInputStream = new ByteArrayFileInputStream(srcFileEntry.data.getByteArrayFile());
                    srcFileEntry.data = null;
                    byteArrayFileInputStream.getByteArrayFile().seek(0);
                    File file8 = new File(new File("" + srcFileEntry.idx), string + DIFF_EXT);
                    String string2 = file8.getPath().replace('\\', '/');
                    ZipEntry zipEntry2 = new ZipEntry(string2);
                    zipOutputStream.putNextEntry(zipEntry2);
                    Util.copyStream(byteArrayFileInputStream, zipOutputStream);
                    zipOutputStream.closeEntry();
                }
            }
        }
        if (((TreeFileEntry)object4).flagSet(2)) {
            if (this.msg.msgLevel >= 3) {
                this.msg.msgln(3, 0, "Storing file: " + string);
                this.msg.addIndent(1);
            }
            ((TreeFileEntry)object4).flags |= 2;
            File file9 = new File(string);
            String string3 = file9.getPath().replace('\\', '/');
            zipEntry = new ZipEntry(string3);
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write((byte[])object3);
            zipOutputStream.closeEntry();
            if (this.msg.msgLevel >= 3) {
                this.msg.addIndent(-1);
            }
        }
        arrayList.add((TreeFileEntry)object4);
    }

    protected TreeFileEntry.SrcFileEntry diffSrcFile(String string, File file, File file2, byte[] byArray, TreeFileEntry treeFileEntry) throws IOException {
        Object object;
        TreeFileEntry.SrcFileEntry srcFileEntry2;
        File file3 = new File(file, string);
        int n = (int)file3.length();
        byte[] byArray2 = Util.getFileBytes(file3);
        int n2 = this.getCrc(byArray2);
        if (this.equals(byArray2, byArray)) {
            if (n2 != treeFileEntry.newCrc) {
                throw new IOException("Equal files CRC32 are different: " + file2.getPath());
            }
            this.msg.msgln(4, 0, "Recording unchanged file: " + string);
            return treeFileEntry.addSrcFile(n, n2, 1, file3);
        }
        if (n2 == treeFileEntry.newCrc) {
            this.msg.err(0, "WARNING: CRC32 collision on different files: " + file2.getPath());
        }
        for (TreeFileEntry.SrcFileEntry srcFileEntry2 : treeFileEntry.srcFiles) {
            if (srcFileEntry2.size != byArray2.length || srcFileEntry2.crc != n2 || !this.equals(byArray2, (byte[])(object = Util.getFileBytes(srcFileEntry2.file)))) continue;
            return null;
        }
        srcFileEntry2 = treeFileEntry.addSrcFile(n, n2, 0, file3);
        srcFileEntry2.data = new ByteArrayFileOutputStream();
        if (string.endsWith(".jar") || string.endsWith(".zip") && !string.endsWith("ffjcext.zip")) {
            if (this.msg.msgLevel >= 2) {
                this.msg.msgln(2, 0, "Zip diff: " + string);
                this.msg.addIndent(1);
            }
            srcFileEntry2.flags |= 8;
            byArray = null;
            byArray2 = null;
            System.gc();
            object = new ZipFile(file3);
            ZipFile zipFile = new ZipFile(file2);
            this.zipDiffer.zipDiff((ZipFile)object, zipFile, srcFileEntry2.data);
            zipFile.close();
            ((ZipFile)object).close();
            if (this.msg.msgLevel >= 2) {
                this.msg.addIndent(-1);
            }
        } else {
            if (this.msg.msgLevel >= 2) {
                this.msg.msgln(2, 0, "File diff: " + string);
                this.msg.addIndent(1);
            }
            srcFileEntry2.flags |= 4;
            this.fileDiffer.bsdiff(byArray2, byArray, srcFileEntry2.data);
            if (this.msg.msgLevel >= 2) {
                this.msg.addIndent(-1);
            }
        }
        return srcFileEntry2;
    }

    public void treeDiff(List<File> list, File file, File file2) throws IOException {
        Iterator<File> iterator = list.iterator();
        while (iterator.hasNext()) {
            this.msg.msgln(1, 0, "Creating tree patch from \"" + iterator.next().getPath() + "\" to \"" + file.getPath() + "\"...");
        }
        int n = 1;
        if (!this.diffArgs.flagSet(65536)) {
            String string;
            for (File file3 : list) {
                string = this.diffArgs.getVersionInfo(file3, this.msg);
                this.diffArgs.versions.add("src" + n + " " + string);
                ++n;
            }
            string = this.diffArgs.getVersionInfo(file, this.msg);
            this.diffArgs.versions.add("dst " + string);
        }
        this.msg.addIndent(1);
        ZipOutputStream zipOutputStream = System.getProperty("java.version").startsWith("1.6") ? new ZipOutputStream(new FileOutputStream(file2)) : new ZipOutputStream((OutputStream)new FileOutputStream(file2), Charset.forName("US-ASCII"));
        this.treeDiff(list, file, zipOutputStream);
        zipOutputStream.finish();
        zipOutputStream.close();
        this.msg.addIndent(-1);
        this.msg.msgln(2, 0, "Tree patch diff file creation successful, " + file2.getPath());
    }

    public void treeDiff(List<File> list, File file, ZipOutputStream zipOutputStream) throws IOException {
        for (File fileArray2 : list) {
            if (fileArray2.isDirectory()) continue;
            throw new IOException("Invalid directory " + fileArray2.getName());
        }
        if (!file.isDirectory()) {
            throw new IOException("Invalid directory " + file.getName());
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            throw new IOException("Directory is empty: " + file.getName());
        }
        ArrayList<TreeFileEntry> arrayList = new ArrayList<TreeFileEntry>();
        if (!this.diffArgs.flagSet(65536)) {
            for (String string : this.diffArgs.versions) {
                ZipEntry zipEntry = new ZipEntry(string.substring(0, string.indexOf(" ")));
                zipOutputStream.putNextEntry(zipEntry);
                zipOutputStream.write(string.getBytes("US-ASCII"));
                zipOutputStream.closeEntry();
            }
        }
        for (int zipEntry = 0; zipEntry < fileArray.length; ++zipEntry) {
            this.treeDiff(list, file, fileArray[zipEntry].getName(), zipOutputStream, arrayList);
        }
        ZipEntry zipEntry = new ZipEntry(LIST_NAME);
        zipOutputStream.putNextEntry(zipEntry);
        TreeFileEntry.writeFileList(arrayList, zipOutputStream);
        zipOutputStream.closeEntry();
        zipEntry = new ZipEntry(VERSION_NAME);
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.write(VERSION.getBytes("US-ASCII"));
        zipOutputStream.closeEntry();
    }

    public static int treeDiff(String[] stringArray) {
        DiffArgs diffArgs = new DiffArgs();
        diffArgs.flags |= 0x20;
        diffArgs = Util.getArgs(stringArray, TreeFileDiff.class.getName(), diffArgs);
        if (diffArgs == null) {
            return -1;
        }
        TreeFileDiff treeFileDiff = DiffFactory.getDiffFactory().getTreeFileDiff(new DiffMessage(diffArgs.out, diffArgs.err, diffArgs.verboseLevel, 0));
        treeFileDiff.diffArgs = diffArgs;
        try {
            treeFileDiff.treeDiff(diffArgs.src, diffArgs.dst, diffArgs.diffArchive);
            return 0;
        }
        catch (IOException iOException) {
            iOException.printStackTrace(diffArgs.err);
            return -1;
        }
    }

    public static void main(String[] stringArray) {
        System.exit(TreeFileDiff.treeDiff(stringArray));
    }
}

