/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rcp.diff.internal;

import com.ibm.rcp.diff.internal.DiffArgs;
import com.ibm.rcp.diff.internal.DiffFactory;
import com.ibm.rcp.diff.internal.DiffMessage;
import com.ibm.rcp.diff.internal.TreeFileDiff;
import com.ibm.rcp.diff.internal.Util;
import com.ibm.rcp.diff.internal.ioutils.ByteArrayFileInputStream;
import com.ibm.rcp.diff.internal.ioutils.ByteArrayFileOutputStream;
import com.ibm.rcp.diff.internal.ioutils.RandomAccessFileOutputStream;
import com.ibm.rcp.diff.internal.ioutils.RandomAccessOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class JBDiff {
    public static final String VERSION = "rcp-bsdiff-0.1.1";
    DiffMessage msg;

    protected JBDiff(DiffMessage diffMessage) {
        this.msg = diffMessage;
    }

    private static final int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    private final void split(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        int n4;
        int n5;
        if (n2 < 16) {
            int n6;
            for (int i = n; i < n + n2; i += n6) {
                n6 = 1;
                int n7 = nArray2[nArray[i] + n3];
                int n8 = 1;
                while (i + n8 < n + n2) {
                    if (nArray2[nArray[i + n8] + n3] < n7) {
                        n7 = nArray2[nArray[i + n8] + n3];
                        n6 = 0;
                    }
                    if (nArray2[nArray[i + n8] + n3] == n7) {
                        int n9 = nArray[i + n6];
                        nArray[i + n6] = nArray[i + n8];
                        nArray[i + n8] = n9;
                        ++n6;
                    }
                    ++n8;
                }
                for (n8 = 0; n8 < n6; ++n8) {
                    nArray2[nArray[i + n8]] = i + n6 - 1;
                }
                if (n6 != 1) continue;
                nArray[i] = -1;
            }
            return;
        }
        int n10 = nArray2[nArray[n + n2 / 2] + n3];
        int n11 = 0;
        int n12 = 0;
        for (n5 = n; n5 < n + n2; ++n5) {
            if (nArray2[nArray[n5] + n3] < n10) {
                ++n11;
            }
            if (nArray2[nArray[n5] + n3] != n10) continue;
            ++n12;
        }
        n12 += (n11 += n);
        n5 = n;
        int n13 = 0;
        int n14 = 0;
        while (n5 < n11) {
            if (nArray2[nArray[n5] + n3] < n10) {
                ++n5;
                continue;
            }
            if (nArray2[nArray[n5] + n3] == n10) {
                n4 = nArray[n5];
                nArray[n5] = nArray[n11 + n13];
                nArray[n11 + n13] = n4;
                ++n13;
                continue;
            }
            n4 = nArray[n5];
            nArray[n5] = nArray[n12 + n14];
            nArray[n12 + n14] = n4;
            ++n14;
        }
        while (n11 + n13 < n12) {
            if (nArray2[nArray[n11 + n13] + n3] == n10) {
                ++n13;
                continue;
            }
            n4 = nArray[n11 + n13];
            nArray[n11 + n13] = nArray[n12 + n14];
            nArray[n12 + n14] = n4;
            ++n14;
        }
        if (n11 > n) {
            this.split(nArray, nArray2, n, n11 - n, n3);
        }
        for (n5 = 0; n5 < n12 - n11; ++n5) {
            nArray2[nArray[n11 + n5]] = n12 - 1;
        }
        if (n11 == n12 - 1) {
            nArray[n11] = -1;
        }
        if (n + n2 > n12) {
            this.split(nArray, nArray2, n12, n + n2 - n12, n3);
        }
    }

    private void qsufsort(int[] nArray, int[] nArray2, byte[] byArray) {
        int n;
        int n2 = byArray.length;
        int[] nArray3 = new int[256];
        for (n = 0; n < 256; ++n) {
            nArray3[n] = 0;
        }
        for (n = 0; n < n2; ++n) {
            int n3 = byArray[n] & 0xFF;
            nArray3[n3] = nArray3[n3] + 1;
        }
        for (n = 1; n < 256; ++n) {
            int n4 = n;
            nArray3[n4] = nArray3[n4] + nArray3[n - 1];
        }
        for (n = 255; n > 0; --n) {
            nArray3[n] = nArray3[n - 1];
        }
        nArray3[0] = 0;
        n = 0;
        while (n < n2) {
            int n5 = byArray[n] & 0xFF;
            int n6 = nArray3[n5] + 1;
            nArray3[n5] = n6;
            nArray[n6] = n++;
        }
        nArray[0] = n2;
        for (n = 0; n < n2; ++n) {
            nArray2[n] = nArray3[byArray[n] & 0xFF];
        }
        nArray2[n2] = 0;
        for (n = 1; n < 256; ++n) {
            if (nArray3[n] != nArray3[n - 1] + 1) continue;
            nArray[nArray3[n]] = -1;
        }
        nArray[0] = -1;
        int n7 = 1;
        while (nArray[0] != -(n2 + 1)) {
            int n8 = 0;
            n = 0;
            while (n < n2 + 1) {
                if (nArray[n] < 0) {
                    n8 -= nArray[n];
                    n -= nArray[n];
                    continue;
                }
                if (n8 != 0) {
                    nArray[n - n8] = -n8;
                }
                n8 = nArray2[nArray[n]] + 1 - n;
                this.split(nArray, nArray2, n, n8, n7);
                n += n8;
                n8 = 0;
            }
            if (n8 != 0) {
                nArray[n - n8] = -n8;
            }
            n7 += n7;
        }
        for (n = 0; n < n2 + 1; ++n) {
            nArray[nArray2[n]] = n;
        }
    }

    private final int matchlen(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3;
        int n4 = JBDiff.min(byArray.length - n, byArray2.length - n2);
        for (n3 = 0; n3 < n4 && byArray[n + n3] == byArray2[n2 + n3]; ++n3) {
        }
        return n3;
    }

    private final int search(int[] nArray, byte[] byArray, byte[] byArray2, int n, int n2, int n3, IntByRef intByRef) {
        if (n3 - n2 < 2) {
            int n4;
            int n5 = this.matchlen(byArray, nArray[n2], byArray2, n);
            if (n5 > (n4 = this.matchlen(byArray, nArray[n3], byArray2, n))) {
                intByRef.value = nArray[n2];
                return n5;
            }
            intByRef.value = nArray[n3];
            return n4;
        }
        int n6 = n2 + (n3 - n2) / 2;
        if (Util.memcmp(byArray, nArray[n6], byArray2, n) < 0) {
            return this.search(nArray, byArray, byArray2, n, n6, n3, intByRef);
        }
        return this.search(nArray, byArray, byArray2, n, n2, n6, intByRef);
    }

    public void bsdiff(File file, File file2, File file3) throws IOException {
        this.msg.msgln(2, 0, "Creating rcp-bsdiff \"" + file3.getPath() + "\" from \"" + file.getPath() + "\" to \"" + file2.getPath() + "\"...");
        this.msg.addIndent(1);
        int n = (int)file.length();
        byte[] byArray = new byte[n];
        FileInputStream fileInputStream = new FileInputStream(file);
        Util.readFromStream(fileInputStream, byArray, 0, n);
        fileInputStream.close();
        int[] nArray = new int[n + 1];
        int[] nArray2 = new int[n + 1];
        this.qsufsort(nArray, nArray2, byArray);
        nArray2 = null;
        System.gc();
        int n2 = (int)file2.length();
        byte[] byArray2 = new byte[n2];
        fileInputStream = new FileInputStream(file2);
        Util.readFromStream(fileInputStream, byArray2, 0, n2);
        fileInputStream.close();
        RandomAccessFileOutputStream randomAccessFileOutputStream = new RandomAccessFileOutputStream(file3, "rw");
        this.bsdiff(byArray, byArray2, new RandomAccessFileOutputStream(file3, "rw"), nArray);
        randomAccessFileOutputStream.close();
        this.msg.addIndent(-1);
        this.msg.msgln(2, 0, "rcp-bsdiff success!! diff file size=" + file3.length());
    }

    public void bsdiff(InputStream inputStream, int n, InputStream inputStream2, int n2, File file) throws IOException {
        this.bsdiff(inputStream, n, inputStream2, n2, new RandomAccessFileOutputStream(file, "rw"));
    }

    public void bsdiff(InputStream inputStream, int n, InputStream inputStream2, int n2, OutputStream outputStream) throws IOException {
        int n3;
        int n4 = n;
        if (n2 > n4) {
            n4 = n2;
        }
        if (n4 > 4096 && (n4 /= 100) < 4096) {
            n4 = 4096;
        }
        ByteArrayFileOutputStream byteArrayFileOutputStream = new ByteArrayFileOutputStream(n4);
        this.bsdiff(inputStream, n, inputStream2, n2, byteArrayFileOutputStream);
        ByteArrayFileInputStream byteArrayFileInputStream = new ByteArrayFileInputStream(byteArrayFileOutputStream.getByteArrayFile());
        byte[] byArray = new byte[16384];
        while ((n3 = byteArrayFileInputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n3);
        }
    }

    public void bsdiff(InputStream inputStream, int n, InputStream inputStream2, int n2, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        byte[] byArray = new byte[n];
        Util.readFromStream(inputStream, byArray, 0, n);
        inputStream.close();
        int[] nArray = new int[n + 1];
        int[] nArray2 = new int[n + 1];
        this.msg.msgln(3, 0, "qsuf sort...");
        this.qsufsort(nArray, nArray2, byArray);
        nArray2 = null;
        System.gc();
        byte[] byArray2 = new byte[n2];
        Util.readFromStream(inputStream2, byArray2, 0, n2);
        inputStream2.close();
        this.bsdiff(byArray, byArray2, randomAccessOutputStream, nArray);
    }

    public void bsdiff(byte[] byArray, byte[] byArray2, OutputStream outputStream) throws IOException {
        int n = byArray.length;
        if (byArray2.length > n) {
            n = byArray2.length;
        }
        if (n > 4096 && (n /= 100) < 4096) {
            n = 4096;
        }
        ByteArrayFileOutputStream byteArrayFileOutputStream = new ByteArrayFileOutputStream(n);
        this.bsdiff(byArray, byArray2, byteArrayFileOutputStream);
        byteArrayFileOutputStream.getByteArrayFile().seek(0);
        Util.copyStream(new ByteArrayFileInputStream(byteArrayFileOutputStream.getByteArrayFile()), outputStream);
    }

    public void bsdiff(byte[] byArray, byte[] byArray2, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        int[] nArray = new int[byArray.length + 1];
        int[] nArray2 = new int[byArray.length + 1];
        this.msg.msgln(3, 0, "qsuf sort...");
        this.qsufsort(nArray, nArray2, byArray);
        nArray2 = null;
        System.gc();
        this.bsdiff(byArray, byArray2, randomAccessOutputStream, nArray);
    }

    protected void bsdiff(byte[] byArray, byte[] byArray2, RandomAccessOutputStream randomAccessOutputStream, int[] nArray) throws IOException {
        int n;
        DataOutputStream dataOutputStream;
        int n2 = byArray.length;
        if (nArray == null) {
            nArray = new int[n2 + 1];
            int[] nArray2 = new int[n2 + 1];
            this.msg.msgln(3, 0, "qsuf sort...");
            this.qsufsort(nArray, nArray2, byArray);
            nArray2 = null;
            System.gc();
        }
        int n3 = byArray2.length;
        int n4 = 0;
        ByteArrayFileOutputStream byteArrayFileOutputStream = new ByteArrayFileOutputStream();
        int n5 = 0;
        ByteArrayFileOutputStream byteArrayFileOutputStream2 = new ByteArrayFileOutputStream();
        DataOutputStream dataOutputStream2 = dataOutputStream = new DataOutputStream(randomAccessOutputStream);
        dataOutputStream.write("rcpdif01".getBytes("US-ASCII"));
        dataOutputStream.writeLong(-1L);
        dataOutputStream.writeLong(-1L);
        dataOutputStream.writeLong(n3);
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(dataOutputStream2);
        dataOutputStream = new DataOutputStream(gZIPOutputStream);
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        IntByRef intByRef = new IntByRef();
        int n11 = 0;
        byte[] byArray3 = new byte[16384];
        this.msg.msgln(3, 0, "scan search...");
        this.msg.addIndent(1);
        while (n6 < n3) {
            int n12;
            int n13 = 0;
            int n14 = n6 += n7;
            while (n6 < n3) {
                n7 = this.search(nArray, byArray, byArray2, n6, 0, n2, intByRef);
                while (n14 < n6 + n7) {
                    if (n14 + n10 < n2 && byArray[n14 + n10] == byArray2[n14]) {
                        ++n13;
                    }
                    ++n14;
                }
                if (n7 == n13 && n7 != 0 || n7 > n13 + 8) break;
                if (n6 + n10 < n2 && byArray[n6 + n10] == byArray2[n6]) {
                    --n13;
                }
                ++n6;
            }
            if (n7 == n13 && n6 != n3) continue;
            n = 0;
            int n15 = 0;
            int n16 = 0;
            int n17 = 0;
            while (n8 + n17 < n6 && n9 + n17 < n2) {
                if (byArray[n9 + n17] == byArray2[n8 + n17]) {
                    ++n;
                }
                if (n * 2 - ++n17 <= n15 * 2 - n16) continue;
                n15 = n;
                n16 = n17;
            }
            int n18 = 0;
            if (n6 < n3) {
                n = 0;
                n12 = 0;
                for (n17 = 1; n6 >= n8 + n17 && intByRef.value >= n17; ++n17) {
                    if (byArray[intByRef.value - n17] == byArray2[n6 - n17]) {
                        ++n;
                    }
                    if (n * 2 - n17 <= n12 * 2 - n18) continue;
                    n12 = n;
                    n18 = n17;
                }
            }
            if (n8 + n16 > n6 - n18) {
                int n19 = n8 + n16 - (n6 - n18);
                n = 0;
                int n20 = 0;
                int n21 = 0;
                for (n17 = 0; n17 < n19; ++n17) {
                    if (byArray2[n8 + n16 - n19 + n17] == byArray[n9 + n16 - n19 + n17]) {
                        ++n;
                    }
                    if (byArray2[n6 - n18 + n17] == byArray[intByRef.value - n18 + n17]) {
                        --n;
                    }
                    if (n <= n20) continue;
                    n20 = n;
                    n21 = n17 + 1;
                }
                n16 += n21 - n19;
                n18 -= n21;
            }
            n12 = 0;
            while (n12 < n16) {
                int n22 = byArray3.length;
                if (n22 > n16 - n12) {
                    n22 = n16 - n12;
                }
                for (n17 = 0; n17 < n22; ++n17) {
                    byArray3[n17] = (byte)(byArray2[n8 + n12] - byArray[n9 + n12]);
                    ++n12;
                }
                byteArrayFileOutputStream.write(byArray3, 0, n22);
            }
            byteArrayFileOutputStream2.write(byArray2, n8 + n16, n6 - n18 - (n8 + n16));
            n4 += n16;
            n5 += n6 - n18 - (n8 + n16);
            dataOutputStream.writeInt(n16);
            dataOutputStream.writeInt(n6 - n18 - (n8 + n16));
            dataOutputStream.writeInt(intByRef.value - n18 - (n9 + n16));
            n11 += 12;
            this.msg.msgln(5, 0, "created ctrlBlock: diffLen=" + n16 + ", ebLen=" + (n6 - n18 - (n8 + n16)));
            n8 = n6 - n18;
            n9 = intByRef.value - n18;
            n10 = intByRef.value - n6;
        }
        this.msg.addIndent(-1);
        gZIPOutputStream.finish();
        n11 = dataOutputStream2.size() - 32;
        dataOutputStream = null;
        this.msg.msgln(4, 0, "wrote ctrlBlock, size=" + n11);
        gZIPOutputStream = new GZIPOutputStream(dataOutputStream2);
        byteArrayFileOutputStream.seek(0L);
        Util.copyStream(new ByteArrayFileInputStream(byteArrayFileOutputStream.getByteArrayFile()), gZIPOutputStream);
        gZIPOutputStream.finish();
        n = dataOutputStream2.size() - n11 - 32;
        this.msg.msgln(4, 0, "wrote diffBlock, size=" + n);
        gZIPOutputStream = new GZIPOutputStream(dataOutputStream2);
        byteArrayFileOutputStream2.seek(0L);
        Util.copyStream(new ByteArrayFileInputStream(byteArrayFileOutputStream2.getByteArrayFile()), gZIPOutputStream);
        gZIPOutputStream.finish();
        long l = dataOutputStream2.size() - n - n11 - 32;
        this.msg.msgln(4, 0, "wrote ebBlock, size=" + l);
        randomAccessOutputStream.seek(8L);
        dataOutputStream2.writeLong(n11);
        dataOutputStream2.writeLong(n);
        dataOutputStream2.flush();
    }

    public static void main(String[] stringArray) throws IOException {
        DiffArgs diffArgs = Util.getArgs(stringArray, TreeFileDiff.class.getName(), null);
        if (diffArgs == null) {
            return;
        }
        JBDiff jBDiff = DiffFactory.getDiffFactory().getJBDiff(new DiffMessage(diffArgs.out, diffArgs.err, diffArgs.verboseLevel, 0));
        try {
            jBDiff.bsdiff(diffArgs.src.get(0), diffArgs.dst, diffArgs.diffArchive);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(diffArgs.err);
        }
    }

    private static class IntByRef {
        public int value;

        private IntByRef() {
        }
    }
}

