/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rcp.diff.internal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class DiffMessage {
    public static final int L_NONE = -1;
    public static final int L0 = 0;
    public static final int L1 = 1;
    public static final int L2 = 2;
    public static final int L3 = 3;
    public static final int L4 = 4;
    public static final int L5 = 5;
    protected PrintStream errOut = System.err;
    protected PrintStream msgOut = System.out;
    protected int msgIndentLevel = 0;
    protected int msgLevel = 1;

    public DiffMessage() {
    }

    public DiffMessage(PrintStream printStream, PrintStream printStream2, int n, int n2) {
        this.msgOut = printStream;
        this.errOut = printStream2;
        this.msgLevel = n;
        this.msgIndentLevel = n2;
    }

    private String getPad(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n + this.msgIndentLevel; ++i) {
            stringBuilder.append("  ");
        }
        return stringBuilder.toString();
    }

    public void setErrOut(PrintStream printStream) {
        this.errOut = printStream;
    }

    public void setMsgOut(PrintStream printStream) {
        this.msgOut = printStream;
    }

    public void addIndent(int n) {
        this.msgIndentLevel += n;
        if (this.msgIndentLevel < 0) {
            this.msgIndentLevel = 0;
        }
    }

    public void setMaxLevel(int n) {
        this.msgLevel = n;
    }

    public void msg(int n, int n2, String string) {
        if (n > this.msgLevel) {
            return;
        }
        this.msgOut.print(this.getPad(n2));
        this.msgOut.print(string);
    }

    public void msgln(int n, int n2, String string) {
        if (n > this.msgLevel) {
            return;
        }
        this.msgOut.print(this.getPad(n2));
        this.msgOut.println(string);
    }

    public void err(int n, String string) {
        this.errOut.print(this.getPad(n));
        this.errOut.print(string);
    }

    public void errln(int n, String string) {
        this.errOut.print(this.getPad(n));
        this.errOut.println(string);
    }

    public PrintStream getMsgOut() {
        return this.msgOut;
    }

    public PrintStream getErrOut() {
        return this.errOut;
    }

    public void errln(int n, Exception exception) {
        if (this.msgIndentLevel == 0) {
            exception.printStackTrace(this.errOut);
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        exception.printStackTrace(printStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
        String string = this.getPad(n);
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                this.errOut.print(string);
                this.errOut.println(string2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

