# /unix/nui/installer/tools/lib/installIA.pl
#
# Used for Domino 11 hotfixes
# Used for Domino 12 hotfixes
#
## Copyright (c) 2023, HCL Development Corporation.
## All Rights Reserved.
 
 
# must be running with perl 5.0 or greater
#
require 5.000;
 
 
# Load the CdPath package, used for Require-ing other perl files,
# and to translate misc filenames to a form accesible on the cd.
# @INC is already set appropriately here.
# So that this multiple eval junk here does not need to be repeated in 
# every perl file that requires another, member functions are to be 
# explicity called via CdPath::
# 
eval 'require "CdPath.pl";';
eval 'require "CDPATH.PL";';
eval 'require "CDPATH.PL;1";';
eval 'require "cdpath.pl";';
CdPath::CdPathSetRoot($ENV{NUI_DISTROOT});


# !!! testing non-dependency on package main
package DingDong;


# simply ignore certain signals
#
$SIG{'INT'} = $SIG{'QUIT'} = $SIG{'TERM'} = 'IGNORE';


CdPath::Require("install.nls");	import install_nls;
CdPath::Require("SysCmd.pl");
#CdPath::Require("CDFFile.pm");	import CDFFile;
CdPath::Require("UIF.pm");		import UIF;
CdPath::Require("NIC.pm");		import NIC;
CdPath::Require("CfgData.pm");  import CfgData;
CdPath::Require("PerlUtil.pl"); import PerlUtil;


# setup & check system commands before anything else
#
#  !!! check all are necessary
@reqcmds = qw(
    mv rm mkdir env stty uname date touch tar chown
    chgrp cat chmod sh pwd
);
if ( $ENV{'NUI_ARCH'} ne "os390") {
    push @reqcmds, qw( hostname clear );
}
if ( ! SysCmd::InitCmds(\@reqcmds, \@cmdsnotfound, \$errmsg, $ENV{'NUI_ARCH'})) {
    Out($txt{2} . $errmsg);
    exit 1;
}


# do usage checking and see if we simply need to handoff to the backend
if ($#ARGV >= 0) {
	if ($ARGV[0] eq "-script" && $#ARGV == 1) {
		local($cmd, $status, $scrfile, $tmp);
		$scrfile = $ARGV[1];
		if ( $ENV{NUI_ARCH} == "linux") {
		    $ENV{LP_REPLACE} = 1;
		}
		# make the scrfile arg absolute; the wrapper has left us
		# in the original user dir
		# !!!
		if ( ! ($scrfile =~ /^\//)) {
			$tmp = `$Sys::pwd`;
			chomp($tmp);
			$scrfile = $tmp . "/" . $scrfile;
		}

		$cmd = CdPath::CdPathShellString("tools/lib/InstBE.pl");
		$cmd = "$ENV{'PERL'} $cmd $scrfile";
		$status = system($cmd);
		exit($status/256);
	} else {
		FatalUsage();
	}
}



#
# do the UI
#

# Create the context to be used by the UI screens.
# This context is meaningful only to the individual screens, not
# to the UI framework.
# This context should not be confused with the install context 
# in InstBE.pl.  This is the UI context, from which will be generated
# the scriptfile to be passed to the backend, from which one or more
# install context's will be derived.
# Remember that the install context is entirely  opaque
# to the back-end mechanism, with thanks to the
# UIC which will create the backend scriptfile, and the 
# NIC which will interpret it.
#
# load the component definition file 
#
local($cdffile) = CdPath::CdPath("sets/data/comp.cfg");
local($cdf) = new CfgData ();
if ( ! $cdf->InitFromFile($cdffile)) {
    Out("$txt{3} " . $cdf->GetErrorMessage());
    Exit(1);
}
#
# create the NIC obj to be placed in the opaque ctx
#
local($nic) = new NIC($cdf);
# create the initial ctx
local($ctx) ={
	nic	=>	$nic
};
#
# load the nui cfg file, in order to tell UIF what UIC to use
#
local($nuicfgfile,$nuicfg,$nuicfgdat);
if (!defined $ENV{NUI_CFGFILE}){
     Out("$txt{5}");
    Exit(1);   
}
$nuicfgfile = CdPath::CdPath("sets/data/nui.cfg");
$nuicfg = new CfgData ();
if ( ! $nuicfg->InitFromFile($nuicfgfile)) {
    Out("$txt{4} " . $nuicfg->GetErrorMessage());
    Exit(1);
}
$nuicfgdat = $nuicfg->GetData();
undef $nuicfg;
#
# create the UIF (user interface framework) obj
#
$ctx->{rev}     = $nuicfgdat->{rev};
$ctx->{baserev} = $nuicfgdat->{baserev};
$ctx->{nuicfg} = $nuicfgdat;
if ( $ENV{NUI_ARCH} == "linux") {
    $ENV{LP_REPLACE} = 1;
}

#$ctx->{nsdfix} = $nuicfgdat->{nsdfix} ;
local($uif) = new UIF ($ctx, $nuicfgdat->{UIC});
if ( ! $uif) {
	# this would happen if initial term checks failed
	# appropriate error messages already displayed
	Exit(1);
}


#
# the UI does all the real work, since it knows about the product,
# and this is a one-shot deal
#
$uif->DoIt();
Exit(0);


#
######################################################################
# functions
#

sub FatalUsage {
	
	print($txt{1});
	exit 1;
}


sub Out {
	# this here for logging (?)
    print @_;
}
 
 
sub Exit {
    local($stat) = @_;
 
    exit $stat;
}



